(function ($) {
    $.fn.validationEngineLanguage = function () {
    };
    $.validationEngineLanguage = {
        newLang: function () {
            $.validationEngineLanguage.allRules = {
                "required": { // Add your regex rules here, you can take telephone as an example
                    "regex": "none",
                    "alertText": "* هذا الحقل مطلوب",
                    "alertTextCheckboxMultiple": "* برجاء إختيار إحدى الخيارات",
                    "alertTextCheckboxe": "* هذا المربع الإختياري مطلوب",
                    "alertTextDateRange": "* كلا حقلين نطاق التاريخ مطلوبة"
                },
                "requiredInFunction": {
                    "func": function (field, rules, i, options) {
                        return (field.val() == "test") ? true : false;
                    },
                    "alertText": "* الحقل يجب أن يساوى test"
                },
                "zipcode":
                {
                    "regex": /^[0-9a-zA-Z\ \-\+]+$/,
                    "alertText": "* يسمح فقط بالأرقام والأحرف " - +""
                },
                "dateRange": {
                    "regex": "none",
                    "alertText": "* غير صالح ",
                    "alertText2": "نطاق التاريخ"
                },
                "dateTimeRange": {
                    "regex": "none",
                    "alertText": "* غير صالح ",
                    "alertText2": "نطاق التاريخ والوقت"
                },
                "minSize": {
                    "regex": "none",
                    "alertText": "* على الأقل ",
                    "alertText2": " حروف مطلوبة"
                },
                "maxSize": {
                    "regex": "none",
                    "alertText": "* على الأكثر ",
                    "alertText2": " حروف مسموحة"
                },
                "groupRequired": {
                    "regex": "none",
                    "alertText": "* يجب عليك ملئ إحدى الحقول التالية",
                    "alertTextCheckboxMultiple": "* برجاء إختيار إحدى الخيارات",
                    "alertTextCheckboxe": "* هذا المربع الإختياري مطلوب"
                },
                "min": {
                    "regex": "none",
                    "alertText": "* الحد الأدنى للقيمة هو "
                },
                "max": {
                    "regex": "none",
                    "alertText": "* الحد الأقصى للقيمة هو "
                },
                "past": {
                    "regex": "none",
                    "alertText": "* التاريخ قبل "
                },
                "future": {
                    "regex": "none",
                    "alertText": "* التاريخ بعد "
                },
                "maxCheckbox": {
                    "regex": "none",
                    "alertText": "* على الأكثر ",
                    "alertText2": " خيارات مسموحة"
                },
                "minCheckbox": {
                    "regex": "none",
                    "alertText": "* برجاء إختيار ",
                    "alertText2": " خيارات"
                },
                "equals": {
                    "regex": "none",
                    "alertText": "* الحقول غير متساوية"
                },
                "creditCard": {
                    "regex": "none",
                    "alertText": "* رقم بطاقة الإتمان غير صالح"
                },
                "phone": {
                    // credit: jquery.h5validate.js / orefalo
                    "regex": /^([\+][0-9]{1,3}([ \.\-])?)?([\(][0-9]{1,6}[\)])?([0-9 \.\-]{1,32})(([A-Za-z \:]{1,11})?[0-9]{1,4}?)$/,
                    "alertText": "* رقم الهاتف غير صالح"
                },
                "email": {
                    // HTML5 compatible email regex ( http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#    e-mail-state-%28type=email%29 )
                    "regex": /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\-0-9]+\.)+[a-zA-Z\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF]{2,}))$/,
                    "alertText": "* عنوان بريد إلكتروني غير صالح"
                },
                "fullname": {
                    "regex": /^([a-zA-Z]+[\'\,\.\-]?[a-zA-Z ]*)+[ ]([a-zA-Z]+[\'\,\.\-]?[a-zA-Z ]+)+$/,
                    "alertText": "* يجب أن يكون الإسم الأول والأخير"
                },
                "zip": {
                    "regex": /^\d{5}$|^\d{5}-\d{4}$/,
                    "alertText": "* صيغة الرمز البريدي غير صالحة"
                },
                "integer": {
                    "regex": /^[\-\+]?\d+$/,
                    "alertText": "* هذا ليس عدد صحيح صالح"
                },
                "number": {
                    // Number, including positive, negative, and floating decimal. credit: orefalo
                    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,
                    "alertText": "* عدد عشري غير صالح"
                },
                "date": {
                    //	Check if date is valid by leap year
                    "func": function (field) {
                        var pattern = new RegExp(/^(\d{4})[\/\-\.](0?[1-9]|1[012])[\/\-\.](0?[1-9]|[12][0-9]|3[01])$/);
                        var match = pattern.exec(field.val());
                        if (match == null)
                            return false;

                        var year = match[1];
                        var month = match[2] * 1;
                        var day = match[3] * 1;
                        var date = new Date(year, month - 1, day); // because months starts from 0.

                        return (date.getFullYear() == year && date.getMonth() == (month - 1) && date.getDate() == day);
                    },
                    "alertText": "* تاريخ غير صالح، يجب أن يكون في هيئة YYYY-MM-DD"
                },
                "ipv4": {
                    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,
                    "alertText": "* عنوان IP غير صالح"
                },
                "ip": {
                    "regex": /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))/,
                    "alertText": "* عنوان IP غير صالح"
                },
                "url": {
                    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,
                    "alertText": "* عنوان إلكتروني غير صالح"
                },
                "onlyNumberSp": {
                    "regex": /^[0-9\ ]+$/,


                    "alertText": "* أرقام فقط"
                },
                "onlyLetterSp": {
                    "regex": /^[a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ \']+$/,
                    "alertText": "* حروف فقط"
                },
                "onlyLetterAccentSp": {
                    "regex": /^[a-z\\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ ]+$/i,
                    "alertText": "* حروف فقط (مسموح بالنبرات)"
                },
                "onlyLetterNumber": {
                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ ]+$/,
                    "alertText": "* غير مسموح بحروف خاصة"
                },

                //Start Custom Validation
                //1)First Name,Last Name
                "onlyLetter_specialcharacter":

                {
                    "regex": /^([^\x00-\x80]|[a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ \_\,\`\.\'\^\-])+$/,
                    //(allow Latin word or Croatian latters)"regex": /^([^\u0600-\u06FF]|[a-zA-Z\ \_\,\`\.\'\^\-])+$/,                     
                    "alertText": "* فقط الحروف و '_ ، `.' ^ - 'الأحرف المسموح بها"
                },
                //2)City,State,Country
                "city_state_country_validation":
                {
                    "regex": /^([^\x00-\x80]|[a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ \_\,\`\.\'\^\-\&])+$/,
                    "alertText": "* فقط الحروف و '_ ، `.' ^ - & 'الأحرف المسموح بها"
                },
                //3)PopUp Category,Medicine Name,Event Name
                "popup_category_validation":
                {
                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ \_\,\`\.\'\^\-\-\&\+\n!\"\%\(\)\*\/\:\=\?\@\[\]\{\|\}\~]+$/,
                    "alertText": "* فقط الأحرف ، أرقام الأحرف المسموح بها و '$ # <>؛' الشخصيات غير مسموح بها"
                },
                //4)Address and Description
                "address_description_validation":
                {
                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ \?\_\,\`\.\'\^\-\&\+\n!\"\%\(\)\*\/\:\=\?\@\[\]\{\|\}\~]+$/,
                    "alertText": "* فقط الأحرف ، أرقام الأحرف المسموح بها و '$ # <>؛' الشخصيات غير مسموح بها"
                },
                "vailidation_with_question_mark":
                {
                    "regex": /^[0-9a-zA-Z\ \?\_\,\`\.\:\[\]\'\^\-\&\n]+$/,
                    "alertText": "*  فقط الأحرف ، أرقام الأحرف المسموح بها و ' _,`.'^-&?' الشخصيات غير مسموح بها"
                },
                "description_validation":
                {
                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\ \_\!\@\(\)\,\`\.\'\^\-\&\+\n!\"\%\(\)\*\/\:\=\?\@\[\]\{\|\}\~]+$/,
                    "alertText": "* يُسمح فقط بالحروف والأرقام و' _,`.'^-&'@!() الأحرف"
                },
                //5)UserName
                "username_validation":
                {
                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\u0600-\u06FF\u0750-\u077F\uFB50-\uFDFF\uFE70-\uFEFF\_\.\-\@]+$/,
                    "alertText": "* فقط الحروف والأرقام والأحرف _.- @ مسموح بها"
                },
                //6)Phone Number
                "phone_number":
                {
                    "regex": /^[0-9\ \-\+]+$/,
                    "alertText": "* فقط أرقام و + مسموح بها"
                },

                // --- CUSTOM RULES -- Those are specific to the demos, they can be removed or changed to your likings
                "ajaxUserCall": {
                    "url": "ajaxValidateFieldUser",
                    // you may want to pass extra data on the ajax call
                    "extraData": "name=eric",
                    "alertText": "* هذا المستخدم بالفعل موجود",
                    "alertTextLoad": "* جاري التحقق، برجاء الإنتظار"
                },
                "ajaxUserCallPhp": {
                    "url": "phpajax/ajaxValidateFieldUser.php",
                    // you may want to pass extra data on the ajax call
                    "extraData": "name=eric",
                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
                    "alertTextOk": "* إسم المستخدم هذا متاح",
                    "alertText": "* هذا المستخدم بالفعل موجود",
                    "alertTextLoad": "* جاري التحقق، برجاء الإنتظار"
                },
                "ajaxNameCall": {
                    // remote json service location
                    "url": "ajaxValidateFieldName",
                    // error
                    "alertText": "* هذا الإسم موجود بالفعل",
                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
                    "alertTextOk": "* هذا الإسم متاح",
                    // speaks by itself
                    "alertTextLoad": "* جاري التحقق، برجاء الإنتظار"
                },
                "ajaxNameCallPhp": {
                    // remote json service location
                    "url": "phpajax/ajaxValidateFieldName.php",
                    // error
                    "alertText": "* هذا الإسم موجود بالفعل",
                    // speaks by itself
                    "alertTextLoad": "* جاري التحقق، برجاء الإنتظار"
                },
                "validate2fields": {
                    "alertText": "* برجاء إدخال HELLO"
                },
                //tls warning:homegrown not fielded 
                "dateFormat": {
                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,
                    "alertText": "* تاريخ غير صالح"
                },
                //tls warning:homegrown not fielded 
                "dateTimeFormat": {
                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,
                    "alertText": "* التاريخ أو هيئة التاريخ غير صالحة",
                    "alertText2": "الهيئة المتوقعة: ",
                    "alertText3": "mm/dd/yyyy hh:mm:ss AM|PM أو ",
                    "alertText4": "yyyy-mm-dd hh:mm:ss AM|PM"
                }
            };

        }
    };

    $.validationEngineLanguage.newLang();

})(jQuery);