<?php
/*
Plugin Name: School Management System
Plugin URI: https://mojoomla.com/
Description: Streamline your school's operations with the **School Management System Plugin for WordPress**. From student enrollment and attendance to schedules, assignments, exams, and fees – this all-in-one plugin simplifies school management. Enhance communication between staff, students, and parents, ensuring smooth and efficient operations.
Version: 93.1.0 (16-07-2025)
Author: Mojoomla
Author URI: https://codecanyon.net/search/mojoomla
Text Domain: school-mgt
Domain Path: /languages
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright 2015 Mojoomla (email: sales@mojoomla.com)
*/
define( 'SMS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'SMS_PLUGIN_DIR', untrailingslashit( dirname( __FILE__ ) ) );
define( 'SMS_PLUGIN_URL', untrailingslashit( plugins_url( '', __FILE__ ) ) );
define( 'SMS_CONTENT_URL',  content_url() );
require_once SMS_PLUGIN_DIR . '/settings.php';


// Load specific pages based on request
if (isset($_REQUEST['page'])) {
    if ($_REQUEST['page'] == 'callback') {
        require_once SMS_PLUGIN_DIR . '/callback.php';
    }
    if ($_REQUEST['page'] == 'notify') {
        require_once SMS_PLUGIN_DIR . '/notify.php';
    }
}

// Add custom links to the plugin details page for better user engagement
function sms_custom_plugin_links($links) {
    $addons_link = admin_url() . 'admin.php?page=smgt_system_addon';
    $plugin_links = [
        '<a href="https://mojoomlasoftware.github.io/wp-school-documentation/" target="_blank">Documentation</a>',
        '<a href="https://youtu.be/34177nQsofw?si=idiHXGkywESeHLeS" target="_blank">Video Guide</a>',
        '<a href="https://mojoomla.com/contact/" target="_blank">Community Support</a>',
        '<a href="'.$addons_link.'" target="_blank">Addons</a>',
    ];

    return array_merge($links, $plugin_links);
}
add_filter('plugin_action_links_' . SMS_PLUGIN_BASENAME, 'sms_custom_plugin_links');

// Add custom metadata links to the plugin row for better visibility
function sms_custom_plugin_row_meta($links, $file) {
    $addons_link = admin_url() . 'admin.php?page=smgt_system_addon';
    if ($file == SMS_PLUGIN_BASENAME) {
        $custom_links = [
            '<a href="https://mojoomlasoftware.github.io/wp-school-documentation/" target="_blank">Documentation</a>',
            '<a href="https://youtu.be/34177nQsofw?si=idiHXGkywESeHLeS" target="_blank">Video Guide</a>',
            '<a href="https://mojoomla.com/contact/" target="_blank">Community Support</a>',
            '<a href="'.$addons_link.'" target="_blank">Addons</a>',
        ];
        $links = array_merge($links, $custom_links);
    }
    return $links;
}
add_filter('plugin_row_meta', 'sms_custom_plugin_row_meta', 10, 2);
?>
