<?php
add_action('wp_ajax_nopriv_mj_smgt_view_video',  'mj_smgt_view_video');
add_action('wp_ajax_mj_smgt_view_video',  'mj_smgt_view_video');
function mj_smgt_view_video()
{
	$link = $_REQUEST['link'];
	$title = sanitize_text_field($_REQUEST['title']);
?>
	<script>
		function stopVideo() {
			var iframe = document.querySelector('.video-frame-class'); // Select iframe by class
			if (iframe) {
				var currentSrc = iframe.src;
				iframe.src = ''; // Temporarily remove the src
				setTimeout(function() {
					iframe.src = currentSrc; // Reset the src
				}, 100);
			}
		}
	</script>
	<div class="modal-header model_header_padding dashboard_model_header">
		<a href="javascript:void(0);" id="close-popup" onclick="stopVideo()" class="event_close-btn badge badge-success pull-right dashboard_pop-up_design">
			<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt="">
		</a>
		<h4 id="myLargeModalLabel" class="modal-title"><?php echo $title; ?></h4>
	</div>
	<div class="border_panel_body gmgt_pop_heder_p_20 exercise_detail_popup">
		<div class="row">
			<div class="col-sm-12 col-md-12 col-xl-12 col-xs-12 mb-3">
				<?php
				echo '<iframe id="video-frame" class="video_width_height video-frame-class" src="' . $link . '" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
				?>
			</div>
		</div>
	</div>
	<?php
	die;
}
// MAIL CONTEMNT WITH TEMPLATE DESIGN
function mj_smgt_get_mail_content_with_template_design($message)
{
	$logo = get_option('smgt_system_logo');
	$system_color = get_option('smgt_system_color_code');
	$email_template = '
	<html>
		<body>
			<div bgcolor="#ffffff" style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;height:100%;width:100%!important;background-color:#ffffff">
				<div style="background-color: aliceblue !important;font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;margin:0 auto;max-width:525px">
					<table style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;float: left;width: 100%;">
					<tbody>
						<tr style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;background:' . $system_color . ';">
							<td style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;text-align:center ; padding-top: 12px;">
								<p style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif">
									<img alt="WP-GYM" src="' . $logo . '" style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;max-width: 50%;" class="CToWUd">
								</p>
							</td>
						</tr>
					</tbody>
					</table>
					<table style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;float:left;width:100%;background-color:aliceblue;">
						<tbody>
							<tr style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif">
								<td style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;color:#333333;padding-top:15px !important;padding: 0px 20px;">
									<p>
										<pre style="white-space: pre-wrap;word-wrap: break-word; overflow-wrap: break-word; max-width: 100%;">' . $message . '</pre>
									</p>
								</td>
							</tr>
							<tr style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;background:' . $system_color . ';">
								<td style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;color:#ffffff;">
									<p style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;font-size:12px;text-align:center;margin-top:10px">
									' . get_option('smgt_footer_description') . '
									</p>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</body>
	</html>';
	return $email_template;
}
add_action('wp_ajax_mj_smgt_load_subject_class_id_and_section_id',  'mj_smgt_load_subject_class_id_and_section_id');
function mj_smgt_load_subject_class_id_and_section_id()
{
	$class_id = sanitize_text_field($_POST['class_id']);
	$section_id = sanitize_text_field($_POST['section_id']);
	global $wpdb;
	$table_name = $wpdb->prefix . "subject";
	$table_name2 = $wpdb->prefix . "teacher_subject";
	$user_id = get_current_user_id();

	//------------------------TEACHER ACCESS---------------------------------//
	$teacher_access = get_option('smgt_access_right_teacher');
	$teacher_access_data = $teacher_access['teacher'];
	$data = [];
	foreach ($teacher_access_data as $key => $value) {
		if ($key == 'subject') {
			$data = $value;
		}
	}

	if (mj_smgt_get_roles($user_id) == 'teacher' && isset($data['own_data']) && $data['own_data'] == '1') {
		if ($section_id == '') {
			$query = $wpdb->prepare("SELECT * FROM $table_name WHERE teacher_id = %d AND class_id = %d", $user_id, $class_id);
		} else {
			$query = $wpdb->prepare("SELECT p1.*, p2.* FROM $table_name p1 INNER JOIN $table_name2 p2 ON (p1.subid = p2.subject_id) WHERE p2.teacher_id = %d AND p1.class_id = %d AND p1.section_id = %d", $user_id, $class_id, $section_id);
		}
	} elseif (mj_smgt_get_roles($user_id) == 'teacher') {
		if ($section_id != '') {
			$query = $wpdb->prepare("SELECT p1.*, p2.* FROM $table_name p1 INNER JOIN $table_name2 p2 ON (p1.subid = p2.subject_id) WHERE p2.teacher_id = %d AND p1.class_id = %d AND p1.section_id = %d", $user_id, $class_id, $section_id);
		} else {
			$query = $wpdb->prepare("SELECT p1.*, p2.* FROM $table_name p1 INNER JOIN $table_name2 p2 ON (p1.subid = p2.subject_id) WHERE p2.teacher_id = %d AND p1.class_id = %d", $user_id, $class_id);
		}
	} elseif (is_admin()) {
		if ($section_id != '') {
			$query = $wpdb->prepare("SELECT p1.* FROM $table_name p1 WHERE p1.class_id = %d AND p1.section_id = %d", $class_id, $section_id);
		} else {
			$query = $wpdb->prepare("SELECT p1.* FROM $table_name p1 WHERE p1.class_id = %d ", $class_id);
		}
	} else {
		$query = $wpdb->prepare("SELECT * FROM $table_name WHERE class_id = %d", $class_id);
	}

	$retrieve_subject = $wpdb->get_results($query);

	$defaultmsg = esc_attr__('Select subject', 'school-mgt');
	echo "<option value=''>" . $defaultmsg . "</option>";

	foreach ($retrieve_subject as $retrieved_data) {
		echo "<option value='" . esc_attr($retrieved_data->subid) . "'> " . esc_html($retrieved_data->sub_name . '-' . $retrieved_data->subject_code) . "</option>";
	}

	exit;
}

add_action('wp_ajax_mj_smgt_load_subject',  'mj_smgt_load_subject');
add_action('wp_ajax_nopriv_mj_smgt_load_subject',  'mj_smgt_load_subject');
function mj_smgt_load_subject()
{
	$class_id = sanitize_text_field($_POST['class_list']);
	global $wpdb;
	$table_name = $wpdb->prefix . "subject";
	$table_name2 = $wpdb->prefix . "teacher_subject";
	$user_id = get_current_user_id();

	if (mj_smgt_get_roles($user_id) == 'teacher') {
		// Prepare query for teacher role
		$query = $wpdb->prepare(
			"SELECT p1.*, p2.* FROM $table_name p1 
             INNER JOIN $table_name2 p2 ON (p1.subid = p2.subject_id) 
             WHERE p2.teacher_id = %d AND p1.class_id = %d",
			$user_id,
			$class_id
		);
	} else {
		// Prepare query for non-teacher role
		$query = $wpdb->prepare(
			"SELECT * FROM $table_name WHERE class_id = %d",
			$class_id
		);
	}

	// Get the results from the query
	$retrieve_subject = $wpdb->get_results($query);

	// Default message
	$defaultmsg = esc_attr__('Select subject', 'school-mgt');
	echo "<option value=''>" . $defaultmsg . "</option>";

	// Loop through the results and display them
	foreach ($retrieve_subject as $retrieved_data) {
		echo "<option value='" . esc_attr($retrieved_data->subid) . "'> " . esc_html($retrieved_data->sub_name . '-' . $retrieved_data->subject_code) . "</option>";
	}

	exit;
}


add_action('wp_ajax_mj_smgt_load_subject_by_section',  'mj_smgt_load_subject_by_section');
add_action('wp_ajax_nopriv_mj_smgt_load_subject_by_section',  'mj_smgt_load_subject_by_section');
function mj_smgt_load_subject_by_section()
{
	$class_id = sanitize_text_field($_POST['class_list']);

	$section_id = sanitize_text_field($_POST['section_list']);


	global $wpdb;
	$table_name = $wpdb->prefix . "subject";
	$table_name2 = $wpdb->prefix . "teacher_subject";
	$user_id = get_current_user_id();

	if (mj_smgt_get_roles($user_id) == 'teacher') {
		// Prepare query for teacher role
		if (!empty($section_id)) {
			$query = $wpdb->prepare(
				"SELECT p1.*, p2.* FROM $table_name p1 
				 INNER JOIN $table_name2 p2 ON (p1.subid = p2.subject_id) 
				 WHERE p2.teacher_id = %d AND p1.class_id = %d AND p1.section_id = %d",
				$user_id,
				$class_id,
				$section_id
			);
		} else {
			$query = $wpdb->prepare(
				"SELECT p1.*, p2.* FROM $table_name p1 
				 INNER JOIN $table_name2 p2 ON (p1.subid = p2.subject_id) 
				 WHERE p2.teacher_id = %d AND p1.class_id = %d",
				$user_id,
				$class_id

			);
		}
	} else {
		// Prepare query for non-teacher role
		if (!empty($section_id)) {
			$query = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE class_id = %d AND section_id = %d",
				$class_id,
				$section_id
			);
		} else {
			$query = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE class_id = %d",
				$class_id
			);
		}
	}

	// Get the results from the query
	$retrieve_subject = $wpdb->get_results($query);
	var_dump($retrieve_subject);
	// Default message
	$defaultmsg = esc_attr__('Select subject', 'school-mgt');
	echo "<option value=''>" . $defaultmsg . "</option>";

	// Loop through the results and display them
	foreach ($retrieve_subject as $retrieved_data) {
		echo "<option value='" . esc_attr($retrieved_data->subid) . "'> " . esc_html($retrieved_data->sub_name . '-' . $retrieved_data->subject_code) . "</option>";
	}

	exit;
}

add_action('wp_ajax_MJ_smgt_load_membership_payment_report', 'MJ_smgt_load_membership_payment_report');
add_action('wp_ajax_nopriv_MJ_smgt_load_membership_payment_report', 'MJ_smgt_load_membership_payment_report');
// FEES PAYMENT REPORT FILTER WISE
function MJ_smgt_load_membership_payment_report()
{
	$month_val = sanitize_text_field($_REQUEST['month_val']);
	$year_val = sanitize_text_field($_REQUEST['year_val']);
	global $wpdb;
	$table_name = $wpdb->prefix . "smgt_fee_payment_history";
	if ($month_val == "all_month") {
		$month = array('1' => esc_html__('January', 'school-mgt'), '2' => esc_html__('February', 'school-mgt'), '3' => esc_html__('March', 'school-mgt'), '4' => esc_html__('April', 'school-mgt'), '5' => esc_html__('May', 'school-mgt'), '6' => esc_html__('June', 'school-mgt'), '7' => esc_html__('July', 'school-mgt'), '8' => esc_html__('August', 'school-mgt'), '9' => esc_html__('September', 'school-mgt'), '10' => esc_html__('October', 'school-mgt'), '11' => esc_html__('November', 'school-mgt'), '12' => esc_html__('December', 'school-mgt'),);
		$result = array();
		$dataPoints_payment = array();
		array_push($dataPoints_payment, array(esc_html__('Month', 'school-mgt'), esc_html__('Payment', 'school-mgt')));
		$payment_array = array();
		foreach ($month as $key => $value) {
			$q = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(paid_by_date) = %d AND MONTH(paid_by_date) = %d",
				$year_val,
				$key
			);
			$result = $wpdb->get_results($q);
			$amount = 0;
			foreach ($result as $payment_entry) {
				$amount += $payment_entry->amount;
			}
			$payment_amount = $amount;
			$payment_array[] = $payment_amount;
			array_push($dataPoints_payment, array($value, $payment_amount));
		}
	} else {
		$select_month = sanitize_text_field($_REQUEST['month_val']);
		$dataPoints_payment = array();
		if ($month_val == "2") {
			$max_d = "29";
		} elseif ($month_val == "4" || $month_val == "6" || $month_val == "9" || $month_val == "11") {
			$max_d = "30";
		} else {
			$max_d = "31";
		}
		for ($d = 1; $d <= $max_d; $d++) {
			$time = mktime(12, 0, 0, $month_val, $d, $year_val);
			if (date('m', $time) == $month_val)
				$date_list[] = date('Y-m-d', $time);
			$day_date[] = date('d', $time);
			$month_first_date = min($date_list);
			$month_last_date =   max($date_list);
		}
		$month_val = array();
		$i = 1;
		foreach ($day_date as $value) {
			$month_val[$i] = $value;
			$i++;
		}
		array_push($dataPoints_payment, array(esc_html__('Day', 'school-mgt'), esc_html__('Payment', 'school-mgt')));
		foreach ($month_val as $key => $value) {
			// GET INCOME EXPENCE DATA
			$q = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(paid_by_date) = %d AND MONTH(paid_by_date) = %d AND DAY(paid_by_date) = %d",
				$year_val,
				$select_month,
				$value
			);
			$result = $wpdb->get_results($q);

			$amount = 0;
			foreach ($result as $payment_entry) {
				$amount += $payment_entry->amount;
			}
			$payment_amount = $amount;
			$payment_array[] = $payment_amount;
			array_push($dataPoints_payment, array($value, $payment_amount));
		}
	}
	$payment_filtered = array_filter($payment_array);
	$new_array = json_encode($dataPoints_payment);
	if (!empty($payment_filtered)) {
	?>
		<script type="text/javascript" src="<?php echo SMS_PLUGIN_URL . '/assets/js/chart_loder.js'; ?>"></script>
		<script type="text/javascript">
			google.charts.load('current', {
				'packages': ['bar']
			});
			google.charts.setOnLoadCallback(drawChart);

			function drawChart() {
				var data = google.visualization.arrayToDataTable(<?php echo $new_array; ?>);
				var options = {
					bars: 'vertical', // Required for Material Bar Charts.
					colors: ['<?php echo get_option('smgt_system_color_code'); ?>'],
				};
				var chart = new google.charts.Bar(document.getElementById('payment_bar_material'));
				chart.draw(data, google.charts.Bar.convertOptions(options));
			}
		</script>
		<div id="payment_bar_material" style="width:100%;height: 430px; padding:20px;"></div>
	<?php
	} else {
	?>
		<div class="calendar-event-new">
			<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
		</div>
	<?php
	}
	die;
}
add_action('wp_ajax_MJ_smgt_load_income_expence_report', 'MJ_smgt_load_income_expence_report');
add_action('wp_ajax_nopriv_MJ_smgt_load_income_expence_report', 'MJ_smgt_load_income_expence_report');
// INCOME EXPENCE REPORT WITH YEAR & MONTH FILTER WISE
function MJ_smgt_load_income_expence_report()
{
	$month_val = sanitize_text_field($_REQUEST['month_val']);
	$year_val = sanitize_text_field($_REQUEST['year_val']);
	global $wpdb;
	$table_name = $wpdb->prefix . "smgt_income_expense";
	// REPORT FOR PARTICULAR YEAR
	if ($month_val == "all_month") {
		$month = array('1' => esc_html__('January', 'school-mgt'), '2' => esc_html__('February', 'school-mgt'), '3' => esc_html__('March', 'school-mgt'), '4' => esc_html__('April', 'school-mgt'), '5' => esc_html__('May', 'school-mgt'), '6' => esc_html__('June', 'school-mgt'), '7' => esc_html__('July', 'school-mgt'), '8' => esc_html__('August', 'school-mgt'), '9' => esc_html__('September', 'school-mgt'), '10' => esc_html__('October', 'school-mgt'), '11' => esc_html__('November', 'school-mgt'), '12' => esc_html__('December', 'school-mgt'),);
		$result = array();
		$dataPoints_2 = array();
		array_push($dataPoints_2, array(esc_html__('Month', 'school-mgt'), esc_html__('Income', 'school-mgt'), esc_html__('Expense', 'school-mgt'), esc_html__('Net Profit', 'school-mgt')));
		$dataPoints_1 = array();
		$expense_array = array();
		$currency_symbol = mj_smgt_get_currency_symbol(get_option('smgt_currency_code'));
		foreach ($month as $key => $value) {
			// GET INCOME EXPENCE DATA
			$q = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(income_create_date) = %d AND MONTH(income_create_date) = %d AND invoice_type = %s",
				$year_val,
				$key,
				'income'
			);

			$q1 = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(income_create_date) = %d AND MONTH(income_create_date) = %d AND invoice_type = %s",
				$year_val,
				$key,
				'expense'
			);

			$result = $wpdb->get_results($q);
			$result1 = $wpdb->get_results($q1);

			$expense_yearly_amount = 0;
			foreach ($result1 as $expense_entry) {
				$all_entry = json_decode($expense_entry->entry);
				$amount = 0;
				foreach ($all_entry as $entry) {
					$amount += $entry->amount;
				}
				$expense_yearly_amount += $amount;
			}
			$expense_amount = $expense_yearly_amount;
			$income_yearly_amount = 0;
			foreach ($result as $income_entry) {
				$all_entry = json_decode($income_entry->entry);
				$amount = 0;
				foreach ($all_entry as $entry) {
					$amount += $entry->amount;
				}
				$income_yearly_amount += $amount;
			}
			$income_amount = $income_yearly_amount;
			$expense_array[] = $expense_amount;
			$income_array[] = $income_amount;
			$net_profit_array = $income_amount - $expense_amount;
			array_push($dataPoints_2, array($value, $income_amount, $expense_amount, $net_profit_array));
		}
	}
	//  REPORT FOR PARTICULAR MONTH WISE
	else {
		$select_month = $_REQUEST['month_val'];
		$dataPoints_2 = array();
		if ($month_val == "2") {
			$max_d = "29";
		} elseif ($month_val == "4" || $month_val == "6" || $month_val == "9" || $month_val == "11") {
			$max_d = "30";
		} else {
			$max_d = "31";
		}
		for ($d = 1; $d <= $max_d; $d++) {
			$time = mktime(12, 0, 0, $month_val, $d, $year_val);
			if (date('m', $time) == $month_val)
				$date_list[] = date('Y-m-d', $time);
			$day_date[] = date('d', $time);
			$month_first_date = min($date_list);
			$month_last_date =   max($date_list);
		}
		$month_val = array();
		$i = 1;
		foreach ($day_date as $value) {
			$month_val[$i] = $value;
			$i++;
		}
		array_push($dataPoints_2, array(esc_html__('Day', 'school-mgt'), esc_html__('Income', 'school-mgt'), esc_html__('Expense', 'school-mgt'), esc_html__('Net Profit', 'school-mgt')));
		foreach ($month_val as $key => $value) {
			// GET INCOME EXPENCE DATA
			$q = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(income_create_date) = %d AND MONTH(income_create_date) = %d AND DAY(income_create_date) = %d AND invoice_type = %s",
				$year_val,
				$select_month,
				$value,
				'income'
			);
			$q1 = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(income_create_date) = %d AND MONTH(income_create_date) = %d AND DAY(income_create_date) = %d AND invoice_type = %s",
				$year_val,
				$select_month,
				$value,
				'expense'
			);
			$result = $wpdb->get_results($q);
			$result1 = $wpdb->get_results($q1);

			$expense_yearly_amount = 0;
			foreach ($result1 as $expense_entry) {
				$all_entry = json_decode($expense_entry->entry);
				$amount = 0;
				foreach ($all_entry as $entry) {
					$amount += $entry->amount;
				}
				$expense_yearly_amount += $amount;
			}
			$expense_amount = $expense_yearly_amount;
			$income_yearly_amount = 0;
			foreach ($result as $income_entry) {
				$all_entry = json_decode($income_entry->entry);
				$amount = 0;
				foreach ($all_entry as $entry) {
					$amount += $entry->amount;
				}
				$income_yearly_amount += $amount;
			}
			$income_amount = $income_yearly_amount;
			$expense_array[] = $expense_amount;
			$income_array[] = $income_amount;
			$net_profit_array = $income_amount - $expense_amount;
			array_push($dataPoints_2, array($value, $income_amount, $expense_amount, $net_profit_array));
		}
	}
	$income_filtered = array_filter($income_array);
	$expense_filtered = array_filter($expense_array);
	$new_array = json_encode($dataPoints_2);
	if (!empty($income_filtered) || !empty($expense_filtered)) {
	?>
		<script type="text/javascript" src="<?php echo SMS_PLUGIN_URL . '/assets/js/chart_loder.js'; ?>"></script>
		<script type="text/javascript">
			google.charts.load('current', {
				'packages': ['bar']
			});
			google.charts.setOnLoadCallback(drawChart);

			function drawChart() {
				var data = google.visualization.arrayToDataTable(<?php echo $new_array; ?>);
				var options = {
					bars: 'vertical', // Required for Material Bar Charts.
					colors: ['#104B73', '#FF9054', '#70ad46'],
				};
				var chart = new google.charts.Bar(document.getElementById('barchart_material'));
				chart.draw(data, google.charts.Bar.convertOptions(options));
			}
		</script>
		<div id="barchart_material" style="width:100%;height: 430px; padding:20px;"></div>
	<?php
	} else {
	?>
		<div class="calendar-event-new">
			<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
		</div>
	<?php
	}
	die();
}
add_action('wp_ajax_MJ_smgt_payment_dashboard_report_content', 'MJ_smgt_payment_dashboard_report_content');
add_action('wp_ajax_nopriv_MJ_smgt_payment_dashboard_report_content', 'MJ_smgt_payment_dashboard_report_content');
// PAYMENT DATA LOAD WITH DATE
function MJ_smgt_payment_dashboard_report_content()
{
	$type = sanitize_text_field($_REQUEST['type']);
	?>
	<canvas id="chartJSContainerpayment" width="300" height="250"></canvas>
	<p class="percent">
		<?php
		$result =  mj_smgt_all_date_type_value($type);
		$response =  json_decode($result);
		$start_date = $response[0];
		$end_date = $response[1];
		$cash_payment = mj_smgt_get_payment_paid_data_by_date_method("Cash", $start_date, $end_date);
		if (!empty($cash_payment)) {
			$cashAmount = 0;
			foreach ($cash_payment as $cash) {
				$cashAmount += $cash->amount;
			}
		} else {
			$cashAmount = 0;
		}
		$Cheque_payment = mj_smgt_get_payment_paid_data_by_date_method("Cheque", $start_date, $end_date);
		if (!empty($Cheque_payment)) {
			$chequeAmount = 0;
			foreach ($Cheque_payment as $cheque) {
				$chequeAmount += $cheque->amount;
			}
		} else {
			$chequeAmount = 0;
		}
		$bank_payment = mj_smgt_get_payment_paid_data_by_date_method("Bank Transfer", $start_date, $end_date);
		if (!empty($bank_payment)) {
			$bankAmount = 0;
			foreach ($bank_payment as $bank) {
				$bankAmount += $bank->amount;
			}
		} else {
			$bankAmount = 0;
		}
		$paypal_payment = mj_smgt_get_payment_paid_data_by_date_method("paypal", $start_date, $end_date);
		if (!empty($paypal_payment)) {
			$paypalAmount = 0;
			foreach ($paypal_payment as $paypal) {
				$paypalAmount += $paypal->amount;
			}
		} else {
			$paypalAmount = 0;
		}
		$stripe_payment = mj_smgt_get_payment_paid_data_by_date_method("Stripe", $start_date, $end_date);
		if (!empty($stripe_payment)) {
			$stripeAmount = 0;
			foreach ($stripe_payment as $stripe) {
				$stripeAmount += $stripe->amount;
			}
		} else {
			$stripeAmount = 0;
		}
		$Total_amount =  $cashAmount + $chequeAmount + $bankAmount + $paypalAmount + $stripeAmount;
		$currency_symbol = html_entity_decode(MJ_smgt_get_currency_symbol(get_option('smgt_currency_code')));
		echo MJ_smgt_currency_symbol_position_language_wise(number_format($Total_amount, 2, '.', ''));
		?>
	</p>
	<p class="percent1">
		<?php esc_html_e('Payment Report', 'school-mgt'); ?>
	</p>
	</div>
	<script>
		var options1 = {
			type: 'doughnut',
			data: {
				labels: ["<?php esc_html_e('Cash', 'school-mgt'); ?>", "<?php esc_html_e('Cheque', 'school-mgt'); ?>", "<?php esc_html_e('Bank Transfer', 'school-mgt'); ?>", "<?php esc_html_e('Paypal', 'school-mgt'); ?>", "<?php esc_html_e('Stripe', 'school-mgt'); ?>"],
				datasets: [{
					label: '# of Votes',
					data: [<?php echo number_format($cashAmount, 2, '.', ''); ?>, <?php echo number_format($chequeAmount, 2, '.', ''); ?>, <?php echo number_format($bankAmount, 2, '.', ''); ?>, <?php echo number_format($paypalAmount, 2, '.', ''); ?>, <?php echo number_format($stripeAmount, 2, '.', ''); ?>],
					backgroundColor: [
						'#CD6155',
						'#00BCD4',
						'#F5B041',
						'#99A3A4',
						'#9B59B6',
					],
					borderColor: [
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
					],
					borderWidth: 1,
				}]
			},
			options: {
				rotation: 1 * Math.PI,
				// circumference: 1 * Math.PI,
				legend: {
					display: false
				},
				tooltips: {
					enabled: true,
					callbacks: {
						label: function(tooltipItem, data) {
							var label = data.labels[tooltipItem.index] || '';
							var symbol = '<?php echo html_entity_decode(MJ_smgt_get_currency_symbol(get_option('smgt_currency_code'))); ?>';
							var value = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
							return label + ': ' + symbol + value;
						}
					}
				},
				cutoutPercentage: 85
			}
		}
		var ctx1 = document.getElementById('chartJSContainerpayment').getContext('2d');
		new Chart(ctx1, options1);
		var options2 = {
			type: 'doughnut',
			data: {
				labels: ["", "Purple", ""],
				datasets: [{
					data: [88.5, 1],
					backgroundColor: [
						"rgba(0,0,0,0)",
						"rgba(255,255,255,1)",
					],
					borderColor: [
						'rgba(0, 0, 0 ,0)',
						'rgba(46, 204, 113, 1)',
					],
					borderWidth: 5
				}]
			},
			options: {
				cutoutPercentage: 95,
				rotation: 1 * Math.PI,
				circumference: 1 * Math.PI,
				legend: {
					display: false
				},
				tooltips: {
					enabled: false
				}
			}
		}
	</script>
<?php
	exit();
}
add_action('wp_ajax_MJ_smgt_attendance_dashboard_report_content', 'MJ_smgt_attendance_dashboard_report_content');
add_action('wp_ajax_nopriv_MJ_smgt_attendance_dashboard_report_content', 'MJ_smgt_attendance_dashboard_report_content');
// ATTENDANCE LOAD WITH DATE
function MJ_smgt_attendance_dashboard_report_content()
{
	$type = sanitize_text_field($_REQUEST['type']);
?>
	<canvas id="chartJSContainerattendance" width="300" height="250"></canvas>
	<p class="percent">
		<?php
		$result =  mj_smgt_all_date_type_value($type);
		$response =  json_decode($result);
		$start_date = $response[0];
		$end_date = $response[1];
		$present = MJ_smgt_attendance_data_by_status($start_date, $end_date, 'Present');
		$absent = MJ_smgt_attendance_data_by_status($start_date, $end_date, 'Absent');
		$late = MJ_smgt_attendance_data_by_status($start_date, $end_date, 'Late');
		$halfday = MJ_smgt_attendance_data_by_status($start_date, $end_date, 'Half Day');
		$attendance = $present + $absent + $late + $halfday;
		echo $attendance;
		?>
	</p>
	<script>
		var options1 = {
			type: 'doughnut',
			data: {
				labels: ["<?php esc_html_e('Present', 'school-mgt'); ?>", "<?php esc_html_e('Absent', 'school-mgt'); ?>", "<?php esc_html_e('Late', 'school-mgt'); ?>", "<?php esc_html_e('Half Day', 'school-mgt'); ?>"],
				datasets: [{
					label: '# of Votes',
					data: [<?php echo $present; ?>, <?php echo $absent; ?>, <?php echo $late; ?>, <?php echo $halfday; ?>],
					backgroundColor: [
						'#28A745',
						'#DC3545',
						'#FFC107',
						'#007BFF',
					],
					borderColor: [
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
						'rgba(255, 255, 255 ,1)',
					],
					borderWidth: 1,
				}]
			},
			options: {
				rotation: 1 * Math.PI,
				legend: {
					display: false
				},
				tooltip: {
					enabled: false
				},
				cutoutPercentage: 85
			}
		}
		var ctx1 = document.getElementById('chartJSContainerattendance').getContext('2d');
		new Chart(ctx1, options1);
		var options2 = {
			type: 'doughnut',
			data: {
				labels: ["", "Purple", ""],
				datasets: [{
					data: [88.5, 1],
					backgroundColor: [
						"rgba(0,0,0,0)",
						"rgba(255,255,255,1)",
					],
					borderColor: [
						'rgba(0, 0, 0 ,0)',
						'rgba(46, 204, 113, 1)',
					],
					borderWidth: 5
				}]
			},
			options: {
				cutoutPercentage: 95,
				rotation: 1 * Math.PI,
				circumference: 1 * Math.PI,
				legend: {
					display: false
				},
				tooltips: {
					enabled: false
				}
			}
		}
	</script>
	<p class="percent1">
		<?php esc_html_e('Attendance', 'school-mgt'); ?>
	</p>
<?php
	exit();
}
add_action('wp_ajax_mj_smgt_load_teacher_by_subject',  'mj_smgt_load_teacher_by_subject');
add_action('wp_ajax_nopriv_mj_smgt_load_teacher_by_subject',  'mj_smgt_load_teacher_by_subject');
function mj_smgt_load_teacher_by_subject()
{
	$current_user = wp_get_current_user();
	$current_user_id = get_current_user_id();

	// Check if the user has any roles
	$current_role = !empty($current_user->roles) ? $current_user->roles[0] : '';

	$subject = sanitize_text_field($_POST['subject']);

	global $wpdb;
	$table_smgt_beds = $wpdb->prefix . 'teacher_subject';

	// Fetch results from the database
	$result = $wpdb->get_results($wpdb->prepare(
		"SELECT teacher_id FROM $table_smgt_beds WHERE subject_id = %d",
		$subject
	));

	if (!empty($result)) {
		foreach ($result as $value) {
			if (!empty($value->teacher_id)) {
				// Check role and conditionally output options
				if ($current_role === 'teacher' && (int)$value->teacher_id === (int)$current_user_id) {
					echo '<option value="' . esc_attr($value->teacher_id) . '"> ' . esc_html(mj_smgt_get_display_name($value->teacher_id)) . '</option>';
				} elseif ($current_role !== 'teacher') {
					echo '<option value="' . esc_attr($value->teacher_id) . '"> ' . esc_html(mj_smgt_get_display_name($value->teacher_id)) . '</option>';
				}
			}
		}
	}

	exit;
}
add_action('wp_ajax_mj_smgt_fees_user_list',  'mj_smgt_fees_user_list');
add_action('wp_ajax_nopriv_mj_smgt_fees_user_list',  'mj_smgt_fees_user_list');
// LOAD FEES USER-LIST FOR GENERATE INVOICE
function mj_smgt_fees_user_list()
{
	$school_obj = new School_Management(get_current_user_id());
	$login_user_role = $school_obj->role;
	$class_list = isset($_REQUEST['class_list']) ? sanitize_text_field($_REQUEST['class_list']) : '';
	$class_section = isset($_REQUEST['class_section']) ? sanitize_text_field($_REQUEST['class_section']) : '';
	$exlude_id = mj_smgt_approve_student_list();
	$html_class_section = '';
	$user_list = array();
	global $wpdb;
	$defaultmsg = esc_attr__('All Section', 'school-mgt');
	$html_class_section =  "<option value=''>" . $defaultmsg . "</option>";
	if ($class_list != '' && $class_list != 'all_class') {
		$retrieve_data = mj_smgt_get_class_sections($class_list);
		if ($retrieve_data) {
			foreach ($retrieve_data as $section) {
				$html_class_section .= "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
			}
		}
	}
	$return_results['section'] = $html_class_section;
	$query_data['exclude'] = $exlude_id;
	if ($class_section) {
		$query_data['meta_key'] = 'class_section';
		$query_data['meta_value'] = $class_section;
		$query_data['meta_query'] = array(array('key' => 'class_name', 'value' => $class_list, 'compare' => '='));
		$results = get_users($query_data);
	} elseif ($class_list == 'all_class') {
		$results = mj_smgt_get_all_student_list();
	} elseif ($class_list != '' && $class_list != 'all_class') {
		$query_data['meta_key'] = 'class_name';
		$query_data['meta_value'] = $class_list;
		$results = get_users($query_data);
	}
	if (isset($results)) {
		foreach ($results as $user_datavalue) {
			$user_list[] = $user_datavalue->ID;
		}
	}
	$user_data_list = array_unique($user_list);
	$return_results['users'] = '';
	$user_string  = '<select name="selected_users[]" id="selected_users" class="form-control validate[required]" multiple="true">';
	if (!empty($user_data_list))
		foreach ($user_data_list as $retrive_data) {
			if ($retrive_data != get_current_user_id()) {
				$check_data = mj_smgt_get_user_name_byid($retrive_data);
				if ($check_data != '') {
					$user_string .= "<option value='" . $retrive_data . "'>" . mj_smgt_get_user_name_byid($retrive_data) . "</option>";
				}
			}
		}
	$user_string .= '</select>';
	$return_results['users'] = $user_string;
	echo json_encode($return_results);
	die;
}
add_action('wp_ajax_mj_smgt_load_siblings_dropdown',  'mj_smgt_load_siblings_dropdown');
add_action('wp_ajax_nopriv_mj_smgt_load_siblings_dropdown',  'mj_smgt_load_siblings_dropdown');
// LOAD SIBLING DATA FOR ADMISSION
function mj_smgt_load_siblings_dropdown()
{
	$x = sanitize_text_field($_REQUEST['click_val']);

?>
	<script>
		jQuery(document).ready(function($) {
			$("body").on("change", "#sibling_class_change_<?php echo $x; ?>", function(event) {
				$('#sibling_student_list_<?php echo $x; ?>').html('');
				var selection = $(this).val();
				var optionval = $(this);
				var curr_data = {
					action: 'mj_smgt_load_user',
					class_list: selection,
					dataType: 'json'
				};
				$.post(smgt.ajax, curr_data, function(response) {
					$('#sibling_student_list_<?php echo $x; ?>').append(response);
				});
			});
			$("body").on("change", "#sibling_class_change_<?php echo $x; ?>", function() {
				$('#sibling_class_section_<?php echo $x; ?>').html('');
				$('#sibling_class_section_<?php echo $x; ?>').append('<option value="remove">Loading..</option>');
				var selection = $("#sibling_class_change_<?php echo $x; ?>").val();
				var optionval = $(this);
				var curr_data = {
					action: 'mj_smgt_load_class_section',
					class_id: selection,
					dataType: 'json'
				};
				$.post(smgt.ajax, curr_data, function(response) {
					$("#sibling_class_section_<?php echo $x; ?> option[value='remove']").remove();
					$('#sibling_class_section_<?php echo $x; ?>').append(response);
				});
			});
			$("#sibling_class_section_<?php echo $x; ?>").on('change', function() {
				$('#sibling_student_list_<?php echo $x; ?>').html('');
				var selection = $(this).val();
				var class_id = $("#sibling_class_change_<?php echo $x; ?>").val();
				var optionval = $(this);
				var curr_data = {
					action: 'mj_smgt_load_section_user',
					section_id: selection,
					class_id: class_id,
					dataType: 'json'
				};
				$.post(smgt.ajax, curr_data, function(response) {
					$('#sibling_student_list_<?php echo $x; ?>').append(response);
				});
			});

			function deleteParentElement(n) {
				var alert = confirm("<?php esc_attr_e('Are you sure you want to delete this record?', 'school-mgt'); ?>");
				if (alert == true) {
					n.parentNode.parentNode.parentNode.removeChild(n.parentNode.parentNode);
					return false;
				}
			}
		});
	</script>
	<?php

	?>
	<div class="form-body user_form">
		<div class="row">
			<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 input smgt_form_select mb-3">
				<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Class', 'school-mgt'); ?><span class="require-field">*</span></label>
				<select name="siblingsclass[]" class="form-control validate[required] class_in_student max_width_100" id="sibling_class_change_<?php echo $x; ?>" style="height:44px;">
					<option value=""><?php esc_attr_e('Select Class', 'school-mgt'); ?></option>
					<?php
					foreach (mj_smgt_get_allclass() as $classdata) {
					?>
						<option value="<?php echo $classdata['class_id']; ?>"><?php echo $classdata['class_name']; ?></option>
					<?php
					}
					?>
				</select>
			</div>
			<div class="col-sm-4 col-md-4 col-lg-4 col-xl-4 input smgt_form_select mb-3">
				<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Class Section', 'school-mgt'); ?></label>
				<select name="siblingssection[]" class="form-control max_width_100" style="height:44px;" id="sibling_class_section_<?php echo $x; ?>">
					<option value=""><?php esc_attr_e('All Section', 'school-mgt'); ?></option>
				</select>
			</div>
			<div class="col-sm-4 col-md-4 col-lg-4 col-xl-4 input class_section_hide mb-3">
				<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Student', 'school-mgt'); ?><span class="require-field">*</span></label>
				<select name="siblingsstudent[]" id="sibling_student_list_<?php echo $x; ?>" style="height:44px;" class="form-control max_width_100 validate[required]">
					<option value=""><?php esc_attr_e('Select Student', 'school-mgt'); ?></option>
				</select>
			</div>
			<div class="col-md-1 col-sm-3 col-xs-12 width_20px_res">
				<input type="image" onclick="deleteParentElement(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px remove_cirtificate input_btn_height_width">
			</div>
		</div>
	</div>
<?php
	die();
}
add_action('wp_ajax_mj_smgt_class_rootine_import', 'mj_smgt_class_rootine_import');
add_action('wp_ajax_nopriv_mj_smgt_class_rootine_import', 'mj_smgt_class_rootine_import');
// CLASS ROUTINE IMPORT FUNCTION
function mj_smgt_class_rootine_import()
{
?>
	<script>
		jQuery(document).ready(function($) {
			$('#import_csv').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body">
		<form name="upload_form" action="#" method="post" class="form-horizontal" id="import_csv" enctype="multipart/form-data"><!--form div-->
			<input type="hidden" name="class_id" value="<?php echo sanitize_text_field($_REQUEST['class_id']); ?>">
			<input type="hidden" name="class_section" value="<?php echo sanitize_text_field($_REQUEST['class_section']); ?>">
			<div class="form-body user_form">
				<div class="row">
					<div class="col-md-9 input mt-0">
						<div class="form-group input rtl_margin_top_0px_popup">
							<div class="col-md-12 form-control res_rtl_height_50px">
								<label for="" class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl"><?php _e('Select CSV File', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file_class" type="file" class="form-control file validate[required] csvfile_width d-inline file_validation" name="csv_file">
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 margin_bottom_15">
						<input type="submit" value="<?php esc_attr_e('Import CSV', 'school-mgt'); ?>" name="save_import_csv" class="btn rtl_margin_0px save_btn" />
					</div>
				</div>
			</div>
		</form>
	</div>
<?php
	die();
}
// LOAD CHILD DROPDOWN
add_action('wp_ajax_mj_smgt_load_child_dropdown',  'mj_smgt_load_child_dropdown');
add_action('wp_ajax_nopriv_mj_smgt_load_child_dropdown',  'mj_smgt_load_child_dropdown');
function mj_smgt_load_child_dropdown()
{
	$students = mj_smgt_get_student_groupby_class();
?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('.add-search-single-select-js').select2({});
		})
	</script>
	<div class="form-body user_form">
		<div id="parents_child" class="row parents_child">
			<div class="col-md-6 input width_80px_res">
				<label class="ml-1 custom-top-label top" for="student_list"><?php esc_attr_e('Child', 'school-mgt'); ?><span class="require-field">*</span></label>
				<select name="chield_list[]" id="student_list" class="form-control validate[required] max_width_100" style="height:47px !important;">
					<option value=""><?php esc_attr_e('Select Child', 'school-mgt'); ?></option>
					<?php foreach ($students as $label => $opt) { ?>
						<optgroup label="<?php echo "Class : " . $label; ?>"><?php foreach ($opt as $id => $name): ?>
								<option value="<?php echo $id; ?>"><?php echo $name; ?></option><?php endforeach; ?>
						</optgroup><?php } ?>
				</select>
			</div>
			<div class="col-md-1 col-sm-3 col-xs-12 width_20px_res">
				<input type="image" onclick="deleteParentElementChild(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px remove_cirtificate input_btn_height_width">
			</div>
		</div>
	</div>
<?php
	die();
}
add_action('wp_ajax_nopriv_mj_smgt_import_student_attendance',  'mj_smgt_import_student_attendance');
add_action('wp_ajax_mj_smgt_import_student_attendance',  'mj_smgt_import_student_attendance');
/*---------- IMPORT STUDENT ATTENDANCE DATA WITH SUBJECT----------*/
function mj_smgt_import_student_attendance()
{
?>
	<script>
		jQuery(document).ready(function($) {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Attendance Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body"><!-- panel-body -->
		<!-------- Import Teacher Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data"><!--form div-->
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<div class="form-body user_form">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control res_rtl_height_50px">
								<label class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl" for="city_name"><?php esc_attr_e('Select CSV file', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file" type="file" class="col-md-12 form-control file validate[required] file_validation csvfile_width" name="csv_file">
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-3">
						<input type="submit" value="<?php esc_attr_e('Upload CSV File', 'school-mgt'); ?>" name="upload_attendance_csv_file" class="col-sm-6 width-auto save_btn" />
					</div>
				</div>
			</div>
		</form><!--form div-->
	</div><!--panel-body-->
	<?php
	die();
}
add_action('wp_ajax_mj_smgt_load_class_section_document',  'mj_smgt_load_class_section_document');
add_action('wp_ajax_nopriv_mj_smgt_load_class_section_document',  'mj_smgt_load_class_section_document');
function mj_smgt_load_class_section_document()
{
	$class_id = $_POST['class_id'];
	$defaultmsg = esc_attr__('All Section', 'school-mgt');
	if ($class_id ==  'all class') {
		echo "<option value='all section'>" . $defaultmsg . "</option>";
	} else {
		echo "<option value='all section'>" . $defaultmsg . "</option>";
		$retrieve_data = mj_smgt_get_class_sections($_POST['class_id']);
		foreach ($retrieve_data as $section) {
			echo "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
		}
	}
	die();
}
add_action('wp_ajax_mj_smgt_load_class_vise_student_document',  'mj_smgt_load_class_vise_student_document');
add_action('wp_ajax_nopriv_mj_smgt_load_class_vise_student_document',  'mj_smgt_load_class_vise_student_document');
// CLASS VISE SECTION LIST
// CLASS VISE STUDENT LIST
function mj_smgt_load_class_vise_student_document()
{
	$exlude_id = '';
	$class_id = sanitize_text_field($_POST['class_id']);
	$defaultmsg = esc_attr__('All Student', 'school-mgt');
	if ($class_id ==  'all class') {
		echo "<option value='all section'>" . $defaultmsg . "</option>";
	} else {
		global $wpdb;
		echo "<option value='all student'>" . $defaultmsg . "</option>";
		$retrieve_data = get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id, 'role' => 'student', 'exclude' => $exlude_id));
		foreach ($retrieve_data as $users) {
			echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
		}
		die();
	}
}
add_action('wp_ajax_mj_smgt_load_section_user_list',  'mj_smgt_load_section_user_list');
add_action('wp_ajax_nopriv_mj_smgt_load_section_user_list',  'mj_smgt_load_section_user_list');
// SECTION VISE STUDENT LIST
function mj_smgt_load_section_user_list()
{
	$section_id = sanitize_text_field($_POST['section_id']);
	$class_id = sanitize_text_field($_POST['class_id']);
	$defaultmsg = esc_attr__('All Student', 'school-mgt');
	if ($section_id == 'all section') {
		echo "<option value='all student'>" . $defaultmsg . "</option>";
		global $wpdb;
		$exlude_id = mj_smgt_approve_student_list();
		$retrieve_data = get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id, 'role' => 'student', 'exclude' => $exlude_id));
		foreach ($retrieve_data as $users) {
			echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
		}
		die();
	} else {
		if (empty($section_id)) {
			global $wpdb;
			$exlude_id = mj_smgt_approve_student_list();
			$retrieve_data = get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id, 'role' => 'student', 'exclude' => $exlude_id));
			//$defaultmsg= esc_attr__( 'Select Student' , 'school-mgt');
			//echo "<option value=''>".$defaultmsg."</option>";
			echo "<option value='all student'>" . $defaultmsg . "</option>";
			foreach ($retrieve_data as $users) {
				echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
			}
			die();
		} else {
			global $wpdb;
			$exlude_id = mj_smgt_approve_student_list();
			$retrieve_data = get_users(array('meta_key' => 'class_section', 'meta_value' => $section_id, 'role' => 'student', 'exclude' => $exlude_id));
			//$defaultmsg= esc_attr__( 'Select student' , 'school-mgt');
			//echo "<option value=''>".$defaultmsg."</option>";
			echo "<option value='all student'>" . $defaultmsg . "</option>";
			foreach ($retrieve_data as $users) {
				echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
			}
			die();
		}
	}
	die();
}
add_action('wp_ajax_nopriv_MJ_smgt_qr_code_take_attendance',  'MJ_smgt_qr_code_take_attendance');
add_action('wp_ajax_MJ_smgt_qr_code_take_attendance',  'MJ_smgt_qr_code_take_attendance');
/* Student Attendance With Qr Code */
function MJ_smgt_qr_code_take_attendance()
{
	$attendance_url = $_REQUEST['attendance_url'];
	$obj_attend = new Attendence_Manage();
	$qrcode_attendance = explode('_', $attendance_url);
	$user_id = $qrcode_attendance[0];
	$user_class_id = $qrcode_attendance[1];
	$curr_date = $qrcode_attendance[2];
	$user_section_id = $qrcode_attendance[3];
	$selected_class_id = $qrcode_attendance[4];
	$selected_class_subject = $qrcode_attendance[5];
	$selected_class_section = $qrcode_attendance[6];
	$userdata = get_userdata($user_id);
	$status = 'Present';
	$attend_by = get_current_user_id();
	$attendence_type = 'QR';
	$comment = "";
	if (!empty($userdata)) {
		$savedata = $obj_attend->mj_smgt_insert_subject_wise_attendance($curr_date, $user_class_id, $user_id, $attend_by, $status, $selected_class_subject, $comment, $attendence_type, $selected_class_section);
		$result = "1";
	} else {
		$result = "3";
	}
	echo $result;
	die;
}
add_action('wp_ajax_mj_smgt_teacher_attendance_graph_report_data', 'mj_smgt_teacher_attendance_graph_report_data');
add_action('wp_ajax_nopriv_mj_smgt_teacher_attendance_graph_report_data', 'mj_smgt_teacher_attendance_graph_report_data');
/* Teacher Attendance Graph Report */
function mj_smgt_teacher_attendance_graph_report_data()
{
	$filter_val = sanitize_text_field($_REQUEST['filter_val']);
	global $wpdb;
	$table_attendance = $wpdb->prefix . 'attendence';
	if ($filter_val == "today") {
		$start_date = date('Y-m-d');
		$end_date = date('Y-m-d');
		$value = 'Today';
	} elseif ($filter_val == "this_week") {
		//check the current day
		if (date('D') != 'Mon') {
			//take the last monday
			$start_date = date('Y-m-d', strtotime('last sunday'));
		} else {
			$start_date = date('Y-m-d');
		}
		//always next saturday
		if (date('D') != 'Sat') {
			$end_date = date('Y-m-d', strtotime('next saturday'));
		} else {
			$end_date = date('Y-m-d');
		}
		$value = 'This Week';
	} elseif ($filter_val == "last_week") {
		$previous_week = strtotime("-1 week +1 day");
		$start_week = strtotime("last sunday midnight", $previous_week);
		$end_week = strtotime("next saturday", $start_week);
		$start_date = date("Y-m-d", $start_week);
		$end_date = date("Y-m-d", $end_week);
		$value = 'Last Week';
	} elseif ($filter_val == "this_month") {
		$start_date = date('Y-m-d', strtotime('first day of this month'));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'This Month';
	} elseif ($filter_val == "last_month") {
		$start_date = date('Y-m-d', strtotime("first day of previous month"));
		$end_date =  date('Y-m-d', strtotime("last day of previous month"));
		$value = 'Last Month';
	} elseif ($filter_val == "last_3_month") {
		$month_date =  date('Y-m-d', strtotime('-2 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'Last 3 Month';
	} elseif ($filter_val == "last_6_month") {
		$month_date =  date('Y-m-d', strtotime('-5 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'Last 6 Month';
	} elseif ($filter_val == "last_12_month") {
		$month_date =  date('Y-m-d', strtotime('-11 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'Last 12 Month';
	} elseif ($filter_val == "this_year") {
		$start_date = date("Y-01-01", strtotime("0 year"));
		$end_date = date("Y-12-t", strtotime($start_date));
		$value = 'This Year';
	} elseif ($filter_val == "last_year") {
		$start_date = date("Y-01-01", strtotime("-1 year"));
		$end_date = date("Y-12-t", strtotime($start_date));
		$value = 'Last Year';
	}
	$report_2 = $wpdb->get_results("SELECT  at.user_id,
	SUM(case when `status` ='Present' then 1 else 0 end) as Present,
	SUM(case when `status` ='Absent' then 1 else 0 end) as Absent
	from $table_attendance as at where `attendence_date` BETWEEN '$start_date' AND '$end_date' AND at.user_id AND at.role_name = 'teacher' GROUP BY at.user_id");
	$chart_array = array();
	$chart_array[] = array(esc_attr__('teacher', 'school-mgt'), esc_attr__('Present', 'school-mgt'), esc_attr__('Absent', 'school-mgt'));
	if (!empty($report_2)) {
		foreach ($report_2 as $result) {
			$class_id = mj_smgt_get_user_name_byid($result->user_id);
			$chart_array[] = array("$class_id", (int)$result->Present, (int)$result->Absent);
		}
	}
	$options = array(
		'title' => esc_attr__($value . ' ' . 'Attendance Report', 'school-mgt'),
		'titleTextStyle' => array('color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
		'legend' => array(
			'position' => 'right',
			'textStyle' => array('color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;')
		),
		'hAxis' => array(
			'title' =>  esc_attr__('Teacher', 'school-mgt'),
			'titleTextStyle' => array('color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
			'textStyle' => array('color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
			'maxAlternation' => 2
		),
		'vAxis' => array(
			'title' =>  esc_attr__('No of Days', 'school-mgt'),
			'minValue' => 0,
			'maxValue' => 4,
			'format' => '#',
			'titleTextStyle' => array('color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
			'textStyle' => array('color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;')
		),
		'colors' => array('#5840bb', '#f25656')
	);
	require_once SMS_PLUGIN_DIR . '/lib/chart/GoogleCharts.class.php';
	$GoogleCharts = new GoogleCharts;
	if (!empty($report_2)) {
		$chart = $GoogleCharts->load('column', 'chart_div_last_month')->get($chart_array, $options);
	} else {
	?>
		<div class="calendar-event-new">
			<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
		</div>
	<?php
	}
	if (isset($report_2) && count($report_2) > 0) {
	?>
		<div id="chart_div_last_month" class="w-100 h-500-px"></div>
		<!-- Javascript -->
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
			<?php echo $chart; ?>
		</script>
	<?php
	}
	die();
}
add_action('wp_ajax_mj_smgt_student_attendance_graph_report_data', 'mj_smgt_student_attendance_graph_report_data');
add_action('wp_ajax_nopriv_mj_smgt_student_attendance_graph_report_data', 'mj_smgt_student_attendance_graph_report_data');
/* Student Attendance Graph Report */
function mj_smgt_student_attendance_graph_report_data()
{
	$filter_val = $_REQUEST['filter_val'];
	global $wpdb;
	$table_attendance = $wpdb->prefix . 'smgt_sub_attendance';
	$table_class = $wpdb->prefix . 'smgt_class';
	if ($filter_val == "today") {
		$start_date = date('Y-m-d');
		$end_date = date('Y-m-d');
		$value = 'Today';
	} elseif ($filter_val == "this_week") {
		//check the current day
		if (date('D') != 'Mon') {
			//take the last monday
			$start_date = date('Y-m-d', strtotime('last sunday'));
		} else {
			$start_date = date('Y-m-d');
		}
		//always next saturday
		if (date('D') != 'Sat') {
			$end_date = date('Y-m-d', strtotime('next saturday'));
		} else {
			$end_date = date('Y-m-d');
		}
		$value = 'This Week';
	} elseif ($filter_val == "last_week") {
		$previous_week = strtotime("-1 week +1 day");
		$start_week = strtotime("last sunday midnight", $previous_week);
		$end_week = strtotime("next saturday", $start_week);
		$start_date = date("Y-m-d", $start_week);
		$end_date = date("Y-m-d", $end_week);
		$value = 'Last Week';
	} elseif ($filter_val == "this_month") {
		$start_date = date('Y-m-d', strtotime('first day of this month'));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'This Month';
	} elseif ($filter_val == "last_month") {
		$start_date = date('Y-m-d', strtotime("first day of previous month"));
		$end_date =  date('Y-m-d', strtotime("last day of previous month"));
		$value = 'Last Month';
	} elseif ($filter_val == "last_3_month") {
		$month_date =  date('Y-m-d', strtotime('-2 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'Last 3 Month';
	} elseif ($filter_val == "last_6_month") {
		$month_date =  date('Y-m-d', strtotime('-5 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'Last 6 Month';
	} elseif ($filter_val == "last_12_month") {
		$month_date =  date('Y-m-d', strtotime('-11 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d', strtotime('last day of this month'));
		$value = 'Last 12 Month';
	} elseif ($filter_val == "this_year") {
		$start_date = date("Y-01-01", strtotime("0 year"));
		$end_date = date("Y-12-t", strtotime($start_date));
		$value = 'This Year';
	} elseif ($filter_val == "last_year") {
		$start_date = date("Y-01-01", strtotime("-1 year"));
		$end_date = date("Y-12-t", strtotime($start_date));
		$value = 'Last Year';
	}
	$school_obj = new School_Management(get_current_user_id());
	if ($school_obj->role == 'teacher') {
		$teacher_id = get_current_user_id();
		$classes = smgt_get_class_by_teacher_id($teacher_id);
		$unique_array = [];
		if (!empty($classes)) {
			foreach ($classes as $class) {
				$class_id = $class->class_id;
				$query = "SELECT at.class_id,
								 SUM(CASE WHEN `status` ='Present' THEN 1 ELSE 0 END) AS Present,
								 SUM(CASE WHEN `status` ='Absent' THEN 1 ELSE 0 END) AS Absent
						  FROM $table_attendance AS at
							   JOIN $table_class AS cl ON at.class_id = cl.class_id
						  WHERE `attendance_date` BETWEEN '$start_date' AND '$end_date'
							AND at.class_id = $class_id
							AND at.role_name = 'student'
						  GROUP BY at.class_id";
				$result = $wpdb->get_results($query);
				$unique_array = array_merge($unique_array, $result);
			}
		}
		$report_2 = array_unique($unique_array, SORT_REGULAR);
	} else {
		$report_2 = $wpdb->get_results("SELECT  at.class_id,
		SUM(case when `status` ='Present' then 1 else 0 end) as Present,
		SUM(case when `status` ='Absent' then 1 else 0 end) as Absent
		from $table_attendance as at,$table_class as cl where `attendance_date` BETWEEN '$start_date' AND '$end_date' AND at.class_id = cl.class_id AND at.role_name = 'student' GROUP BY at.class_id");
	}
	$chart_array = array();
	$chart_array[] = array(esc_attr__('Class', 'school-mgt'), esc_attr__('Present', 'school-mgt'), esc_attr__('Absent', 'school-mgt'));
	if (!empty($report_2)) {
		foreach ($report_2 as $result) {
			$class_id = mj_smgt_get_class_name($result->class_id);
			$chart_array[] = array("$class_id", (int)$result->Present, (int)$result->Absent);
		}
	}
	$options = array(
		'title' => esc_attr__("$value" . ' ' . 'Attendance Report', 'school-mgt'),
		'titleTextStyle' => array('color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
		'legend' => array(
			'position' => 'right',
			'textStyle' => array('color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;')
		),
		'hAxis' => array(
			'title' =>  esc_attr__('Class', 'school-mgt'),
			'titleTextStyle' => array('color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
			'textStyle' => array('color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
			'maxAlternation' => 2
		),
		'vAxis' => array(
			'title' =>  esc_attr__('No. of Students', 'school-mgt'),
			'minValue' => 0,
			'maxValue' => 4,
			'format' => '#',
			'titleTextStyle' => array('color' => '#4e5e6a', 'fontSize' => 16, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;'),
			'textStyle' => array('color' => '#4e5e6a', 'fontSize' => 13, 'bold' => false, 'italic' => false, 'fontName' => '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", sans-serif;')
		),
		'colors' => array('#5840bb', '#f25656')
	);
	require_once SMS_PLUGIN_DIR . '/lib/chart/GoogleCharts.class.php';
	$GoogleCharts = new GoogleCharts;
	if (!empty($report_2)) {
		$chart = $GoogleCharts->load('column', 'chart_div_last_month')->get($chart_array, $options);
	} else {
	?>
		<div class="calendar-event-new">
			<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
		</div>
	<?php
	}
	if (isset($report_2) && count($report_2) > 0) {
	?>
		<div id="chart_div_last_month" class="w-100 h-500-px"></div>
		<!-- Javascript -->
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
			<?php echo $chart; ?>
		</script>
	<?php
	}
	die();
}
add_action('wp_ajax_mj_smgt_dashboard_append_report_data', 'mj_smgt_dashboard_append_report_data');
add_action('wp_ajax_nopriv_mj_smgt_dashboard_append_report_data', 'mj_smgt_dashboard_append_report_data');
// DASHBOARD APPEND REPORT DATA
function mj_smgt_dashboard_append_report_data()
{
	$filter_val = sanitize_text_field($_REQUEST['filter_val']);
	$result = array();
	$dataPoints_2 = array();
	if ($filter_val == "this_month") {
		$list = array();
		$month = date("m");
		$current_month = date("m");
		$current_year = date("Y");
		if ($month == "2") {
			$max_d = "28";
		} elseif ($month == "4" || $month == "6" || $month == "9" || $month == "11") {
			$max_d = "30";
		} else {
			$max_d = "31";
		}
		for ($d = 1; $d <= $max_d; $d++) {
			$time = mktime(12, 0, 0, $month, $d, $year);
			if (date('m', $time) == $month)
				$date_list[] = date('Y-m-d', $time);
			$day_date[] = date('d', $time);
			$month_first_date = min($date_list);
			$month_last_date =   max($date_list);
		}
		$month = array();
		$i = 1;
		foreach ($day_date as $value) {
			$month[$i] = $value;
			$i++;
		}
		array_push($dataPoints_2, array(esc_html__('Day', 'school-mgt'), esc_html__('Fees Payment', 'school-mgt'), esc_html__('Expense', 'school-mgt')));
	} elseif ($filter_val == "last_month") {
		$list = array();
		$month = date('m', strtotime("first day of previous month"));
		$current_month = date('m', strtotime("first day of previous month"));
		$current_year =  date('Y', strtotime("last day of previous month"));
		if ($month == "2") {
			$max_d = "28";
		} elseif ($month == "4" || $month == "6" || $month == "9" || $month == "11") {
			$max_d = "30";
		} else {
			$max_d = "31";
		}
		for ($d = 1; $d <= $max_d; $d++) {
			$time = mktime(12, 0, 0, $month, $d, $year);
			if (date('m', $time) == $month)
				$date_list[] = date('Y-m-d', $time);
			$day_date[] = date('d', $time);
			$month_first_date = min($date_list);
			$month_last_date =   max($date_list);
		}
		$month = array();
		$i = 1;
		foreach ($day_date as $value) {
			$month[$i] = $value;
			$i++;
		}
		array_push($dataPoints_2, array(esc_html__('Day', 'school-mgt'), esc_html__('Fees Payment', 'school-mgt'), esc_html__('Expense', 'school-mgt')));
	} elseif ($filter_val == "this_year") {
		$current_year = Date("Y");
		$month = array('1' => esc_html__('January', 'school-mgt'), '2' => esc_html__('February', 'school-mgt'), '3' => esc_html__('March', 'school-mgt'), '4' => esc_html__('April', 'school-mgt'), '5' => esc_html__('May', 'school-mgt'), '6' => esc_html__('June', 'school-mgt'), '7' => esc_html__('July', 'school-mgt'), '8' => esc_html__('August', 'school-mgt'), '9' => esc_html__('September', 'school-mgt'), '10' => esc_html__('October', 'school-mgt'), '11' => esc_html__('November', 'school-mgt'), '12' => esc_html__('December', 'school-mgt'),);
		array_push($dataPoints_2, array(esc_html__('Month', 'school-mgt'), esc_html__('Fees Payment', 'school-mgt'), esc_html__('Expense', 'school-mgt')));
	} elseif ($filter_val == "last_year") {
		$start_date = date("Y-01-01", strtotime("-1 year"));
		$current_year = date("Y", strtotime($start_date));
		$month = array('1' => esc_html__('January', 'school-mgt'), '2' => esc_html__('February', 'school-mgt'), '3' => esc_html__('March', 'school-mgt'), '4' => esc_html__('April', 'school-mgt'), '5' => esc_html__('May', 'school-mgt'), '6' => esc_html__('June', 'school-mgt'), '7' => esc_html__('July', 'school-mgt'), '8' => esc_html__('August', 'school-mgt'), '9' => esc_html__('September', 'school-mgt'), '10' => esc_html__('October', 'school-mgt'), '11' => esc_html__('November', 'school-mgt'), '12' => esc_html__('December', 'school-mgt'),);
		array_push($dataPoints_2, array(esc_html__('Month', 'school-mgt'), esc_html__('Fees Payment', 'school-mgt'), esc_html__('Expense', 'school-mgt')));
	}
	$dataPoints_1 = array();
	$expense_array = array();
	$currency_symbol = MJ_smgt_get_currency_symbol(get_option('smgt_currency_code'));
	foreach ($month as $key => $value) {
		global $wpdb;
		$table_name = $wpdb->prefix . "smgt_income_expense";
		$fees_table_name = $wpdb->prefix . "smgt_fees_payment";
		if ($filter_val == "last_month" || $filter_val == "this_month") {
			$q = $wpdb->prepare(
				"SELECT * FROM $fees_table_name WHERE YEAR(paid_by_date) = %d AND MONTH(paid_by_date) = %d AND DAY(paid_by_date) = %d",
				$current_year,
				$current_month,
				$value
			);

			$q1 = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(income_create_date) = %d AND MONTH(income_create_date) = %d AND DAY(income_create_date) = %d AND invoice_type = %s",
				$current_year,
				$current_month,
				$value,
				'expense'
			);
		} else {
			$q = $wpdb->prepare(
				"SELECT * FROM $fees_table_name WHERE YEAR(paid_by_date) = %d AND MONTH(paid_by_date) = %d",
				$current_year,
				$key
			);

			$q1 = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE YEAR(income_create_date) = %d AND MONTH(income_create_date) = %d AND invoice_type = %s",
				$current_year,
				$key,
				'expense'
			);
		}
		$result = $wpdb->get_results($q);
		$result1 = $wpdb->get_results($q1);
		// EXPENSE ENTRY //
		$expense_yearly_amount = 0;
		foreach ($result1 as $expense_entry) {
			$all_entry = json_decode($expense_entry->entry);
			$amount = 0;
			if (!empty($all_entry)) {
				foreach ($all_entry as $entry) {
					$amount += $entry->amount;
				}
			}
			$expense_yearly_amount += $amount;
		}
		$expense_amount = $expense_yearly_amount;
		// END EXPENSE ENTRY //
		// FEES PAYMENT ENTRY //
		$income_yearly_amount = 0;
		if (!empty($result)) {
			foreach ($result as $retrieved_data) {
				$income_amount = $retrieved_data->total_amount;
				$income_yearly_amount += $income_amount;
			}
		}
		$income_amount = $income_yearly_amount;
		// END FEES PAYMENT ENTRY //
		$expense_array[] = $expense_amount;
		$income_array[] = $income_amount;
		array_push($dataPoints_2, array($value, $income_amount, $expense_amount));
	}
	$new_array = json_encode($dataPoints_2);
	$income_filtered = array_filter($income_array);
	$expense_filtered = array_filter($expense_array);
	if (!empty($income_filtered) || !empty($expense_filtered)) {
		$new_currency_symbol = html_entity_decode($currency_symbol);
	?>
		<script type="text/javascript" src="<?php echo SMS_PLUGIN_URL . '/assets/js/chart_loder.js'; ?>"></script>
		<script type="text/javascript">
			google.charts.load('current', {
				'packages': ['bar']
			});
			google.charts.setOnLoadCallback(drawChart);

			function drawChart() {
				var data = google.visualization.arrayToDataTable(<?php echo $new_array; ?>);
				var options = {
					bars: 'vertical', // Required for Material Bar Charts.
					colors: ['#104B73', '#FF9054'],
				};
				var chart = new google.charts.Bar(document.getElementById('barchart_material'));
				chart.draw(data, google.charts.Bar.convertOptions(options));
			}
		</script>
		<div id="barchart_material" style="width:100%;height: 280px; padding:20px;"></div>
	<?php
	} else {
	?>
		<div class="calendar-event-new">
			<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/no_data_img.png" ?>">
		</div>
	<?php
	}
	die();
}
add_action('wp_ajax_MJ_smgt_check_username_exit_or_not', 'MJ_smgt_check_username_exit_or_not');
add_action('wp_ajax_nopriv_MJ_smgt_check_username_exit_or_not', 'MJ_smgt_check_username_exit_or_not');
function MJ_smgt_check_username_exit_or_not()
{
	$username = $_POST['username'];
	if (username_exists($username)) {
		$response = 1;
	} else {
		$response = 0;
	}
	echo $response;
	die;
}
add_action('wp_ajax_MJ_smgt_check_roll_exit_or_not', 'MJ_smgt_check_roll_exit_or_not');
add_action('wp_ajax_nopriv_MJ_smgt_check_add_actionroll_exit_or_not', 'MJ_smgt_check_roll_exit_or_not');
function MJ_smgt_check_roll_exit_or_not()
{
	$roll = sanitize_text_field($_POST['roll']);
	$user = get_users(array(
		'meta_key' => 'roll_id',
		'meta_value' => $roll
	));
	if ($user) {
		$response = 1;
	} else {
		$response = 0;
	}
	echo $response;
	die;
}
add_action('wp_ajax_MJ_smgt_check_email_exit_or_not', 'MJ_smgt_check_email_exit_or_not');
add_action('wp_ajax_nopriv_MJ_smgt_check_email_exit_or_not', 'MJ_smgt_check_email_exit_or_not');
function MJ_smgt_check_email_exit_or_not()
{
	$email = $_POST['email_id'];
	if (email_exists($email)) {
		$response = 1;
	} else {
		$response = 0;
	}
	echo $response;
	die;
}
add_action('wp_ajax_mj_smgt_load_exam',  'mj_smgt_load_exam');
function mj_smgt_load_exam()
{
	$class_id = sanitize_text_field($_POST['class_id']);
	global $wpdb;
	$table_name_exam = $wpdb->prefix . "exam";
	$retrieve_exam = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name_exam WHERE class_id = %d", $class_id));

	$defaultmsg = esc_attr__('Select Exam', 'school-mgt');
	echo "<option value=''>" . $defaultmsg . "</option>";
	foreach ($retrieve_exam as $retrieved_data) {
		echo "<option value=" . $retrieved_data->exam_id . "> " . $retrieved_data->exam_name . "</option>";
	}
	exit;
}
add_action('wp_ajax_mj_smgt_load_exam_by_section',  'mj_smgt_load_exam_by_section');
function mj_smgt_load_exam_by_section()
{
	$class_id = sanitize_text_field($_POST['class_id']);
	$section_id = sanitize_text_field($_POST['section_id']);
	global $wpdb;
	$table_name_exam = $wpdb->prefix . "exam";
	if (!empty($section_id)) {
		$retrieve_exam = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name_exam WHERE class_id = %d AND section_id = %d", $class_id, $section_id));
	} else {
		$retrieve_exam = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name_exam WHERE class_id = %d", $class_id));
	}


	$defaultmsg = esc_attr__('Select Exam', 'school-mgt');
	echo "<option value=''>" . $defaultmsg . "</option>";
	if (!empty($retrieve_exam)) {
		foreach ($retrieve_exam as $retrieved_data) {
			echo "<option value=" . $retrieved_data->exam_id . "> " . $retrieved_data->exam_name . "</option>";
		}
	}
	exit;
}
add_action('wp_ajax_mj_smgt_ajax_smgt_result',  'mj_smgt_ajax_smgt_result');
function mj_smgt_ajax_smgt_result()
{
	$obj_mark = new Marks_Manage();
	$exam_obj = new smgt_exam();
	$uid = sanitize_text_field($_REQUEST['student_id']);
	$user = get_userdata($uid);
	$user_meta = get_user_meta($uid);
	$class_id = $user_meta['class_name'][0];
	$section_id = $user_meta['class_section'][0];
	$subject = $obj_mark->mj_smgt_student_subject_list($class_id, $section_id);
	$total_subject = count($subject);

	$total = 0;
	$grade_point = 0;
	$all_exam = mj_smgt_get_all_exam_by_class_id_all($class_id);
	?>
	<style>
		.modal-header {
			height: auto;
		}
	</style>
	<div class="panel-white">
		<div class="modal-header model_header_padding dashboard_model_header">
			<a href="javascript:void(0);" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
			<h4 id="myLargeModalLabel" class="modal-title"><?php echo mj_smgt_get_user_name_byid($uid); ?>'s <?php esc_attr_e('Result', 'school-mgt') ?></h4>
		</div>
		<?php

		if (!empty($all_exam)) {


		?>
			<div class="clearfix"></div>
			<div id="accordionExample" class="accordion student_accordion" aria-multiselectable="true" role="tablist">
				<?php
				$i = 0;

				foreach ($all_exam as $exam) /* #### ALL EXAM LOOP STARTS  */ {
					$exam_id = $exam->exam_id;
				?>
					<div class="mt-2 accordion-item">
						<h4 class="accordion-header" id="heading_<?php echo $i; ?>">
							<button class="accordion-button student_result_collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo $i; ?>" aria-expanded="true" aria-controls="heading_<?php echo $i; ?>">
								<div class="col-md-10 col-7">
									<span class="student_exam_result"><?php esc_attr_e('Exam Results : ', 'school-mgt'); ?></span> &nbsp;
									<span class="student_exam_name"><?php echo $exam->exam_name; ?></span>
								</div>
								<?php
								$new_marks = '';
								foreach ($subject as $sub)
								/*** ####  SUBJECT LOOPS STARTS **/
								{
									$marks = $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid);

									if (!empty($marks)) {
										$new_marks = $marks;
									}
								}

								if (!empty($new_marks)) {
								?>
									<div class="col-md-2 row justify-content-end smt_view_result">
										<div class="col-md-5 width_50">
											<a href="?page=smgt_student&print=pdf&student=<?php echo MJ_smgt_encrypt_id($uid); ?>&exam_id=<?php echo MJ_smgt_encrypt_id($exam_id); ?>" class="float_right" target="_blank"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/PDF.png" ?>" alt=""></a>
										</div>
										<div class="col-md-4 width_50 rtl_margin_left_20px exam_result_pdf_margin" style="margin-right:22px;">
											<a href="?page=smgt_student&print=print&student=<?php echo MJ_smgt_encrypt_id($uid); ?>&exam_id=<?php echo MJ_smgt_encrypt_id($exam_id); ?>" class="float_right" target="_blank"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Print.png" ?>" alt=""></a>
										</div>
									</div>
								<?php
								} else {
								?>
									<span class="student_exam_name">
										<?php esc_attr_e('No Result', 'school-mgt'); ?>
									</span>
								<?php
								}
								?>
							</button>
						</h4>
						<div id="collapse_<?php echo $i; ?>" class="accordion-collapse wizard_accordion_rtl collapse" aria-labelledby="heading_<?php echo $i; ?>" data-bs-parent="#accordionExample">
							<div class="clearfix"></div>
							<div class="clearfix"></div>
							<div class="view_result">
								<?php
								if (!empty($new_marks)) {

									$exam_data = $exam_obj->mj_smgt_exam_data($exam_id);
									$exam_marks = $exam_data->total_mark;
									$contributions = $exam_data->contributions;
									if ($contributions ==  'yes') {
										$contributions_data = $exam_data->contributions_data;
										$contributions_data_array = json_decode($contributions_data, true);
									}
								?>
									<div class="table-responsive view_result_table_responsive">
										<table class="table table-bordered">
											<tr>
												<th class="view_result_table_heading"><?php esc_attr_e('Subjects', 'school-mgt') ?></th>
												<?php
												if ($contributions ==  'yes') {
													foreach ($contributions_data_array as $con_id => $con_value) {
												?>
														<th class="view_result_table_heading"><?php echo $con_value['label'] . ' (' . $con_value['mark'] . ')'; ?></th>
													<?php
													}
													?>
													<th class="view_result_table_heading"><?php esc_attr_e('Total (' . $exam_marks . ')', 'school-mgt') ?></th>
												<?php
												} else {
												?>
													<th class="view_result_table_heading"><?php esc_attr_e('Total (' . $exam_marks . ')', 'school-mgt') ?></th>
												<?php
												}
												?>

												<th class="view_result_table_heading"><?php esc_attr_e('Grade', 'school-mgt') ?></th>
												<th class="view_result_table_heading"><?php esc_attr_e('Remarks', 'school-mgt') ?></th>
											</tr>
											<?php
											$total = 0;
											$grade_point = 0;
											$total_marks = 0;

											foreach ($subject as $sub) {
												$ob_marks = $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid) ?? 0;
											?>
												<tr>
													<td class="view_result_table_value"><?php echo esc_html($sub->sub_name); ?></td>

													<?php if ($contributions == 'yes') {
														$subject_total = 0;
														foreach ($contributions_data_array as $con_id => $con_value) {
															$mark_value = is_array($ob_marks) ? ($ob_marks[$con_id] ?? 0) : $ob_marks;
															$subject_total += $mark_value;
													?>
															<td class="view_result_table_value"><?php echo esc_html($mark_value); ?></td>
														<?php
														}
														?>
														<td class="view_result_table_value"><?php echo esc_html($subject_total); ?></td>
													<?php
													} else { ?>
														<td class="view_result_table_value"><?php echo esc_html($ob_marks); ?></td>
													<?php } ?>

													<td class="view_result_table_value">
														<?php echo esc_html($obj_mark->mj_smgt_get_grade($exam_id, $class_id, $sub->subid, $uid)); ?>
													</td>
													<td class="view_result_table_value">
														<?php echo esc_html($obj_mark->mj_smgt_get_grade_omment($exam_id, $class_id, $sub->subid, $uid)); ?>
													</td>

												</tr>

											<?php
												// Calculate total marks
												if ($contributions == 'yes') {
													foreach ($contributions_data_array as $con_id => $con_value) {
														$total_marks += is_array($ob_marks) ? ($ob_marks[$con_id] ?? 0) : $ob_marks;
													}
												} else {
													$total_marks += $ob_marks;
												}

												// Accumulate grade points
												$grade_point += $obj_mark->mj_smgt_get_grade_point($exam_id, $class_id, $sub->subid, $uid);
											}
											$exam_total_marks = $exam_marks * $total_subject;
											$total += $total_marks;
											$GPA = $grade_point / $total_subject;
											$percentage = $total / $exam_total_marks * 100;
											?>
										</table>
										<table class="table table-bordered">
											<tr>
												<th class="view_result_table_heading"><?php esc_attr_e('Marks Obtainable', 'school-mgt') ?></th>
												<th class="view_result_table_heading"><?php esc_attr_e('Marks Obtained', 'school-mgt') ?></th>
												<th class="view_result_table_heading"><?php esc_attr_e('Percentage(%)', 'school-mgt') ?></th>
												<th class="view_result_table_heading"><?php esc_attr_e('GPA', 'school-mgt') ?></th>
											</tr>
											<tr>
												<td class="view_result_table_value"><?php echo $exam_total_marks; ?></td>
												<td class="view_result_table_value"><?php echo $total; ?></td>
												<td class="view_result_table_value"><?php if (!empty($percentage)) {
																						echo number_format($percentage, 2, '.', '');
																					} else {
																						echo "-";
																					}; ?></td>
												<td class="view_result_table_value"><?php echo round($GPA, 2); ?></td>
											</tr>
										</table>

									</div>
								<?php

								} else {
								?>
									<div class="col-md-12" style="text-align:center;padding:10px;">
										<span class="student_exam_name">
											<?php esc_attr_e('No Result Available.', 'school-mgt'); ?>
										</span>
									</div>
								<?php
								}
								?>
							</div>
						</div>
					</div>
				<?php
					$i++;
				}  /* #### ALL EXAM LOOP ENDS  */ ?>
			</div>
	</div>
<?php
		} else {
?>
	<div class="modal-header model_header_padding dashboard_model_header">
		<h6 id="myLargeModalLabel"><?php echo esc_attr_e('No Result Found', 'school-mgt'); ?></h6>
	</div>
<?php
		}
		exit;
	}
	add_action('wp_ajax_mj_smgt_ajax_create_meeting',  'mj_smgt_ajax_create_meeting');
	function mj_smgt_ajax_create_meeting()
	{
		$obj_mark = new Class_routine();
		$route_id = sanitize_text_field($_REQUEST['route_id']);
		$route_data = mj_smgt_get_route_by_id($route_id);
		$start_time_data = explode(":", $route_data->start_time);
		$end_time_data = explode(":", $route_data->end_time);
		if ($start_time_data[1] == 0 or $end_time_data[1] == 0) {
			$start_time_minit = '00';
			$end_time_minit = '00';
		} else {
			$start_time_minit = $start_time_data[1];
			$end_time_minit = $end_time_data[1];
		}
		$start_time  = date("h:i A", strtotime("$start_time_data[0]:$start_time_minit $start_time_data[2]"));
		$end_time  = date("h:i A", strtotime("$end_time_data[0]:$end_time_minit $end_time_data[2]"));
?>
<style>
	.modal-header {
		height: auto;
	}
</style>
<script type="text/javascript">
	$(document).ready(function() {
		$('#meeting_form').validationEngine({
			promptPosition: "bottomLeft",
			maxErrorsPerField: 1
		});
		$("#start_date").datepicker({
			dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
			minDate: 0,
			changeYear: true,
			changeMonth: true,
			onSelect: function(selected) {
				var dt = new Date(selected);
				dt.setDate(dt.getDate() + 0);
				$("#end_date").datepicker("option", "minDate", dt);
			}
		});
		$("#end_date").datepicker({
			dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
			minDate: 0,
			changeYear: true,
			changeMonth: true,
			onSelect: function(selected) {
				var dt = new Date(selected);
				dt.setDate(dt.getDate() + 0);
				$("#start_date").datepicker("option", "maxDate", dt);
			}
		});
	});
</script>
<div class="modal-header import_csv_popup">
	<a href="#" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
	<h4 class="modal-title"><?php esc_attr_e('Create Virtual Class', 'school-mgt'); ?></h4>
</div>
<div class="panel-white">
	<div class="panel-body padding_18px_top_0">
		<form name="route_form" action="" method="post" class="form-horizontal" id="meeting_form">
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="route_id" value="<?php echo $route_id; ?>">
			<input type="hidden" name="class_id" value="<?php echo $route_data->class_id; ?>">
			<input type="hidden" name="subject_id" value="<?php echo $route_data->subject_id; ?>">
			<input type="hidden" name="class_section_id" value="<?php echo $route_data->section_name; ?>">
			<input type="hidden" name="duration" value="<?php echo $duration; ?>">
			<input type="hidden" name="weekday" value="<?php echo $route_data->weekday; ?>">
			<input type="hidden" name="start_time" value="<?php echo $start_time; ?>">
			<input type="hidden" name="end_time" value="<?php echo $end_time; ?>">
			<input type="hidden" name="teacher_id" value="<?php echo $route_data->teacher_id; ?>">
			<div class="form-body user_form "><!--user_form div-->
				<div class="row">
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="class_name" class="form-control" maxlength="50" type="text" value="<?php echo mj_smgt_get_class_name($route_data->class_id); ?>" name="class_name" disabled>
								<label class="active" for="username"><?php esc_attr_e('Class Name', 'school-mgt'); ?></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="class_section" class="form-control" maxlength="50" type="text" value="<?php echo mj_smgt_get_section_name($route_data->section_name); ?>" name="class_section" disabled>
								<label class="active" for="username"><?php esc_attr_e('Class Section', 'school-mgt'); ?></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="subject" class="form-control" type="text" value="<?php echo mj_smgt_get_single_subject_name($route_data->subject_id); ?>" name="class_section" disabled>
								<label class="active" for="username"><?php esc_attr_e('Subject', 'school-mgt'); ?></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="start_time" class="form-control" type="text" value="<?php echo $start_time; ?>" name="start_time" disabled>
								<label class="active" for="username"><?php esc_attr_e('Start Time', 'school-mgt'); ?></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="end_time" class="form-control" type="text" value="<?php echo $end_time; ?>" name="end_time" disabled>
								<label class="active" for="username"><?php esc_attr_e('End Time', 'school-mgt'); ?></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 virtual_error_msg_left_margin">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="start_date" class="form-control validate[required] text-input" type="text" name="start_date" value="<?php echo date("Y-m-d") ?>" readonly>
								<label class="active" for="username"><?php esc_attr_e('Start Date', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="end_date" class="form-control validate[required] text-input" type="text" name="end_date" value="<?php echo date("Y-m-d") ?>" readonly>
								<label class="active" for="username"><?php esc_attr_e('End Date', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-md-6 note_text_notice">
						<div class="form-group input">
							<div class="col-md-12 note_border margin_bottom_15px_res">
								<div class="form-field">
									<textarea name="agenda" class="textarea_height_47px form-control validate[custom[address_description_validation]]" maxlength="250" id=""></textarea>
									<span class="txt-title-label"></span>
									<label class="text-area address active"><?php esc_attr_e('Topic', 'school-mgt'); ?></label>
								</div>
							</div>
						</div>
					</div>
					<?php wp_nonce_field('create_meeting_admin_nonce'); ?>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="password" class="form-control validate[required,minSize[8],maxSize[12]]" type="password" value="" name="password">
								<label class="active" for="username"><?php esc_attr_e('Password', 'school-mgt'); ?><span class="required">*</span></label>
							</div>
						</div>
					</div>
				</div>
			</div><!--user_form div-->
			<div class="form-body user_form"><!--user_form div-->
				<div class="row">
					<div class="col-sm-6">
						<input type="submit" value="<?php if ($edit) {
														esc_attr_e('Save Virtual Class', 'school-mgt');
													} else {
														esc_attr_e('Create Virtual Class', 'school-mgt');
													} ?>" name="create_meeting" class="save_btn btn btn-success" />
					</div>
				</div>
			</div><!--user_form div-->
		</form>
	</div>
</div>
<?php
		exit;
	}
	add_action('wp_ajax_mj_smgt_ajax_view_meeting_detail',  'mj_smgt_ajax_view_meeting_detail');
	function mj_smgt_ajax_view_meeting_detail()
	{
		$obj_virtual_classroom = new mj_smgt_virtual_classroom;
		$meeting_id = sanitize_text_field($_REQUEST['meeting_id']);
		$class_data = $obj_virtual_classroom->mj_smgt_get_singal_meeting_data_in_zoom($meeting_id);
?>
	<script type="text/javascript">
		function copy_text() {
			// Use navigator clipboard API for better compatibility
			const textToCopy = $('.copy_text').text();
			navigator.clipboard.writeText(textToCopy).then(function() {
				// Show success message with green color
				$(".copy_link_text").css({
					"display": "block",
					"color": "green"
				});
			}).catch(function(err) {
				console.error('Error copying text: ', err);
			});
		}
	</script>
	<div class="modal-header">
		<a href="#" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Virtual Class Details', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-white form-horizontal view_notice_overflow" style="padding: 20px;">
		<div class="row">
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Meeting ID', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php echo $class_data->zoom_meeting_id; ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Meeting Title', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php echo $class_data->title; ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Class Name', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php echo smgt_get_class_section_name_wise($class_data->class_id, $class_data->section_id); ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Subject Name', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php if (!empty($class_data->subject_id)) {
														echo mj_smgt_get_single_subject_name($class_data->subject_id);
													} else {
														echo "N/A";
													} ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Teacher Name', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php if (!empty($class_data->teacher_id)) {
														echo mj_smgt_get_teacher($class_data->teacher_id);
													} else {
														echo "N/A";
													} ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Day', 'school-mgt'); ?></label><br>
				<label for="" class="label_value">
					<?php
					if ($class_data->weekday_id == '2') {
						$day = esc_attr__('Monday', 'school-mgt');
					} elseif ($class_data->weekday_id == '3') {
						$day = esc_attr__('Tuesday', 'school-mgt');
					} elseif ($class_data->weekday_id == '4') {
						$day = esc_attr__('Wednesday', 'school-mgt');
					} elseif ($class_data->weekday_id == '5') {
						$day = esc_attr__('Thursday', 'school-mgt');
					} elseif ($class_data->weekday_id == '6') {
						$day = esc_attr__('Friday', 'school-mgt');
					} elseif ($class_data->weekday_id == '7') {
						$day = esc_attr__('Saturday', 'school-mgt');
					} elseif ($class_data->weekday_id == '1') {
						$day = esc_attr__('Sunday', 'school-mgt');
					}
					echo $day;
					?>
				</label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Start To End Time', 'school-mgt'); ?></label><br>
				<label for="" class="label_value">
					<?php
					$route_data = mj_smgt_get_route_by_id($class_data->route_id);
					$stime = explode(":", $route_data->start_time);
					$start_hour = str_pad($stime[0], 2, "0", STR_PAD_LEFT);
					$start_min = str_pad($stime[1], 2, "0", STR_PAD_LEFT);
					$start_am_pm = $stime[2];
					$start_time = $start_hour . ':' . $start_min . ' ' . $start_am_pm;
					$etime = explode(":", $route_data->end_time);
					$end_hour = str_pad($etime[0], 2, "0", STR_PAD_LEFT);
					$end_min = str_pad($etime[1], 2, "0", STR_PAD_LEFT);
					$end_am_pm = $etime[2];
					$end_time = $end_hour . ':' . $end_min . ' ' . $end_am_pm;
					?>
					<?php echo MJ_smgt_timeremovecolonbefoream_pm($start_time); ?> <?php esc_html_e('To', 'school-mgt'); ?> <?php echo MJ_smgt_timeremovecolonbefoream_pm($end_time); ?>
				</label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Start To End Date', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($class_data->start_date) . " " . esc_html__("To", "school-mgt") . " " . mj_smgt_getdate_in_input_box($class_data->end_date); ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Password', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php echo $class_data->password; ?></label>
			</div>
			<div class="col-md-6 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Join Virtual Class Link', 'school-mgt'); ?></label><br>
				<div class="copy_text">
					<label for="" class="label_value word_brack"><?php echo $class_data->meeting_join_link; ?></label>
				</div>
			</div>
			<div class="col-md-12 popup_padding_15px">
				<label for="" class="popup_label_heading"><?php esc_attr_e('Agenda', 'school-mgt'); ?></label><br>
				<label for="" class="label_value"><?php if (!empty($class_data->agenda)) {
														echo $class_data->agenda;
													} else {
														echo "N/A";
													}  ?></label>
			</div>
			<div class="col-md-3">
				<button type="button" onclick="copy_text();" class="save_btn btn btn-success"><?php esc_attr_e('Copy Link', 'school-mgt'); ?></button>
			</div>
			<span class="copy_link_text" style="display:none;"><?php esc_attr_e('Link Copied Successfully', 'school-mgt'); ?></span>
		</div>
	</div>
<?php
		exit;
	}
	add_action('wp_ajax_mj_smgt_active_student',  'mj_smgt_active_student');
	function mj_smgt_active_student()
	{
		$uid = sanitize_text_field($_REQUEST['student_id']);
?>
	<div class="form-group popup_heder_marging">
		<a href="#" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title" id="myLargeModalLabel"><?php echo get_option('smgt_school_name'); ?></h4>
	</div>
	<div class="panel-body padding_15px">
		<div class="panel-heading">
			<h4 class="panel-title"><?php echo mj_smgt_get_user_name_byid($uid); ?></h4>
		</div>
		<form name="expense_form" action="" method="post" class="margin_top_15px form-horizontal" id="expense_form">
			<input type="hidden" name="act_user_id" value="<?php echo $uid; ?>">
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="roll_id" class="form-control validate[required,custom[integer]] text-input" maxlength="10" type="text" value="" name="roll_id">
								<label class="" for="roll_id"><?php esc_attr_e('Roll Number', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 padding_top_15px_res rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control checkbox_height_47px">
								<div class="row padding_radio">
									<div class="">
										<label class="custom-top-label" for="smgt_enable_homework_sms"><?php esc_attr_e('Send Mail', 'school-mgt'); ?></label>
										<input id="chk_sms_sent1" class=" check_box_input_margin" type="checkbox" <?php $smgt_student_mail_service_enable = 0;
																													if ($smgt_student_mail_service_enable) echo "checked"; ?> value="1" name="smgt_student_mail_service_enable"> <?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 padding_top_15px_res rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control checkbox_height_47px">
								<div class="row padding_radio">
									<div class="">
										<label class="custom-top-label" for="smgt_enable_homework_sms"><?php esc_attr_e('Send SMS', 'school-mgt'); ?></label>
										<input id="chk_sms_sent1" class="" type="checkbox" <?php $smgt_studnet_sms_service_enable = 0;
																							if ($smgt_studnet_sms_service_enable) echo "checked"; ?> value="1" name="smgt_studnet_sms_service_enable"> &nbsp;<?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="form-body user_form margin_top_15px"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Active Student', 'school-mgt'); ?>" name="active_user" class="btn save_btn" />
					</div>
				</div>
			</div>
		</form>
	</div>
<?php
		die();
	}
	add_action('wp_mj_smgt_ajax_smgt_result_pdf',  'mj_smgt_ajax_smgt_result_pdf');
	function mj_smgt_ajax_smgt_result_pdf()
	{
		$obj_mark = new Marks_Manage();
		$uid = sanitize_text_field($_REQUEST['student_id']);
		$user = get_userdata($uid);
		$user_meta = get_user_meta($uid);
		$class_id = $user_meta['class_name'][0];
		$subject = $obj_mark->mj_smgt_student_subject($class_id);
		$exam_id = mj_smgt_get_exam_id()->exam_id;
		$total = 0;
		$grade_point = 0;
		ob_start();
?>
	<div class="panel panel-white">
		<form method="post">
			<input type="hidden" name="student_id" value="<?php echo $uid; ?>">
			<button id="pdf" type="button"><?php esc_attr_e('PDF', 'school-mgt'); ?> </button>
		</form>
		<p class="student_name">
			<?php esc_attr_e('Result', 'school-mgt'); ?>
		</p>
		<div class="clearfix panel-heading">
			<h4 class="panel-title"><?php echo mj_smgt_get_user_name_byid($uid); ?></h4>
		</div>
		<div class="panel-body">
			<div class="table-responsive">
				<table class="table table-bordered">
					<tr>
						<th><?php esc_attr_e('Subject', 'school-mgt'); ?></th>
						<th><?php esc_attr_e('Obtain Mark', 'school-mgt'); ?></th>
						<th><?php esc_attr_e('Grade', 'school-mgt'); ?></th>
						<th><?php esc_attr_e('Attendance', 'school-mgt'); ?></th>
						<th><?php esc_attr_e('Comment', 'school-mgt'); ?></th>
					</tr>
					<?php
					foreach ($subject as $sub) {
					?>
						<tr>
							<td><?php echo $sub->sub_name; ?></td>
							<td><?php echo $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid); ?> </td>
							<td><?php echo $obj_mark->mj_smgt_get_grade($exam_id, $class_id, $sub->subid, $uid); ?></td>
							<td><?php echo $obj_mark->mj_smgt_get_attendance($exam_id, $class_id, $sub->subid, $uid); ?></td>
							<td><?php echo $obj_mark->mj_smgt_get_marks_comment($exam_id, $class_id, $sub->subid, $uid); ?></td>
						</tr>
					<?php
						$total +=  $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid);
						$grade_point += $obj_mark->mj_smgt_get_grade_point($exam_id, $class_id, $sub->subid, $uid);
					}
					$GPA = $grade_point / $total_subject; ?>
				</table>
			</div>
		</div>
		<hr />
		<?php echo "GPA is" . $GPA; ?>
		<p class="result_total"><?php esc_attr_e("Total Marks", "school-mgt") . "=>" . $total; ?></p>
		<hr />
		<p class="result_point">
			<?php esc_attr_e("GPA(grade point average)", "school-mgt") . "=> " . $grade_point;	?>
		</p>
		<hr />
	<?php
		$out_put = ob_get_contents();
		ob_end_clean();
		require_once SMS_PLUGIN_DIR . '/lib/mpdf/vendor/autoload.php';
		$mpdf = new Mpdf\Mpdf;
		$mpdf->WriteHTML($out_put);
		$mpdf->Output('filename.pdf', 'F');
		unset($out_put);
		unset($mpdf);
		exit;
	}
	add_action('wp_ajax_mj_smgt_load_user',  'mj_smgt_load_user');
	add_action('wp_ajax_nopriv_mj_smgt_load_user',  'mj_smgt_load_user');
	function mj_smgt_load_user()
	{
		$class_id = sanitize_text_field($_REQUEST['class_list']);
		if (empty($class_id)) {
			$defaultmsg = esc_attr__('Select Student', 'school-mgt');
			echo "<option value=''>" . $defaultmsg . "</option>";
		} else {
			global $wpdb;
			$exlude_id = mj_smgt_approve_student_list();
			$retrieve_data = get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id, 'role' => 'student', 'exclude' => $exlude_id));
			$defaultmsg = esc_attr__('Select Student', 'school-mgt');
			echo "<option value=''>" . $defaultmsg . "</option>";
			foreach ($retrieve_data as $users) {
				echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
			}
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_load_section_user',  'mj_smgt_load_section_user');
	add_action('wp_ajax_nopriv_mj_smgt_load_section_user',  'mj_smgt_load_section_user');
	function mj_smgt_load_section_user()
	{
		$section_id = sanitize_text_field($_POST['section_id']);
		$class_id = sanitize_text_field($_POST['class_id']);
		if (empty($section_id)) {
			global $wpdb;
			$exlude_id = mj_smgt_approve_student_list();
			$retrieve_data = get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id, 'role' => 'student', 'exclude' => $exlude_id));
			$defaultmsg = esc_attr__('Select Student', 'school-mgt');
			echo "<option value=''>" . $defaultmsg . "</option>";
			foreach ($retrieve_data as $users) {
				echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
			}
			die();
		} else {
			global $wpdb;
			$exlude_id = mj_smgt_approve_student_list();
			$retrieve_data = get_users(array('meta_key' => 'class_section', 'meta_value' => $section_id, 'role' => 'student', 'exclude' => $exlude_id));
			$defaultmsg = esc_attr__('Select student', 'school-mgt');
			echo "<option value=''>" . $defaultmsg . "</option>";
			foreach ($retrieve_data as $users) {
				echo "<option value=" . $users->ID . ">" . mj_smgt_student_display_name_with_roll($users->ID) . "</option>";
			}
			die();
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_load_books',  'mj_smgt_load_books');
	function mj_smgt_load_books()
	{
		$cat_id = sanitize_text_field($_POST['bookcat_id']);
		global $wpdb;
		$table_book = $wpdb->prefix . 'smgt_library_book';
		$retrieve_data = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_book WHERE cat_id = %d AND quentity != %d", $cat_id, 0));
		foreach ($retrieve_data as $book) {
			echo "<option value=" . $book->id . ">" . stripslashes($book->book_name) . '(' . $book->quentity . ')' . "</option>";
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_load_class_fee_type',  'mj_smgt_load_class_fee_type');
	function mj_smgt_load_class_fee_type()
	{
		$class_list = sanitize_text_field($_POST['class_list']);
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix . 'smgt_fees';
		$result = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM $table_smgt_fees WHERE class_id = %s",
				$class_list
			)
		);

		//$defaultmsg= esc_attr__( 'Select Fee Type' , 'school-mgt');
		//echo '<option value="">'.$defaultmsg.'</option>';
		if (!empty($result)) {
			foreach ($result as $retrive_data) {
				echo '<option value="' . $retrive_data->fees_id . '">' . get_the_title($retrive_data->fees_title_id) . '</option>';
			}
		} else {
			//$defaultmsg= esc_attr__( 'Select Fee Type' , 'school-mgt');
			//echo '<option value="">'.$defaultmsg.'</option>';
			return false;
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_load_section_fee_type',  'mj_smgt_load_section_fee_type');
	function mj_smgt_load_section_fee_type()
	{
		$section_id = sanitize_text_field($_POST['section_id']);
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix . 'smgt_fees';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_smgt_fees where section_id =%d", $section_id));
		$defaultmsg = esc_attr__('Select Fee Type', 'school-mgt');
		echo "<option value=' '>" . $defaultmsg . "</option>";
		if (!empty($result)) {
			foreach ($result as $retrive_data) {
				echo '<option value="' . $retrive_data->fees_id . '">' . get_the_title($retrive_data->fees_title_id) . '</option>';
			}
		} else
			return false;
		die();
	}
	add_action('wp_ajax_mj_smgt_load_fee_type_amount',  'mj_smgt_load_fee_type_amount');
	add_action('wp_ajax_nopriv_mj_smgt_load_fee_type_amount', 'mj_smgt_load_fee_type_amount');
	function mj_smgt_load_fee_type_amount()
	{
		$fees_id = $_POST['fees_id'];
		global $wpdb;
		$table_smgt_fees = $wpdb->prefix . 'smgt_fees';
		$fees_amount = array();
		if (!empty($fees_id)) {
			foreach ($fees_id as $id) {
				$fees_id = intval($id);
				$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_smgt_fees where fees_id =%d", $fees_id));
				$fees_amount[] = $result->fees_amount;
			}
		}
		echo array_sum($fees_amount);
		die();
	}
	add_action('wp_ajax_mj_smgt_verify_pkey', 'mj_smgt_verify_pkey');
	function mj_smgt_verify_pkey()
	{
		$api_server = 'license.dasinfomedia.com';
		$fp = fsockopen($api_server, 80, $errno, $errstr, 2);
		$location_url = admin_url() . 'admin.php?page=smgt_school';
		if (!$fp)
			$server_rerror = 'Down';
		else
			$server_rerror = "up";
		if ($server_rerror == "up") {
			$domain_name = $_SERVER['SERVER_NAME'];
			$licence_key = $_REQUEST['licence_key'];
			$email = $_REQUEST['enter_email'];
			$data['domain_name'] = $domain_name;
			$data['licence_key'] = $licence_key;
			$data['enter_email'] = $email;
			$result = mj_smgt_check_productkey($domain_name, $licence_key, $email);
			if ($result == '1') {
				$message = esc_attr__('Please provide correct Envato purchase key.', 'school-mgt');
				$_SESSION['cmgt_verify'] = '1';
			} elseif ($result == '2') {
				$message = 'This purchase key is already registered with the different domain. If have any issue please contact us at sales@mojoomla.com';
				$_SESSION['cmgt_verify'] = '2';
			} elseif ($result == '3') {
				$message = 'There seems to be some problem please try after sometime or contact us on sales@mojoomla.com';
				$_SESSION['cmgt_verify'] = '3';
			} elseif ($result == '4') {
				$message = esc_attr__('Please provide correct Envato purchase key for this plugin.', 'school-mgt');
				$_SESSION['cmgt_verify'] = '4';
			} else {
				update_option('domain_name', $domain_name, true);
				update_option('licence_key', $licence_key, true);
				update_option('cmgt_setup_email', $email, true);
				$message = 'Success fully register';
				$_SESSION['cmgt_verify'] = '0';
			}
			$result_array = array('message' => $message, 'cmgt_verify' => $_SESSION['cmgt_verify'], 'location_url' => $location_url);
			echo json_encode($result_array);
		} else {
			$message = 'Server is down Please wait some time';
			$_SESSION['cmgt_verify'] = '3';
			$result_array = array('message' => $message, 'cmgt_verify' => $_SESSION['cmgt_verify'], 'location_url' => $location_url);
			echo json_encode($result_array);
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_view_notice',  'mj_smgt_ajax_smgt_view_notice');
	function mj_smgt_ajax_smgt_view_notice()
	{
		$notice = get_post($_REQUEST['notice_id']);
	?>
		<div class="form-group popup_heder_marging">
			<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/notice_1.png";  ?>" alt="" class="popup_image_before_name">
			<a href="#" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
			<h4 class="modal-title" id="myLargeModalLabel">
				<?php esc_attr_e('Notice Detail', 'school-mgt'); ?>
			</h4>
		</div>
		<div class="modal-body view_details_body_assigned_bed view_details_body">
			<div class="row">
				<div class="col-md-6 popup_padding_15px">
					<label for="" class="popup_label_heading"><?php esc_attr_e('Title', 'school-mgt'); ?></label><br>
					<label for="" class="label_value"><?php echo $notice->post_title; ?></label>
				</div>
				<div class="col-md-6 popup_padding_15px">
					<label for="" class="popup_label_heading"><?php esc_attr_e('Start Date To End Date', 'school-mgt'); ?></label><br>
					<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box(get_post_meta($notice->ID, 'start_date', true)); ?> <?php esc_attr_e('To', 'school-mgt'); ?> <?php echo mj_smgt_getdate_in_input_box(get_post_meta($notice->ID, 'end_date', true)); ?> </label>
				</div>
				<div class="col-md-6 popup_padding_15px">
					<label for="" class="popup_label_heading"><?php esc_attr_e('Notice For', 'school-mgt'); ?></label><br>
					<label for="" class="label_value"><?php echo esc_attr_e(ucfirst(get_post_meta($notice->ID, 'notice_for', true)), 'school-mgt'); ?></label>
				</div>
				<div class="col-md-6 popup_padding_15px">
					<label for="" class="popup_label_heading"><?php esc_attr_e('Class Name', 'school-mgt'); ?></label><br>
					<label for="" class="label_value">
						<?php
						if (get_post_meta($notice->ID, 'smgt_class_id', true) != "" && get_post_meta($notice->ID, 'smgt_class_id', true) == "all") {
							esc_attr_e('All', 'school-mgt');
						} elseif (get_post_meta($notice->ID, 'smgt_class_id', true) != "") {
							echo mj_smgt_get_class_name(get_post_meta($notice->ID, 'smgt_class_id', true));
						} ?>
					</label>
				</div>
				<div class="col-md-12 popup_padding_15px">
					<label for="" class="popup_label_heading"><?php esc_attr_e('Comment', 'school-mgt'); ?></label><br>
					<label for="" class="label_value">
						<?php
						if (!empty($notice->post_content)) {
							echo $notice->post_content;
						} else {
							echo "N/A";
						}
						?>
					</label>
				</div>
			</div>
		</div>
		<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_sms_service_setting',  'mj_smgt_sms_service_setting');
	function mj_smgt_sms_service_setting()
	{
		$select_serveice = $_POST['select_serveice'];
		if ($select_serveice == 'clickatell') {
			$clickatell = get_option('smgt_clickatell_sms_service');
		?>
			<div class="form-body user_form">
				<div class="row">
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="username" class="form-control validate[required]" type="text" value="<?php if (isset($clickatell['username'])) echo $clickatell['username']; ?>" name="username">
								<label class="active" for="username"><?php esc_attr_e('Username', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="password" class="form-control validate[required]" type="text" value="<?php if (isset($clickatell['password'])) echo $clickatell['password']; ?>" name="password">
								<label class="active" for="password"><?php esc_attr_e('Password', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="api_key" class="form-control validate[required]" type="text" value="<?php if (isset($clickatell['api_key'])) echo $clickatell['api_key']; ?>" name="api_key">
								<label class="active" for="api_key"><?php esc_attr_e('API Key', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="sender_id" class="form-control validate[required]" type="text" value="<?php if (isset($clickatell['sender_id'])) echo $clickatell['sender_id']; ?>" name="sender_id">
								<label class="active" for="sender_id"><?php esc_attr_e('Sender Id', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php
		}
		if ($select_serveice == 'twillo') {
			$twillo = get_option('smgt_twillo_sms_service');
		?>
			<div class="mb-3 form-group row">
				<label class="col-sm-2 control-label col-form-label text-md-end active" for="account_sid"><?php esc_attr_e('Account SID', 'school-mgt'); ?><span class="require-field">*</span></label>
				<div class="col-sm-8">
					<input id="account_sid" class="form-control validate[required]" type="text" value="<?php if (isset($twillo['account_sid'])) echo $twillo['account_sid']; ?>" name="account_sid">
				</div>
			</div>
			<div class="mb-3 form-group row">
				<label class="col-sm-2 control-label col-form-label text-md-end active" for="auth_token"><?php esc_attr_e('Auth Token', 'school-mgt'); ?><span class="require-field">*</span></label>
				<div class="col-sm-8">
					<input id="auth_token" class="form-control validate[required] text-input" type="text" name="auth_token" value="<?php if (isset($twillo['auth_token'])) echo $twillo['auth_token']; ?>">
				</div>
			</div>
			<div class="mb-3 form-group row">
				<label class="col-sm-2 control-label col-form-label text-md-end active" for="from_number"><?php esc_attr_e('From Number', 'school-mgt'); ?><span class="require-field">*</span></label>
				<div class="col-sm-8">
					<input id="from_number" class="form-control validate[required] text-input" type="text" name="from_number" value="<?php if (isset($twillo['from_number'])) echo $twillo['from_number']; ?>">
				</div>
			</div>
		<?php }
		if ($select_serveice == 'msg91') {
			$msg91 = get_option('smgt_msg91_sms_service');
		?>
			<div class="form-body user_form">
				<div class="row">
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="sms_auth_key" class="form-control validate[required]" type="text" value="<?php echo $msg91['sms_auth_key']; ?>" name="sms_auth_key">
								<label class="active" for="sms_auth_key"><?php esc_attr_e('Authentication Key', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="msg91_senderID" class="form-control validate[required] text-input" type="text" name="msg91_senderID" value="<?php echo $msg91['msg91_senderID']; ?>">
								<label class="active" for="msg91_senderID"><?php esc_attr_e('SenderID ', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="wpnc_sms_route" class="form-control validate[required] text-input" type="text" name="wpnc_sms_route" value="<?php echo $msg91['wpnc_sms_route']; ?>">
								<label class="active" for="wpnc_sms_route"><?php esc_attr_e('Route', 'school-mgt'); ?><span class="require-field">*</span></label>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_student_invoice_view',  'mj_smgt_student_invoice_view');
	function mj_smgt_student_invoice_view()
	{
		$obj_invoice = new Smgtinvoice();
		if ($_POST['invoice_type'] == 'invoice') {
			$invoice_data = mj_smgt_get_payment_by_id($_POST['idtest']);
		}
		if ($_POST['invoice_type'] == 'income') {
			$income_data = $obj_invoice->mj_smgt_get_income_data($_POST['idtest']);
		}
		if ($_POST['invoice_type'] == 'expense') {
			$expense_data = $obj_invoice->mj_smgt_get_income_data($_POST['idtest']);
		} ?>
		<div class="modal-header model_header_padding dashboard_model_header">
			<a href="javascript:void(0);" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
			<h4 id="myLargeModalLabel" class="modal-title"><?php echo get_option('smgt_school_name'); ?></h4>
		</div>
		<div class="modal-body invoice_model_body float_left_width_100 " style="height: 380px;">
			<img class="invoiceimage float_left invoice_image_model" src="<?php echo plugins_url('/school-management/assets/images/listpage_icon/invoice.png'); ?>" width="100%">
			<div id="invoice_print" class="main_div float_left_width_100 payment_invoice_popup_main_div">
				<div class="invoice_width_100 float_left" border="0">
					<div class="row">
						<div class="col-md-1 col-sm-2 col-xs-3">
							<div class="width_1">
								<img class="system_logo" src="<?php echo esc_url(get_option('smgt_school_logo')); ?>">
							</div>
						</div>
						<div class="col-md-11 col-sm-10 col-xs-9 invoice_address invoice_address_css">
							<div class="row">
								<div class="col-md-1 col-sm-2 col-xs-3 address_css padding_right_0">
									<label class="popup_label_heading"><?php esc_html_e('Address :', 'school-mgt');
																		$address_length = strlen(get_option('smgt_school_address'));
																		if ($address_length > 120) {
																		?>
											<BR><BR><BR><BR><BR>
										<?php
																		} elseif ($address_length > 90) {
										?>
											<BR><BR><BR><BR>
										<?php
																		} elseif ($address_length > 60) { ?>
											<BR><BR><BR>
										<?php
																		} elseif ($address_length > 30) { ?>
											<BR><BR>
										<?php
																		}
										?>
									</label>
								</div>
								<div class="col-md-9 col-sm-8 col-xs-7">
									<label for="" class="label_value"> <?php
																		echo chunk_split(get_option('smgt_school_address'), 42, "<BR>") . "";
																		?></label>
								</div>
							</div>
							<div class="row invoice_padding_bottom_15px">
								<div class="col-md-1 col-sm-2 col-xs-3 address_css padding_right_0">
									<label class="popup_label_heading"><?php esc_html_e('Email :', 'school-mgt'); ?> </label>
								</div>
								<div class="col-md-10 col-sm-8 col-xs-7">
									<label for="" class="label_value"><?php echo get_option('smgt_email'), "<BR>";  ?></label>
								</div>
							</div>
							<div class="row invoice_padding_bottom_15px">
								<div class="col-md-1 col-sm-2 col-xs-3 address_css padding_right_0">
									<label class="popup_label_heading"><?php esc_html_e('Phone :', 'school-mgt'); ?> </label>
								</div>
								<div class="col-md-10 col-sm-8 col-xs-7">
									<label for="" class="label_value"><?php echo get_option('smgt_contact_number') . "<br>";  ?></label>
								</div>
							</div>
							<div align="right" class="width_24"></div>
						</div>
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xl-12 mozila_display_css">
					<div class="row">
						<div class="width_50a1 float_left_width_100">
							<div class="col-md-8 col-sm-8 col-xs-5 padding_0 float_left display_grid margin_bottom_20px">
								<div class="billed_to display_flex invoice_address_heading">
									<?php
									$issue_date = 'DD-MM-YYYY';
									if (!empty($income_data)) {
										$issue_date = $income_data->income_create_date;
										$payment_status = $income_data->payment_status;
									}
									if (!empty($invoice_data)) {
										$issue_date = $invoice_data->date;
										$payment_status = $invoice_data->payment_status;
									}
									if (!empty($expense_data)) {
										$issue_date = $expense_data->income_create_date;
										$payment_status = $expense_data->payment_status;
									}
									?>
									<h3 class="billed_to_lable invoice_model_heading" style="width: 20%;"><?php esc_html_e('Bill To', 'school-mgt'); ?> : </h3>
									<?php
									if (!empty($expense_data)) {
										$party_name = $expense_data->supplier_name;
										echo "<h3 class='display_name invoice_width_100'>" . chunk_split(ucwords($party_name), 30, "<BR>") . "</h3>";
									} else {
										if (!empty($income_data))
											$student_id = $income_data->supplier_name;
										if (!empty($invoice_data))
											$student_id = $invoice_data->student_id;
										$patient = get_userdata($student_id);
										echo "<h3 class='display_name invoice_width_100'>" . chunk_split(ucwords($patient->display_name), 30, "<BR>") . "</h3>";
									}
									?>
								</div>
								<div class="width_60b2 address_information_invoice">
									<?php
									if (!empty($expense_data)) {
										$party_name = $expense_data->supplier_name;
										echo "<h3 class='display_name invoice_width_100'>" . chunk_split(ucwords($party_name), 30, "<BR>") . "</h3>";
									} else {
										if (!empty($income_data))
											$student_id = $income_data->supplier_name;
										if (!empty($invoice_data))
											$student_id = $invoice_data->student_id;
										$patient = get_userdata($student_id);
										// echo "<h3 class='display_name invoice_width_100'>".chunk_split(ucwords($patient->display_name),30,"<BR>"). "</h3>";
										$address = get_user_meta($student_id, 'address', true);
										echo chunk_split($address, 30, "<BR>");
										echo get_user_meta($student_id, 'city', true) . "," . "<BR>";;
										echo get_user_meta($student_id, 'zip_code', true) . ",<BR>";
									}
									?>
								</div>
							</div>
							<div class="col-md-3 col-sm-4 col-xs-7 float_left">
								<div class="width_50a1112">
									<div class="width_20c" align="center">
										<?php
										if (!empty($invoice_data)) {
										}
										?>
										<h5 class="align_left"> <label class="popup_label_heading text-transfer-upercase"><?php echo esc_html__('Date :', 'school-mgt') ?> </label>&nbsp; <label class="invoice_model_value"><?php echo mj_smgt_getdate_in_input_box(date("Y-m-d", strtotime($issue_date))); ?></label></h5>
										<h5 class="align_left"><label class="popup_label_heading text-transfer-upercase"><?php echo esc_html__('Status :', 'school-mgt') ?> </label> &nbsp;<label class="invoice_model_value"><?php
																																																								if ($payment_status == 'Paid') {
																																																									echo '<span class="green_color">' . esc_attr__('Fully Paid', 'school-mgt') . '</span>';
																																																								}
																																																								if ($payment_status == 'Part Paid') {
																																																									echo '<span class="perpal_color">' . esc_attr__('Partially Paid', 'school-mgt') . '</span>';
																																																								}
																																																								if ($payment_status == 'Unpaid') {
																																																									echo '<span class="red_color">' . esc_attr__('Not Paid', 'school-mgt') . '</span>';
																																																								} ?></h5>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<table class="width_100">
					<tbody>
						<tr>
							<td>
								<?php
								if (!empty($invoice_data)) {
								?>
									<h3 class="display_name"><?php esc_attr_e('Invoice Entries', 'school-mgt'); ?></h3>
								<?php
								} elseif (!empty($income_data)) {
								?>
									<h3 class="display_name"><?php esc_attr_e('Income Entries', 'school-mgt'); ?></h3>
								<?php
								} elseif (!empty($expense_data)) {
								?>
									<h3 class="display_name"><?php esc_attr_e('Expense Entries', 'school-mgt'); ?></h3>
								<?php
								}
								?>
							<td>
						</tr>
					</tbody>
				</table>
				<table class="table model_invoice_table">
					<thead class="entry_heading invoice_model_entry_heading">
						<tr>
							<th class="entry_table_heading align_center">#</th>
							<th class="entry_table_heading align_center"> <?php esc_attr_e('Date', 'school-mgt'); ?></th>
							<th class="entry_table_heading align_center"><?php esc_attr_e('Entry', 'school-mgt'); ?> </th>
							<th class="entry_table_heading align_center"><?php esc_attr_e('Price', 'school-mgt'); ?></th>
							<th class="entry_table_heading align_center"> <?php esc_attr_e('Issue By', 'school-mgt'); ?> </th>
						</tr>
					</thead>
					<tbody>
						<?php
						$id = 1;
						$total_amount = 0;
						if (!empty($income_data) || !empty($expense_data)) {
							if (!empty($expense_data)) {
								$income_data = $expense_data;
							}
							$patient_all_income = $obj_invoice->mj_smgt_get_onepatient_income_data($income_data->supplier_name);
							foreach ($patient_all_income as $result_income) {
								$income_entries = json_decode($result_income->entry);
								foreach ($income_entries as $each_entry) {
									$total_amount += $each_entry->amount;
						?>
									<tr>
										<td class="align_center invoice_table_data"><?php echo $id; ?></td>
										<td class="align_center invoice_table_data"><?php echo $result_income->income_create_date; ?></td>
										<td class="align_center invoice_table_data"><?php echo $each_entry->entry; ?> </td>
										<td class="align_center invoice_table_data"> <?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($each_entry->amount, 2, '.', '')); ?></td>
										<td class="align_center invoice_table_data"><?php echo mj_smgt_get_display_name($result_income->create_by); ?></td>
									</tr>
							<?php
									$id += 1;
								}
							}
						}
						if (!empty($invoice_data)) {
							$total_amount = $invoice_data->amount
							?>
							<tr>
								<td class="align_center invoice_table_data"><?php echo $id; ?></td>
								<td class="align_center invoice_table_data"><?php echo date("Y-m-d", strtotime($invoice_data->date)); ?></td>
								<td class="align_center invoice_table_data"><?php echo $invoice_data->payment_title; ?> </td>
								<td class="align_center invoice_table_data"> <?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($invoice_data->amount, 2, '.', '')); ?></td>
								<td class="align_center invoice_table_data"><?php echo mj_smgt_get_display_name($invoice_data->payment_reciever_id); ?></td>
							</tr>
						<?php
						} ?>
					</tbody>
				</table>
				<?php
				if (!empty($invoice_data)) {
					$grand_total = $total_amount;
				}
				if (!empty($income_data)) {
					$grand_total = $total_amount;
				}
				?>
				<div class="row col-md-12 grand_total_main_div margin_top_20px">
					<div class="row col-md-6 col-sm-6 col-xs-6 print-button pull-left invoice_print_pdf_btn">
						<div class="col-md-2 print_btn_rs">
							<a href="?page=smgt_payment&print=print&invoice_id=<?php echo $_POST['idtest']; ?>&invoice_type=<?php echo $_POST['invoice_type']; ?>" target="_blank" class="btn color_white btn save_btn invoice_btn_div"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/print.png" ?>"> </a>
						</div>
						<div class="col-md-3 pdf_btn_rs">
							<a href="?page=smgt_payment&print=pdf&invoice_id=<?php echo $_POST['idtest']; ?>&invoice_type=<?php echo $_POST['invoice_type']; ?>" target="_blank" class="btn color_white invoice_btn_div btn save_btn"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/pdf.png" ?>"></a>
						</div>
					</div>
					<div class="row col-md-6 col-sm-6 col-xs-6 view_invoice_lable_css float_left grand_total_div invoice_table_grand_total" style="float: right;">
						<div class="align_right col-md-6 col-sm-6 col-xs-6 view_invoice_lable padding_11 padding_right_0_left_0 float_left grand_total_label_div invoice_model_height line_height_1_5 padding_left_0_px">
							<h3 class="padding color_white margin invoice_total_label"><?php esc_html_e('Grand Total', 'school-mgt'); ?> </h3>
						</div>
						<div class="align_right col-md-6 col-sm-6 col-xs-6 view_invoice_lable  padding_right_5_left_5 padding_11 float_left grand_total_amount_div">
							<h3 class="padding margin text-right color_white invoice_total_value" style="float: right;"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($grand_total, 2, '.', '')); ?></h3>
						</div>
					</div>
				</div>
				<div class="margin_top_20px"></div>
			</div>
		</div>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_student_add_payment',  'mj_smgt_student_add_payment');
	function mj_smgt_student_add_payment()
	{
		$fees_pay_id = $_POST['idtest'];
		$due_amount = $_POST['due_amount'];
		$student_id = $_POST['student_id'];
		$max_due_amount = str_replace(",", "", $_POST['due_amount']);
?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#expense_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
		});
	</script>
	<div class="modal-header model_header_padding dashboard_model_header" style="margin-bottom: 20px;">
		<a href="javascript:void(0);" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 id="myLargeModalLabel" class="modal-title"><?php echo get_option('smgt_school_name'); ?></h4>
	</div>
	<div class="panel-white" style="padding: 20px;">
		<form name="expense_form" action="" method="post" class="form-horizontal" id="expense_form">
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="fees_pay_id" value="<?php echo $fees_pay_id; ?>">
			<input type="hidden" name="payment_status" value="paid">
			<div class="form-body user_form">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="amount" class="form-control validate[required,min[0],max[<?php echo $max_due_amount; ?>],maxSize[10]] text-input" type="number" step="0.01" value="<?php echo $max_due_amount; ?>" name="amount">
								<label for="userinput1" class="active"><?php esc_html_e('Paid Amount', 'school-mgt'); ?>(<?php echo mj_smgt_get_currency_symbol(); ?>)<span class="required">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-md-6 input">
						<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Payment By', 'school-mgt'); ?><span class="required">*</span></label>
						<?php global $current_user;
						$user_roles = $current_user->roles;
						$user_role = array_shift($user_roles);
						?>
						<select name="payment_method" id="payment_method" class="font_transform_capitalization form-control select_height_47px">
							<?php
							if ($user_role != 'student' and $user_role != 'parent') { ?>
								<option value="Cash"><?php esc_attr_e('Cash', 'school-mgt'); ?></option>
								<option value="Cheque"><?php esc_attr_e('Cheque', 'school-mgt'); ?></option>
								<option value="Bank Transfer"><?php esc_attr_e('Bank Transfer', 'school-mgt'); ?></option>
								<?php
							} else {
								if (is_plugin_active('paymaster/paymaster.php') && get_option('smgt_paymaster_pack') == "yes") {
									$payment_method = get_option('pm_payment_method');
									print '<option value="' . $payment_method . '" class="font_transform_capitalization">' . $payment_method . '</option>';
								} else { ?>
									<option value="Paypal"><?php esc_attr_e('Paypal', 'school-mgt'); ?></option>
							<?php
								}
							}
							?>
						</select>
					</div>

					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 note_border margin_bottom_15px_res">
								<div class="form-field">
									<textarea name="payment_note" cols="50" rows="2" class="textarea_height_47px form-control validate[required,custom[address_description_validation]]" maxlength="250" id=""></textarea>
									<span class="txt-title-label"></span>
									<label class="text-area address active"><?php esc_attr_e('Note', 'school-mgt'); ?><span class="require-field">*</span></label>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="form-body user_form">
				<div class="row">
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Add Payment', 'school-mgt'); ?>" name="add_feetype_payment" class="btn btn-success save_btn" />
					</div>
				</div>
			</div>
		</form>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_student_view_paymenthistory',  'mj_smgt_student_view_paymenthistory');
	function mj_smgt_student_view_paymenthistory()
	{
?>
	<script>
		function mj_smgt_PrintElem(elem) {
			mj_smgt_Popup($('<div/>').append($(elem).clone()).html());
		}

		function mj_smgt_Popup(data) {
			var mywindow = window.open('', 'my div', 'height=500,width=700');
			mywindow.document.write('<html><head><title>Fees Payment Invoice</title>');
			mywindow.document.write('<link rel="stylesheet" href="<?php echo $path; ?>" type="text/css" />');
			mywindow.document.write('</head><body class="test_print">');
			mywindow.document.write(data);
			mywindow.document.write('</body></html>');
			mywindow.document.close(); // necessary for IE >= 104
			mywindow.focus(); // necessary for IE >= 10
			mywindow.print();
			mywindow.focus();
			return true;
		}
	</script>
	<?php
		$fees_pay_id = $_REQUEST['idtest'];
		$fees_detail_result = mj_smgt_get_single_fees_payment_record($fees_pay_id);
		$fees_history_detail_result = mj_smgt_get_payment_history_by_feespayid($fees_pay_id);
		$obj_feespayment = new mj_smgt_feespayment();
	?>
	<div class="background_image_print" style="background-image: url(<?php echo SMS_PLUGIN_URL . '/assets/images/Invoice-BG.png' ?>);">
		<div class="modal-body">
			<div class="modal-header">
				<a href="#" class="close-btn-cat badge badge-success float-end"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
				<h4 class="modal-title"><?php echo get_option('smgt_school_name'); ?></h4>
			</div>
			<div id="invoice_print" class="print-box" width="100%">
				<table width="100%" border="0">
					<tbody>
						<tr>
							<td width="70%">
								<img style="max-height:80px;" src="<?php echo get_option('smgt_school_logo'); ?>">
							</td>
							<td align="right" width="24%">
								<h5><?php
									$issue_date = 'DD-MM-YYYY';
									$issue_date = $fees_detail_result->paid_by_date;
									echo esc_attr__('Issue Date', 'school-mgt') . " : " . mj_smgt_getdate_in_input_box(date("Y-m-d", strtotime($issue_date))); ?></h5>
								<h5><?php echo esc_attr__('Status', 'school-mgt') . " : ";
									$payment_status = mj_smgt_get_payment_status($fees_detail_result->fees_pay_id);
									if ($payment_status == 'Fully Paid') {
										echo "<span class='btn btn-success btn-xs' style='color: green;'>";
										echo esc_attr__('Fully Paid', 'school-mgt');
									}
									if ($payment_status == 'Partially Paid') {
										echo "<span class='btn partially_paid_button_color btn-xs' style='color: purple;'>";
										echo esc_attr__('Partially Paid', 'school-mgt');
									}
									if ($payment_status == 'Not Paid') {
										echo "<span class='btn btn-danger btn-xs' style='color: red;'>";
										echo esc_attr__('Not Paid', 'school-mgt');
									}
									echo "</span>"; ?></h5>
							</td>
						</tr>
					</tbody>
				</table>
				<hr class="hr_margin_new color_black">
				<table width="100%" border="0">
					<tbody>
						<tr>
							<td class="col-md-6">
								<h4><?php esc_attr_e('Payment From', 'school-mgt'); ?> </h4>
							</td>
							<td class="col-md-6 pull-right" style="text-align: right;">
								<h4><?php esc_attr_e('Bill To', 'school-mgt'); ?> </h4>
							</td>
						</tr>
						<tr>
							<td valign="top" class="col-md-6">
								<?php echo get_option('smgt_school_name') . "<br>";
								echo get_option('smgt_school_address') . ",";
								echo get_option('smgt_contry') . "<br>";
								echo get_option('smgt_contact_number') . "<br>";
								?>
							</td>
							<td valign="top" class="col-md-6" style="text-align: right;">
								<?php
								$student_id = $fees_detail_result->student_id;
								$patient = get_userdata($student_id);
								if ($patient) {
									echo $patient->display_name . "<br>";
									echo 'Student ID' . ' <b>' . get_user_meta($student_id, 'roll_id', true) . "</b><br>";
									echo get_user_meta($student_id, 'address', true) . ",";
									echo get_user_meta($student_id, 'city', true) . "," . "<BR>";;
									echo get_user_meta($student_id, 'zip_code', true) . ",<BR>";
									echo get_user_meta($student_id, 'state', true) . ",";
									echo get_option('smgt_contry') . ",";
									echo get_user_meta($student_id, 'mobile', true) . "<br>";
								}
								?>
							</td>
						</tr>
					</tbody>
				</table>
				<hr class="hr_margin_new color_black">
				<div class="table-responsive">
					<div>
						<h4 class="invoice_entries_css"><?php esc_attr_e('Invoice Entries', 'school-mgt'); ?></h4>
					</div>
					<table class="table table-bordered" width="100%" border="1" style="border-collapse:collapse;">
						<thead>
							<tr>
								<th class="text-center padding_10">#</th>
								<th class="text-center padding_10"><?php esc_attr_e('Date', 'school-mgt'); ?></th>
								<th class="text-center padding_10"> <?php esc_attr_e('Fees Type', 'school-mgt'); ?></th>
								<th class="padding_10"><?php esc_attr_e('Total', 'school-mgt'); ?> </th>
							</tr>
						</thead>
						<?php
						$fees_id = explode(',', $fees_detail_result->fees_id);
						$x = 1;
						foreach ($fees_id as $id) {
						?>
							<tbody>
								<td class="text-center"> <?php echo $x; ?></td>
								<td class="text-center"> <?php echo mj_smgt_getdate_in_input_box($fees_detail_result->created_date); ?></td>
								<td class="text-center"> <?php echo mj_smgt_get_fees_term_name($id); ?></td>
								<td><?php
									$amount = $obj_feespayment->mj_smgt_feetype_amount_data($id);
									echo MJ_smgt_currency_symbol_position_language_wise(number_format($amount, 2, '.', ''));
									?></td>
							</tbody>
						<?php
							$x++;
						}
						?>
					</table>
				</div>
				<table width="100%" border="0">
					<tbody>
						<tr>
							<td align="right"><?php esc_attr_e('Sub Total :', 'school-mgt'); ?></td>
							<td align="right"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($fees_detail_result->total_amount, 2, '.', '')); ?></td>
						</tr>
						<tr>
							<td width="80%" align="right"><?php esc_attr_e('Payment Made :', 'school-mgt'); ?></td>
							<td align="right"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($fees_detail_result->fees_paid_amount, 2, '.', '')); ?></td>
						</tr>
						<tr>
							<td width="80%" align="right"><?php esc_attr_e('Due Amount :', 'school-mgt'); ?></td>
							<?php $Due_amount = $fees_detail_result->total_amount - $fees_detail_result->fees_paid_amount; ?>
							<td align="right"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($Due_amount, 2, '.', '')); ?></td>
						</tr>
					</tbody>
				</table>
				<hr class="hr_margin_new color_black">
				<?php if (!empty($fees_history_detail_result)) { ?>
					<h4><?php esc_attr_e('Payment History', 'school-mgt'); ?></h4>
					<table class="table table-bordered" width="100%" border="1" style="border-collapse:collapse;">
						<thead>
							<tr>
								<th class="text-center padding_10"><?php esc_attr_e('Date', 'school-mgt'); ?></th>
								<th class="text-center padding_10"> <?php esc_attr_e('Amount', 'school-mgt'); ?></th>
								<th class="padding_10"><?php esc_attr_e('Method', 'school-mgt'); ?> </th>
							</tr>
						</thead>
						<tbody>
							<?php
							foreach ($fees_history_detail_result as  $retrive_date) {
							?>
								<tr>
									<td class="text-center"><?php echo mj_smgt_getdate_in_input_box($retrive_date->paid_by_date); ?></td>
									<td class="text-center"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($retrive_date->amount, 2, '.', '')); ?></td>
									<td><?php $data = $retrive_date->payment_method;
										echo esc_attr__("$data", "school-mgt");
										?>
									</td>
								</tr>
							<?php } ?>
						</tbody>
					</table>
				<?php } ?>
			</div>
			<div class="print-button align-center">
				<input type="button" value="<?php esc_attr_e('Print', 'school-mgt'); ?>" class="btn btn-success" onclick="mj_smgt_PrintElem('#invoice_print')" />
				&nbsp;&nbsp;&nbsp;
				<a href="?page=smgt_fees_payment&print=pdf&payment_id=<?php echo MJ_smgt_encrypt_id($_POST['idtest']); ?>&fee_paymenthistory=<?php echo "fee_paymenthistory"; ?>" target="_blank" class="btn btn-success"><?php esc_attr_e('PDF', 'school-mgt'); ?></a>
			</div>
		</div>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_student_view_librarryhistory',  'mj_smgt_student_view_librarryhistory');
	function mj_smgt_student_view_librarryhistory()
	{
		$student_id = sanitize_text_field($_REQUEST['student_id']);
		$booklist = mj_smgt_get_student_lib_booklist($student_id);
		$student = get_userdata($student_id);
?>
	<div class="modal-header model_header_padding dashboard_model_header">
		<a href="javascript:void(0);" class="event_close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 id="myLargeModalLabel" class="modal-title"><?php echo $student->display_name; ?></h4>
	</div>
	<div class="panel-white libraryhistory_panal_white_div"><!----------  panel-white div------------>
		<div class="modal-body"><!----------  Model Body div------------>
			<div id="invoice_print" class="table-responsive">
				<?php
				if (!empty($booklist)) {
				?>
					<table class="table table-bordered" style="border: 1px solid #D9E1ED;text-align: center;margin-bottom: 0px;" width="100%">
						<thead>
							<tr>
								<th class="exam_hall_receipt_table_heading" style="border-top: medium none;border-right: 1px solid #D9E1ED;background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"><?php esc_attr_e('Book Title', 'school-mgt'); ?></th>
								<th class="exam_hall_receipt_table_heading" style="border-right: 1px solid #D9E1ED;background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"> <?php esc_attr_e('Issue Date', 'school-mgt'); ?></th>
								<th class="exam_hall_receipt_table_heading" style="border-right: 1px solid #D9E1ED;background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"> <?php esc_attr_e('Return Date', 'school-mgt'); ?></th>
								<th class="exam_hall_receipt_table_heading" style="border-right: 1px solid #D9E1ED;background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"> <?php esc_attr_e('Accept Return Date', 'school-mgt'); ?></th>
								<th class="exam_hall_receipt_table_heading" style="border-right: 1px solid #D9E1ED;background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"><?php esc_attr_e('Period', 'school-mgt'); ?> </th>
								<th class="exam_hall_receipt_table_heading" style="border-right: 1px solid #D9E1ED;background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"><?php esc_attr_e('Overdue By', 'school-mgt'); ?> </th>
								<th class="exam_hall_receipt_table_heading" style="background-color: #F2F5FA;border-bottom: 1px solid #D9E1ED;text-align: center;"><?php esc_attr_e('Fine', 'school-mgt'); ?> </th>
							</tr>
						</thead>
						<tbody>
							<?php
							foreach ($booklist as  $retrieved_data) {
							?>
								<tr style="border: 1px solid #D9E1ED;">
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;"><?php echo stripslashes(mj_smgt_get_bookname($retrieved_data->book_id)); ?></td>
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;"><?php echo mj_smgt_getdate_in_input_box($retrieved_data->issue_date); ?></td>
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;"><?php echo mj_smgt_getdate_in_input_box($retrieved_data->end_date); ?></td>
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;"><?php echo mj_smgt_getdate_in_input_box($retrieved_data->actual_return_date); ?></td>
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;"><?php echo get_the_title($retrieved_data->period) . esc_attr__(" Days", "school-mgt"); ?></td>
									<?php
									$date1 = date_create(date('Y-m-d'));
									$date2 = date_create(date("Y-m-d", strtotime($retrieved_data->end_date)));
									$diff = date_diff($date2, $date1);
									?>
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;">
										<?php
										if ($retrieved_data->actual_return_date == '' && $date1 < $date2) {
											echo esc_attr__("0 Days", "school-mgt");
										} elseif ($date2 > $date3 && $retrieved_data->actual_return_date != '') {
											echo esc_attr__("0 Days", "school-mgt");
										} elseif ($date1 > $date2) {
											echo $diff->format("%a") . esc_attr__(" Days", "school-mgt");
										}
										?>
									</td>
									<td class="exam_hall_receipt_table_value" style="border-right: 1px solid #D9E1ED;"><?php echo ($retrieved_data->fine != "" || $retrieved_data->fine != 0) ? mj_smgt_get_currency_symbol() . $retrieved_data->fine : "N/A"; ?></td>
								</tr>
							<?php
							}
							?>
						</tbody>
					</table>
				<?php
				} ?>
			</div>
		</div>
	</div><!----------  Model Body div------------>
	</div><!----------  panel-white div------------>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_add_remove_feetype',  'mj_smgt_add_remove_feetype');
	add_action('wp_ajax_nopriv_mj_smgt_add_remove_feetype',  'mj_smgt_add_remove_feetype');
	function mj_smgt_add_remove_feetype()
	{
		$model = sanitize_text_field($_REQUEST['model']);
		$class_id = sanitize_text_field($_REQUEST['class_id']);
		mj_smgt_add_category_type($model, $class_id);
	}
	add_action('wp_ajax_mj_smgt_add_fee_type',  'mj_smgt_add_fee_type');
	function mj_smgt_add_fee_type()
	{
		global $wpdb;
		$model = sanitize_text_field($_REQUEST['model']);
		$class_id = sanitize_text_field($_REQUEST['class_id']);
		$array_var = array();
		$data['category_name'] = mj_smgt_strip_tags_and_stripslashes($_REQUEST['fee_type']);
		$dlt_image = SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png";
		$edit_image = SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png";
		if ($model == 'feetype') {
			$obj_fees = new Smgt_fees();
			$obj_fees->mj_smgt_add_feetype($data);
			$id = $wpdb->insert_id;
			$row1 = '<div class="row new_popup_padding" id="cat-' . $id . '"><div class="col-md-11" >' . stripslashes($_REQUEST['fee_type']) . '</div><div class="row col-md-1"><div class="col-md-12"><a href="#" class="btn-delete-cat" model="' . $model . '" id="' . $id . '"><img src="' . $dlt_image . '" alt=""></a></a></div></div></div>';
			$option = "<option value='$id'>" . stripslashes($_REQUEST['fee_type']) . "</option>";
		}
		if ($model == 'book_cat') {
			$obj_lib = new Smgtlibrary();
			$cat_result = $obj_lib->mj_smgt_add_bookcat($data);
			$id = $wpdb->insert_id;
			$row1 = '<tr id="cat-' . $id . '"><td>' . stripslashes($_REQUEST['fee_type']) . '</td><td><a class="btn-delete-cat badge badge-delete" href="#" id=' . $id . '>X</a></td></tr>';
			$option = "<option value='$id'>" . stripslashes($_REQUEST['fee_type']) . "</option>";
		}
		if ($model == 'rack_type') {
			$obj_lib = new Smgtlibrary();
			$cat_result = $obj_lib->mj_smgt_add_rack($data);
			$id = $wpdb->insert_id;
			$row1 = '<div class="row new_popup_padding" id="cat-' . $id . '"><div class="col-md-11" >' . stripslashes($_REQUEST['fee_type']) . '</div><div class="row col-md-1"><div class="col-md-12"><a href="#" class="btn-delete-cat" model="' . $model . '" id="' . $id . '"><img src="' . $dlt_image . '" alt=""></a></a></div></div></div>';
			$option = "<option value='$id'>" . stripslashes($_REQUEST['fee_type']) . "</option>";
		}
		if ($model == 'period_type') {
			$obj_lib = new Smgtlibrary();
			$cat_result = $obj_lib->mj_smgt_add_period($data);
			$id = $wpdb->insert_id;
			$row1 = '<div class="row new_popup_padding" id="cat-' . $id . '"><div class="col-md-11" >' . stripslashes($_REQUEST['fee_type']) . ' ' . esc_attr__('Days', 'school-mgt') . '</div><div class="row col-md-1"><div class="col-md-12"><a href="#" class="btn-delete-cat" model="' . $model . '" id="' . $id . '"><img src="' . $dlt_image . '" alt=""></a></a></div></div></div>';
			$option = "<option value='$id'>" . stripslashes($_REQUEST['fee_type']) . " " . esc_attr__('Days', 'school-mgt') . "</option>";
		}
		if ($model == 'class_sec') {
			$error = '';
			$class_id = $_REQUEST['class_id'];
			$section = $_REQUEST['fee_type'];
			global $wpdb;
			$class_section_table = $wpdb->prefix . 'smgt_class_section';
			// Use prepared statement to prevent SQL injection
			$prepared_statement = $wpdb->prepare(
				"SELECT * FROM $class_section_table WHERE class_id = %d AND section_name = %s",
				$class_id,
				$section
			);
			$section_list = $wpdb->get_results($prepared_statement);
			if (empty($section_list)) {
				$sectiondata['class_id'] = $class_id;
				$sectiondata['section_name'] = $section;
				$tablename = "smgt_class_section";
				$result = mj_smgt_add_class_section($tablename, $sectiondata);
				$id = $wpdb->insert_id;
				$row1 = '<div class="row new_popup_padding" id="cat-' . $id . '"><div class="col-md-10 width_70" >' . stripslashes($_REQUEST['fee_type']) . '</div>
			<div class="row col-md-2 padding_left_0_res width_30"><div class="col-md-6 width_50_res padding_left_0"><a href="#" class="btn-delete-cat" model="' . $model . '" id="' . $id . '"><img src="' . $dlt_image . '" alt=""></a></div>
			<div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0"><a class="btn-edit-cat"  model="' . $model . '" href="#" id="' . $id . '"><img src="' . $edit_image . '" alt=""></a></div>
			</div></div>';
				$option = "<option value='$id'>" . stripslashes($_REQUEST['fee_type']) . "</option>";
			} else {
				$error = 1;
			}
		}
		$array_var[] = $row1;
		$array_var[] = $option;
		$array_var[2] = $error;
		echo json_encode($array_var);
		die();
	}
	add_action('wp_ajax_mj_smgt_remove_feetype',  'mj_smgt_remove_feetype');
	add_action('wp_ajax_nopriv_mj_smgt_remove_feetype',  'mj_smgt_remove_feetype');
	function mj_smgt_remove_feetype()
	{
		// Check if user is logged in
		if (!is_user_logged_in()) {
			wp_send_json_error(['message' => 'Unauthorized access'], 403);
			exit;
		}

		// Check user role
		$role = mj_smgt_get_user_role(get_current_user_id());
		$allowed_roles = ["management", "administrator", "supportstaff", "teacher"];
		if (!in_array($role, $allowed_roles)) {
			wp_send_json_error(['message' => 'Permission denied'], 403);
			exit;
		}

		// Verify nonce
		if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'mj_smgt_nonce')) {
			wp_send_json_error(['message' => 'Invalid security token'], 403);
			exit;
		}

		// Validate and sanitize inputs
		if (!isset($_POST['cat_id']) || !is_numeric($_POST['cat_id'])) {
			wp_send_json_error(['message' => 'Invalid category ID'], 400);
			exit;
		}

		$cat_id = intval($_POST['cat_id']);
		$model = isset($_POST['model']) ? sanitize_text_field($_POST['model']) : '';

		// Perform deletion based on model type
		switch ($model) {
			case 'feetype':
				$obj_fees = new Smgt_fees();
				$deleted = $obj_fees->mj_smgt_delete_fee_type($cat_id);
				break;
			case 'book_cat':
			case 'rack_type':
			case 'period_type':
				$obj_lib = new Smgtlibrary();
				$method = 'mj_smgt_delete_' . str_replace('_', '', $model);
				$deleted = method_exists($obj_lib, $method) ? $obj_lib->$method($cat_id) : false;
				break;
			case 'class_sec':
				$deleted = mj_smgt_delete_class_section($cat_id);
				break;
			default:
				wp_send_json_error(['message' => 'Invalid model type'], 400);
				exit;
		}

		// Return response
		if ($deleted) {
			wp_send_json_success(['message' => 'Deleted successfully']);
		} else {
			wp_send_json_error(['message' => 'Failed to delete item'], 500);
		}
		exit;
	}
	add_action('wp_ajax_mj_smgt_update_section',  'mj_smgt_update_section');
	function mj_smgt_update_section()
	{
		$model = '';
		global $wpdb;
		$smgt_class_section = $wpdb->prefix . 'smgt_class_section';
		$data['section_name'] = $_POST['section_name'];
		$data_id['id'] = $_POST['cat_id'];
		$result = $wpdb->update($smgt_class_section, $data, $data_id);
		$retrieved_data = mj_smgt_single_section($_POST['cat_id']);
?>
	<div class="col-md-10 width_70">
		<?php
		echo $retrieved_data->section_name;
		?>
	</div>
	<div class="row col-md-2 padding_left_0_res width_30" id="<?php echo $retrieved_data->id; ?>">
		<div class="col-md-6 width_50_res padding_left_0">
			<a href="#" class="btn-delete-cat" model="<?php echo $model; ?>" id="<?php echo $retrieved_data->id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></a>
		</div>
		<div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0">
			<a class="btn-edit-cat" model="<?php echo $model; ?>" href="#" id="<?php echo $retrieved_data->id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png" ?>" alt=""></a>
		</div>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_update_cancel_section',  'mj_smgt_update_cancel_section');
	function mj_smgt_update_cancel_section()
	{
		global $wpdb;
		$smgt_class_section = $wpdb->prefix . 'smgt_class_section';
		$retrieved_data = mj_smgt_single_section($_POST['cat_id']);
?>
	<div class="col-md-10 width_70">
		<?php
		echo $retrieved_data->section_name;
		?>
	</div>
	<div class="row col-md-2 padding_left_0_res width_30" id="<?php echo $retrieved_data->id; ?>">
		<div class="col-md-6 width_50_res padding_left_0">
			<a href="#" class="btn-delete-cat" model="<?php echo $model; ?>" id="<?php echo $retrieved_data->id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></a>
		</div>
		<div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0">
			<a class="btn-edit-cat" model="<?php echo $model; ?>" href="#" id="<?php echo $retrieved_data->id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png" ?>" alt=""></a>
		</div>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_get_book_return_date',  'mj_smgt_get_book_return_date');
	function mj_smgt_get_book_return_date()
	{
		$period_days = get_the_title($_REQUEST['issue_period']);
		$date = date_create($_REQUEST['issue_date']);
		$olddate = date_format($date, 'Y-m-d');
		$new_date =  date('Y-m-d', strtotime($olddate . ' + ' . $period_days . 'Days'));
		echo mj_smgt_getdate_in_input_box($new_date);
		die();
	}
	add_action('wp_ajax_mj_smgt_accept_return_book',  'mj_smgt_accept_return_book');
	function mj_smgt_accept_return_book()
	{
?>
	<SCRIPT language=Javascript>
		function isNumberKey(evt) {
			var charCode = (evt.which) ? evt.which : event.keyCode
			if (charCode > 31 && (charCode < 48 || charCode > 57))
				return false;
			return true;
		}

		jQuery(document).ready(function($) {
			$('#issue_book-return').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.datepicker').datepicker({
				dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
				minDate: 0,
				changeMonth: true,
				changeYear: true,
				beforeShow: function(textbox, instance) {
					instance.dpDiv.css({
						marginTop: (-textbox.offsetHeight) + 'px'
					});
				}
			});
		});
	</SCRIPT>
	<?php
		$id = $_REQUEST['idtest'];
		global $wpdb;
		$table_issuebook = $wpdb->prefix . 'smgt_library_book_issue';
		$booklist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_issuebook WHERE id = %d AND status = %s", $id, 'Issue'));

	?>
	<div class="modal-header model_header_padding dashboard_model_header">
		<a href="javascript:void(0);" class="event_close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 id="myLargeModalLabel" class="modal-title"><?php echo esc_html__("Confirm Return Books", "school-mgt") ?></h4>
	</div>
	<div class="panel-white libraryhistory_panal_white_div"><!----------  panel-white div------------>
		<div class="modal-body"><!----------  Model Body div------------>
			<div id="invoice_print" class="exam_table_res table-responsive">
				<?php
				if (!empty($booklist)) {
				?>
					<form name="issue_book-return" method="post" id="issue_book-return">
						<input type="hidden" name="issue_book_id" value="<?php echo $id; ?>">
						<div class="form-body user_form">
							<div class="row">
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="return_date" class="datepicker form-control validate[required] text-input" type="text" name="return_date" value="<?php echo mj_smgt_getdate_in_input_box(date('Y-m-d')); ?>" readonly>
											<label class="active" for="return_date"><?php esc_attr_e('Return Date', 'school-mgt'); ?><span class="require-field">*</span></label>
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
									<div class="form-group input rtl_margin_0px">
										<div class="col-md-12 form-control">
											<input type="number" min="0" class="validate[required,min[0],maxSize[5]] number form-control" onkeypress="return isNumberKey(event)" name="fine" value="">
											<label class="active" for="Fine"><?php esc_attr_e('Fine', 'school-mgt'); ?>(<?php echo mj_smgt_get_currency_symbol(); ?>)<span class="require-field">*</span></label>
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group input">
										<div class="col-md-12 note_border margin_bottom_15px_res">
											<div class="form-field">
												<textarea name="comment" cols="50" rows="2" class="textarea_height_47px form-control validate[required,custom[address_description_validation]]" maxlength="250" id=""></textarea>
												<span class="txt-title-label"></span>
												<label class="text-area address active"><?php esc_attr_e('Comment', 'school-mgt'); ?><span class="require-field">*</span></label>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="form-body user_form">
							<div class="row">
								<div class="col-sm-6">
									<input type="submit" value="<?php esc_attr_e('Return Book', 'school-mgt'); ?>" name="return_book" class="btn btn-success save_btn" />
								</div>
							</div>
						</div>

					</form>
				<?php
				} ?>
			</div>
		</div>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_load_class_section',  'mj_smgt_load_class_section');
	add_action('wp_ajax_nopriv_mj_smgt_load_class_section',  'mj_smgt_load_class_section');
	function mj_smgt_load_class_section()
	{
		$class_id = sanitize_text_field($_POST['class_id']);
		global $wpdb;
		$retrieve_data = mj_smgt_get_class_sections($_POST['class_id']);
		$defaultmsg = esc_attr__('All Section', 'school-mgt');
		echo "<option value=''>" . $defaultmsg . "</option>";
		foreach ($retrieve_data as $section) {
			echo "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_load_class_section_add_student',  'mj_smgt_load_class_section_add_student');
	add_action('wp_ajax_nopriv_mj_smgt_load_class_section_add_student',  'mj_smgt_load_class_section_add_student');
	function mj_smgt_load_class_section_add_student()
	{
		$class_id = sanitize_text_field($_POST['class_id']);

		global $wpdb;
		$retrieve_data = mj_smgt_get_class_sections($_POST['class_id']);
		$defaultmsg = esc_attr__('Select Section', 'school-mgt');
		echo "<option value=''>" . $defaultmsg . "</option>";
		foreach ($retrieve_data as $section) {
			echo "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
		}
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_load_section_subject',  'mj_smgt_load_section_subject');
	add_action('wp_ajax_mj_smgt_load_section_subject',  'mj_smgt_load_section_subject');
	function mj_smgt_load_section_subject()
	{
		$section_id = sanitize_text_field($_POST['section_id']);
		global $wpdb;
		$table_name = $wpdb->prefix . "subject";
		$user_id = get_current_user_id();
		//------------------------TEACHER ACCESS---------------------------------//
		$teacher_access = get_option('smgt_access_right_teacher');
		$teacher_access_data = $teacher_access['teacher'];
		foreach ($teacher_access_data as $key => $value) {
			if ($key == 'subject') {
				$data = $value;
			}
		}
		if (mj_smgt_get_roles($user_id) == 'teacher' && $data['own_data'] == '1') {
			$retrieve_subject = $wpdb->get_results(
				$wpdb->prepare("SELECT * FROM $table_name WHERE teacher_id = %d AND section_id = %d", $user_id, $section_id)
			);
		} else {
			$retrieve_subject = $wpdb->get_results(
				$wpdb->prepare("SELECT * FROM $table_name WHERE section_id = %d", $section_id)
			);
		}
		$defaultmsg = esc_attr__('Select subject', 'school-mgt');
		echo "<option value=''>" . $defaultmsg . "</option>";
		foreach ($retrieve_subject as $retrieved_data) {
			echo "<option value=" . $retrieved_data->subid . "> " . $retrieved_data->sub_name . '-' . $retrieved_data->subject_code . "</option>";
		}
		exit;
	}
	add_action('wp_ajax_nopriv_mj_smgt_load_class_student',  'mj_smgt_load_class_student');
	add_action('wp_ajax_mj_smgt_load_class_student',  'mj_smgt_load_class_student');
	function mj_smgt_load_class_student()
	{
		$class_list = sanitize_text_field($_REQUEST['class_list']);
		$args = array(
			'role' => 'student',
			'meta_key' => 'class_name',
			'meta_value' => $class_list
		);
		$result = get_users($args);
		foreach ($result as $key => $value) {
			print "Yes";
		}
		exit;
	}
	add_action('wp_ajax_mj_smgt_notification_user_list', 'mj_smgt_notification_user_list');
	function mj_smgt_notification_user_list()
	{
		$school_obj = new School_Management(get_current_user_id());
		$class_list = isset($_REQUEST['class_list']) ? $_REQUEST['class_list'] : '';
		$class_section = isset($_REQUEST['class_section']) ? $_REQUEST['class_section'] : '';
		$exlude_id = mj_smgt_approve_student_list();
		$html_class_section = '';
		$return_results['section'] = '';
		$user_list = array();
		global $wpdb;
		$defaultmsg = esc_attr__('All', 'school-mgt');
		$html_class_section =  "<option value='All'>" . $defaultmsg . "</option>";
		if ($class_list != '') {
			$retrieve_data = mj_smgt_get_class_sections($class_list);
			if ($retrieve_data)
				foreach ($retrieve_data as $section) {
					$html_class_section .= "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
				}
		}
		$query_data['exclude'] = $exlude_id;
		if ($class_section != 'All' && $class_section != '') {
			$query_data['meta_key'] = 'class_section';
			$query_data['meta_value'] = $class_section;
			$query_data['meta_query'] = array(array('key' => 'class_name', 'value' => $class_list, 'compare' => '='));
			$results = get_users($query_data);
		} elseif ($class_list != '') {
			$query_data['meta_key'] = 'class_name';
			$query_data['meta_value'] = $class_list;
			$results = get_users($query_data);
		}
		if (isset($results)) {
			foreach ($results as $user_datavalue)
				$user_list[] = $user_datavalue->ID;
		}
		$user_data_list = array_unique($user_list);
		$return_results['section'] = $html_class_section;
		$return_results['users'] = '';
		$user_string  = '<select name="selected_users" id="notification_selected_users" class="line_height_30px form-control max_width_100">';
		$user_string .= '<option value="All">' . esc_attr__('All', 'school-mgt') . '</option>';
		if (!empty($user_data_list))
			foreach ($user_data_list as $retrive_data) {
				$user_string .= "<option value='" . $retrive_data . "'>" . mj_smgt_student_display_name_with_roll($retrive_data) . "</option>";
			}
		$user_string .= '</select>';
		$return_results['users'] = $user_string;
		echo json_encode($return_results);
		die();
	}
	add_action('wp_ajax_mj_smgt_document_user_list', 'mj_smgt_document_user_list');
	function mj_smgt_document_user_list()
	{
		$school_obj = new School_Management(get_current_user_id());
		$class_list = isset($_REQUEST['class_list']) ? sanitize_text_field($_REQUEST['class_list']) : '';
		$class_section = isset($_REQUEST['class_section']) ? sanitize_text_field($_REQUEST['class_section']) : '';
		$exlude_id = mj_smgt_approve_student_list();
		$html_class_section = '';
		$return_results['section'] = '';
		$user_list = array();
		global $wpdb;
		$defaultmsg = esc_attr__('All Section', 'school-mgt');
		$html_class_section =  "<option value='all section'>" . $defaultmsg . "</option>";
		if ($class_list != '') {
			$retrieve_data = mj_smgt_get_class_sections($class_list);
			if ($retrieve_data)
				foreach ($retrieve_data as $section) {
					$html_class_section .= "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
				}
		}
		$query_data['exclude'] = $exlude_id;
		if ($class_section != 'All' && $class_section != '') {
			$query_data['meta_key'] = 'class_section';
			$query_data['meta_value'] = $class_section;
			$query_data['meta_query'] = array(array('key' => 'class_name', 'value' => $class_list, 'compare' => '='));
			$results = get_users($query_data);
		} elseif ($class_list != '') {
			$query_data['meta_key'] = 'class_name';
			$query_data['meta_value'] = $class_list;
			$results = get_users($query_data);
		}
		if (isset($results)) {
			foreach ($results as $user_datavalue)
				$user_list[] = $user_datavalue->ID;
		}
		$user_data_list = array_unique($user_list);
		$return_results['section'] = $html_class_section;

		$return_results['users'] = '';
		$user_string  = '<select name="selected_users" id="notification_selected_users" class="line_height_30px form-control max_width_100">';
		$user_string .= '<option value="all student">' . esc_attr__('All Student', 'school-mgt') . '</option>';
		if (!empty($user_data_list))
			foreach ($user_data_list as $retrive_data) {
				$user_string .= "<option value='" . $retrive_data . "'>" . mj_smgt_student_display_name_with_roll($retrive_data) . "</option>";
			}
		$user_string .= '</select>';
		$return_results['users'] = $user_string;
		echo json_encode($return_results);

		die();
	}
	add_action('wp_ajax_mj_smgt_class_by_teacher', 'mj_smgt_class_by_teacher');
	function mj_smgt_class_by_teacher()
	{
		$teacher_id = sanitize_text_field($_REQUEST['teacher_id']);
		$teacher_obj = new Smgt_Teacher;
		$classes = $teacher_obj->mj_smgt_get_class_by_teacher($teacher_id);
		foreach ($classes as $class) {
			$classdata = mj_smgt_get_class_by_id($class['class_id']);
			echo "<option value={$class['class_id']}>{$classdata->class_name}</option>";
		}
		wp_die();
	}
	add_action('wp_ajax_mj_smgt_teacher_by_class', 'mj_smgt_teacher_by_class');
	function mj_smgt_teacher_by_class()
	{
		$class_id = sanitize_text_field($_REQUEST['class_id']);
		$teacher_obj = new Smgt_Teacher;
		$classes = $teacher_obj->mj_smgt_get_class_teacher($class_id);
		foreach ($classes as $class) {
			echo "<option value={$class['teacher_id']}>" . mj_smgt_get_user_name_byid($class['teacher_id']) . "</option>";
		}
		wp_die();
	}
	add_action('wp_ajax_mj_smgt_sender_user_list', 'mj_smgt_sender_user_list');
	function mj_smgt_sender_user_list()
	{
		$school_obj = new School_Management(get_current_user_id());
		$login_user_role = $school_obj->role;
		$role = $_REQUEST['send_to'];
		$login_user_role = $school_obj->role;
		$class_list = isset($_REQUEST['class_list']) ? $_REQUEST['class_list'] : '';
		$class_section = isset($_REQUEST['class_section']) ? $_REQUEST['class_section'] : '';
		$query_data['role'] = $role;
		$exlude_id = mj_smgt_approve_student_list();
		$html_class_section = '';
		$return_results['section'] = '';
		$user_list = array();
		global $wpdb;
		$defaultmsg = esc_attr__('All Section', 'school-mgt');
		$html_class_section =  "<option value=''>" . $defaultmsg . "</option>";
		if ($class_list != '') {
			$retrieve_data = mj_smgt_get_class_sections($class_list);
			if ($retrieve_data)
				foreach ($retrieve_data as $section) {
					$html_class_section .= "<option value='" . $section->id . "'>" . $section->section_name . "</option>";
				}
		}
		if ($role == 'student') {
			$query_data['exclude'] = $exlude_id;
			if ($class_section) {
				$query_data['meta_key'] = 'class_section';
				$query_data['meta_value'] = $class_section;
				$query_data['meta_query'] = array(array('key' => 'class_name', 'value' => $class_list, 'compare' => '='));
				$results = get_users($query_data);
			} elseif ($class_list != '') {
				$query_data['meta_key'] = 'class_name';
				$query_data['meta_value'] = $class_list;
				$results = get_users($query_data);
			} else {
				if ($login_user_role == "parent") {
					$parentdata = get_user_meta(get_current_user_id(), 'child', true);
					foreach ($parentdata as $key => $val) {
						$studentdata[] = get_userdata($val);
					}
					$results = $studentdata;
				}
				if ($login_user_role == "teacher") {
					$teacher_class_data = mj_smgt_get_all_teacher_data(get_current_user_id());
					foreach ($teacher_class_data as $data_key => $data_val) {
						$course_id[] = $data_val->class_id;
						$query_data['meta_key'] = 'class_name';
						$query_data['meta_value'] = $course_id;
						$result = get_users($query_data);
					}
					$results = $result;
				}
			}
		}
		if ($role == 'teacher') {
			if ($class_list != '') {
				global $wpdb;
				$table_smgt_teacher_class = $wpdb->prefix . 'smgt_teacher_class';
				$teacher_list = $wpdb->get_results(
					$wpdb->prepare("SELECT * FROM $table_smgt_teacher_class WHERE class_id = %d", $class_list)
				);

				if ($teacher_list) {
					foreach ($teacher_list as $teacher) {
						$user_list[] = $teacher->teacher_id;
					}
				}
			} else
				$results = get_users($query_data);
		}
		if ($role == 'supportstaff' || $role == 'administrator') {
			$results = get_users($query_data);
		}
		if ($role == 'parent') {
			if ($class_list == '') {
				$results = get_users($query_data);
			} else {
				$query_data['role'] = 'student';
				$query_data['exclude'] = $exlude_id;
				if ($class_section) {
					$query_data['meta_key'] = 'class_section';
					$query_data['meta_value'] = $class_section;
					$query_data['meta_query'] = array(
						array('key' => 'class_name', 'value' => $class_list, 'compare' => '=')
					);
				} elseif ($class_list != '') {
					$query_data['meta_key'] = 'class_name';
					$query_data['meta_value'] = $class_list;
				}
				$userdata = get_users($query_data);
				foreach ($userdata as $users) {
					$parent = get_user_meta($users->ID, 'parent_id', true);
					if (!empty($parent)) {
						foreach ($parent as $p) {
							$user_list[] = $p;
						}
					}
				}
			}
		}
		if (isset($results)) {
			foreach ($results as $user_datavalue) {
				$user_list[] = $user_datavalue->ID;
			}
		}
		$user_data_list = array_unique($user_list);
		$return_results['section'] = $html_class_section;
		$return_results['users'] = '';
		$user_string  = '<select name="selected_users[]" id="selected_users" class="form-control" multiple="true">';
		if (!empty($user_data_list))
			foreach ($user_data_list as $retrive_data) {
				if ($retrive_data != get_current_user_id()) {
					$check_data = mj_smgt_get_user_name_byid($retrive_data);
					if ($check_data != '') {
						$user_string .= "<option value='" . $retrive_data . "'>" . mj_smgt_get_user_name_byid($retrive_data) . "</option>";
					}
				}
			}
		$user_string .= '</select>';
		$return_results['users'] = $user_string;
		echo json_encode($return_results);
		die();
	}
	add_action('wp_ajax_mj_smgt_frontend_sender_user_list', 'mj_smgt_frontend_sender_user_list');
	add_action('wp_ajax_mj_smgt_change_profile_photo', 'mj_smgt_change_profile_photo');
	function mj_smgt_change_profile_photo()
	{
?>
	<div class="modal-header mb-4"> <a href="#" class="close-btn-cat badge badge-danger pull-right"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title update_profile_title"><?php esc_attr_e('Update Profile Picture', 'school-mgt'); ?></h4>
	</div>
	<form class="form-horizontal" action="#" method="post" enctype="multipart/form-data">
		<div class="form-body user_form"> <!--form Body div-->
			<div class="row"><!--Row Div-->
				<div class="col-md-8">
					<div class="form-group input">
						<div class="col-md-12 form-control image_upload_popup_account res_rtl_height_50px">
							<label for="inputEmail" class="label_margin_left_10px custom-control-label custom-top-label ml-2 margin_left_30px"><?php esc_attr_e('Select Profile Picture', 'school-mgt'); ?></label>
							<div class="col-sm-12">
								<input id="input-1" name="profile" type="file" onchange="mj_smgt_fileCheck(this);" class="line_height_26px file profile_file d-inline">
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-4">
					<button type="submit" class="btn btn-success save_upload_profile_btn save_btn" name="save_profile_pic"><?php esc_attr_e('Save', 'school-mgt'); ?></button>
				</div>
			</div>
		</div>
	</form>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_assign_route', 'mj_smgt_assign_route');
	function mj_smgt_assign_route()
	{
		$transport_id = sanitize_text_field($_REQUEST['record_id']);
		$assign_transport_data = mj_smgt_get_assign_transport_by_id($_REQUEST['record_id']);
		$teacher_obj = new Smgt_Teacher;
?>
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			"use strict";
			$('#message_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('#selected_multiple_users').multiselect({
				nonSelectedText: "<?php esc_attr_e('Select Users', 'school-mgt'); ?>",
				includeSelectAllOption: true,
				selectAllText: '<?php esc_attr_e('Select all', 'school-mgt'); ?>',
				templates: {
					button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
				},
			});
		});
	</script>
	<div class="form-group popup_heder_marging">
		<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Icons/Transportation.png";  ?>" alt="" class="popup_image_before_name">
		<a href="#" class="close-btn-cat badge badge-danger pull-right">
			<img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title" id="myLargeModalLabel">
			<?php esc_attr_e('Assign Route', 'school-mgt'); ?>
		</h4>
	</div>
	<div class="panel-body margin_top_20px padding_top_15px_res"><!--------- penal body ------->
		<form name="assign_transport_form" action="#" method="post" enctype="multipart/form-data" class="form-horizontal" id="assign_transport_form">
			<input type="hidden" value="<?php echo $transport_id; ?>" name="transport_id">
			<div class="form-body user_form"><!--user form -->
				<div class="row"><!--row -->
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 single_class_div support_staff_user_div input">
						<div class="col-sm-12 smgt_multiple_select rtl_padding_left_right_0px">
							<span class="user_display_block">
								<select name="selected_users[]" id="selected_multiple_users" class="form-control min_width_250px" multiple="multiple">
									<?php
									if (!empty($assign_transport_data)) {
										$users = json_decode($assign_transport_data->route_user);
									}
									$student_list = mj_smgt_get_all_student_list();
									foreach ($student_list  as $retrive_data) {
									?>
										<option value="<?php echo $retrive_data->ID; ?>"
											<?php echo $teacher_obj->mj_smgt_in_array_r($retrive_data->ID, $users) ? 'selected' : ''; ?>>
											<?php echo $retrive_data->display_name; ?>
										<?php
										//echo '<option value="'.$retrive_data->ID.'" >'.$retrive_data->display_name.'</option>';
									}
										?>
								</select>
							</span>
							<span class="multiselect_label">
								<label class="ml-1 custom-top-label top" for="staff_name"><?php esc_html_e('Select Users', 'school-mgt'); ?><span class="required">*</span></label>
							</span>
						</div>
					</div>
					<?php wp_nonce_field('save_assign_transpoat_admin_nonce'); ?>
					<div class="col-sm-3">
						<input type="submit" value="<?php if ($edit) {
														esc_attr_e('Assign Route', 'school-mgt');
													} else {
														esc_attr_e('Assign Route', 'school-mgt');
													} ?>" name="save_assign_route" class="btn btn-success save_btn" />
					</div>
				</div>
			</div>
		</form>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_count_student_in_class', 'mj_smgt_count_student_in_class');
	add_action('wp_ajax_mj_smgt_count_student_in_class', 'mj_smgt_count_student_in_class');
	function mj_smgt_count_student_in_class()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'smgt_class';
		$class_id = $_POST['class_id'];
		$student_list = count(get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id, 'role' => 'student')));
		$class_capacity_data = $wpdb->get_row(
			$wpdb->prepare("SELECT class_capacity FROM $table_name WHERE class_id = %d", $class_id)
		);

		$class_capacity = intval($class_capacity_data->class_capacity);
		$class_data = array();
		if ($class_capacity > $student_list) {
			echo "class_empt";
			$class_data[0] = 'class_empt';
		} else {
			$class_data[0] = 'class_full';
			$class_data[1] = $class_capacity;
			$class_data[2] = $student_list;
		}
		echo json_encode($class_data);
		die;
	}
	add_action('wp_ajax_mj_smgt_show_event_task', 'mj_smgt_show_event_task');
	add_action('wp_ajax_nopriv_mj_smgt_show_event_task', 'mj_smgt_show_event_task');
	//show event and task model code
	function mj_smgt_show_event_task()
	{
		$role = mj_smgt_get_user_role(get_current_user_id());
		$id = sanitize_text_field($_REQUEST['id']);
		$model = sanitize_text_field($_REQUEST['model']);
		if ($model == 'Notification Details') {
			$notification = new Smgt_dashboard;
			$notification_data = $notification->mj_smgt_get_signle_notification_by_id($id);
		}
		if ($model == 'Noticeboard Details') {
			$retrieve_class = get_post($id);
		}
		if ($model == 'Exam Details') {
			$exam_data = mj_smgt_get_exam_by_id($id);
		}
		if ($model == 'holiday Details') {
			$holiday_data = mj_smgt_get_holiday_by_id($id);
		}
		if ($model == 'Feespayment Details') {
			$feespayment_data = mj_smgt_get_feespayment_by_id($id);
			$page = 'feepayment';
			$feepayment_access = mj_smgt_page_access_rolewise_accessright_dashboard($page);
		}
		if ($model == 'Class Details') {
			$class_data = mj_smgt_get_class_by_id($id);
		}
		if ($model == 'Message Details') {
			$message_data = mj_smgt_get_message_by_id($id);
		}
		if ($model == 'Event Details') {
			$obj_event = new event_Manage();
			$event_data = $obj_event->MJ_smgt_get_single_event($id);
		}
		if ($model == 'transport Details') {
			$transport_data = mj_smgt_get_transport_by_id($id);
		}
		if ($model == 'homework Details') {
			$homework_data = mj_smgt_get_homework_by_id($id);
		}
?>
	<div class="modal-header model_header_padding dashboard_model_header">
		<img src="<?php if ($model == 'homework Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Icons/homework.png";
					}
					if ($model == 'transport Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Icons/Transportation.png";
					}
					if ($model == 'Event Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/notice_1.png";
					}
					if ($model == 'Notification Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/notifications_1.png";
					} elseif ($model == 'Noticeboard Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/notice_1.png";
					} elseif ($model == 'Exam Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Exam.png";
					} elseif ($model == 'holiday Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Holiday.png";
					} elseif ($model == 'Feespayment Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Fees_Payment.png";
					} elseif ($model == 'Class Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Class.png";
					} elseif ($model == 'Message Details') {
						echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/message_1.png";
					} ?>" alt="" class="popup_image_before_name">
		<a href="javascript:void(0);" class="event_close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>

		<?php
		if ($role == "administrator" || $role == "management") {
			if ($model == 'homework Details') {
		?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_student_homewrok'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'transport Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_transport'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Event Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_event'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Notification Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_notification'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Noticeboard Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_notice'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Exam Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_exam'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'holiday Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_holiday'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Feespayment Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_fees_payment&tab=view_fesspayment&idtest=' . MJ_smgt_encrypt_id($feespayment_data->fees_pay_id) . '&view_type=view_payment'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Class Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_class'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Message Details') {
			?>
				<a href="<?php echo admin_url() . 'admin.php?page=smgt_message'; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			}
		} else {
			if ($model == 'homework Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=homework"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'transport Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=transport"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Event Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=event"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Notification Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=notification"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Noticeboard Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=notice"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Exam Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=exam"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'holiday Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=holiday"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
				<?php
			} elseif ($model == 'Feespayment Details') {
				if ($feepayment_access == '1') {
				?>
					<a href="<?php echo home_url() . "?dashboard=user&page=feepayment&tab=view_fesspayment&idtest=" . MJ_smgt_encrypt_id($feespayment_data->fees_pay_id) . "&view_type=view_payment"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
				<?php
				}
			} elseif ($model == 'Class Details') {
				?>
				<a href="<?php echo home_url() . "?dashboard=user&page=class"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
			<?php
			} elseif ($model == 'Message Details') {
			?>
				<a href="<?php echo home_url() . "?dashboard=user&page=message"; ?>" class="badge badge-success pull-right dashboard_pop-up_design"><img class="redirect_img_css" src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Redirect.png" ?>"></a>
		<?php
			}
		} ?>
		<h4 id="myLargeModalLabel" class="modal-title"><?php if ($model == 'homework Details') {
															esc_attr_e('Homework Details', 'school-mgt');
														} elseif ($model == 'transport Details') {
															esc_attr_e('Transport Details', 'school-mgt');
														}
														if ($model == 'Event Details') {
															esc_attr_e('Event Details', 'school-mgt');
														}
														if ($model == 'Notification Details') {
															esc_attr_e('Notification Details', 'school-mgt');
														} elseif ($model == 'Noticeboard Details') {
															esc_attr_e('Notice Details', 'school-mgt');
														} elseif ($model == 'Exam Details') {
															esc_attr_e('Exam Details', 'school-mgt');
														} elseif ($model == 'holiday Details') {
															esc_attr_e('Holiday Details', 'school-mgt');
														} elseif ($model == 'Feespayment Details') {
															esc_attr_e('Fees Payment Details', 'school-mgt');
														} elseif ($model == 'Class Details') {
															esc_attr_e('Class Details', 'school-mgt');
														} elseif ($model == 'Message Details') {
															esc_attr_e('Message Details', 'school-mgt');
														} ?></h4>
	</div>
	<div class="panel-white">
		<?php
		if ($model == 'Notification Details') {
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Student Name', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_get_user_name_byid($notification_data->student_id); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Title', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $notification_data->title; ?></label>
					</div>
					<div class="col-md-12 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Message', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $notification_data->message; ?></label>
					</div>
				</div>
			</div>
		<?php
		}
		if ($model == 'Class Details') {
			$class_id = $class_data->class_id;
			$user = count(get_users(array(
				'meta_key' => 'class_name',
				'meta_value' => $class_id
			)));
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Name', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $class_data->class_name; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Create Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($class_data->created_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Numeric Name', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $class_data->class_num_name; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Student Capacity', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							echo $user . ' ';
							esc_attr_e('Out Of', 'school-mgt');
							echo ' ' . $class_data->class_capacity;
							?>
						</label>
					</div>
				</div>
			</div>
		<?php
		}
		if ($model == 'Message Details') {
			$message_for = get_post_meta($message_data->post_id, 'message_for', true);
			$attchment = get_post_meta($message_data->post_id, 'message_attachment', true);
			$auth = get_post($message_data->post_id);
			$authid = $auth->post_author;
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Message For', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							$check_message_single_or_multiple = mj_smgt_send_message_check_single_user_or_multiple($message_data->post_id);
							if ($check_message_single_or_multiple == 1) {
								global $wpdb;
								$tbl_name = $wpdb->prefix . 'smgt_message';
								$post_id = $message_data->post_id;
								$get_single_user = $wpdb->get_row("SELECT * FROM $tbl_name where post_id = $post_id");
								$role = mj_smgt_get_display_name($get_single_user->receiver);
								echo esc_attr_e($role, 'school-mgt');
							} else {
								$role = get_post_meta($message_data->post_id, 'message_for', true);
								echo esc_attr_e($role, 'school-mgt');
							}
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Message From', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php $author = mj_smgt_get_display_name($authid);
															echo  esc_attr_e($author, 'school-mgt'); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Subject', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $message_data->subject; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Attachment', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							if (!empty($attchment)) {
								$attchment_array = explode(',', $attchment);
								foreach ($attchment_array as $attchment_data) {
							?>
									<a target="blank" href="<?php echo content_url() . '/uploads/school_assets/' . $attchment_data; ?>" class="btn message_popup_button btn-default"><i class="fa fa-eye"></i> <?php esc_attr_e('View Attachment', 'school-mgt'); ?></a>
							<?php
								}
							} else {
								esc_attr_e('No Attachment', 'school-mgt');
							}
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Message Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($message_data->date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Description', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $message_data->message_body; ?></label>
					</div>
				</div>
			</div>
		<?php
		}
		if ($model == 'Feespayment Details') {
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Class Name', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo smgt_get_class_section_name_wise($feespayment_data->class_id, $feespayment_data->section_id); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Student Name', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							$student_data =	get_userdata($feespayment_data->student_id);
							if (!empty($student_data)) {
								echo esc_html($student_data->display_name);
							} else {
								echo 'N/A';
							}
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Fees Title', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							$fees_id = explode(',', $feespayment_data->fees_id);
							$fees_type = array();
							foreach ($fees_id as $id) {
								$fees_type[] = mj_smgt_get_fees_term_name($id);
							}
							echo implode(" , ", $fees_type);
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Invoice Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($feespayment_data->paid_by_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Total Amount', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($feespayment_data->total_amount, 2, '.', '')); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<?php
						$total_amount = $feespayment_data->total_amount;
						$paid_amount = $feespayment_data->fees_paid_amount;
						$due_amount = $total_amount - $paid_amount;
						?>
						<label for="" class="popup_label_heading"><?php esc_attr_e('Due Amount', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($due_amount, 2, '.', '')); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Paid Amount', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($feespayment_data->fees_paid_amount, 2, '.', '')); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Payment Status', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							$smgt_get_payment_status = mj_smgt_get_payment_status($feespayment_data->fees_pay_id);
							if ($smgt_get_payment_status == 'Not Paid') {
								echo "<span class='red_color'>";
							} elseif ($smgt_get_payment_status == 'Partially Paid') {
								echo "<span class='perpal_color'>";
							} else {
								echo "<span class='green_color'>";
							}
							echo esc_html__("$smgt_get_payment_status", "school-mgt");
							echo "</span>";
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Start Date To End Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $feespayment_data->start_year . ' ' . esc_html__('To', 'school-mgt') . ' ' . $feespayment_data->end_year; ?></label>
					</div>
					<div class="col-md-12 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Description', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							$description = ltrim($feespayment_data->description);
							if (!empty($description)) {
								echo $description;
							} else {
								echo "N/A";
							} ?>
						</label>
					</div>
				</div>
			</div>
		<?php
		}
		?>
		<?php
		if ($model == 'Noticeboard Details') {
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Title', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $retrieve_class->post_title; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Start Date To End Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box(get_post_meta($retrieve_class->ID, 'start_date', true)); ?> <?php esc_html_e('To', 'school-mgt'); ?> <?php echo mj_smgt_getdate_in_input_box(get_post_meta($retrieve_class->ID, 'end_date', true)); ?> </label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Notice For', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							$role = get_post_meta($retrieve_class->ID, 'notice_for', true);
							if ($role == 'all') {
								echo esc_html_e('All', 'school-mgt');
							} else {
								echo esc_attr_e($role, 'school-mgt');
							}
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Class Name', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							if (get_post_meta($retrieve_class->ID, 'smgt_class_id', true) != "" && get_post_meta($retrieve_class->ID, 'smgt_class_id', true) == "all") {
								esc_attr_e('All', 'school-mgt');
							} elseif (get_post_meta($retrieve_class->ID, 'smgt_class_id', true) != "") {
								echo mj_smgt_get_class_name(get_post_meta($retrieve_class->ID, 'smgt_class_id', true));
							} ?>
						</label>
					</div>
					<div class="col-md-12 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Comment', 'school-mgt'); ?></label><br>
						<label for="" class="label_value">
							<?php
							if (!empty($retrieve_class->post_content)) {
								echo $retrieve_class->post_content;
							} else {
								echo "N/A";
							}
							?>
						</label>
					</div>
				</div>
			</div>
		<?php
		}
		?>
		<?php
		if ($model == 'Exam Details') {

		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Title', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $exam_data->exam_name; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Term', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo get_the_title($exam_data->exam_term); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Class', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo smgt_get_class_section_name_wise($exam_data->class_id, $exam_data->section_id); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Start Date', 'school-mgt'); ?> <?php esc_attr_e('To', 'school-mgt'); ?> <?php esc_attr_e('End Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($exam_data->exam_start_date); ?> <?php esc_attr_e('To', 'school-mgt'); ?> <?php echo mj_smgt_getdate_in_input_box($exam_data->exam_end_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Total Marks', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $exam_data->total_mark; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Passing Marks', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $exam_data->passing_mark; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Download File', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value">
							<?php
							$doc_data = json_decode($exam_data->exam_syllabus);
							if (!empty($doc_data[0]->value)) {
							?>
								<a download href="<?php print content_url() . '/uploads/school_assets/' . $doc_data[0]->value; ?>" class="btn padding_0 popup_download_btn" record_id="<?php echo $exam_data->exam_id; ?>"><i class="fa fa-download" id="download_icon"></i> <?php esc_attr_e('Download', 'school-mgt'); ?></a>
							<?php
							} else {
								echo "N/A";
							}
							?>
						</label>
					</div>
					<div class="col-md-12 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Comment', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php if (!empty($exam_data->exam_comment)) {
																echo $exam_data->exam_comment;
															} else {
																echo "N/A";
															} ?></label>
					</div>
				</div>
			</div>
		<?php
		}
		?>
		<?php
		if ($model == 'holiday Details') {
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Holiday Title', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo $holiday_data->holiday_title; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Start Date To End Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value" style=""><?php echo mj_smgt_getdate_in_input_box($holiday_data->date) . ' ' . esc_attr__('To', 'school-mgt') . ' ' . mj_smgt_getdate_in_input_box($holiday_data->end_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Status', 'school-mgt'); ?></label><br>
						<label for="" class="label_value" style="color:green !important;"><?php echo esc_attr_e('approve', 'school-mgt'); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Description', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php if (!empty($holiday_data->description)) {
																echo $holiday_data->description;
															} else {
																echo "N/A";
															} ?></label>
					</div>
				</div>
			</div>
		<?php
		}
		if ($model == 'Event Details') {
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Title', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php if (!empty($event_data->event_title)) {
																echo stripslashes($event_data->event_title);
															} else {
																echo "N/A";
															} ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Download File', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value">
							<?php
							if (!empty($event_data->event_doc)) {
							?>
								<a download href="<?php print content_url() . '/uploads/school_assets/' . $event_data->event_doc; ?>" class="btn padding_0 popup_download_btn" record_id="<?php echo $exam_data->exam_id; ?>"><i class="fa fa-download" id="download_icon"></i> <?php esc_attr_e('Download', 'school-mgt'); ?></a>
							<?php
							} else {
								echo "N/A";
							}
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Start Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($event_data->start_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('End Date', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($event_data->end_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Start Time', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo MJ_smgt_timeremovecolonbefoream_pm($event_data->start_time); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('End Time', 'school-mgt'); ?></label><br>
						<label for="" class="label_value"><?php echo MJ_smgt_timeremovecolonbefoream_pm($event_data->end_time); ?></label>
					</div>
					<div class="col-md-12 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Description', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php if (!empty($event_data->description)) {
																echo stripslashes($event_data->description);
															} else {
																echo "N/A";
															} ?></label>
					</div>
				</div>
			</div>
		<?php
		}
		if ($model == 'transport Details') {
		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Route Name', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $transport_data->route_name; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Vehicle Identifier', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $transport_data->number_of_vehicle; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Vehicle Registration Number', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $transport_data->vehicle_reg_num; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Driver Name', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $transport_data->driver_name; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Driver Phone Number', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $transport_data->driver_phone_num; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Driver Address', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $transport_data->driver_address; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Route Fare', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($transport_data->route_fare, 2, '.', '')); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Route Description', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php if (!empty($transport_data->route_description)) {
																echo $transport_data->route_description;
															} else {
																echo "N/A";
															} ?></label>
					</div>
				</div>
			</div>
		<?php
		}
		if ($model == 'homework Details') {

		?>
			<div class="modal-body view_details_body_assigned_bed view_details_body">
				<div class="row">
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Title', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo $homework_data->title; ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Subject', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo mj_smgt_get_subject_byid($homework_data->subject); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Class', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo smgt_get_class_section_name_wise($homework_data->class_name, $homework_data->section_id); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Homework Date', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($homework_data->created_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Submission Date', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php echo mj_smgt_getdate_in_input_box($homework_data->submition_date); ?></label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Documents Title', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value">
							<?php
							$doc_data = json_decode($homework_data->homework_document);
							if (!empty($doc_data[0]->title)) {
								echo esc_attr($doc_data[0]->title);
							} else {
								echo "N/A";
							}
							?>
						</label>
					</div>
					<div class="col-md-6 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Download File', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value">
							<?php
							$doc_data = json_decode($homework_data->homework_document);
							if (!empty($doc_data[0]->value)) {
							?>
								<a download href="<?php print content_url() . '/uploads/school_assets/' . $doc_data[0]->value; ?>" class="btn padding_0 popup_download_btn" record_id="<?php echo $homework_data->homework_id; ?>"><i class="fa fa-download" id="download_icon"></i> <?php esc_attr_e('Download', 'school-mgt'); ?></a>
							<?php
							} else {
								echo "N/A";
							}
							?>
						</label>
					</div>
					<?php
					global $current_user;
					$user_roles = $current_user->roles;

					$user_role = array_shift($user_roles);
					if ($user_role == "student") {
					?>
						<div class="col-md-6 popup_padding_15px" style="margin-top:15px;">
							<a href="?dashboard=user&page=homework&tab=Viewhomework&action=view&homework_id=<?php echo $homework_data->homework_id; ?>&student_id=<?php echo get_current_user_id(); ?>" class="save_btn" style="padding: 5px;">
								<?php esc_attr_e('Upload Homework', 'school-mgt'); ?>
							</a>
						</div>
					<?php
					}
					?>

					<div class="col-md-12 popup_padding_15px">
						<label for="" class="popup_label_heading"><?php esc_attr_e('Homework Content', 'school-mgt'); ?></label>
						<br>
						<label for="" class="label_value"><?php
															if (!empty($homework_data->content)) {
																echo $homework_data->content;
															} else {
																echo "N/A";
															}
															?></label>
					</div>
				</div>
			</div>
		<?php
		}
		?>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_add_or_remove_category_new', 'mj_smgt_add_or_remove_category_new');
	add_action('wp_ajax_nopriv_mj_smgt_add_or_remove_category_new', 'mj_smgt_add_or_remove_category_new');
	function mj_smgt_add_or_remove_category_new() //smgt_add_or_remove_category_new
	{
		$model = sanitize_text_field($_REQUEST['model']);
		$title = esc_html__("title", 'school-mgt');
		$table_header_title =  esc_html__("header", 'school-mgt');
		$button_text =  esc_html__("Add", 'school-mgt');
		$label_text =  esc_html__("category Name", 'school-mgt');
		if ($model == 'school_category') //school_category
		{
			$title = esc_html__("Add School Name", 'school-mgt');
			$table_header_title =  esc_html__("School Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("School Name", 'school-mgt');
		}
		if ($model == 'standard_category') //standard_category
		{
			$title = esc_html__("Add Standard Name", 'school-mgt');
			$table_header_title =  esc_html__("Standard Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("Standard Name", 'school-mgt');
		}
		if ($model == 'term_category') //term_category
		{
			$title = esc_html__("Add Term Category", 'school-mgt');
			$table_header_title =  esc_html__("Term Category Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("Term Category Name", 'school-mgt');
		}
		if ($model == 'room_category') //term_category
		{
			$title = esc_html__("Add Room Type", 'school-mgt');
			$table_header_title =  esc_html__("Room Type Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("Room Type Name", 'school-mgt');
		}
		if ($model == 'leave_type') {
			$title = esc_attr__("Add Leave Type", 'school-mgt');
			$table_header_title =  esc_attr__("Leave Type Name", 'school-mgt');
			$button_text =  esc_attr__("Add", 'school-mgt');
			$label_text =  esc_attr__("Leave Type Name", 'school-mgt');
		}
		if ($model == 'smgt_feetype') //term_category
		{
			$title = esc_html__("Add Fees", 'school-mgt');
			$table_header_title =  esc_html__("Fees Category Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("Fees Category Name", 'school-mgt');
		}
		if ($model == 'smgt_bookcategory') //term_category
		{
			$title = esc_html__("Add Book Category", 'school-mgt');
			$table_header_title =  esc_html__("Book Category Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("Book Category Name", 'school-mgt');
		}
		if ($model == 'smgt_rack') //term_category
		{
			$title = esc_html__("Add Rack Location", 'school-mgt');
			$table_header_title =  esc_html__("Rack Location Name", 'school-mgt');
			$button_text =  esc_html__("Add", 'school-mgt');
			$label_text =  esc_html__("Rack Location Name", 'school-mgt');
		}
		if ($model == 'period_type') //term_category
		{
			$title = esc_attr__("Issue Period", 'school-mgt');
			$table_header_title =  esc_attr__("Period Time", 'school-mgt');
			$button_text =  esc_attr__("Add", 'school-mgt');
			$label_text =  esc_attr__("Period Time", 'school-mgt');
		}
		if ($model == 'period_type') //term_category
		{
			$obj_lib = new Smgtlibrary();
			$cat_result1 = $obj_lib->mj_smgt_get_periodlist();
		} else {
			$cat_result = mj_smgt_get_all_category($model);
		}
?>
	<script src="jquery.maxlength.min.js"></script>
	<script type="text/javascript">
		jQuery(document).ready(function() {
			jQuery('#category_form_test').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
		});
		jQuery('.onlyletter_number_space_validation').keypress(function(e) {
			var regex = new RegExp("^[0-9a-zA-Z \b]+$");
			var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			if (!regex.test(key)) {
				event.preventDefault();
				return false;
			}
		});
		jQuery('.onlyletter_number').keypress(function(e) {
			var regex = new RegExp("^[0-9\b]+$");
			var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			if (!regex.test(key)) {
				event.preventDefault();
				return false;
			}
		});
	</script>
	<div class="modal-header model_header_padding dashboard_model_header">
		<a href="javascript:void(0);" class="event_close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 id="myLargeModalLabel" class="modal-title"><?php echo $title; ?></h4>
	</div>
	<div class="padding_15px"><!---PANEL-WHITE--->
		<form name="category_form" action="" method="post" class="category_popup_float form-horizontal admission_form_popup" id="category_form_test"><!---CATEGORY_FORM----->
			<input type="hidden" id="mj_smgt_nonce" value="<?php echo wp_create_nonce('mj_smgt_nonce'); ?>">
			<div class="form-body user_form">
				<div class="row">
					<?php
					if ($model == 'period_type') {
					?>
						<div class="col-md-9">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="category_name" maxlength="50" min="1" class="cat_value validate[required] form-control text-input onlyletter_number" type="number" value="" name="category_name" placeholder="<?php esc_attr_e('Must Be Enter Number of Days', 'school-mgt'); ?>">
									<label for="userinput1" class="active "><?php esc_html_e($label_text, 'school-mgt'); ?><span class="required">*</span></label>
								</div>
							</div>
						</div>
					<?php
					} else {
					?>
						<div class="col-md-9">
							<div class="form-group input rtl_margin_0px">
								<div class="col-md-12 form-control">
									<input id="category_name" maxlength="50" class="cat_value form-control validate[required,custom[description_validation]] text-input" type="text" maxlength="50" value="" name="category_name">
									<label for="userinput1" class=""><?php esc_html_e($label_text, 'school-mgt'); ?><span class="required">*</span></label>
								</div>
							</div>
						</div>
					<?php
					}
					?>
					<div class="col-sm-3" style="padding-bottom: 10px;">
						<input type="button" value="<?php echo $button_text; ?>" name="save_category_test" class="btn save_btn btn-success" model="<?php echo $model; ?>" id="btn_add_cat_new_test">
					</div>
				</div>
			</div>
		</form>
		<div class="category_listbox_new admission_pop_up_new"><!---CATEGORY_LISTBOX----->
			<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12"><!---TABLE-RESPONSIVE----->
				<?php
				$i = 1;
				?>
				<div class="div_new">
					<?php
					if ($model == 'period_type') {
						foreach ($cat_result1 as $retrieved_data) {
					?>
							<div class="row new_popup_padding" id="<?php echo "cat_new-" . $retrieved_data->ID . "";  ?>">
								<div class="col-md-11 width_80 mt_7px">
									<?php
									echo $retrieved_data->post_title;
									echo esc_attr__("Days", "school-mgt");
									?>
								</div>
								<div class="row col-md-1 rs_popup_width_20px" id="<?php echo $retrieved_data->ID; ?>">
									<div class="col-md-12">
										<a href="#" class="btn-delete-cat_new" model="<?php echo $model; ?>" id="<?php echo $retrieved_data->ID; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></a>
									</div>
								</div>
							</div>
						<?php
							$i++;
						}
					} else {
						foreach ($cat_result as $retrieved_data) {

						?>
							<div class="row new_popup_padding" id="<?php echo "cat_new-" . $retrieved_data->ID . ""; ?>">
								<div class="col-md-10 width_70">
									<?php
									echo $retrieved_data->post_title;
									?>
								</div>
								<div class="row col-md-2 padding_left_0_res width_30" id="<?php echo $retrieved_data->ID; ?>">
									<div class="col-md-6 width_50_res padding_left_0">
										<a href="#" class="btn-delete-cat_new" model="<?php echo $model; ?>" id="<?php echo $retrieved_data->ID; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></a>
									</div>
									<div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0">
										<a class="btn-edit-cat_popup" model="<?php echo $model; ?>" href="#" id="<?php echo $retrieved_data->ID; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png" ?>" alt=""></a>
									</div>
								</div>
							</div>
					<?php
							$i++;
						}
					}
					?>
				</div>
			</div><!---END TABLE-RESPONSIVE----->
		</div><!---END CATEGORY_LISTBOX----->
	</div><!---END PANEL-WHITE--->
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_add_category_new', 'mj_smgt_add_category_new');
	add_action('wp_ajax_nopriv_mj_smgt_add_category_new', 'mj_smgt_add_category_new');
	function mj_smgt_add_category_new($data)
	{
		global $wpdb;
		$model = sanitize_text_field($_REQUEST['model']);
		$array_var = array();
		$data = array();
		$data['category_name'] = sanitize_text_field($_POST['category_name']);
		$data['category_type'] = sanitize_text_field($_POST['model']);
		$dlt_image = SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png";
		$edit_image = SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png";
		$id = mj_smgt_add_categorytype($data);
		if ($model == 'period_type') {
			$row1 = '<div class="row new_popup_padding" id="cat_new-' . $id . '"><div class="col-md-11 width_80 mt_7px" >' . $_REQUEST['category_name'] . ' ' . esc_attr__("Days", "school-mgt") . '</div><div class="row col-md-1 rs_popup_width_20px"><div class="col-md-12"><a href="#" class="btn-delete-cat_new" model="' . $model . '" id="' . $id . '"><img src="' . $dlt_image . '" alt=""></a></a></div></div></div>';
			$option = "<option value='$id'>" . $_REQUEST['category_name'] . ' ' . esc_attr__('Days', 'school-mgt') . '' . "</option>";
		} else {
			$row1 = '<div class="row new_popup_padding" id="cat_new-' . $id . '"><div class="col-md-10 width_70" >' . $_REQUEST['category_name'] . '</div><div class="row col-md-2 padding_left_0_res width_30"><div class="col-md-6 width_50_res padding_left_0"><a href="#" class="btn-delete-cat_new" model="' . $model . '" id="' . $id . '"><img src="' . $dlt_image . '" alt=""></a></div><div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0"><a class="btn-edit-cat_popup" model="' . $model . '" href="#" id="' . $id . '"><img src="' . $edit_image . '" alt=""></a></div></div></div>';
			$option = "<option value='$id'>" . $_REQUEST['category_name'] . "</option>";
		}
		$array_var[] = $row1;
		$array_var[] = $option;
		echo json_encode($array_var);
		die();
	}
	add_action('wp_ajax_mj_smgt_remove_category_new', 'mj_smgt_remove_category_new');
	add_action('wp_ajax_nopriv_mj_smgt_remove_category_new', 'mj_smgt_remove_category_new');
	function mj_smgt_remove_category_new()
	{
		// Verify nonce for CSRF protection
		if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'mj_smgt_nonce')) {
			wp_send_json_error(['message' => 'Security check failed'], 403);
			exit;
		}

		// Ensure the user is logged in
		if (!is_user_logged_in()) {
			wp_send_json_error(['message' => 'Unauthorized access'], 401);
			exit;
		}
		// Validate user role
		$role = mj_smgt_get_user_role(get_current_user_id());
		$allowed_roles = ["management", "administrator", "supportstaff", "teacher"];
		if (!in_array($role, $allowed_roles)) {
			wp_send_json_error(['message' => 'Permission denied'], 403);
			exit;
		}

		// Validate and sanitize cat_id
		if (!isset($_POST['cat_id']) || !is_numeric($_POST['cat_id'])) {
			wp_send_json_error(['message' => 'Invalid category ID'], 400);
			exit;
		}

		$cat_id = intval($_POST['cat_id']);

		// Check if the post exists before attempting deletion
		if (get_post_status($cat_id) === false) {
			wp_send_json_error(['message' => 'Category not found'], 404);
			exit;
		}
		// Attempt to delete the post
		$delete = wp_delete_post($cat_id, true); // 'true' forces permanent deletion
		if ($delete) {
			wp_send_json_success(['message' => 'Deleted successfully'], 200);
		} else {
			wp_send_json_error(['message' => 'Failed to delete category'], 500);
		}
		exit;
	}
	add_action('wp_ajax_mj_smgt_admissoin_approved',  'mj_smgt_admissoin_approved');
	function mj_smgt_admissoin_approved()
	{
		$uid = sanitize_text_field($_REQUEST['student_id']);
		$user_info = get_userdata($uid);
?>
	<script type="text/javascript">
		jQuery(document).ready(function() {
			var validate = jQuery('#admission_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
		});
		// PASSWORD SHOWING TOGGLE BUTTON
		const togglePassword = document.querySelector("#togglePassword");
		const password = document.querySelector("#password");
		togglePassword.addEventListener("click", function() {
			// toggle the type attribute
			const type = password.getAttribute("type") === "password" ? "text" : "password";
			password.setAttribute("type", type);
			// toggle the Font Awesome icon class
			this.classList.toggle("fa-eye");
			this.classList.toggle("fa-eye-slash");
		});
	</script>
	<style>
		.modal-header {
			height: auto;
		}
	</style>
	<div class="modal-header dashboard_model_header">
		<a href="#" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<img class="rtl_float_right" src="<?php echo get_option('smgt_school_logo') ?>" class="img-circle head_logo" width="40" height="40" style="float: left;" />
		<h4 class="modal-title">&nbsp;<?php echo get_option('smgt_school_name'); ?></h4>
	</div>
	<div class="panel-white admission_div_responsive">
		<div class="padding_20px padding_bottom_0px">
			<h4 class="panel-title"><i class="fa fa-user"></i> <?php echo mj_smgt_get_user_name_byid($uid); ?></h4>
		</div>
		<form name="admission_form" action="" method="post" class="padding_20px form-horizontal" id="admission_form">
			<input type="hidden" name="act_user_id" value="<?php echo $uid; ?>">
			<div class="form-body user_form">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="email" class="form-control validate[required,custom[email]] text-input email" maxlength="100" value="<?php echo $user_info->user_email; ?>" type="text" name="email" readonly>
								<label for="userinput1" class="active"><?php esc_html_e('Email', 'school-mgt'); ?><span class="required">*</span></label>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="password" class="form-control validate[required,minSize[8],maxSize[12]]" type="password" name="password" value="">
								<label for="userinput1" class=""><?php esc_html_e('Password', 'school-mgt'); ?><span class="required">*</span></label>
								<i class="fa fa-eye-slash" id="togglePassword"></i>
							</div>
						</div>
					</div>
					<div class="col-md-6 input">
						<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Class', 'school-mgt'); ?><span class="required">*</span></label>
						<select name="class_name" class="line_height_30px form-control validate[required] width_515" id="approve_class_list">
							<option value=""><?php esc_attr_e('Select Class', 'school-mgt'); ?></option>
							<?php
							foreach (mj_smgt_get_allclass() as $classdata) {
							?>
								<option value="<?php echo $classdata['class_id']; ?>"><?php echo $classdata['class_name']; ?></option>
							<?php } ?>
						</select>
					</div>
					<div class="col-md-6 input">
						<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Class Section', 'school-mgt'); ?></label>
						<select name="class_section" class="line_height_30px form-control width_515" id="approve_class_section">
							<option value=""><?php esc_attr_e('All Section', 'school-mgt'); ?></option>
						</select>
					</div>
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="student_roll" class="form-control validate[required,maxSize[6],custom[integer]] student_roll text-input" maxlength="50" type="text" value="" name="roll_id">
								<label for="userinput1" class=""><?php esc_html_e('Roll No.', 'school-mgt'); ?><span class="required">*</span></label>
							</div>
							<div class="roll_validation_div" style="display:none;">
								<div class="formError" style="opacity: 0.87; position: absolute; top: 33px; left: 0px; margin-top: 0px; display: block;">
									<div class="formErrorArrow formErrorArrowBottom">
										<div class="line1"><!-- --></div>
										<div class="line2"><!-- --></div>
										<div class="line3"><!-- --></div>
										<div class="line4"><!-- --></div>
										<div class="line5"><!-- --></div>
										<div class="line6"><!-- --></div>
										<div class="line7"><!-- --></div>
										<div class="line8"><!-- --></div>
										<div class="line9"><!-- --></div>
										<div class="line10"><!-- --></div>
									</div>
									<div class="formErrorContent"><?php esc_html_e('Roll No. Already Exist.', 'school-mgt'); ?><br></div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control checkbox_height_47px">
								<div class="row padding_radio responsive_label_position">
									<div class="display_flex">
										<label class="custom-top-label" for="student_approve_mail"><?php esc_attr_e('Send Mail', 'school-mgt'); ?></label>
										<input id="chk_sms_sent1" class=" check_box_input_margin" type="checkbox" value="1" name="student_approve_mail"> &nbsp;<?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 padding_top_15px_res rtl_margin_top_15px mb-3 rtl_margin_bottom_0px">
						<div class="form-group">
							<div class="col-md-12 form-control checkbox_height_47px">
								<div class="row padding_radio responsive_label_position">
									<div class="display_flex">
										<label class="custom-top-label" for="student_approve_sms"><?php esc_attr_e('Send SMS', 'school-mgt'); ?></label>
										<input id="chk_sms_sent1" class="" type="checkbox" value="1" name="student_approve_sms"> &nbsp;<?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="form-body user_form">
				<div class="row">
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Active Student', 'school-mgt'); ?>" name="active_user_admission" class="btn btn-success activate_student save_btn margin_top_20" />
					</div>
				</div>
			</div>
		</form>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_view_all_relpy',  'mj_smgt_view_all_relpy');
	add_action('wp_ajax_nopriv_mj_smgt_view_all_relpy',  'mj_smgt_view_all_relpy');
	function mj_smgt_view_all_relpy()
	{
		global $wpdb;
		$sTable = $wpdb->prefix . 'smgt_message_replies';
		$sTable_wp_users = $wpdb->prefix . 'users';
		$sLimit = "10";
		if (isset($_REQUEST['iDisplayStart']) && $_REQUEST['iDisplayLength'] != '-1') {
			$sLimit = "LIMIT " . intval($_REQUEST['iDisplayStart']) . ", " .
				intval($_REQUEST['iDisplayLength']);
		}
		$ssearch = $_REQUEST['sSearch'];
		if ($ssearch) {
			$sQuery = "SELECT * FROM  $sTable INNER JOIN $sTable_wp_users ON ($sTable.sender_id = $sTable_wp_users.ID OR $sTable.receiver_id = $sTable_wp_users.ID) WHERE sender_id LIKE '%$ssearch%' OR $sTable_wp_users.display_name LIKE '%$ssearch%' OR receiver_id LIKE '%$ssearch%' OR message_comment LIKE '%$ssearch%' OR created_date LIKE '%$ssearch%' ORDER BY $sTable.created_date DESC $sLimit";
			$rResult = $wpdb->get_results($sQuery, ARRAY_A);
			$wpdb->get_results("SELECT * FROM  $sTable INNER JOIN $sTable_wp_users ON ($sTable.sender_id = $sTable_wp_users.ID OR $sTable.receiver_id = $sTable_wp_users.ID) WHERE sender_id LIKE '%$ssearch%' OR $sTable_wp_users.display_name LIKE '%$ssearch%' OR receiver_id LIKE '%$ssearch%' OR message_comment LIKE '%$ssearch%' OR created_date LIKE '%$ssearch%' ORDER BY $sTable.created_date DESC");
			$iFilteredTotal = $wpdb->num_rows;
			$wpdb->get_results("SELECT * FROM  $sTable INNER JOIN $sTable_wp_users ON ($sTable.sender_id = $sTable_wp_users.ID OR $sTable.receiver_id = $sTable_wp_users.ID) WHERE sender_id LIKE '%$ssearch%' OR $sTable_wp_users.display_name LIKE '%$ssearch%' OR receiver_id LIKE '%$ssearch%' OR message_comment LIKE '%$ssearch%' OR created_date LIKE '%$ssearch%' ORDER BY $sTable.created_date DESC");
			$iTotal = $wpdb->num_rows;
		} else {
			$sQuery = "SELECT * FROM $sTable ORDER BY created_date DESC $sLimit";
			$rResult = $wpdb->get_results($sQuery, ARRAY_A);
			$wpdb->get_results("SELECT * FROM $sTable Group BY id , id DESC");
			$iFilteredTotal = $wpdb->num_rows;
			$wpdb->get_results(" SELECT * FROM $sTable Group BY id , id DESC");
			$iTotal = $wpdb->num_rows;
		}
		$output = array(
			"sEcho" => intval($_REQUEST['sEcho']),
			"iTotalRecords" => $iTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$i = 0;
		foreach ($rResult as $aRow) {
			if ($i == 10) {
				$i = 0;
			}
			if ($i == 0) {
				$color_class = 'smgt_class_color0';
			} elseif ($i == 1) {
				$color_class = 'smgt_class_color1';
			} elseif ($i == 2) {
				$color_class = 'smgt_class_color2';
			} elseif ($i == 3) {
				$color_class = 'smgt_class_color3';
			} elseif ($i == 4) {
				$color_class = 'smgt_class_color4';
			} elseif ($i == 5) {
				$color_class = 'smgt_class_color5';
			} elseif ($i == 6) {
				$color_class = 'smgt_class_color6';
			} elseif ($i == 7) {
				$color_class = 'smgt_class_color7';
			} elseif ($i == 8) {
				$color_class = 'smgt_class_color8';
			} elseif ($i == 9) {
				$color_class = 'smgt_class_color9';
			}
			$sender_info = get_userdata($aRow['sender_id']);
			$receiver_info = get_userdata($aRow['receiver_id']);
			$image_src = SMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png";
			$profile_image_src = SMS_PLUGIN_URL . "/assets/images/dashboard_icon/White_icons/Message_Chat.png";
			$row[0] = '<td class="checkbox_width_10px">
							<input type="checkbox" class="smgt_sub_chk select-checkbox sub_chk" name="id[]" value="' . $aRow['id'] . '">
						</td>';
			$row[1] = '<td class="user_image width_50px profile_image_prescription padding_left_0">
							<p class="smgt_message_profile prescription_tag padding_15px margin_bottom_0px ' . $color_class . '">
								<img src="' . $profile_image_src . '" height= "30px" width ="30px" alt="" class="massage_image center">
							</p>
						</td>';
			$row[2] = '<td>' . $sender_info->display_name . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Sender', 'school-mgt') . '" ></i></td>';
			$row[3] = '<td>' . $receiver_info->display_name . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Receiver', 'school-mgt') . '" ></i><td>';
			$body_char = strlen($msg->message_body);
			$body_char = strlen($aRow['message_comment']);
			if ($body_char <= 60) {
				$row[4] = '<td>' . $aRow['message_comment'] . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Description', 'school-mgt') . '" ></i></td>';
			} else {
				$char_limit = 60;
				$msg_body = substr(strip_tags($aRow['message_comment']), 0, $char_limit) . "...";
				$row[4] = '<td>' . $msg_body . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Description', 'school-mgt') . '" ></i></td>';
			}
			$attchment = $aRow['message_attachment'];
			if (!empty($attchment)) {
				$attchment_array = explode(',', $attchment);
				$view_attchment = '';
				foreach ($attchment_array as $attchment_data) {
					$view_attchment .= '<a target="blank" href="' . content_url() . '/uploads/school_assets/' . $attchment_data . '" class="btn btn-default"><i class="fa fa-download"></i>' . esc_html__('View Attachment', 'school-mgt') . '</a></br>';
				}
				$row[5] = '<td>' . $view_attchment . '</td>';
			} else {
				$row[5] = '<td>' . esc_attr__('No Attachment', 'school-mgt') . '</td>';
			}
			$row[6] = '<td>' . mj_smgt_convert_date_time($aRow['created_date']) . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Date & Time', 'school-mgt') . '" ></i></td>';
			$row[7] = '<td class="action">
							<div class="smgt-user-dropdown">
								<ul class="" style="margin-bottom: 0px !important;">
									<li class="">
										<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
											<img src="' . $image_src . '" >
										</a>
										<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
											<li class="float_left_width_100">
												<a href="?page=smgt_message&tab=view_all_message_reply&action=delete_users_reply_message&users_reply_message_id=' . $aRow['id'] . '" class="float_left_width_100" style="color: #f06c65!important;" onclick="return confirm(language_translate2.delete_record_alert)"><i class="fa fa-trash"></i> ' . esc_attr__('Delete', 'school-mgt') . '</a>
											</li>
										</ul>
									</li>
								</ul>
							</div>
						</td>';
			$output['aaData'][] = $row;
			$i++;
		}
		echo json_encode($output);
		die();
	}
	add_action('wp_ajax_mj_smgt_view_all_message',  'mj_smgt_view_all_message');
	add_action('wp_ajax_nopriv_mj_smgt_view_all_message',  'mj_smgt_view_all_message');
	function mj_smgt_view_all_message()
	{
		global $wpdb;
		$sTable = $wpdb->prefix . 'smgt_message';
		$sTable_wp_users = $wpdb->prefix . 'users';
		$tablename = "smgt_class";
		$retrieve_class = mj_smgt_get_all_data($tablename);
		$sLimit = "10";
		if (isset($_REQUEST['iDisplayStart']) && $_REQUEST['iDisplayLength'] != '-1') {
			$sLimit = "" . intval($_REQUEST['iDisplayStart']) . ", " .
				intval($_REQUEST['iDisplayLength']);
		}
		$ssearch = $_REQUEST['sSearch'];
		if ($ssearch) {
			$sQuery = "SELECT * FROM  $sTable INNER JOIN $sTable_wp_users ON ($sTable.sender = $sTable_wp_users.ID OR $sTable.receiver = $sTable_wp_users.ID) WHERE sender LIKE '%$ssearch%' OR $sTable_wp_users.display_name LIKE '%$ssearch%' OR receiver LIKE '%$ssearch%' OR subject LIKE '%$ssearch%' OR message_body LIKE '%$ssearch%' ORDER BY $sTable.date DESC $sLimit";
			$rResult = $wpdb->get_results($sQuery, ARRAY_A);
			$wpdb->get_results("SELECT * FROM  $sTable INNER JOIN $sTable_wp_users ON ($sTable.sender = $sTable_wp_users.ID OR $sTable.receiver = $sTable_wp_users.ID) WHERE sender LIKE '%$ssearch%' OR $sTable_wp_users.display_name LIKE '%$ssearch%' OR receiver LIKE '%$ssearch%' OR subject LIKE '%$ssearch%' OR message_body LIKE '%$ssearch%' ORDER BY $sTable.date DESC");
			$iFilteredTotal = $wpdb->num_rows;
			$wpdb->get_results("SELECT * FROM  $sTable INNER JOIN $sTable_wp_users ON ($sTable.sender = $sTable_wp_users.ID OR $sTable.receiver = $sTable_wp_users.ID) WHERE sender LIKE '%$ssearch%' OR $sTable_wp_users.display_name LIKE '%$ssearch%' OR receiver LIKE '%$ssearch%' OR subject LIKE '%$ssearch%' OR message_body LIKE '%$ssearch%' ORDER BY $sTable.date DESC");
			$iTotal = $wpdb->num_rows;
		} else {
			$sQuery = "SELECT * FROM $sTable ORDER BY date DESC limit $sLimit";
			$rResult = $wpdb->get_results($sQuery, ARRAY_A);
			$wpdb->get_results("SELECT * FROM $sTable Group BY message_id , message_id DESC");
			$iFilteredTotal = $wpdb->num_rows;
			$wpdb->get_results(" SELECT * FROM $sTable Group BY message_id , message_id DESC");
			$iTotal = $wpdb->num_rows;
		}
		$output = array(
			"sEcho" => intval($_REQUEST['sEcho']),
			"iTotalRecords" => $iTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$i = 0;
		foreach ($rResult as $aRow) {
			if ($i == 10) {
				$i = 0;
			}
			if ($i == 0) {
				$color_class = 'smgt_class_color0';
			} elseif ($i == 1) {
				$color_class = 'smgt_class_color1';
			} elseif ($i == 2) {
				$color_class = 'smgt_class_color2';
			} elseif ($i == 3) {
				$color_class = 'smgt_class_color3';
			} elseif ($i == 4) {
				$color_class = 'smgt_class_color4';
			} elseif ($i == 5) {
				$color_class = 'smgt_class_color5';
			} elseif ($i == 6) {
				$color_class = 'smgt_class_color6';
			} elseif ($i == 7) {
				$color_class = 'smgt_class_color7';
			} elseif ($i == 8) {
				$color_class = 'smgt_class_color8';
			} elseif ($i == 9) {
				$color_class = 'smgt_class_color9';
			}
			$user_id = $aRow['receiver'];
			$school_obj = new School_Management($user_id);
			$attchment = get_post_meta($aRow['post_id'], 'message_attachment', true);
			$sender_info = get_userdata($aRow['sender']);
			$receiver_info = get_userdata($aRow['receiver']);
			$image_src = SMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png";
			$profile_image_src = SMS_PLUGIN_URL . "/assets/images/dashboard_icon/White_icons/Message_Chat.png";
			$row[0] = '<td class="checkbox_width_10px"><input type="checkbox" class="smgt_sub_chk select-checkbox sub_chk" name="id[]" value="' . $aRow['message_id'] . '"></td>';
			$message_for = get_post_meta($aRow['post_id'], 'message_for', true);
			$row[1] = '<td class="user_image width_50px profile_image_prescription padding_left_0">
					<p class="smgt_message_profile prescription_tag padding_15px margin_bottom_0px ' . $color_class . '">
						<img src="' . $profile_image_src . '" height= "30px" width ="30px" alt="" class="massage_image center">
					</p>
				</td>';
			$row[2] = '<td>' . esc_attr__($message_for, 'school-mgt') . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Message For', 'school-mgt') . '" ></i></td>';
			$row[3] = '<td>' . $sender_info->display_name . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Sender', 'school-mgt') . '" ></i></td>';
			$row[4] = '<td>' . $receiver_info->display_name . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Receiver', 'school-mgt') . '" ></i></td>';
			if (get_post_meta($aRow['post_id'], 'smgt_class_id', true) != "" && get_post_meta($aRow['post_id'], 'smgt_class_id', true) == 'all') {
				$row[5] = '<td>' . esc_attr_e('All', 'school-mgt') . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Class', 'school-mgt') . '" ></i></td>';
			} elseif (get_post_meta($aRow['post_id'], 'smgt_class_id', true) != "") {
				$smgt_class_id = get_post_meta($aRow['post_id'], 'smgt_class_id', true);
				$class_id_array = explode(',', $smgt_class_id);
				$class_name_array = array();
				foreach ($class_id_array as $data) {
					$class_name_array[] = mj_smgt_get_class_name($data);
				}
				$row[5] = '<td>' . implode(',', $class_name_array) . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Class', 'school-mgt') . '" ></i></td>';
			} else {
				$row[5] = '<td>' . esc_html__('All', 'school-mgt') . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Class', 'school-mgt') . '" ></i></td>';
			}
			$subject_char = strlen(get_the_title($aRow['post_id']));
			if ($subject_char <= 10) {
				$row[6] = '<td>' . get_the_title($aRow['post_id']) . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Subject', 'school-mgt') . '" ></i></td>';
			} else {
				$char_limit = 10;
				$subject_body = substr(strip_tags(get_the_title($aRow['post_id'])), 0, $char_limit) . "...";
				$row[6] = '<td>' . $subject_body . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Subject', 'school-mgt') . '" ></i></td>';
			}
			$content_post = get_post($aRow['post_id']);
			$body_char = strlen($content_post->post_content);
			if ($body_char <= 60) {
				$row[7] = '<td>' . $content_post->post_content . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Description', 'school-mgt') . '" ></i></td>';
			} else {
				$char_limit = 60;
				$msg_body = substr(strip_tags($content_post->post_content), 0, $char_limit) . "...";
				$row[7] = '<td>' . $msg_body . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Description', 'school-mgt') . '" ></i></td>';
			}
			// $row[6] = $content_post->post_content;
			if (!empty($attchment)) {
				$attchment_array = explode(',', $attchment);
				$view_attchment = '';
				foreach ($attchment_array as $attchment_data) {
					$view_attchment .= '<a target="blank" href="' . content_url() . '/uploads/school_assets/' . $attchment_data . '" class="btn btn-default"><i class="fa fa-download"></i>' . esc_html__('View Attachment', 'school-mgt') . '</a>';
				}
				$row[8] = '<td>' . $view_attchment . '</td>';
			} else {
				$row[8] = '<td>' . esc_attr__('No Attachment', 'school-mgt') . '</td>';
			}
			$created_date = $content_post->post_date_gmt;
			$row[9] = '<td>' . mj_smgt_convert_date_time($created_date) . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="' . esc_html__('Date & Time', 'school-mgt') . '" ></i></td>';
			$row[10] = '<td class="action">
							<div class="smgt-user-dropdown">
								<ul class="" style="margin-bottom: 0px !important;">
									<li class="">
										<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
											<img src="' . $image_src . '" >
										</a>
										<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
											<li class="float_left_width_100">
												<a href="?page=smgt_message&tab=view_all_message&action=delete_users_message&users_message_id=' . $aRow['message_id'] . '" class="float_left_width_100" style="color: #f06c65!important;" onclick="return confirm(language_translate2.delete_record_alert)"><i class="fa fa-trash"></i>' . esc_attr__('Delete', 'school-mgt') . '</a>
												</li>
											</ul>
										</li>
									</ul>
								</div>
							</td>';
			$output['aaData'][] = $row;
			$i++;
		}
		echo json_encode($output);
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_generate_access_token',  'mj_smgt_generate_access_token');
	add_action('wp_ajax_mj_smgt_generate_access_token',  'mj_smgt_generate_access_token');
	function mj_smgt_generate_access_token()
	{
		$CLIENT_ID = get_option('smgt_virtual_classroom_client_id');
		$REDIRECT_URI = site_url() . '/?page=callback';
		wp_redirect("https://zoom.us/oauth/authorize?response_type=code&client_id=" . $CLIENT_ID . "&redirect_uri=" . $REDIRECT_URI);
	}
	add_action('wp_ajax_nopriv_mj_smgt_import_data',  'mj_smgt_import_data');
	add_action('wp_ajax_mj_smgt_import_data',  'mj_smgt_import_data');
	function mj_smgt_import_data()
	{
?>
	<script>
		jQuery(document).ready(function($) {
			$('#inport_csv').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<form class="form-horizontal import_csv_popup_form" id="inport_csv" action="#" method="post" enctype="multipart/form-data">
		<div class="form-body user_form">
			<div class="row">
				<div class="col-md-6 input mt-0">
					<div class="form-group input rtl_margin_top_0px_popup">
						<div class="col-md-12 form-control res_rtl_height_50px">
							<label for="" class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl"><?php _e('Select CSV File', 'school-mgt'); ?><span class="require-field">*</span></label>
							<div class="col-sm-12">
								<input id="input-1" name="csv_file" type="file" class="form-control file validate[required] file_validation">
							</div>
						</div>
					</div>
				</div>
				<?php wp_nonce_field('upload_csv_nonce'); ?>
				<div class="col-lg-6 col-md-6 col-sm-4 col-xs-6 margin_bottom_15">
					<button type="submit" class="btn width-auto save_btn rtl_margin_0px" name="upload_csv_file"><?php esc_attr_e('Upload CSV File', 'school-mgt'); ?></button>
				</div>

				<p><?php esc_attr_e('Instruction : For Import Image First add image To /wp-content/uploads/ folder after that in your csv file add one column user_profile', 'school-mgt'); ?></p>
			</div>
		</div>
	</form>
<?php
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_export_data',  'mj_smgt_export_data');
	add_action('wp_ajax_mj_smgt_export_data',  'mj_smgt_export_data');
	function mj_smgt_export_data()
	{
?>
	<script>
		jQuery(document).ready(function($) {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Export Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body export_csv_padding_18px"><!------- Penal Body ---------->
		<!------- Export Student CSV Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data">
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="role" value="<?php echo $role; ?>" />
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 input smgt_form_select">
						<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Select Class', 'school-mgt'); ?><span class="require-field">*</span></label>
						<select name="class_name" class="form-control validate[required]" id="class_list">
							<option value=""><?php esc_attr_e('Select Class', 'school-mgt'); ?></option>
							<?php
							foreach (mj_smgt_get_allclass() as $classdata) {
							?>
								<option value="<?php echo $classdata['class_id']; ?>"><?php echo $classdata['class_name']; ?></option>
							<?php } ?>
						</select>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 input smgt_form_select">
						<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Select Section', 'school-mgt'); ?></label>
						<select name="class_section" class="form-control" id="class_section">
							<option value=""><?php esc_attr_e('All Section', 'school-mgt'); ?></option>
						</select>
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
			<div class="form-body user_form">
				<div class="row">
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Export IN CSV', 'school-mgt'); ?>" name="exportstudentin_csv" class="save_btn btn btn-success save_btn" />
					</div>
				</div>
			</div>
		</form><!------- Export Student CSV Form ---------->
	</div><!------- Penal Body ---------->
<?php
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_student_import_data',  'mj_smgt_student_import_data');
	add_action('wp_ajax_mj_smgt_student_import_data',  'mj_smgt_student_import_data');
	function mj_smgt_student_import_data()
	{
?>
	<script>
		jQuery(document).ready(function($) {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});
			$(document).on('change', '.csv_file', function() {
				if ($(this).val()) {
					$('.csv_fileformError').hide();
				}
			});

		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body"><!-------- Penal Body ---------->
		<!-------- Import Student Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data">
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="role" value="<?php echo $role; ?>" />
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 input smgt_form_select">
						<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Select Class', 'school-mgt'); ?><span class="require-field">*</span></label>
						<select name="class_name" class="form-control validate[required]" id="class_list_add_student">
							<option value=""><?php esc_attr_e('Select Class', 'school-mgt'); ?></option>
							<?php
							foreach (mj_smgt_get_allclass() as $classdata) {
							?>
								<option value="<?php echo $classdata['class_id']; ?>"><?php echo $classdata['class_name']; ?></option>
							<?php } ?>
						</select>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 input smgt_form_select">
						<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Select Section', 'school-mgt'); ?></label>
						<select name="class_section" class="form-control" id="class_section_add_student">
							<option value=""><?php esc_attr_e('Select Section', 'school-mgt'); ?></option>
						</select>
					</div>
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control res_rtl_height_50px">
								<label for="" class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl"><?php _e('Select CSV file', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file" type="file" class="validate[required] form-control file csvfile_width d-inline file_validation csv_file" name="csv_file">
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3 rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control">
								<div class="row padding_radio">
									<div class="rtl_relative_position">
										<label class="custom-top-label " for="smgt_import_student_mail"><?php esc_attr_e('Send Email', 'school-mgt'); ?></label>
										<input type="checkbox" class="check_box_input_margin" name="smgt_import_student_mail" value="1" <?php echo checked(get_option('smgt_import_student_mail'), 'yes'); ?> /> &nbsp;<?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
			<?php wp_nonce_field('upload_teacher_admin_nonce'); ?>
			<p>
				<strong>1. <?php esc_attr_e('Instruction for Profile image :', 'school-mgt'); ?></strong><br>
				1) <?php esc_attr_e('Add ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile', 'school-mgt'); ?></strong><?php esc_attr_e(' folder in ', 'school-mgt'); ?><strong><?php esc_attr_e('/wp-content/uploads/', 'school-mgt'); ?></strong><?php esc_attr_e(' Path', 'school-mgt'); ?><br>
				2) <?php esc_attr_e('Upload the User Profile photo in ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile', 'school-mgt'); ?></strong><?php esc_attr_e(' folder', 'school-mgt'); ?><br>
				3) <?php esc_attr_e('Add your image path in ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile', 'school-mgt'); ?></strong><?php esc_attr_e(' column in CSV. for example : ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile/image.png', 'school-mgt'); ?></strong><br>
				<strong>2. <?php esc_attr_e('Instruction for Import Custom-Field :', 'school-mgt'); ?></strong><br>
				=> <?php esc_attr_e('Add your custom-field label in ', 'school-mgt'); ?><strong><?php esc_attr_e('custom-field', 'school-mgt'); ?></strong><?php esc_attr_e(' column in CSV.', 'school-mgt'); ?><br>
				=> <?php esc_attr_e('How to add Custom Field Value? ', 'school-mgt'); ?><br>
				1) <?php esc_attr_e('Add your text-field value like : ', 'school-mgt'); ?><strong><?php esc_attr_e('hello world', 'school-mgt'); ?></strong><br>
				2) <?php esc_attr_e('Add your textarea-field value like : ', 'school-mgt'); ?><strong><?php esc_attr_e('hello world', 'school-mgt'); ?></strong><br>
				3) <?php esc_attr_e('Add your dropdown-field value like : ', 'school-mgt'); ?><strong><?php esc_attr_e('dropdown option 1', 'school-mgt'); ?></strong><br>
				4) <?php esc_attr_e('Add your date-field value like : ', 'school-mgt'); ?><strong><?php esc_attr_e('2024-01-01', 'school-mgt'); ?></strong><br>
				5) <?php esc_attr_e('Add your radio-field value like : ', 'school-mgt'); ?><strong><?php esc_attr_e('redio option 1', 'school-mgt'); ?></strong><br>
				6) <?php esc_attr_e('Add your checkbox-field value like : ', 'school-mgt'); ?><strong><?php esc_attr_e('option 1,option 2,option 3	', 'school-mgt'); ?></strong><br>
				<strong>3. <?php esc_attr_e('Instruction for Import Custom-Field Document :', 'school-mgt'); ?></strong><br>
				1) <?php esc_attr_e('Add your document in ', 'school-mgt'); ?><strong><?php esc_attr_e('/wp-content/uploads/school_assets/', 'school-mgt'); ?></strong><?php esc_attr_e(' Path', 'school-mgt'); ?><br>
				2) <?php esc_attr_e('Add your document name in ', 'school-mgt'); ?><strong><?php esc_attr_e('custom-field', 'school-mgt'); ?></strong><?php esc_attr_e(' column in CSV. for example : ', 'school-mgt'); ?><strong><?php esc_attr_e('hello.pdf', 'school-mgt'); ?></strong><br>
			</p>
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Upload CSV File', 'school-mgt'); ?>" name="upload_csv_file" class="btn btn-success save_btn" />
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
		</form><!-------- Import Student Form ---------->
	</div><!-------- Penal Body ---------->
<?php
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_teacher_import_data',  'mj_smgt_teacher_import_data');
	add_action('wp_ajax_mj_smgt_teacher_import_data',  'mj_smgt_teacher_import_data');
	function mj_smgt_teacher_import_data()
	{
?>
	<script>
		jQuery(document).ready(function($) {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});

			$(document).on('change', '.csv_file', function() {
				if ($(this).val()) {
					$('.csv_fileformError').hide();
				}
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body"><!-- panel-body -->
		<!-------- Import Teacher Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data"><!--form div-->
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="role" value="<?php echo $role; ?>" />
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control res_rtl_height_50px">
								<label class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl" for="city_name"><?php esc_attr_e('Select CSV file', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file" type="file" class="validate[required] form-control file csvfile_width d-inline file_validation csv_file" name="csv_file">
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 padding_top_15px_res rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control rtl_relative_position">
								<div class="row padding_radio">
									<div class="">
										<label class="custom-top-label label_position_rtl" for="smgt_import_teacher_mail "> <?php esc_attr_e('Send Email', 'school-mgt'); ?></label>
										<input type="checkbox" class="check_box_input_margin" name="smgt_import_teacher_mail" value="1" <?php echo checked(get_option('smgt_import_teacher_mail'), 'yes'); ?> /> <?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php wp_nonce_field('upload_csv_nonce'); ?>
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Upload CSV File', 'school-mgt'); ?>" name="upload_teacher_csv_file" class="btn btn-success save_btn" />
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
		</form><!--form div-->
	</div><!--panel-body-->
<?php
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_support_staff_import_data',  'mj_smgt_support_staff_import_data');
	add_action('wp_ajax_mj_smgt_support_staff_import_data',  'mj_smgt_support_staff_import_data');
	//----------- Import Support Staff Function --------------//
	function mj_smgt_support_staff_import_data()
	{
?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});

			$(document).on('change', '.csv_file', function() {
				if ($(this).val()) {
					$('.csv_fileformError').hide();
				}
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body"><!-- panel-body -->
		<!-------- Import Teacher Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data"><!--form div-->
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="role" value="<?php echo $role; ?>" />
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control res_rtl_height_50px rtl_relative_position">
								<label class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl" for="city_name"><?php esc_attr_e('Select CSV file', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file" type="file" class="validate[required] form-control file csvfile_width file_validation csv_file" name="csv_file">
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 padding_top_15px_res rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control rtl_relative_position">
								<div class="row padding_radio">
									<div class="">
										<label class="custom-top-label label_position_rtl" for="smgt_import_staff_mail"><?php esc_attr_e('Send Email', 'school-mgt'); ?></label>
										<input type="checkbox" class="check_box_input_margin" name="smgt_import_staff_mail" value="1" <?php echo checked(get_option('smgt_import_staff_mail'), 'yes'); ?> /><?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php wp_nonce_field('upload_csv_nonce'); ?>
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Upload CSV File', 'school-mgt'); ?>" name="upload_staff_csv_file" class="btn btn-success save_btn" />
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
		</form><!--form div-->
	</div><!--panel-body-->
<?php
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_parent_import_data',  'mj_smgt_parent_import_data');
	add_action('wp_ajax_mj_smgt_parent_import_data',  'mj_smgt_parent_import_data');
	//----------- Import Parent Function --------------//
	function mj_smgt_parent_import_data()
	{
?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});

			$(document).on('change', '.csv_file', function() {
				if ($(this).val()) {
					$('.csv_fileformError').hide();
				}
			});
		});
	</script>
	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body"><!-- panel-body -->
		<!-------- Import Teacher Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data"><!--form div-->
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="role" value="<?php echo $role; ?>" />
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control res_rtl_height_50px">
								<label class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl" for="city_name"><?php esc_attr_e('Select CSV file', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file" type="file" class="validate[required] form-control file csvfile_width file_validation csv_file" name="csv_file">
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 padding_top_15px_res rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control rtl_relative_position">
								<div class="row padding_radio">
									<div class="">
										<label class="custom-top-label label_position_rtl" for="smgt_import_parent_mail"> <?php esc_attr_e('Send Email', 'school-mgt'); ?></label>
										<input type="checkbox" class="check_box_input_	margin" name="smgt_import_parent_mail" value="1" <?php echo checked(get_option('smgt_import_parent_mail'), 'yes'); ?> />&nbsp;<?php esc_attr_e('Enable', 'school-mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php wp_nonce_field('upload_csv_nonce'); ?>
					<p>
						<strong><?php esc_attr_e('Instruction for Profile image :', 'school-mgt'); ?></strong><br>
						1) <?php esc_attr_e('Add ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile', 'school-mgt'); ?></strong><?php esc_attr_e(' folder in ', 'school-mgt'); ?><strong><?php esc_attr_e('/wp-content/uploads/', 'school-mgt'); ?></strong><?php esc_attr_e(' Path', 'school-mgt'); ?><br>
						2) <?php esc_attr_e('Upload the User Profile photo in ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile', 'school-mgt'); ?></strong><?php esc_attr_e(' folder', 'school-mgt'); ?><br>
						3) <?php esc_attr_e('Add your image path in ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile', 'school-mgt'); ?></strong><?php esc_attr_e(' column in CSV. for example : ', 'school-mgt'); ?><strong><?php esc_attr_e('user_profile/image.png', 'school-mgt'); ?></strong>
					</p>
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Upload CSV File', 'school-mgt'); ?>" name="upload_parent_csv_file" class="btn btn-success save_btn" />
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
		</form><!--form div-->
	</div><!--panel-body-->
<?php
		die();
	}
	add_action('wp_ajax_nopriv_mj_smgt_subject_import_data',  'mj_smgt_subject_import_data');
	add_action('wp_ajax_mj_smgt_subject_import_data',  'mj_smgt_subject_import_data');
	function mj_smgt_subject_import_data()
	{
		$teacher_obj = new Smgt_Teacher;
?>
	<script>
		jQuery(document).ready(function($) {
			$('#upload_form').validationEngine({
				promptPosition: "bottomLeft",
				maxErrorsPerField: 1
			});
			$('.file_validation ').change(function() {
				var val = $(this).val().toLowerCase();
				var regex = new RegExp("(.*?)\.(csv)$");
				if (!(regex.test(val))) {
					$(this).val('');
					alert("<?php _e('Only CSV formate are allowed.', 'school-mgt'); ?>");
				}
			});

			//--------------- TEACHER BY CLASS ----------//
			$(".class_by_teacher").on('change', function() {
				var class_list = $(".class_by_teacher").val();
				$('#subject_teacher').html('');
				var optionval = $(this);
				var curr_data = {
					action: 'mj_smgt_load_teacher_by_class',
					class_list: class_list,
					dataType: 'json'
				};
				$.post(smgt.ajax, curr_data, function(response) {
					$("#subject_teacher option[value='remove']").remove();
					$('#subject_teacher').append(response);
					jQuery('#subject_teacher').multiselect('rebuild');
					return false;
				});
			});

			$("#subject_teacher").multiselect({
				nonSelectedText: '<?php esc_html_e('Select Teacher', 'school-mgt'); ?>',
				includeSelectAllOption: true,
				selectAllText: '<?php esc_html_e('Select all', 'school-mgt'); ?>',
				templates: {
					button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
				},
			});


		});
	</script>

	<div class="modal-header import_csv_popup">
		<a href="#" class="close-btn-cat badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
		<h4 class="modal-title"><?php esc_attr_e('Import Data', 'school-mgt'); ?></h4>
	</div>
	<div class="panel-body"><!-------- Penal Body ---------->
		<!-------- Import Student Form ---------->
		<form name="upload_form" action="" method="post" class="form-horizontal" id="upload_form" enctype="multipart/form-data" style="padding:10px;">
			<?php $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'; ?>
			<input type="hidden" name="action" value="<?php echo $action; ?>">
			<input type="hidden" name="role" value="<?php echo $role; ?>" />
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 input smgt_form_select">
						<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Select Class', 'school-mgt'); ?><span class="require-field">*</span></label>
						<select name="class_name" class="form-control validate[required] class_by_teacher" id="class_list">
							<option value=""><?php esc_attr_e('Select Class', 'school-mgt'); ?></option>
							<?php
							foreach (mj_smgt_get_allclass() as $classdata) {
							?>
								<option value="<?php echo $classdata['class_id']; ?>"><?php echo $classdata['class_name']; ?></option>
							<?php } ?>
						</select>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 input smgt_form_select">
						<label class="custom-top-label lable_top top" for="class_name"><?php esc_attr_e('Select Section', 'school-mgt'); ?></label>
						<select name="class_section" class="form-control" id="class_section">
							<option value=""><?php esc_attr_e('All Section', 'school-mgt'); ?></option>
						</select>
					</div>
					<div class="col-md-6 rs_mb_15px rtl_margin_top_15px">
						<div id="res_rtl_width_100" class="rtl_subject_import_data_multiple col-sm-12 rtl_padding_left_right_0px multiselect_validation_teacher smgt_multiple_select teacher_list">
							<?php
							$teachval = array();
							$teacherdata_array = mj_smgt_get_usersdata('teacher');
							?>
							<select name="subject_teacher[]" multiple="multiple" id="subject_teacher" class="form-control validate[required] teacher_list">
								<?php
								foreach ($teacherdata_array as $teacherdata) {
								?>
									<option value="<?php echo $teacherdata->ID; ?>" <?php echo $teacher_obj->mj_smgt_in_array_r($teacherdata->ID, $teachval) ? 'selected' : ''; ?>><?php echo $teacherdata->display_name; ?></option>
								<?php
								}
								?>
							</select>
							<span class="multiselect_label">
								<label class="ml-1 custom-top-label top" for="staff_name"><?php esc_html_e('Select Teacher', 'school-mgt'); ?><span class="required">*</span></label>
							</span>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group input">
							<div class="col-md-12 form-control res_rtl_height_50px">
								<label for="" class="custom-control-label custom-top-label ml-2 margin_left_30px label_position_rtl"><?php _e('Select CSV file', 'school-mgt'); ?><span class="require-field">*</span></label>
								<div class="col-sm-12">
									<input id="csv_file" type="file" class="validate[required] form-control file csvfile_width d-inline file_validation csv_file" name="csv_file">
								</div>
							</div>
						</div>
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
			<?php wp_nonce_field('upload_subject_admin_nonce'); ?>
			<div class="form-body user_form"> <!--form Body div-->
				<div class="row"><!--Row Div-->
					<div class="col-sm-6">
						<input type="submit" value="<?php esc_attr_e('Upload CSV File', 'school-mgt'); ?>" name="upload_csv_file" class="btn btn-success save_btn" />
					</div>
				</div> <!--Row Div-->
			</div><!--form Body div-->
		</form><!-------- Import Student Form ---------->
	</div><!-------- Penal Body ---------->
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_load_multiple_day', 'mj_smgt_load_multiple_day');
	add_action('wp_ajax_nopriv_mj_smgt_load_multiple_day',  'mj_smgt_load_multiple_day');
	function mj_smgt_load_multiple_day()
	{
		$obj_leave = new SmgtLeave;
		$duration = $_REQUEST['duration'];
		$leave_id = $_REQUEST['idset'];
		$edit = 0;
		if ($leave_id != '') {
			$edit = 1;
			$result = $obj_leave->hrmgt_get_single_leave($leave_id);
		}
?>
	<script type="text/javascript">
		$(document).ready(function() { //EVENT VALIDATIONENGINE
			"use strict";
			var start = new Date();
			var end = new Date(new Date().setYear(start.getFullYear() + 1));
			$(".leave_start_date").datepicker({
				dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
				changeYear: true,
				changeMonth: true,
				minDate: 0,
				onSelect: function(selected) {
					var dt = new Date(selected);
					dt.setDate(dt.getDate() + 0);
					$(".leave_end_date").datepicker("option", "minDate", dt);
				},
				beforeShow: function(textbox, instance) {
					instance.dpDiv.css({
						marginTop: (-textbox.offsetHeight) + 'px'
					});
				}
			});
			$(".leave_end_date").datepicker({
				dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
				changeYear: true,
				changeMonth: true,
				minDate: 0,
				onSelect: function(selected) {
					var dt = new Date(selected);
					dt.setDate(dt.getDate() - 0);
					$(".leave_start_date").datepicker("option", "maxDate", dt);
				},
				beforeShow: function(textbox, instance) {
					instance.dpDiv.css({
						marginTop: (-textbox.



							Height) + 'px'
					});
				}
			});
		});
	</script>
	<?php
		if ($duration == 'more_then_day') {
	?>
		<div class="row">
			<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
				<div class="form-group input">
					<div class="col-md-12 form-control">
						<input id="leave_start_date" class="form-control validate[required] leave_start_date datepicker1" autocomplete="off" type="text" name="start_date" value="<?php if ($edit) {
																																														echo mj_smgt_getdate_in_input_box($result->start_date);
																																													} elseif (isset($_POST['start_date'])) echo mj_smgt_getdate_in_input_box($_POST['start_date']);
																																													else echo mj_smgt_getdate_in_input_box(date("Y-m-d")); ?>">
						<label class="active" for="start"><?php esc_html_e('Leave Start Date', 'school-mgt'); ?><span class="require-field">*</span></label>
					</div>
				</div>
			</div>
			<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
				<div class="form-group input">
					<div class="col-md-12 form-control">
						<input id="leave_end_date" class="form-control validate[required] leave_end_date datepicker2" type="text" name="end_date" autocomplete="off" value="<?php if ($edit) {
																																												echo esc_attr(date("Y-m-d", strtotime($result->end_date)));
																																											} elseif (isset($_POST['end_date'])) {
																																												echo esc_attr($_POST['end_date']);
																																											} else {
																																												echo mj_smgt_getdate_in_input_box(date("Y-m-d"));
																																											} ?>">
						<label class="active" for="end"><?php esc_html_e('Leave End Date', 'school-mgt'); ?><span class="require-field">*</span></label>
					</div>
				</div>
			</div>
		</div>
	<?php
		} else { ?>
		<div class="form-group input">
			<div class="col-md-12 form-control">
				<input id="leave_start_date" class="form-control validate[required] leave_start_date start_date datepicker1" autocomplete="off" type="text" name="start_date" value="<?php if ($edit) {
																																															echo mj_smgt_getdate_in_input_box($result->start_date);
																																														} elseif (isset($_POST['start_date'])) echo mj_smgt_getdate_in_input_box($_POST['start_date']);
																																														else echo mj_smgt_getdate_in_input_box(date("Y-m-d")); ?>">
				<label class="active" for="start"><?php esc_html_e('Leave Start Date', 'school-mgt'); ?><span class="require-field">*</span></label>
			</div>
		</div>
	<?php
		} ?>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_admission_repot_load_date', 'mj_smgt_admission_repot_load_date');
	add_action('wp_ajax_nopriv_mj_smgt_admission_repot_load_date',  'mj_smgt_admission_repot_load_date');
	function mj_smgt_admission_repot_load_date()
	{
		$date_type = sanitize_text_field($_REQUEST['date_type']);
?>
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			"use strict";
			$("#report_sdate").datepicker({
				dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
				changeYear: true,
				changeMonth: true,
				maxDate: 0,
				onSelect: function(selected) {
					var dt = new Date(selected);
					dt.setDate(dt.getDate() + 0);
					$("#report_edate").datepicker("option", "minDate", dt);
				}
			});
			$("#report_edate").datepicker({
				dateFormat: "<?php echo get_option('smgt_datepicker_format'); ?>",
				changeYear: true,
				changeMonth: true,
				maxDate: 0,
				onSelect: function(selected) {
					var dt = new Date(selected);
					dt.setDate(dt.getDate() - 0);
					$("#report_sdate").datepicker("option", "maxDate", dt);
				}
			});
		});
	</script>
	<?php
		if ($date_type == 'period') {
	?>
		<div class="row">
			<div class="col-md-6 mb-2">
				<div class="form-group input">
					<div class="col-md-12 form-control">
						<input type="text" id="report_sdate" class="form-control" name="start_date" value="<?php if (isset($_REQUEST['start_date'])) echo $_REQUEST['start_date'];
																											else echo date('Y-m-d'); ?>" readonly>
						<label for="userinput1" class="active"><?php esc_html_e('Start Date', 'school-mgt'); ?></label>
					</div>
				</div>
			</div>
			<div class="col-md-6 mb-2">
				<div class="form-group input">
					<div class="col-md-12 form-control">
						<input type="text" id="report_edate" class="form-control" name="end_date" value="<?php if (isset($_REQUEST['edate'])) echo $_REQUEST['end_date'];
																											else echo date('Y-m-d'); ?>" readonly>
						<label for="userinput1" class="active"><?php esc_html_e('End Date', 'school-mgt'); ?></label>
					</div>
				</div>
			</div>
		</div>
	<?php
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_edit_section',  'mj_smgt_edit_section');
	add_action('wp_ajax_nopriv_mj_smgt_edit_section', 'mj_smgt_edit_section');
	function mj_smgt_edit_section()
	{
		$model = $_REQUEST['model'];
		$cat_id = $_REQUEST['cat_id'];
		$retrieved_data = mj_smgt_single_section($cat_id);

	?>
	<div class="form-body user_form">
		<div class="row">
			<div class="col-md-10 width_70 margin_right_10px_res">
				<div class="form-group input rtl_margin_0px">
					<div class="col-md-12 form-control">
						<input type="text" class="validate[required,custom[popup_category_validation]]" name="section_name" maxlength="50" value="<?php echo $retrieved_data->section_name; ?>" id="section_name">
					</div>
				</div>
			</div>
			<div class="row col-md-2 margin_top_10px_web padding_left_0_res width_30 margin_top_13px_res" id="<?php echo $retrieved_data->id; ?>">
				<div class="col-md-6 width_50_res padding_left_0">
					<a class="btn-cat-update-cancel" model="<?php echo $model; ?>" href="#" id="<?php echo $retrieved_data->id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/cencal.png"; ?>" alt=""></a>
				</div>
				<div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_left_0">
					<a class="btn-cat-update" model="<?php echo $model; ?>" href="#" id="<?php echo $retrieved_data->id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/save.png"; ?>" alt=""> </a>
				</div>
			</div>
		</div>
	</div>
	<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_load_teacher_by_class',  'mj_smgt_load_teacher_by_class');
	add_action('wp_ajax_nopriv_mj_smgt_load_teacher_by_class',  'mj_smgt_load_teacher_by_class');
	function mj_smgt_load_teacher_by_class()
	{
		$class_id = $_POST['class_list'];
		$teacherdata	= 	mj_smgt_get_teacher_by_class_id($class_id);
		foreach ($teacherdata as $retrieved_data) {
			if ($retrieved_data->ID != "") {
				echo "<option value=" . $retrieved_data->ID . "> " . $retrieved_data->display_name . "</option>";
			}
		}
		exit;
	}
	//-------------------- UPDATE POPUP VALUE CATEGORY ---------//
	add_action('wp_ajax_mj_smgt_update_cetogory_popup_value', 'mj_smgt_update_cetogory_popup_value');
	add_action('wp_ajax_nopriv_mj_smgt_update_cetogory_popup_value', 'mj_smgt_update_cetogory_popup_value');
	function mj_smgt_update_cetogory_popup_value()
	{
		$model = sanitize_text_field($_REQUEST['model']);
		$cat_id = sanitize_text_field($_REQUEST['cat_id']);
		$category_name = sanitize_text_field($_REQUEST['category_name']);
		$dlt_image = SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png";
		$edit_image = SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png";
		$edited_post = array(
			'ID'           => $cat_id,
			'post_title' => $category_name
		);
		$result = wp_update_post($edited_post);
		if ($model == 'smgt_bookperiod') {
			$row1 = '<div class="col-md-10 width_70">' . get_the_title($cat_id) . '' . esc_attr__('Days', 'school-mgt') . '</div>';
			$row1 .= '<div class="row col-md-2 padding_left_0_res width_30" id=' . $cat_id . '><div class="col-md-6 width_50_res padding_left_0" ><a href="#" class="btn-delete-cat_new" model="' . $model . '" id="' . $cat_id . '"><img src="' . $dlt_image . '" alt=""></a></div><div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0"><a class="btn-edit-cat_popup" model="' . $model . '" href="#" id="' . $cat_id . '"><img src="' . $edit_image . '" alt="" style="height: 40px; width: 40px;"></a></div></div>';
			$option = "<option value='$cat_id'>" . $_REQUEST['category_name'] . '' . esc_attr__('Days', 'school-mgt') . '' . "</option>";
		} else {
			$row1 = '<div class="col-md-10 width_70">' . get_the_title($cat_id) . '</div>';
			$row1 .= '<div class="row col-md-2 padding_left_0_res width_30" id=' . $cat_id . '><div class="col-md-6 width_50_res padding_left_0" ><a href="#" class="btn-delete-cat_new" model="' . $model . '" id="' . $cat_id . '"><img src="' . $dlt_image . '" alt=""></a></div><div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0"><a class="btn-edit-cat_popup" model="' . $model . '" href="#" id="' . $cat_id . '"><img src="' . $edit_image . '" alt=""></a></div></div>';
			$option = "<option value='$cat_id'>" . $_REQUEST['category_name'] . "</option>";
		}
		$array_var[] = $row1;
		$array_var[] = $option;
		echo json_encode($array_var);
		die();
	}
	add_action('wp_ajax_mj_smgt_update_cancel_popup', 'mj_smgt_update_cancel_popup');
	add_action('wp_ajax_nopriv_mj_smgt_update_cancel_popup', 'mj_smgt_update_cancel_popup');
	//------------ CANCEL POPUP --------//
	function mj_smgt_update_cancel_popup()
	{
		$model = sanitize_text_field($_REQUEST['model']);
		$cat_result = mj_smgt_get_all_category($model);
		$i = 1;
		if (!empty($cat_result)) {
			foreach ($cat_result as $retrieved_data) {
	?>
			<div class="row new_popup_padding" id="<?php echo "cat_new-" . $retrieved_data->ID . ""; ?>">
				<div class="col-md-10 width_70">
					<?php
					echo $retrieved_data->post_title;
					?>
				</div>
				<div class="row col-md-2 padding_left_0_res width_30" id="<?php echo $retrieved_data->ID; ?>">
					<div class="col-md-6 width_50_res padding_left_0">
						<a href="#" class="btn-delete-cat_new" model="<?php echo $model; ?>" id="<?php echo $retrieved_data->ID; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></a>
					</div>
					<div class="col-md-6 edit_btn_padding_left_25px_res width_50_res padding_right_0">
						<a class="btn-edit-cat_popup" model="<?php echo $model; ?>" href="#" id="<?php echo $retrieved_data->ID; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/edit.png" ?>" alt=""></a>
					</div>
				</div>
			</div>
	<?php
				$i++;
			}
		}
		die();
	}
	add_action('wp_ajax_mj_smgt_edit_popup_value', 'mj_smgt_edit_popup_value');
	add_action('wp_ajax_nopriv_mj_smgt_edit_popup_value', 'mj_smgt_edit_popup_value');
	function mj_smgt_edit_popup_value()
	{
		$model = sanitize_text_field($_REQUEST['model']);
		$cat_id = sanitize_text_field($_REQUEST['cat_id']);
		$category_value = get_the_title($cat_id);
	?>
	<div class="form-body user_form">
		<div class="row">
			<div class="col-md-10 width_70 margin_right_10px_res">
				<div class="form-group input rtl_padding_top ">
					<div class="col-md-12 form-control">
						<input type="text" class="validate[required,custom[popup_category_validation]]" name="category_name" maxlength="50" value="<?php echo $category_value; ?>" id="category_name_edit">
					</div>
				</div>
			</div>
			<div class="row col-md-2 margin_top_10px_web padding_left_0_res width_30 margin_top_13px_res" id="<?php echo $cat_id; ?>">
				<div class="col-md-6 padding_left_0 width_50_res">
					<a class="btn-cat-update-cancel_popup" model="<?php echo $model; ?>" href="#" id="<?php echo $cat_id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/cencal.png" ?>" alt=""></a>
				</div>
				<div class="col-md-6 width_50_res edit_btn_padding_left_25px_res">
					<a class="btn-cat-update_popup" model="<?php echo $model; ?>" href="#" id="<?php echo $cat_id; ?>"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/save.png" ?>" alt=""> </a>
				</div>
			</div>
		</div>
	</div>
<?php
		die();
	}

	add_action('wp_ajax_mj_smgt_load_more_document',  'mj_smgt_load_more_document');
	add_action('wp_ajax_nopriv_mj_smgt_load_more_document',  'mj_smgt_load_more_document');
	function mj_smgt_load_more_document()
	{
		?>
		<div class="form-body user_form">
			<div class="row">
				<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 error_msg_left_margin">
					<div class="form-group input">
						<div class="col-md-12 form-control">
							<input class="form-control text-input" maxlength="50" type="text" value="" name="document_title[]">
							<label class="" for="document_title"><?php esc_attr_e('Ducument Title', 'school-mgt'); ?></label>
						</div>
					</div>
				</div>
				<div class="col-md-5 col-10 col-sm-1">
					<div class="form-group input">
						<div class="col-md-12 form-control upload-profile-image-patient res_rtl_height_50px file_height_padding">
							<label for="photo" class="custom-control-label custom-top-label ml-2"><?php esc_attr_e('Document File', 'school-mgt'); ?></label>
							<div class="col-sm-12 display_flex">
								<input name="document_file[]" type="file" class="p-1 form-control file_validation file" value="<?php esc_html_e('Upload image', 'school-mgt'); ?>" />
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-1 col-2 col-sm-3 col-xs-12">
					<input type="image" onclick="deleteParentElement(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px float_right remove_cirtificate input_btn_height_width">
				</div>
			</div>
		</div>
		<?php
		die();
	}

	add_action('wp_ajax_mj_smgt_load_more_subject_information',  'mj_smgt_load_more_subject_information');
	add_action('wp_ajax_nopriv_mj_smgt_load_more_subject_information',  'mj_smgt_load_more_subject_information');
	// ADD SUBJECT LOAD MORE INFORMATION 
	function mj_smgt_load_more_subject_information()
	{
		$x = sanitize_text_field($_REQUEST['click_val']);
?>
	<script>
		jQuery(document).ready(function($) {
			$("body").on("change", "#class_list_subject_<?php echo $x; ?>", function() {
				$('#class_section_subject_<?php echo $x; ?>').html('');
				$('#class_section_subject_<?php echo $x; ?>').append('<option value="remove">Loading..</option>');
				var selection = $("#class_list_subject_<?php echo $x; ?>").val();
				var optionval = $(this);
				var curr_data = {
					action: 'mj_smgt_load_class_section',
					class_id: selection,
					dataType: 'json'
				};
				$.post(smgt.ajax, curr_data, function(response) {
					$("#class_section_subject_<?php echo $x; ?> option[value='remove']").remove();
					$('#class_section_subject_<?php echo $x; ?>').append(response);
				});
				return false;
			});
			$(".class_by_teacher_subject_<?php echo $x; ?>").on('change', function() {
				var class_list = $(".class_by_teacher_subject_<?php echo $x; ?>").val();
				$('#subject_teacher_subject_<?php echo $x; ?>').html('');
				var optionval = $(this);
				var curr_data = {
					action: 'mj_smgt_load_teacher_by_class',
					class_list: class_list,
					dataType: 'json'
				};
				$.post(smgt.ajax, curr_data, function(response) {
					$("#subject_teacher_subject_<?php echo $x; ?> option[value='remove']").remove();
					$('#subject_teacher_subject_<?php echo $x; ?>').append(response);
					jQuery('#subject_teacher_subject_<?php echo $x; ?>').multiselect('rebuild');
					return false;
				});
			});
			$("#subject_teacher_subject_<?php echo $x; ?>").multiselect({
				nonSelectedText: '<?php esc_html_e('Select Teacher', 'school-mgt'); ?>',
				includeSelectAllOption: true,
				selectAllText: '<?php esc_html_e('Select all', 'school-mgt'); ?>',
				templates: {
					button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
				},
			});
		});
	</script>
	<div class="form-body user_form">
		<div class="row">
			<hr>
			<div class="col-md-6">
				<div class="form-group input">
					<div class="col-md-12 form-control">
						<input id="subject_code_<?php echo $x; ?>" class="form-control validate[required,custom[onlyLetterNumber],maxSize[8],min[0]] text-input" type="text" maxlength="50" value="" name="subject_code[]">
						<label for="userinput1" class=""><?php esc_html_e('Subject Code', 'school-mgt'); ?><span class="required">*</span></label>
					</div>
				</div>
			</div>
			<div class="col-md-6 input error_msg_left_margin">
				<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Class', 'school-mgt'); ?><span class="required">*</span></label>
				<select name="subject_class[]" class="form-control validate[required] width_100 class_by_teacher_subject_<?php echo $x; ?>" id="class_list_subject_<?php echo $x; ?>" style="height:47px">
					<option value=""><?php echo esc_attr_e('Select Class', 'school-mgt'); ?></option>
					<?php foreach (mj_smgt_get_allclass() as $classdata) { ?>
						<option value="<?php echo $classdata['class_id']; ?>"><?php echo $classdata['class_name']; ?></option>
					<?php } ?>
				</select>
			</div>
			<div class="col-md-6 input">
				<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Class Section', 'school-mgt'); ?></label>
				<select name="class_section[]" class="form-control width_100" id="class_section_subject_<?php echo $x; ?>" style="height:47px">
					<option value=""><?php esc_attr_e('All Section', 'school-mgt'); ?></option>

				</select>
			</div>
			<?php
			$school_obj = new School_Management(get_current_user_id());
			if ($school_obj->role == 'teacher') {
				$user_id = get_current_user_id();
			?>
				<div class="col-md-5 input">
					<input type="hidden" name="subject_teacher[0][]" value="<?php echo $user_id; ?>">
				</div>
			<?php
			} else {
			?>
				<div class="col-md-5 col-10 rtl_margin_top_15px teacher_list_multiselect">
					<div class="col-sm-12 multiselect_validation_teacher smgt_multiple_select rtl_padding_left_right_0px res_rtl_width_100">
						<?php $teacherdata_array = mj_smgt_get_usersdata('teacher'); ?>
						<select name="subject_teacher[<?php echo $x; ?>][]" multiple="multiple" id="subject_teacher_subject_<?php echo $x; ?>" class="form-control validate[required]">
							<?php
							foreach ($teacherdata_array as $teacherdata) { ?>
								<option value="<?php echo $teacherdata->ID; ?>"><?php echo $teacherdata->display_name; ?></option>
							<?php } ?>
						</select>
						<span class="multiselect_label">
							<label class="ml-1 custom-top-label top" for="staff_name"><?php esc_html_e('Select Teacher', 'school-mgt'); ?><span class="required">*</span></label>
						</span>
					</div>
				</div>
			<?php
			}
			?>
			<div class="col-md-1 col-2 col-sm-3 col-xs-12">
				<input type="image" onclick="deleteParentElement(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px float_right remove_cirtificate input_btn_height_width">
			</div>
		</div>
	</div>
<?php
		die();
	}
	add_action('wp_ajax_mj_smgt_load_other_user_homework', 'mj_smgt_load_other_user_homework');
	add_action('wp_ajax_nopriv_mj_smgt_load_other_user_homework', 'mj_smgt_load_other_user_homework');
	function mj_smgt_load_other_user_homework()
	{
		global $wpdb;
		$document_for = $_POST['document_for'];
		$defaultmsg = esc_attr__('All ' . $document_for . '', 'school-mgt');
		global $wpdb;
		echo "<option value='all " . $document_for . "'>" . $defaultmsg . "</option>";
		$retrieve_data = get_users(array('role' => $document_for));
		foreach ($retrieve_data as $users) {
			echo "<option value=" . $users->ID . ">" . $users->first_name . " " . $users->last_name .  "</option>";
		}
		die();
	}

	add_action('wp_ajax_mj_smgt_ajax_smgt_view_result',  'mj_smgt_ajax_smgt_view_result');
	function mj_smgt_ajax_smgt_view_result()
	{
		$obj_mark = new Marks_Manage();
		$uid = intval($_REQUEST['student_id']);
		$exam_id = intval($_REQUEST['exam_id']);
		$user = get_userdata($uid);
		$user_meta = get_user_meta($uid);
		$class_id = $user_meta['class_name'][0];
		$section_id = $user_meta['class_section'][0];
		$subject = $obj_mark->mj_smgt_student_subject_list($class_id, $section_id);
		$total_subject = count($subject);
		$total = 0;
		$grade_point = 0;
?>
	<style>
		.modal-header {
			height: auto;
		}
	</style>
	<div class="panel-white">
		<div class="modal-header model_header_padding dashboard_model_header">
			<a href="javascript:void(0);" class="close-btn badge badge-success pull-right dashboard_pop-up_design"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></a>
			<h4 id="myLargeModalLabel" class="modal-title"><?php echo mj_smgt_get_user_name_byid($uid); ?>'s <?php esc_attr_e('Result', 'school-mgt') ?></h4>
		</div>
		<?php
		if (!empty($exam_id)) {
			$exam_name = mj_smgt_get_exam_name_id($exam_id);
		?>
			<div class="clearfix"></div>
			<div id="accordionExample" class="accordion student_accordion" aria-multiselectable="true" role="tablist">
				<div class="mt-2 accordion-item">
					<h4 class="accordion-header" id="heading_<?php echo $i; ?>">
						<button class="accordion-button student_result_collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse_<?php echo $i; ?>">
							<div class="col-md-10 col-7">
								<span class="student_exam_result"><?php esc_attr_e('Exam Results : ', 'school-mgt'); ?></span> &nbsp;
								<span class="student_exam_name"><?php echo esc_html($exam_name); ?></span>
							</div>
							<?php
							$new_marks = [];
							foreach ($subject as $sub) {
								$marks = $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid);
								if (!empty($marks)) {
									$new_marks[$sub->subid] = $marks;
								}
							}
							if (!empty($new_marks)) 
							{
							?>
								<div class="col-md-2 row justify-content-end smt_view_result">
									<div class="col-md-5 width_50">
										<a href="?page=smgt_student&print=pdf&student=<?php echo MJ_smgt_encrypt_id($uid); ?>&exam_id=<?php echo MJ_smgt_encrypt_id($exam_id); ?>" class="float_right" target="_blank">
											<img src="<?php echo esc_url(SMS_PLUGIN_URL . "/assets/images/dashboard_icon/PDF.png"); ?>" alt="">
										</a>
									</div>
									<div class="col-md-4 width_50 rtl_margin_left_20px exam_result_pdf_margin" style="margin-right:22px;">
										<a href="?page=smgt_student&print=print&student=<?php echo MJ_smgt_encrypt_id($uid); ?>&exam_id=<?php echo MJ_smgt_encrypt_id($exam_id); ?>" class="float_right" target="_blank">
											<img src="<?php echo esc_url(SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Print.png"); ?>" alt="">
										</a>
									</div>
								</div>
							<?php } else { ?>
								<span class="student_exam_name">
									<?php esc_attr_e('No Result', 'school-mgt'); ?>
								</span>
							<?php } ?>
						</button>
					</h4>
					<div id="collapse_<?php echo $i; ?>" class="accordion-collapse wizard_accordion_rtl collapse show" aria-labelledby="heading_<?php echo $i; ?>" data-bs-parent="#accordionExample">
						<div class="view_result">
							<?php if (!empty($new_marks)) { ?>
								<div class="table-responsive view_result_table_responsive">
									<table class="table table-bordered">
										<tr>
											<th class="view_result_table_heading"><?php esc_attr_e('Subject', 'school-mgt'); ?></th>
											<th class="view_result_table_heading"><?php esc_attr_e('Max Marks', 'school-mgt'); ?></th>
											<th class="view_result_table_heading"><?php esc_attr_e('Pass Marks', 'school-mgt'); ?></th>
											<th class="view_result_table_heading"><?php esc_attr_e('Obtain Mark', 'school-mgt'); ?></th>
											<th class="view_result_table_heading"><?php esc_attr_e('Grade', 'school-mgt'); ?></th>
											<th class="view_result_table_heading"><?php esc_attr_e('Marks Comment', 'school-mgt'); ?></th>
										</tr>
										<?php
										$total = 0;
										$total_max_mark = 0;
										$grade_point = 0;
										$total_pass_mark = 0;
										$result = array();
										$result1 = array();
										foreach ($subject as $sub) {
											if ($obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid) >= $obj_mark->mj_smgt_get_pass_marks($exam_id)) {
												$result[] = "pass";
											} else {
												$result1[] = "fail";
											}
											$marks = isset($new_marks[$sub->subid]) ? $new_marks[$sub->subid] : 0;
										?>
											<tr>
												<td class="view_result_table_value"><?php echo esc_html($sub->sub_name); ?></td>
												<td class="view_result_table_value"><?php echo $obj_mark->mj_smgt_get_max_marks($exam_id); ?></td>
												<td class="view_result_table_value"><?php echo $obj_mark->mj_smgt_get_pass_marks($exam_id); ?> </td>
												<td class="view_result_table_value"><?php echo $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid); ?> </td>
												<td class="view_result_table_value"><?php echo esc_html($obj_mark->mj_smgt_get_grade($exam_id, $class_id, $sub->subid, $uid)); ?></td>
												<td class="view_result_table_value"><?php echo esc_html($obj_mark->mj_smgt_get_marks_comment($exam_id, $class_id, $sub->subid, $uid)); ?></td>
											</tr>
										<?php
											//$total += $marks;
											$grade_point += $obj_mark->mj_smgt_get_grade_point($exam_id, $class_id, $sub->subid, $uid);
											$total +=  $obj_mark->mj_smgt_get_marks($exam_id, $class_id, $sub->subid, $uid);
											$total_max_mark += $obj_mark->mj_smgt_get_max_marks($exam_id);
											$total_pass_mark += $obj_mark->mj_smgt_get_pass_marks($exam_id);
										}
										?>

										<tfoot>
											<tr class="table_color tfoot_border mt_10" style=" border-bottom: 1px solid #000;">
												<th><?php esc_attr_e('TOTAL MARKS', 'school-mgt') ?></th>
												<th><?php
													if (!empty($total_max_mark)) {
														echo $total_max_mark;
													} else {
														echo "-";
													}
													?></th>
												<th>
													<?php
													if (!empty($total_pass_mark)) {
														echo $total_pass_mark;
													} else {
														echo "-";
													}
													?></th>
												<th><?php
													if (!empty($total)) {
														echo $total;
													} else {
														echo "-";
													}
													?></th>
												<th></th>
												<th></th>
											</tr>
										</tfoot>
									</table>
									<div class="row col-md-12">
										<div class="col-md-4 view_result_total">
											<?php esc_attr_e("Percentage", "school-mgt");
											echo " : "; ?>
											<span class="view_result_total_int"><?php
																				$percentage = $total / $total_max_mark * 100;
																				if (!empty($percentage)) {
																					echo number_format($percentage, 2, '.', '');
																				} else {
																					echo "-";
																				}
																				?></span>
										</div>
										<div class="col-md-4 view_result_total">
											<?php esc_attr_e("GPA(grade point average)", "school-mgt");
											echo " : "; ?>
											<span class="view_result_total_int"><?php echo round($grade_point / max(count($subject), 1), 2); ?></span>
										</div>
										<div class="col-md-4 view_result_total">
											<?php esc_attr_e("Result", "school-mgt");
											echo " : "; ?>
											<span class="view_result_total_int <?php
																				if ((isset($result) && in_array("pass", $result) && isset($result1) && in_array("fail", $result1)) || (isset($result1) && in_array("fail", $result1))) {
																					echo 'text-danger'; // Red color for Fail
																				} elseif (isset($result) && in_array("pass", $result)) {
																					echo 'text-success'; // Green color for Pass
																				}
																				?>">
												<?php
												if (isset($result) && in_array("pass", $result) && isset($result1) && in_array("fail", $result1)) {
													esc_html_e('Fail', 'school-mgt');
												} elseif (isset($result) && in_array("pass", $result)) {
													esc_html_e('Pass', 'school-mgt');
												} elseif (isset($result1) && in_array("fail", $result1)) {
													esc_html_e('Fail', 'school-mgt');
												} else {
													echo "-";
												}
												?>
											</span>
										</div>
									</div>
								</div>
							<?php } else { ?>
								<div class="col-md-12 text-center p-3">
									<span class="student_exam_name">
										<?php esc_attr_e('No Result Available.', 'school-mgt'); ?>
									</span>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>

	</div>
<?php
		} else {
?>
	<div class="modal-header model_header_padding dashboard_model_header">
		<h6 id="myLargeModalLabel"><?php echo esc_attr_e('No Result Found', 'school-mgt'); ?></h6>
	</div>
<?php
		}
		exit;
	}

	add_action('wp_ajax_mj_smgt_load_more_constributions',  'mj_smgt_load_more_constributions');
	add_action('wp_ajax_nopriv_mj_smgt_load_more_constributions',  'mj_smgt_load_more_constributions');
	function mj_smgt_load_more_constributions()
	{
?>
<div class="form-body user_form">
	<div class="row">
		<div class="col-md-6">
			<div class="form-group input">
				<div class="col-md-12 form-control">
					<input class="form-control" maxlength="50" type="text" value="" name="contributions_label[]">
					<label for="userinput1" class=""><?php esc_html_e('Contributions Label', 'school-mgt'); ?></label>
				</div>
			</div>
		</div>
		<div class="col-md-5 col-10">
			<div class="form-group input error_msg_left_margin">
				<div class="col-md-12 form-control">
					<input class="form-control onlyletter_number_space_validation text-input" type="number" value="" name="contributions_mark[]">
					<label for="userinput1" class=""><?php esc_html_e('Contributions Marks', 'school-mgt'); ?></label>
				</div>
			</div>
		</div>
		<div class="col-md-1 col-2 col-sm-3 col-xs-12">
			<input type="image" onclick="deleteParentElementConstribution(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px remove_cirtificate input_btn_height_width" style="float:right;">
		</div>
	</div>
</div>
<?php
		die();
	}

	add_action('wp_ajax_mj_smgt_load_library_card_no',  'mj_smgt_load_library_card_no');
	add_action('wp_ajax_nopriv_mj_smgt_load_library_card_no',  'mj_smgt_load_library_card_no');
	// LOAD LIBRARY CARD NUMBER
	function mj_smgt_load_library_card_no()
	{
		$user_id = intval($_REQUEST['user_id']);
		$obj_lib = new Smgtlibrary();
		$library_card_no =  $obj_lib->mj_smgt_get_library_card_for_student($user_id);
		$library_card_name = '';
		if (!empty($library_card_no)) {
			$library_card =  $library_card_no[0]->library_card_no;
			if (!empty($library_card)) {
				$library_card_name = $library_card;
			}
		}
		echo $library_card_name;
	}
	add_action('wp_ajax_add_more_merge_result',  'add_more_merge_result');
	add_action('wp_ajax_nopriv_add_more_merge_result',  'add_more_merge_result');
	function add_more_merge_result()
	{ 
		$class_name=$_REQUEST['class_name'];
		$section_name=$_REQUEST['section_name'];
	?>
	<div class="form-body user_form">
		<div class="row">
			<div class="col-md-4 input">
				<label class="ml-1 custom-top-label top" for="hmgt_contry"><?php esc_html_e('Select Exam', 'school-mgt'); ?><span class="require-field">*</span></label>
				<select name="exam_id[]" class="line_height_30px form-control exam_list validate[required] text-input">
				<option value=""><?php esc_attr_e('Select Exam', 'school-mgt'); ?></option>
					<?php
					$exam_data = mj_smgt_get_all_exam_by_class_id_and_section_id_array($class_name,$section_name);
					if (!empty($exam_data)) 
					{
						foreach ($exam_data as $retrieved_data) 
						{
						?>
							<option value="<?php echo $retrieved_data->exam_id; ?>" <?php selected($_POST['exam_id'], $retrieved_data->exam_id);  ?>><?php echo $retrieved_data->exam_name; ?></option>
						<?php
						}
					}
					?>
				</select>
			</div>
			<div class="col-md-4 col-10">
			<div class="form-group input error_msg_left_margin">
				<div class="col-md-12 form-control">
					<input class="form-control onlyletter_number_space_validation text-input" type="number" value="" name="weightage[]">
					<label for="userinput1" class=""><?php esc_html_e('Weightage of the exam','school-mgt');?></label>
				</div>
			</div>
		</div>
		<div class="col-md-1 col-2 col-sm-3 col-xs-12">
			<input type="image" onclick="deleteParentElementExamMergeSettings(this)" alt="" src="<?php echo SMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" class="rtl_margin_top_15px remove_cirtificate input_btn_height_width">
		</div>
		</div>
	</div>
	<?php
	die();
	echo $library_card_name;
}
add_action('wp_ajax_mj_smgt_student_list', 'mj_smgt_student_list');
add_action('wp_ajax_nopriv_mj_smgt_student_list', 'mj_smgt_student_list');
function mj_smgt_student_list()
{
	$role = mj_smgt_get_user_role(get_current_user_id());
	if ($role == 'administrator') 
	{
		$user_access_add = 1;
		$user_access_edit = 1;
		$user_access_delete = 1;
		$user_access_view = 1;
	} else 
	{
		$user_access = mj_smgt_get_userrole_wise_filter_access_right_array('student');
		$user_access_add = $user_access['add'];
		$user_access_edit = $user_access['edit'];
		$user_access_delete = $user_access['delete'];
		$user_access_view = $user_access['view'];
	}
	global $wpdb, $school_obj;
	$start = isset($_REQUEST['iDisplayStart']) ? intval($_REQUEST['iDisplayStart']) : 0;
	$length = isset($_REQUEST['iDisplayLength']) ? intval($_REQUEST['iDisplayLength']) : 10;
	$sSearch = isset($_REQUEST['sSearch']) ? sanitize_text_field($_REQUEST['sSearch']) : '';
	$students = [];
	if ($role == 'student') 
	{
		$own_data = $user_access['own_data'];
		if ($own_data == '1') {
			$user_id = get_current_user_id();
			$students[] = get_userdata($user_id);
		} else {
			$students = mj_smgt_get_usersdata('student');
		}
	} elseif ($role == 'teacher') 
	{
		$own_data = $user_access['own_data'];
		if ($own_data == '1') 
		{
			$user_id = get_current_user_id();
			$class_id = get_user_meta($user_id, 'class_name', true);
			$exlude_id = mj_smgt_approve_student_list();
		    $students = get_users(array('meta_key' => 'class_name', 'meta_value' => $class_id,'role'=>'student','exclude'=>$exlude_id));
		} 
		else 
		{
			$students = mj_smgt_get_usersdata('student');
		}
	} 
	elseif ($role == 'parent') 
	{
		$students = $school_obj->child_list;
	} 
	elseif ($role == 'supportstaff') 
	{
		$own_data = $user_access['own_data'];
		$user_id = get_current_user_id();
		if ($own_data == '1') 
		{
			$students = get_users([
				'role' => 'student',
				'meta_query' => [
					[
						'key' => 'created_by',
						'value' => $user_id,
						'compare' => '='
					]
				]
			]);
		} else {
			$students = mj_smgt_get_usersdata('student');
		}
	} 
	elseif ($role == 'administrator') 
	{
		// Admin role already handled by get_users with limit
		$students = get_users([
			'role'    => 'student',
			'search'  => "*{$sSearch}*",
			'orderby' => 'ID',
			'order'   => 'DESC',
			'number'  => $length,
			'offset'  => $start
		]);
	}

	// If not admin, we apply manual search and pagination
	if ($role != 'administrator') 
	{
		// Search filter
		if (!empty($sSearch)) {
			$students = array_filter($students, function ($student) use ($sSearch) {
				return stripos($student->display_name, $sSearch) !== false ||
					   stripos($student->user_email, $sSearch) !== false;
			});
		}

		$total_records = count($students);
		$students = array_slice($students, $start, $length);
		$iTotal = count(mj_smgt_get_usersdata('student')); // Full count
		$iFilteredTotal = $total_records;
	} else {
		$iTotal = count(get_users(['role' => 'student']));
		$iFilteredTotal = !empty($sSearch) ? count($students) : $iTotal;
	}

	$output = [
		"sEcho" => intval($_REQUEST['sEcho']),
		"iTotalRecords" => $iTotal,
		"iTotalDisplayRecords" => $iFilteredTotal,
		"aaData" => []
	];
	foreach ($students as $user_info) 
	{
		$uid = $user_info->ID;
		$student_id = MJ_smgt_encrypt_id($uid);
		$class_name = get_user_meta($uid, 'class_name', true);
		$phone = $user_info->mobile_number ?? get_user_meta($uid, 'mobile_number', true);
		$gender = get_user_meta($uid, 'gender', true);
		$view_nonce = MJ_smgt_get_nonce('view_action');
		$row = [];
		if ($role == 'administrator' || $role == 'management' ||  $role == 'supportstaff') 
	    {
			$row[0] = '<input type="checkbox" name="id[]" class="smgt_sub_chk check_for_id" value="' . esc_attr($uid) . '">';
		} 
		else 
		{
			$row[0] = ''; // Still assign a value to keep columns aligned
		}
		$user_img = mj_smgt_get_user_image($uid);
		$image_url = empty($user_img) ? get_option('smgt_student_thumb_new') : $user_img;
		if ($role != 'administrator') 
	    {
			$row[1] = '<a href="?dashboard=user&page=student&tab=view_student&action=view_student&student_id=' . $student_id.'">
						<img src="' . esc_url($image_url) . '" class="img-circle" />
					</a>';

			$row[2] = '<a class="color_black" href="?dashboard=user&page=student&tab=view_student&action=view_student&student_id=' . $student_id .'">' . esc_html($user_info->display_name) . '</a>
					<br>
					<label class="list_page_email">' . esc_html($user_info->user_email) . '</label>';
	    }
		else
		{
			$row[1] = '<a href="?page=smgt_student&tab=view_student&action=view_student&student_id=' . $student_id . '&_wpnonce=' . $view_nonce . '">
						<img src="' . esc_url($image_url) . '" class="img-circle" />
					</a>';

			$row[2] = '<a class="color_black" href="?page=smgt_student&tab=view_student&action=view_student&student_id=' . $student_id . '&_wpnonce=' . $view_nonce . '">' . esc_html($user_info->display_name) . '</a>
					<br>
					<label class="list_page_email">' . esc_html($user_info->user_email) . '</label>';
		}
		$country_code = mj_smgt_get_countery_phonecode(get_option('smgt_contry'));
		$mobile = !empty($phone) ? $phone : 'N/A';
		$row[3] = '+' . $country_code . ' ' . $mobile .
				  ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="' . esc_attr__('Mobile No.', 'school-mgt') . '"></i>';

		$section_id = get_user_meta($uid, 'class_section', true);
		$classname = smgt_get_class_section_name_wise($class_name, $section_id);
		$row[4] = (!empty($classname) ? $classname : 'N/A') .
				  ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="' . esc_attr__('Class & Section', 'school-mgt') . '"></i>';

		$roll_id = get_user_meta($uid, 'roll_id', true);
		$row[5] = (!empty($roll_id) ? $roll_id : 'N/A') .
				  ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="' . esc_attr__('Roll No.', 'school-mgt') . '"></i>';

		$row[6] = (!empty($gender) ? ucfirst($gender) : 'N/A') .
				  ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="' . esc_attr__('Gender', 'school-mgt') . '"></i>';

		$hash = get_user_meta($uid, 'hash', true);
		if ($hash) {
			$status = '<span class="btn btn-success active-user" idtest="' . esc_attr($uid) . '">' . esc_html__('Active', 'school-mgt') . '</span>';
		} else {
			$status = '<span style="color:green;">' . esc_html__('Approved', 'school-mgt') . '</span>';
		}
		$row[7] = $status . ' <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" title="' . esc_attr__('Status', 'school-mgt') . '"></i>';

		if ($role == 'administrator' || $role == 'management' ) 
	    {
			$action = '<div class="smgt-user-dropdown">
			<ul class="" style="margin-bottom: 0px !important;">
				<li class="">
					<a href="#" data-bs-toggle="dropdown" aria-expanded="false">
						<img src="' . esc_url(SMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png") . '">
					</a>
					<ul class="dropdown-menu heder-dropdown-menu action_dropdawn">
				
					<li class="float_left_width_100">
					<a href="?page=smgt_student&tab=view_student&action=view_student&student_id=' . esc_attr($student_id) . '&_wpnonce=' . MJ_smgt_get_nonce('view_action') . '" class="float_left_width_100">
						<i class="fa fa-eye"></i> ' . esc_html__('View', 'school-mgt') . '
					</a>
				</li>
				<li class="float_left_width_100">
					<a href="?page=smgt_student&tab=studentlist&action=result&student_id=' . esc_attr($student_id) . '" class="show-popup float_left_width_100" idtest="' . esc_attr($uid) . '">
						<i class="fa fa-bar-chart"></i> ' . esc_html__('View Result', 'school-mgt') . '
					</a>
				</li>';
			if ($user_access_edit == '1') {
				$action .= '<li class="float_left_width_100 border_bottom_menu">
								<a href="?page=smgt_student&tab=addstudent&action=edit&student_id=' . esc_attr($student_id) . '&_wpnonce=' . MJ_smgt_get_nonce('edit_action') . '" class="float_left_width_100">
									<i class="fa fa-edit"></i> ' . esc_html__('Edit', 'school-mgt') . '
								</a>
							</li>';
			}

			if ($user_access_delete == '1') {
				$action .= '<li class="float_left_width_100">
								<a href="?page=smgt_student&tab=studentlist&action=delete&student_id=' . esc_attr($student_id) . '&_wpnonce=' . MJ_smgt_get_nonce('delete_action') . '" class="float_left_width_100" style="color: #fd726a !important;" onclick="return confirm(\'' . esc_js(__('Are you sure you want to delete this record?', 'school-mgt')) . '\');">
									<i class="fa fa-trash"></i> ' . esc_html__('Delete', 'school-mgt') . '
								</a>
							</li>';
			}
		}
		else
		{
			$action = '<div class="smgt-user-dropdown">
			<ul class="" style="margin-bottom: 0px !important;">
				<li class="">
					<a href="#" data-bs-toggle="dropdown" aria-expanded="false">
						<img src="' . esc_url(SMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png") . '">
					</a>
					<ul class="dropdown-menu heder-dropdown-menu action_dropdawn">
				
					<li class="float_left_width_100">
					<a href="?dashboard=user&page=student&tab=view_student&action=view_student&student_id=' . esc_attr($student_id) . '" class="float_left_width_100">
						<i class="fa fa-eye"></i> ' . esc_html__('View', 'school-mgt') . '
					</a>
				</li>
				<li class="float_left_width_100">
					<a href="?dashboard=user&page=student&action=result&student_id=' . esc_attr($student_id) . '" class="show-popup float_left_width_100" idtest="' . esc_attr($uid) . '">
						<i class="fa fa-bar-chart"></i> ' . esc_html__('View Result', 'school-mgt') . '
					</a>
				</li>';
			if ($user_access_edit == '1') {
				$action .= '<li class="float_left_width_100 border_bottom_menu">
								<a href="?dashboard=user&page=student&tab=addstudent&action=edit&student_id=' . esc_attr($student_id) . '&_wpnonce_action=' . MJ_smgt_get_nonce('edit_action') . '" class="float_left_width_100">
									<i class="fa fa-edit"></i> ' . esc_html__('Edit', 'school-mgt') . '
								</a>
							</li>';
			}

			if ($user_access_delete == '1') {
				$action .= '<li class="float_left_width_100">
								<a href="?dashboard=user&page=student&tab=studentlist&action=delete&student_id=' . esc_attr($student_id) . '&_wpnonce_action=' . MJ_smgt_get_nonce('delete_action') . '" class="float_left_width_100" style="color: #fd726a !important;" onclick="return confirm(\'' . esc_js(__('Are you sure you want to delete this record?', 'school-mgt')) . '\');">
									<i class="fa fa-trash"></i> ' . esc_html__('Delete', 'school-mgt') . '
								</a>
							</li>';
			}
		}
		$action .= '</ul></li></ul></div>';
		$row[8] = $action;
		$output['aaData'][] = $row;
	}
	echo json_encode($output);
	wp_die();
}
?>