<?php
//-------- CHECK BROWSER JAVA SCRIPT ----------//
mj_smgt_browser_javascript_check();
//--------------- ACCESS WISE ROLE -----------//
$role_name=mj_smgt_get_user_role(get_current_user_id());
$school_obj = new School_Management(get_current_user_id());
$user_access=mj_smgt_get_userrole_wise_access_right_array();
if (isset ( $_REQUEST ['page'] ))
{	
	if($user_access['view']=='0')
	{	
		mj_smgt_access_right_page_not_access_message();
		die;
	}
	if(!empty($_REQUEST['action']))
	{
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='edit'))
		{
			if($user_access['edit']=='0')
			{	
				mj_smgt_access_right_page_not_access_message();
				die;
			}			
		}
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='delete'))
		{
			if($user_access['delete']=='0')
			{	
				mj_smgt_access_right_page_not_access_message();
				die;
			}	
		}
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='insert'))
		{
			if($user_access['add']=='0')
			{	
				mj_smgt_access_right_page_not_access_message();
				die;
			}	
		} 
	}
}
?>
<!-- POP up code -->
<div class="popup-bg">
    <div class="overlay-content">
		<div class="modal-content">
			<div class="view_popup"></div>
			<div class="invoice_data"></div>
			<div class="category_list"></div> 					
		</div>
    </div>    
</div>
<!-- End POP-UP Code -->
<?php 
	$obj_lib= new Smgtlibrary();
	//--------------Delete code-------------------------------
	if(isset($_REQUEST['action'])&& $_REQUEST['action']=='delete')
	{
		if (isset($_GET['_wpnonce_action']) && wp_verify_nonce($_GET['_wpnonce_action'], 'delete_action')) 
        {
			$result=$obj_lib->mj_smgt_delete_book(MJ_smgt_decrypt_id($_REQUEST['book_id']));
			if($result)
			{
				wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=1');
			}
		} 
		else 
		{
			wp_die('Security check failed!');
		}
	}
	if(isset($_REQUEST['delete_selected_book']))
	{		
		if(!empty($_REQUEST['id']))
		foreach($_REQUEST['id'] as $id)
			$result=$obj_lib->mj_smgt_delete_book($id);
		if($result)
			{
				wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=1');
			}
	}

	//------------------Edit-Add code ------------------------------
	if(isset($_POST['save_book']))
	{
		$nonce = $_POST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'save_book_frontend_nonce' ) )
		{
			if($_REQUEST['action']=='edit')
			{
				if (isset($_GET['_wpnonce_action']) && wp_verify_nonce($_GET['_wpnonce_action'], 'edit_action')) 
				{
					$result=$obj_lib->mj_smgt_add_book($_POST);
					if($result)
					{
						wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=4');	
					}
				} 
				else 
				{
					wp_die('Security check failed!');
				}
			}
			else
			{
				$result=$obj_lib->mj_smgt_add_book($_POST);
				if($result)
				{ 
					wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=3');	
				}
			}
		}	
	}
	//--------------------------- SAVE ISSUE BOOK ----------------------//
	if(isset($_POST['save_issue_book']))
	{
		$nonce = $_POST['_wpnonce'];
		if ( wp_verify_nonce( $nonce, 'issue_book_frontend_nonce' ) )
		{
			if($_REQUEST['action']=='edit')
			{
				if (isset($_GET['_wpnonce_action']) && wp_verify_nonce($_GET['_wpnonce_action'], 'edit_action')) 
                {
					$result=$obj_lib->mj_smgt_add_issue_book($_POST);
					if($result)
					{ 
						/* Book Issue Mail Notification */
						if(isset($_POST['smgt_issue_book_mail_service_enable']))
						{
							foreach($_POST['book_id'] as $book_id)
							{
								$smgt_issue_book_mail_service_enable = $_POST['smgt_issue_book_mail_service_enable'];
								if($smgt_issue_book_mail_service_enable)
								{	
									$search['{{student_name}}']	 	= 	mj_smgt_get_teacher($_POST['student_id']);
									$search['{{book_name}}'] 	    = 	mj_smgt_get_bookname($book_id);	
									$search['{{issue_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['issue_date']);							
									$search['{{return_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['return_date']);					
									$search['{{school_name}}'] 		= 	get_option('smgt_school_name');								
									$message = mj_smgt_string_replacement($search,get_option('issue_book_mailcontent'));
									$mail_id=mj_smgt_get_emailid_byuser_id($_POST['student_id']);		
									if(get_option('smgt_mail_notification') == '1')
									{
										wp_mail($mail_id,get_option('issue_book_title'),$message);
									}	
								}
							}	
						}
						wp_redirect ( home_url() . '?dashboard=user&page=library&tab=issuelist&message=5');
					}
				} 
				else 
				{
					wp_die('Security check failed!');
				}
			}
			else
			{
				$result=$obj_lib->mj_smgt_add_issue_book($_POST);
				if($result)
				{ 
					/* Book Issue Mail Notification */
					if(isset($_POST['smgt_issue_book_mail_service_enable']))
					{
						foreach($_POST['book_id'] as $book_id)
						{
							$smgt_issue_book_mail_service_enable = $_POST['smgt_issue_book_mail_service_enable'];
							if($smgt_issue_book_mail_service_enable)
							{	
								$search['{{student_name}}']	 	= 	mj_smgt_get_teacher($_POST['student_id']);
								$search['{{book_name}}'] 	    = 	mj_smgt_get_bookname($book_id);	
								$search['{{issue_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['issue_date']);							
								$search['{{return_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['return_date']);					
								$search['{{school_name}}'] 		= 	get_option('smgt_school_name');								
								$message = mj_smgt_string_replacement($search,get_option('issue_book_mailcontent'));
								$mail_id=mj_smgt_get_emailid_byuser_id($_POST['student_id']);
								if(get_option('smgt_mail_notification') == '1')
								{
									wp_mail($mail_id,get_option('issue_book_title'),$message);
								}	
							}
						}	
					}
					wp_redirect ( home_url() . '?dashboard=user&page=library&tab=issuelist&message=6'); 
				}
			}
		}
	}
	//------------------ SUBMIT BOOK ------------------------//
	if(isset($_POST['submit_book']))
	{
		$result=$obj_lib->mj_smgt_submit_return_book($_POST);
		if($result)
		{ ?>
			<div id="message" class="alert_msg alert alert-success alert-dismissible " role="alert">
				<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span>
				</button>
				<?php esc_attr_e('Book Submitted Successfully','school-mgt');?>
			</div>
		<?php 
		}
	}	
	/* Save Book Import Data */
	//upload booklist csv	
	if(isset($_REQUEST['upload_csv_file']))
	{		
		if(isset($_FILES['csv_file']))
		{				
			$errors= array();
			$file_name = $_FILES['csv_file']['name'];
			$file_size =$_FILES['csv_file']['size'];
			$file_tmp =$_FILES['csv_file']['tmp_name'];
			$file_type=$_FILES['csv_file']['type'];			
			$value = explode(".", $_FILES['csv_file']['name']);
			$file_ext = strtolower(array_pop($value));
			$extensions = array("csv");
			$upload_dir = wp_upload_dir();
			if(in_array($file_ext,$extensions )=== false)
			{
				$errors[]="this file not allowed, please choose a CSV file.";
				wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=8'); 
			}
			if($file_size > 2097152)
			{
				$errors[]='File size limit 2 MB';
				wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=9');
			}			
			if(empty($errors)==true)
			{	
				$rows = array_map('str_getcsv', file($file_tmp));		
				$header = array_map('strtolower',array_shift($rows));
				
				$csv = array();
				foreach ($rows as $row) 
				{
					$csv = array_combine($header, $row);
					
					if(isset($csv['isbn']))
						$bookdata['isbn']=$csv['isbn'];
					if(isset($csv['book_name']))
						$bookdata['book_name']=$csv['book_name'];
					if(isset($csv['author_name']))
						$bookdata['author_name']=$csv['author_name'];
					if(isset($csv['rack_location']))
						$bookdata['rack_location']=$csv['rack_location'];
					if(isset($csv['cat_id']))
						$bookdata['cat_id']=$csv['cat_id'];
					if(isset($csv['price']))
						$bookdata['price']=$csv['price'];							
					if(isset($csv['quentity']))
						$bookdata['quentity']=$csv['quentity'];							
					if(isset($csv['description']))
						$bookdata['description']=$csv['description'];
					$bookdata['added_by']=get_current_user_id();
					$bookdata['added_date']=date('Y-m-d');
									
					global $wpdb;
					$table_smgt_library_book = $wpdb->prefix. 'smgt_library_book';
					$all_book = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_smgt_library_book"));	
					$book_name=array();
					$book_isbn=array();
					
					foreach ($all_book as $book_data) 
					{
						$book_name[]=$book_data->book_name;
						$book_isbn[]=$book_data->ISBN;
					}
					
					if (in_array($bookdata['book_name'], $book_name) && in_array($bookdata['isbn'], $book_isbn))
					{
						$import_book_name=$bookdata['book_name'];
						$import_isbn=$bookdata['isbn'];
						$existing_book_data = $wpdb->get_row(
							$wpdb->prepare("SELECT id FROM $table_smgt_library_book WHERE book_name = %s AND ISBN = %s", $import_book_name, $import_isbn)
						);
						$id['id']=$existing_book_data->id;
												
						$wpdb->update( $table_smgt_library_book, $bookdata,$id);	
						
						$success = 1;	
					}
					else
					{ 	
						$wpdb->insert( $table_smgt_library_book, $bookdata );	
						$success = 1;	
					}	
				}
			}
			else
			{
				foreach($errors as &$error) echo $error;
			}
			
			if(isset($success))
			{			
				wp_redirect ( home_url() . '?dashboard=user&page=library&tab=booklist&message=7');
			} 
		}
	}
	$active_tab = isset($_GET['tab'])?$_GET['tab']:'booklist';
	
?>
<script type="text/javascript" >
jQuery(document).ready(function($)
{
	"use strict";	
	jQuery('.datepicker').datepicker({
			dateFormat: "<?php echo get_option('smgt_datepicker_format');?>",		
			changeYear:true,
			changeMonth:true,
			minDate:0
		}); 
		jQuery('#bookissue_form').validationEngine({promptPosition : "bottomLeft",maxErrorsPerField: 1});
		jQuery('#book_form').validationEngine({promptPosition : "bottomLeft",maxErrorsPerField: 1});
		
		// ----- member_list tabal js start ----- // 
		jQuery('#member_list').DataTable({
			
			//stateSave: true,
			"dom": 'lifrtp',
			"order": [[ 1, "asc" ]],
				"aoColumns":[
					{"bSortable": false},
					{"bSortable": true},
					{"bSortable": true},
					{"bSortable": true},
					{"bSortable": false}],
			language:<?php echo mj_smgt_datatable_multi_language();?>
		});
		$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
		// ----- member_list tabal js End ----- // 
		var table =  jQuery('#liabrary_book_list').DataTable({
			"initComplete": function(settings, json) {
			$(".print-button").css({"margin-top": "-5%"});
		},
		//stateSave: true,
			"dom": 'lifrtp',
			"order": [[ 2, "asc" ]],	
			"aoColumns":[	                  
					<?php
					if($role_name == "supportstaff")
					{
						?>
						{"bSortable": false},
						<?php
					}
					?>
						{"bSortable": false},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": true},
						{"bSortable": false}],			
			language:<?php echo mj_smgt_datatable_multi_language();?>
		});
	
		$('.select_all').on('click', function(e)
		{
			if($(this).is(':checked',true))  
			{
				$(".smgt_sub_chk").prop('checked', true);  
			}  
			else  
			{  
				$(".smgt_sub_chk").prop('checked',false);  
			} 
		});
		$('.smgt_sub_chk').on('change',function()
		{ 
			if(false == $(this).prop("checked"))
			{ 
				$(".select_all").prop('checked', false); 
			}
			if ($('.smgt_sub_chk:checked').length == $('.smgt_sub_chk').length )
			{
				$(".select_all").prop('checked', true);
			}
		});
		jQuery('#checkbox-select-all').on('click', function(){
			 
			var rows = table.rows({ 'search': 'applied' }).nodes();
			jQuery('input[type="checkbox"]', rows).prop('checked', this.checked);
		}); 
		   
		$("#delete_selected").on('click', function()
		{	
			if ($('.select-checkbox:checked').length == 0 )
			{
				alert(language_translate2.one_record_select_alert);
				return false;
			}
			else{
				var alert_msg=confirm("<?php esc_html_e('Are you sure you want to delete this record?','school-mgt');?>");
				if(alert_msg == false)
				{
					return false;
				}
				else
				{
					return true;
				}
			}
		});
		 
	// START select student class wise
	$("body").on("change", "#class_list_lib", function()
	{	
		$('#class_section_lib').html('');
		$('#class_section_lib').append('<option value="remove">Loading..</option>');
		 var selection = $("#class_list_lib").val();
		 var optionval = $(this);
		var curr_data = {
			action: 'mj_smgt_load_class_section',
			class_id: selection,			
			dataType: 'json'
		};
		$.post(smgt.ajax, curr_data, function(response) 
		{
			$("#class_section_lib option[value='remove']").remove();
			$('#class_section_lib').append(response);	
		});					
					
	});
	// START select student class wise
	$("#class_section_lib").on('change',function(){
		 var selection = $(this).val();
		 if(selection != ''){
			$('#student_list').html('');
			var optionval = $(this);
			var curr_data = {
				action: 'mj_smgt_load_section_user',
				section_id: selection,			
				dataType: 'json'
			};
					
			$.post(smgt.ajax, curr_data, function(response) 
			{
				$('#student_list').append(response);	
			});
		 }
		
	});
	
	 $("#bookcat_list").on('change',function()
	 {				
		$("#book_list1 option[value]").remove();
		var selection = $("#bookcat_list").val();		
		var optionval = $(this);
			var curr_data = 
			{
				action: 'mj_smgt_load_books',
				bookcat_id: $("#bookcat_list").val(),			
				dataType: 'json'
			};
			$.post(smgt.ajax, curr_data, function(response) {
			$('#book_list1').append(response);
			$('#book_list1').multiselect('rebuild');
			});					
	});
});
</script>
		
<div class="panel-body panel-white frontend_list_margin_30px_res">
	<?php
	$message = isset($_REQUEST['message'])?$_REQUEST['message']:'0';
	switch($message)
	{
		case '1':
			$message_string = esc_attr__('Book Deleted successfully','school-mgt');
			break;
		case '2':
			$message_string = esc_attr__('Issue Book Deleted successfully.','school-mgt');
			break;	
		case '3':
			$message_string = esc_attr__('Book Added Successfully.','school-mgt');
			break;
		case '4':
			$message_string = esc_attr__('Book Updated Successfully.','school-mgt');
			break;
		case '5':
			$message_string = esc_attr__('Issue Book Updated Successfully.','school-mgt');
			break;
		case '6':
			$message_string = esc_attr__('Issue Book Added Successfully.','school-mgt');
			break;
		case '7':
			$message_string = esc_attr__('Book Uploaded Successfully.','school-mgt');
			break;
		case '8':
			$message_string = esc_attr__('This file not allowed, please choose a CSV file.','school-mgt');
			break;
			case '9':
			$message_string = esc_attr__('File size limit 2 MB.','school-mgt');
			break;			
	}
	if($message)
	{ ?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible " role="alert">
			<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"><img src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/Close.png"?>" alt=""></span>
			</button>
			<?php echo $message_string;?>
		</div>
		<?php 
	} ?>
	<?php
	// TABBING START
	if($active_tab =='issue_return' || $active_tab =='view_book')
	{
		echo "";
	}
	else
	{
		?>
		<ul class="nav nav-tabs panel_tabs flex-nowrap margin_left_1per" role="tablist"><!--Start nav-tabs -->
			<li class="<?php if($active_tab=='booklist'){?>active<?php }?>">
				<a href="?dashboard=user&page=library&tab=booklist"  class="padding_left_0 tab  <?php echo $active_tab == 'booklist' ? 'active' : ''; ?>">
				<?php esc_attr_e('Book List', 'school-mgt'); ?></a>
				</a>
			</li>
			<?php
			if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit' && $_REQUEST['tab'] == 'addbook')
			{
				?>
				<li class="<?php if($active_tab=='addbook'){?>active<?php }?>">
					<a href="?dashboard=user&page=library&tab=addbook&action=edit&book_id=<?php echo $_REQUEST['book_id'];?>"  class="padding_left_0 tab  <?php echo $active_tab == 'addbook' ? 'active' : ''; ?>">
					<?php esc_attr_e('Edit Book', 'school-mgt'); ?></a>
					</a>
				</li>
				<?php 
			}
			elseif($active_tab=='addbook')
			{
				if($user_access['add']=='1')
				{
				?>
					<li class="<?php if($active_tab=='addbook'){?>active<?php }?>">
						<a href="?dashboard=user&page=library&tab=addbook"  class="padding_left_0 tab <?php echo $active_tab == 'addbook' ? 'active' : ''; ?>">
						<?php esc_attr_e('Add Book', 'school-mgt'); ?></a>
						</a>
					</li>
				<?php 
				}
			} 
			?> 
			<li class="<?php if($active_tab=='issuelist'){?>active<?php }?>">
				<a href="?dashboard=user&page=library&tab=issuelist"  class="padding_left_0 tab <?php echo $active_tab == 'issuelist' ? 'active' : ''; ?>">
				<?php esc_attr_e('Issue & Return', 'school-mgt'); ?></a>
				</a>
			</li>
		</ul>
		<?php
	}
	// BOOK LIST TAB START
	if($active_tab == 'booklist')
	{ 
			?>
		
			<div class="panel-body">
				<form id="frm-example" name="frm-example" method="post">
					<?php
					$user_id=get_current_user_id();
					//------- BOOK DATA FOR STUDENT ---------//
					if($school_obj->role == 'supportstaff')
					{ 
						$own_data=$user_access['own_data'];
						if($own_data == '1')
						{ 
							$retrieve_books=$obj_lib->mj_smgt_get_all_books_creted_by($user_id);
						}
						else
						{
							$retrieve_books=$obj_lib->mj_smgt_get_all_books(); 
						}
					}
					else
					{
						$retrieve_books=$obj_lib->mj_smgt_get_all_books(); 
					}
					if(!empty($retrieve_books))
					{
						?>
						<div class="table-responsive">
							<table id="liabrary_book_list" class="display dataTable booklist_datatable" cellspacing="0" width="100%">
								<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
									<tr>
										<?php
										if($role_name == "supportstaff")
										{
											?>
											<th class="padding_0"><input type="checkbox" class="select_all" id="select_all"></th>
											<?php
										}
										?>
										<th><?php  _e( 'Image', 'school-mgt' ) ;?></th>
										<th><?php esc_attr_e('Book Title','school-mgt');?></th>
										<th><?php esc_attr_e('ISBN','school-mgt');?></th>
										<th><?php esc_attr_e('Book Category','school-mgt');?></th>
										<th><?php esc_attr_e('Book Price','school-mgt');?></th>
										<th><?php esc_attr_e('Author Name','school-mgt');?></th>
										<th><?php esc_attr_e('Publisher','school-mgt');?></th>
										<th><?php esc_attr_e('Rack Location','school-mgt');?></th>
										<th><?php esc_attr_e('Remaining Quantity','school-mgt');?></th>
										<th class="text_align_end"><?php _e( 'Action', 'school-mgt' ) ;?></th>
									</tr>
								</thead>
								<tbody>
									<?php 
									if(!empty($retrieve_books))
									{
										$i=0;
										foreach ($retrieve_books as $retrieved_data)
										{ 
											?>
											<tr>
												<?php
												if($role_name == "supportstaff")
												{
													?>
													<td class="checkbox_width_10px">
														<input type="checkbox" class="smgt_sub_chk select-checkbox" name="id[]"	value="<?php echo $retrieved_data->id;?>">
													</td>
													<?php
												}
												?>
												<td class="user_image width_50px"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/Library.png" ?>" class="img-circle" /></td>
												<td><a href="?dashboard=user&page=library&tab=view_book&book_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->id);?>"><?php echo stripslashes($retrieved_data->book_name);?></a> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Book Title','school-mgt');?>" ></td>
												<td><?php echo $retrieved_data->ISBN;?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('ISBN','school-mgt');?>" ></i></td>
												<td>
													<?php echo get_the_title($retrieved_data->cat_id);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Book Category','school-mgt');?>" ></i>
												</td>
												<td>
													<?php echo "<span> ". mj_smgt_get_currency_symbol() ." </span>" . number_format($retrieved_data->price,2,'.',''); ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Book Price','school-mgt');?>" ></i>
												</td>
												<td><?php echo stripslashes($retrieved_data->author_name);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Author Name','school-mgt');?>" ></td>
												<td>
													<?php if(!empty($retrieved_data->publisher)){ echo stripslashes($retrieved_data->publisher); }else{ echo "N/A";} ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Publisher','school-mgt');?>" ></i>
												</td>
												<td>
													<?php
														if($retrieved_data->rack_location!=="0")
														{
															echo get_the_title($retrieved_data->rack_location);
														}
														else
														{
															echo "N/A";
														}
														?>
													<i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Rack Location','school-mgt');?>" ></i>
												</td>
												<td>
													<?php  echo $retrieved_data->quentity." ".esc_html__("Out of","school-mgt")." ".$retrieved_data->total_quentity;?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Remaining Quantity','school-mgt');?>" ></i>
												</td>
												<td class="action"> 
													<div class="smgt-user-dropdown">
														<ul class="" style="margin-bottom: 0px !important;">
															<li class="">
																<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																	<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
																</a>
																<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
																	<li class="float_left_width_100">
																		<a href="?dashboard=user&page=library&tab=view_book&book_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->id);?>" class="float_left_width_100"><i class="fa fa-eye"> </i><?php esc_attr_e('View','school-mgt');?></a>
																	</li>
																	<?php 
																	if($school_obj->role=='supportstaff')
																	{ 
																		if($user_access['edit']=='1')
																		{?>
																			<li class="float_left_width_100 border_bottom_item">
																				<a href="?dashboard=user&page=library&tab=addbook&action=edit&book_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->id);?>&_wpnonce_action=<?php echo MJ_smgt_get_nonce('edit_action');?>" class="float_left_width_100"><i class="fa fa-edit"> </i><?php esc_attr_e('Edit','school-mgt');?> </a>
																			</li>
																		<?php
																		}
																		if($user_access['delete']=='1')
																		{ ?>
																			<li class="float_left_width_100">
																				<a href="?dashboard=user&page=library&tab=booklist&action=delete&book_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->id);?>&_wpnonce_action=<?php echo MJ_smgt_get_nonce('delete_action');?>" class="float_left_width_100" style="color: #fd726a !important;" onclick="return confirm('<?php esc_attr_e('Are you sure you want to delete this record?','school-mgt');?>');"><i class="fa fa-trash"></i> <?php esc_attr_e('Delete','school-mgt');?></a> 
																			</li>
																		<?php
																		}
																	}
																	?>
																</ul>
															</li>
														</ul>
													</div>	
												</td>
											</tr>
											<?php  
											$i++;
										}
									}
									?>	
								</tbody>
							</table> 
							<?php
							if($role_name == "supportstaff")
							{
								?>
								<div class="print-button pull-left">
									<button class="btn btn-success btn-sms-color button_reload">
										<input type="checkbox" name="id[]" class="smgt_sub_chk select_all" value="" style="margin-top: 0px;">
										<label for="checkbox" class="margin_right_5px"><?php esc_html_e( 'Select All', 'school-mgt' ) ;?></label>
									</button>
									<?php 
									if($school_obj->role=='supportstaff')
									{
										if($user_access['delete']=='1')
										{ ?>
											<button id="delete_selected" data-toggle="tooltip" title="<?php esc_html_e('Delete Selected','school-mgt');?>" name="delete_selected_book" class="delete_selected" ><img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/Delete.png" ?>" alt=""></button>
											<?php
										}
									} ?>
								</div>
								<?php
							}
							?>
						</div>
						<?php
					}
					else
					{	
						if($user_access['add']=='1')
						{
							?>
							<div class="no_data_list_div no_data_img_mt_30px"> 
								<a href="<?php echo home_url().'?dashboard=user&page=library&tab=addbook';?>">
									<img class="col-md-12 width_100px" src="<?php echo get_option( 'smgt_no_data_img' ) ?>" >
								</a>
								<div class="col-md-12 dashboard_btn margin_top_20px">
									<label class="no_data_list_label"><?php esc_html_e('Tap on above icon to add your first Record.','school-mgt'); ?> </label>
								</div> 
							</div>		
							<?php
						}
						else
						{
							?>
							<div class="calendar-event-new"> 
								<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
							</div>	
							<?php
						}
					} ?>
				</form>
			</div>
			<?php 
		
	}
	// ADD BOOK TAB START
	if($active_tab == 'addbook')
	{ ?>
		<?php 
		$bookid=0;
		if(isset($_REQUEST['book_id']))
		//$bookid=$_REQUEST['book_id'];
		$bookid=intval(MJ_smgt_decrypt_id($_REQUEST['book_id']));
		$edit=0;
		if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit')
		{
			$edit=1;
			$result=$obj_lib->mj_smgt_get_single_books($bookid);
		
		}?>
		<div class="panel-body"><!--panel-body -->	
			<form name="book_form" action="" method="post" class="mt-3 form-horizontal" id="book_form">
				<?php $action = isset($_REQUEST['action'])?$_REQUEST['action']:'insert';?>
				<input type="hidden" name="action" value="<?php echo $action;?>">
				<input type="hidden" name="book_id" value="<?php echo $bookid;?>">
				<div class="header">	
					<h3 class="first_hed"><?php esc_html_e('BooK Information','school-mgt');?></h3>
				</div>
				<div class="form-body user_form">
					<div class="row">
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="book_name" class="form-control validate[required,custom[address_description_validation]] text-input" maxlength="50" type="text" value="<?php if($edit){ echo stripslashes($result->book_name);}?>" name="book_name">
									<label class="" for="book_name"><?php esc_attr_e('Book Title','school-mgt');?><span class="require-field"><span class="require-field">*</span></span></label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="book_number" class="form-control text-input" maxlength="10" type="number" value="<?php if($edit){ echo stripslashes($result->book_number);}?>" name="book_number">
									<label class="" for="book_number"><?php esc_attr_e('Book Number','school-mgt');?></label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="isbn" class="form-control validate[required,custom[address_description_validation]]" type="text" maxlength="50" value="<?php if($edit){ echo $result->ISBN;}?>" name="isbn">
									<label class="" for="isbn"><?php esc_attr_e('ISBN Number','school-mgt');?><span class="require-field">*</span></label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input rtl_margin_0px">
								<div class="col-md-12 form-control">
									<input id="publisher" class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input" type="text" maxlength="50" value="<?php if($edit){ echo stripslashes($result->publisher);}?>" name="publisher">
									<label class="" for="publisher"><?php esc_attr_e('Publisher','school-mgt');?><span class="require-field">*</span></label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 error_msg_left_margin">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="author_name" class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input" maxlength="50" type="text" value="<?php if($edit){ echo stripslashes($result->author_name);}?>" name="author_name">
									<label class="" for="author_name"><?php esc_attr_e('Author Name','school-mgt');?><span class="require-field"><span class="require-field">*</span></span></label>
								</div>
							</div>
						</div>
						<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
							<label class="ml-1 custom-top-label top" for="category_data"><?php esc_attr_e('Select Category','school-mgt');?><span class="require-field">*</span></label>
							<select name="bookcat_id" id="" class="line_height_30px form-control smgt_bookcategory validate[required] width_100">
								<option value=""><?php esc_attr_e('Select Category','school-mgt');?></option>
									<?php 
									$activity_category=mj_smgt_get_all_category('smgt_bookcategory');
									if(!empty($activity_category))
									{
										if($edit)
										{
											$fees_val=$result->cat_id; 
										}
										else
										{
											$fees_val=''; 
										}
									
										foreach ($activity_category as $retrive_data)
										{ 		 	
										?>
											<option value="<?php echo $retrive_data->ID;?>" <?php selected($retrive_data->ID,$fees_val);  ?>><?php echo esc_attr($retrive_data->post_title); ?> </option>
										<?php }
									} 
									?> 
							</select>
						</div>
						<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3">
							<button id="addremove_cat" class="rtl_margin_top_15px add_btn sibling_add_remove" model="smgt_bookcategory"><?php esc_attr_e('Add','school-mgt');?></button>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 error_msg_left_margin">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="book_price" class="form-control validate[required,min[0],maxSize[8]]" type="number" step="0.01" value="<?php if($edit){ echo $result->price;}?>" name="book_price" >
									<label class="" for="book_price"><?php echo esc_attr__('Price','school-mgt')."(".html_entity_decode(mj_smgt_get_currency_symbol(get_option('smgt_currency_code'))).")";?><span class="require-field">*</span></label>
								</div>
							</div>
						</div>
						
						<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
							<label class="ml-1 custom-top-label top" for="category_data"><?php esc_attr_e('Rack Location','school-mgt');?><span class="require-field">*</span></label>
							<select name="rack_id" id="rack_category_data" class="line_height_30px form-control smgt_rack validate[required] max_width_100">
								<option value=""><?php esc_attr_e('Select Rack Location','school-mgt');?></option>
								<?php 
								$activity_category=mj_smgt_get_all_category('smgt_rack');
								if(!empty($activity_category))
								{
									if($edit)
									{
										$rank_val=$result->rack_location; 
									}
									else
									{
										$rank_val=''; 
									}
								
									foreach ($activity_category as $retrive_data)
									{ 		 	
									?>
										<option value="<?php echo $retrive_data->ID;?>" <?php selected($retrive_data->ID,$rank_val);  ?>><?php echo esc_attr($retrive_data->post_title); ?> </option>
									<?php }
								} 
								?> 
							</select> 
						</div>
						<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3">
							<button id="addremove_cat" class="rtl_margin_top_15px add_btn sibling_add_remove" model="smgt_rack"><?php esc_attr_e('Add','school-mgt');?></button>
						</div>
						
						<?php wp_nonce_field( 'save_book_frontend_nonce' ); ?>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="quentity" class="form-control validate[required,min[0],maxSize[5]]" type="number" value="<?php if($edit){ echo $result->quentity;}?>" name="quentity">
									<label class="" for="class_capacity"><?php esc_attr_e('Total Quantity','school-mgt');?><span class="require-field">*</span></label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="post_date" class="datepicker form-control validate[required] text-input" type="text" name="post_date" value="<?php if($edit){ echo mj_smgt_getdate_in_input_box($result->added_date);}else{echo mj_smgt_getdate_in_input_box(date('Y-m-d'));}?>" readonly>
									<label class="" for="post_date"><?php esc_attr_e('Post Date','school-mgt');?><span class="require-field">*</span></label>
								</div>
							</div>
						</div>
						<div class="col-md-6 note_text_notice">
							<div class="form-group input">
								<div class="col-md-12 note_border margin_bottom_15px_res">
									<div class="form-field">
										<textarea id="description" name="description" class="textarea_height_47px validate[custom[description_validation]] form-control" ><?php if($edit){ echo $result->description;}?>  </textarea>
										<span class="txt-title-label"></span>
										<label class="text-area address active" for="description"><?php esc_attr_e('Description','school-mgt');?></label>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>  
				
				<div class="form-body user_form">
					<div class="row">
						<div class="col-sm-6">           	
							<input type="submit" value="<?php if($edit){ esc_attr_e('Save Book','school-mgt'); }else{ esc_attr_e('Add Book','school-mgt');}?>" name="save_book" class="btn btn-success save_btn" />
						</div>    
					</div>
				</div>    
				
			</form>
		</div><!--panel-body -->	
		<?php
	}
	// ISSUELIST TAB START
	if($active_tab == 'issuelist')
	{ 
		if($user_access['own_data'] == "1")
		{
			
			$alluser = array();
			if($role_name == "student")
			{
				$alluser[] = get_userdata(get_current_user_id());
			}
			elseif($role_name == "parent")
			{
				$childs = $school_obj->child_list;
				$alluser = array();
				if(!empty($childs))
				{
					foreach ($childs as $key => $value) 
					{
						$alluser[] = get_userdata($value);
					}
				}
				
				
			}
			elseif($role_name == "teacher")
			{
				$alluser[] = get_userdata(get_current_user_id());
			}
			else
			{
				$alluser = get_users(array('role__in' => array('student', 'teacher')));
			}
		}
		else
		{
			$alluser = get_users(array('role__in' => array('student', 'teacher')));
		}
		
		if(!empty($alluser))
		{
			?>
			<script type="text/javascript">
				jQuery(document).ready(function($){
					var table =  jQuery('#issue_list').DataTable({
						"initComplete": function(settings, json) {
							$(".print-button").css({"margin-top": "-55px"});
						},
						//stateSave: true,
						// responsive: true,
						"dom": 'lifrtp',
						"order": [[ 2, "asc" ]],
						"aoColumns":[                  
							{"bSortable": false},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": false}],
						language:<?php echo mj_smgt_datatable_multi_language();?>
					});
					$('.select_all').on('click', function(e)
					{
						if($(this).is(':checked',true))  
						{
							$(".smgt_sub_chk").prop('checked', true);  
						}  
						else  
						{  
							$(".smgt_sub_chk").prop('checked',false);  
						} 
					});
					$('.smgt_sub_chk').on('change',function()
					{ 
						if(false == $(this).prop("checked"))
						{ 
							$(".select_all").prop('checked', false); 
						}
						if ($('.smgt_sub_chk:checked').length == $('.smgt_sub_chk').length )
						{
							$(".select_all").prop('checked', true);
						}
					});
							
					$("#delete_selected").on('click', function()
					{	
						if ($('.smgt_sub_chk:checked').length == 0 )
						{
							alert(language_translate2.one_record_select_alert);
							return false;
						}
						else
						{
							var alert_msg=confirm(language_translate2.delete_record_alert);
							if(alert_msg == false)
							{
								return false;
							}
							else
							{
								return true;
							}
						}
					});
					$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
				});
			</script>
			
			<div class="panel-body"><!--panel-body -->
				<div class="table-responsive">
					<form id="frm-example" name="frm-example" method="post">
						<table id="issue_list" class="display" cellspacing="0" width="100%">
							<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
								<tr>
									<th><?php  esc_attr_e( 'Image', 'school-mgt' ) ;?></th>
									<th><?php esc_attr_e('Name & Email','school-mgt');?></th>
									<th><?php esc_attr_e('Library Card No','school-mgt');?></th>
									<th><?php esc_attr_e('User Type','school-mgt');?></th>
									<th><?php esc_attr_e('Mobile No.','school-mgt');?></th>
									<th class="text_align_end"><?php esc_attr_e('Action', 'school-mgt') ;?></th>
								</tr>
							</thead>
							<tbody>
								<?php 
								if(!empty($alluser))
								{
									foreach ($alluser as $retrieved_data)
									{ 
										$library_card_no =  $obj_lib->mj_smgt_get_library_card_for_student($retrieved_data->ID);
										?>
										<tr>
											<td class="user_image width_50px">
												<a href="?dashboard=user&page=library&tab=issue_return&user_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->ID);?>">
													<?php
														$uid=$retrieved_data->ID;
														$role_name = mj_smgt_get_user_role($uid);
														$umetadata=mj_smgt_get_user_image($uid);
														if(empty($umetadata))
														{
															if($role_name == "student") 
															{
																echo '<img src='.get_option( 'smgt_student_thumb_new' ).' class="img-circle" />';
															} 
															elseif($role_name == "teacher") 
															{
																echo '<img src='.get_option( 'smgt_teacher_thumb_new' ).' class="img-circle" />';
															}
														}
														else
														{
															echo '<img src='.$umetadata.' class="img-circle" />';
														}
													?>
												</a>
											</td>
											<td class="name">
												<a class="color_black" href="?dashboard=user&page=library&tab=issue_return&user_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->ID);?>" idtest=<?php echo $retrieved_data->ID;?> ><?php echo $retrieved_data->display_name;?></a>
												<br>
												<label class="list_page_email"><?php echo $retrieved_data->user_email;?></label>
											</td>
											<td>
												<?php 
												if(!empty($library_card_no))
												{
													$library_card =  $library_card_no[0]->library_card_no;
													if(!empty($library_card))
													{
													echo $library_card;
													}
													else
													{
													echo "N/A";
													}
												}
												else
												{
													echo "N/A";
												}
												
											
												?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e('Library Card No','school-mgt');?>" ></i>
											</td>
											<td>
												<?php echo mj_smgt_get_user_role($retrieved_data->ID);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e('User Type','school-mgt');?>" ></i>
											</td>
											<td class="name">
												+<?php echo mj_smgt_get_countery_phonecode(get_option( 'smgt_contry' ));?>
												<?php
												if(!empty($retrieved_data->mobile_number)){echo $retrieved_data->mobile_number;}else{echo 'N/A';}
												?>

												<i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Mobile No.','school-mgt');?>" ></i>
											</td>
											<td class="action"> 
												<div class="smgt-user-dropdown">
													<ul class="" style="margin-bottom: 0px !important;">
														<li class="">
															<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
															</a>
															<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
																<li class="float_left_width_100">
																	<a href="?dashboard=user&page=library&tab=issue_return&user_id=<?php echo MJ_smgt_encrypt_id($retrieved_data->ID);?>" class="float_left_width_100"><i class="fa fa-book"> </i><?php esc_attr_e('Issue & Return','school-mgt');?> </a>
																</li>	
															</ul>
														</li>
													</ul>
												</div>	
											</td>
										</tr>
										<?php 
										$i++;
									} 
								} ?>	
							</tbody>
						</table>
					</form>
				</div>    
			</div>  <!--panel-body -->
			<?php 
		}
		else
		{
			if($user_access_add=='1')
			{
				?>
				<div class="no_data_list_div no_data_img_mt_30px"> 
					<a href="<?php echo admin_url().'admin.php?page=smgt_library&tab=issuebook';?>">
						<img class="col-md-12 width_100px" src="<?php echo get_option( 'smgt_no_data_img' ) ?>" >
					</a>
					<div class="col-md-12 dashboard_btn margin_top_20px">
						<label class="no_data_list_label"><?php esc_html_e('Tap on above icon to add your first Record.','school-mgt'); ?> </label>
					</div> 
				</div>		
				<?php
			}
			else
			{
				?>
				<div class="calendar-event-new"> 
					<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
				</div>		
				<?php
			}
		}
	} 
	// ISSUE RETURN TAB START
	if($active_tab == 'issue_return')
	{
		$active_tab1 = isset($_REQUEST['tab1'])?$_REQUEST['tab1']:'general';
		$user_id = intval(MJ_smgt_decrypt_id($_REQUEST['user_id']));
		$user_data=get_userdata($user_id);
		$role_name = mj_smgt_get_user_role($user_id);
		$obj_lib= new Smgtlibrary();
		$library_card_no =  $obj_lib->mj_smgt_get_library_card_for_student($user_id);
		?>
		<div class="panel-body view_page_main"><!-- START PANEL BODY DIV-->
			<div class="content-body">
				<section id="user_information" class="">
					<div class="view_page_header_bg">
						<div class="row">
							<div class="col-xl-10 col-md-9 col-sm-10">
								<div class="user_profile_header_left float_left_width_100">
									<?php
										$userimage=mj_smgt_get_user_image($user_data->ID);
									?>
									<img class="user_view_profile_image" src="<?php if(!empty($userimage)) {echo $userimage; }else{ if($role_name == "student"){  echo get_option( 'smgt_student_thumb_new' );}elseif($role_name == "teacher"){ echo get_option( 'smgt_teacher_thumb_new' );} }?>">
									<div class="row profile_user_name">
										<div class="float_left view_top1">
											<div class="col-xl-12 col-md-12 col-sm-12 float_left_width_100">
												<label class="view_user_name_label"><?php echo esc_html($user_data->display_name);?></label>
											</div>
											<div class="col-xl-12 col-md-12 col-sm-12 float_left_width_100">
												<div class="view_user_phone float_left_width_100">
													<img src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/phone_figma.png"?>">&nbsp;+<?php echo mj_smgt_get_countery_phonecode(get_option( 'smgt_contry' ));?>&nbsp;&nbsp;<lable class="color_white_rs"><?php echo $user_data->mobile_number;?></label>
												</div>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-xl-12 col-md-12 col-sm-12">
											<div class="view_top2">
												<div class="row view_user_doctor_label">
													<div class="col-md-12 address_student_div">
														<img src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/location.png"?>" alt="">&nbsp;&nbsp;<lable class="address_detail_page"><?php echo $user_data->address; ?></label>
													</div>		
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-xl-2 col-lg-3 col-md-3 col-sm-2 add_btn_possition_teacher_res">
								<div class="group_thumbs">
									<img src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/Group.png"?>">
								</div>
							</div>
						</div>
					</div>
				</section>

				<section id="body_area" class="teacher_view_tab">
					<div class="row">
						<div class="col-xl-12 col-md-12 col-sm-12 rs_width">
							<ul class="nav nav-tabs panel_tabs flex-nowrap margin_left_1per" role="tablist">
								<li class="<?php if($active_tab1=='general'){?>active<?php }?>">
									<a href="?dashboard=user&page=library&tab=issue_return&user_id=<?php echo $_REQUEST['user_id'];?>"
									class="padding_left_0 tab <?php echo $active_tab1 == 'general' ? 'active' : ''; ?>">
									<i class="fa fa-book"> </i> <?php esc_html_e('issue & Return Details', 'school-mgt'); ?></a>
								</li>
							</ul>
						</div>
					</div>
				</section>
				<section id="body_content_area" class="">
					<div class="panel-body"><!-- START PANEL BODY DIV-->
						<?php
						if($active_tab1=='general')
						{
							if(isset($_POST['save_issue_book']))
							{
								$result=$obj_lib->mj_smgt_add_issue_book($_POST);
								if($result)
								{ 
									/* Book Issue Mail Notification */
									if(isset($_POST['smgt_issue_book_mail_service_enable']))
									{
										foreach($_POST['book_id'] as $book_id)
										{
											$smgt_issue_book_mail_service_enable = $_POST['smgt_issue_book_mail_service_enable'];
											if($smgt_issue_book_mail_service_enable)
											{	
												$search['{{student_name}}']	 	= 	mj_smgt_get_teacher($_POST['student_id']);
												$search['{{book_name}}'] 	    = 	mj_smgt_get_bookname($book_id);
												$search['{{issue_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['issue_date']);							
												$search['{{return_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['return_date']);	
												$search['{{school_name}}'] 		= 	get_option('smgt_school_name');								
												$message = mj_smgt_string_replacement($search,get_option('issue_book_mailcontent'));
												$mail_id=mj_smgt_get_emailid_byuser_id($_POST['student_id']);		
												if(get_option('smgt_mail_notification') == '1')
												{
													wp_mail($mail_id,get_option('issue_book_title'),$message);
												}	
											}
										}	
									}
									wp_redirect ( home_url().'?dashboard=user&page=library&tab=issue_return&user_id='.$_REQUEST['user_id'].'&issue_message=issue_success');
								}
							}

							if(isset($_POST['return_book']))
							{
								$result=$obj_lib->mj_smgt_submit_return_book($_POST);
								if($result)
								{ 
									wp_redirect ( home_url().'?dashboard=user&page=library&tab=issue_return&user_id='.$_REQUEST['user_id'].'&issue_message=return_success');
								}
								
							}
							?>
							<?php
							if(isset($_REQUEST['issue_message']) && ($_REQUEST['issue_message'] == "issue_success"))
							{ 
								?>
								<div id="message" class="alert_msg alert alert-success alert-dismissible " role="alert">
										<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></span>

										</button>

										<p><?php _e('Book Issued Successfully.', 'school-mgt'); ?></p>

								</div>
								<?php 
							} 
							if(isset($_REQUEST['issue_message']) && ($_REQUEST['issue_message'] == "return_success"))
							{ 
								?>
								<div id="message" class="alert_msg alert alert-success alert-dismissible " role="alert">
										<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></span>
										</button>

										<p><?php _e('Book Returned Successfully.', 'school-mgt'); ?></p>

								</div>
								<?php 
							} 
							?>
							<div class="row margin_top_15px margin_left_3">
								<div class="col-xl-4 col-md-4 col-sm-12 margin_bottom_10_res">
									<label class="view_page_header_labels"> <?php esc_html_e('Email ID', 'school-mgt'); ?> </label><br/>
									<label class="view_page_content_labels"> <?php echo $user_data->user_email; ?> </label>
								</div>
								<div class="col-xl-3 col-md-2 col-sm-12 margin_bottom_10_res">
									<label class="view_page_header_labels"> <?php esc_html_e('Library Card No', 'school-mgt'); ?> </label><br/>
									<label class="view_page_content_labels"> 
									<?php 
									if(!empty($library_card_no))
									{
										$library_card =  $library_card_no[0]->library_card_no;
										if(!empty($library_card))
										{
											echo $library_card;
										}
										else
										{
											echo "N/A";
										}
									}
									else
									{
										echo "N/A";
									}
									?>
									</label>
								</div>
								<div class="col-xl-2 col-md-2 col-sm-12 margin_bottom_10_res">
									<label class="view_page_header_labels"> <?php esc_html_e('Gender', 'school-mgt'); ?> </label><br/>
									<label class="view_page_content_labels"> <?php echo esc_html_e(ucfirst($user_data->gender),'school-mgt'); ?></label>
								</div>
								<div class="col-xl-3 col-md-2 col-sm-12 margin_bottom_10_res">
									<label class="view_page_header_labels"> <?php esc_html_e('Date of Birth', 'school-mgt'); ?> </label><br/>
									<label class="view_page_content_labels"> <?php if(!empty($user_data->birth_date)){ echo mj_smgt_getdate_in_input_box($user_data->birth_date);}else{ echo "N/A";} ?></label>
								</div>
							</div>
							<script type="text/javascript">
								jQuery(document).ready(function($)
								{
									$('#book_list1').multiselect({
											nonSelectedText :'<?php esc_attr_e( 'Select Book', 'school-mgt' ) ;?>',
											includeSelectAllOption: true,
											selectAllText : '<?php esc_attr_e( 'Select all', 'school-mgt' ) ;?>',
											templates: {
												button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
											}
									});
								});
							</script>
							<!-- ISSUE bOOK FORM  -->
							<div class="row margin_top_20px">
								<div class="col-xl-12 col-md-12 col-sm-12">
									<div class="col-xl-12 col-md-12 col-sm-12 margin_top_20px margin_top_15px_rs">
									<?php
									if($user_access['add']=='1')
									{
										?>
										<script type="text/javascript">
											jQuery(document).ready(function($)
											{
												var selection = $(".issue_period").val();
												if (selection == '') {
													return false;
												}
												var curr_data = {
													action: 'mj_smgt_get_book_return_date',
													issue_period: $(".issue_period").val(),
													issue_date: $("#issue_date").val()
												};
												$.post(smgt.ajax, curr_data, function (response) {
													$('#return_date').val(response);
												});
											});
										</script>
										<div class="guardian_div">
											<form name="book_form" action="" method="post" class="form-horizontal" id="book_form">
												<?php $action = isset($_REQUEST['action'])?$_REQUEST['action']:'insert';?>
												<input type="hidden" name="action" value="<?php echo $action;?>">
												<input type="hidden" name="issue_id" value="<?php echo $issuebook_id;?>">
												<input type="hidden" name="student_id" value="<?php echo MJ_smgt_decrypt_id($_REQUEST['user_id']);?>">
												<div class="header">	
													<h3 class="first_hed"><?php esc_html_e('Issue Book Information','school-mgt');?></h3>
												</div>
												<div class="form-body user_form">
													<div class="row">
														<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
															<div class="form-group input">
																<div class="col-md-12 form-control">
																	<?php
																	$library_card_name = '';
																	if(!empty($library_card_no))
																	{
																		$library_card =  $library_card_no[0]->library_card_no;
																		if(!empty($library_card))
																		{
																			$library_card_name = $library_card;
																		}
																	}
																	?>
																	<input id="library_card" class="form-control validate[required,custom[address_description_validation]]" type="text" maxlength="50" value="<?php echo $library_card_name;?>" name="library_card" <?php if(!empty($library_card_name)){ echo "readonly"; }?>>
																	<label class="" for="library_card"><?php esc_attr_e('Library Card No.','school-mgt');?><span class="require-field">*</span></label>
																</div>
															</div>
														</div>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 input error_msg_left_margin rtl_margin_0px">
															<label class="ml-1 custom-top-label top" for="category_data validate[required]"><?php esc_attr_e('Subject','school-mgt');?><span class="require-field">*</span></label>
															<select name="bookcat_id" id="bookcat_list" class="form-control max_width_100" style="height: 47px; !important">
																<option value = ""><?php esc_attr_e('Select Subject','school-mgt');?></option>
																
																<?php
																	$book_cat='';
																	if($edit)
																	{
																		$book_cat = $result->cat_id;
																	}
																	$category_data = $obj_lib->mj_smgt_get_bookcat();
																
																	if(!empty($category_data))
																	{
																		foreach ($category_data as $retrieved_data)
																		{
																			echo '<option value="'.$retrieved_data->ID.'" '.selected($book_cat,$retrieved_data->ID).'>'.$retrieved_data->post_title.'</option>';
																		}
																	}
																?>
															</select>
														</div>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 mb-3 error_msg_top_margin">
															<div class="col-sm-12 multiselect_validation_class smgt_multiple_select rtl_padding_left_right_0px">
																<?php 
																	$book_id=0;
																	$books_data=$obj_lib->mj_smgt_get_all_books();
																?>
																<select name="book_id[]" id="book_list1" multiple="multiple" class="form-control validate[required]"></select>		
																<span class ="multiselect_label">
																	<label class="ml-1 custom-top-label top" for="staff_name"><?php esc_html_e('Select Book','gym_mgt');?><span class="required">*</span></label>
																</span>	
															</div>
														</div>
														
														<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
															<label class="ml-1 custom-top-label top" for="period"><?php esc_attr_e('Period ','school-mgt');?><span class="require-field">*</span></label>
															<select name="period_id" id="category_data" class="line_height_30px form-control issue_period validate[required] max_width_100 period_type">
																<option value = ""><?php esc_attr_e('Select Period','school-mgt');?></option>
																<?php 
																if($edit)
																{
																	$period_id = $result->period;
																}
																else
																{
																	$period_id = get_option('smgt_return_period');
																}
																	$category_data = $obj_lib->mj_smgt_get_periodlist();
															
																if(!empty($category_data))
																{
																	foreach ($category_data as $retrieved_data)
																	{
																		echo '<option value="'.$retrieved_data->ID.'" '.selected($period_id,$retrieved_data->ID).'>'.$retrieved_data->post_title.' '. esc_attr__('Days','school-mgt').'</option>';
																	}
																}
																?>
															</select>
														</div>
														<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3">
															<button id="addremove_cat" class="rtl_margin_top_15px add_btn sibling_add_remove" model="period_type"><?php esc_attr_e('Add','school-mgt');?></button>
														</div>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
															<div class="form-group input">
																<div class="col-md-12 form-control">
																	<input id="issue_date" class="datepicker form-control validate[required] text-input" type="text" name="issue_date" value="<?php echo mj_smgt_getdate_in_input_box(date('Y-m-d'));?>" readonly>
																	<label class="" for="issue_date"><?php esc_attr_e('Issue Date','school-mgt');?><span class="require-field">*</span></label>
																</div>
															</div>
														</div>
														<?php wp_nonce_field( 'save_issuebook_admin_nonce' ); ?>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 error_msg_left_margin">
															<div class="form-group input">
																<div class="col-md-12 form-control">
																	<input id="return_date" class="form-control validate[required] date_picker text-input" type="text" name="return_date" value="" readonly>
																	<label class="active date_label" for="return_date"><?php esc_attr_e('Return Date','school-mgt');?><span class="require-field">*</span></label>
																</div>
															</div>
														</div>
														<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
															<div class="form-group">
																<div class="col-md-12 form-control rtl_relative_position">
																	<div class="row padding_radio">
																		<div class="">
																			<label class="custom-top-label label_position_rtl" for="enable"><?php esc_attr_e('Send Mail','school-mgt');?></label>
																			<input id="chk_sms_sent1" type="checkbox" class="check_box_input_margin" <?php $smgt_issue_book_mail_service_enable = 0;if($smgt_issue_book_mail_service_enable) echo "checked";?> value="1" name="smgt_issue_book_mail_service_enable"> <?php esc_attr_e('Send Mail','school-mgt');?>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="form-body user_form">
													<div class="row">
														<div class="col-sm-6">
															<input type="submit" value="<?php esc_attr_e('Issue Book','school-mgt');?>" name="save_issue_book" class="save_btn btn btn-success book_for_alert rtl_margin_0px" />
														</div>    
													</div>
												</div>  
											</form>
										</div>
										<?php
									}
									?>
										<!-- ISSUE bOOK lIST  -->
										<div class="panel-body mt-3">
											<div class="header">	
												<h3 class="first_hed"><?php esc_html_e('Issue Book List','school-mgt');?></h3>
											</div>
											<?php
											$issue_data = $obj_lib->mj_smgt_get_all_issuebooks_for_student($user_id);
											if(!empty($issue_data))
											{
												?>
												<script type="text/javascript">
													jQuery(document).ready(function($)
													{
														var table =  jQuery('#user_issue_list').DataTable({
															"initComplete": function(settings, json) {
																$(".print-button").css({"margin-top": "-5%"});
															},
															"dom": 'lifrtp',
															"order": [[ 2, "asc" ]],
															"aoColumns":[	                  
																		{"bSortable": false},
																		{"bSortable": true},
																		{"bSortable": true},
																		{"bSortable": true},
																		{"bSortable": true},
																		{"bSortable": true},
																		{"bSortable": true},
																		{"bSortable": true},	
																		{"bSortable": false}
																	],
															language:<?php echo mj_smgt_datatable_multi_language();?>
														});
														$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
													});
												</script>
												<div class="table-responsive">
													<form id="frm-example" name="frm-example" method="post">
														<table id="user_issue_list" class="display" cellspacing="0" width="100%">
															<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
																<tr>
																	<th><?php esc_attr_e('Image', 'school-mgt');?></th>
																	<th><?php esc_attr_e('Book Title','school-mgt');?></th>
																	<th><?php esc_attr_e('Issue Date','school-mgt');?></th>
																	<th><?php esc_attr_e('Due Return Date ','school-mgt');?></th>
																	<th><?php esc_attr_e('Accept Return Date ','school-mgt');?></th>
																	<th><?php esc_attr_e('Period','school-mgt');?></th>
																	<th><?php esc_attr_e('Fine','school-mgt');?></th>
																	<th><?php esc_attr_e('Comment','school-mgt');?></th>
																	<th class="text_align_end"><?php esc_attr_e('Action', 'school-mgt');?></th>
																</tr>
															</thead>
															<tbody>
																<?php
																$i=0;
																foreach ($issue_data as $retrieved_data) 
																{
																	$book_data=$obj_lib->mj_smgt_get_single_books($retrieved_data->book_id);
																	?>
																	<tr>
																		<td class="user_image width_50px"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/Library.png" ?>" class="img-circle" /></td>
																		<td><?php echo stripslashes(mj_smgt_get_bookname($retrieved_data->book_id));?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Book Title','school-mgt');?>" ></i></td>
																		<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->issue_date);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Issue Date','school-mgt');?>" ></i> </td>
																		<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->end_date);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Due Return Date','school-mgt');?>" ></i></td>
																		<td><?php  if(!empty($retrieved_data->actual_return_date)){echo mj_smgt_getdate_in_input_box($retrieved_data->actual_return_date);}else{echo "N/A";}?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Accept Return Date','school-mgt');?>" ></i></td>
																		<td><?php echo get_the_title($retrieved_data->period);?> <?php _e('Day','school-mgt') ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Period','school-mgt');?>" ></i></td>
																		<td class="" ><?php if($retrieved_data->fine == "" || $retrieved_data->fine == 0){ echo 'N/A';}else{echo mj_smgt_get_currency_symbol().$retrieved_data->fine; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Fine','school-mgt');?>" ></i></td>
																		<td class="" ><?php if($book_data->description == ""){ echo 'N/A';}else{echo $retrieved_data->description; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php if($book_data->description == ""){ echo 'Comment';}else{echo $retrieved_data->description; } ?>" ></i></td>
																		<td class="action"> 
																			<div class="smgt-user-dropdown">
																			<?php
																				$current_role = mj_smgt_get_user_role(get_current_user_id());
																				
																				?>
																				<ul class="" style="margin-bottom: 0px !important;">
																				   
																					<li class="">
																						<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																							<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
																						</a>
																						
																						<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
																							<?php
																							if($retrieved_data->status == "Issue" &&  ($current_role == "supportstaff" ||  $current_role == "teacher"))
																							{
																							?>
																								<li class="float_left_width_100">
																									<a idtest=<?php echo $retrieved_data->id;?> id="accept_returns_book_popup" class="float_left_width_100"><img src="<?php echo SMS_PLUGIN_URL."/assets/images/accept_book_return.png"?>" style="height:13px;">&nbsp;&nbsp;&nbsp;<?php esc_attr_e('Accept Returns','school-mgt');?> </a>
																								</li>
																							<?php
																							}
																							?>
																						</ul>

																					</li>

																				</ul>
																				
																			</div>	

																		</td>
																	</tr>
																	<?php
																}
																?>
															</tbody>
														</table>
													</form>
												</div>
												<?php
											}
											else
											{
												?>
												<div class="calendar-event-new"> 
													<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
												</div>	
												<?php
											}
											?>
										</div>
									</div>
								</div>
							</div>
							<?php
						}
						?>
					</div>
				</section>
			</div>
		</div>
		<?php
	}
	if($active_tab == 'view_book')
	{
		$obj_lib = new Smgtlibrary();
		if (isset($_GET['book_id']) && is_array($_GET['book_id'])) {
			$book_id = reset($_GET['book_id']); // Get the first book_id from the array
		} else {
			$book_id = $_GET['book_id'] ?? ''; // Use single value if not an array
		}
		// Now safely pass it to your function
		$bookid = MJ_smgt_decrypt_id($book_id);
		$book_data=$obj_lib->mj_smgt_get_single_books($bookid);
		
		?>
		<div class="panel-body view_page_main"><!-- START PANEL BODY DIV-->
			<div class="content-body">
				<section id="user_information" class="">
					<div class="view_page_header_bg">
						<div class="row">
							<div class="col-xl-10 col-md-9 col-sm-10">
								<div class="user_profile_header_left float_left_width_100">
									<img class="user_view_profile_image" src="<?php echo SMS_PLUGIN_URL."/assets/images/Library.png"?>">
									<div class="row profile_user_name">
										<div class="float_left view_top1">
											<div class="col-xl-12 col-md-12 col-sm-12 float_left_width_100">
												<label class="view_user_name_label"><?php echo ucfirst($book_data->book_name);?></label>
												<?php
												if($user_access['edit']=='1')
												{
													?>
														<div class="view_user_edit_btn">
															<a class="color_white margin_left_2px" href="?dashboard=user&page=library&tab=addbook&action=edit&book_id=<?php echo MJ_smgt_encrypt_id($book_data->id);?>&_wpnonce_action=<?php echo MJ_smgt_get_nonce('edit_action');?>">
																<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/edit.png"?>">
															</a>
														</div>
													<?php
												}
												?>
											</div>
										</div>
									</div>
								</div>		
							</div>
							<div class="col-xl-2 col-lg-3 col-md-3 col-sm-2 add_btn_possition_teacher_res">
								<div class="group_thumbs">
									<img src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/Group.png"?>">
								</div>
							</div>
						</div>
					</div>
				</section>

				<section id="body_content_area" class="mt-5">
					<div class="panel-body"><!-- START PANEL BODY DIV-->

						<?php
						if(isset($_REQUEST['issue_message']) && ($_REQUEST['issue_message'] == "issue_success"))
						{ 
							?>
							<div id="message" class="alert_msg alert alert-success alert-dismissible " role="alert">
									<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></span>
									</button>
									<p><?php esc_attr_e('Book Issued Successfully.', 'school-mgt'); ?></p>
							</div>
							<?php 
						} 
						if(isset($_REQUEST['issue_message']) && ($_REQUEST['issue_message'] == "return_success"))
						{ 
							?>
							<div id="message" class="alert_msg alert alert-success alert-dismissible " role="alert">
									<button type="button" class="btn-default notice-dismiss" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></span>
									</button>
									<p><?php esc_attr_e('Book Returned Successfully.', 'school-mgt'); ?></p>
							</div>
							<?php 
						} 
						?>
						<div class="row">
							<div class="col-xl-12 col-md-12 col-sm-12">
								<div class="col-xl-12 col-md-12 col-sm-12 margin_top_15px_rs">
									<div class="guardian_div">
										<label class="view_page_label_heading"> <?php esc_html_e('Book Information', 'school-mgt'); ?> </label>
										<div class="row">
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('ISBN', 'school-mgt'); ?> </label> <br>
												<label class="view_page_content_labels"><?php if(!empty($book_data->ISBN)){ echo $book_data->ISBN;}else{ echo "N/A";}?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Book Number', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->book_number)){ echo $book_data->book_number;}else{ echo "N/A";}?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Book Category', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->cat_id)){ echo get_the_title($book_data->cat_id);}else{ echo "N/A";}?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Author Name', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->author_name)){ echo $book_data->author_name;}else{ echo "N/A";}?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Publisher', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->publisher)){ echo $book_data->publisher;}else{ echo "N/A";}?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Rack Location', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php if(!empty($book_data->rack_location)){ echo get_the_title($book_data->rack_location);}else{ echo "N/A";}?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Book Price', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php echo MJ_smgt_currency_symbol_position_language_wise(number_format($book_data->price, 2, '.', '')); ?></label>
											</div>
											<div class="col-xl-3 col-md-3 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Remaining Quantity', 'school-mgt'); ?> </label><br>
												<label class="ftext_style_capitalization view_page_content_labels"><?php echo $book_data->quentity . ' ' . esc_html__("Out Of", "school-mgt") . " " . $book_data->total_quentity; ?></label>
											</div>
											<div class="col-xl-12 col-md-12 col-sm-12 margin_top_15px">
												<label class="guardian_labels view_page_header_labels"> <?php esc_html_e('Description', 'school-mgt'); ?> </label><br>
												<label class="">
												<?php
												if(!empty($book_data->description))
												{
													echo $book_data->description;
												}
												else
												{
													echo "N/A";
												}
												?>
												</label>
											</div>
										</div>
									</div>
								</div>
								<?php
								if(isset($_POST['save_issue_book']))
								{
									$result=$obj_lib->mj_smgt_add_issue_book($_POST);
									if($result)
									{ 
										/* Book Issue Mail Notification */
										if(isset($_POST['smgt_issue_book_mail_service_enable']))
										{
											foreach($_POST['book_id'] as $book_id)
											{
												$smgt_issue_book_mail_service_enable = $_POST['smgt_issue_book_mail_service_enable'];
												if($smgt_issue_book_mail_service_enable)
												{	
													$search['{{student_name}}']	 	= 	mj_smgt_get_teacher($_POST['student_id']);
													$search['{{book_name}}'] 	    = 	mj_smgt_get_bookname($book_id);
													$search['{{issue_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['issue_date']);							
													$search['{{return_date}}'] 	    = 	mj_smgt_getdate_in_input_box($_POST['return_date']);	
													$search['{{school_name}}'] 		= 	get_option('smgt_school_name');								
													$message = mj_smgt_string_replacement($search,get_option('issue_book_mailcontent'));
													$mail_id=mj_smgt_get_emailid_byuser_id($_POST['student_id']);		
													if(get_option('smgt_mail_notification') == '1')
													{
														wp_mail($mail_id,get_option('issue_book_title'),$message);
													}	
												}
											}	
										}
										wp_redirect ( home_url().'?dashboard=user&page=library&tab=view_book&book_id='.MJ_smgt_encrypt_id($bookid).'&issue_message=issue_success');
									}
								}
								if(isset($_POST['return_book']))
								{
									$result=$obj_lib->mj_smgt_submit_return_book($_POST);
									wp_redirect ( home_url().'?dashboard=user&page=library&tab=view_book&book_id='.MJ_smgt_encrypt_id($bookid).'&issue_message=return_success');
								}
								?>
								<div class="col-xl-12 col-md-12 col-sm-12 mt-3 margin_top_15px_rs">
									<?php
									if($user_access['add']=='1')
									{
										?>
										<script type="text/javascript">
										jQuery(document).ready(function($)
										{
											var selection = $(".issue_period").val();
											if (selection == '') {
												return false;
											}
											var curr_data = {
												action: 'mj_smgt_get_book_return_date',
												issue_period: $(".issue_period").val(),
												issue_date: $("#issue_date").val()
											};
											$.post(smgt.ajax, curr_data, function (response) {
												$('#return_date').val(response);
											});
										});
										</script>
										<div class="guardian_div">
											<label class="view_page_label_heading mb-4"> <?php esc_html_e('Issue Book Information', 'school-mgt'); ?> </label>
											<form name="issue_book_form" action="" method="post" class="form-horizontal" id="issue_book_form">
												<?php $action = isset($_REQUEST['action'])?$_REQUEST['action']:'insert';?>
												<input type="hidden" name="action" value="<?php echo $action;?>">
												<input type="hidden" name="issue_id" value="">
												<input type="hidden" name="book_id[]" value="<?php echo $bookid;?>">
												<input type="hidden" name="bookcat_id" value="<?php echo $book_data->cat_id;?>">
												<div class="form-body user_form">
													<div class="row">
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 input error_msg_left_margin rtl_margin_0px">
															<label class="ml-1 custom-top-label top" for="student_id"><?php esc_attr_e('Select User','school-mgt');?><span class="require-field">*</span></label>
															<select name="student_id" id="student_id" class="form-control change_library_card max_width_100 line_height_30px">
																<option value = ""><?php esc_attr_e('Select User','school-mgt');?></option>
																<?php echo mj_smgt_get_student_and_teacher_for_library();?>
															</select>
														</div>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
															<div class="form-group input">
																<div class="col-md-12 form-control">
																	<input id="issue_library_card" class="form-control validate[required,custom[address_description_validation]]" type="text" maxlength="50" value="" name="library_card">
																	<label class="" for="library_card"><?php esc_attr_e('Library Card No.','school-mgt');?><span class="require-field">*</span></label>
																</div>
															</div>
														</div>
														<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
															<label class="ml-1 custom-top-label top" for="period"><?php esc_attr_e('Period','school-mgt');?><span class="require-field">*</span></label>
															<select name="period_id" id="category_data" class="form-control issue_period validate[required] max_width_100 period_type line_height_30px">
																<option value = ""><?php esc_attr_e('Select Period','school-mgt');?></option>
																<?php 
																if($edit)
																{
																	$period_id = $result->period;
																}
																else
																{
																	$period_id = get_option('smgt_return_period');
																}
																	$category_data = $obj_lib->mj_smgt_get_periodlist();
															
																if(!empty($category_data))
																{
																	foreach ($category_data as $retrieved_data)
																	{
																		echo '<option value="'.$retrieved_data->ID.'" '.selected($period_id,$retrieved_data->ID).'>'.$retrieved_data->post_title.' '. esc_attr__('Days','school-mgt').'</option>';
																	}
																}
																?>
															</select>
														</div>
														<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3">
															<button id="addremove_cat" class="rtl_margin_top_15px add_btn sibling_add_remove" model="period_type"><?php esc_attr_e('Add','school-mgt');?></button>
														</div>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
															<div class="form-group input">
																<div class="col-md-12 form-control">
																	<input id="issue_date" class="datepicker form-control validate[required] text-input" type="text" name="issue_date" value="<?php echo mj_smgt_getdate_in_input_box(date('Y-m-d'));?>" readonly>
																	<label class="" for="issue_date"><?php esc_attr_e('Issue Date','school-mgt');?><span class="require-field">*</span></label>
																</div>
															</div>
														</div>
														<?php wp_nonce_field( 'save_issuebook_admin_nonce' ); ?>
														<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3">
															<div class="form-group input">
																<div class="col-md-12 form-control">
																	<input id="return_date" class="form-control validate[required] date_picker text-input" type="text" name="return_date" value="" readonly>
																	<label class="active date_label" for="return_date"><?php esc_attr_e('Return Date','school-mgt');?><span class="require-field">*</span></label>
																</div>
															</div>
														</div>
														<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3">
															<div class="form-group">
																<div class="col-md-12 form-control rtl_relative_position">
																	<div class="row padding_radio">
																		<div class="">
																			<label class="custom-top-label label_position_rtl" for="enable"><?php esc_attr_e('Send Mail','school-mgt');?></label>
																			<input id="chk_sms_sent1" type="checkbox" class="check_box_input_margin" <?php $smgt_issue_book_mail_service_enable = 0;if($smgt_issue_book_mail_service_enable) echo "checked";?> value="1" name="smgt_issue_book_mail_service_enable"> <?php esc_attr_e('Send Mail','school-mgt');?>
																		</div>												
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="form-body user_form">
													<div class="row">
														<div class="col-sm-6">      
															<input type="submit" value="<?php esc_attr_e('Issue Book','school-mgt');?>" name="save_issue_book" class="save_btn btn btn-success book_for_alert rtl_margin_0px" />
														</div>    
													</div>
												</div>  
											</form>
										</div>
										<?php
									}
									?>
									<div class="panel-body mt-3">
										<div class="header">	
											<h3 class="first_hed"><?php esc_html_e('Issue Book List','school-mgt');?></h3>
										</div>
										<?php
										$issue_data = $obj_lib->mj_smgt_get_all_issuebooks_book_id($bookid);
										if(!empty($issue_data))
										{
											?>
											<script type="text/javascript">
												jQuery(document).ready(function($)
												{
													var table =  jQuery('#user_issue_list').DataTable({
														"initComplete": function(settings, json) {
															$(".print-button").css({"margin-top": "-5%"});
														},
														"dom": 'lifrtp',
														"order": [[ 2, "asc" ]],
														"aoColumns":[	                  
																	{"bSortable": false},
																	{"bSortable": true},
																	{"bSortable": true},
																	{"bSortable": true},
																	{"bSortable": true},
																	{"bSortable": true},
																	{"bSortable": true},
																	{"bSortable": true},
																	{"bSortable": true},	
																	{"bSortable": false}
																],
														language:<?php echo mj_smgt_datatable_multi_language();?>
													});
													$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'school-mgt') ?>");
												});
											</script>
											<div class="table-responsive">
												<form id="frm-example" name="frm-example" method="post">
													<table id="user_issue_list" class="display" cellspacing="0" width="100%">
														<thead class="<?php echo MJ_smgt_datatable_heder() ?>">
															<tr>
																<th><?php esc_attr_e('Image', 'school-mgt');?></th>
																<th><?php esc_attr_e('User Name','school-mgt');?></th>
																<th><?php esc_attr_e('Issue Date','school-mgt');?></th>
																<th><?php esc_attr_e('Due Return Date ','school-mgt');?></th>
																<th><?php esc_attr_e('Accept Return Date ','school-mgt');?></th>
																<th><?php esc_attr_e('Period','school-mgt');?></th>
																<th><?php esc_attr_e('Status','school-mgt');?></th>
																<th><?php esc_attr_e('Fine','school-mgt');?></th>
																<th><?php esc_attr_e('Comment','school-mgt');?></th>
																<th class="text_align_end"><?php esc_attr_e('Action', 'school-mgt');?></th>
															</tr>
														</thead>
														<tbody>
															<?php
															$i=0;
															$current_role = mj_smgt_get_user_role(get_current_user_id());
															foreach ($issue_data as $retrieved_data) 
															{
																?>
																<tr>
																	<td class="user_image width_50px"><img src="<?php echo SMS_PLUGIN_URL . "/assets/images/Library.png" ?>" class="img-circle" /></td>
																	<td><?php echo mj_smgt_get_display_name($retrieved_data->student_id);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('User Name','school-mgt');?>" ></i></td>
																	<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->issue_date);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Issue Date','school-mgt');?>" ></i> </td>
																	<td><?php echo mj_smgt_getdate_in_input_box($retrieved_data->end_date);?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Due Return Date','school-mgt');?>" ></i></td>
																	<td><?php  if(!empty($retrieved_data->actual_return_date)){echo mj_smgt_getdate_in_input_box($retrieved_data->actual_return_date);}else{echo "N/A";}?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Accept Return Date','school-mgt');?>" ></i></td>
																	<td><?php echo get_the_title($retrieved_data->period);?> <?php _e('Day','school-mgt') ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Period','school-mgt');?>" ></i></td>
																	<td class="" >
																		<?php 
																		if($retrieved_data->status == "Issue")
																		{ 
																			esc_attr_e('Issued','school-mgt');
																		}
																		elseif($retrieved_data->status == "Submitted")
																		{ 
																			esc_attr_e('Returned','school-mgt');
																		} ?> 
																		
																		<i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Status','school-mgt');?>" ></i></td>
																	<td class="" ><?php if($retrieved_data->fine == "" || $retrieved_data->fine == 0){ echo 'N/A';}else{echo mj_smgt_get_currency_symbol().$retrieved_data->fine; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php _e('Fine','school-mgt');?>" ></i></td>
																	<td class="" ><?php if($retrieved_data->comment == ""){ echo 'N/A';}else{echo $retrieved_data->comment; } ?> <i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php if($retrieved_data->comment == ""){ echo 'Comment';}else{echo $retrieved_data->comment; } ?> " ></i></td>
																	<td class="action"> 
																		<div class="smgt-user-dropdown">
																			<ul class="" style="margin-bottom: 0px !important;">
																				<li class="">
																					<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																						<img src="<?php echo SMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
																					</a>
																					<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
																						<?php
																						if($retrieved_data->status == "Issue" && ($current_role == "supportstaff" ||  $current_role == "teacher"))
																						{
																							?>
																							<li class="float_left_width_100">
																								<a idtest=<?php echo $retrieved_data->id;?> id="accept_returns_book_popup" class="float_left_width_100"><img src="<?php echo SMS_PLUGIN_URL."/assets/images/accept_book_return.png"?>" style="height:13px;">&nbsp;&nbsp;&nbsp;<?php esc_attr_e('Accept Returns','school-mgt');?> </a>
																							</li>
																							<?php
																						}
																						?>
																						
																					</ul>

																				</li>

																			</ul>

																		</div>	

																	</td>
																</tr>
																<?php
															}
															?>
														</tbody>
													</table>
												</form>
											</div>
											<?php
										}
										else
										{
											?>
											<div class="calendar-event-new"> 
												<img class="no_data_img" src="<?php echo SMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
											</div>	
											<?php
										}
										?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
			</div>
		</div>
		<?php
	}
	?>
</div>
<?php ?>