// Generated by CoffeeScript 2.1.0
(function() {
  /*
  jQuery Growl
  Copyright 2015 Kevin Sylvestre
  1.3.3
  */
  "use strict";
  var $, Animation, Growl;

  $ = jQuery;

  Animation = (function() {
    class Animation {
      static transition($el) {
        var el, ref, result, type;
        el = $el[0];
        ref = this.transitions;
        for (type in ref) {
          result = ref[type];
          if (el.style[type] != null) {
            return result;
          }
        }
      }

    };

    Animation.transitions = {
      "webkitTransition": "webkitTransitionEnd",
      "mozTransition": "mozTransitionEnd",
      "oTransition": "oTransitionEnd",
      "transition": "transitionend"
    };

    return Animation;

  })();

  Growl = (function() {
    class Growl {
      static growl(settings = {}) {
        return new Growl(settings);
      }

      constructor(settings = {}) {
        this.render = this.render.bind(this);
        this.bind = this.bind.bind(this);
        this.unbind = this.unbind.bind(this);
        this.mouseEnter = this.mouseEnter.bind(this);
        this.mouseLeave = this.mouseLeave.bind(this);
        this.click = this.click.bind(this);
        this.close = this.close.bind(this);
        this.cycle = this.cycle.bind(this);
        this.waitAndDismiss = this.waitAndDismiss.bind(this);
        this.present = this.present.bind(this);
        this.dismiss = this.dismiss.bind(this);
        this.remove = this.remove.bind(this);
        this.animate = this.animate.bind(this);
        this.$growls = this.$growls.bind(this);
        this.$growl = this.$growl.bind(this);
        this.html = this.html.bind(this);
        this.content = this.content.bind(this);
        this.container = this.container.bind(this);
        this.settings = $.extend({}, Growl.settings, settings);
        this.initialize(this.settings.location);
        this.render();
      }

      initialize(location) {
        var id;
        id = 'growls-' + location;
        return $('body:not(:has(#' + id + '))').append('<div id="' + id + '" />');
      }

      render() {
        var $growl;
        $growl = this.$growl();
        this.$growls(this.settings.location).append($growl);
        if (this.settings.fixed) {
          this.present();
        } else {
          this.cycle();
        }
      }

      bind($growl = this.$growl()) {
        $growl.on("click", this.click);
        if (this.settings.delayOnHover) {
          $growl.on("mouseenter", this.mouseEnter);
          $growl.on("mouseleave", this.mouseLeave);
        }
        return $growl.on("contextmenu", this.close).find(`.${this.settings.namespace}-close`).on("click", this.close);
      }

      unbind($growl = this.$growl()) {
        $growl.off("click", this.click);
        if (this.settings.delayOnHover) {
          $growl.off("mouseenter", this.mouseEnter);
          $growl.off("mouseleave", this.mouseLeave);
        }
        return $growl.off("contextmenu", this.close).find(`.${this.settings.namespace}-close`).off("click", this.close);
      }

      mouseEnter(event) {
        var $growl;
        $growl = this.$growl();
        return $growl.stop(true, true);
      }

      mouseLeave(event) {
        return this.waitAndDismiss();
      }

      click(event) {
        if (this.settings.url != null) {
          event.preventDefault();
          event.stopPropagation();
          return window.open(this.settings.url);
        }
      }

      close(event) {
        var $growl;
        event.preventDefault();
        event.stopPropagation();
        $growl = this.$growl();
        return $growl.stop().queue(this.dismiss).queue(this.remove);
      }

      cycle() {
        var $growl;
        $growl = this.$growl();
        return $growl.queue(this.present).queue(this.waitAndDismiss());
      }

      waitAndDismiss() {
        var $growl;
        $growl = this.$growl();
        return $growl.delay(this.settings.duration).queue(this.dismiss).queue(this.remove);
      }

      present(callback) {
        var $growl;
        $growl = this.$growl();
        this.bind($growl);
        return this.animate($growl, `${this.settings.namespace}-incoming`, 'out', callback);
      }

      dismiss(callback) {
        var $growl;
        $growl = this.$growl();
        this.unbind($growl);
        return this.animate($growl, `${this.settings.namespace}-outgoing`, 'in', callback);
      }

      remove(callback) {
        this.$growl().remove();
        return typeof callback === "function" ? callback() : void 0;
      }

      animate($element, name, direction = 'in', callback) {
        var transition;
        transition = Animation.transition($element);
        $element[direction === 'in' ? 'removeClass' : 'addClass'](name);
        $element.offset().position;
        $element[direction === 'in' ? 'addClass' : 'removeClass'](name);
        if (callback == null) {
          return;
        }
        if (transition != null) {
          $element.one(transition, callback);
        } else {
          callback();
        }
      }

      $growls(location) {
        var base;
        if (this.$_growls == null) {
          this.$_growls = [];
        }
        return (base = this.$_growls)[location] != null ? base[location] : base[location] = $('#growls-' + location);
      }

      $growl() {
        return this.$_growl != null ? this.$_growl : this.$_growl = $(this.html());
      }

      html() {
        return this.container(this.content());
      }

      content() {
        return `<div class='${this.settings.namespace}-close'>${this.settings.close}</div>\n<div class='${this.settings.namespace}-title'>${this.settings.title}</div>\n<div class='${this.settings.namespace}-message'>${this.settings.message}</div>`;
      }

      container(content) {
        return `<div class='${this.settings.namespace} ${this.settings.namespace}-${this.settings.style} ${this.settings.namespace}-${this.settings.size}'>\n  ${content}\n</div>`;
      }

    };

    Growl.settings = {
      namespace: 'growl',
      duration: 3200,
      close: "&#215;",
      location: "default",
      style: "default",
      size: "medium",
      delayOnHover: true
    };

    return Growl;

  })();

  this.Growl = Growl;

  $.growl = function(options = {}) {
    return Growl.growl(options);
  };

  $.growl.error = function(options = {}) {
    var settings;
    settings = {
      title: "Error!",
      style: "error"
    };
    return $.growl($.extend(settings, options));
  };

  $.growl.notice = function(options = {}) {
    var settings;
    settings = {
      title: "Notice!",
      style: "notice"
    };
    return $.growl($.extend(settings, options));
  };

  $.growl.warning = function(options = {}) {
    var settings;
    settings = {
      title: "Warning!",
      style: "warning"
    };
    return $.growl($.extend(settings, options));
  };

}).call(this);