<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'BESTBUG_HB_IMPORT_SHORTCODE' ) ) {
	/**
	 * BESTBUG_HB_IMPORT_SHORTCODE Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_HB_IMPORT_SHORTCODE {

		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			add_action( 'init', array( $this, 'init' ) );
		}

		public function init() {
			
			add_shortcode( BESTBUG_HB_IMPORT_SHORTCODE, array( $this, 'shortcode' ) );
			if ( defined( 'WPB_VC_VERSION' ) && function_exists( 'vc_add_param' ) ) {
				$this->vc_shortcode();
			}

        }

		public function vc_shortcode() {
			vc_map( array(
			    "name" => esc_html__( "Shortcode", 'bestbug' ),
			    "base" => BESTBUG_HB_IMPORT_SHORTCODE,
			    "content_element" => true,
				"icon" => 'bbhd_icon_shortcode',
				"description" => esc_html__( "Import a shortcode", 'bestbug' ),
				'category' => esc_html( sprintf( esc_html__( 'by %s', 'bestbug' ), BESTBUG_HB_CATEGORY ) ),
			    "params" => array(
					array(
						'type'        => 'textarea_raw_html',
						'heading'     => 'Shortcode',
						'param_name'  => 'shortcode',
						'admin_label' => true,
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Extra class name', 'bestbug' ),
						'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.', 'bestbug'),
						'param_name' => 'el_class',
					),
					array(
						'type' => 'css_editor',
						'heading' => 'CSS box',
						'param_name' => 'css',
						'group' => 'Design Options',
					),
			    ),
			) );
        }

		public function shortcode( $atts ){
			extract( shortcode_atts( array(
				'shortcode' => '',
				'css' => '',
				'el_class' => '',
			), $atts ) );
			
			$class_array = array('bbfb-import-shortcode');
			if(isset($css) && !empty($css)) {
				array_push($class_array, BESTBUG_HELPER::vc_shortcode_custom_css_class($css));
			}
			if(isset($el_class) && !empty($el_class)) {
				array_push($class_array, $el_class);
			}
            $class_string = apply_filters( 'vc_shortcodes_css_class', implode(' ', $class_array), BESTBUG_HB_IMPORT_SHORTCODE, $atts );
            ob_start();
            ?>
            <div class="<?php echo esc_html($class_string) ?> bb_footer_import_shortcode " >
            <?php

            echo do_shortcode(urldecode( base64_decode ($shortcode) ) );
            ?>
            </div>
            <?php
            $shortcodeContent = ob_get_contents();
            ob_end_clean();
			return $shortcodeContent;
			
		}
		
    }
	
	new BESTBUG_HB_IMPORT_SHORTCODE();
}
