const { registerCheckoutFilters } = window.wc.blocksCheckout;

const wcMeasurementPriceCalculatorCartItemPriceFormatting =  (
	defaultValue,
	extensions,
	args,
	validation
) => {

	if ( ! args?.cartItem || ! args?.cartItem?.key || 0 === args?.cartItem?.key.length || typeof defaultValue !== 'string' ) {
		return defaultValue;
	}

	let cartItemKey      = args.cartItem.key,
		measurementUnits = window?.wc_price_calculator_block_params?.cart_item_products_pricing_labels;

	if ( measurementUnits && measurementUnits[ cartItemKey ] ) {
		return defaultValue + ' ' + measurementUnits[ cartItemKey ];
	}

	return defaultValue;
};

registerCheckoutFilters( 'woocommerce-measurement-price-calculator', {
	subtotalPriceFormat: wcMeasurementPriceCalculatorCartItemPriceFormatting,
} );
