<?php

use Merkulove\Helper\Unity\Settings;

require_once __DIR__ . '/../../../../../../wp-load.php'; // Load WordPress core
require_once __DIR__ . '/../../../vendor/autoload.php';

header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

// Disable output buffering
if (ob_get_level()) ob_end_flush();
ob_implicit_flush(true);

if ( !isset( $_GET['visitor_message'] ) || !isset( $_GET['mdp_helper_nonce'] ) ) {
    echo "event: stop\n";
    echo "data: stopped\n\n";
    die( "Invalid request." );
}

if ( !wp_verify_nonce( $_GET['mdp_helper_nonce'], 'mdp-helper-nonce' ) ) {
    echo "event: stop\n";
    echo "data: stopped\n\n";
    die( "Invalid request nonce." );
}


$options = Settings::get_instance()->options;
$question = esc_attr( $_GET['visitor_message'] );

\Merkulove\Helper\OpenAiBot::get_instance()->stream_bot_response($question);


echo "event: stop\n";
echo "data: stopped\n\n";