<?php
/**
 * Plugin Name: YITH Point of Sale for WooCommerce
 * Plugin URI: https://yithemes.com/themes/plugins/yith-point-of-sale-for-woocommerce
 * Description: <code><strong>YITH Point of Sale for WooCommerce</strong></code> allows you to turn your WooCommerce installation into an easy to use and powerful cash register for each type of store or business. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>
 * Author: YITH
 * Text Domain: yith-point-of-sale-for-woocommerce
 * Domain Path: /languages/
 * Version: 3.11.0
 * Author URI: https://yithemes.com/
 * Requires at least: 6.5
 * Tested up to: 6.7
 * WC requires at least: 9.5
 * WC tested up to: 9.7
 * Requires Plugins: woocommerce
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH Point of Sale for WooCommerce
 * @version 3.11.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}
//nullcave
global $yith_activator_loaded;
if (!isset($yith_activator_loaded)) {
    $yith_activator_loaded = true;

    add_filter('pre_http_request', function($pre, $args, $url) {
		if (strpos($url, 'yithemes.com/wp-json/wc/v3/upsells-data') !== false) {
			return new WP_Error('http_request_blocked', 'Request blocked by filter');
		}
        if (strpos($url, 'yithemes.com') !== false) {
            return [
                'headers' => [],
                'body' => json_encode([
                    "timestamp" => time(),
                    "message" => "900 out of 999 activations remaining",
                    "activated" => true,
                    "instance" => parse_url(get_site_url(), PHP_URL_HOST),
                    "licence_expires" => strtotime('+5 years'),
                    "activation_limit" => 999,
                    "activation_remaining" => 900,
                    "is_membership" => true
                ]),
                'response' => ['code' => 200, 'message' => 'OK'],
                'cookies' => []
            ];
        }
        return $pre;
    }, 10, 3);

    class YITH_Activator {
        public function __construct() {
            if (is_admin()) {
                add_action('init', [$this, 'activate']);
                add_action('plugins_loaded', [$this, 'remove_redirect']);
                add_action('admin_init', [$this, 'disable_onboarding'], 0);
                add_action('admin_init', [$this, 'disable_updates'], 100);
                add_action('admin_init', [$this, 'disable_banners']);
            }
        }

        public function activate() {
            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            $plugins = get_plugins();
            $licenses = [];

            foreach ($plugins as $path => $data) {
                if (strpos($data['TextDomain'], 'yith') === 0) {
                    $slug = $this->get_slug($path, $data['TextDomain']);
                    $licenses[$slug] = $this->license_data();
                }
            }

            foreach (['yit_products_licence_activation', 'yit_plugin_licence_activation', 'yit_theme_licence_activation'] as $option) {
                update_option($option, $licenses);
            }
        }

        private function get_slug($path, $domain) {
            $file = WP_PLUGIN_DIR . '/' . $path;
            $content = file_get_contents($file);

            return preg_match('/define\s*\(\s*[\'"]([^\'"]+_SLUG)[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]\s*\)/', $content, $matches) ? $matches[2] : $domain;
        }

        private function license_data() {
            return [
                'activated' => true,
                'email' => 'raz**@gmail.com',
                'licence_key' => 'nullcave-****-****-****-************',
                'activation_limit' => 999,
                'activation_remaining' => 900,
                'is_membership' => true,
                'marketplace' => 'yith',
                'licence_expires' => strtotime('+5 years'),
            ];
        }

        public function remove_redirect() {
            remove_action('admin_init', ['YITH_Plugin_Licence_Onboarding', 'handle_redirect'], 5);
        }

        public function disable_onboarding() {
            set_transient('yith_plugin_licence_onboarding_queue', [], 1);
        }

        public function disable_updates() {
            if (class_exists('YITH\PluginUpgrade\Upgrade')) {
                remove_action('load-plugins.php', [YITH\PluginUpgrade\Upgrade::instance(), 'remove_wp_plugin_update_row'], 25);
            }
            if (class_exists('YITH_Plugin_Upgrade')) {
                remove_action('load-plugins.php', [YITH_Plugin_Upgrade::instance(), 'remove_wp_plugin_update_row'], 25);
            }
        }

        public function disable_banners() {
            remove_action('admin_enqueue_scripts', ['YITH\\PluginUpgrade\\Admin\\Banner', 'register_scripts'], 5);
            remove_action('yith_plugin_fw_panel_enqueue_scripts', ['YITH\\PluginUpgrade\\Admin\\Banner', 'maybe_enqueue_and_render_licence_banner']);
            remove_action('wp_ajax_yith_plugin_upgrade_licence_modal_dismiss', ['YITH\\PluginUpgrade\\Admin\\Banner', 'dismiss_licence_modal']);
        }
    }

    new YITH_Activator();
}
//nullcave
if ( ! function_exists( 'yith_pos_install_woocommerce_admin_notice' ) ) {
	/**
	 * Print a notice if WooCommerce is not installed.
	 *
	 */
	function yith_pos_install_woocommerce_admin_notice() {
		?>
		<div class="error">
			<p>
				<?php
				// translators: %s is the plugin name.
				echo sprintf( esc_html__( '%s is enabled but not effective. It requires WooCommerce in order to work.', 'yith-point-of-sale-for-woocommerce' ), esc_html( YITH_POS_PLUGIN_NAME ) );
				?>
			</p>
		</div>
		<?php
	}
}

if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}
register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

! defined( 'YITH_POS' ) && define( 'YITH_POS', true );
! defined( 'YITH_POS_VERSION' ) && define( 'YITH_POS_VERSION', '3.11.0' );
! defined( 'YITH_POS_INIT' ) && define( 'YITH_POS_INIT', plugin_basename( __FILE__ ) );
! defined( 'YITH_POS_FILE' ) && define( 'YITH_POS_FILE', __FILE__ );
! defined( 'YITH_POS_URL' ) && define( 'YITH_POS_URL', plugins_url( '/', __FILE__ ) );
! defined( 'YITH_POS_DIR' ) && define( 'YITH_POS_DIR', plugin_dir_path( __FILE__ ) );
! defined( 'YITH_POS_ASSETS_URL' ) && define( 'YITH_POS_ASSETS_URL', YITH_POS_URL . 'assets' );
! defined( 'YITH_POS_REACT_URL' ) && define( 'YITH_POS_REACT_URL', YITH_POS_URL . 'dist' );
! defined( 'YITH_POS_ASSETS_PATH' ) && define( 'YITH_POS_ASSETS_PATH', YITH_POS_DIR . 'assets' );
! defined( 'YITH_POS_TEMPLATE_PATH' ) && define( 'YITH_POS_TEMPLATE_PATH', YITH_POS_DIR . 'templates/' );
! defined( 'YITH_POS_LANGUAGES_PATH' ) && define( 'YITH_POS_LANGUAGES_PATH', YITH_POS_DIR . 'languages/' );
! defined( 'YITH_POS_VIEWS_PATH' ) && define( 'YITH_POS_VIEWS_PATH', YITH_POS_DIR . 'views/' );
! defined( 'YITH_POS_INCLUDES_PATH' ) && define( 'YITH_POS_INCLUDES_PATH', YITH_POS_DIR . 'includes/' );
! defined( 'YITH_POS_SLUG' ) && define( 'YITH_POS_SLUG', 'yith-point-of-sale-for-woocommerce' );
! defined( 'YITH_POS_SECRET_KEY' ) && define( 'YITH_POS_SECRET_KEY', 'O7qviMFTu56qJiHvjPyS' );
! defined( 'YITH_POS_PLUGIN_NAME' ) && define( 'YITH_POS_PLUGIN_NAME', 'YITH Point of Sale for WooCommerce' );
if ( ! defined( 'YITH_POS_COOKIEHASH' ) ) {
	$site_url = get_site_option( 'siteurl' );
	$hash     = ! ! $site_url ? md5( $site_url ) : '';
	define( 'YITH_POS_COOKIEHASH', defined( 'COOKIEHASH' ) ? COOKIEHASH : $hash );
}
! defined( 'YITH_POS_REGISTER_COOKIE' ) && define( 'YITH_POS_REGISTER_COOKIE', 'yith_pos_register_' . YITH_POS_COOKIEHASH );

require_once YITH_POS_INCLUDES_PATH . 'class.yith-pos-post-types.php';
require_once YITH_POS_INCLUDES_PATH . 'functions.yith-pos.php';
register_activation_hook( __FILE__, array( 'YITH_POS_Post_Types', 'handle_roles_and_capabilities' ) );
register_activation_hook( __FILE__, array( 'YITH_POS_Post_Types', 'create_default_receipt' ) );

if ( ! function_exists( 'yith_pos_install' ) ) {
	/**
	 * Check WC installation
	 *
	 */
	function yith_pos_install() {
		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_pos_install_woocommerce_admin_notice' );
		} else {
			do_action( 'yith_pos_init' );
		}
	}
}
add_action( 'plugins_loaded', 'yith_pos_install', 11 );

if ( ! function_exists( 'yith_pos_init' ) ) {
	/**
	 * Let's start the game
	 *
	 */
	function yith_pos_init() {
		if ( function_exists( 'yith_plugin_fw_load_plugin_textdomain' ) ) {
			yith_plugin_fw_load_plugin_textdomain( 'yith-point-of-sale-for-woocommerce', basename( dirname( __FILE__ ) ) . '/languages' );
		}

		require_once YITH_POS_INCLUDES_PATH . 'traits/trait-yith-pos-singleton.php';
		require_once YITH_POS_INCLUDES_PATH . 'class.yith-pos.php';

		// Let's start the game!
		yith_pos();
	}
}
add_action( 'yith_pos_init', 'yith_pos_init' );


// Plugin Framework Loader.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}
