<?php
/**
 * Common plugin functions
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH Easy Login & Register Popup For WooCommerce
 * @version 1.0.0
 */

defined( 'YITH_WELRP' ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'yith_welrp_update_popup_colors_option' ) ) {

	function yith_welrp_update_popup_colors_option() {

		$updated = get_option( 'yith_welrp_popup_colors_updated', 'no' );
		if ( 'no' === $updated ) {
			$old_popup_bg      = get_option( 'yith_welrp_popup_bg' );
			$old_popup_head    = get_option( 'yith_welrp_popup_header_bg' );
			$old_popup_text    = get_option( 'yith_welrp_popup_text_color' );
			$old_popup_overlay = get_option( 'yith_welrp_overlay_color' );

			$new_option = array(
				'background' => $old_popup_bg !== false ? $old_popup_bg : '#fff',
				'header'     => $old_popup_head !== false ? $old_popup_head : YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_popup_colors[header]', '#ffffff' ),
				'text'       => $old_popup_text !== false ? $old_popup_text : YITH_Easy_Login_Register::get_proteo_default( 'yith_welrp_popup_colors[text]', '#1a1a1a' ),
				'overlay'    => $old_popup_overlay !== false ? $old_popup_overlay : 'rgba(0,0,0,0.5)'
			);

			update_option( 'yith_welrp_popup_colors', $new_option );
			update_option( 'yith_welrp_popup_colors_updated', 'yes' );
		}
	}
}

add_action( 'admin_init', 'yith_welrp_update_popup_colors_option', 20 );