<?php defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'WP_Sheet_Editor_Columns_Renaming' ) ) {

	/**
	 * Rename the columns of the spreadsheet editor to something more meaningful.
	 */
	class WP_Sheet_Editor_Columns_Renaming {

		private static $instance = false;

		private function __construct() {
		}

		/**
		 * Creates or returns an instance of this class.
		 */
		static function get_instance() {
			if ( null == WP_Sheet_Editor_Columns_Renaming::$instance ) {
				WP_Sheet_Editor_Columns_Renaming::$instance = new WP_Sheet_Editor_Columns_Renaming();
				WP_Sheet_Editor_Columns_Renaming::$instance->init();
			}
			return WP_Sheet_Editor_Columns_Renaming::$instance;
		}

		function init() {
			// Priority 15 so the custom names are applied to the columns after the other filters applied their default names.
			add_filter( 'vg_sheet_editor/columns/all_items', array( $this, 'filter_columns_for_rename' ), 15 );
			add_action( 'vg_sheet_editor/columns_visibility/enabled/after_column_action_alpine', array( $this, 'render_rename_button' ) );
			add_action( 'vg_sheet_editor/after_enqueue_assets', array( $this, 'enqueue_assets' ) );
			add_action( 'wp_ajax_vgse_rename_column', array( $this, 'rename_column' ) );
		}

		/**
		 * Enqueue frontend assets
		 */
		function enqueue_assets() {
			wp_enqueue_script( 'wp-sheet-editor-columns-renaming', plugins_url( '/assets/js/init.js', __FILE__ ), array(), filemtime( __DIR__ . '/assets/js/init.js' ), true );
		}

		function render_rename_button() {
			if ( ! VGSE()->helpers->user_can_manage_options() ) {
				return;
			}
			?>
			<template x-if="column.allow_to_rename">
				<button class="rename-column column-action" title="<?php echo esc_attr( __( 'Rename column', 'vg_sheet_editor' ) ); ?>"><i class="fa fa-edit"></i></button>
			</template>
			<?php
		}

		function __set( $name, $value ) {
			$this->$name = $value;
		}

		function __get( $name ) {
			return $this->$name;
		}

		function rename_column() {
			if ( empty( $_REQUEST['post_type'] ) || empty( $_REQUEST['column_key'] ) || empty( $_REQUEST['new_title'] ) ) {
				wp_send_json_error( array( 'message' => esc_html__( 'Missing parameters.', 'vg_sheet_editor' ) ) );
			}

			if ( ! VGSE()->helpers->verify_nonce_from_request() || ! VGSE()->helpers->user_can_manage_options() ) {
				wp_send_json_error( array( 'message' => esc_html__( 'You dont have enough permissions to execute this action.', 'vg_sheet_editor' ) ) );
			}
			$post_type  = VGSE()->helpers->sanitize_table_key( wp_unslash( $_REQUEST['post_type'] ) );
			$column_key = sanitize_text_field( wp_unslash( $_REQUEST['column_key'] ) );
			$new_title  = sanitize_text_field( wp_unslash( $_REQUEST['new_title'] ) );

			$option_key = ( taxonomy_exists( $column_key ) ) ? 'be_tax_txt_' . $column_key . '_' . $post_type : 'be_' . $column_key . '_txt_' . $post_type;

			VGSE()->update_option( $option_key, $new_title );
			wp_send_json_success();
		}

		/**
		 * Rename columns
		 * @param array $columns
		 * @return array
		 */
		function filter_columns_for_rename( $columns ) {
			$options = VGSE()->options;

			if ( empty( $options ) ) {
				return $columns;
			}
			foreach ( $columns as $post_type_key => $post_type_columns ) {
				foreach ( $post_type_columns as $key => $column ) {
					if ( $column['allow_to_rename'] ) {
						if ( isset( $options[ 'be_' . $key . '_txt_' . $post_type_key ] ) && $options[ 'be_' . $key . '_txt_' . $post_type_key ] ) {
							$columns[ $post_type_key ][ $key ]['title'] = $options[ 'be_' . $key . '_txt_' . $post_type_key ];
						} elseif ( isset( $options[ 'be_tax_txt_' . $key . '_' . $post_type_key ] ) && $options[ 'be_tax_txt_' . $key . '_' . $post_type_key ] ) {

							$columns[ $post_type_key ][ $key ]['title'] = $options[ 'be_tax_txt_' . $key . '_' . $post_type_key ];
						}
					}
				}
			}

			return $columns;
		}

	}

	add_action( 'vg_sheet_editor/initialized', 'vgse_columns_renaming_init' );

	function vgse_columns_renaming_init() {
		WP_Sheet_Editor_Columns_Renaming::get_instance();
	}

}
