<?php

if ( ! class_exists( 'WPSE_AI_Teaser' ) ) {

	class WPSE_AI_Teaser {

		private static $instance = null;

		private function __construct() {
		}

		public function init() {
			if ( class_exists( 'WP_Sheet_Editor_AI_Core' ) ) {
				return;
			}
			add_action( 'vg_sheet_editor/editor/before_init', array( $this, 'register_toolbar' ), 20 );
		}
		public function register_toolbar( $editor ) {
			$post_types = $editor->args['enabled_post_types'];
			foreach ( $post_types as $post_type ) {
				$editor->args['toolbars']->register_item(
					'ai',
					array(
						'type'                  => 'button',
						'content'               => esc_html__( 'AI', 'vg_sheet_editor' ),
						'icon'                  => 'fa fa-bolt',
						'extra_html_attributes' => 'data-remodal-target="modal-ai"',
						'footer_callback'       => array( $this, 'render_ai_modal' ),
						'allow_in_frontend'     => false,
					),
					$post_type
				);
			}
		}

		public function render_ai_modal( $post_type ) {
			?>
			<div class="remodal modal-ai remodal-draggable" data-remodal-id="modal-ai" data-remodal-options="closeOnOutsideClick: false">

			<div class="modal-content">
					<h3><?php esc_html_e( 'Recommended addon: Artificial Intelligence in WordPress', 'vg_sheet_editor' ); ?></h3>
					<p><?php esc_html_e( 'This addon allows you to manage your content in bulk using Artificial Intelligence. We\'re compatible with all the popular AI providers, including ChatGPT, Claude, Grok, Google Gemini, OpenRouter, Perplexity, and more.', 'vg_sheet_editor' ); ?></p>
					<h3><?php esc_html_e( 'Our AI functionality will blow your mind', 'vg_sheet_editor' ); ?></h3>
					<ol>
						<li><?php esc_html_e( 'Use AI when you edit in the cells to generate values or edit existing values. Just enter the shortcut "ai:prompt here"', 'vg_sheet_editor' ); ?></li>
						<li><?php esc_html_e( 'You can use AI prompts when you run bulk edits, so the AI model can edit or generate content for thousands of items at once', 'vg_sheet_editor' ); ?></li>
						<li><?php esc_html_e( 'You can use AI to generate full posts, products, or any item. You can select which columns are auto generated by the AI and set default values for other columns.', 'vg_sheet_editor' ); ?></li>
						<li><?php esc_html_e( 'You can generate images with AI in the cells or in bulk.', 'vg_sheet_editor' ); ?></li>
						<li><?php esc_html_e( 'You can chat with the AI using our chat playground.', 'vg_sheet_editor' ); ?></li>
						<li><?php esc_html_e( 'You can save a gallery of prompts and use those prompts as shortcuts in the cells or bulk edits', 'vg_sheet_editor' ); ?></li>
					</ol>
					<p><?php esc_html_e( 'The AI can be used on all our spreadsheet editors, so you can manage all types of content (posts, pages, products, user profiles, media library, taxonomies, custom post types, custom database tables etc), and it works on all our editable columns (edit ACF/JetEngine/Metabox/custom fields using AI).', 'vg_sheet_editor' ); ?></p>
					<p><?php esc_html_e( 'The possibilities are endless. You can use an AI model with web search capabilities to generate content for your posts, auto fill your directory listings, perform research for your content, improve your content, auto generate SEO title and meta descriptions, translate thousands of product descriptions with one bulk edit, and more.', 'vg_sheet_editor' ); ?></p>

					<a class="remodal-confirm" target="_blank" href="https://wpsheeteditor.com/go/ai-toolbar"><?php esc_html_e( 'I\'m interested in the AI addon', 'vg_sheet_editor' ); ?></a>
					<button data-remodal-action="confirm" class="remodal-cancel"><?php esc_html_e( 'Close', 'vg_sheet_editor' ); ?></button>
			</div>
			<br>
			</div>

			<?php
		}

		/**
		 * Creates or returns an instance of this class.
		 */
		public static function get_instance() {
			if ( null === WPSE_AI_Teaser::$instance ) {
				WPSE_AI_Teaser::$instance = new WPSE_AI_Teaser();
				WPSE_AI_Teaser::$instance->init();
			}
			return WPSE_AI_Teaser::$instance;
		}

		public function __set( $name, $value ) {
			$this->name = $value;
		}

		public function __get( $name ) {
			return $this->name;
		}

	}
}

if ( ! function_exists( 'WPSE_AI_Teaser_Obj' ) ) {
	/**
	 * @return WPSE_AI_Teaser
	 */
	function WPSE_AI_Teaser_Obj() {
		return WPSE_AI_Teaser::get_instance();
	}
}
add_action( 'vg_sheet_editor/initialized', 'WPSE_AI_Teaser_Obj' );
