<?php
/**
 * AutomotivePartsCompatibilityPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Metadata API
 *
 * The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.
 *
 * OpenAPI spec version: v1.8.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.63
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * AutomotivePartsCompatibilityPolicy Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AutomotivePartsCompatibilityPolicy implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'AutomotivePartsCompatibilityPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'category_id' => 'string',
        'category_tree_id' => 'string',
        'compatibility_based_on' => 'string',
        'compatible_vehicle_types' => 'string[]',
        'max_number_of_compatible_vehicles' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'category_id' => null,
        'category_tree_id' => null,
        'compatibility_based_on' => null,
        'compatible_vehicle_types' => null,
        'max_number_of_compatible_vehicles' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'category_id' => 'categoryId',
        'category_tree_id' => 'categoryTreeId',
        'compatibility_based_on' => 'compatibilityBasedOn',
        'compatible_vehicle_types' => 'compatibleVehicleTypes',
        'max_number_of_compatible_vehicles' => 'maxNumberOfCompatibleVehicles'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'category_id' => 'setCategoryId',
        'category_tree_id' => 'setCategoryTreeId',
        'compatibility_based_on' => 'setCompatibilityBasedOn',
        'compatible_vehicle_types' => 'setCompatibleVehicleTypes',
        'max_number_of_compatible_vehicles' => 'setMaxNumberOfCompatibleVehicles'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'category_id' => 'getCategoryId',
        'category_tree_id' => 'getCategoryTreeId',
        'compatibility_based_on' => 'getCompatibilityBasedOn',
        'compatible_vehicle_types' => 'getCompatibleVehicleTypes',
        'max_number_of_compatible_vehicles' => 'getMaxNumberOfCompatibleVehicles'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['category_id'] = isset($data['category_id']) ? $data['category_id'] : null;
        $this->container['category_tree_id'] = isset($data['category_tree_id']) ? $data['category_tree_id'] : null;
        $this->container['compatibility_based_on'] = isset($data['compatibility_based_on']) ? $data['compatibility_based_on'] : null;
        $this->container['compatible_vehicle_types'] = isset($data['compatible_vehicle_types']) ? $data['compatible_vehicle_types'] : null;
        $this->container['max_number_of_compatible_vehicles'] = isset($data['max_number_of_compatible_vehicles']) ? $data['max_number_of_compatible_vehicles'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets category_id
     *
     * @return string
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param string $category_id The category ID to which the automotive-parts-compatibility policies apply.
     *
     * @return $this
     */
    public function setCategoryId($category_id)
    {
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets category_tree_id
     *
     * @return string
     */
    public function getCategoryTreeId()
    {
        return $this->container['category_tree_id'];
    }

    /**
     * Sets category_tree_id
     *
     * @param string $category_tree_id A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree.    <br><br>A <i>category tree</i> is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique <b>categoryId</b> value. Within a category tree, the root node has no parent node and <i>leaf nodes</i> are nodes that have no child nodes.
     *
     * @return $this
     */
    public function setCategoryTreeId($category_tree_id)
    {
        $this->container['category_tree_id'] = $category_tree_id;

        return $this;
    }

    /**
     * Gets compatibility_based_on
     *
     * @return string
     */
    public function getCompatibilityBasedOn()
    {
        return $this->container['compatibility_based_on'];
    }

    /**
     * Sets compatibility_based_on
     *
     * @param string $compatibility_based_on Indicates whether the category supports parts compatibility by either <code>ASSEMBLY</code> or by <code>SPECIFICATION</code>. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/metadata/types/sel:CompatibilityTypeEnum'>eBay API documentation</a>
     *
     * @return $this
     */
    public function setCompatibilityBasedOn($compatibility_based_on)
    {
        $this->container['compatibility_based_on'] = $compatibility_based_on;

        return $this;
    }

    /**
     * Gets compatible_vehicle_types
     *
     * @return string[]
     */
    public function getCompatibleVehicleTypes()
    {
        return $this->container['compatible_vehicle_types'];
    }

    /**
     * Sets compatible_vehicle_types
     *
     * @param string[] $compatible_vehicle_types Indicates the compatibility classification of the part based on high-level vehicle types.
     *
     * @return $this
     */
    public function setCompatibleVehicleTypes($compatible_vehicle_types)
    {
        $this->container['compatible_vehicle_types'] = $compatible_vehicle_types;

        return $this;
    }

    /**
     * Gets max_number_of_compatible_vehicles
     *
     * @return int
     */
    public function getMaxNumberOfCompatibleVehicles()
    {
        return $this->container['max_number_of_compatible_vehicles'];
    }

    /**
     * Sets max_number_of_compatible_vehicles
     *
     * @param int $max_number_of_compatible_vehicles Specifies the maximum number of compatible vehicle-applications allowed per item.
     *
     * @return $this
     */
    public function setMaxNumberOfCompatibleVehicles($max_number_of_compatible_vehicles)
    {
        $this->container['max_number_of_compatible_vehicles'] = $max_number_of_compatible_vehicles;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
