<?php
/**
 * ItemConditionDescriptor
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Metadata API
 *
 * The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.
 *
 * OpenAPI spec version: v1.8.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.63
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * ItemConditionDescriptor Class Doc Comment
 *
 * @category Class
 * @description This type is used to display the possible condition descriptors and condition values applicable for a specified category. It also returns usage requirements, maximum length, cardinality, and help text.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ItemConditionDescriptor implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ItemConditionDescriptor';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'condition_descriptor_constraint' => '\Swagger\Client\Model\ItemConditionDescriptorConstraint',
        'condition_descriptor_help_text' => 'string',
        'condition_descriptor_id' => 'string',
        'condition_descriptor_name' => 'string',
        'condition_descriptor_values' => '\Swagger\Client\Model\ItemConditionDescriptorValue[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'condition_descriptor_constraint' => null,
        'condition_descriptor_help_text' => null,
        'condition_descriptor_id' => null,
        'condition_descriptor_name' => null,
        'condition_descriptor_values' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'condition_descriptor_constraint' => 'conditionDescriptorConstraint',
        'condition_descriptor_help_text' => 'conditionDescriptorHelpText',
        'condition_descriptor_id' => 'conditionDescriptorId',
        'condition_descriptor_name' => 'conditionDescriptorName',
        'condition_descriptor_values' => 'conditionDescriptorValues'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'condition_descriptor_constraint' => 'setConditionDescriptorConstraint',
        'condition_descriptor_help_text' => 'setConditionDescriptorHelpText',
        'condition_descriptor_id' => 'setConditionDescriptorId',
        'condition_descriptor_name' => 'setConditionDescriptorName',
        'condition_descriptor_values' => 'setConditionDescriptorValues'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'condition_descriptor_constraint' => 'getConditionDescriptorConstraint',
        'condition_descriptor_help_text' => 'getConditionDescriptorHelpText',
        'condition_descriptor_id' => 'getConditionDescriptorId',
        'condition_descriptor_name' => 'getConditionDescriptorName',
        'condition_descriptor_values' => 'getConditionDescriptorValues'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['condition_descriptor_constraint'] = isset($data['condition_descriptor_constraint']) ? $data['condition_descriptor_constraint'] : null;
        $this->container['condition_descriptor_help_text'] = isset($data['condition_descriptor_help_text']) ? $data['condition_descriptor_help_text'] : null;
        $this->container['condition_descriptor_id'] = isset($data['condition_descriptor_id']) ? $data['condition_descriptor_id'] : null;
        $this->container['condition_descriptor_name'] = isset($data['condition_descriptor_name']) ? $data['condition_descriptor_name'] : null;
        $this->container['condition_descriptor_values'] = isset($data['condition_descriptor_values']) ? $data['condition_descriptor_values'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets condition_descriptor_constraint
     *
     * @return \Swagger\Client\Model\ItemConditionDescriptorConstraint
     */
    public function getConditionDescriptorConstraint()
    {
        return $this->container['condition_descriptor_constraint'];
    }

    /**
     * Sets condition_descriptor_constraint
     *
     * @param \Swagger\Client\Model\ItemConditionDescriptorConstraint $condition_descriptor_constraint condition_descriptor_constraint
     *
     * @return $this
     */
    public function setConditionDescriptorConstraint($condition_descriptor_constraint)
    {
        $this->container['condition_descriptor_constraint'] = $condition_descriptor_constraint;

        return $this;
    }

    /**
     * Gets condition_descriptor_help_text
     *
     * @return string
     */
    public function getConditionDescriptorHelpText()
    {
        return $this->container['condition_descriptor_help_text'];
    }

    /**
     * Sets condition_descriptor_help_text
     *
     * @param string $condition_descriptor_help_text A description of the condition descriptor that directs a user to its condition descriptor values.<br><br> For example, the help text for <code>Card Condition</code> is <code>Select ungraded condition</code>.
     *
     * @return $this
     */
    public function setConditionDescriptorHelpText($condition_descriptor_help_text)
    {
        $this->container['condition_descriptor_help_text'] = $condition_descriptor_help_text;

        return $this;
    }

    /**
     * Gets condition_descriptor_id
     *
     * @return string
     */
    public function getConditionDescriptorId()
    {
        return $this->container['condition_descriptor_id'];
    }

    /**
     * Sets condition_descriptor_id
     *
     * @param string $condition_descriptor_id The unique identification number of a condition descriptor associated with with a <b>conditionDescriptorName</b>. <br><br>For example, <code>40001</code> is the ID for <code>Card Condition</code>.<br><br>These IDs are used in the addItem family of calls of the <b>Trading API</b> to provide condition descriptor names for the item. These IDs are used by the inventoryItem family of calls of the <b>Inventory API</b> to provide condition descriptor names for the item.
     *
     * @return $this
     */
    public function setConditionDescriptorId($condition_descriptor_id)
    {
        $this->container['condition_descriptor_id'] = $condition_descriptor_id;

        return $this;
    }

    /**
     * Gets condition_descriptor_name
     *
     * @return string
     */
    public function getConditionDescriptorName()
    {
        return $this->container['condition_descriptor_name'];
    }

    /**
     * Sets condition_descriptor_name
     *
     * @param string $condition_descriptor_name The human-readable label for the condition descriptor associated with the <b>conditionDescriptorID</b>. <br><br>For example, <code>Card Condition</code> is the condition descriptor name for ID <code>40001</code>
     *
     * @return $this
     */
    public function setConditionDescriptorName($condition_descriptor_name)
    {
        $this->container['condition_descriptor_name'] = $condition_descriptor_name;

        return $this;
    }

    /**
     * Gets condition_descriptor_values
     *
     * @return \Swagger\Client\Model\ItemConditionDescriptorValue[]
     */
    public function getConditionDescriptorValues()
    {
        return $this->container['condition_descriptor_values'];
    }

    /**
     * Sets condition_descriptor_values
     *
     * @param \Swagger\Client\Model\ItemConditionDescriptorValue[] $condition_descriptor_values This array shows the possible values that map to the corresponding <b>conditionDescriptorName</b> values. Constraint information and help text are also shown for each value. <br><br>For example, The ID <code>40001</code> is ID for the condition descriptor <code>card condition</code>. The ID <code>400012</code> is the ID for the <code>Very Good</code> card condition value.
     *
     * @return $this
     */
    public function setConditionDescriptorValues($condition_descriptor_values)
    {
        $this->container['condition_descriptor_values'] = $condition_descriptor_values;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
