<?php
/**
 * ItemConditionDescriptorConstraint
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Metadata API
 *
 * The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.
 *
 * OpenAPI spec version: v1.8.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.63
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * ItemConditionDescriptorConstraint Class Doc Comment
 *
 * @category Class
 * @description This type specifies the constraints on a condition descriptor, such as the maximum length, default condition descriptor value ID, cardinality, mode, usage, and applicable descriptor IDs.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ItemConditionDescriptorConstraint implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ItemConditionDescriptorConstraint';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'applicable_to_condition_descriptor_ids' => 'string[]',
        'cardinality' => 'string',
        'default_condition_descriptor_value_id' => 'string',
        'max_length' => 'int',
        'mode' => 'string',
        'usage' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'applicable_to_condition_descriptor_ids' => null,
        'cardinality' => null,
        'default_condition_descriptor_value_id' => null,
        'max_length' => 'int32',
        'mode' => null,
        'usage' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'applicable_to_condition_descriptor_ids' => 'applicableToConditionDescriptorIds',
        'cardinality' => 'cardinality',
        'default_condition_descriptor_value_id' => 'defaultConditionDescriptorValueId',
        'max_length' => 'maxLength',
        'mode' => 'mode',
        'usage' => 'usage'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'applicable_to_condition_descriptor_ids' => 'setApplicableToConditionDescriptorIds',
        'cardinality' => 'setCardinality',
        'default_condition_descriptor_value_id' => 'setDefaultConditionDescriptorValueId',
        'max_length' => 'setMaxLength',
        'mode' => 'setMode',
        'usage' => 'setUsage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'applicable_to_condition_descriptor_ids' => 'getApplicableToConditionDescriptorIds',
        'cardinality' => 'getCardinality',
        'default_condition_descriptor_value_id' => 'getDefaultConditionDescriptorValueId',
        'max_length' => 'getMaxLength',
        'mode' => 'getMode',
        'usage' => 'getUsage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['applicable_to_condition_descriptor_ids'] = isset($data['applicable_to_condition_descriptor_ids']) ? $data['applicable_to_condition_descriptor_ids'] : null;
        $this->container['cardinality'] = isset($data['cardinality']) ? $data['cardinality'] : null;
        $this->container['default_condition_descriptor_value_id'] = isset($data['default_condition_descriptor_value_id']) ? $data['default_condition_descriptor_value_id'] : null;
        $this->container['max_length'] = isset($data['max_length']) ? $data['max_length'] : null;
        $this->container['mode'] = isset($data['mode']) ? $data['mode'] : null;
        $this->container['usage'] = isset($data['usage']) ? $data['usage'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets applicable_to_condition_descriptor_ids
     *
     * @return string[]
     */
    public function getApplicableToConditionDescriptorIds()
    {
        return $this->container['applicable_to_condition_descriptor_ids'];
    }

    /**
     * Sets applicable_to_condition_descriptor_ids
     *
     * @param string[] $applicable_to_condition_descriptor_ids This array is returned if the corresponding condition descriptor requires that one or more other associated condition descriptors must also be specified in a listing. The condition descriptor IDs for the associated condition descriptors are returned here.<br><br>For example, the <code>Grade</code> and <code>Grader</code> condition descriptors must always be specified together in a listing for Graded cards.
     *
     * @return $this
     */
    public function setApplicableToConditionDescriptorIds($applicable_to_condition_descriptor_ids)
    {
        $this->container['applicable_to_condition_descriptor_ids'] = $applicable_to_condition_descriptor_ids;

        return $this;
    }

    /**
     * Gets cardinality
     *
     * @return string
     */
    public function getCardinality()
    {
        return $this->container['cardinality'];
    }

    /**
     * Sets cardinality
     *
     * @param string $cardinality The value returned in this field indicates whether a condition descriptor can have a single value or multiple values. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/metadata/types/sel:CardinalityEnum'>eBay API documentation</a>
     *
     * @return $this
     */
    public function setCardinality($cardinality)
    {
        $this->container['cardinality'] = $cardinality;

        return $this;
    }

    /**
     * Gets default_condition_descriptor_value_id
     *
     * @return string
     */
    public function getDefaultConditionDescriptorValueId()
    {
        return $this->container['default_condition_descriptor_value_id'];
    }

    /**
     * Sets default_condition_descriptor_value_id
     *
     * @param string $default_condition_descriptor_value_id The default condition descriptor value that will be set if there are multiple values.
     *
     * @return $this
     */
    public function setDefaultConditionDescriptorValueId($default_condition_descriptor_value_id)
    {
        $this->container['default_condition_descriptor_value_id'] = $default_condition_descriptor_value_id;

        return $this;
    }

    /**
     * Gets max_length
     *
     * @return int
     */
    public function getMaxLength()
    {
        return $this->container['max_length'];
    }

    /**
     * Sets max_length
     *
     * @param int $max_length The maximum characters allowed for a condition descriptor. This field is only returned/applicable for condition descriptors that allow free text for condition descriptor values.
     *
     * @return $this
     */
    public function setMaxLength($max_length)
    {
        $this->container['max_length'] = $max_length;

        return $this;
    }

    /**
     * Gets mode
     *
     * @return string
     */
    public function getMode()
    {
        return $this->container['mode'];
    }

    /**
     * Sets mode
     *
     * @param string $mode The value returned in this field indicates whether the supported values for a condition descriptor are predefined or if the seller manually specified the value.<br><br><span class=\"tablenote\"><b>Note:</b> <code>FREE_TEXT</code> is currently only applicable to the Certification Number condition descriptor.</span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/metadata/types/sel:ModeEnum'>eBay API documentation</a>
     *
     * @return $this
     */
    public function setMode($mode)
    {
        $this->container['mode'] = $mode;

        return $this;
    }

    /**
     * Gets usage
     *
     * @return string
     */
    public function getUsage()
    {
        return $this->container['usage'];
    }

    /**
     * Sets usage
     *
     * @param string $usage This value indicates whether or not the condition descriptor is required for the item condition. Currently, this field is only returned if the condition descriptor is required for the item condition. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/metadata/types/sel:DescriptorUsageEnum'>eBay API documentation</a>
     *
     * @return $this
     */
    public function setUsage($usage)
    {
        $this->container['usage'] = $usage;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
