<?php
/**
 * ItemConditionDescriptorValue
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Metadata API
 *
 * The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.
 *
 * OpenAPI spec version: v1.8.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.63
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * ItemConditionDescriptorValue Class Doc Comment
 *
 * @category Class
 * @description This type displays the possible values for the corresponding condition descriptor, along with help text and constraint information.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ItemConditionDescriptorValue implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ItemConditionDescriptorValue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'condition_descriptor_value_additional_help_text' => 'string[]',
        'condition_descriptor_value_constraints' => '\Swagger\Client\Model\ItemConditionDescriptorValueConstraint[]',
        'condition_descriptor_value_help_text' => 'string',
        'condition_descriptor_value_id' => 'string',
        'condition_descriptor_value_name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'condition_descriptor_value_additional_help_text' => null,
        'condition_descriptor_value_constraints' => null,
        'condition_descriptor_value_help_text' => null,
        'condition_descriptor_value_id' => null,
        'condition_descriptor_value_name' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'condition_descriptor_value_additional_help_text' => 'conditionDescriptorValueAdditionalHelpText',
        'condition_descriptor_value_constraints' => 'conditionDescriptorValueConstraints',
        'condition_descriptor_value_help_text' => 'conditionDescriptorValueHelpText',
        'condition_descriptor_value_id' => 'conditionDescriptorValueId',
        'condition_descriptor_value_name' => 'conditionDescriptorValueName'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'condition_descriptor_value_additional_help_text' => 'setConditionDescriptorValueAdditionalHelpText',
        'condition_descriptor_value_constraints' => 'setConditionDescriptorValueConstraints',
        'condition_descriptor_value_help_text' => 'setConditionDescriptorValueHelpText',
        'condition_descriptor_value_id' => 'setConditionDescriptorValueId',
        'condition_descriptor_value_name' => 'setConditionDescriptorValueName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'condition_descriptor_value_additional_help_text' => 'getConditionDescriptorValueAdditionalHelpText',
        'condition_descriptor_value_constraints' => 'getConditionDescriptorValueConstraints',
        'condition_descriptor_value_help_text' => 'getConditionDescriptorValueHelpText',
        'condition_descriptor_value_id' => 'getConditionDescriptorValueId',
        'condition_descriptor_value_name' => 'getConditionDescriptorValueName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['condition_descriptor_value_additional_help_text'] = isset($data['condition_descriptor_value_additional_help_text']) ? $data['condition_descriptor_value_additional_help_text'] : null;
        $this->container['condition_descriptor_value_constraints'] = isset($data['condition_descriptor_value_constraints']) ? $data['condition_descriptor_value_constraints'] : null;
        $this->container['condition_descriptor_value_help_text'] = isset($data['condition_descriptor_value_help_text']) ? $data['condition_descriptor_value_help_text'] : null;
        $this->container['condition_descriptor_value_id'] = isset($data['condition_descriptor_value_id']) ? $data['condition_descriptor_value_id'] : null;
        $this->container['condition_descriptor_value_name'] = isset($data['condition_descriptor_value_name']) ? $data['condition_descriptor_value_name'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets condition_descriptor_value_additional_help_text
     *
     * @return string[]
     */
    public function getConditionDescriptorValueAdditionalHelpText()
    {
        return $this->container['condition_descriptor_value_additional_help_text'];
    }

    /**
     * Sets condition_descriptor_value_additional_help_text
     *
     * @param string[] $condition_descriptor_value_additional_help_text Additional information about the the condition of the item that is not included in the <b>conditionDescriptorValueHelpText</b> field.
     *
     * @return $this
     */
    public function setConditionDescriptorValueAdditionalHelpText($condition_descriptor_value_additional_help_text)
    {
        $this->container['condition_descriptor_value_additional_help_text'] = $condition_descriptor_value_additional_help_text;

        return $this;
    }

    /**
     * Gets condition_descriptor_value_constraints
     *
     * @return \Swagger\Client\Model\ItemConditionDescriptorValueConstraint[]
     */
    public function getConditionDescriptorValueConstraints()
    {
        return $this->container['condition_descriptor_value_constraints'];
    }

    /**
     * Sets condition_descriptor_value_constraints
     *
     * @param \Swagger\Client\Model\ItemConditionDescriptorValueConstraint[] $condition_descriptor_value_constraints The constraints on a condition descriptor value, such as which descriptor value IDs and Descriptor ID it is associated with.
     *
     * @return $this
     */
    public function setConditionDescriptorValueConstraints($condition_descriptor_value_constraints)
    {
        $this->container['condition_descriptor_value_constraints'] = $condition_descriptor_value_constraints;

        return $this;
    }

    /**
     * Gets condition_descriptor_value_help_text
     *
     * @return string
     */
    public function getConditionDescriptorValueHelpText()
    {
        return $this->container['condition_descriptor_value_help_text'];
    }

    /**
     * Sets condition_descriptor_value_help_text
     *
     * @param string $condition_descriptor_value_help_text A detailed description of the condition descriptor value.
     *
     * @return $this
     */
    public function setConditionDescriptorValueHelpText($condition_descriptor_value_help_text)
    {
        $this->container['condition_descriptor_value_help_text'] = $condition_descriptor_value_help_text;

        return $this;
    }

    /**
     * Gets condition_descriptor_value_id
     *
     * @return string
     */
    public function getConditionDescriptorValueId()
    {
        return $this->container['condition_descriptor_value_id'];
    }

    /**
     * Sets condition_descriptor_value_id
     *
     * @param string $condition_descriptor_value_id The unique identification number of a condition descriptor value associated with the <b>conditionDescriptorValueName</b>.
     *
     * @return $this
     */
    public function setConditionDescriptorValueId($condition_descriptor_value_id)
    {
        $this->container['condition_descriptor_value_id'] = $condition_descriptor_value_id;

        return $this;
    }

    /**
     * Gets condition_descriptor_value_name
     *
     * @return string
     */
    public function getConditionDescriptorValueName()
    {
        return $this->container['condition_descriptor_value_name'];
    }

    /**
     * Sets condition_descriptor_value_name
     *
     * @param string $condition_descriptor_value_name The human-readable label for the condition descriptor value associated with the <b>conditionDescriptorValueID</b>.
     *
     * @return $this
     */
    public function setConditionDescriptorValueName($condition_descriptor_value_name)
    {
        $this->container['condition_descriptor_value_name'] = $condition_descriptor_value_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
