<?php
/**
 * NegotiatedPricePolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Metadata API
 *
 * The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.
 *
 * OpenAPI spec version: v1.8.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.63
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * NegotiatedPricePolicy Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class NegotiatedPricePolicy implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'NegotiatedPricePolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'best_offer_auto_accept_enabled' => 'bool',
        'best_offer_auto_decline_enabled' => 'bool',
        'best_offer_counter_enabled' => 'bool',
        'category_id' => 'string',
        'category_tree_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'best_offer_auto_accept_enabled' => null,
        'best_offer_auto_decline_enabled' => null,
        'best_offer_counter_enabled' => null,
        'category_id' => null,
        'category_tree_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'best_offer_auto_accept_enabled' => 'bestOfferAutoAcceptEnabled',
        'best_offer_auto_decline_enabled' => 'bestOfferAutoDeclineEnabled',
        'best_offer_counter_enabled' => 'bestOfferCounterEnabled',
        'category_id' => 'categoryId',
        'category_tree_id' => 'categoryTreeId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'best_offer_auto_accept_enabled' => 'setBestOfferAutoAcceptEnabled',
        'best_offer_auto_decline_enabled' => 'setBestOfferAutoDeclineEnabled',
        'best_offer_counter_enabled' => 'setBestOfferCounterEnabled',
        'category_id' => 'setCategoryId',
        'category_tree_id' => 'setCategoryTreeId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'best_offer_auto_accept_enabled' => 'getBestOfferAutoAcceptEnabled',
        'best_offer_auto_decline_enabled' => 'getBestOfferAutoDeclineEnabled',
        'best_offer_counter_enabled' => 'getBestOfferCounterEnabled',
        'category_id' => 'getCategoryId',
        'category_tree_id' => 'getCategoryTreeId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['best_offer_auto_accept_enabled'] = isset($data['best_offer_auto_accept_enabled']) ? $data['best_offer_auto_accept_enabled'] : null;
        $this->container['best_offer_auto_decline_enabled'] = isset($data['best_offer_auto_decline_enabled']) ? $data['best_offer_auto_decline_enabled'] : null;
        $this->container['best_offer_counter_enabled'] = isset($data['best_offer_counter_enabled']) ? $data['best_offer_counter_enabled'] : null;
        $this->container['category_id'] = isset($data['category_id']) ? $data['category_id'] : null;
        $this->container['category_tree_id'] = isset($data['category_tree_id']) ? $data['category_tree_id'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets best_offer_auto_accept_enabled
     *
     * @return bool
     */
    public function getBestOfferAutoAcceptEnabled()
    {
        return $this->container['best_offer_auto_accept_enabled'];
    }

    /**
     * Sets best_offer_auto_accept_enabled
     *
     * @param bool $best_offer_auto_accept_enabled This flag denotes whether or not the category supports the setting of a price at which best offers are automatically accepted. If set to <code>true</code>, the category does support the setting of an automatic price for best-offers.
     *
     * @return $this
     */
    public function setBestOfferAutoAcceptEnabled($best_offer_auto_accept_enabled)
    {
        $this->container['best_offer_auto_accept_enabled'] = $best_offer_auto_accept_enabled;

        return $this;
    }

    /**
     * Gets best_offer_auto_decline_enabled
     *
     * @return bool
     */
    public function getBestOfferAutoDeclineEnabled()
    {
        return $this->container['best_offer_auto_decline_enabled'];
    }

    /**
     * Sets best_offer_auto_decline_enabled
     *
     * @param bool $best_offer_auto_decline_enabled This flag denotes whether or not the category supports the setting of an auto-decline price for best offers. If set to <code>true</code>, the category does support the setting of an automatic-decline price for best-offers.
     *
     * @return $this
     */
    public function setBestOfferAutoDeclineEnabled($best_offer_auto_decline_enabled)
    {
        $this->container['best_offer_auto_decline_enabled'] = $best_offer_auto_decline_enabled;

        return $this;
    }

    /**
     * Gets best_offer_counter_enabled
     *
     * @return bool
     */
    public function getBestOfferCounterEnabled()
    {
        return $this->container['best_offer_counter_enabled'];
    }

    /**
     * Sets best_offer_counter_enabled
     *
     * @param bool $best_offer_counter_enabled This flag denotes whether or not the category supports the setting for an automatic counter-offer on best offers. If set to <code>true</code>, the category does support the setting of an automatic counter-offer price for best-offers.
     *
     * @return $this
     */
    public function setBestOfferCounterEnabled($best_offer_counter_enabled)
    {
        $this->container['best_offer_counter_enabled'] = $best_offer_counter_enabled;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return string
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param string $category_id The category ID to which the negotiated-price policies apply.
     *
     * @return $this
     */
    public function setCategoryId($category_id)
    {
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets category_tree_id
     *
     * @return string
     */
    public function getCategoryTreeId()
    {
        return $this->container['category_tree_id'];
    }

    /**
     * Sets category_tree_id
     *
     * @param string $category_tree_id A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree.    <br><br>A <i>category tree</i> is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique <b>categoryId</b> value. Within a category tree, the root node has no parent node and <i>leaf nodes</i> are nodes that have no child nodes.
     *
     * @return $this
     */
    public function setCategoryTreeId($category_tree_id)
    {
        $this->container['category_tree_id'] = $category_tree_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
