<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://wpswings.com
 * @since      1.0.0
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/admin
 */
use Automattic\WooCommerce\Utilities\OrderUtil;
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;
/**
 * The admin-specific functionality of the plugin.
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/admin
 * @author     WP Swings <webmaster@wpswings.com>
 */
class Ultimate_Woocommerce_Gift_Card_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	/**
	 * The object of common class file.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $wps_uwgc_settings    The common variable used for classes.
	 */
	private $wps_uwgc_settings;
	/**
	 * The object of common class file.
	 *
	 * @since    1.0.0
	 * @access   public
	 * @var      string    $wps_common_fun    The common variable used for classes.
	 */
	public $wps_common_fun;
	/**
	 * Array ro hold imported templates.
	 *
	 * @param string $plugin_name plugin name.
	 * @param string $version version.
	 *
	 * @since    1.0.0
	 * @access   public
	 * @var      array    $wps_uwgc_array    Hold imported templates.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		require_once WPS_UWGC_DIRPATH . 'admin/partials/templates/wps-uwgc-settings/class-wps-uwgc-setting-html-function.php';
		require_once WPS_UWGC_DIRPATH . 'admin/partials/templates/wps-uwgc-settings/class-wps-uwgc-settings-data.php';
		require_once WPS_UWGC_DIRPATH . 'includes/class-wps-uwgc-giftcard-common-function.php';
		$this->wps_uwgc_settings = new Wps_Uwgc_Settings_Data();

		$this->wps_common_fun = new WPS_UWGC_Giftcard_Common_Function();

		include_once WPS_UWGC_DIRPATH . 'Qrcode/phpqrcode/qrlib.php';
		include_once WPS_UWGC_DIRPATH . 'Qrcode/php-barcode-master/barcode.php';

	}


	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ultimate_Woocommerce_Gift_Card_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ultimate_Woocommerce_Gift_Card_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/ultimate-woocommerce-gift-card-admin.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . 'wps_wgm_jquery-ui-datepicker', plugin_dir_url( __FILE__ ) . 'css/jquery-ui.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ultimate_Woocommerce_Gift_Card_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ultimate_Woocommerce_Gift_Card_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( $this->plugin_name . 'color-picker', plugin_dir_url( __FILE__ ) . 'js/color-script.js', array( 'wp-color-picker' ), $this->version, false );

		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$wps_obj = new Woocommerce_Gift_Cards_Common_Function();
		$selected_date = $wps_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
		$selected_date = $this->wps_common_fun->wps_uwgc_selected_date_format_for_js( $selected_date );

		global $post;
		$post_id = isset( $post->ID ) ? $post->ID : '';

		$wps_wgm = array(
			'ajax_url'        => admin_url( 'admin-ajax.php' ),
			'wps_wgm_nonce'   => wp_create_nonce( 'wps-wgm-verify-nonce' ),
			'dateformat'      => $selected_date,
			'is_customizable' => get_post_meta( $post_id, 'woocommerce_customizable_giftware', true ),
			'is_group_gift'     => get_post_meta( $post_id, 'wps_wgm_is_group_gift', true ),
			'is_expiry_product' => ( $post_id == get_option( 'gc_expiry_extension_product_id' ) ) ? 'yes' : 'no',
		);

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-admin.js', array( 'jquery', 'wp-color-picker', 'jquery-ui-datepicker', 'wc-enhanced-select' ), $this->version, false );
		wp_localize_script( $this->plugin_name, 'wps_wgm_params', $wps_wgm );

		if ( ( isset( $_GET['page'] ) && 'wps-wgc-setting-lite' == $_GET['page'] ) && isset( $_GET['tab'] ) && 'discount' == $_GET['tab'] ) {
			wp_enqueue_script( $this->plugin_name . '-admin-discount', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-admin-discount.js', array( 'jquery' ), $this->version, false );
		}
		if ( ( isset( $_GET['page'] ) && 'wps-wgc-setting-lite' == $_GET['page'] ) && isset( $_GET['tab'] ) && 'thankyou-order' == $_GET['tab'] ) {
			wp_register_script( $this->plugin_name . '-thankyou-order', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-admin-thankyou-order.js', array( 'jquery' ), $this->version, false );
			wp_enqueue_script( $this->plugin_name . '-thankyou-order' );
		}
		if ( ( isset( $_GET['page'] ) && 'wps-wgc-setting-lite' == $_GET['page'] ) && isset( $_GET['tab'] ) && 'customizable-giftcard' == $_GET['tab'] ) {

			wp_enqueue_script( $this->plugin_name . '-customizable', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-giftcard-admin-customizable.js', array( 'jquery' ), $this->version, false );
			wp_localize_script(
				$this->plugin_name . '-customizable',
				'ajax_object',
				array(
					'ajaxurl' => admin_url( 'admin-ajax.php' ),
					'reloadurl' => admin_url( 'admin.php?page=wps-wgc-setting-lite&tab=customizable-giftcard' ),
					'license_nonce' => wp_create_nonce( 'woocommerce-customizable-gift-card-license-nonce-action' ),
				)
			);
		}

		// enqueue scripts for giftcard products edit page.
		wp_enqueue_script( $this->plugin_name . '-admin-products', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-admin-product.js', array( 'jquery' ), $this->version, false );
		wp_localize_script( $this->plugin_name . '-admin-products', 'wps_wgm_object', $wps_wgm );

		/*Isotope Js to import template*/
		$wps_uwgc_import_gc_array = array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'wps_import_temp_nonce' => wp_create_nonce( 'wps-uwgc-giftcard-import-nonce' ),
		);
		wp_enqueue_script( 'wps_isotope_js', plugin_dir_url( __FILE__ ) . 'js/isotope.pkgd.min.js', array( 'jquery' ), $this->version, false );
		if ( isset( $_GET['page'] ) && 'uwgc-import-giftcard-templates' == $_GET['page'] ) {

			wp_register_script( $this->plugin_name . '-import-template', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-giftcard-isotope.js', array( 'jquery', 'wps_isotope_js' ), $this->version, true );
			wp_localize_script( $this->plugin_name . '-import-template', 'wps_import_gc', $wps_uwgc_import_gc_array );
			wp_enqueue_script( $this->plugin_name . '-import-template' );
		}

		/*Enqueue script for selecting multiple templates*/
		$wps_wgm = array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'append_option_val' => __( 'Select the template from above field', 'giftware' ),
			'wps_wgm_nonce' => wp_create_nonce( 'wps-wgm-verify-nonce' ),
		);

		wp_register_script( $this->plugin_name . 'admin-product', plugin_dir_url( __FILE__ ) . 'js/woocommerce_gift_cards_lite-product.js', array( 'jquery' ), $this->version, false );

		wp_localize_script( $this->plugin_name . 'admin-product', 'wps_wgm', $wps_wgm );
		wp_enqueue_script( $this->plugin_name . 'admin-product' );

		$screen = get_current_screen();
		if ( isset( $screen->id ) ) {
			$pagescreen = $screen->id;
		}
		if ( 'shop_order' === $pagescreen || 'woocommerce_page_wc-orders' == $pagescreen ) {
			if ( $this->check_if_giftcard_is_refundable() ) {
				wp_register_script( $this->plugin_name . 'gc_refundable', plugin_dir_url( __FILE__ ) . 'js/giftware-refund.js', array( 'jquery' ), $this->version, false );
				wp_enqueue_script( $this->plugin_name . 'gc_refundable' );
			}
		}
		$product_id = get_the_ID();
		$contri_prod_id = get_option( 'contributor_product_id' );
		if ($product_id == $contri_prod_id  ){
			wp_register_script( $this->plugin_name . 'contribution_product', plugin_dir_url( __FILE__ ) . 'js/contribution.js', array( 'jquery' ), $this->version, false );
				wp_enqueue_script( $this->plugin_name . 'contribution_product' );
		}

		////////////////////////////////// subs criptiin js enqueu /////////////////////////////

		if ( ( isset($screen->id) && ( 'plugins' === $screen->id || 'giftcard_page_wps-wgc-setting-lite' == $screen->id) )  ) {

			wp_register_script( 'ultimate-woocommerce-gift-card-admin-js', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-giftcard-notice-admin.js', array( 'jquery' ), $this->version, false );
 
 
			wp_localize_script(
				'ultimate-woocommerce-gift-card-admin-js',
				'wps_gc_admin_notice_param',
				array(
					'ajaxurl'                       => admin_url( 'admin-ajax.php' ),			
					'wsfwp_ajax_error'                => __( 'An error occured!', 'giftware' ),
					'gc_admin_param_location'      =>  admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite' ),
					'nonce'                           => wp_create_nonce( 'check-nonce' ),
					'reloadurl'                     => admin_url( 'admin.php?page=wps-wgc-setting-lite' ),
				)
			);
 
 
			wp_enqueue_script( 'ultimate-woocommerce-gift-card-admin-js' );
		}
	}

	/**
	 * This function is used to check if giftcard is refundable.
	 *
	 * @name check_if_giftcard_is_refundable
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function check_if_giftcard_is_refundable() {
		$result = false;
		$gc_item_in_order = 0;
		if ( isset( $_GET['post'] ) ) {
			$order_id = sanitize_text_field( wp_unslash( $_GET['post'] ) );
			$wps_wgc_enable = wps_wgm_giftcard_enable();
			if ( $wps_wgc_enable ) {
				$order = wc_get_order( $order_id );
				$order_status = $order->get_status();
				$order_total_quantity = $order->get_item_count();
				if ( 'processing' == $order_status || 'completed' == $order_status ) {
					// The loop to get the order items which are WC_Order_Item_Product objects since WC 3+.
					$woo_ver = WC()->version;
					foreach ( $order->get_items() as $item_id => $item ) {
						if ( $woo_ver < '3.0.0' ) {
							$_product = $order->get_product_from_item( $item );
							$product_id = $_product->id;
						} else {
							$_product = $item->get_product();
							if ( ! empty( $_product ) ) {
								$product_id = $_product->get_id();
							}
						}
						if ( isset( $product_id ) && ! empty( $product_id ) ) {
							$product_types = wp_get_object_terms( $product_id, 'product_type' );
							if ( isset( $product_types[0] ) ) {
								$product_type = $product_types[0]->slug;
								if ( 'wgm_gift_card' == $product_type ) {
									$gc_item_in_order++;
								}
							}
						}
					}
					if ( $gc_item_in_order === $order_total_quantity ) {
						foreach ( $order->get_items() as $item_id => $item ) {
							$giftcoupon = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
							if ( isset( $giftcoupon ) && ! empty( $giftcoupon ) ) {
								foreach ( $giftcoupon as $key => $value ) {
									global $woocommerce;
									$coupon_data = new WC_Coupon( $value );
									$coupon_usage = $coupon_data->get_usage_count();
									$coupon_amount = $coupon_data->get_amount();
									$expiry_date_timestamp = $coupon_data->get_date_expires();

									if ( empty( $expiry_date_timestamp ) ) {
										$expirydiff = 1;
									} else {
										$expiry_date_timestamp = strtotime( $expiry_date_timestamp );
										$timestamp = strtotime( gmdate( 'Y-m-d' ) );
										$expirydiff = $expiry_date_timestamp - $timestamp;
									}
									$coupon_original_amount = get_post_meta( $coupon_data->get_id(), 'wps_wgm_coupon_amount', true );
									if ( 0 == $coupon_usage && isset( $coupon_original_amount ) && $coupon_amount == $coupon_original_amount && 0 < $expirydiff ) {
										$result = false;
									} else {
										$result = true;
									}
								}
							}
						}
					}
				}
			}
		}
		return $result;
	}

	/**
	 * This function is used fpor license verification
	 *
	 * @name enqueue_scripts_for_license_validation
	 * @since 1.0.0
	 */
	public function enqueue_scripts_for_license_validation() {
		if ( ( isset( $_GET['page'] ) && 'wps-wgc-setting-lite' == $_GET['page'] ) && isset( $_GET['tab'] ) && 'validate_license' == $_GET['tab'] ) {
			wp_enqueue_script( $this->plugin_name . '-license', plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-giftcard-license.js', array( 'jquery' ), $this->version, false );
			wp_localize_script(
				$this->plugin_name . '-license',
				'license_ajax_object',
				array(
					'ajaxurl' => admin_url( 'admin-ajax.php' ),
					'reloadurl' => admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite' ),
					'license_nonce' => wp_create_nonce( 'wps_uwgc-nonce-action' ),
				)
			);
		}
	}
	/**
	 * This function return true if ultimate giftcard is active
	 *
	 * @name wps_uwgc_ultimate_giftcard_active
	 * @since 1.0.0
	 */
	public function wps_uwgc_ultimate_giftcard_active() {
		return true;
	}

	/**
	 * This function is used to provide Add new Template capability
	 *
	 * @name wps_uwgc_template_capabilities
	 * @param array $capability Hold the capability.
	 * @since 1.0.0
	 */
	public function wps_uwgc_template_capabilities( $capability ) {
		$capability = array(
			'create_posts' => true,
		);
		return $capability;
	}

	/**
	 * This function is to add giftcard tab settings
	 *
	 * @name wps_uwgc_pro_gift_card_setting_tab
	 * @param array $settings Contains the setting array.
	 * @since 1.0.0
	 */
	public function wps_uwgc_pro_gift_card_setting_tab( $settings ) {
		$callname_lic = Ultimate_Woocommerce_Gift_Card::$lic_callback_function;
		$callname_lic_initial = Ultimate_Woocommerce_Gift_Card::$lic_ini_callback_function;
		$day_count = Ultimate_Woocommerce_Gift_Card::$callname_lic_initial();

		if ( is_array( $settings ) && ! empty( $settings ) ) {
			if ( ! Ultimate_Woocommerce_Gift_Card::$callname_lic() ) {
				if ( 0 <= $day_count ) {
					$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_tab_additional_settings();
					$settings = array_merge( $settings, $wps_uwgc_data );
				} else {
					$settings = $settings;
				}
			} else {
				$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_tab_additional_settings();
				$settings = array_merge( $settings, $wps_uwgc_data );
			}
		}
		return $settings;
	}

	/**
	 * This function is to add giftcard tab settings for license activation af
	 *
	 * @name wps_uwgc_add_license_setting_tab
	 * @param array $settings Contains the array of settings.
	 * @since 1.0.0
	 */
	public function wps_uwgc_add_license_setting_tab( $settings ) {
		$callname_lic = Ultimate_Woocommerce_Gift_Card::$lic_callback_function;
		$callname_lic_initial = Ultimate_Woocommerce_Gift_Card::$lic_ini_callback_function;
		$day_count = Ultimate_Woocommerce_Gift_Card::$callname_lic_initial();

		if ( is_array( $settings ) && ! empty( $settings ) ) {
			if ( ! Ultimate_Woocommerce_Gift_Card::$callname_lic() || 0 <= $day_count ) {
				if ( ! Ultimate_Woocommerce_Gift_Card::$callname_lic() ) {
					$settings['validate_license'] = array(
						'title' => __( 'Activate License', 'giftware' ),
						'file_path' => WPS_UWGC_DIRPATH . 'admin/partials/templates/wps-uwgc-license-activation.php',
					);
				} else {
					$settings = $settings;
				}
			}
		}
		return $settings;
	}

	/**
	 * This function is to add giftcard notice on license activation.
	 *
	 * @name wps_uwgc_show_license_activation_notice.
	 * @since 1.0.0
	 */
	public function wps_uwgc_show_license_activation_notice() {

		$callname_lic = Ultimate_Woocommerce_Gift_Card::$lic_callback_function;
		$callname_lic_initial = Ultimate_Woocommerce_Gift_Card::$lic_ini_callback_function;
		$day_count = Ultimate_Woocommerce_Gift_Card::$callname_lic_initial();

		if ( ! Ultimate_Woocommerce_Gift_Card::$callname_lic() ) {
			if ( 0 <= $day_count ) {
				$day_count_warning = floor( $day_count );
				/* translators: %s: search term */
				$day_string = sprintf( _n( '%s day', '%s days', $day_count_warning, 'giftware' ), number_format_i18n( $day_count_warning ) );
				?>
				<div class="wps-gc-activate_notice update-nag">
					<strong>
						<?php esc_html_e( 'Activate your License Key before ', 'giftware' ); ?>
						<a href="<?php get_admin_url(); ?>edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=validate_license"><?php echo esc_html( $day_string ); ?></a>
						<?php esc_html_e( ' of activation - You might risk losing data by then, and you will not be able to use the plugin !', 'giftware' ); ?>
						<a href="<?php get_admin_url(); ?>edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=validate_license">
						<?php esc_html_e( ' Activate now ', 'giftware' ); ?></a>
					</strong>
				
				</div>
				<?php
			} else {
				?>
				<div class="wps-gc-activate_notice update-nag">
					<strong><?php esc_html_e( 'Unfortunately, Your trial has been expired. Please ', 'giftware' ); ?>
					<a href="<?php get_admin_url(); ?>edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=validate_license">
					   <?php esc_html_e( 'activate', 'giftware' ); ?></a>
				   <?php esc_html_e( ' your license key to avail the premium features.', 'giftware' ); ?>
					</strong>
				</div>
				<?php
			}
		}
	}

	/**
	 * This is used to add metabox
	 *
	 * @name wps_uwgc_css_metabox
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_css_metabox() {
		$screens = array( 'giftcard' );
		foreach ( $screens as $screen ) {
			add_meta_box(
				'wps_uwgc_css_field',           // Unique ID.
				__( 'Custom CSS', 'giftware' ),  // Box title.
				array( $this, 'wps_uwgc_template_css_metabox' ),  // Content callback.
				$screen                   // Post type.
			);
		}
	}

	/**
	 * This is the html of metabox
	 *
	 * @name wps_uwgc_template_css_metabox
	 * @author WP Swings <webmaster@wpswings.com>
	 * @param object $post Contains the posts.
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_template_css_metabox( $post ) {
		$value = get_post_meta( $post->ID, 'wps_css_field', true );
		?>
		<table class="form-table">

			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="wps_css_field"><?php esc_html_e( 'Custom CSS', 'giftware' ); ?></label>
				</th>
				<td class="forminp forminp-text">
					<label>
						<textarea name="wps_css_field" id="wps_css_field" class="wps_css_field" style="width:308px;height:100px;">
							<?php echo esc_html( $value ); ?> 
						</textarea>				
					</label>
				</td>
			</tr>
		</table>
		<?php
	}

	/**
	 * This is used to save meta fields of templates
	 *
	 * @name wps_save_meta_fields
	 * @param int $post_id Post Id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_save_meta_fields( $post_id ) {
		if ( array_key_exists( 'wps_css_field', $_POST ) ) {
			if ( isset( $_POST['wps_css_field'] ) ) {
				update_post_meta(
					$post_id,
					'wps_css_field',
					trim( sanitize_text_field( wp_unslash( $_POST['wps_css_field'] ) ) )
				);
			}
		}
	}

	/**
	 * Function to preview offline giftcard using ajax
	 *
	 * @name wps_uwgc_offline_preview
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_offline_preview() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		unset( $_POST['action'] );
		$_POST['wps_uwgc_offline_preview'] = 'wps_uwgc_offline_preview';
		$_POST['tempId'] = isset( $_POST['tempId'] ) ? stripcslashes( sanitize_text_field( wp_unslash( $_POST['tempId'] ) ) ) : '';
		$_POST['message'] = isset( $_POST['message'] ) ? stripcslashes( sanitize_text_field( wp_unslash( $_POST['message'] ) ) ) : '';

		$upload_dir_path = wp_upload_dir()['basedir'] . '/wps_browse';
		if ( ! is_dir( $upload_dir_path ) ) {
			wp_mkdir_p( $upload_dir_path );
			chmod( $upload_dir_path, 0775 );
		}
		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$browse_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_other_setting_browse' );
		if ( 'on' == $browse_enable && isset( $_FILES['file']['type'] ) && ! empty( $_FILES['file']['type'] ) ) {

			if ( ( 'image/gif' == $_FILES['file']['type'] )
				|| ( 'image/jpeg' == $_FILES['file']['type'] )
				|| ( 'image/jpg' == $_FILES['file']['type'] )
				|| ( 'image/pjpeg' == $_FILES['file']['type'] )
				|| ( 'image/x-png' == $_FILES['file']['type'] )
				|| ( 'image/png' == $_FILES['file']['type'] ) ) {
				$file_name = isset( $_FILES['file']['name'] ) ? sanitize_text_field( wp_unslash( $_FILES['file']['name'] ) ) : '';
				$tmp_name = isset( $_FILES['file']['tmp_name'] ) ? sanitize_text_field( wp_unslash( $_FILES['file']['tmp_name'] ) ) : '';
				if ( ! file_exists( wp_upload_dir()['basedir'] . '/wps_browse/' . $file_name ) ) {
					move_uploaded_file( $tmp_name, wp_upload_dir()['basedir'] . '/wps_browse/' . $file_name );
				}
				$_POST['name'] = $file_name;
			}
		}
		$_POST['width'] = '500';
		$_POST['height'] = '500';
		$_POST['TB_iframe'] = true;
		$query = http_build_query( wp_unslash( $_POST ) );
		$ajax_url = home_url( "?$query" );
		echo esc_attr( $ajax_url );
		wp_die();
	}

	/**
	 * Function to preview offline giftcard in mail
	 *
	 * @name wps_uwgc_offline_email_preview
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_offline_email_preview() {
		if ( isset( $_GET['wps_uwgc_offline_preview'] ) && 'wps_uwgc_offline_preview' == $_GET['wps_uwgc_offline_preview'] ) {
			$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
			$product_id = isset( $_GET['product_id'] ) ? sanitize_text_field( wp_unslash( $_GET['product_id'] ) ) : '';
			$product_pricing = ! empty( get_post_meta( $product_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $product_id, 'wps_wgm_pricing', true ) : get_post_meta( $product_id, 'wps_wgm_pricing_details', true );
			if ( ! empty( $product_pricing ) ) {
				$product_pricing_type = $product_pricing['type'];
			}
			$is_imported = get_post_meta( $product_id, 'is_imported', true );
			if ( isset( $is_imported ) && ! empty( $is_imported ) && 'yes' == $is_imported ) {
				$coupon = 'XXXXX';
				$imported_exp_date = get_post_meta( $product_id, 'expiry_after_days', true );
				$expirydate_format = $wps_admin_obj->wps_wgm_check_expiry_date( $imported_exp_date );
			} else {
				$general_setting = get_option( 'wps_wgm_general_settings', array() );
				$giftcard_coupon_length_display = $wps_admin_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_giftcard_coupon_length' );
				if ( '' == $giftcard_coupon_length_display ) {
					$giftcard_coupon_length_display = 5;
				}
				$password = '';
				for ( $i = 0;$i < $giftcard_coupon_length_display;$i++ ) {
					$password .= 'x';
				}
				$giftcard_prefix = $wps_admin_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_giftcard_prefix' );
				$coupon = $giftcard_prefix . $password;
			///////////////////////////////////////////////////

			$local_expiry_day = get_post_meta($product_id  ,'wps_wgm_local_setting_giftcard_expiry',true);
			if ( empty($local_expiry_day) || 0 == $local_expiry_day ){
				$expiry_date = $wps_admin_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_giftcard_expiry' );
			}else {
				$expiry_date = $local_expiry_day;
			}
			

			//////////////////////////////////////////////////
				
				$expirydate_format = $wps_admin_obj->wps_wgm_check_expiry_date( $expiry_date );
			}
			if ( isset( $_GET['gift_manual_code'] ) && ! empty( $_GET['gift_manual_code'] ) ) {
				$coupon = isset( $_GET['gift_manual_code'] ) ? sanitize_text_field( wp_unslash( $_GET['gift_manual_code'] ) ) : '';
			}
			$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing', true );
			$templateid = isset( $wps_wgm_pricing['template'] ) ? $wps_wgm_pricing['template'] : '';
			if ( is_array( $templateid ) && array_key_exists( 0, $templateid ) ) {
				$temp = $templateid[0];
			} else {
				$temp = $templateid;
			}
			$args['from'] = isset( $_GET['from'] ) ? sanitize_text_field( wp_unslash( $_GET['from'] ) ) : '';
			$args['to'] = isset( $_GET['to'] ) ? sanitize_text_field( wp_unslash( $_GET['to'] ) ) : '';
			$args['message'] = isset( $_GET['message'] ) ? sanitize_text_field( wp_unslash( $_GET['message'] ) ) : '';
			$args['coupon'] = apply_filters( 'wps_wgm_qrcode_coupon', $coupon );
			$args['expirydate'] = $expirydate_format;

			// Added for currency switcher.
			if ( class_exists( 'WOOCS' ) ) {
				global $WOOCS;
				$rate = 1;
				$currency = $WOOCS->current_currency;
				$currencies = $WOOCS->get_currencies();
				$rate = $currencies[ $currency ]['rate'];
				$cur_cur = $WOOCS->current_currency;
				$WOOCS->reset_currency();
				$WOOCS->set_currency( $cur_cur );
				$amt = isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '';
				if ( 'wps_wgm_range_price' == $product_pricing_type ) {
					$amt = isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '';
				} elseif ( 'wps_wgm_user_price' == $product_pricing_type ) {
					$amt = isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '';
				} else {
					$amt = floatval( $amt * $rate );
				}
				$args['amount'] = wc_price( $amt );
			} elseif ( class_exists( 'WCPBC_Pricing_Zone' ) ) {  // Added for price based on country.
				if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {

					if ( 'wps_wgm_range_price' == $product_pricing_type ) {
						$amt = isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '';
					} elseif ( 'wps_wgm_user_price' == $product_pricing_type ) {
							$amt = isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '';
					} else {
							$amt = isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '';
						$amt = wcpbc_the_zone()->get_exchange_rate_price( $amt );
					}
					$args['amount'] = wc_price( $amt );
				} else {
					$args['amount'] = wc_price( isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '' );
				}
			} else {
				$args['amount'] = wc_price( isset( $_GET['price'] ) ? sanitize_text_field( wp_unslash( $_GET['price'] ) ) : '' );
			}
			$args['templateid'] = isset( $temp_id ) && ! empty( $temp_id ) ? $temp_id : $temp;
			$args['product_id'] = $product_id;
			$args['order_id'] = '';
			$args['send_date'] = isset( $_GET['send_date'] ) ? sanitize_text_field( wp_unslash( $_GET['send_date'] ) ) : '';
			$other_settings = get_option( 'wps_wgm_other_settings', array() );
			$browse_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_other_setting_browse' );
			if ( 'on' == $browse_enable ) {
				if ( isset( $_GET['name'] ) && null !== $_GET['name'] ) {
					$args['browse_image'] = isset( $_GET['name'] ) ? sanitize_text_field( wp_unslash( $_GET['name'] ) ) : '';
				}
			}
			$style = '<style>
				table, th, tr, td {
					border: medium none;
				}
				table, th, tr, td {
					border: 0px !important;
				}
				#wps_wgm_email {
					width: 630px !important;
				}
				</style>';
			$giftcard_custom_css = get_option( 'wps_wgm_other_setting_mail_style', false );
			$giftcard_custom_css = stripcslashes( $giftcard_custom_css );
			$style .= "<style>$giftcard_custom_css</style>";
			$message = $wps_admin_obj->wps_wgm_create_gift_template( $args );
			$finalhtml = $style . $message;
			$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
			$allowed_tags = $wps_admin_obj->wps_allowed_html_tags();
			echo wp_kses( $finalhtml, $allowed_tags );
			wp_die();
		}
	}

	/**
	 * Function to add product settings fields
	 *
	 * @name wps_uwgc_ultimate_product_settings
	 * @author WP Swings <webmaster@wpswings.com>
	 * @param array $product_settings Contains array for product setting.
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_ultimate_product_settings( $product_settings ) {
		$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_product_settings();
		return array_merge( $product_settings, $wps_uwgc_data );
	}

	/**
	 * Function to check offline coupon is valid or not
	 *
	 * @name wps_uwgc_ultimate_product_settings
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_check_manual_code_exist() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$wps_manual_code = isset( $_POST['wps_manual_code'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_manual_code'] ) ) : '';
		$response['result'] = 'Fail due to some error!';
		if ( isset( $wps_manual_code ) && ! empty( $wps_manual_code ) ) {
			$the_coupon = new WC_Coupon( $wps_manual_code );
			$wps_manual_code_id = $the_coupon->get_id();
			if ( 0 == $wps_manual_code_id ) {
				$response['result'] = 'valid';
			} else {
				$response['result'] = 'invalid';
			}
			echo json_encode( $response );
			wp_die();
		}
	}

	/**
	 * This function is used to get all woocommerce orders
	 *
	 * @name wps_uwgc_get_all_woocommerce_orders
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_get_all_woocommerce_orders() {
		$wps_server_request_uri = isset( $_SERVER['REQUEST_URI'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '';

		if ( strpos( $wps_server_request_uri, 'admin.php?page=wps-wgc-setting-lite&wps_wugc_export_csv=' ) ) {
			$title = array();
			$content = array();
			$filename = 'wps_export.csv';
			$wps_export_csv = isset( $_GET['wps_wugc_export_csv'] ) ? sanitize_text_field( wp_unslash( $_GET['wps_wugc_export_csv'] ) ) : '';
			if ( 'wps_woo_gift_card_report' == $wps_export_csv ) {
				$gift_card_order_id = array();
				$coupons_args = array(
					'posts_per_page'   => -1,
					'orderby'          => 'title',
					'order'            => 'asc',
					'post_type'        => 'shop_coupon',
					'post_status'      => 'publish',
				);

				$coupons = get_posts( $coupons_args );
				if ( null !== $coupons ) {
					foreach ( $coupons as $post_key ) {
						$giftcardcoupon = get_post_meta( $post_key->ID, 'wps_wgm_giftcard_coupon', true );
						if ( ! empty( $giftcardcoupon ) ) {
							$gift_card_order_id[] = $giftcardcoupon;
						}
					}
					$gift_card_order_id = array_unique( $gift_card_order_id );

					if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
						// HPOS Enabled.
						$loops = wc_get_orders(
							array(
								'type'     => wc_get_order_types(),
								'limit'    => -1,
								'status'   => array_keys( wc_get_order_statuses() ),
								'post__in' => $gift_card_order_id,
								'return'   => 'ids',
							)
						);
					} else {
						$args = array(
							'post_type'       => wc_get_order_types(),
							'numberposts'     => -1,
							'post_status'     => array_keys( wc_get_order_statuses() ),
							'post__in'        => $gift_card_order_id,
							'fields'          => 'ids',
						);
						$loops = get_posts( $args );
					}
					if ( isset( $loops ) && ! empty( $loops ) ) {
						foreach ( $loops as $order_id ) {

							$order = new WC_Order( $order_id );
							$order_items = $order->get_items();// Items Array.

							$all_item_keys = array_keys( $order_items );// Items Keys.

							$woo_ver = WC()->version;
							foreach ( $all_item_keys as $key => $value ) {
								$coupon_code = wps_wgm_hpos_get_meta_data( $order_id, $order_id . '#' . $value, true );
								// check the coupon is array or not, as the previously it was just the string(before 2.4.3).
								if ( is_array( $coupon_code ) && ! empty( $coupon_code ) ) {
									foreach ( $coupon_code as $coupon_key => $coupon_val ) {
										if ( null !== $coupon_val ) {
											$coupon = new WC_Coupon( $coupon_val );
											if ( $woo_ver < '3.0.0' ) {
												$usage_amount = $coupon->usage_count;
												if ( null == $coupon->usage_count ) {
													$usage_amount = 0;
												}
												$coupon_amount_ = $coupon->coupon_amount;
												$to_type = gettype( $order_items[ $value ]['To'] );
												$from_type = gettype( $order_items[ $value ]['From'] );
												if ( preg_match( '/<[^<]+>/', $order_items[ $value ]['To'] ) ) {
													$to = new SimpleXMLElement( $order_items[ $value ]['To'] );
													$to_arr = substr( $to['href'], 7 );
												} else {
													$to = $order_items[ $value ]['To'];
													$to_arr = $to;
												}
												if ( preg_match( '/<[^<]+>/', $order_items[ $value ]['From'] ) ) {
													$from = new SimpleXMLElement( $order_items[ $value ]['From'] );
													$from_arr = substr( $from['href'], 7 );
												} else {
													$from = $order_items[ $value ]['From'];
													$from_arr = $from;
												}

												$content[] = array(
													$order_id,
													$coupon_val,
													$to_arr,
													$from_arr,
													$order_items[ $value ]['Message'],
													$usage_amount,
													$coupon_amount_,
												);
											} else {
												$usage_amount = $coupon->get_usage_count();
												if ( $coupon->get_usage_count() == null ) {
													$usage_amount = 0;
												}
												$coupon_amount_ = $coupon->get_amount();
												$to = $order_items[ $value ]['To'];
												$from = $order_items[ $value ]['From'];
												$content[] = array(
													$order_id,
													$coupon_val,
													$to,
													$from,
													$order_items[ $value ]['Message'],
													$usage_amount,
													$coupon_amount_,
												);
											}
										}
									}
								} else {
									if ( null !== $coupon_code ) {
										$coupon = new WC_Coupon( $coupon_code );
										if ( $woo_ver < '3.0.0' ) {
											$usage_amount = $coupon->usage_count;
											if ( null == $coupon->usage_count ) {
												$usage_amount = 0;
											}
											$coupon_amount_ = $coupon->coupon_amount;
											$to_type = gettype( $order_items[ $value ]['To'] );
											$from_type = gettype( $order_items[ $value ]['From'] );
											if ( preg_match( '/<[^<]+>/', $order_items[ $value ]['To'] ) ) {
												$to = new SimpleXMLElement( $order_items[ $value ]['To'] );
												$to_arr = substr( $to['href'], 7 );
											} else {
												$to = $order_items[ $value ]['To'];
												$to_arr = $to;
											}
											if ( preg_match( '/<[^<]+>/', $order_items[ $value ]['From'] ) ) {
												$from = new SimpleXMLElement( $order_items[ $value ]['From'] );
												$from_arr = substr( $from['href'], 7 );
											} else {
												$from = $order_items[ $value ]['From'];
												$from_arr = $from;
											}

											$content[] = array(
												$order_id,
												$coupon_code,
												$to_arr,
												$from_arr,
												$order_items[ $value ]['Message'],
												$usage_amount,
												$coupon_amount_,
											);

										} else {
											$usage_amount = $coupon->get_usage_count();
											if ( $coupon->get_usage_count() == null ) {
												$usage_amount = 0;
											}
											$coupon_amount_ = $coupon->get_amount();
											$to = $order_items[ $value ]['To'];
											$from = $order_items[ $value ]['From'];
											$content[] = array(
												$order_id,
												$coupon_code,
												$to,
												$from,
												$order_items[ $value ]['Message'],
												$usage_amount,
												$coupon_amount_,
											);
										}
									}
								}
							}
						}
					}
				}
				$title = array(
					__( 'Order Id', 'giftware' ),
					__( 'Coupon Code', 'giftware' ),
					__( 'To', 'giftware' ),
					__( 'From', 'giftware' ),
					__( 'Message', 'giftware' ),
					__( 'Usage Count', 'giftware' ),
					__( 'Coupon Amount Left', 'giftware' ),
				);
				$filename = 'wps_woo_gift_card_report.csv';
			}
			$wps_export_csv = isset( $_GET['wps_wugc_export_csv'] ) ? sanitize_text_field( wp_unslash( $_GET['wps_wugc_export_csv'] ) ) : '';
			if ( 'wps_woo_offline_gift_card_report' == $wps_export_csv ) {
				global $wpdb;
				$table_name = $wpdb->prefix . 'offline_giftcard';
				$query = "SELECT * FROM $table_name";
				$giftresults = $wpdb->get_results( $query, ARRAY_A );
				foreach ( $giftresults as $key => $value ) {
					$content[] = array(
						$value['id'],
						$value['coupon'],
						$value['to'],
						$value['from'],
						$value['message'],
						$value['amount'],
					);
				}
				$filename = 'wps_woo_offline_gift_card_report.csv';
				$title = array(
					__( 'Id', 'giftware' ),
					__( 'Coupon Code', 'giftware' ),
					__( 'To', 'giftware' ),
					__( 'From', 'giftware' ),
					__( 'Message', 'giftware' ),
					__( 'Coupon Amount', 'giftware' ),
				);
			}
			$upload_dir_path = wp_upload_dir()['basedir'] . '/';
			$error_log_folder = 'wps_woo_gift_card_import_error/';

			$import_error_dir = $upload_dir_path . $error_log_folder;
			if ( ! is_dir( $import_error_dir ) ) {
				mkdir( $import_error_dir, $permissions = 0777 );
			}

			$output = fopen( $import_error_dir . $filename, 'w' );
			fputcsv( $output, $title );
			foreach ( $content as $con ) {
				fputcsv( $output, $con );
			}
			$file_name = sanitize_text_field( $filename );
			$upload_dir_path = wp_upload_dir()['basedir'] . '/';
			$error_log_folder = 'wps_woo_gift_card_import_error/';
			$path_of_file_to_download = $upload_dir_path . $error_log_folder . $file_name;

			if ( file_exists( $path_of_file_to_download ) ) {
				header( 'Content-Description: File Transfer' );
				header( 'Content-Type: application/csv' );
				header( 'Content-Disposition: attachment; filename="' . basename( $path_of_file_to_download ) . '"' );
				header( 'Expires: 0' );
				header( 'Cache-Control: must-revalidate' );
				header( 'Pragma: public' );
				header( 'Content-Length: ' . filesize( $path_of_file_to_download ) );
				readfile( $path_of_file_to_download );
				exit;
			}
		}
	}

	/**
	 * This function is used to create general setting fields
	 *
	 * @name wps_uwgc_general_settings_fields
	 * @param array $general_setting Contains array of general settings.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_general_settings_fields( $general_setting ) {
		$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_general_settings();
		return ( array_merge( $general_setting, $wps_uwgc_data ) );
	}

	/**
	 * This function is used to extend the common functions of ultimate woocommerce gift card to general settings html
	 *
	 * @name wps_uwgc_settings_fields_html
	 * @param array $value Contains array .
	 * @param array $saved_settings Contains array .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_settings_fields_html( $value, $saved_settings ) {
		$wps_uwgc_html = new WPS_UWGC_SETTING_HTML_FUNCTION();
		$wps_uwgc_html->wps_uwgc_additional_common_settings_generate_html( $value, $saved_settings );
	}

	/**
	 * This function is used to extend the mail settings of ultimate woocommerce gift card
	 *
	 * @name wps_uwgc_email_settings
	 * @param array $settings Contains settings array .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_email_settings( $settings ) {
		$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_mail_settings();
		return ( array_merge( $settings, $wps_uwgc_data ) );
	}

	/**
	 * This function is used to extend the bottom mail settings tab of ultimate woocommerce gift card
	 *
	 * @name wps_uwgc_additional_mail_settings
	 * @param array $wps_wgm_mail_template_settings Contains settings array .
	 * @param array $mail_settings Contains settings array .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_additional_mail_settings( $wps_wgm_mail_template_settings, $mail_settings ) {
		?>
		<h3 id="wps_uwgc_coupon_mail_setting" class="wps_wgm_mail_setting_tab"><?php esc_html_e( ' Left Coupon Amount Mail Settings', 'giftware' ); ?></h3>
		<div id="wps_uwgc_coupon_mail_setting_wrapper" class="wps_wgm_table_wrapper">
			<table class="form-table wps_wgm_general_setting">		
				<tbody>
					<?php
					$settings_obj = new Woocommerce_Giftcard_Admin_Settings();
					$settings_obj->wps_wgm_generate_common_settings( $wps_wgm_mail_template_settings['bottom'], $mail_settings );
					?>
				</tbody>
			</table>
		</div>
		<?php
	}

	/**
	 * This function is used to extend the delivery settins of ultimate woocommerce gift card
	 *
	 * @name wps_wgm_additional_delivery_settings
	 * @param array $wps_wgm_delivery_settings Contains settings array .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_additional_delivery_settings( $wps_wgm_delivery_settings ) {
		$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_delivery_settings();
		return ( array_merge( $wps_wgm_delivery_settings, $wps_uwgc_data ) );
	}

	/**
	 * This function is used to merge other settings.
	 *
	 * @name wps_wgm_additional_other_setting
	 * @param array $settings Contains settings array .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_additional_other_setting( $settings ) {
		$wps_uwgc_data = $this->wps_uwgc_settings->wps_ugc_get_pro_other_settings();
		return ( array_merge( $settings, $wps_uwgc_data ) );
	}

	/**
	 * Provide multiple Fields for Gift Card Product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_giftcard_product_type_field()
	 * @param int $product_id Contains product_id .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_giftcard_product_type_field( $product_id ) {
		$wps_wgm_exclude_per_product = get_post_meta( $product_id, 'wps_wgm_exclude_per_product', true );
		$wps_wgm_exclude_per_category = get_post_meta( $product_id, 'wps_wgm_exclude_per_category', array() );
		$wps_wgm_include_per_product = get_post_meta( $product_id, 'wps_wgm_include_per_product', true );
		$wps_wgm_include_per_category = get_post_meta( $product_id, 'wps_wgm_include_per_category', array() );
		$wps_wgm_excluded_days_per_product = get_post_meta( $product_id, 'wps_wgm_excluded_days_per_product', array() );
		$wps_wgm_recommanded_per_product = get_post_meta( $product_id, 'wps_wgm_recommanded_per_product', true );
		$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing', true );
		$selectedtemplate  = isset( $wps_wgm_pricing['template'] ) ? $wps_wgm_pricing['template'] : false;
		$default_selected = isset( $wps_wgm_pricing['by_default_tem'] ) ? $wps_wgm_pricing['by_default_tem'] : false;
		$wps_wgm_discount_settings = get_option( 'wps_wgm_discount_settings', array() );
		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
		$discount_enable = $wps_admin_obj->wps_wgm_get_template_data( $wps_wgm_discount_settings, 'wps_wgm_discount_enable' );
		$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_giftware', true );
		if ( isset( $discount_enable ) && 'on' == $discount_enable && empty( $is_customizable ) ) {
			woocommerce_wp_checkbox(
				array(
					'id' => 'wps_wgm_discount',
					'class' => 'wps_wgm_discount',
					'label' => __( 'Give Discount ?', 'giftware' ),
					'name' => 'wps_wgm_discount',
				)
			);
		}


		////////////////////////////////////////////////////////////////////

		$wps_giftcard_type = get_post_meta( $product_id, 'wps_giftcard_type', true );

		$is_group_product = get_post_meta( $product_id , 'wps_wgm_is_group_gift', true );

		if ( 'yes' === $is_customizable ) {
			$wps_giftcard_type = 'customize';
		} else if ( 'yes' === $is_group_product ) {
			$wps_giftcard_type = 'group';
		} else {
			$wps_giftcard_type = 'simple';
		}
		
		?>
	
<p class="form-field wps_wgm_local_setting_giftcard_expiry_field">
				<label class = "wps_wgm_local_setting_giftcard_type" for="wps_wgm_local_setting_giftcard_type"><?php esc_html_e( 'Select Giftcard type', 'giftware' ); ?></label>
				<span class="wps-wrapper-class" >
				
  <input type="radio"  onclick="toggleFields()" value="simple" name="wps_giftcard_type" id="wps_type1" <?php if ('simple' == $wps_giftcard_type) { echo "checked"; } ?>  ><span><?php esc_html_e( 'Simple', 'giftware' );  ?></span>
 
  <input type="radio" onclick="toggleFields()" value="customize" name="wps_giftcard_type" id="wps_type2" <?php if ('customize' == $wps_giftcard_type) { echo "checked" ;} ?> ><span><?php esc_html_e( 'Customize', 'giftware' ); ?></span>
  
<input type="radio" onclick="toggleFields()" value="group" name="wps_giftcard_type" id="wps_type3" <?php if ('group' == $wps_giftcard_type) { echo "checked" ;} ?> ><span> <?php esc_html_e( 'Group', 'giftware' ); ?></span>
  
		</span>
        
    

			</p>

		<p class="form-field wps_wgm_email_defualt_template">
			<label class = "wps_wgm_email_defualt_template" for="wps_wgm_email_defualt_template"><?php esc_html_e( 'Which template do you want to be selected by default?', 'giftware' ); ?></label>

			<select id="wps_wgm_email_defualt_template" name = "wps_wgm_email_defualt_template" style="width: 50%">
				<?php

				if ( empty( $default_selected ) ) {
					?>
					<option value=""><?php esc_html_e( 'Select the template from above field ', 'giftware' ); ?></option>
					<?php
				} elseif ( is_array( $selectedtemplate ) && ! empty( $selectedtemplate ) && ! empty( $default_selected ) ) {
					$args = array(
						'post_type' => 'giftcard',
						'post__in' => $selectedtemplate,
					);
					$loop = new WP_Query( $args );
					foreach ( $loop->posts as $key => $value ) {
						$template_id = $value->ID;
						$template_title = $value->post_title;
						$alreadyselected = '';
						if ( is_array( $selectedtemplate ) && in_array( $default_selected, $selectedtemplate ) && $default_selected == $template_id ) {

							$alreadyselected = " selected='selected'";
						}
						?>
						<option value="<?php echo esc_attr( $template_id ); ?>"<?php echo esc_attr( $alreadyselected ); ?>><?php echo esc_attr( $template_title ); ?></option>
						<?php
					}
				} elseif ( '' !== $selectedtemplate && '' !== $default_selected ) {
					$alreadyselected = '';
					if ( $selectedtemplate == $default_selected ) {
						$alreadyselected = " selected='selected'";
					}
					$template_id = $default_selected;
					$template_title = get_the_title( $default_selected );
					?>
					<option value="<?php echo esc_attr( $template_id ); ?>"<?php echo esc_attr( $alreadyselected ); ?>><?php echo esc_attr( $template_title ); ?></option>
					<?php
				}
				?>
			</select>
		</p>
			<?php

		$woo_ver = WC()->version;
		if ( $woo_ver < '3.0.0' ) {
			?>
			<p class="form-field"><label><?php esc_html_e( 'Exclude Products', 'giftware' ); ?></label>
				<input type="hidden" class="wc-product-search" data-multiple="true" style="width: 50%;" name="wps_wgm_exclude_per_product" data-placeholder="<?php esc_attr_e( 'Search for a product', 'giftware' ); ?>" data-action="woocommerce_json_search_products_and_variations" data-selected="" value="<?php echo esc_html( implode( ',', array_keys( $json_ids ) ) ); ?>" />
			</p>
			<?php
		} else {
			?>
			<p class="form-field wps_wgm_exclude_per_product_field">
				<label class = "wps_wgm_exclude_per_product" for="wps_wgm_exclude_per_product"><?php esc_html_e( 'Exclude Products', 'giftware' ); ?></label>
				<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Products which must not be in the cart to use Gift card coupon or, for "Product Discounts", which products are not discounted.', 'giftware'); ?>"></span>
				<select class="wc-product-search" multiple="multiple" style="width: 50%;" name="wps_wgm_exclude_per_product[]" data-placeholder="<?php esc_attr_e( 'Search for a product', 'giftware' ); ?>" data-action="woocommerce_json_search_products_and_variations" id="wps_wgm_exclude_per_product"> 
					<?php
					if ( isset( $wps_wgm_exclude_per_product ) && ! empty( $wps_wgm_exclude_per_product ) ) {
						foreach ( $wps_wgm_exclude_per_product as $pro_id ) {
							$product      = wc_get_product( $pro_id );
							$product_title = $product->get_formatted_name();
							echo '<option value="' . esc_attr( $pro_id ) . '" selected="selected">' . esc_html( $product_title ) . '</option>';
						}
					}
					?>
				</select>
			</p>
			<?php
		}
		?>
		<p class="form-field wps_wgm_exclude_per_category_field">
			<label class = "wps_wgm_exclude_per_category" for="wps_wgm_exclude_per_category"><?php esc_html_e( 'Exclude Category', 'giftware' ); ?></label>
			<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Product must not be in this category for the Gift Card coupon to remain valid or, for "Product Discounts", products in these categories will not be discounted.', 'giftware'); ?>"></span>
			<select id="wps_wgm_exclude_per_category" multiple="multiple" name="wps_wgm_exclude_per_category[]">
				<?php
				$args = array( 'taxonomy' => 'product_cat' );
				$categories = get_terms( $args );
				if ( isset( $categories ) && ! empty( $categories ) ) {
					foreach ( $categories as $category ) {
						$catid = $category->term_id;
						$catname = $category->name;
						$catselect = '';
						if ( is_array( $wps_wgm_exclude_per_category ) && ! empty( $wps_wgm_exclude_per_category ) ) {
							if ( is_array( $wps_wgm_exclude_per_category[0] ) && in_array( $catid, $wps_wgm_exclude_per_category[0] ) ) {
								$catselect = "selected='selected'";
							}
						}
						?>
						<option value="<?php echo esc_html( $catid ); ?>" <?php echo esc_html( $catselect ); ?>><?php echo esc_html( $catname ); ?></option>
						<?php
					}
				}
				?>
			</select>
		</p>
		<?php
		$woo_ver = WC()->version;
		if ( $woo_ver < '3.0.0' ) {
			?>
			<p class="form-field"><label><?php esc_html_e( 'Include Products', 'giftware' ); ?></label>
				<input type="hidden" class="wc-product-search" data-multiple="true" style="width: 50%;" name="wps_wgm_include_per_product" data-placeholder="<?php esc_attr_e( 'Search for a product', 'giftware' ); ?>" data-action="woocommerce_json_search_products_and_variations" data-selected="" value="<?php echo esc_html( implode( ',', array_keys( $json_ids ) ) ); ?>" />
			</p>
			<?php
		} else {
			?>
			<p class="form-field wps_wgm_include_per_product_field">
				<label class = "wps_wgm_include_per_product" for="wps_wgm_include_per_product"><?php esc_html_e( 'Include Products', 'giftware' ); ?></label>
				<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Product that the coupon will be applied to, or that need to be in the cart in order for the "Gift Card discount" to be applied.', 'giftware'); ?>"></span>
				<select class="wc-product-search" multiple="multiple" style="width: 50%;" name="wps_wgm_include_per_product[]" data-placeholder="<?php esc_attr_e( 'Search for a product', 'giftware' ); ?>" data-action="woocommerce_json_search_products_and_variations" id="wps_wgm_include_per_product"> 
					<?php
					if ( isset( $wps_wgm_include_per_product ) && ! empty( $wps_wgm_include_per_product ) ) {
						foreach ( $wps_wgm_include_per_product as $pro_id ) {
							$product      = wc_get_product( $pro_id );
							$product_title = $product->get_formatted_name();
							echo '<option value="' . esc_attr( $pro_id ) . '" selected="selected">' . esc_html( $product_title ) . '</option>';
						}
					}
					?>
				</select>
			</p>
			<?php
		}
		?>
		<p class="form-field wps_wgm_include_per_category_field">
			<label class = "wps_wgm_include_per_category" for="wps_wgm_include_per_category"><?php esc_html_e( 'Include Category', 'giftware' ); ?></label>
			<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Product categories that the coupon will be applied to, or that need to be in the cart in order for the "Gift Card discount" to be applied.', 'giftware'); ?>"></span>
			<select id="wps_wgm_include_per_category" multiple="multiple" name="wps_wgm_include_per_category[]">
				<?php
				$args = array( 'taxonomy' => 'product_cat' );
				$categories = get_terms( $args );
				if ( isset( $categories ) && ! empty( $categories ) ) {
					foreach ( $categories as $category ) {
						$catid = $category->term_id;
						$catname = $category->name;
						$catselect = '';
						if ( is_array( $wps_wgm_include_per_category ) && ! empty( $wps_wgm_include_per_category ) ) {
							if ( is_array( $wps_wgm_include_per_category[0] ) && in_array( $catid, $wps_wgm_include_per_category[0] ) ) {
								$catselect = "selected='selected'";
							}
						}
						?>
						<option value="<?php echo esc_attr( $catid ); ?>" <?php echo esc_html( $catselect ); ?>><?php echo esc_html( $catname ); ?></option>
						<?php
					}
				}
				?>
			</select>
		</p>
		<p class="form-field wps_wgm_excluded_days_field">
			<label class = "wps_wgm_excluded_days_per_product" for="wps_wgm_excluded_days_per_product"><?php esc_html_e( 'Days Excluded', 'giftware' ); ?></label>
			<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Select the days when this coupon cannot be used.', 'giftware'); ?>"></span>
			<select id="wps_wgm_excluded_days_per_product" multiple="multiple" name="wps_wgm_excluded_days_per_product[]">
				<?php
				$wps_wgm_week_days = array( 
					array(
						'id'   => 'sunday',
						'name' => __('Sunday', 'giftware'),
					),
					array(
						'id'   => 'monday',
						'name' => __('Monday', 'giftware'),
					),
					array(
						'id'   => 'tuesday',
						'name' => __('Tuesday', 'giftware'),
					),
					array(
						'id'   => 'wednesday',
						'name' => __('Wednesday', 'giftware'),
					),
					array(
						'id'   => 'thursday',
						'name' => __('Thursday', 'giftware'),
					),
					array(
						'id'   => 'friday',
						'name' => __('Friday', 'giftware'),
					),
					array(
						'id'   => 'saturday',
						'name' => __('Saturday', 'giftware'),
					),
				);

				if ( isset( $wps_wgm_week_days ) && ! empty( $wps_wgm_week_days ) ) {
					foreach ( $wps_wgm_week_days as $week_day ) {
						$wid         = $week_day['id'];
						$wname       = $week_day['name'];
						$week_select = '';
						if ( is_array( $wps_wgm_excluded_days_per_product ) && ! empty( $wps_wgm_excluded_days_per_product ) ) {
							if ( is_array( $wps_wgm_excluded_days_per_product[0] ) && in_array( $wid, $wps_wgm_excluded_days_per_product[0] ) ) {
								$week_select = "selected='selected'";
							}
						}
						?>
						<option value="<?php echo esc_attr( $wid ); ?>" <?php echo esc_html( $week_select ); ?>><?php echo esc_html( $wname ); ?></option>
						<?php
					}
				}
				?>
			</select>
		</p>
		<p class="form-field wps_wgm_recommanded_product_field">
				<label class = "wps_wgm_recommanded_per_product" for="wps_wgm_recommanded_per_product"><?php esc_html_e( 'Recommended Products', 'giftware' ); ?></label>
				<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'To show the recommended products on email templates for this product.', 'giftware'); ?>"></span>
				<select class="wc-product-search" multiple="multiple" style="width: 50%;" name="wps_wgm_recommanded_per_product[]" data-placeholder="<?php esc_attr_e( 'Search for a product', 'giftware' ); ?>" data-action="woocommerce_json_search_products_and_variations" id="wps_wgm_recommanded_per_product"> 
					<?php
					if ( isset( $wps_wgm_recommanded_per_product ) && ! empty( $wps_wgm_recommanded_per_product ) ) {
						foreach ( $wps_wgm_recommanded_per_product as $pro_id ) {
							$product      = wc_get_product( $pro_id );
							$product_title = $product->get_formatted_name();
							echo '<option value="' . esc_attr( $pro_id ) . '" selected="selected">' . esc_html( $product_title ) . '</option>';
						}
					}
					?>
				</select>
			</p>
			<?php
				$local_expiry_day = get_post_meta($product_id ,'wps_wgm_local_setting_giftcard_expiry',true);
				if (empty($local_expiry_day)){
					$local_expiry_day = 0;
				}
				?>
			<p class="form-field wps_wgm_local_setting_giftcard_expiry_field">
				<label class = "wps_wgm_local_setting_giftcard_expiry" for="wps_wgm_local_setting_giftcard_expiry"><?php esc_html_e( 'Set Expiry Days', 'giftware' ); ?></label>
				<span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'To set the expiry days locally for this product after gift card purchase.', 'giftware'); ?>"></span>
				<input type="number" min="0" value="<?php echo esc_html( $local_expiry_day ); ?>" name="wps_wgm_local_setting_giftcard_expiry" id="wps_wgm_local_setting_giftcard_expiry" >	
			</p>
			
		<?php
			woocommerce_wp_checkbox(
				array(
					'id' => 'wps_wgm_is_group_gift',
					'class' => 'wps_wgm_is_group_gift',
					'label' => __( 'Group Product', 'giftware' ),
					'name' => 'wps_wgm_is_group_gift',
				)
			);
		
		woocommerce_wp_checkbox(
			array(
				'id' => 'wps_wgm_overwrite',
				'class' => 'wps_wgm_overwrite',
				'label' => __( 'Overwrite Delivery', 'giftware' ),
				'name' => 'wps_wgm_overwrite',
				'desc_tip'    => true,
            	'description' => __( 'Overwrite the global delivery method by enabling this setting.', 'giftware' ),
			)
		);
		woocommerce_wp_checkbox(
			array(
				'id' => 'wps_wgm_email_to_recipient',
				'class' => 'wps_wgm_email_to_recipient',
				'label' => __( 'Email To Recipient', 'giftware' ),
				'name' => 'wps_wgm_email_to_recipient',
			)
		);
		woocommerce_wp_checkbox(
			array(
				'id' => 'wps_wgm_download',
				'class' => 'wps_wgm_download',
				'label' => __( 'Download', 'giftware' ),
				'name' => 'wps_wgm_download',
			)
		);
		woocommerce_wp_checkbox(
			array(
				'id' => 'wps_wgm_shipping',
				'class' => 'wps_wgm_shipping',
				'label' => __( 'Shipping', 'giftware' ),
				'name' => 'wps_wgm_shipping',
			)
		);

		do_action( 'wps_uwgc_giftcard_product_field', $product_id );
	}

	/**
	 * Saves the all required details for each giftcard product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_giftcard_product_type_save_fields()
	 * @param int $product_id Contains product_id .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_giftcard_product_type_save_fields( $product_id ) {
		$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing', true );
		if ( ! isset( $_POST['wps_wgm_product_nonce_field'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['wps_wgm_product_nonce_field'] ) ), 'wps_wgm_lite_nonce' ) ) {
			return;
		}
		
		$is_overwrite = isset( $_POST['wps_wgm_overwrite'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_overwrite'] ) ) : '';
		update_post_meta( $product_id, 'wps_wgm_overwrite', $is_overwrite );
		
		$is_group_gift = isset( $_POST['wps_wgm_is_group_gift'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_is_group_gift'] ) ) : '';
		update_post_meta( $product_id, 'wps_wgm_is_group_gift', $is_group_gift );

		//////////////////////////////////////// for customizable gift card /////////////////////////////////////
		$wps_giftcard_type = isset( $_POST['wps_giftcard_type'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_giftcard_type'] ) ) : '';
		update_post_meta( $product_id, 'wps_giftcard_type', $wps_giftcard_type );

		if ( "customize" == $wps_giftcard_type  ){
			wp_set_object_terms( $product_id, 'wgm_gift_card', 'product_type' );
			update_post_meta( $product_id, '_regular_price', 35 );
            update_post_meta( $product_id, '_price', 35 );
            update_post_meta( $product_id, 'wps_wgm_pricing', $wps_wgm_pricing );
            update_post_meta( $product_id, 'woocommerce_customizable_giftware', 'yes' );
            update_post_meta( $product_id, 'wps_customizable_gift_card_from_edit', 'yes');
            $wps_wgm_image_enable   = get_option( 'wps_wgm_image_enable','default_img' );
            $wps_uwgc_custmizable_settings = get_option( 'wps_wgm_customizable_settings', array() );
            $wps_uwgc_custmizable_settings['wps_wgm_customizable_enable'] = 'on';
            $wps_uwgc_custmizable_settings['wps_wgm_image_enable'] = $wps_wgm_image_enable;
            update_option( 'wps_wgm_customizable_settings',$wps_uwgc_custmizable_settings );

		}

		if ( "simple" == $wps_giftcard_type ){

			delete_post_meta($product_id, 'woocommerce_customizable_giftware');
		}

		if ( "group" == $wps_giftcard_type  ) {
			delete_post_meta($product_id, 'woocommerce_customizable_giftware');
			update_post_meta( $product_id, 'wps_wgm_is_group_gift', $is_group_gift );
		}
		
		////////////////////////////////////////// End setting //////////////////////////////////////////////
		
		if ( isset( $is_overwrite ) && ! empty( $is_overwrite ) ) {
			$wps_wgm_email_to_recipient = isset( $_POST['wps_wgm_email_to_recipient'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_email_to_recipient'] ) ) : '';

			$wps_wgm_shipping = isset( $_POST['wps_wgm_shipping'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_shipping'] ) ) : '';
			$wps_wgm_download = isset( $_POST['wps_wgm_download'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_download'] ) ) : '';

			if ( empty( $wps_wgm_email_to_recipient ) && empty( $wps_wgm_shipping ) && empty( $wps_wgm_download ) ) {
				$wps_wgm_email_to_recipient = 'yes';
			}

			update_post_meta( $product_id, 'wps_wgm_email_to_recipient', $wps_wgm_email_to_recipient );
			update_post_meta( $product_id, 'wps_wgm_download', $wps_wgm_download );
			update_post_meta( $product_id, 'wps_wgm_shipping', $wps_wgm_shipping );
		}
		$wps_uwgc_is_discount = isset( $_POST['wps_wgm_discount'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_discount'] ) ) : 'no';
		if ( isset( $wps_wgm_pricing['type'] ) ) {
			if ( 'wps_wgm_default_price' == $wps_wgm_pricing['type'] || 'wps_wgm_range_price' == $wps_wgm_pricing['type'] || 'wps_wgm_user_price' == $wps_wgm_pricing['type'] ) {
				update_post_meta( $product_id, 'wps_wgm_discount', $wps_uwgc_is_discount );
			} else {
				$wps_uwgc_is_discount = 'no';
				update_post_meta( $product_id, 'wps_wgm_discount', $wps_uwgc_is_discount );
			}
		}
		$wps_wgm_exclude_per_product = array();
		$wps_wgm_exclude_per_product = isset( $_POST['wps_wgm_exclude_per_product'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_exclude_per_product'] ), 'sanitize_text_field' ) : '';

		if ( isset( $wps_wgm_exclude_per_product ) && ! empty( $wps_wgm_exclude_per_product ) ) {
			update_post_meta( $product_id, 'wps_wgm_exclude_per_product', $wps_wgm_exclude_per_product );
		} else {
			update_post_meta( $product_id, 'wps_wgm_exclude_per_product', $wps_wgm_exclude_per_product );
		}

		$wps_wgm_include_per_product = array();
		$wps_wgm_include_per_product = isset( $_POST['wps_wgm_include_per_product'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_include_per_product'] ), 'sanitize_text_field' ) : '';
		if ( isset( $wps_wgm_include_per_product ) && ! empty( $wps_wgm_include_per_product ) ) {
			update_post_meta( $product_id, 'wps_wgm_include_per_product', $wps_wgm_include_per_product );
		} else {
			update_post_meta( $product_id, 'wps_wgm_include_per_product', $wps_wgm_include_per_product );
		}

		$wps_wgm_recommanded_per_product = array();
		$wps_wgm_recommanded_per_product = isset( $_POST['wps_wgm_recommanded_per_product'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_recommanded_per_product'] ), 'sanitize_text_field' ) : '';
		if ( isset( $wps_wgm_recommanded_per_product ) && ! empty( $wps_wgm_recommanded_per_product ) ) {
			update_post_meta( $product_id, 'wps_wgm_recommanded_per_product', $wps_wgm_recommanded_per_product );
		} else {
			update_post_meta( $product_id, 'wps_wgm_recommanded_per_product', $wps_wgm_recommanded_per_product );
		}

		$wps_wgm_exclude_per_category = array();
		$wps_wgm_exclude_per_category = isset( $_POST['wps_wgm_exclude_per_category'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_exclude_per_category'] ), 'sanitize_text_field' ) : array();
		if ( isset( $wps_wgm_exclude_per_category ) && ! empty( $wps_wgm_exclude_per_category ) ) {
			update_post_meta( $product_id, 'wps_wgm_exclude_per_category', $wps_wgm_exclude_per_category );
		} else {
			update_post_meta( $product_id, 'wps_wgm_exclude_per_category', $wps_wgm_exclude_per_category );
		}

		$wps_wgm_include_per_category = array();
		$wps_wgm_include_per_category = isset( $_POST['wps_wgm_include_per_category'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_include_per_category'] ), 'sanitize_text_field' ) : array();
		if ( isset( $wps_wgm_include_per_category ) && ! empty( $wps_wgm_include_per_category ) ) {
			update_post_meta( $product_id, 'wps_wgm_include_per_category', $wps_wgm_include_per_category );
		} else {
			update_post_meta( $product_id, 'wps_wgm_include_per_category', $wps_wgm_include_per_category );
		}

		$wps_wgm_excluded_days_per_product = array();
		$wps_wgm_excluded_days_per_product = isset( $_POST['wps_wgm_excluded_days_per_product'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_excluded_days_per_product'] ), 'sanitize_text_field' ) : array();
		if ( isset( $wps_wgm_excluded_days_per_product ) && ! empty( $wps_wgm_excluded_days_per_product ) ) {
			update_post_meta( $product_id, 'wps_wgm_excluded_days_per_product', $wps_wgm_excluded_days_per_product );
		} else {
			update_post_meta( $product_id, 'wps_wgm_excluded_days_per_product', $wps_wgm_excluded_days_per_product );
		}

		//////////////////////////////////////////////////////////////////////
		$wps_wgm_local_setting_giftcard_expiry = isset( $_POST['wps_wgm_local_setting_giftcard_expiry'] ) ? map_deep( wp_unslash( $_POST['wps_wgm_local_setting_giftcard_expiry'] ), 'sanitize_text_field' ): array(); 
		
		if ( isset($wps_wgm_local_setting_giftcard_expiry) && !empty($wps_wgm_local_setting_giftcard_expiry)){
			update_post_meta( $product_id, 'wps_wgm_local_setting_giftcard_expiry',$wps_wgm_local_setting_giftcard_expiry );
		} else {
			$wps_wgm_local_setting_giftcard_expiry = 0;
			update_post_meta( $product_id, 'wps_wgm_local_setting_giftcard_expiry',$wps_wgm_local_setting_giftcard_expiry );
		}
		/////////////////////////////////////////////////////////////////////
		do_action( 'wps_uwgc_giftcard_product_field_save', $product_id );
	}

	/**
	 * This function is used to create Custmizable Giftcard.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_show_customizable_dialog()
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_show_customizable_dialog() {
		$response['result'] = false;
		$response['message'] = __( 'Failed to create Product!', 'giftware' );
		$pro_img_url = WPS_UWGC_URL . 'assets/images/customized_card.jpg';
		if ( ! empty( $pro_img_url ) ) {
			$filename = array( $pro_img_url );
			foreach ( $filename as $key => $value ) {
				$upload_file = wp_upload_bits( basename( $value ), null, file_get_contents( $value ) );
				if ( ! $upload_file['error'] ) {
					$filename = $upload_file['file'];
					// The ID of the post this attachment is for.

					$parent_post_id = 0;

					// Check the type of file. We'll use this as the 'post_mime_type'.
					$filetype = wp_check_filetype( basename( $filename ), null );

					// Get the path to the upload directory.
					$wp_upload_dir = wp_upload_dir();

					// Prepare an array of post data for the attachment.
					$attachment = array(
						'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ),
						'post_mime_type' => $filetype['type'],
						'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
						'post_status'    => 'inherit',
					);
					// Insert the attachment.
					$attach_id = wp_insert_attachment( $attachment, $filename, 0 );
					// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
					require_once( ABSPATH . 'wp-admin/includes/image.php' );

					// Generate the metadata for the attachment, and update the database record.
					$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );

					wp_update_attachment_metadata( $attach_id, $attach_data );
				}
			}
		}
		$product_array = array(
			'post_title' => 'Customize Your Gift Card',
			'post_content' => '',
			'post_excerpt' => '',
			'post_status' => 'draft',
			'post_author' => get_current_user_id(),
			'post_type'     => 'product',
		);

		$product_id = wp_insert_post( $product_array );

		if ( isset( $product_id ) && ! empty( $product_id ) ) {

			$wps_wgm_pricing['type'] = 'wps_wgm_default_price';
			$wps_wgm_pricing['default_price'] = 35;
			wp_set_object_terms( $product_id, 'wgm_gift_card', 'product_type' );
			update_post_meta( $product_id, '_regular_price', 35 );
			update_post_meta( $product_id, '_price', 35 );
			update_post_meta( $product_id, 'wps_wgm_pricing', $wps_wgm_pricing );
			update_post_meta( $product_id, 'woocommerce_customizable_giftware', 'yes' );
			update_post_meta( $product_id, 'wps_giftcard_type', 'customize' );
			update_option( 'wcgc_product_created', true );
			if ( ! empty( $attach_id ) ) {
				set_post_thumbnail( $product_id, $attach_id );
			}
			$response['result'] = true;
			$response['message'] = __( 'Successfully Created!', 'giftware' );
			$redirection = "post.php?post={$product_id}&action=edit";
			$response['redirect_url'] = admin_url( $redirection );
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * This function is used to validate_license_handle.
	 *
	 * @since 1.0.0
	 * @name validate_license_handle()
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function validate_license_handle() {

		// First check the nonce, if it fails the function will break.
		check_ajax_referer( 'wps_uwgc-nonce-action', 'wps_uwgc-license-nonce' );
		$wps_license_key = ! empty( $_POST['wps_uwgc_purchase_code'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_uwgc_purchase_code'] ) ) : '';

		if ( is_multisite() ) {
			$domain = site_url();
		} else {
			$domain = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
		}

		// API query parameters.
		$api_params = array(
			'slm_action' => 'slm_activate',
			'secret_key' => WPS_UWGC_SPECIAL_SECRET_KEY,
			'license_key' => $wps_license_key,
			'registered_domain' => $domain,
			'item_reference' => urlencode( WPS_UWGC_ITEM_REFERENCE ),
			'product_reference' => 'WPSPK-67566',
		);
		// Send query to the license manager server.
		$query = esc_url_raw( add_query_arg( $api_params, WPS_UWGC_SERVER_URL ) );

		$response = wp_remote_get(
			$query,
			array(
				'timeout'    => 20,
				'sslverify'  => false,
				'user-agent' => 'Ultimate Woocommerce Gift Cards/' . $this->version,
			)
		);

		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

		if ( isset( $license_data->result ) && 'success' === $license_data->result ) {
			global $wpdb;
			if ( is_multisite() ) {
				// Get all blogs in the network and activate plugins on each one.
				$blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
				foreach ( $blog_ids as $blog_id ) {
					switch_to_blog( $blog_id );
					update_option( 'wps_gw_lcns_key', $wps_license_key );
					update_option( 'wps_gw_lcns_status', 'true' );
					restore_current_blog();
				}
			} else {
				update_option( 'wps_gw_lcns_key', $wps_license_key );
				update_option( 'wps_gw_lcns_status', 'true' );
			}

			echo json_encode(
				array(
					'status' => true,
					'msg' => __(
						'Successfully Verified...',
						'giftware'
					),
				)
			);
		} else {

			$error_message = ! empty( $license_data->message ) ? $license_data->message : __( 'License Verification Failed.', 'giftware' );

			echo json_encode(
				array(
					'status' => false,
					'msg' => $error_message,
				)
			);
		}
		wp_die();
	}

	/**
	 * Validate License daily.
	 * name     validate_license_daily
	 *
	 * @since   1.0.0
	 */
	public function validate_license_daily() {

		$wps_license_key = get_option( 'wps_gw_lcns_key', '' );

		if ( is_multisite() ) {
			$domain = site_url();
		} else {
			$domain = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
		}

		// API query parameters.
		$api_params = array(
			'slm_action' => 'slm_check',
			'secret_key' => WPS_UWGC_SPECIAL_SECRET_KEY,
			'license_key' => $wps_license_key,
			'registered_domain' => $domain,
			'item_reference' => urlencode( WPS_UWGC_ITEM_REFERENCE ),
			'product_reference' => 'WPSPK-67566',
		);

		$query = esc_url_raw( add_query_arg( $api_params, WPS_UWGC_SERVER_URL ) );

		$wps_response = wp_remote_get(
			$query,
			array(
				'timeout'    => 20,
				'sslverify'  => false,
				'user-agent' => 'Ultimate Woocommerce Gift Cards/' . $this->version,
			)
		);

		$license_data = json_decode( wp_remote_retrieve_body( $wps_response ) );
		
		if ( isset( $license_data ) && ! empty( $license_data ) ) {
			if ( isset( $license_data->result ) && 'success' === $license_data->result && isset( $license_data->status ) && 'active' === $license_data->status ) {

				update_option( 'wps_gw_lcns_key', $wps_license_key );
				update_option( 'wps_gw_lcns_status', 'true' );


				update_option( 'wps_gc_pro_valid_license', true );
				//Subscription Code
				if( isset( $license_data->subscr_status ) ){
					if ( 'on-hold' === $license_data->subscr_status || 'cancelled' === $license_data->subscr_status ) {
						update_option( 'wps_gc_pro_subscription_status', true );
					}
					else {
						update_option( 'wps_gc_pro_subscription_status', false );
					}
 
 
					$today_date = date( 'Y-m-d', strtotime('now') );
					$reminder_date = date( 'Y-m-d', strtotime('-5 days', strtotime($license_data->date_renewed)));
 
 
					if( 'pending-cancel' === $license_data->subscr_status && ( $today_date >= $reminder_date && $today_date < $license_data->date_renewed ) ){
						update_option( 'wps_gc_pro_subscription_renewdate', $license_data->date_renewed );
					}
					else{
						delete_option( 'wps_gc_pro_subscription_renewdate' );
					}
				}
			} else {
	
				delete_option( 'wps_gw_lcns_key' );
				update_option( 'wps_gw_lcns_status', 'false' );
				////////////////////////////////////////////////////			
				delete_option( 'wps_gc_pro_valid_license', true );
				/////////////////////////////////////////////////////
			}
		}
	}

	/**
	 * This function is used to add meta box on order detail page
	 *
	 * @name wps_uwgc_order_edit_meta_box
	 * @param String $post_type Contains post type.
	 * @param object $post Contains Post .
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_order_edit_meta_box( $post_type, $post ) {

		$woo_ver = WC()->version;
		global $post;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$post_id = isset( $_GET['id'] ) ? sanitize_text_field( wp_unslash( $_GET['id'] ) ) : '';
			$post_type = OrderUtil::get_order_type( $post_id );
			if ( empty( $post_type ) && ! empty( $post_id ) ) {
				$post_type = get_post( $post_id )->post_type;
			}
		} else {
			$post_id = $post->ID;
			$post_type = get_post( $post_id )->post_type;
		}
		if ( isset( $post_id ) && 'shop_order' == $post_type ) {
			$order_id = $post_id;
			$order = new WC_Order( $order_id );
			$order_status = $order->get_status();

			if ( 'completed' == $order_status || 'processing' == $order_status ) {
				$giftcard = false;
				foreach ( $order->get_items() as $item_id => $item ) {
					if ( $woo_ver < '3.0.0' ) {
						$_product = apply_filters( 'woocommerce_order_item_product', $order->get_product_from_item( $item ), $item );
					} else {
						$_product = apply_filters( 'woocommerce_order_item_product', $item->get_product(), $item );
					}
					if ( isset( $_product ) && ! empty( $_product ) ) {
						$product_id = $_product->get_id();
					}
					if ( isset( $product_id ) && ! empty( $product_id ) ) {
						$product_types = wp_get_object_terms( $product_id, 'product_type' );

						$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
						if ( isset( $product_types[0] ) || 'on' === $wps_gift_product ) {
							$product_type = isset( $product_types[0] ) ? $product_types[0]->slug : '';
							
							if ( 'wgm_gift_card' == $product_type || 'on' == $wps_gift_product ) {
								$giftcard = true;
							}
						}
					}
					$item_meta_data = $item->get_meta_data();
					foreach ( $item_meta_data as $key => $value ) {
						if ( isset( $value->key ) && 'To' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$to = $value->value;
						}
					}
					if ( ! empty( $to ) ) {
						$recipients = preg_split('/[\s,]+/', $to, -1, PREG_SPLIT_NO_EMPTY);
					}
				}

				if ( $giftcard ) {
					$shop_order_screen = wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
					? wc_get_page_screen_id( 'shop-order' )
					: 'shop_order';

					add_meta_box( 'wps_uwgc_resend_mail', __( 'Resend Gift Card Mail', 'giftware' ), array( $this, 'wps_uwgc_resend_mail' ), $shop_order_screen, 'normal', 'core' );
					$is_group_product = get_post_meta($product_id , 'wps_wgm_is_group_gift', true );
					if ($is_group_product){
						add_meta_box(
							'suborder_order_meta_box', // Unique ID.
							'Sub-Orders', // Title.
							array( $this, 'wps_gift_display_custom_order_meta_box' ), // Callback function.
							$shop_order_screen, // Screen.
							'normal', // Context.
							'high' // Priority.
						);
					}
					
					if ( isset( $recipients ) && count( $recipients ) == 1 ) {
						add_meta_box( 'wps_uwgc_resend_coupon_add_more', __( 'Resend Gift Card by changing amount', 'giftware' ), array( $this, 'wps_uwgc_resend_coupon_add_more' ), $shop_order_screen );

						add_meta_box( 'wps_uwgc_edit_email_address', __( 'Edit Email Address', 'giftware' ), array( $this, 'wps_uwgc_edit_email_address' ), $shop_order_screen );
					}
					
				}
			}
		}
	}
	/**
	 * This function is used to add resend email button on order detal page
	 *
	 * @name wps_uwgc_resend_mail
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_mail() {
		global $post;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$post_id = isset( $_GET['id'] ) ? sanitize_text_field( wp_unslash( $_GET['id'] ) ) : '';
		} else {
			$post_id = $post->ID;
		}
		if ( isset( $post_id ) ) {
			$order_id = $post_id;
			?>
			<div id="wps_wgm_loader" style="display: none;">
				<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
			</div>
			<p><?php esc_html_e( 'If the user is not received a Gift Cards email then resend mail.', 'giftware' ); ?> </p>
			<p id="wps_uwgc_resend_mail_notification"></p>
			<input type="button" data-id="<?php echo esc_html( $order_id ); ?>" id="wps_uwgc_resend_mail_button" class="button button-primary" value="<?php esc_html_e( 'Resend Mail', 'giftware' ); ?>">
			<?php
		}
	}

	/**
	 * This is used to add html for adding more amount to coupon
	 *
	 * @name wps_uwgc_resend_coupon_add_more
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_coupon_add_more() {
		global $post;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$post_id = isset( $_GET['id'] ) ? sanitize_text_field( wp_unslash( $_GET['id'] ) ) : '';
		} else {
			$post_id = $post->ID;
		}
		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();

		$general_setting = get_option( 'wps_wgm_general_settings', array() );

		$selected_date = $wps_admin_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_enable_selected_format' );

		if ( isset( $post_id ) ) {
			$order_id = $post_id;
			$order = wc_get_order( $order_id );
			$select_coupon = array();
			$woo_ver = WC()->version;
			foreach ( $order->get_items() as $item_id => $item ) {
				if ( $woo_ver < '3.0.0' ) {
					$product = $order->get_product_from_item( $item );
					$product_title = $product->post->post_title;
					$product_id = $product->id;
				} else {
					$product = $item->get_product();
					$product_title = $product->get_name();
					$product_id = $product->get_id();
				}
				$giftcoupon = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
				if ( empty( $giftcoupon ) ) {
					$giftcoupon = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$product_id", true );
				}
				if ( is_array( $giftcoupon ) && ! empty( $giftcoupon ) ) {
					foreach ( $giftcoupon as $key => $value ) {
						$coupon = new WC_Coupon( $value );
						$today = date_i18n( 'Y-m-d' );
						$today = strtotime( $today );
						if ( $woo_ver < '3.0.0' ) {
							$coupon_expiry = $coupon->expiry_date;
							if ( is_string( $coupon_expiry ) ) {
								if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
									if ( 'd/m/Y' == $selected_date ) {
										$coupon_expiry = str_replace( '/', '-', $coupon_expiry );
									}
								}
								$coupon_expiry = strtotime( $coupon_expiry );
							}
							if ( null == $coupon_expiry || $today < $coupon_expiry ) {

								if ( isset( $coupon->usage_count ) && null == $coupon->usage_count && '' == $coupon->usage_count && $coupon->usage_count < 1 ) {
									$select_coupon[ $product_title . '#wps#' . $value . '#wps#' . $item_id ] = $product_title . '#wps#' . $value;
								}
							}
						} else {
							$coupon_expiry = $coupon->get_date_expires();

							if ( isset( $coupon_expiry ) && ! empty( $coupon_expiry ) ) {
								$coupon_expiry = date_format( $coupon_expiry, 'Y-m-d' );
								$coupon_expiry = strtotime( $coupon_expiry );
							}

							if ( null == $coupon_expiry || $today < $coupon_expiry ) {
								$usage_count = $coupon->get_usage_count();
								if ( isset( $usage_count ) && null == $usage_count && $usage_count < 1 ) {
									$select_coupon[ $product_title . '#wps#' . $value . '#wps#' . $item_id ] = $product_title . '#wps#' . $value;
								}
							}
						}
					}
				}
			}
			if ( ! empty( $select_coupon ) ) {
				?>
				<div id="wps_wgm_loader" style="display: none;">
					<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
				</div>
				<p><?php esc_html_e( 'You can resend the Gift Card Coupon by increasing its amount.', 'giftware' ); ?> </p>
				<p id="wps_uwgc_resend_coupon_amount_msg"></p>
				<table class="form-table">
					<tr valign="top">
						<th scope="row" class="titledesc">
							<label for="wps_uwgc_select_coupon_product"><?php esc_html_e( 'Select the product', 'giftware' ); ?>
						</label>
					</th>
					<td class="forminp forminp-text">
						<?php
						$attribute_description = __( 'Select the product coupon for changing the amount', 'giftware' );
						/* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */
						echo wp_kses_post( wc_help_tip( $attribute_description ) ); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */
						?>
						<select multiple="multiple" id="wps_uwgc_select_coupon_product" data-placeholder="<?php esc_html_e( 'Select Coupons', 'giftware' ); ?>" class="wps_uwgc_select_coupon_product wc-enhanced-select">
							<?php
							foreach ( $select_coupon as $key => $val ) {
								echo ( '<option value="' . esc_attr( $key ) . '">' . esc_attr( $val ) . '</option>' );
							}
							?>
											
						</select>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row" class="titledesc">
						<label for="wps_uwgc_inc_amount"><?php esc_html_e( 'Enter the price', 'giftware' ); ?>
					</label>
				</th>
				<td class="forminp forminp-text">
					<?php
					$attribute_description = __( 'Enter the new amount of the coupon.', 'giftware' );
					/* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */
					echo wp_kses_post( wc_help_tip( $attribute_description ) ); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */
					?>
					<input class="wc_input_price" style="" id="wps_uwgc_inc_amount" value="" placeholder="" type="text">
				</td>
			</tr>
			<tr valign="top">
				<td class="forminp forminp-text">
					<label for="wps_uwgc_inc_amount">
						<a href="javascript:void(0)" class="button" id="wps__uwgc_inc_money_coupon" data-id="<?php echo esc_html( $order_id ); ?>"><?php esc_html_e( 'Change amount and send mail', 'giftware' ); ?></a>
					</label>
				</td>
			</tr>							
		</table>
				<?php
			}
		}
	}
	/**
	 * This function is used for adding the HTML for providing another way to the Admin for editing the Email from backend, after the order has been placed successfully
	 *
	 * @name wps_uwgc_edit_email_address
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_edit_email_address() {
		global $post;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$post_id = isset( $_GET['id'] ) ? sanitize_text_field( wp_unslash( $_GET['id'] ) ) : '';
		} else {
			$post_id = $post->ID;
		}
		if ( isset( $post_id ) ) {
			$woo_ver = WC()->version;
			$order_id = $post_id;
			$order = wc_get_order( $order_id );
			$order_items = $order->get_items();
			foreach ( $order_items as $item_id => $item ) {
				if ( $woo_ver < '3.0.0' ) {
					$product = $order->get_product_from_item( $item );
				} else {
					$product = $item->get_product();
				}
				if ( $woo_ver < '3.0.0' ) {
					if ( isset( $item['item_meta']['Delivery Method'] ) && ! empty( $item['item_meta']['Delivery Method'] ) ) {
						$delivery_method = $item['item_meta']['Delivery Method'][0];
					}
				} else {
					$item_meta_data = $item->get_meta_data();
					foreach ( $item_meta_data as $key => $value ) {
						if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
							$delivery_method = $value->value;
						}
					}
				}
			}
			if ( 'Mail to recipient' == $delivery_method ) {
				?>
				<div id="wps_wgm_loader" style="display: none;">
					<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
				</div>
				<p><?php esc_html_e( 'Update recipient email address if the previous one was incorrect. Make sure to click the resend mail button once the email is successfully updated.', 'giftware' ); ?></p>
				<p id="wps_wgm_resend_confirmation_msg"></p>
				<table class="form-table">
					<tr valign="top">
						<th scope="row" class="titledesc">
							<label for="wps_uwgc_new_email"><?php esc_html_e( 'Enter the new Email', 'giftware' ); ?>
						</label>
					</th>
					<td class="forminp forminp-text">
						<input type="email" class="wps_uwgc_new_email" id="wps_uwgc_new_email">
					</td>
				</tr>
				<tr valign="top">
					<td class="forminp forminp-text">
						<label for="wps_uwgc_update_item_meta">
							<a href="javascript:void(0)" class="button button-primary" id="wps_uwgc_update_item_meta" data-id="<?php echo esc_html( $order_id ); ?>"><?php esc_html_e( 'Update Email', 'giftware' ); ?></a>
						</label>
					</td>
				</tr>							
			</table>
				<?php
			}
		}
	}

	/**
	 * This function is used for Resend Mail for giftcard on order edit page
	 *
	 * @name wps_uwgc_resend_mail_order_edit
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_mail_order_edit() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$this->wps_common_fun->wps_uwgc_resend_mail_common_function();
	}

	/**
	 * This function is used for Resend Mail for offline giftcard
	 *
	 * @name wps_uwgc_offline_resend_mail
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_offline_resend_mail() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$response['result'] = false;
		$response['message'] = esc_html( 'Mail sending failed due to some issue. Please try again.', 'giftware' );
		global $wpdb;
		$offline_orderid = isset( $_POST['id'] ) ? sanitize_text_field( wp_unslash( $_POST['id'] ) ) : '';
		$table_name = $wpdb->prefix . 'offline_giftcard';
		$query = "SELECT * FROM $table_name WHERE `id`=$offline_orderid";
		$giftresults = $wpdb->get_results( $query, ARRAY_A );
		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$wps_obj = new Woocommerce_Gift_Cards_Common_Function();
		$giftcard_pdf_prefix = $wps_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_pdf_prefix' );
		$selected_date = $wps_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$mail_settings = get_option( 'wps_wgm_mail_settings', array() );

		$senddatetime = '';
		if ( isset( $giftresults[0] ) ) {
			$giftresult = $giftresults[0];
			if ( isset( $giftresult['mail'] ) && null == $giftresult['mail'] && 1 !== $giftresult['mail'] ) {

				$schedule_date = $giftresult['schedule'];

				if ( is_string( $schedule_date ) ) {
					if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
						if ( 'd/m/Y' == $selected_date ) {
							$schedule_date = str_replace( '/', '-', $schedule_date );
						}
					}
					$senddatetime = strtotime( $schedule_date );
				}
				$senddate = date_i18n( 'Y-m-d', $senddatetime );
				$todaytime = time();
				$todaydate = date_i18n( 'Y-m-d', $todaytime );
				$senddatetime = strtotime( "$senddate" );
				$todaytime = strtotime( "$todaydate" );
				$giftdiff = $senddatetime - $todaytime;
				if ( $giftdiff > 0 ) {
					$response['result'] = false;
					$response['message'] = __( 'Mail does not send as the scheduled date is not reached.', 'giftware' );
					echo json_encode( $response );
					wp_die();
				} else {
					$couponcreated = $this->wps_common_fun->wps_uwgc_create_offline_gift_coupon( $giftresult['coupon'], $giftresult['amount'], $offline_orderid, $giftresult['template'], $giftresult['to'] );
				}
			}
			$woo_ver = WC()->version;
			$product_id = $giftresult['template'];
			$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing', true );
			$templateid = $wps_wgm_pricing['template'];
			if ( is_array( $templateid ) && array_key_exists( 0, $templateid ) ) {
				$temp = $templateid[0];
			} else {
				$temp = $templateid;
			}

			$args['from'] = $giftresult['from'];
			$args['to'] = $giftresult['to'];
			$args['created_date'] = $giftresult['date'];
			$args['message'] = stripcslashes( $giftresult['message'] );
			$args['coupon'] = apply_filters( 'wps_wgm_qrcode_coupon', $giftresult['coupon'] );
			$to = $args['to'];
			$from = $args['from'];
			$couponcode = $giftresult['coupon'];
			$coupon = new WC_Coupon( $couponcode );

			if ( $woo_ver < '3.0.0' ) {
				$coupon_id = $coupon->id;

			} else {
				$coupon_id = $coupon->get_id();
			}
			if ( isset( $coupon_id ) ) {
				if ( $woo_ver < '3.0.0' ) {
					$expirydate = $coupon->expiry_date;
					if ( is_string( $expirydate ) ) {
						if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
							if ( 'd/m/Y' == $selected_date ) {
								$expirydate = str_replace( '/', '-', $expirydate );
							}
						}

						$expirydate = strtotime( $expirydate );
					}
				} else {
					$expirydate = $coupon->get_date_expires();
					if (!empty($expirydate) ){
						$expirydate = date_format( $expirydate, 'Y-m-d' );
						$expirydate = strtotime( $expirydate );
					}
					
				}

				if ( empty( $expirydate ) ) {
					$expirydate_format = __( 'No Expiration', 'giftware' );
				} else {
					$selected_date = $wps_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );

					if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
						$selected_date = $this->wps_common_fun->wps_uwgc_selected_date_format( $selected_date );
						$expirydate_format = date_i18n( $selected_date, $expirydate );
					} else {
						$expirydate_format = date_format( $expirydate_format, 'jS M Y' );
					}
				}
				$args['expirydate'] = $expirydate_format;
				$args['amount'] = wc_price( $giftresult['amount'] );
				$args['templateid'] = $temp;
				$args['product_id'] = $product_id;
				$args['send_date']  = $giftresult['schedule'];

				$message = $wps_obj->wps_wgm_create_gift_template( $args );
				$wps_uwgc_pdf_enable = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_pdf_enable' );
				if ( isset( $wps_uwgc_pdf_enable ) && 'on' == $wps_uwgc_pdf_enable ) {
					$site_name = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
					$time = time();
					$this->wps_common_fun->wps_uwgc_attached_pdf( $message, $site_name, $time, '', $couponcode );
					if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
						$attachments = array( wp_upload_dir()['basedir'] . '/giftcard_pdf/' . $giftcard_pdf_prefix . $couponcode . '.pdf' );
					} else {
						$attachments = array( wp_upload_dir()['basedir'] . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
					}
				} else {
					$attachments = array();
				}
				$subject = $wps_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_giftcard_subject' );
				$bloginfo = get_bloginfo();
				if ( empty( $subject ) || ! isset( $subject ) ) {

					$subject = "$bloginfo:";
					$subject .= __( ' Hurry!!! Gift Card is Received', 'giftware' );
				}
				$subject = str_replace( '[SITENAME]', $bloginfo, $subject );
				$subject = str_replace( '[FROM]', $from, $subject );
				$subject = stripcslashes( $subject );
				$subject = html_entity_decode( $subject, ENT_QUOTES, 'UTF-8' );
				// Send mail to Receiver.
				$wps_wgc_bcc_enable = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable' );
				$wps_bcc_to_admin_enable = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable_for_site_admin' );
				if ( isset( $wps_wgc_bcc_enable ) && 'on' == $wps_wgc_bcc_enable ) {
					$headers[] = 'Bcc:' . $from;
					if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
						$headers[] = 'Bcc:' . get_option( 'admin_email' );
					}
					wc_mail( $to, $subject, $message, $headers, $attachments );
					if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
						unlink( wp_upload_dir()['basedir'] . '/giftcard_pdf/' . $giftcard_pdf_prefix . $couponcode . '.pdf' );
					} elseif ( isset( $time ) && isset( $site_name ) && ! empty( $time ) && ! empty( $site_name ) ) {
						unlink( wp_upload_dir()['basedir'] . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
					}
				} else {
					$headers = array( 'Content-Type: text/html; charset=UTF-8' );
					if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
						$headers[] = 'Bcc:' . get_option( 'admin_email' );
					}
					wc_mail( $to, $subject, $message, $headers, $attachments );
					if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
						unlink( wp_upload_dir()['basedir'] . '/giftcard_pdf/' . $giftcard_pdf_prefix . $couponcode . '.pdf' );
					} elseif ( isset( $time ) && isset( $site_name ) && ! empty( $time ) && ! empty( $site_name ) ) {
						unlink( wp_upload_dir()['basedir'] . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
					}
				}

				$subject = $wps_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_receive_subject' );
				$subject = str_replace( '[TO]', $to, $subject );
				$message = $wps_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_receive_message' );
				if ( empty( $subject ) || ! isset( $subject ) ) {

					$subject = "$bloginfo:";
					$subject .= __( ' Gift Card is Sent Successfully', 'giftware' );
				}

				if ( empty( $message ) || ! isset( $message ) ) {

					$message = "$bloginfo:";
					$message .= __( ' Gift Card is Sent Successfully to the Email Id: [TO]', 'giftware' );
				}

				$message = stripcslashes( $message );
				$message = str_replace( '[TO]', $to, $message );
				$subject = stripcslashes( $subject );

				// send acknowledge mail to sender.

				$wps_wgm_disable_buyer_notification = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_disable_buyer_notification' );
				if ( 'on' !== $wps_wgm_disable_buyer_notification ) {
					wc_mail( $from, $subject, $message );
				}
				$data_to_update = array( 'mail' => 1 );
				$where = array( 'id' => $offline_orderid );
				$update_data = $wpdb->update( $table_name, $data_to_update, $where );
				$response['result'] = true;
				$response['message'] = __( 'Mail Sent Successfully.', 'giftware' );
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * This function is used for resend change coupon amount on order edit page.
	 *
	 * @name wps_uwgc_resend_coupon_amount
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_coupon_amount() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$response['result'] = false;
		$response['message'] = __( 'Mail sending failed due to some issue. Please try again.', 'giftware' );
		$woo_ver = WC()->version;

		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
		$general_setting = get_option( 'wps_wgm_general_settings', array() );
		$selected_date = $wps_admin_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_enable_selected_format' );
		$giftcard_pdf_prefix = $wps_admin_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_pdf_prefix' );

		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$delivery_settings = get_option( 'wps_wgm_delivery_settings', array() );

		$mail_template_settings = get_option( 'wps_wgm_mail_settings', array() );
		if ( isset( $_POST['order_id'] ) && ! empty( $_POST['order_id'] ) ) {
			$order_id = isset( $_POST['order_id'] ) ? sanitize_text_field( wp_unslash( $_POST['order_id'] ) ) : '';
			$coupon_arr = isset( $_POST['selectedcoupon'] ) ? map_deep( wp_unslash( $_POST['selectedcoupon'] ), 'sanitize_text_field' ) : '';
			$new_price = isset( $_POST['selectedprice'] ) ? sanitize_text_field( wp_unslash( $_POST['selectedprice'] ) ) : '';
			foreach ( $coupon_arr as $key => $value ) {

				$coupon_arr_detail = explode( '#wps#', $value );
				$coupon_details = new WC_Coupon( $coupon_arr_detail[1] );
				if ( $woo_ver < '3.0.0' ) {
					$coupon_id = $coupon_details->id;
				} else {
					$coupon_id = $coupon_details->get_id();
				}
				update_post_meta( $coupon_id, 'coupon_amount', $new_price );
				$order = new WC_Order( $order_id );
				$order_items = $order->get_items();

				foreach ( $order_items as $item_id => $item ) {
					if ( $coupon_arr_detail[2] == $item_id ) {
						$mailsend = false;
						$woo_ver = WC()->version;
						$gift_img_name = '';
						if ( $woo_ver < '3.0.0' ) {
							$product = $order->get_product_from_item( $item );
							if ( isset( $item['item_meta']['To'] ) && ! empty( $item['item_meta']['To'] ) ) {
								$mailsend = true;
								$to = $item['item_meta']['To'][0];
							}
							if ( isset( $item['item_meta']['To Name'] ) && ! empty( $item['item_meta']['To Name'] ) ) {
								$mailsend = true;
								$to_name = $item['item_meta']['To Name'][0];
							}
							if ( isset( $item['item_meta']['From'] ) && ! empty( $item['item_meta']['From'] ) ) {
								$mailsend = true;
								$from = $item['item_meta']['From'][0];
							}
							if ( isset( $item['item_meta']['Image'] ) && ! empty( $item['item_meta']['Image'] ) ) {
								$mailsend = true;
								$gift_img_name = $item['item_meta']['Image'][0];
							}
							if ( isset( $item['item_meta']['Message'] ) && ! empty( $item['item_meta']['Message'] ) ) {
								$mailsend = true;
								$gift_msg = $item['item_meta']['Message'][0];
							}
							if ( isset( $item['item_meta']['Delivery Method'] ) && ! empty( $item['item_meta']['Delivery Method'] ) ) {
								$mailsend = true;
								$delivery_method = $item['item_meta']['Delivery Method'][0];
							}
							if ( isset( $item['item_meta']['Selected Template'] ) && ! empty( $item['item_meta']['Selected Template'] ) ) {
								$mailsend = true;
								$selected_template = $item['item_meta']['Selected Template'][0];
							}
							if ( ! isset( $to ) && empty( $to ) ) {
								if ( 'Mail to recipient' == $delivery_method ) {
									$to = $order->billing_email();
								} else {
									$to = '';
								}
							}
						} else {

							$product = $item->get_product();
							$item_meta_data = $item->get_meta_data();
							foreach ( $item_meta_data as $key => $value ) {
								if ( isset( $value->key ) && 'To' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$to = $value->value;
								}
								if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$to_name = $value->value;
								}
								if ( isset( $value->key ) && 'From' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$from = $value->value;
								}
								if ( isset( $value->key ) && 'Image' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$gift_img_name = $value->value;
								}
								if ( isset( $value->key ) && 'Message' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$gift_msg = $value->value;
								}
								if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$gift_date = $value->value;
								}
								if ( isset( $value->key ) && 'Send Time' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$gift_time = $value->value;
								}
								if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$delivery_method = $value->value;
								}
								if ( isset( $value->key ) && 'Selected Template' == $value->key && ! empty( $value->value ) ) {
									$mailsend = true;
									$selected_template = $value->value;
								}
							}
							if ( ! isset( $to ) && empty( $to ) ) {
								if ( 'Mail to recipient' == $delivery_method ) {
									$to = $order->get_billing_email();
								} else {
									$to = '';
								}
							}
						}
						if ( $mailsend ) {
							$gift_order = true;
							if ( $woo_ver < '3.0.0' ) {
								$product_id = $product->id;
							} else {
								$product_id = $product->get_id();
							}
							$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
							if ( empty( $gift_couponnumber ) ) {
								$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$product_id", true );
							}
							foreach ( $gift_couponnumber as $coupon_key => $coupon_val ) {
								$the_coupon = new WC_Coupon( $coupon_val );
								if ( $woo_ver < '3.0.0' ) {
									$expiry_date_timestamp = $the_coupon->expiry_date;
									$couponamont = $the_coupon->coupon_amount;
								} else {
									$expiry_date_timestamp = $the_coupon->get_date_expires();
									if ( isset( $expiry_date_timestamp ) && ! empty( $expiry_date_timestamp ) ) {

										$expiry_date_timestamp = date_format( $expiry_date_timestamp, 'Y-m-d' );
										$expiry_date_timestamp = strtotime( $expiry_date_timestamp );
									}
									$couponamont = $the_coupon->get_amount();
								}
								if ( empty( $expiry_date_timestamp ) ) {
									$expirydate_format = __( 'No Expiration', 'giftware' );
								} else {
									$expirydate = date_i18n( 'Y-m-d', $expiry_date_timestamp );

									$expirydate_format = date_create( $expirydate );

									if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
										$selected_date = $this->wps_common_fun->wps_uwgc_selected_date_format( $selected_date );
										$expirydate_format = date_i18n( $selected_date, $expiry_date_timestamp );

									} else {
										$expirydate_format = date_format( $expirydate_format, 'jS M Y' );
									}
								}
								if ( $woo_ver < '3.0.0' ) {
									$wps_wgm_pricing = get_post_meta( $product->id, 'wps_wgm_pricing', true );
								} else {
									$wps_wgm_pricing = get_post_meta( $product->get_id(), 'wps_wgm_pricing', true );
								}
								$templateid = $wps_wgm_pricing['template'];
								if ( is_array( $templateid ) && array_key_exists( 0, $templateid ) ) {
									$temp = $templateid[0];
								} else {
									$temp = $templateid;
								}
								$currenttime = time();
								$args['from'] = $from;
								$args['to'] = isset( $to_name ) ? $to_name : $to;
								$args['message'] = stripcslashes( $gift_msg );
								$args['coupon'] = apply_filters( 'wps_wgm_qrcode_coupon', $coupon_val );
								$args['expirydate'] = $expirydate_format;
								$args['amount'] = wc_price( $couponamont );
								$args['templateid'] = isset( $selected_template ) && ! empty( $selected_template ) ? $selected_template : $temp;
								$args['product_id'] = $product_id;
								$args['send_date']  = $gift_date;

								$browse_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_other_setting_browse' );

								if ( 'on' == $browse_enable ) {

									if ( '' !== $gift_img_name ) {

										$args['browse_image'] = $gift_img_name;
									}
								}

								// Update the array according to the Customized giftcard.
								$updated_arr = apply_filters( 'wps_wgm_resend_mail_arr_update', $args, $item );

								$message = apply_filters( 'wps_wgm_customizable_email_template', $wps_admin_obj->wps_wgm_create_gift_template( $args ), $updated_arr );

								$wps_uwgc_pdf_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_pdf_enable' );

								if ( isset( $wps_uwgc_pdf_enable ) && 'on' == $wps_uwgc_pdf_enable ) {
								
									$site_name = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
									$time = time();
									$this->wps_common_fun->wps_uwgc_attached_pdf( $message, $site_name, $time, $order_id, $coupon_val );
									if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
										$attachments = array( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $coupon_val . '.pdf' );
									} else {
										$attachments = array( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
									}
								} else {
									$attachments = array();
								}

								$get_mail_status = true;
								$get_mail_status = apply_filters( 'wps_send_mail_status', $get_mail_status );

								if ( $get_mail_status ) {

									if ( isset( $delivery_method ) && 'Mail to recipient' == $delivery_method ) {
										$subject = $wps_admin_obj->wps_wgm_get_template_data( $mail_template_settings, 'wps_wgm_mail_setting_giftcard_subject' );
									}
									if ( isset( $delivery_method ) && 'Downloadable' == $delivery_method ) {
										$subject = $wps_admin_obj->wps_wgm_get_template_data( $mail_template_settings, 'wps_wgm_mail_setting_giftcard_subject_downloadable' );
									}
									if ( isset( $delivery_method ) && 'shipping' == $delivery_method ) {
										$subject = $wps_admin_obj->wps_wgm_get_template_data( $mail_template_settings, 'wps_wgm_mail_setting_giftcard_subject_shipping' );

									}
									$bloginfo = get_bloginfo();
									if ( empty( $subject ) || ! isset( $subject ) ) {

										$subject = "$bloginfo:";
										$subject .= __( ' Hurry!!! Gift Card is Received', 'giftware' );
									}
									$subject = str_replace( '[SITENAME]', $bloginfo, $subject );
									$subject = str_replace( '[FROM]', $from, $subject );
									$subject = str_replace( '[ORDERID]', $order_id, $subject );
									$subject = html_entity_decode( $subject, ENT_QUOTES, 'UTF-8' );
									if ( isset( $delivery_method ) ) {

										if ( 'Mail to recipient' == $delivery_method ) {
											$woo_ver = WC()->version;
											if ( $woo_ver < '3.0.0' ) {
												$from = $order->billing_email;
											} else {
												$from = $order->get_billing_email();
											}
										}
										if ( 'Downloadable' == $delivery_method ) {
											$woo_ver = WC()->version;
											if ( $woo_ver < '3.0.0' ) {
												$to = $order->billing_email;
											} else {
												$to = $order->get_billing_email();
											}
										}
										if ( 'shipping' == $delivery_method ) {
											$admin_email = get_option( 'admin_email' );
											$wps_change_admin_email = $wps_admin_obj->wps_wgm_get_template_data( $delivery_settings, 'wps_wgm_change_admin_email_for_shipping' );
											$alternate_email = ! empty( $wps_change_admin_email ) ? $wps_change_admin_email : $admin_email;
											$to = $alternate_email;
										}
									}
									$wps_uwgc_bcc_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable' );
									$wps_bcc_to_admin_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable_for_site_admin' );
									if ( isset( $wps_uwgc_bcc_enable ) && 'on' == $wps_uwgc_bcc_enable ) {
										$headers[] = 'Bcc:' . $from;
										if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
											$headers[] = 'Bcc:' . get_option( 'admin_email' );
										}
										wc_mail( $to, $subject, $message, $headers, $attachments );
										if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
											unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $coupon_val . '.pdf' );
										} elseif ( isset( $time ) && isset( $site_name ) && ! empty( $time ) && ! empty( $site_name ) ) {
											unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
										}
									} else {
										$headers = array( 'Content-Type: text/html; charset=UTF-8' );
										if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
											$headers[] = 'Bcc:' . get_option( 'admin_email' );
										}
										wc_mail( $to, $subject, $message, $headers, $attachments );
										if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
											unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $coupon_val . '.pdf' );
										} elseif ( isset( $time ) && isset( $site_name ) && ! empty( $time ) && ! empty( $site_name ) ) {
											unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
										}
									}

									$subject = $wps_admin_obj->wps_wgm_get_template_data( $mail_template_settings, 'wps_wgm_mail_setting_receive_subject' );
									$subject = str_replace( '[TO]', $to, $subject );
									$message = $wps_admin_obj->wps_wgm_get_template_data( $mail_template_settings, 'wps_wgm_mail_setting_receive_message' );

									if ( empty( $subject ) || ! isset( $subject ) ) {

										$subject = "$bloginfo:";
										$subject .= __( ' Gift Card is Sent Successfully', 'giftware' );
									}

									if ( empty( $message ) || ! isset( $message ) ) {

										$message = "$bloginfo:";
										$message .= __( ' Gift Card is Sent Successfully to the Email Id: [TO]', 'giftware' );
									}

									$message = stripcslashes( $message );
									$message = str_replace( '[TO]', $to, $message );
									$subject = stripcslashes( $subject );

									$disable_buyer_notification = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_disable_buyer_notification' );

									if ( 'on' !== $disable_buyer_notification && 'Mail to recipient' == $delivery_method ) {
										wc_mail( $from, $subject, $message );
									}
								}
								$response['result'] = true;
								$response['message'] = __( 'Coupon amount is changed and Mail is Successfully Send.', 'giftware' );
								break;
							}
						}
					}
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * This function is used for updating the Order_Item Meta for sending the gift card to the updated email id.
	 *
	 * @name wps_uwgc_update_item_meta_with_new_email
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_update_item_meta_with_new_email() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$response['result'] = false;
		$response['message'] = __( 'Mail sending failed due to some issue. Please try again.', 'giftware' );
		$woo_ver = WC()->version;
		if ( isset( $_POST['order_id'] ) && ! empty( $_POST['order_id'] ) && isset( $_POST['new_email_id'] ) && ! empty( $_POST['new_email_id'] ) ) {
			$correct_email_format = isset( $_POST['correct_email_format'] ) ? sanitize_text_field( wp_unslash( $_POST['correct_email_format'] ) ) : '';
			if ( 'true' == $correct_email_format ) {
				$order_id = sanitize_text_field( wp_unslash( $_POST['order_id'] ) );
				$new_email_id = sanitize_text_field( wp_unslash( $_POST['new_email_id'] ) );
				$order = wc_get_order( $order_id );
				$order_items = $order->get_items();
				foreach ( $order_items as $item_id => $item ) {
					$product = $order->get_product_from_item( $item );
					$product_id = $product->get_id();
					wc_update_order_item_meta( $item_id, 'To', $new_email_id );

					// Update the recipient email for "Check the Balance of Gift Card".
					$giftcoupon = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
					if ( is_array( $giftcoupon ) && ! empty( $giftcoupon ) ) {
						foreach ( $giftcoupon as $key => $value ) {
							$the_coupon = new WC_Coupon( $value );
							$coupon_id = $the_coupon->get_id();
							update_post_meta( $coupon_id, 'wps_wgm_giftcard_coupon_mail_to', $new_email_id );
						}
					}
				}
				$response['result'] = true;
				$response['message'] = __( 'Email Id has been updated, now you may Resend your Email', 'giftware' );
			} else {
				$response['result'] = false;
				$response['message'] = __( 'Enter a valid Email Id', 'giftware' );
			}
		} else {
			$response['result'] = false;
			$response['message'] = __( 'Email field should not be empty', 'giftware' );
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * This function is used for display qrcode/barcode Image on giftcard template
	 *
	 * @name wps_uwgc_qrcode_image
	 * @param Object $coupon Contains coupon object.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_qrcode_image( $coupon ) {
		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_qrcode_settings = get_option( 'wps_wgm_qrcode_settings', array() );
		$wps_uwgc_qrcode = $wps_admin_obj->wps_wgm_get_template_data( $wps_wgm_qrcode_settings, 'wps_wgm_qrcode_enable' );
		if ( isset( $wps_uwgc_qrcode ) && 'qrcode' == $wps_uwgc_qrcode ) {
			$coupon = '<img src="' . WPS_UWGC_URL . 'assets/images/wps_qrcode.png">';

		}
		if ( isset( $wps_uwgc_qrcode ) && 'barcode' == $wps_uwgc_qrcode ) {
			$coupon = '<img src="' . WPS_UWGC_URL . 'assets/images/wps_barcode.png">';
		}
		return $coupon;
	}

	/**
	 * This function is used to show inventory tab in giftcard edit page.
	 *
	 * @name wps_uwgc_add_inventory_tab
	 * @param array $tabs Contains Tabs.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_add_inventory_tab( $tabs ) {
		if ( isset( $tabs ) && ! empty( $tabs ) ) {
			foreach ( $tabs as $key => $tab ) {
				if ( 'inventory' == $key ) {
					if ( isset( $tabs[ $key ]['class'] ) && in_array( 'hide_if_wgm_gift_card', $tabs[ $key ]['class'] ) ) {
						$index = array_search( 'hide_if_wgm_gift_card', $tabs[ $key ]['class'] );
						unset( $tabs[ $key ]['class'][ $index ] );
						array_push( $tabs[ $key ]['class'], 'show_if_wgm_gift_card' );
					}
				}
			}
		}
		return $tabs;
	}

	/**
	 * This function is used to Add custom css on Email Template.
	 *
	 * @name wps_uwgc_custom_template_css
	 * @param Strings $template_css Contains template css .
	 * @param int     $template_id Contains template id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_custom_template_css( $template_css, $template_id ) {
		if ( isset( $template_id ) && ! empty( $template_id ) ) {
			$custom_css = get_post_meta( $template_id, 'wps_css_field', true );
			if ( isset( $custom_css ) && ! empty( $custom_css ) ) {
				$template_css = $custom_css;
			}
		}
		return $template_css;
	}

	/**
	 * This function is used to add the manual increment option inside the Coupon Section.
	 *
	 * @name wps_uwgc_manual_increment_usage_count
	 * @param int    $coupon_id Contains coupon id.
	 * @param Object $coupon Contains coupon object.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_manual_increment_usage_count( $coupon_id, $coupon ) {

		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_uwgc_other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_uwgc_manual_inc = $wps_admin_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_manually_increment_usage' );

		if ( isset( $wps_uwgc_manual_inc ) && 'on' == $wps_uwgc_manual_inc ) {

			woocommerce_wp_text_input(
				array(
					'id'                => 'manually_increment_usage',
					'label'             => __( 'Manually Increment Usage', 'giftware' ),
					'placeholder'       => esc_attr__( 'Increment Usage', 'giftware' ),
					'description'       => __( 'Number of times coupon has been used', 'giftware' ),
					'type'              => 'number',
					'desc_tip'          => true,
					'class'             => 'short',
					'custom_attributes' => array(
						'step'  => 1,
						'min'   => 0,
					),
					'value' => $coupon->get_usage_count() ? $coupon->get_usage_count() : 0,
				)
			);
		}
		wp_nonce_field( 'wps_uwgc_nonce_on_increment', 'manual_increment_nonce' );
	}

	/**
	 * This function is used to add/update the usage count (manual increment) manually.
	 *
	 * @name wps_uwgc_save_coupon_manual_usage_count
	 * @param int $coupon_id Contains coupon id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_save_coupon_manual_usage_count( $coupon_id ) {
		if ( ! isset( $_POST['manual_increment_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['manual_increment_nonce'] ) ), 'wps_uwgc_nonce_on_increment' ) ) {
			return;
		}
		if ( isset( $_POST['manually_increment_usage'] ) && ! empty( $_POST['manually_increment_usage'] ) ) {
			$wps_uwgc_manual_value = sanitize_text_field( wp_unslash( $_POST['manually_increment_usage'] ) );
			update_post_meta( $coupon_id, 'usage_count', $wps_uwgc_manual_value );
		}
	}

	/**
	 * This function is used for adding the  dropdown for filterization for Offline,Online, and Imported Coupons
	 *
	 * @name wps_uwgc_manage_coupon_type
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_manage_coupon_type() {
		global $typenow;
		global $post;
		if ( 'shop_coupon' == $typenow ) {
			$wps_uwgc_online_giftcards = false;
			$wps_uwgc_offline_giftcards = false;
			$wps_uwgc_imported_coupon = false;
			if ( isset( $_GET['wps_uwgc_coupon_type'] ) ) {
				if ( 'online' == $_GET['wps_uwgc_coupon_type'] ) {
					$wps_uwgc_online_giftcards = true;
				} elseif ( 'offline' == $_GET['wps_uwgc_coupon_type'] ) {
					$wps_uwgc_offline_giftcards = true;
				} elseif ( 'importedcoupon' == $_GET['wps_uwgc_coupon_type'] ) {
					$wps_uwgc_imported_coupon = true;
				}
			}
			?>
				
			 <select name="wps_uwgc_coupon_type" id="wps_uwgc_dropdown_shop_coupon_type">
				<?php
				$online_selected = '';
				$offline_selected = '';
				$imported_selected = '';
				if ( $wps_uwgc_online_giftcards ) {
					$online_selected = " selected='selected'";
				} elseif ( $wps_uwgc_offline_giftcards ) {
					$offline_selected = " selected='selected'";
				} elseif ( $wps_uwgc_imported_coupon ) {
					$imported_selected = " selected='selected'";
				}
				?>
				 <option><?php esc_html_e( 'Select Gift Cards', 'giftware' ); ?></option>
				 <option value="online" <?php echo esc_attr( $online_selected ); ?> ><?php esc_html_e( 'Online Gift Cards', 'giftware' ); ?></option>
				 <option value="offline" <?php echo esc_attr( $offline_selected ); ?> ><?php esc_html_e( 'Offline Gift Cards', 'giftware' ); ?></option>
				 <option value="importedcoupon" <?php echo esc_attr( $imported_selected ); ?> ><?php esc_html_e( 'Imported Gift Coupons', 'giftware' ); ?></option>
			 </select>
			<?php
		}
	}

	/**
	 * This function is used for handle the requested query and return the result for ONline, Off and Imported Coupons.
	 *
	 * @name wps_uwgc_request_coupon_type
	 * @param array $vars Conains the array.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_request_coupon_type( $vars ) {
		global $typenow;
		if ( 'shop_coupon' === $typenow ) {

			if ( ! empty( $_GET['wps_uwgc_coupon_type'] ) && ( 'online' == $_GET['wps_uwgc_coupon_type'] || 'offline' == $_GET['wps_uwgc_coupon_type'] ) ) {
				$vars['meta_key']   = 'wps_wgm_giftcard_coupon_unique';
				$vars['meta_value'] = wc_clean( sanitize_text_field( wp_unslash( $_GET['wps_uwgc_coupon_type'] ) ) );
			}
			if ( ! empty( $_GET['wps_uwgc_coupon_type'] ) && 'importedcoupon' == $_GET['wps_uwgc_coupon_type'] ) {
				$vars['meta_key']   = 'wps_wgm_imported_coupon';
				$vars['meta_value'] = 'yes';
			}
		}
		return $vars;
	}

	/**
	 * This function is used for hide non required data in order item.
	 *
	 * @name wps_uwgc_giftcard_hidden_order_itemmeta
	 * @param array $order_items Conains order_items.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_giftcard_hidden_order_itemmeta( $order_items ) {
		array_push( $order_items, 'Image', 'Choosen Image' );
		return $order_items;
	}

	/**
	 * This function is to add meta field like field for instruction how to use shortcode in email template.
	 *
	 * @name wps_uwgc_template_shortcode
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_template_shortcode() {
		?>
		<tr>
			<td>[FEATUREDIMAGE]</td>
			<td><?php esc_html_e( 'Replace with Featured Image on Gift Card.', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[PRODUCTNAME]</td>
			<td><?php esc_html_e( 'Replaced with Product Name having the link also', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[PRODUCT]</td>
			<td><?php esc_html_e( 'Replaced with Product Name Only.', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[ORDERID]</td>
			<td><?php esc_html_e( 'Replaced with Order ID', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[SHORTDESCRIPTION]</td>
			<td><?php esc_html_e( 'Replaced with Product Short Description', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[COUPONURL]</td>
			<td><?php esc_html_e( 'Replaced with Coupon URL( Coupon will apply to cart )', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[SCHEDULEDATE]</td>
			<td><?php esc_html_e( 'Replaced with Schedule Date.', 'giftware' ); ?></td>
		</tr>
		<tr>
			<td>[RECOMMENDEDPRODUCT]</td>
			<td><?php esc_html_e( 'Replaced with added recommended product with giftcard.', 'giftware' ); ?></td>
		</tr>
		<?php
	}

	/**
	 * Function is used to add a button for import template.
	 *
	 * @since 1.0.0
	 * @name wps_add_import_template_button().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_add_import_template_button() {
		global $typenow;
		if ( 'giftcard' == $typenow ) {
			?>
			<a href="<?php get_admin_url(); ?>edit.php?post_type=giftcard&page=uwgc-import-giftcard-templates" name="import_new_card" class="wps_import_templates button" target="_blank"><?php esc_html_e( 'Import New Templates', 'giftware' ); ?></a>
			<?php
		}
	}

	/**
	 * Function is used to add a sub menu for import template section.
	 *
	 * @since 1.0.0
	 * @name wps_wgm_import_template().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_wgm_import_template() {
		add_submenu_page( 'edit.php?post_type=giftcard', __( 'Import Templates', 'giftware' ), __( 'Import Templates', 'giftware' ), 'manage_options', 'uwgc-import-giftcard-templates', array( $this, 'wps_wgm_import_giftcard_template' ) );
	}

	/**
	 * Function is used to import giftcard template.
	 *
	 * @since 1.0.0
	 * @name wps_wgm_import_giftcard_template().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_wgm_import_giftcard_template() {
		$other_settings              = get_option( 'wps_wgm_other_settings', array() );
		$wps_obj                     = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_select_library = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );

		if ( 'mpdf' == $wps_wgm_select_library ) {
			$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/wps-get-gc-template.php';
		} else {
			$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/wps-get-gc-template.php';
		}

		$attr = array(
			'action' => 'wps_fetch_gc_template',
		);
		$query = esc_url_raw( add_query_arg( $attr, $url ) );
		$wps_response = wp_remote_get(
			$query,
			array(
				'timeout' => 20,
				'sslverify' => false,
			)
		);
		if ( is_wp_error( $wps_response ) ) {
			$error_message = $wps_response->get_error_message();
			echo '<p><strong> Something went wrong: ' . esc_html( stripslashes( $error_message ) ) . '</strong></p>';
		} else {
			$wps_response = wp_remote_retrieve_body( $wps_response );
			$template_json_data = json_decode( $wps_response, true );
		}
		?>
		<div id="wps_wgm_loader" style="display: none;">
			<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
		</div>
		<div class="wps_notice_temp" style="display:none;"> 
			<span id="wps_import_notice"></span>
			<i class="fas fa-times cancel_notice"></i>
		</div>
		<h1><?php esc_html_e( 'Import Gift Card Templates', 'giftware' ); ?></h1>
		<?php
		if ( isset( $template_json_data ) && is_array( $template_json_data ) && ! empty( $template_json_data ) ) {
			?>
		<div class="wps_uwgc_filter_wrap">
			<h2><?php esc_html_e( 'Filter Gift Card Templates', 'giftware' ); ?></h2>
			<!-- Import all template button -->
			<a href="#" name="import_all_gift_card" class="wps_import_all_giftcard_templates button"><?php esc_html_e( 'Import All Gift Card Templates At Once', 'giftware' ); ?></a>
			<a href="#" name="update_all_gift_card" class="wps_update_all_giftcard_templates button"><?php esc_html_e( 'Update All Gift Card Templates At Once', 'giftware' ); ?></a>
		</div>
		<div class="wps_uwgc_wrapper">
			<div id="filters" class="button-group wps_template_filter"> 
				 <button class="button wps_gc_events is-checked" data-filter="*">show all</button>
			<?php
			foreach ( $template_json_data as $rs ) {
				?>
			  <button class="button wps_gc_events" data-filter=".<?php echo esc_attr( stripslashes( $rs['occassion_id'] ) ); ?>"><?php echo esc_html( stripslashes( $rs['occassion_name'] ) ); ?></button>
				<?php
			}
		}
		?>
			</div>
			<?php
			if ( isset( $template_json_data ) && is_array( $template_json_data ) && ! empty( $template_json_data ) ) {
				?>
			<div id="filters_on_mobile" class="wps_template_filter"> 
			<select class="select-group wps_select_template_filter">
				<option class="wps_gc_events is-checked" value="*">show all</option>
				<?php
				foreach ( $template_json_data as $rs ) {
					?>
				<option class="wps_gc_events" value =".<?php echo esc_attr( stripslashes( $rs['occassion_id'] ) ); ?>"><?php echo esc_html( stripslashes( $rs['occassion_name'] ) ); ?></option>
					<?php
				}
				?>
			</select>
			</div>
				<?php
			}
			?>
			<div class="grid wps_template_display">
				<?php
				if ( isset( $template_json_data ) && is_array( $template_json_data ) && ! empty( $template_json_data ) ) {
					foreach ( $template_json_data as $rs ) {
						if ( array_key_exists( 'templates', $rs ) ) {
							foreach ( $rs['templates'] as $temp_data ) {
								?>
								<div class="element-item template_block <?php echo esc_attr( stripslashes( $rs['occassion_id'] ) ); ?>" data-category="template">
									<h3 class="name"><?php echo esc_html( stripslashes( $temp_data['template_name'] ) ); ?></h3>
									<div class="event_template">
										<img src="
										<?php
										if ( 'mpdf' == $wps_wgm_select_library ) {
											echo esc_url( WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/giftcard-templates/' . $temp_data['template_image'] );
										} else {
											echo esc_url( WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/giftcard-templates/' . $temp_data['template_image'] );
										}
										?>
										  ">
									</div>
									<div class="wps_event_template_preview">
										<div class="wps_preview_links">
											<a href="">
												<i class="fas fa-eye wps_preview_template"></i>
											</a>
											<?php
											$check_template_exist = $this->wps_uwgc_check_already_imported_template( $temp_data );
											if ( $check_template_exist['status'] ) {
												?>
												<i class="fas fa-cloud-upload-alt wps_update_template" data-id="<?php echo esc_attr( stripslashes( $temp_data['template_id'] ) ); ?>"></i>
												<div class="wps_template_update_note">
													<p class="wps_note"><?php esc_html_e( 'Update this template with existing one', 'giftware' ); ?></p>
													<p class="wps_note" id="wps_caution"><span style="color:black;"><strong><?php esc_html_e( 'CAUTION : ', 'giftware' ); ?></strong></span><?php esc_html_e( 'This updation will erase all your custom work on the same template and provide you with the fresh new template.', 'giftware' ); ?></p>
												</div>
												<?php
											} else {
												?>
												<i class="fas fa-download wps_download_template" data-id="<?php echo esc_attr( stripslashes( $temp_data['template_id'] ) ); ?>"></i>
												<div class="wps_template_import_note">
													<p class="wps_note"><?php esc_html_e( 'Import this template.', 'giftware' ); ?></p>
												</div>
												<?php
											}
											?>
																						
										</div>
									</div>
									<div class="wps-popup-wrapper">
										  <div class="wps-popup">
											  <div class="wps-popup-img">
												<span><i class="far fa-times-circle"></i></span>
												<img src="
												<?php
												if ( 'mpdf' == $wps_wgm_select_library ) {
													echo esc_url( WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/giftcard-templates/' . $temp_data['template_image'] );
												} else {
													echo esc_url( WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/giftcard-templates/' . $temp_data['template_image'] );
												}
												?>
												  ">
											  </div>
										  </div>
									</div>
								</div>
								<?php
							}
						}
					}
				}
				?>
			</div>
		 </div>
		<?php
	}

	/**
	 * Function is used to import selected giftcard template.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_import_selected_template().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_import_selected_template() {
		check_ajax_referer( 'wps-uwgc-giftcard-import-nonce', 'wps_nonce' );
		$wps_selected_temp_id = isset( $_POST['temp_id'] ) ? sanitize_text_field( wp_unslash( $_POST['temp_id'] ) ) : '';
		$response = false;
		if ( isset( $wps_selected_temp_id ) && '' !== $wps_selected_temp_id ) {
			$other_settings              = get_option( 'wps_wgm_other_settings', array() );
			$wps_obj                     = new Woocommerce_Gift_Cards_Common_Function();
			$wps_wgm_select_library = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );

			if ( 'mpdf' == $wps_wgm_select_library ) {
				$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/wps-get-gc-template.php';
			} else {
				$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/wps-get-gc-template.php';
			}

			$attr = array(
				'action' => 'wps_fetch_gc_template',
			);
			$query = esc_url_raw( add_query_arg( $attr, $url ) );
			$wps_response = wp_remote_get(
				$query,
				array(
					'timeout' => 20,
					'sslverify' => false,
				)
			);
			if ( is_wp_error( $wps_response ) ) {
				$error_message = $wps_response->get_error_message();
				echo '<p><strong> Something went wrong: ' . esc_html( stripslashes( $error_message ) ) . '</strong></p>';
			} else {
				$wps_response = wp_remote_retrieve_body( $wps_response );
				$wps_json_templates_data = json_decode( $wps_response, true );
			}
			if ( is_array( $wps_json_templates_data ) && ! empty( $wps_json_templates_data ) ) {
				foreach ( $wps_json_templates_data as $wps_template ) {
					if ( array_key_exists( 'templates', $wps_template ) && isset( $wps_template['templates'] ) ) {
						foreach ( $wps_template['templates'] as $wps_templates ) {
							$filename = array();
							$check_template_exist = $this->wps_uwgc_check_already_imported_template( $wps_templates );
							if ( false == $check_template_exist['status'] ) {
								if ( $wps_templates['template_id'] == $wps_selected_temp_id ) {
									foreach ( $wps_templates['template_inside_image'] as $images ) {
										if ( 'mpdf' == $wps_wgm_select_library ) {
											$filename[] = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/giftcard-templates/inside_images/' . $images;
										} else {
											$filename[] = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/giftcard-templates/inside_images/' . $images;
										}
									}
									if ( isset( $filename ) && is_array( $filename ) && ! empty( $filename ) ) {
										foreach ( $filename as $key => $value ) {
											$upload_file = wp_upload_bits( basename( $value ), null, file_get_contents( $value ) );
											if ( ! $upload_file['error'] ) {
												$filename = $upload_file['file'];
												// The ID of the post this attachment is for.
												$parent_post_id = 0;
												// Check the type of file. We'll use this as the 'post_mime_type'.
												$filetype = wp_check_filetype( basename( $filename ), null );
												// Get the path to the upload directory.
												$wp_upload_dir = wp_upload_dir();
												// Prepare an array of post data for the attachment.
												$attachment = array(
													'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ),
													'post_mime_type' => $filetype['type'],
													'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),

													'post_status'    => 'inherit',
												);
												// Insert the attachment.

												$attach_id = wp_insert_attachment( $attachment, $filename, 0 );
												// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
												require_once( ABSPATH . 'wp-admin/includes/image.php' );

												// Generate the metadata for the attachment, and update the database record.
												$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
												wp_update_attachment_metadata( $attach_id, $attach_data );
												$arr[] = $attach_id;
											}
										}
									}
									$template_html = $wps_templates['template_html'];
									$gifttemplate = array(
										'post_title' => __( $wps_templates['template_name'], 'giftware' ),
										'post_content' => $template_html,
										'post_status' => 'publish',
										'post_author' => get_current_user_id(),
										'post_type'     => 'giftcard',
									);
									$parent_post_id = wp_insert_post( $gifttemplate );
									update_post_meta( $parent_post_id, 'wps_css_field', trim( $wps_templates['template_css'] ) );
									$imported_temp = get_option( 'wps_uwgc_templateid', array() );
									if ( empty( $imported_temp ) && ! is_array( $imported_temp ) ) {
										$imported_temp = array();
									}
									$imported_temp[] = $parent_post_id;
									update_option( 'wps_uwgc_templateid', $imported_temp );
									set_post_thumbnail( $parent_post_id, $arr[0] );
									$response = true;
								}
							}
						}
					}
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * Function is used to import all giftcard template at once on button click.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_import_all_templates_at_once().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_import_all_templates_at_once() {
		check_ajax_referer( 'wps-uwgc-giftcard-import-nonce', 'wps_nonce' );
		$other_settings              = get_option( 'wps_wgm_other_settings', array() );
		$wps_obj                     = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_select_library = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );

		if ( 'mpdf' == $wps_wgm_select_library ) {
			$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/wps-get-gc-template.php';
		} else {
			$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/wps-get-gc-template.php';
		}

		$attr = array(
			'action' => 'wps_fetch_gc_template',
		);
		$query = esc_url_raw( add_query_arg( $attr, $url ) );
		$wps_response = wp_remote_get(
			$query,
			array(
				'timeout' => 20,
				'sslverify' => false,
			)
		);
		if ( is_wp_error( $wps_response ) ) {
			$error_message = $wps_response->get_error_message();
			echo '<p><strong> Something went wrong: ' . esc_html( stripslashes( $error_message ) ) . '</strong></p>';
		} else {
			$wps_response = wp_remote_retrieve_body( $wps_response );
			$gc_templates = json_decode( $wps_response, true );
		}
		$response = false;
		if ( is_array( $gc_templates ) && ! empty( $gc_templates ) ) {
			foreach ( $gc_templates as $all_templates ) {
				if ( array_key_exists( 'templates', $all_templates ) && isset( $all_templates['templates'] ) ) {
					foreach ( $all_templates['templates'] as $wps_templates ) {
						$filename = array();
						$arr = array();
						$check_template_exist = $this->wps_uwgc_check_already_imported_template( $wps_templates );
						if ( false == $check_template_exist['status'] ) {
							foreach ( $wps_templates['template_inside_image'] as $images ) {
								if ( 'mpdf' == $wps_wgm_select_library ) {
									$filename[] = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/giftcard-templates/inside_images/' . $images;
								} else {
									$filename[] = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/giftcard-templates/inside_images/' . $images;
								}
							}
							if ( isset( $filename ) && is_array( $filename ) && ! empty( $filename ) ) {
								foreach ( $filename as $key => $value ) {
									$upload_file = wp_upload_bits( basename( $value ), null, file_get_contents( $value ) );
									if ( ! $upload_file['error'] ) {
										$filename = $upload_file['file'];
										// The ID of the post this attachment is for.
										$parent_post_id = 0;
										// Check the type of file. We'll use this as the 'post_mime_type'.
										$filetype = wp_check_filetype( basename( $filename ), null );
										// Get the path to the upload directory.
										$wp_upload_dir = wp_upload_dir();
										// Prepare an array of post data for the attachment.
										$attachment = array(
											'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ),
											'post_mime_type' => $filetype['type'],
											'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),

											'post_status'    => 'inherit',
										);
										// Insert the attachment.
										$attach_id = wp_insert_attachment( $attachment, $filename, 0 );
										// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
										require_once( ABSPATH . 'wp-admin/includes/image.php' );
										// Generate the metadata for the attachment, and update the database record.
										$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
										wp_update_attachment_metadata( $attach_id, $attach_data );
										$arr[] = $attach_id;
									}
								}
							}
							$template_html = $wps_templates['template_html'];
							$gifttemplate = array(
								'post_title' => __( $wps_templates['template_name'], 'giftware' ),
								'post_content' => $template_html,
								'post_status' => 'publish',
								'post_author' => get_current_user_id(),
								'post_type' => 'giftcard',
							);
							$parent_post_id = wp_insert_post( $gifttemplate );
							update_post_meta( $parent_post_id, 'wps_css_field', trim( $wps_templates['template_css'] ) );
							$imported_temp = get_option( 'wps_uwgc_templateid', array() );
							if ( empty( $imported_temp ) && ! is_array( $imported_temp ) ) {
								$imported_temp = array();
							}
							$imported_temp[] = $parent_post_id;
							update_option( 'wps_uwgc_templateid', $imported_temp );
							set_post_thumbnail( $parent_post_id, $arr[0] );
							$response = true;
							update_option( 'wps_uwgc_all_templates_imported', 1 );
						}
					}
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * Function is used to import all giftcard template at once on button click.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_check_already_imported_template().
	 * @param String $template_name Contains template name.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_check_already_imported_template( $template_name ) {
		$post_title = $template_name['template_name'];
		$post_status = 'publish'; // publish, draft, etc.
		$post_type = 'giftcard'; // or whatever post type desired.

		/* Attempt to find post id by post name if it exists */	
		$posts = get_posts(
			array(
				'post_type'   => $post_type,
				'name'        => $post_title,
				'post_status' => $post_status,
			)
		);
		$found_post_title = isset( $posts[0] ) ? $posts[0] : null;
		$result = array();
		if ( ! is_null( $found_post_title ) ) {
			$found_post_id = $found_post_title->ID;
			if ( false === get_post_status( $found_post_id ) ) {
				$result['post_id'] = '';
				$result['status'] = false;
			} else {
				$result['post_id'] = $found_post_id;
				$result['status'] = true;
			}
		} else {
			$result['post_id'] = '';
			$result['status'] = false;
		}
		return $result;
	}
	/**
	 * Function is used to update selected giftcard template.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_update_selected_template().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_update_selected_template() {

		check_ajax_referer( 'wps-uwgc-giftcard-import-nonce', 'wps_nonce' );
		$wps_selected_temp_id = isset( $_POST['temp_id'] ) ? sanitize_text_field( wp_unslash( $_POST['temp_id'] ) ) : '';
		$response = false;
		if ( isset( $wps_selected_temp_id ) && '' !== $wps_selected_temp_id ) {
			$other_settings              = get_option( 'wps_wgm_other_settings', array() );
			$wps_obj                     = new Woocommerce_Gift_Cards_Common_Function();
			$wps_wgm_select_library = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );

			if ( 'mpdf' == $wps_wgm_select_library ) {
				$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/wps-get-gc-template.php';
			} else {
				$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/wps-get-gc-template.php';
			}

			$attr = array(
				'action' => 'wps_fetch_gc_template',
			);
			$query = esc_url_raw( add_query_arg( $attr, $url ) );
			$wps_response = wp_remote_get(
				$query,
				array(
					'timeout' => 20,
					'sslverify' => false,
				)
			);
			if ( is_wp_error( $wps_response ) ) {
				$error_message = $wps_response->get_error_message();
				echo '<p><strong> Something went wrong: ' . esc_html( stripslashes( $error_message ) ) . '</strong></p>';
			} else {
				$wps_response = wp_remote_retrieve_body( $wps_response );
				$wps_json_templates_data = json_decode( $wps_response, true );
			}
			if ( is_array( $wps_json_templates_data ) && ! empty( $wps_json_templates_data ) ) {
				foreach ( $wps_json_templates_data as $wps_template ) {
					if ( array_key_exists( 'templates', $wps_template ) && isset( $wps_template['templates'] ) ) {
						foreach ( $wps_template['templates'] as $wps_templates ) {
							if ( $wps_templates['template_id'] == $wps_selected_temp_id ) {
								$check_template_exist = $this->wps_uwgc_check_already_imported_template( $wps_templates );
								if ( true == $check_template_exist['status'] ) {
									update_post_meta( $check_template_exist['post_id'], 'wps_css_field', trim( $wps_templates['template_css'] ) );
									$updated_post = array();
									$updated_post['ID'] = $check_template_exist['post_id'];
									$updated_post['post_content'] = $wps_templates['template_html'];
									$response = wp_update_post( $updated_post );
								}
							}
						}
					}
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * Function is used to update all giftcard template at once on button click.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_update_all_templates_at_once().
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_update_all_templates_at_once() {
		check_ajax_referer( 'wps-uwgc-giftcard-import-nonce', 'wps_nonce' );
		$other_settings              = get_option( 'wps_wgm_other_settings', array() );
		$wps_obj                     = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_select_library = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );

		if ( 'mpdf' == $wps_wgm_select_library ) {
			$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/mpdf/wps-get-gc-template.php';
		} else {
			$url  = WPS_TEMPLATE_URL . 'ultimate-woocommerce-gift-card/wps-get-gc-template.php';
		}

		$attr = array(
			'action' => 'wps_fetch_gc_template',
		);
		$query = esc_url_raw( add_query_arg( $attr, $url ) );
		$wps_response = wp_remote_get(
			$query,
			array(
				'timeout' => 20,
				'sslverify' => false,
			)
		);
		if ( is_wp_error( $wps_response ) ) {
			$error_message = $wps_response->get_error_message();
			echo '<p><strong> Something went wrong: ' . esc_html( stripslashes( $error_message ) ) . '</strong></p>';
		} else {
			$wps_response = wp_remote_retrieve_body( $wps_response );
			$wps_json_templates_data = json_decode( $wps_response, true );
		}
		$response = false;
		if ( is_array( $wps_json_templates_data ) && ! empty( $wps_json_templates_data ) ) {
			foreach ( $wps_json_templates_data as $wps_template ) {
				if ( array_key_exists( 'templates', $wps_template ) && isset( $wps_template['templates'] ) ) {
					foreach ( $wps_template['templates'] as $wps_templates ) {
						$check_template_exist = $this->wps_uwgc_check_already_imported_template( $wps_templates );
						if ( true == $check_template_exist['status'] ) {
							update_post_meta( $check_template_exist['post_id'], 'wps_css_field', trim( $wps_templates['template_css'] ) );
							$updated_post = array();
							$updated_post['ID'] = $check_template_exist['post_id'];
							$updated_post['post_content'] = $wps_templates['template_html'];
							$response = wp_update_post( $updated_post );
						}
					}
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * Wps_uwgc_custom_plugin_row_meta
	 *
	 * @param array  $links links.
	 * @param string $file file.
	 */
	public function wps_uwgc_custom_plugin_row_meta( $links, $file ) {
		if ( strpos( $file, 'giftware/giftware.php' ) !== false ) {
			$new_links = array(
				'demo'    => '<a href="https://demo.wpswings.com/gift-cards-for-woocommerce-pro/?utm_source=wpswings-giftcards-demo&utm_medium=giftcards-pro-backend&utm_campaign=demo" target="_blank"><img src="' . esc_html( WPS_UWGC_URL ) . 'assets/images/Demo.svg" class="wps-info-img" alt="Demo image" style="margin-right: 5px;vertical-align: middle;max-width: 15px;">' . __( 'Demo', 'giftware' ) . '</a>',
				'doc'     => '<a href="https://docs.wpswings.com/gift-cards-for-woocommerce/?utm_source=wpswings-giftcards-doc&utm_medium=giftcards-pro-backend&utm_campaign=doc" target="_blank"><img src="' . esc_html( WPS_UWGC_URL ) . 'assets/images/Documentation.svg" class="wps-info-img" alt="Demo image" style="margin-right: 5px;vertical-align: middle;max-width: 15px;">' . __( 'Documentation', 'giftware' ) . '</a>',
				'Video'     => '<a href="https://youtu.be/7DxJcp5XvDo" target="_blank"><img src="' . esc_html( WPS_UWGC_URL ) . 'assets/images/YouTube32px.svg" class="wps-info-img" alt="Vedio image" style="margin-right: 5px;vertical-align: middle;max-width: 15px;">' . __( 'Video', 'giftware' ) . '</a>',
				'support' => '<a href="https://wpswings.com/submit-query/?utm_source=wpswings-giftcards-support&utm_medium=giftcards-pro-backend&utm_campaign=support" target="_blank"><img src="' . esc_html( WPS_UWGC_URL ) . 'assets/images/Support.svg" class="wps-info-img" alt="Demo image" style="margin-right: 5px;vertical-align: middle;max-width: 15px;">' . __( 'Support', 'giftware' ) . '</a>',
				'services' => '<a href="https://wpswings.com/woocommerce-services/?utm_source=wpswings-giftcards-services&utm_medium=giftcards-pro-backend&utm_campaign=woocommerce-services" target="_blank"><img src="' . esc_html( WPS_UWGC_URL ) . 'assets/images/Services.svg" class="wps-info-img" alt="services image" style="margin-right: 5px;vertical-align: middle;max-width: 15px;">' . __( 'Services', 'giftware' ) . '</a>',
			);

			$links = array_merge( $links, $new_links );
		}
		return $links;
	}

	/**
	 * Wps_uwgc_preview_email_template_for_pro
	 *
	 * @param string $message message.
	 */
	public function wps_uwgc_preview_email_template_for_pro( $message ) {
		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
		$allowed_tags = $wps_admin_obj->wps_allowed_html_tags();
		echo wp_kses( $message, $allowed_tags );
		wp_die();
	}
	/**
	 * Append template on product edit page for giftcard.
	 *
	 * @name wps_wgm_append_default_template
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_append_default_template() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$response['result'] = __( 'Fail due to an error', 'giftware' );
		$template_ids = isset( $_POST['template_ids'] ) ? map_deep( wp_unslash( $_POST['template_ids'] ), 'sanitize_text_field' ) : '';

		if ( isset( $template_ids ) && ! empty( $template_ids ) ) {
			$args = array(
				'post_type' => 'giftcard',
				'posts_per_page' => -1,
				'post__in' => $template_ids,
			);
			$loop = new WP_Query( $args );
			$template = array();
			if ( $loop->have_posts() ) {
				while ( $loop->have_posts() ) {
					$loop->the_post();
					global $product;
					$template_id = $loop->post->ID;
					$template_title = $loop->post->post_title;
					$template[ $template_id ] = $template_title;
				}
			}
			$response['templateid'] = $template;
			$response['result'] = 'success';
		} else if ( empty( $template_ids ) ) {
			$response['result'] = 'no_ids';
		}

		echo json_encode( $response );
		wp_die();
	}

	/**
	 * Wps_wgm_restore_gc_data_on_plugins_loaded
	 */
	public function wps_wgm_restore_gc_data_on_plugins_loaded() {
		require_once WPS_UWGC_DIRPATH . 'includes/class-ultimate-woocommerce-gift-cards-activation.php';
		$restore_data = new Ultimate_Woocommerce_Gift_Cards_Activation();
		$restore_data->wps_wgm_restore_data_pro();
	}

	/**
	 * This function is for adding a new product type option Sell as a GiftCard.
	 *
	 * @param array $product_type_options product type.
	 *
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_add_product_type_option( $product_type_options ) {
		$wps_wgc_enable = wps_wgm_giftcard_enable();
		if ( $wps_wgc_enable ) {
			$product_type_options['sell_as_a_giftcard'] = array(
				'id'            => '_sell_as_a_giftcard',
				'wrapper_class' => 'show_if_simple show_if_variable',
				'label'         => 'Sell as a Gift Card',
				'description'   => 'Enable to Sell this product as a Giftcard',
				'default'       => 'no',
			);
		}
		return $product_type_options;
	}

	/**
	 * This function is for saving data of new product type option Sell as a GiftCard.
	 *
	 * @param int    $post_ID postid.
	 * @param object $product product.
	 * @param mixed  $update update.
	 *
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_save_sell_as_a_gc_product_details( $post_ID, $product, $update ) {
		$price = get_post_meta( $product->ID, '_price', true );
		update_post_meta(
			$product->ID,
			'_sell_as_a_giftcard',
			isset( $_POST['_sell_as_a_giftcard'] ) ? 'yes' : 'no'
		);
	}

	/**
	 * This function is for adding new price type.
	 * 
	 * @param array $pricing_options pricing type.
	 */
	public function wps_uwgc_pricing_type( $pricing_options ) {
		$pricing_options['wps_wgm_selected_with_price_range'] = __( 'Selected with Price Range Type', 'giftware' );
		return $pricing_options;
	}

	// Show custom cart item fields on order edit page - Values
	public function custom_wc_add_order_item_custom_fields_values($product, $order_item, $item_id)
	{
		// Replace 'custom_meta_key' with your actual custom meta key
		$custom_meta_key = 'recharge_coupon_key_field';

		$custom_field = wc_get_order_item_meta($item_id, $custom_meta_key, true);
		if (!empty($custom_field)) {
			echo '<td>' . esc_html($custom_field) . '</td>';
		} else {
			echo '<td>&ndash;</td>';
		}
	}

	/**
	 * Create transaction table and product on new blog creation.
	 *
	 * @return void
	 */
	public function wps_gc_create_table_and_product() {


		$prod_created = get_option('gc_recharge_coupon_prod','yes');

		if ('yes' == $prod_created  ) {
				update_option('gc_recharge_coupon_prod','no');
			// create wallet metakey in usermeta of users.
			$users = get_users();
			if ( ! empty( $users ) && is_array( $users ) ) {
				foreach ( $users as $user ) {
					$user_id = $user->ID;
					$wallet  = get_user_meta( $user_id, 'wps_gc', true );
					if ( empty( $wallet ) ) {
						$wallet = update_user_meta( $user_id, 'wps_gc', 0 );
					}
				}
			}
			// create product named as wallet topup.
			if ( ! wc_get_product( get_option( 'wps_gccoupon_rechargeable_product_id' ) ) ) {
				$product = array(
					'post_title'   => 'Rechargeable Gift Card Product',
					'post_content' => 'This is the custom Gift Card topup product.',
					'post_type'    => 'product',
					'post_status'  => 'private',
					'post_author'  => 1,
				);

				$product_id = wp_insert_post( $product );
				// update price and visibility of product.
				if ( $product_id ) {
					update_post_meta( $product_id, '_regular_price', 0 );
					update_post_meta( $product_id, '_price', 0 );
					update_post_meta( $product_id, '_visibility', 'hidden' );
					update_post_meta( $product_id, '_virtual', 'yes' );

					$productdata = wc_get_product( $product_id );
					$productdata->set_catalog_visibility( 'hidden' );
					$productdata->save();

					update_option( 'wps_gccoupon_rechargeable_product_id', $product_id );

				}
			}
		}
		
	}
	//////////////////////////////////// Group gifting product functions ///////////////////////////////.

	/**
	 * Add custom column header.
	 */
	public function wps_gift_add_custom_column_header( $columns ) {
		
		$new_columns = array();
		// Add existing columns first.
		foreach ($columns as $column_key => $column_label) {
			$new_columns[$column_key] = $column_label;
		}
		// Add your custom column.
		$new_columns['order_detail'] = __('Order details', 'giftware');

		return $new_columns;
	}
	/**
	 * Display custom column.
	 */
	public function wps_gift_display_custom_column_content( $column, $order_id ) {
		if ($column === 'order_detail') {
			// Get the order object.
				$order = wc_get_order($order_id);
		
				// Check if the order exists.
				if ($order) {
					// Get order data.
					$order_data = $order->get_data();
		
					// Output order details.
					$order = wc_get_order( $order_data['id'] );
					$items = $order->get_items(); 
		
					foreach ( $order->get_items() as $item_id => $item ) {
						$product_id = $item->get_product_id();
						// Here you get your data
						$custom_field = wc_get_order_item_meta( $item_id, 'Main order id', true ); 
		
						// To test data output (uncomment the line below)
						if ( !empty($custom_field)){
							// If it is an array of values
							if( is_array( $custom_field ) ){
								echo implode( '<br>', $custom_field ); 
							} 
							// just one value (a string)
							else {
								echo 'suborder#'.$custom_field;
								
							}
						}
						$recharge_prod_id = get_option('wps_gccoupon_rechargeable_product_id',true);
						
						if ( $product_id == $recharge_prod_id ){
							echo esc_html('#Recharge','giftware');
						}
						$custom_contri = wc_get_order_item_meta( $item_id, 'Contributor', true );
						if ( !empty($custom_contri)){
							echo esc_html("#GroupGifting","giftware");
							
						}
						
					}
				
				} else {
					echo esc_html('Order not found.','giftware');
				}
			   
			}
	}

	/**
	 * Create custom product.
	 */
	public function wps_group_product_for_contributor( ) {
		$prod_created = get_option('gc_contributor_product','yes');
		
		if ('yes' == $prod_created  ) {
				
			
			// create product named as group gift contributor.
			if ( ! wc_get_product( get_option( 'contributor_product_id' ) ) ) {
				$product = array(
					'post_title'   => 'Group gift contribution',
					'post_content' => '<div class="wps-gc-restirction" >This is contribution collection product.</div>',
					'post_type'    => 'product',
					'post_status'  => 'publish',
					'post_author'  => 1,
					
				);

				$product_id = wp_insert_post( $product );
				update_option('gc_contributor_product','no');
				// update price and visibility of product.
				if ( $product_id ) {
					update_post_meta( $product_id, '_regular_price', 0 );
					update_post_meta( $product_id, '_price', 0 );
					
					update_post_meta( $product_id, '_virtual', 'yes' );

					$productdata = wc_get_product( $product_id );
					$productdata->set_catalog_visibility( 'hidden' );
					$productdata->save();

					update_option( 'contributor_product_id', $product_id );


				}
			}
		}

		$expiry_extension_prod_created = get_option( 'gc_expiry_extension_product','yes' );

		if ( 'yes' == $expiry_extension_prod_created ) {
			if ( ! wc_get_product( get_option( 'gc_expiry_extension_product_id' ) ) ) {
				$product = array(
					'post_title'   => 'Gift Card Expiry Extension',
					'post_content' => '<div class="wps-gc-restirction" >This is gift card expiry extension product.</div>',
					'post_type'    => 'product',
					'post_status'  => 'publish',
					'post_author'  => 1,
				);

				$product_id = wp_insert_post( $product );
				update_option('gc_expiry_extension_product','no');
				if ( $product_id ) {
					update_post_meta( $product_id, '_regular_price', 0 );
					update_post_meta( $product_id, '_price', 0 );
					update_post_meta( $product_id, '_virtual', 'yes' );

					$productdata = wc_get_product( $product_id );
					$productdata->set_catalog_visibility( 'hidden' );
					$productdata->save();

					update_option( 'gc_expiry_extension_product_id', $product_id );
				}
			}
		}

		$wps_admin_obj             = new Woocommerce_Gift_Cards_Common_Function();
		$other_settings            = get_option( 'wps_wgm_other_settings', array() );
		$wps_wgm_product_settings  = get_option( 'wps_wgm_product_settings', array() );

		if ( array_key_exists( 'wps_wgm_remove_validation_to', $other_settings ) ) {
			$remove_validation_to = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_remove_validation_to' );
			$wps_wgm_product_settings['wps_wgm_remove_validation_to'] = $remove_validation_to;
			unset($other_settings['wps_wgm_remove_validation_to']);
		}

		if ( array_key_exists( 'wps_wgm_remove_validation_to_name', $other_settings ) ) {
			$remove_validation_to_name = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_remove_validation_to_name' );
			$wps_wgm_product_settings['wps_wgm_remove_validation_to_name'] = $remove_validation_to_name;
			unset($other_settings['wps_wgm_remove_validation_to_name']);
		}

		if ( array_key_exists( 'wps_wgm_remove_validation_from', $other_settings ) ) {
			$remove_validation_from = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_remove_validation_from' );
			$wps_wgm_product_settings['wps_wgm_remove_validation_from'] = $remove_validation_from;
			unset($other_settings['wps_wgm_remove_validation_from']);
		}

		if ( array_key_exists( 'wps_wgm_remove_validation_msg', $other_settings ) ) {
			$remove_validation_msg = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_remove_validation_msg' );
			$wps_wgm_product_settings['wps_wgm_remove_validation_msg'] = $remove_validation_msg;
			unset($other_settings['wps_wgm_remove_validation_msg']);
		}

		update_option( 'wps_wgm_product_settings', $wps_wgm_product_settings );
		update_option( 'wps_wgm_other_settings', $other_settings );
		
	}

	/**
	 * Custom meta box .
	 * 
	 * @param $post $post. 
	 */
	public function wps_gift_display_custom_order_meta_box( $post ) {
		global $post;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$post_id = isset( $_GET['id'] ) ? $_GET['id'] : '';
		} else {
			$post_id = $post->ID;
		}
		$order_main_id = $post_id;
		$current_ord = wc_get_order($order_main_id );
		$m_billing_first_name = $current_ord->get_billing_first_name();
		$m_billing_last_name  = $current_ord->get_billing_last_name();
		$m_billing_email      = $current_ord->get_billing_email();
		$m_product_amount     = $current_ord->get_subtotal();;
		// Get the order object
		
		$order = wc_get_order();
		
		$meta_key = 'suborder#'.$order_main_id;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$orders = wc_get_orders( 
				array(
					'limit'       => -1,
					'status'      => array_keys( wc_get_order_statuses() ),
					'meta_key'    => $meta_key, // Replace with your custom field key 
					'type'        => wc_get_order_types(),
				)
			);
		} else {
			$args = array(
				'post_type'      => 'shop_order',
				'post_status'    => 'any',
				'posts_per_page' => -1,
				'meta_key'       => $meta_key, // Replace with your custom field key
			);
			$orders = get_posts( $args );
		}

		$html = '';
		$total_suborder_amout = 0;
			// Loop through the orders and display relevant data
			$html .='<div class="wps-suborder"><h3>Suborder Details</h3>
				<table>
					<tr>
						<th>Suborder ID</th>
						<th>Name</th>
						<th>Email</th>
						<th>Amount</th>
						
						<th>Url</th>
						<!-- Add more suborder details here -->
					</tr>';
					$html .='	<tr>
						<td class="suborder">' .$order_main_id. '</td>
						<td>' . $m_billing_first_name . $m_billing_last_name . '</td>
						<td> ' . $m_billing_email . '</td>
						<td> ' . wc_price($m_product_amount) . '</td>
						
						<td class="blinking"> </td>
						
						<!-- Add more suborder details here -->
					</tr>';
			foreach ( $orders as $order ) {
				if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					$order_id = $order->get_id();
				} else {
					$order_id = $order->ID;
				}
				$ord = wc_get_order( $order_id );
		
				$billing_first_name = $ord->get_billing_first_name();
				$billing_last_name  = $ord->get_billing_last_name();
				$billing_email      = $ord->get_billing_email();
				$product_amount     = $ord->get_subtotal();
				if ( $product_amount ) {
					$total_suborder_amout = $total_suborder_amout + $product_amount;
				}
				$html .='	<tr>
						<td class="suborder">' . $order_id . '</td>
						<td>' . $billing_first_name . $billing_last_name . '</td>
						<td> ' . $billing_email . '</td>
						<td> ' . wc_price($product_amount) . '</td>
						
						<td class="blinking"> <a href='.admin_url( 'post.php?post=' . $order_id . '&action=edit' ).'>click here </a></td>
						
						<!-- Add more suborder details here -->
					</tr>';
				}
				$html .='<tr>
		
				<td colspan="3">Total Coupon Amount </td>
				<td colspan="2">  ' . wc_price( intval( $total_suborder_amout + $m_product_amount ) ) .'</td>
				
				<!-- Add more suborder details here -->
				</tr></table></div>';
			
				echo $html;
		
	}

	////////////////////////////////////

public function custom_link_after_order_itemmeta( $item_id, $item, $product ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$woo_ver = WC()->version;
		
		global $post;
		if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS Enabled.
			$post_id = isset( $_GET['id'] ) ? sanitize_text_field( wp_unslash( $_GET['id'] ) ) : '';
		} else {
			$post_id = $post->ID;
		}
		
			if ( $woo_ver < '3.0.0' ) {
				$_product = $order->get_product_from_item( $item );
				$product_id = $_product->id;
			} else {
				if ( ! empty( $product ) ) {
                    $product_id = $product->get_id();
                }
			}
		
		
			if ( isset( $product_id ) && ! empty( $product_id ) ) {
				$product_types = wp_get_object_terms( $product_id, 'product_type' );
				$order_id = $post_id;
				
				$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
				if ( isset( $product_types[0] ) || 'on' === $wps_gift_product ) {
					$product_type = isset( $product_types[0] ) ? $product_types[0]->slug : '';
					if ( 'wgm_gift_card' == $product_type || 'on' === $wps_gift_product ) {
							$item_data = $item->get_meta_data();
						foreach ( $item_data as $key => $value ) {
								$value = $value->get_data();
							if ( isset( $value['key'] ) && 'Contributor' == $value['key'] && ! empty( $value['value'] ) ) {
								$pro_id = $item->get_id();
								$conti_prod_id = get_option( 'contributor_product_id' );
								$conti_prod_link = $url = get_permalink( $conti_prod_id );
	
								$subject = 'Product Notification';
	
								$message = $conti_prod_link . '?order_id=' . $order_id . '&prod_id=' . $pro_id;
	
								$whatsapp_url = 'https://api.whatsapp.com/send?';
								$whatsapp_url .= 'text=' . urlencode( $message );
								
								
							}
							if ( isset( $value['key'] ) && 'Send Date' == $value['key'] && '' !== $value['value'] ) {
								$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
								$other_settings = get_option( 'wps_wgm_other_settings', array() );
								$wps_uwgc_sendtoday_disable  = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_additional_sendtoday_disable' );
								if ( 'send' !== $itemgiftsend ) {
									
										$order = new WC_Order(intval($_GET['id']));
		
										$order_status = $order->get_status();
										if ( 'completed' == $order_status || 'processing' == $order_status ) {
										?>
												<div id="wps_wgm_loader" style="display: none;">
													<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
												</div>
												<p id="wps_uwgc_send_mail_force_notification_<?php echo esc_attr( $item_id ); ?>"></p>
												<div id="wps_send_force_div_<?php echo esc_attr( $item_id ); ?>">
													<input type="button" data-id="<?php echo esc_attr( $order_id ); ?>" data-num = "<?php echo esc_attr( $item_id ); ?>" class="wps_uwgc_send_mail_force" class="button button-primary" value="<?php esc_attr_e( 'Send Today', 'giftware' ); ?>">
												</div>
											<?php
									}
								
								}
							}
						}
					}
				}
			}
	
}

		/**
	 * Send mail forcefully for Schedule Giftcard when click on send Today Button.
	 *
	 * @name wps_uwgc_send_mail_force
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_send_mail_forcefully_admin() {
		check_ajax_referer( 'wps-wgm-verify-nonce', 'wps_nonce' );
		$response['result'] = false;
		$response['message'] = __( 'Mail sending failed due to some issue. Please try again.', 'giftware' );

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$discount_settings = get_option( 'wps_wgm_discount_settings', array() );
		$discount_enable  = $wps_public_obj->wps_wgm_get_template_data( $discount_settings, 'wps_wgm_discount_enable' );

		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$giftcard_coupon_length  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );
		$giftcard_coupon_length = ( '' !== $giftcard_coupon_length ) ? $giftcard_coupon_length : 5;
		
		if ( isset( $_POST['order_id'] ) && ! empty( $_POST['order_id'] ) && isset( $_POST['item_id'] ) && ! empty( $_POST['item_id'] ) ) {

			$order_id = sanitize_text_field( wp_unslash( $_POST['order_id'] ) );
			$item_id = sanitize_text_field( wp_unslash( $_POST['item_id'] ) );
			$order = wc_get_order( $order_id );

			foreach ( $order->get_items() as $item_id_arr => $item ) {
				if ( $item_id_arr == $item_id ) {
					$mailsend = false;
					$original_price = 0;
					$woo_ver = WC()->version;
					$gift_img_name = '';
					$from = '';
					$gift_msg = '';
					$to_name = '';
					$contact_no = '';
					$variable_price_description = '';
					$item_quantity = wc_get_order_item_meta( $item_id, '_qty', true );
					$product = $item->get_product();
					$item_meta_data = $item->get_meta_data();
					$pro_id = $product->get_id();
					foreach ( $item_meta_data as $key => $value ) {
						if ( isset( $value->key ) && 'To' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$to = $value->value;
						}
						if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$to_name = $value->value;
						}
						if ( isset( $value->key ) && 'From' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$from = $value->value;
						}
						if ( isset( $value->key ) && 'Message' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$gift_msg = $value->value;
						}
						if ( isset( $value->key ) && 'Image' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$gift_img_name = $value->value;
						}
						if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$delivery_method = $value->value;
						}
						if ( isset( $value->key ) && 'Original Price' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$original_price = $value->value;
						}
						if ( isset( $value->key ) && 'Selected Template' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$selected_template = $value->value;
						}
						if ( isset( $value->key ) && 'Reciever Contact' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$contact_no = $value->value;
						}
						if ( isset( $value->key ) && 'Variable Price Description' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$variable_price_description = $value->value;
						}
						if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
							$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
							if ( 'send' == $itemgiftsend ) {
								$response['result'] = false;
								$response['message'] = __( 'Mail already send on the scheduled date.', 'giftware' );
								echo json_encode( $response );
								wp_die();
							}

							$mailsend = true;
							wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'send' );
							$note = __( 'Gift Card Email has been sent.', 'giftware' );
							$order->add_order_note( $note );
						} else {
							wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#giftcard_send", 'send' );
						}
					}
					if ( ! empty( $to ) && ( 'Mail to recipient' == $delivery_method ) ) {
						$recipients = preg_split( '/[\s,]+/', $to, -1, PREG_SPLIT_NO_EMPTY );
					}
					if ( ! empty( $to_name ) ) {
						$recipients_name = preg_split( '/[,]+/', $to_name, -1, PREG_SPLIT_NO_EMPTY );
					}
					if ( ! isset( $to ) && empty( $to ) ) {
						if ( 'Mail to recipient' == $delivery_method ) {
							$to = $order->get_billing_email();
						} else {
							$to = '';
						}
					}
					if ( $mailsend ) {
						$gift_order = true;
						// gift total.
						$inc_tax_status = get_option( 'woocommerce_prices_include_tax', false );
						if ( 'yes' == $inc_tax_status ) {
							$inc_tax_status = true;
						} else {
							$inc_tax_status = false;
						}
						$couponamont = $original_price;
						$group_couponamont = wps_wgm_hpos_get_meta_data( $order_id, 'suborder#amttotal', true );
						if ( isset( $group_couponamont ) && ! empty( $group_couponamont ) ) {
							$couponamont = $group_couponamont;
						}
						$args = array(
							'posts_per_page'   => -1,
							'orderby'          => 'title',
							'order'            => 'asc',
							'post_type'        => 'shop_coupon',
							'post_status'      => 'publish',
						);

						// First query: search for coupons associated with product ID.
						$args['meta_query'] = array(
							'relation' => 'AND',
							array(
								'key'     => 'wps_wgm_imported_coupon',
								'value'   => 'yes',
								'compare' => '==',
							),
							array(
								'key'     => 'wps_wgm_coupon_product_id',
								'value'   => $pro_id,
								'compare' => '==',
							),
						);
						$imported_coupons = get_posts( $args );

						// If no imported coupons found for product ID, search for global coupons.
						if ( empty( $imported_coupons ) ) {
							$args['meta_query'] = array(
								'relation' => 'AND',
								array(
									'key'     => 'wps_wgm_imported_coupon',
									'value'   => 'yes',
									'compare' => '==',
								),
								array(
									'key'     => 'wps_wgm_coupon_product_id',
									'compare' => 'NOT EXISTS',
								),
							);
							$imported_coupons = get_posts( $args );
						}

						$wps_uwgc_common_arr = array();
						$is_imported_product = get_post_meta( $pro_id, 'is_imported', true );
						$wps_wgm_pricing = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
						$templateid = $wps_wgm_pricing['template'];
						if ( is_array( $templateid ) && array_key_exists( 0, $templateid ) ) {
							$temp = $templateid[0];
						} else {
							$temp = $templateid;
						}
						if ( isset( $is_imported_product ) && ! empty( $is_imported_product ) && 'yes' == $is_imported_product ) {
							if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
								$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
								if ( isset( $pro_price ) && is_array( $pro_price ) ) {
									$couponamont = $pro_price['default_price'];
								}
							} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
								$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
								if ( isset( $pro_price ) && is_array( $pro_price ) ) {
									$couponamont = $pro_price['default_price'];
								}
							} else {
								$couponamont = $order->get_line_subtotal( $item, $inc_tax_status );
							}
							$gift_couponnumber = get_post_meta( $pro_id, 'coupon_code', true );
							if ( empty( $gift_couponnumber ) && ! isset( $gift_couponnumber ) ) {
								$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );
							}
							if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $to ) ) {
								$todaydate = date_i18n( 'Y-m-d' );
								$expiry_date = get_post_meta( $pro_id, 'expiry_after_days', true );
								$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
								wc_update_order_item_meta( $item_id, 'Send Date', $todaydate );
								$wps_uwgc_common_arr['order_id'] = $order_id;
								$wps_uwgc_common_arr['product_id'] = $pro_id;
								$wps_uwgc_common_arr['to'] = $to;
								$wps_uwgc_common_arr['from'] = $from;
								$wps_uwgc_common_arr['to_name'] = isset( $to_name ) ? $to_name : '';
								$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
								$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
								$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
								$wps_uwgc_common_arr['selected_template'] = ! empty( $selected_template ) ? $selected_template : $temp;
								$wps_uwgc_common_arr['couponamont'] = $couponamont;
								$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
								$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
								$wps_uwgc_common_arr['item_id'] = $item_id;
								$wps_uwgc_common_arr['contact_no'] = $contact_no;
								$wps_uwgc_common_arr['send_date'] = $todaydate;
								$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
								$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

								if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
									update_post_meta( $pro_id, '_stock_status', 'outofstock' );
									$response['result'] = true;
									$response['message'] = __( 'Gift card  is Sent Successfully', 'giftware' );
									echo json_encode( $response );
									wp_die();
								}
							}
						} elseif ( ! empty( $imported_coupons ) ) {

							for ( $i = 0; $i < $item_quantity; $i++ ) {
								if ( isset( $recipients ) && ! empty( $recipients ) ) {
									$to = trim( array_shift( $recipients ) );
								}
								if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
									$to_name = trim( array_shift( $recipients_name ) );
								}
								$imported_code = $imported_coupons[ $i ]->post_title;
								if ( isset( $imported_code ) && ! empty( $imported_code ) ) {
									$the_coupon = new WC_Coupon( $imported_code );
									if ( $woo_ver < '3.0.0' ) {
										$import_coupon_id = $the_coupon->id;
									} else {
										$import_coupon_id = $the_coupon->get_id();
									}
									$todaydate = date_i18n( 'Y-m-d' );
									$expiry_date = get_post_meta( $import_coupon_id, 'wps_wgm_expiry_date', true );
									$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
									$wps_uwgc_common_arr['order_id'] = $order_id;
									$wps_uwgc_common_arr['product_id'] = $pro_id;
									$wps_uwgc_common_arr['to'] = $to;
									$wps_uwgc_common_arr['from'] = $from;
									$wps_uwgc_common_arr['to_name'] = isset( $to_name ) ? $to_name : '';
									$wps_uwgc_common_arr['gift_couponnumber'] = $imported_code;
									$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
									$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
									$wps_uwgc_common_arr['selected_template'] = $selected_template;
									$wps_uwgc_common_arr['couponamont'] = $couponamont;
									$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
									$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
									$wps_uwgc_common_arr['item_id'] = $item_id;
									$wps_uwgc_common_arr['contact_no'] = $contact_no;
									$wps_uwgc_common_arr['send_date'] = $todaydate;
									$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;

									$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

									if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
										update_post_meta( $import_coupon_id, 'coupon_amount', $couponamont );
										update_post_meta( $import_coupon_id, 'wps_wgm_coupon_amount', $couponamont );
										update_post_meta( $import_coupon_id, 'wps_wgm_imported_coupon', 'purchased' );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon', $order_id );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_unique', 'online' );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_product_id', $pro_id );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_mail_to', $to );
										$woo_ver = WC()->version;

										
										if ( $woo_ver < '3.6.0' ) {
											update_post_meta( $import_coupon_id, 'expiry_date', $expirydate_format );
										} else {
											$general_settings = get_option( 'wps_wgm_general_settings', array() );
											$selected_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
											if ( isset( $selected_date ) && null != $selected_date && '' != $selected_date ) {
												if ( 'd/m/Y' == $selected_date ) {
													$expirydate_format = str_replace( '/', '-', $expirydate_format );
												}
											}
											$expirydate_format = strtotime( $expirydate_format );
											update_post_meta( $import_coupon_id, 'date_expires', $expirydate_format );
										}
										$response['result'] = true;
										$response['message'] = __( 'Gift card  is Sent Successfully', 'giftware' );
										echo json_encode( $response );
										wp_die();
									}
								} elseif ( empty( $imported_code ) ) {
									$random_code = wps_wgm_coupon_generator( $giftcard_coupon_length );
									if ( $wps_public_obj->wps_wgm_create_gift_coupon( $random_code, $couponamont, $order_id, $item['product_id'], $to ) ) {
										$todaydate = date_i18n( 'Y-m-d' );
																				$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
										if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
											$expiry_date  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
										} else {
											$expiry_date = $local_expiry_day;
										}

									
										$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
										$wps_uwgc_common_arr['order_id'] = $order_id;
										$wps_uwgc_common_arr['product_id'] = $pro_id;
										$wps_uwgc_common_arr['to'] = $to;
										$wps_uwgc_common_arr['from'] = $from;
										$wps_uwgc_common_arr['to_name'] = $to_name;
										$wps_uwgc_common_arr['gift_couponnumber'] = $random_code;
										$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
										$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
										$wps_uwgc_common_arr['selected_template'] = $selected_template;
										$wps_uwgc_common_arr['couponamont'] = $couponamont;
										$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
										$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
										$wps_uwgc_common_arr['item_id'] = $item_id;
										$wps_uwgc_common_arr['contact_no'] = $contact_no;
										$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
										$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );
									}
								}
							}
						} else {

							for ( $i = 1; $i <= $item_quantity; $i++ ) {
								if ( isset( $recipients ) && ! empty( $recipients ) ) {
									$to = trim( array_shift( $recipients ) );
								}
								if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
									$to_name = trim( array_shift( $recipients_name ) );
								}
								$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );

								if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $to ) ) {
									$todaydate = date_i18n( 'Y-m-d' );

									$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
									if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
										$expiry_date  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
									} else {
										$expiry_date = $local_expiry_day;
									}

								
									$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
									$wps_uwgc_common_arr['order_id'] = $order_id;
									$wps_uwgc_common_arr['product_id'] = $pro_id;
									$wps_uwgc_common_arr['to'] = $to;
									$wps_uwgc_common_arr['from'] = $from;
									$wps_uwgc_common_arr['to_name'] = $to_name;
									$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
									$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
									$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
									$wps_uwgc_common_arr['selected_template'] = ! empty( $selected_template ) ? $selected_template : $temp;
									$wps_uwgc_common_arr['couponamont'] = $couponamont;
									$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
									$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
									$wps_uwgc_common_arr['item_id'] = $item_id;
									$wps_uwgc_common_arr['contact_no'] = $contact_no;
									$wps_uwgc_common_arr['send_date'] = $todaydate;
									$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
									$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

									if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
										$response['result'] = true;
										$response['message'] = __( 'Gift card  is Sent Successfully', 'giftware' );
										echo json_encode( $response );
										 wp_die();
									}
								}
							}
						}
					}
					break;
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}
	/////////////////////////////////////////////////////// subcription code //////////////////////////////////////////////
	
	/**
	 * 
	 */
	public function wps_giftware_check_license_key_status() {
		
		$this->validate_license_daily();
 

		$gc_subscr_status = get_option( 'wps_gc_pro_subscription_status', false );
		$wps_subscr_renewdate = get_option( 'wps_gc_pro_subscription_renewdate', false );
		if ( isset( $gc_subscr_status ) && true == $gc_subscr_status ) {
 
 
			echo json_encode(
				array(
					'status' => false,
					'msg' => __(
						'Subscription is not renewed yet.',
						'giftware'
					),
				)
			);
		} else if ( isset( $wps_subscr_renewdate ) && ! empty( $wps_subscr_renewdate ) && '0000-00-00' != $wps_subscr_renewdate ) {
			echo json_encode(
				array(
					'status' => false,
					'msg' => __(
						'Subscription is not renewed yet.',
						'giftware'
					),
				)
			);
		} else {
			echo json_encode(
				array(
					'status' => true,
					'msg' => __(
						'License Status Updated. Please Wait.',
						'giftware'
					),
				)
			);
		}
 
 
		wp_die();
 
}
	/**
	 *  Subscription code .
	 */
	public function wps_gc_subscription_notification_html() {
		$screen = get_current_screen();
		if ( isset( $screen->id ) ) {
			$pagescreen = $screen->id;
		}
		
		if ( ( isset( $pagescreen ) && 'plugins' === $pagescreen ) || ( 'giftcard_page_wps-wgc-setting-lite' == $pagescreen ) ) {
			$wps_subscr_status = get_option( 'wps_gc_pro_subscription_status', false );
			
			if ( isset( $wps_subscr_status ) && true == $wps_subscr_status ) {

				?>
					<div class="wps-subsc_notice notice notice-warning is-dismissible">
						<p><?php esc_attr_e( 'Stay on track! Renew your subscription for ', 'giftware' ); ?><b><?php esc_attr_e( 'Ultimate Giftcard For Woocommerce ', 'giftware' ); ?></b><?php esc_attr_e( 'now to maintain uninterrupted service!', 'giftware' ); ?> <a href="https://wpswings.com/my-account/subscriptions/" target="_blank"> <b><?php esc_attr_e( 'Renew Now', 'giftware' ); ?></b></a>. <?php esc_attr_e( 'If already renewed', 'giftware' ); ?>, <a href="#" id="wps_check_license"><b><?php esc_attr_e( 'Validate Now', 'giftware' ); ?></b></a>.</p>
					</div>


				<?php
			}

			$wps_subscr_renewdate = get_option( 'wps_gc_pro_subscription_renewdate', false );
			$today_date = gmdate( 'Y-m-d', strtotime( 'now' ) );
			$reminder_date = gmdate( 'Y-m-d', strtotime( '-5 days', strtotime( $wps_subscr_renewdate ) ) );

			$date1 = new DateTime( $wps_subscr_renewdate );
			$date2 = new DateTime( $today_date );
			$interval = $date1->diff( $date2 );

			if ( isset( $wps_subscr_renewdate ) && ( $today_date >= $reminder_date && $today_date < $wps_subscr_renewdate ) ) {

				?>
					<div class="wps-subsc_notice notice notice-warning is-dismissible">
						<p><strong>
						<?php
						esc_html_e( 'Your Subscription Will Expire in ', 'giftware' );
						echo esc_html( $interval->days );
						esc_html_e( ' days', 'giftware' );
						?>
						.</strong><br>
						<?php esc_attr_e( 'Stay on track! Renew your subscription for ', 'giftware' ); ?><b><?php esc_attr_e( 'Ultimate Giftcard For Woocommerce ', 'giftware' ); ?></b><?php esc_attr_e( 'now to maintain uninterrupted service!', 'giftware' ); ?> <a href="https://wpswings.com/my-account/subscriptions/" target="_blank"> <b><?php esc_attr_e( 'Renew Now', 'giftware' ); ?></b></a>. <?php esc_attr_e( 'If already renewed', 'giftware' ); ?>, <a href="#" id="wps_check_license"><b><?php esc_attr_e( 'Validate Now', 'giftware' ); ?></b></a>.</p>
					</div>
					
				<?php
			}
		}
	}

	/**
	* Export Pdf button for gift template.
	*/
	public function wps_uwgc_export_pdf_gift_template( $actions, $post ) {
		$secure_nonce = wp_create_nonce( 'wps-gc-auth-nonce' );

		$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();

		$other_settings = get_option( 'wps_wgm_other_settings', array() );

		$wps_uwgc_pdf_enable = $wps_admin_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_pdf_enable' );

		if ( isset( $wps_uwgc_pdf_enable ) && 'on' == $wps_uwgc_pdf_enable ) {
			if ( 'giftcard' == $post->post_type ) {
				$actions['wps_wgm_export_pdf'] = '<a href="' . admin_url( 'edit.php?post_type=giftcardpost&post_id=' . $post->ID . '&wps_wgm_template=giftcardpdf&wps_nonce=' . $secure_nonce ) . '" rel="permalink">' . __( 'Export PDF', 'giftware' ) . '</a>';
			}
		}
	
		return $actions;
	}

	/**
	* Export Pdf for gift template.
	*/
	public function wps_wgm_export_pdf_email_template() {
		if ( current_user_can( 'edit_others_posts' ) ) {
	
			$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
	
			if ( isset( $_GET['wps_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['wps_nonce'] ) ), 'wps-gc-auth-nonce' ) ) {
				if ( isset( $_GET['wps_wgm_template'] ) ) {
	
					if ( $_GET['wps_wgm_template'] == 'giftcardpdf' ) {
						$post_id = isset( $_GET['post_id'] ) ? sanitize_text_field( wp_unslash( $_GET['post_id'] ) ) : '';
	
						$wps_post_type = get_post_type( $post_id );
						if ( 'giftcard' == $wps_post_type ) {
	
							$todaydate = date_i18n( 'Y-m-d' );
							$wps_wgm_general_settings = get_option( 'wps_wgm_general_settings', false );
							$expiry_date = $wps_admin_obj->wps_wgm_get_template_data( $wps_wgm_general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
	
							$expirydate_format = $wps_admin_obj->wps_wgm_check_expiry_date( $expiry_date );
							$wps_wgm_coupon_length_display = $wps_admin_obj->wps_wgm_get_template_data( $wps_wgm_general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );
	
							if ( '' == $wps_wgm_coupon_length_display ) {
								$wps_wgm_coupon_length_display = 5;
							}
							$password = '';
							for ( $i = 0; $i < $wps_wgm_coupon_length_display; $i++ ) {
								$password .= 'x';
							}
							$giftcard_prefix = $wps_admin_obj->wps_wgm_get_template_data( $wps_wgm_general_settings, 'wps_wgm_general_setting_giftcard_prefix' );
							$coupon = $giftcard_prefix . $password;
							$templateid = $post_id;
	
							$args['from'] = esc_html__( 'from@example.com', 'giftware' );
							$args['to'] = esc_html__( 'to@example.com', 'giftware' );
							$args['message'] = esc_html__( 'Your gift message will appear here which you send to your receiver. ', 'giftware' );
							$args['coupon'] = apply_filters( 'wps_wgm_static_coupon_img', $coupon );
							$args['expirydate'] = $expirydate_format;
							$args['amount'] = wc_price( 100 );
							$args['templateid'] = $templateid;
							$style = '<style>
								table, th, tr, td {
									border: medium none;
								}
								table, th, tr, td {
									border: 0px !important;
								}
								#wps_gw_email {
									width: 630px !important;
								}
							</style>';
	
							$message = $wps_admin_obj->wps_wgm_create_gift_template( $args );
	
							$site_name = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
							$time = time();
	
							$this->wps_common_fun->wps_uwgc_attached_pdf( $message, $site_name, $time, '', $coupon );
	
							$upload_dir = wp_upload_dir();
							$file_path = $upload_dir['basedir'] . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf';
	
							if ( file_exists( $file_path ) ) {
								header( 'Content-Description: File Transfer' );
								header( 'Content-Type: application/pdf' );
								header( 'Content-Disposition: attachment; filename="' . basename( $file_path ) . '"' );
								header( 'Expires: 0' );
								header( 'Cache-Control: must-revalidate' );
								header( 'Pragma: public' );
								header( 'Content-Length: ' . filesize( $file_path ) );
								readfile( $file_path );
								unlink( wp_upload_dir()['basedir'] . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
								exit;
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Function to create giftcard template for product as a gift.
	 */
	public function wps_uwgc_create_template_for_product_as_a_gift() {

		if ( empty( get_option( 'wps_wgm_purchase_as_a_gift_template', '' ) ) ) {

			update_option( 'wps_wgm_purchase_as_a_gift_template', true );
			$wps_obj = new Woocommerce_Gift_Cards_Common_Function();

			$filename = array( WPS_WGC_URL . 'assets/images/purchase_as_a_gift.jpg' );
			if ( isset( $filename ) && is_array( $filename ) && ! empty( $filename ) ) {
				foreach ( $filename as $key => $value ) {
					$upload_file = wp_upload_bits( basename( $value ), null, $wps_obj->wps_wgm_get_file_content( $value ) );
					if ( ! $upload_file['error'] ) {
						$filename = $upload_file['file'];
						// The ID of the post this attachment is for.

						$parent_post_id = 0;

						// Check the type of file. We'll use this as the 'post_mime_type'.
						$filetype = wp_check_filetype( basename( $filename ), null );
						// Get the path to the upload directory.
						$wp_upload_dir = wp_upload_dir();
						// Prepare an array of post data for the attachment.
						$attachment = array(
							'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ),
							'post_mime_type' => $filetype['type'],
							'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),

							'post_status'    => 'inherit',
						);
						// Insert the attachment.

						$attach_id = wp_insert_attachment( $attachment, $filename, 0 );
						// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
						require_once ABSPATH . 'wp-admin/includes/image.php';

						// Generate the metadata for the attachment, and update the database record.
						$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );

						wp_update_attachment_metadata( $attach_id, $attach_data );
						$arr[] = $attach_id;
					}
				}
			}

			$wps_wgm_purchase_as_a_gift_template = "<style>@page{ margin: 20px}</style><center><div style='max-width:600px;margin:auto'><div style='display:none;font-size:1px;line-height:1px;max-height:0px;max-width:0px;opacity:0;overflow:hidden;mso-hide:all;font-family: sans-serif;'>(Optional) This text will appear in the inbox preview, but not the email body.</div><table class='left-right-container' style='margin: auto;width: 100%;' role='presentation' border='0' cellspacing='0' cellpadding='0'><tbody><tr><td dir='ltr' valign='top' style='background:#fff;width:100%;padding:20px;'><table role='presentation' border='0' cellspacing='0' cellpadding='0' style='width:100%;'><tbody><tr><td class='stack-column-center default-img-left' valign='middle' style='text-align: left;width:50%;padding:0 0 10px;'>[LOGO]</td><td class='stack-column-center default-img-content' style='width:50%;padding:0;text-align: right;font-family: sans-serif; font-size: 28px; line-height: 32px; color: #000; height: auto; word-wrap: break-word;' valign='middle' dir='ltr' valign='middle'><strong class='woocommerce-Price-amount amount'>[AMOUNT]/- </strong><span dir='ltr' style='font-size: 16px;text-align: right;font-weight: bold; font-family: sans-serif; color: #000;' valign='top'>(Ed: [EXPIRYDATE])</span></td></tr></tbody></table></td></tr></tbody></table><table class='coupon-code-container' style='margin: auto;width: 100%;' role='presentation' border='0' cellspacing='0' cellpadding='0' align='center'><tbody><tr><td style='padding:10px 0; background:#fff;width:100%;'><table role='presentation' border='0' cellspacing='0' cellpadding='0' align='center' style='width:100%;margin: auto;'><tbody><tr><td dir='ltr' style='font-size: 16px;text-align: center;font-weight: bold; font-family: sans-serif; padding: 5px 0; color: #000;' valign='top'>Coupon Code </td></tr><tr><td dir='ltr' style='background: #e91e63; padding:10px;width: 100%;font-size: 16px;text-align: center;font-weight: bold; font-family: sans-serif; color: #fff;' valign='top' dir='ltr'><strong style='font-size: 18px;'>[COUPON] </strong></td></tr></tbody></table></td></tr></tbody></table><table class='featured-image-container' style='margin: auto;width: 100%;' role='presentation' border='0' cellspacing='0' cellpadding='0' align='center'><tbody><tr><td style='text-align: center;padding: 0 0 20px;width:100%;background:#fff;'><img src='[FEATUREDIMAGE]' style='margin:auto;width:100%;'></td></tr><tr><td style='text-align: center;padding: 40px 0;width:100%;background:#fff;'><table class='disclaimer-container' role='presentation' border='0' style='width: 100%;' cellspacing='0' cellpadding='0'><tbody><tr><td dir='ltr' style='text-align: center;padding: 0 20px 0;font-family: sans-serif; font-size: 18px; line-height: 24px; color: #000; height: auto; word-wrap: break-word;' valign='top'>[MESSAGE]</td></tr><tr><td dir='ltr' style='text-align: center;padding: 30px 20px 0;font-family: sans-serif; font-size: 18px; line-height: 24px; color: #424242; word-wrap: break-word;' valign='top'><span style='display: inline-block; font-size: 15px; vertical-align: top;'><strong style='color: #000;font-weight: bold;'>From-&nbsp;</strong>[FROM]</span></td></tr><tr><td dir='ltr' style='text-align: center;padding: 5px 20px 0;font-family: sans-serif; font-size: 18px; line-height: 24px; color: #424242; word-wrap: break-word;' valign='top'><span style='display: inline-block; font-size: 15px; vertical-align: top;'><strong style='color: #000;font-weight: bold;'>To-&nbsp;</strong>[TO]</span></td></tr></tbody></table></td></tr></tbody></table><table class='disclaimer-container' role='presentation' border='0' style='width: 100%;' cellspacing='0' cellpadding='0'><tbody><tr><td style='text-align: center;padding: 20px; font-family: sans-serif; font-size: 16px; mso-height-rule: exactly; line-height: 20px; color: #fff; background: #424242;'>[DISCLAIMER]</td></tr></tbody></table></div></center><style>html, body{ margin: 0 auto !important; padding: 0 !important; height: 100% !important; width: 100% !important} *{ -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; box-sizing: border-box} div[style*='margin: 16px 0']{ margin: 0 !important} table, td{ mso-table-lspace: 0pt !important; mso-table-rspace: 0pt !important} table{ border-spacing: 0 !important; border-collapse: collapse !important; table-layout: fixed !important; margin: 0 auto !important} table table table{ table-layout: auto} img{ -ms-interpolation-mode: bicubic} *[x-apple-data-detectors], .x-gmail-data-detectors, .x-gmail-data-detectors *, .aBn{ border-bottom: 0 !important; cursor: default !important; color: inherit !important; text-decoration: none !important; font-size: inherit !important; font-family: inherit !important; font-weight: inherit !important; line-height: inherit !important} .a6S{ display: none !important; opacity: 0.01 !important} img.g-img+div{ display: none !important} .button-link{ text-decoration: none !important}</style>";

			$gifttemplate_new = array(
				'post_title'   => 'Purchase as a Gift',
				'post_content' => $wps_wgm_purchase_as_a_gift_template,
				'post_status'  => 'publish',
				'post_author'  => get_current_user_id(),
				'post_type'    => 'giftcard',
			);
			$parent_post_id   = wp_insert_post( $gifttemplate_new );
			set_post_thumbnail( $parent_post_id, $arr[0] );
		}
	}

	public function wps_uwgc_add_analytics_coupons( $html, $column_name, $item ) {
		if ( $column_name === 'analytics' ) {
			$text = __( 'View', 'giftware' );
			$html = '<a href="' . esc_url( admin_url( 'admin.php?page=wc-admin&path=%2Fanalytics%2Fcoupons&filter=single_coupon&coupons=' . absint( $item['coupon_id'] ) ) ) .'" target="_blank">' . $text . '</a>';
		}
		return $html;
	}

	public function wps_uwgc_add_analytics_coupons_column( $columns ) {
		$columns['analytics'] = __( 'Analytics', 'giftware' );
		return $columns;
	}

	public function wps_uwgc_gc_report_extra_tablenav( $which ) {
		$gc_date_1 = isset( $_POST['wps_gc_date_filter_1'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_gc_date_filter_1'] ) ) : '';
		$gc_date_2 = isset( $_POST['wps_gc_date_filter_2'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_gc_date_filter_2'] ) ) : '';

		?>
		<form method="POST">
			<input type="date" name="wps_gc_date_filter_1" id="wps_gc_date_filter_1" value="<?php echo $gc_date_1; ?>">
			<input type="date" name="wps_gc_date_filter_2" id="wps_gc_date_filter_2" value="<?php echo $gc_date_2; ?>">
			<input type="submit" class="button wps_date_filter" value="<?php echo esc_html__( 'Filter', 'giftware' ); ?>" name="wps_date_filter">
			<input type="hidden" id="wps_wgm_report_nonce" name="wps_wgm_report_nonce" value="<?php echo esc_attr( wp_create_nonce() ); ?>" />
		</form>
			<?php
			$export_url = add_query_arg(
				array(
					'export_users'         => 'export_users_report',
					'wps_gc_date_filter_1' => esc_attr( $gc_date_1 ),
					'wps_gc_date_filter_2' => esc_attr( $gc_date_2 ),
				)
			);
			?>
			<a class="page-title-action wps_uwgc_export_report_button" href="<?php echo esc_url( $export_url ); ?>">
				<?php echo esc_html__( 'Export Report', 'giftware' ); ?>
			</a>
		<?php
	}

	public function wps_uwgc_export_users_action() {

		if ( isset( $_GET['export_users'] ) && ( 'export_users_report' === $_GET['export_users'] ) ) {

			$report_data = $this->wps_uwgc_giftcard_report_data_to_export();
	
			if ( empty( $report_data ) ) {
				wp_die( __( 'No data available for export.', 'giftware' ) );
			}
	
			header( 'Content-Type: text/csv; charset=utf-8' );
			header( 'Content-Disposition: attachment; filename=giftcard_report_' . date( 'Y-m-d' ) . '.csv' );
	
			$output = fopen( 'php://output', 'w' );
	
			fputcsv( $output, array(
				'Coupon ID',
				'Gift Card Code',
				'Order ID',
				'Gift Card Amount',
				'Expiry Date',
				'Buyer Email',
			));
	
			foreach ( $report_data as $row ) {
				fputcsv( $output, array(
					$row['coupon_id'],
					$row['giftcard_code'],
					$row['order_id'],
					$row['coupon_amount'],
					$row['expiry_date'],
					$row['buyer_email']
				));
			}
	
			fclose( $output );
	
			exit;
		}
	}

	public function wps_uwgc_giftcard_report_data_to_export() {

		$gc_date_1 = isset( $_GET['wps_gc_date_filter_1'] ) ? sanitize_text_field( wp_unslash( $_GET['wps_gc_date_filter_1'] ) ) : '';
		$gc_date_2 = isset( $_GET['wps_gc_date_filter_2'] ) ? sanitize_text_field( wp_unslash( $_GET['wps_gc_date_filter_2'] ) ) : '';
	
		$args = array(
			'posts_per_page'   => -1,
			'post_type'        => 'shop_coupon',
			'post_status'      => 'publish',
		);
	
		if ( $gc_date_1 && $gc_date_2 ) {
			$args['date_query'] = array(
				array(
					'after'     => $gc_date_1,
					'before'    => $gc_date_2,
					'inclusive' => true,
				),
			);
		}
	
		$coupons = get_posts( $args );
	
		$coupon_codes = array();
		if ( isset( $coupons ) && is_array( $coupons ) && ! empty( $coupons ) ) {
			foreach ( $coupons as $coupon ) {
				$couponcontent = $coupon->post_content;
				if ( strpos( $couponcontent, 'GIFTCARD ORDER #' ) !== false || ( strpos( $couponcontent, 'Imported Coupon' ) !== false && 'purchased' === get_post_meta( $coupon->ID, 'wps_wgm_imported_coupon', true ) ) ) {
					$coupon_name = strtolower( $coupon->post_title );
					array_push( $coupon_codes, $coupon_name );
				}
			}
		}
	
		$wps_uwgc_data = array();
	
		if ( is_array( $coupon_codes ) && ! empty( $coupon_codes ) && count( $coupon_codes ) ) {
	
			foreach ( $coupon_codes as $key => $value ) {
				$coupon_obj = new WC_Coupon( $value );
				$order_id = get_post_meta( $coupon_obj->get_id(), 'wps_wgm_giftcard_coupon', true );
				if ( isset( $order_id ) && ! empty( $order_id ) ) {
					$order = wc_get_order( $order_id );
	
					global $wpdb;
					$table_name = $wpdb->prefix . 'offline_giftcard';
					$query = "SELECT * FROM $table_name WHERE `id`=$order_id";
					$giftresults = $wpdb->get_results( $query, ARRAY_A );
	
					if ( ! empty( $order ) ) {
						$user_email = $order->get_billing_email();
						$coupon_amount = get_post_meta( $coupon_obj->get_id(), 'coupon_amount', true );
						$expiry_date = $coupon_obj->get_date_expires();
						$expiry_date = 	isset( $expiry_date ) ? date('F j, Y', strtotime('-1 day', strtotime($expiry_date))): esc_html__( 'No Expiry', 'giftware' );
						$wps_uwgc_data[] = array(
							'coupon_id' => $coupon_obj->get_id(),
							'giftcard_code' => $value,
							'order_id'  => $order_id,
							'coupon_amount' => $coupon_amount,
							'expiry_date' => $expiry_date,
							'buyer_email' => $user_email,
						);
					} else if ( isset( $giftresults[0] ) ) {
						$giftresult = $giftresults[0];
						$user_email = $giftresult['from'];
						$coupon_amount = get_post_meta( $coupon_obj->get_id(), 'coupon_amount', true );
						$expiry_date = $coupon_obj->get_date_expires();
						$expiry_date = 	isset( $expiry_date ) ? date('F j, Y', strtotime('-1 day', strtotime($expiry_date))): esc_html__( 'No Expiry', 'giftware' );
						$wps_uwgc_data[] = array(
							'coupon_id' => $coupon_obj->get_id(),
							'giftcard_code' => $value,
							'order_id'  => $order_id,
							'coupon_amount' => $coupon_amount,
							'expiry_date' => $expiry_date,
							'buyer_email' => $user_email,
						);
					}
				}
			}
		}
		return $wps_uwgc_data;
	}
	
	public function add_imported_coupon_availability_column( $columns ) {
		$columns['wps_wgm_coupon_availability'] = __( 'Imported Coupons Availability', 'giftware' );
		return $columns;
	}

	public function populate_imported_coupon_availability_column( $column, $coupon_id ) {
		if ( 'wps_wgm_coupon_availability' === $column ) {
			$custom_data = get_post_meta( $coupon_id, 'wps_wgm_imported_coupon', true );
			
			if ( ! empty( $custom_data ) ) {
				if ( 'purchased' == $custom_data ) {
					echo esc_html__( 'Purchased', 'giftware' );
				} else {
					echo esc_html__( 'Available', 'giftware' );
				}
			}
		}
	}

	public function wps_uwgc_woocommerce_product_options_general_product_data() {
		global $post;
		$product_id = $post->ID;
		if ( isset( $product_id ) ) {
			if ( ! current_user_can( 'edit_post', $product_id ) ) {
				return;
			}
		}

		if ( wps_wgm_giftcard_enable() ) {
			if ( get_option( 'gc_expiry_extension_product_id' ) == $product_id ) {

				$wps_uwgc_expiry_extension_giftcard_text = ! empty( get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_text', true ) ) ? get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_text', true ) : array();
				$wps_uwgc_expiry_extension_giftcard_price = ! empty( get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_price', true ) ) ? get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_price', true ) : array();
	
				?>
				<p class="form-field">
				<div id="extension_options_group">
					<p><?php esc_html_e( 'Gift Card Expiry Extension Setting', 'giftware' ); ?></p>
					<div class="wps_expiry_extension_desc">
						<span><?php esc_html_e( 'Expiry Days', 'giftware' ); ?></span>
						<span><?php esc_html_e( 'Price', 'giftware' ); ?></span>
					</div>
					<?php
					if ( is_array( $wps_uwgc_expiry_extension_giftcard_price ) && empty( $wps_uwgc_expiry_extension_giftcard_price ) && count( $wps_uwgc_expiry_extension_giftcard_price ) == 0 ) {
						?>
						<div class="wps_uwgc_expiry_extension_giftcard">
							<input type="text" class="wps_uwgc_expiry_extension_giftcard_text" name="wps_uwgc_expiry_extension_giftcard_text[]" placeholder="Eg : 30 ( for 1 months )" value="" required>
							<input type="text" class="wps_uwgc_expiry_extension_giftcard_price wc_input_price" name="wps_uwgc_expiry_extension_giftcard_price[]" placeholder="Enter Price" value="" required>
						</div>
						<?php
					} else {
						if ( is_array( $wps_uwgc_expiry_extension_giftcard_price ) && is_array( $wps_uwgc_expiry_extension_giftcard_text ) && ! empty( $wps_uwgc_expiry_extension_giftcard_price ) && ! empty( $wps_uwgc_expiry_extension_giftcard_text ) && count( $wps_uwgc_expiry_extension_giftcard_price ) >= 1 ) {
							foreach ( $wps_uwgc_expiry_extension_giftcard_price as $key => $value ) {
								?>
								<div class="wps_uwgc_expiry_extension_giftcard">
									<input type="text" class="wps_uwgc_expiry_extension_giftcard_text" name="wps_uwgc_expiry_extension_giftcard_text[]" value="<?php echo esc_html( $wps_uwgc_expiry_extension_giftcard_text[ $key ] ); ?>" required>
									<input type="text" class="wps_uwgc_expiry_extension_giftcard_price wc_input_price" name="wps_uwgc_expiry_extension_giftcard_price[]" value="<?php echo esc_html( $value ); ?>" required>
									<?php if ( $key > 0 ) { ?>
									<a class="wps_remove_more_extension_price button" href="javascript:void(0)"><?php esc_html_e( 'Remove', 'giftware' ); ?></a>
								<?php } ?>
								</div>
								<?php
							}
						}
					}
					?>
					<a href="#" class="wps_add_more_extension_price button"><?php esc_html_e( 'Add', 'giftware' ); ?></a>
				</div>
				</p>
				<?php
			}
		}
	}

	public function wps_uwgc_save_post_expiry_extension( $post_id ) {
		global $post;
		if ( isset( $post_id ) ) {
			if ( ! current_user_can( 'edit_post', $post_id ) || ! is_admin() ) {
				return;
			}
			$product_id = $post_id;
			$product    = wc_get_product( $product_id );
			if ( isset( $product ) && is_object( $product ) && get_option( 'gc_expiry_extension_product_id' ) == $product_id ) {
				$wps_uwgc_expiry_extension_giftcard_text  = isset( $_POST['wps_uwgc_expiry_extension_giftcard_text'] ) ? map_deep( wp_unslash( $_POST['wps_uwgc_expiry_extension_giftcard_text'] ), 'sanitize_text_field' ) : array();
				$wps_uwgc_expiry_extension_giftcard_price = isset( $_POST['wps_uwgc_expiry_extension_giftcard_price'] ) ? map_deep( wp_unslash( $_POST['wps_uwgc_expiry_extension_giftcard_price'] ), 'sanitize_text_field' ) : array();
			
				update_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_text', $wps_uwgc_expiry_extension_giftcard_text );
				update_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_price', $wps_uwgc_expiry_extension_giftcard_price );
			}
		}
	}

	// Add custom fields to the coupon edit page
	public function wps_wgm_custom_coupon_usage_restriction_fields( $coupon_id ) {
		$excluded_days = get_post_meta( $coupon_id, 'wps_wgm_excluded_days', array() );
		?>
		<p class="form-field">
			<label for="wps_wgm_excluded_days"><?php _e( 'Days Excluded', 'giftware' ); ?></label>
			<select id="wps_wgm_excluded_days" name="wps_wgm_excluded_days[]" style="width: 50%;"  class="wc-enhanced-select" multiple="multiple">
				<?php
				$wps_wgm_week_days = array( 
					array(
						'id'   => 'sunday',
						'name' => __('Sunday', 'giftware'),
					),
					array(
						'id'   => 'monday',
						'name' => __('Monday', 'giftware'),
					),
					array(
						'id'   => 'tuesday',
						'name' => __('Tuesday', 'giftware'),
					),
					array(
						'id'   => 'wednesday',
						'name' => __('Wednesday', 'giftware'),
					),
					array(
						'id'   => 'thursday',
						'name' => __('Thursday', 'giftware'),
					),
					array(
						'id'   => 'friday',
						'name' => __('Friday', 'giftware'),
					),
					array(
						'id'   => 'saturday',
						'name' => __('Saturday', 'giftware'),
					),
				);

				if ( isset( $wps_wgm_week_days ) && ! empty( $wps_wgm_week_days ) ) {
					foreach ( $wps_wgm_week_days as $week_day ) {
						$wid         = $week_day['id'];
						$wname       = $week_day['name'];
						$week_select = '';
						if ( is_array( $excluded_days ) && ! empty( $excluded_days ) ) {
							if ( wc_selected( $wid, $excluded_days[0] ) ) {
								$week_select = "selected='selected'";
							}
						}
						?>
						<option value="<?php echo esc_attr( $wid ); ?>" <?php echo esc_html( $week_select ); ?>><?php echo esc_html( $wname ); ?></option>
						<?php
					}
				}
				?>
			</select> <?php echo wc_help_tip( __( 'Select the days when this coupon cannot be used.', 'giftware' ) ); ?>
		</p>
		<?php
	}

	// Save the custom fields
	public function wps_wgm_save_custom_coupon_fields( $post_id ) {
		$excluded_days = isset( $_POST['wps_wgm_excluded_days'] ) ? (array) $_POST['wps_wgm_excluded_days'] : array();
		update_post_meta( $post_id, 'wps_wgm_excluded_days', $excluded_days );
	}
	
}
