<?php
/**
 * Exit if accessed directly
 *
 * @package  Ultimate Woocommerce Gift Cards
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h3 class="wps_wgm_overview_heading"><?php esc_html_e( 'Group Gifting', 'giftware' ); ?><a href="https://docs.wpswings.com/woocommerce-group-gifting?utm_source=wpswings-groupgifting-doc&utm_medium=giftcards-pro-backend&utm_campaign=group-gifting-documentation"  target="_blank" class="button"><span class="dashicons dashicons-media-document"></span><?php esc_html_e( 'DOC', 'giftware' ); ?></a></h3>

<div class="wps_gifting_main_content">
    <h3 class="text-left"><?php esc_html_e( 'Hello Dear', 'giftware' ); ?></h3>	
    <p><?php esc_html_e( 'We are thrilled to announce that we have launched a new feature of Group Gifting.', 'giftware' ); ?></p>

    <p><?php esc_html_e( 'Group Gifting refers to a scenario where multiple individuals contribute money or resources to collectively purchase a gift for someone. This concept is often applied in various contexts, such as birthday gifts, wedding registries, or crowdfunding campaigns for specific items.', 'giftware' ); ?></p>

    <p><?php esc_html_e( 'We have made this just on your demand so we would love your suggestion to improve it.', 'giftware' ); ?></p>
</div>

<div class="wps_wgm_gifting">
    <span><b><?php esc_html_e( 'Group Gifting Feature Doc', 'giftware' ); ?> :- </b><a href="https://docs.wpswings.com/woocommerce-group-gifting?utm_source=wpswings-groupgifting-doc&utm_medium=giftcards-pro-backend&utm_campaign=group-gifting-documentation"  target="_blank" class="button"><span class="dashicons dashicons-media-document"></span><?php esc_html_e( 'DOC', 'giftware' ); ?></a></span>
</div>

<div class="wps_wgm_video_wrapper">
    <h3><?php esc_html_e( 'See it in Action', 'giftware' ); ?></h3>
    <iframe height="411" src="https://www.youtube.com/embed/N4JeJxR98kY" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</div>