<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to create rest api for viewing and managing giftcard
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/admin/partials/templates/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once WPS_WGC_DIRPATH . 'admin/partials/template_settings_function/class-woocommerce-giftcard-admin-settings.php';
$settings_obj = new Woocommerce_Giftcard_Admin_Settings();


// for generating api keys.
if ( isset( $_POST['wps_uwgc_generate_api_key'] ) && ! empty( $_POST['wps_uwgc_generate_api_key'] ) ) {
	$nonce = ( isset( $_POST['verifynonce'] ) ) ? sanitize_text_field( wp_unslash( $_POST['verifynonce'] ) ) : '';
	if ( wp_verify_nonce( $nonce ) ) {
		unset( $_POST['wps_uwgc_generate_api_key'] );
		$api_keys = array();
		for ( $i = 0; $i < 2; $i++ ) {
			$random     = wp_rand();
			$api_keys[] = md5( $random );
		}
		$wps_uwgc_api_keys['consumer_key']    = $api_keys[0];
		$wps_uwgc_api_keys['consumer_secret'] = $api_keys[1];
		$result                               = update_option( 'wps_uwgc_rest_api_keys', $wps_uwgc_api_keys );
		if ( $result ) {
			$wps_uwgc_error_text = esc_html__( 'API Key generated successfully.', 'giftware' );
			$settings_obj->wps_uwgc_plug_admin_notice( $wps_uwgc_error_text, 'success' );
		} else {
			$wps_uwgc_error_text = esc_html__( 'API Key is not created', 'giftware' );
			$settings_obj->wps_uwgc_plug_admin_notice( $wps_uwgc_error_text, 'error' );
		}
	} else {
		$settings_obj->wps_uwgc_plug_admin_notice( esc_html__( 'Failed security check', 'giftware' ), 'error' );
	}
}

// for deleting api keys.
if ( isset( $_GET['action'] ) && ( 'delete_rest_api_keys' === $_GET['action'] ) ) {
	$result = delete_option( 'wps_uwgc_rest_api_keys' );
	if ( $result ) {
		wp_safe_redirect( admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=rest-api' ) );
		$wps_uwgc_error_text = esc_html__( 'API Key deleted successfully.', 'giftware' );
		$settings_obj->wps_uwgc_plug_admin_notice( $wps_uwgc_error_text, 'success' );
	} else {
		wp_safe_redirect( admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=rest-api' ) );
		$wps_uwgc_error_text = esc_html__( 'API Key is not deleted', 'giftware' );
		$settings_obj->wps_uwgc_plug_admin_notice( $wps_uwgc_error_text, 'error' );
	}
}
?>

<h3 class="wps_wgm_overview_heading"><?php esc_html_e( 'REST API Settings', 'giftware' ); ?></h3>
<div class="wps_wgm_table_wrapper">	
	<div class="wps_table">
		<table class="form-table wps-uwgc-giftcard-rest-api">
			<tbody>
                <?php
                $rest_api_keys = get_option( 'wps_uwgc_rest_api_keys', '' );
                $store_url     = site_url();
                if ( empty( $rest_api_keys ) || ! is_array( $rest_api_keys ) ) {
                    ?>
                    <form action="" method="POST" > 
                        <div class="wpg-secion-wrap">
                            <div class="wps-form-group wps-form-group2">
                                <div class="wps-form-group__control">
            
                                    <p><?php esc_html_e( 'REST API allows external apps to view and manage Giftcard. Access is granted only to those with valid API keys.', 'giftware' ); ?></p>
                                    <input type="hidden" id="verifynonce" name="verifynonce" value="<?php echo esc_attr( wp_create_nonce() ); ?>" />
                                    <input type="submit" class="wps-btn wps_wgm_save_button wps-btn__filled" name="wps_uwgc_generate_api_key"  value="Generate API key">
                                </div>
                            </div>
                        </div>
                    </form>
                    <?php
                } else {
                    ?>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th>
                                    <label><?php esc_html_e( 'Consumer Key', 'giftware' ); ?></label>
                                </th>
                                <td>
                                    <input type="text" name="consumer_key" class="uwgc-number-class" value="<?php echo esc_attr( $rest_api_keys['consumer_key'] ); ?>" disabled >
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <label><?php esc_html_e( 'Consumer Secret', 'giftware' ); ?></label>
                                </th>
                                <td>
                                    <input type="text" name="consumer_secret" class="uwgc-number-class" value="<?php echo esc_attr( $rest_api_keys['consumer_secret'] ); ?>" disabled >
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <p><a href="<?php echo esc_url( admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=rest-api' ) ); ?>&action=delete_rest_api_keys" class="wps-btn wps_wgm_save_button delete_keys" ><?php esc_html_e( 'Delete API Keys', 'giftware' ); ?></a></p>
                    <?php
                }
            	?>
			</tbody>
		</table>
	</div>
</div>

	<h3><?php esc_html_e( 'REST API details', 'giftware' ); ?></h3>
	<p>
	<?php
	echo '<strong>' . esc_html__( 'Base Url for accessing Gift Card Coupons : ', 'giftware' ) . '</strong>';
	echo '{home_url}/wp-json/api/v1/giftcard/';
	?>
	</p>
	<p>
	<?php
	esc_html_e( 'Your Base Url : ', 'giftware' );
	echo esc_html( $store_url );
	esc_html_e( '/wp-json/api/v1/giftcard/ ', 'giftware' );
	?>
	</p>
	<h4><?php esc_html_e( 'Authentication', 'giftware' ); ?></h4> 
	<p>
	<?php
	esc_html_e( 'For authentication you need Consumer Key  ', 'giftware' );
	echo '<strong>consumer_key</strong>';
	esc_html_e( ' and Consumer Secret  ', 'giftware' );
	echo '<strong>consumer_secret </strong>';
	esc_html_e( 'keys. Response on wrong api details:', 'giftware' );
	?>
	</p>

	<?php
	echo '<pre>
    {
        "code": "rest_forbidden",
        "message": "Sorry, your key details are incorrect.",
        "data": {
            "status": 401
        }
    }
	</pre>';
	?>


	<h4><?php esc_html_e( 'Retrieve GiftCard Coupon Details : ', 'giftware' ); ?></h4> 
	<p><?php echo '<strong><code>POST {home_url}/wp-json/api/v1/giftcard/coupon-details</code></strong>'; ?><p>
	<p>
	<?php
	esc_html_e( 'Your Url : ', 'giftware' );
	echo esc_html( $store_url );
	esc_html_e( '/wp-json/api/v1/giftcard/coupon-details', 'giftware' );
	?>
	</p>
	<p>
		<?php esc_html_e( 'Required Parameters : consumer_key, consumer_secret, coupon_code', 'giftware' ); ?>
	</p>
	<p><?php esc_html_e( 'JSON request example:', 'giftware' ); ?></p>
	<?php
	$rest_api_keys = get_option( 'wps_uwgc_rest_api_keys', '' );
	if ( ! empty( $rest_api_keys ) && is_array( $rest_api_keys ) ) {
		$key    = $rest_api_keys['consumer_key'];
		$secret = $rest_api_keys['consumer_secret'];
	} else {
		$key    = 'XXXXX';
		$secret = 'XXXXX';
	}
	?>
	<pre><?php echo esc_html( json_encode( [
			'consumer_key'    => $key,
			'consumer_secret' => $secret,
			'coupon_code'     => 'wps-uwsqb'
		], JSON_PRETTY_PRINT ) ); 
	?>
	</pre>
	<p><?php esc_html_e( 'JSON response example:', 'giftware' ); ?></p>
	<?php
	echo '<pre>
    {
        "code": "success",
        "message": "There is Giftcard Coupon Details",
        "remaining_amount": "10",
        "discount_type": "fixed_cart",
        "usage_count": 2,
        "usage_limit": 10,
        "description": "GIFTCARD ORDER #491",
        "coupon_expiry": "15/05/2025"
    }
	</pre>';
	?>


	<h4><?php esc_html_e( 'Gift Card Coupon Redeem : ', 'giftware' ); ?></h4> 
	<p><?php echo '<strong><code>POST {home_url}/wp-json/api/v1/giftcard/redeem-coupon</code></strong>'; ?><p>
	<p>
	<?php
	esc_html_e( 'Your Url : ', 'giftware' );
	echo esc_html( $store_url );
	esc_html_e( '/wp-json/api/v1/giftcard/redeem-coupon', 'giftware' );
	?>
	</p>
	<p>
		<?php esc_html_e( 'Required Parameters : consumer_key, consumer_secret, coupon_code, redeem_amount', 'giftware' ); ?>
	</p>
	<p><?php esc_html_e( 'JSON request example:', 'giftware' ); ?></p>
	<?php
	$rest_api_keys = get_option( 'wps_uwgc_rest_api_keys', '' );
	if ( ! empty( $rest_api_keys ) && is_array( $rest_api_keys ) ) {
		$key    = $rest_api_keys['consumer_key'];
		$secret = $rest_api_keys['consumer_secret'];
	} else {
		$key    = 'XXXXX';
		$secret = 'XXXXX';
	}
	?>
	<pre><?php echo esc_html( json_encode( [
		'consumer_key'    => sanitize_text_field( $key ),
		'consumer_secret' => sanitize_text_field( $secret ),
		'coupon_code'     => 'wps-uwsqb',
		'redeem_amount'   => 5
	], JSON_PRETTY_PRINT ) ); ?>
	</pre>
	<p><?php esc_html_e( 'JSON response example:', 'giftware' ); ?></p>
	<?php
	echo '<pre>
    {
        "code": "success",
        "message": "Coupon is successfully Redeemed",
        "remaining_amount": 12,
        "discount_type": "fixed_cart",
        "usage_count": 3,
        "usage_limit": 10,
        "description": "GIFTCARD ORDER #491",
        "coupon_expiry": "30/05/2024"
    }
	</pre>';
	?>


	<h4><?php esc_html_e( 'Gift Card Coupon Recharge/Update Details ( Coupon Amount, Coupon Expiry, Usage Count, Usage Limit ) : ', 'giftware' ); ?></h4> 
	<p><?php echo '<strong><code>POST {home_url}/wp-json/api/v1/giftcard/recharge-coupon</code></strong>'; ?><p>
	<p>
	<?php
	esc_html_e( 'Your Url : ', 'giftware' );
	echo esc_html( $store_url );
	esc_html_e( '/wp-json/api/v1/giftcard/recharge-coupon', 'giftware' );
	?>
	</p>
	<p>
		<?php esc_html_e( 'Required Parameters : consumer_key, consumer_secret, coupon_code, recharge_amount', 'giftware' ); ?>
	</p>
	<p>
		<?php esc_html_e( 'Optional Parameters : coupon_expiry( in timestamp ), usage_count, usage_limit', 'giftware' ); ?>
	</p>
	<p><?php esc_html_e( 'JSON request example:', 'giftware' ); ?></p>
	<?php
	$rest_api_keys = get_option( 'wps_uwgc_rest_api_keys', '' );
	if ( ! empty( $rest_api_keys ) && is_array( $rest_api_keys ) ) {
		$key    = $rest_api_keys['consumer_key'];
		$secret = $rest_api_keys['consumer_secret'];
	} else {
		$key    = 'XXXXX';
		$secret = 'XXXXX';
	}
	?>
	<pre><?php echo esc_html( json_encode( [
		'consumer_key'    => sanitize_text_field( $key ),
		'consumer_secret' => sanitize_text_field( $secret ),
		'coupon_code'     => 'wps-uwsqb',
		'recharge_amount' => 6,
		'coupon_expiry'   => '1717050604',
		'usage_count'     => 2,
		'usage_limit'     => 10
	], JSON_PRETTY_PRINT ) ); ?>
	</pre>
	<p><?php esc_html_e( 'JSON response example:', 'giftware' ); ?></p>
	<?php
	echo '<pre>
    {
        "code": "success",
        "message": "Coupon is successfully Recharged",
        "remaining_amount": 18,
        "discount_type": "fixed_cart",
        "usage_count": 2,
        "usage_limit": 10,
        "description": "GIFTCARD ORDER #491",
        "coupon_expiry": "30/05/2024"
    }
	</pre>';
	?>
