<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://wpswings.com/
 * @since             1.0.0
 * @package           Ultimate Woocommerce Gift Cards
 *
 * @wordpress-plugin
 * Plugin Name:       Gift Cards For WooCommerce Pro
 * Plugin URI:        https://wpswings.com/product/gift-cards-for-woocommerce-pro/?utm_source=wpswings-giftcards-pro&utm_medium=giftcards-pro-backend&utm_campaign=giftcards-pro
 * Description:        <code><strong>Gift Cards for WooCommerce Pro</strong></code> plugin allows merchants to sell, and create gift cards on the WordPress website by increasing sales and revenue. <a href="https://wpswings.com/woocommerce-plugins/?utm_source=wpswings-giftcards-shop&utm_medium=giftcards-pro-backend&utm_campaign=shop-page" target="_blank"> Elevate your e-commerce store by exploring more on <strong> WP Swings </strong></a>.
 * Version:           4.1.3
 * Author:            WP Swings
 * Author URI:        https://wpswings.com/?utm_source=wpswings-giftcards-official&utm_medium=giftcards-pro-backend&utm_campaign=official
 * Requires at least: 5.5.0
 * Tested up to:      6.7.2
 * WC tested up to:   9.7.1
 * License:           WP Swings License
 * License URI:       https://wpswings.com/license-agreement.txt
 * Text Domain:       giftware
 * Requires Plugins:  woocommerce
 * Domain Path:       /languages
 */

// If this file is called directly, abort.

if ( ! defined( 'WPINC' ) ) {
	die;
}

use Automattic\WooCommerce\Utilities\OrderUtil;
$host     = isset( $_SERVER['HTTP_HOST'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_HOST'] ) ) : '';
update_option( 'wps_gw_lcns_key'. $host, 'xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx' );
update_option( 'wps_gw_lcns_status', 'true' );
update_option( 'wps_gc_pro_valid_license', true );
update_option( 'wps_gc_pro_subscription_status', false );
delete_option( 'wps_gc_pro_subscription_renewdate' );
require_once ABSPATH . 'wp-admin/includes/plugin.php';
$activated = false;

$wps_lite_plugin = 'woo-gift-cards-lite/woocommerce_gift_cards_lite.php';
$wps_wgm_woo_plugin = 'woocommerce/woocommerce.php';

if ( function_exists( 'is_multisite' ) && is_multisite() ) {
	include_once ABSPATH . 'wp-admin/includes/plugin.php';
	if ( file_exists( WP_PLUGIN_DIR . '/' . $wps_wgm_woo_plugin ) && is_plugin_active( 'woocommerce/woocommerce.php' ) && file_exists( WP_PLUGIN_DIR . '/' . $wps_lite_plugin ) && is_plugin_active( 'woo-gift-cards-lite/woocommerce_gift_cards_lite.php' ) ) {
		$activated = true;
	}
} else {
	if ( file_exists( WP_PLUGIN_DIR . '/' . $wps_wgm_woo_plugin ) && is_plugin_active( 'woocommerce/woocommerce.php' ) && file_exists( WP_PLUGIN_DIR . '/' . $wps_lite_plugin ) && in_array( 'woo-gift-cards-lite/woocommerce_gift_cards_lite.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		$activated = true;
	}
}
define( 'WPS_UWGC_PLUGIN_VERSION', '4.1.3' );

add_action( 'before_woocommerce_init', 'wps_uwgc_declare_hpos_compatibility' );
/**
 * Hpos and cart/checkout block compatibility.
 */
function wps_uwgc_declare_hpos_compatibility() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
	if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
	}
}

/*Check If Ultimate Gift card lite is Active*/
if ( $activated && is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
	$wp_upload     = wp_upload_dir();
	$wp_upload_dir = $wp_upload['basedir'];
	$wp_upload_url = $wp_upload['baseurl'];
	define( 'WPS_UWGC_UPLOAD_DIR', $wp_upload_dir );
	define( 'WPS_UWGC_UPLOAD_URL', $wp_upload_url );
	define( 'WPS_UWGC_DIRPATH', plugin_dir_path( __FILE__ ) );
	define( 'WPS_UWGC_URL', plugin_dir_url( __FILE__ ) );
	define( 'WPS_UWGC_ADMIN_URL', admin_url() );
	define( 'WPS_UWGC_SPECIAL_SECRET_KEY', '59f32ad2f20102.74284991' );
	define( 'WPS_UWGC_SERVER_URL', 'https://wpswings.com' );
	define( 'WPS_UWGC_ITEM_REFERENCE', 'giftware' );
	define( 'WPS_TEMPLATE_URL', 'https://demo.wpswings.com/client-notification/' );
	global $wp_version;
	if ( $wp_version >= '4.9.6' ) {
		include_once WPS_UWGC_DIRPATH . 'ultimate-woocommerce-gift-card-gdpr.php';
	}
	add_filter( 'plugin_action_links', 'wps_uwgc_admin_settings', 10, 2 );

	/**
	 * Register eraser for Plugin user data.
	 *
	 * @param array $actions Actions.
	 * @param array $plugin_file Plugin file.
	 * @return array
	 */
	function wps_uwgc_admin_settings( $actions, $plugin_file ) {
		static $plugin;
		if ( ! isset( $plugin ) ) {
			$plugin = plugin_basename( __FILE__ );
		}
		if ( $plugin == $plugin_file ) {
			$settings     = array(
				'settings' => '<a href="' . admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=general_setting' ) . '">' . __( 'Settings', 'giftware' ) . '</a>',
			);
			$callname_lic = Ultimate_Woocommerce_Gift_Card::$lic_callback_function;
			if ( ! Ultimate_Woocommerce_Gift_Card::$callname_lic() ) {
				$settings['license'] = '<a href="' . admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=validate_license' ) . '">' . __( 'Activate License', 'giftware' ) . '</a>';
			}
			$actions = array_merge( $settings, $actions );
		}
		return $actions;
	}

	add_action( 'admin_init', 'wps_uwgc_create_giftcard_template' );

	/**
	 * Function to create giftcard template.
	 */
	function wps_uwgc_create_giftcard_template() {
		// create folder for qrcode/barcode.
		$upload_dir_path = WPS_UWGC_UPLOAD_DIR . '/qrcode_barcode';
		if ( ! is_dir( $upload_dir_path ) ) {
			wp_mkdir_p( $upload_dir_path );
			chmod( $upload_dir_path, 0775 );
		}

	}
	register_activation_hook( __FILE__, 'activate_ultimate_woocommerce_gift_card' );
	register_deactivation_hook( __FILE__, 'deactivate_ultimate_woocommerce_gift_card' );
	/**
	 * The code that runs during plugin activation.
	 * This action is documented in includes/class-ultimate-woocommerce-gift-card-activator.php
	 */
	function activate_ultimate_woocommerce_gift_card() {
		
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-ultimate-woocommerce-gift-card-activator.php';
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-ultimate-woocommerce-gift-cards-activation.php';
		$restore_data = new Ultimate_Woocommerce_Gift_Cards_Activation();
		$restore_data->wps_wgm_restore_data_pro();
		$restore_data->wps_wgm_enable_mpdf_for_new_user();
	
		Ultimate_Woocommerce_Gift_Card_Activator::activate();
		set_transient( 'wps-uwgc-admin-activation-notice', true, 5 );
		flush_rewrite_rules();
	}

	/**
	 * The code that runs during plugin deactivation.
	 * This action is documented in includes/class-ultimate-woocommerce-gift-card-deactivator.php
	 */
	function deactivate_ultimate_woocommerce_gift_card() {
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-ultimate-woocommerce-gift-card-deactivator.php';
		Ultimate_Woocommerce_Gift_Card_Deactivator::deactivate();
		flush_rewrite_rules();
	}

	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and public-facing site hooks.
	 */
	require plugin_dir_path( __FILE__ ) . 'includes/class-ultimate-woocommerce-gift-card.php';
	/**
	 * Begins execution of the plugin.
	 *
	 * Since everything within the plugin is registered via hooks,
	 * then kicking off the plugin from this point in the file does
	 * not affect the page life cycle.
	 *
	 * @since    1.0.0
	 */
	function run_ultimate_woocommerce_gift_card() {
		$plugin = new Ultimate_Woocommerce_Gift_Card();
		$plugin->run();
	}
	run_ultimate_woocommerce_gift_card();

	add_action( 'admin_init', 'wps_uwgc_giftcard_scheduling_cron' );

	/**
	 * Schedule Giftcard.
	 */
	function wps_uwgc_giftcard_scheduling_cron() {

		$offset = get_option( 'gmt_offset' );
		$time   = time() + $offset * 60 * 60;
		if ( ! wp_next_scheduled( 'wps_gw_giftcard_cron_schedule' ) ) {
			wp_schedule_event( $time, 'hourly', 'wps_gw_giftcard_cron_schedule' );
		}
		if ( ! wp_next_scheduled( 'wps_gw_giftcard_cron_delete_images' ) ) {
			wp_schedule_event( $time, 'daily', 'wps_gw_giftcard_cron_delete_images' );
		}
	}

	register_deactivation_hook( __FILE__, 'wps_uwgc_remove_cron_delete_images' );

	add_action( 'admin_init', 'wps_uwgc_offline_giftcard_table' );
	/**
	 * Schedule Giftcard.
	 */
	function wps_uwgc_offline_giftcard_table() {

		$offline_giftcard = get_option( 'wps_wgm_offline_giftcard', false );
		if ( empty( $offline_giftcard ) ) {
			global $wpdb;
			$table_name      = $wpdb->prefix . 'offline_giftcard';
			$charset_collate = '';
			if ( ! empty( $wpdb->charset ) ) {
				$charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
			}

			if ( ! empty( $wpdb->collate ) ) {
				$charset_collate .= " COLLATE {$wpdb->collate}";
			}
			$create_tbl = "
			CREATE TABLE IF NOT EXISTS `$table_name` (
				`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`to` text,
				`from` text,
				`message` text,
				`amount` text,
				`coupon` text,
				`template` text,
				`mail` text,	
				`date` datetime,
				`schedule` date,
				PRIMARY KEY (`id`)
			);";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta( $create_tbl );
			$add_schedule = get_option( 'wps_wgm_add_schedule', false );

			if ( false == $add_schedule ) {
				update_option( 'wps_wgm_add_schedule', true );
				if ( ! empty( $wpdb->query ) ) {
					$wpdb->query( "ALTER TABLE $table_name ADD COLUMN `schedule` DATE" );
				}
			}
			update_option( 'wps_wgm_offline_giftcard', true );
		}
	}

	register_deactivation_hook( __FILE__, 'wps_uwgc_remove_cron_schedule' );
	/**
	 * This function is used to remove the cron schedule
	 *
	 * @name wps_uwgc_remove_cron_schedule
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function wps_uwgc_remove_cron_schedule() {
		wp_clear_scheduled_hook( 'wps_gw_giftcard_cron_schedule' );
	}

	/**
	 * This function is used to remove the cron schedule for deleting images
	 *
	 * @name wps_uwgc_remove_cron_delete_image.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function wps_uwgc_remove_cron_delete_images() {
		wp_clear_scheduled_hook( 'wps_gw_giftcard_cron_delete_images' );
	}
	add_action( 'admin_notices', 'wps_uwgc_license_notice_on_activation' );
	/**
	 * Wps_uwgc_license_notice_on_activation.
	 *
	 * @return void
	 */
	function wps_uwgc_license_notice_on_activation() {
		global $pagenow;
		$screen = get_current_screen();
		if ( isset( $screen->id ) ) {
			$pagescreen = $screen->id;
		}
		if ( isset( $pagescreen ) && 'plugins' === $pagescreen ) {
			/* Check transient, if available display notice */
			if ( get_transient( 'wps-uwgc-admin-activation-notice' ) ) {
				?>
				<div class="updated notice is-dismissible" class="wps-wgm-is-dismissible">
				<p class="wps_wgm_plugin_active_para"><strong><?php esc_html_e( 'Welcome to Ultimate WooCommerce Gift Cards ', 'giftware' ); ?></strong><span style="background: black;color: #fff;padding: 2px 5px;margin-right: 3px;"><?php esc_html_e( ' Premium ', 'giftware' ); ?></span><?php esc_html_e( ' -Create and sell multiple Gift Cards with ease.', 'giftware' ); ?></p>
				<p class="wps_show_setting_on_activation">
					<?php
					$general_settings               = get_option( 'wps_wgm_general_settings', array() );
					$wps_obj                        = new Woocommerce_Gift_Cards_Common_Function();
					$wps_wgm_general_setting_enable = $wps_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable' );
					if ( 'on' !== $wps_wgm_general_setting_enable ) {
						?>
						<a class="wps_wgm_plugin_activation_msg" href="<?php echo esc_url( admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=general_setting' ) ); ?>"><?php echo esc_html__( 'Enable Gift Cards', 'giftware' ); ?></a>
						<?php
					}
					$callname_lic = Ultimate_Woocommerce_Gift_Card::$lic_callback_function;
					if ( ! Ultimate_Woocommerce_Gift_Card::$callname_lic() ) {
						?>
						<a class="wps_wgm_plugin_activation_msg" href="<?php echo esc_url( admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=validate_license' ) ); ?>"><?php echo esc_html__( 'Activate License', 'giftware' ); ?></a>
						<?php
					}
					?>
				</p>		
				</div>
				<?php
				/* Delete transient, only display this notice once. */
				delete_transient( 'wps-uwgc-admin-activation-notice' );
			}
		}
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_obj = new Woocommerce_Gift_Cards_Common_Function();
		$enable_pdf = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_pdf_enable' );
		$wps_wgm_select_library = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );

		if ( 'plugins.php' == $pagenow || 'giftcard_page_wps-wgc-setting-lite' === $pagescreen || 'edit-giftcard' == $pagescreen || 'giftcard_page_uwgc-import-giftcard-templates' == $pagescreen ) {
			if ( 'on' == $enable_pdf && 'mpdf' != $wps_wgm_select_library ) {
				echo '<div  class="notice notice-success is-dismissible wps-gc-activate_notice wps-new-setting-notice update-nag">
						<a href="' . esc_url( admin_url( 'edit.php?post_type=giftcard&page=wps-wgc-setting-lite&tab=other_setting' ) ) . '">Click here</a>
						  to <strong> Switch on MPdf library, WKHTMLTOPDF will be deprecated soon</strong>.
						 Import supported templates from 
						<a href="' . esc_url( admin_url( 'edit.php?post_type=giftcard&page=uwgc-import-giftcard-templates' ) ) . '">here</a>, Old imported/custom templates unsupported.
					</div>';
			}
		}
	}
	/**
	 * Contri product default image.
	 */
	add_action( 'admin_init', 'wps_set_contri_product_thumbnail_image' );

	function wps_set_contri_product_thumbnail_image() {

		$post_id = get_option( 'contributor_product_id' );
		$thumbnail_image = get_option( 'file_updated_yes', 'no' );
		if ( 'yes' != $thumbnail_image && ! empty( $post_id ) ) {
			// Add Featured Image to Post.
				// Add Featured Image to Post.
				$image_url        = WPS_UWGC_URL . 'assets/images/contribution.jpg'; // Define the image URL here.

				$image_name       = 'contribution.jpg';
				$upload_dir       = wp_upload_dir(); // Set upload folder.
				$image_data       = file_get_contents( $image_url ); // Get image data.

				$unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name.
				$filename         = basename( $unique_file_name ); // Create image file name.

				// Check folder permission and define file location.
			if ( wp_mkdir_p( $upload_dir['path'] ) ) {
				$file = $upload_dir['path'] . '/' . $filename;
			} else {
				$file = $upload_dir['basedir'] . '/' . $filename;
			}

				// Create the image  file on the server.
				file_put_contents( $file, $image_data );

				// Check image file type.
				$wp_filetype = wp_check_filetype( $filename, null );

				// Set attachment data.
				$attachment = array(
					'post_mime_type' => $wp_filetype['type'],
					'post_title'     => sanitize_file_name( $filename ),
					'post_content'   => '',
					'post_status'    => 'inherit',
				);

				// Create the attachment.
				$attach_id = wp_insert_attachment( $attachment, $file, $post_id );

				// Include image.php.
				require_once( ABSPATH . 'wp-admin/includes/image.php' );

				// Define attachment metadata.
				$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

				// Assign metadata to attachment.
				wp_update_attachment_metadata( $attach_id, $attach_data );

				// And finally assign featured image to post.
				set_post_thumbnail( $post_id, $attach_id );
				update_option( 'file_updated_yes', 'yes' );
		}

	}
	// Multisite Compatibilty for new site creation.
	add_action( 'wps_wgm_standard_plugin_on_create_blog', 'wps_wgm_standard_plugin_on_create_blog', 10, 3 );
	/**
	 * Compatibilty with multisite.
	 *
	 * @param string $wps_lcns_status status.
	 * @param string $wps_license_key license code.
	 * @param string $timestamp       timestamp.
	 * @return void
	 */
	function wps_wgm_standard_plugin_on_create_blog( $wps_lcns_status, $wps_license_key, $timestamp ) {
		update_option( 'wps_gw_lcns_key', $wps_license_key );
		update_option( 'wps_gw_lcns_status', $wps_lcns_status );
		update_option( 'wps_gw_lcns_thirty_days', $timestamp );
	}
} else {
	add_action( 'admin_enqueue_scripts', 'wps_uwgc_enqueue_activation_script' );
	add_action( 'admin_init', 'wps_uwgc_plugin_error_notice' );
	add_action( 'wp_ajax_wps_uwgc_activate_lite_plugin', 'wps_uwgc_activate_lite_plugin' );
	add_action( 'wp_ajax_wps_uwgc_dismiss_plugin_notice', 'wps_uwgc_dismiss_plugin_notice' );

	/**
	 * Plugin error notice.
	 */
	function wps_uwgc_plugin_error_notice() {
		// to hide Plugin activated notice.
		unset( $_GET['activate'] );
		
		$wps_wgm_woo_plugin = 'woocommerce/woocommerce.php';
		$wps_lite_plugin = 'woo-gift-cards-lite/woocommerce_gift_cards_lite.php';

		if ( ! file_exists( WP_PLUGIN_DIR . '/' . $wps_wgm_woo_plugin ) || ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
			?>
			<div class="notice notice-error is-dismissible">
				<p><?php esc_html_e( 'WooCommerce is not activated, Please activate WooCommerce first to activate Ultimate WooCommerce Gift Cards Pro.', 'giftware' ); ?></p>
			</div>

			<?php
		} elseif ( ! file_exists( WP_PLUGIN_DIR . '/' . $wps_lite_plugin ) || ! is_plugin_active( 'woo-gift-cards-lite/woocommerce_gift_cards_lite.php' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
			?>

			<div class="notice notice-error is-dismissible">
				<p><?php esc_html_e( 'Ultimate Gift Cards For WooCommerce is not activated, Please activate ', 'giftware' ); ?>
				<a href="<?php echo esc_url( 'https://wordpress.org/plugins/woo-gift-cards-lite/?utm_source=wps-org-plugin&utm_medium=org-plugin&utm_campaign=free-plugin' ); ?>"><?php esc_html_e( ' Ultimate Gift Cards For WooCommerce ', 'giftware' ); ?></a>
				<?php esc_html_e( 'first to activate Ultimate WooCommerce Gift Cards Pro.', 'giftware' ); ?>
				</p>
				<?php
				if ( file_exists( WP_PLUGIN_DIR . '/' . $wps_lite_plugin ) && ! is_plugin_active( 'woo-gift-cards-lite' ) ) {
					?>

						<p>
							<a class="button button-primary" href="<?php echo esc_attr( wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $wps_lite_plugin . '&amp;plugin_status=all&amp;paged=1&amp;s=', 'activate-plugin_' . $wps_lite_plugin ) ); ?>"><?php esc_html_e( 'Activate', 'giftware' ); ?></a>
						</p>
					<?php
				} else {
					?>
							<p>
								<a href = "#" id="wps-uwgc-install-lite" class="button button-primary"><?php esc_html_e( 'Install', 'giftware' ); ?></a>
								<span style="display: none;" class="wps_loader_style" id="wps_notice_loader">
									<img src="<?php echo esc_url( plugin_dir_url( __FILE__ ) ); ?>assets/images/loading.gif">
								</span>
							</p>
						<?php
				}
				?>
			</div>

			<?php
		}

	}
	
	/**
	 * Enqueue js and css.
	 */
	function wps_uwgc_enqueue_activation_script() {
		$wps_uwgc_params = array(
			'ajax_url'       => admin_url( 'admin-ajax.php' ),
			'wps_uwgc_nonce' => wp_create_nonce( 'wps-uwgc-activation-nonce' ),
		);
		wp_enqueue_script( 'wps-uwgc-activation-js', plugin_dir_url( __FILE__ ) . 'admin/js/wps-uwgc-activation.js', array( 'jquery' ), '1.0.0', false );
		wp_localize_script( 'wps-uwgc-activation-js', 'wps_uwgc_activation', $wps_uwgc_params );
		wp_enqueue_style( 'wps-uwgc-activation-css', plugin_dir_url( __FILE__ ) . 'admin/css/wps-uwgc-activation.css', array(), '1.0.0' );
	}

	/**
	 * Install lite plugin on ajax request.
	 */
	function wps_uwgc_activate_lite_plugin() {
		include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
		include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

		$wps_plugin_name = 'woo-gift-cards-lite';
		$wps_plugin_api  = plugins_api(
			'plugin_information',
			array(
				'slug'   => $wps_plugin_name,
				'fields' => array( 'sections' => false ),
			)
		);

		if ( isset( $wps_plugin_api->download_link ) ) {
			$wps_ajax_obj = new WP_Ajax_Upgrader_Skin();
			$wps_obj      = new Plugin_Upgrader( $wps_ajax_obj );
			$wps_install  = $wps_obj->install( $wps_plugin_api->download_link );
			activate_plugin( 'woo-gift-cards-lite/woocommerce_gift_cards_lite.php' );
		}
		echo 'success';
		wp_die();
	}

	/**
	 * Dismiss the notice.
	 */
	function wps_uwgc_dismiss_plugin_notice() {
		check_ajax_referer( 'wps-uwgc-activation-nonce', 'wps_nonce' );
		deactivate_plugins( plugin_basename( __FILE__ ) );
		echo 'success';
		wp_die();
	}
}


$wps_uwgc_license_key_pre = get_option( 'wps_gw_lcns_key', '' );
$wps_uwgc_server_host     = isset( $_SERVER['HTTP_HOST'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_HOST'] ) ) : '';
$wps_uwgc_license_key     = get_option( 'wps_gw_lcns_key' . $wps_uwgc_server_host, $wps_uwgc_license_key_pre );
define( 'WPS_UWGC_LICENSE_KEY', $wps_uwgc_license_key );
define( 'WPS_UWGC_FILE', __FILE__ );
$wps_uwgc_update_check = 'https://wpswings.com/pluginupdates/giftware/update.php';
require_once 'class-wps-uwgc-update.php';
