<?php
/**
 * Fired during plugin activation
 *
 * @link       https://wpswings.com
 * @since      1.0.0
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/includes
 * @author     WP Swings <webmaster@wpswings.com>
 */
class Ultimate_Woocommerce_Gift_Card_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		$timestamp = get_option( 'wps_gw_lcns_thirty_days', 'not_set' );
		if ( 'not_set' === $timestamp ) {

			$current_time = current_time( 'timestamp' );

			$thirty_days = strtotime( '+30 days', $current_time );

			update_option( 'wps_gw_lcns_thirty_days', $thirty_days );
		}
		if ( ! wp_next_scheduled( 'wps_gw_license_daily' ) ) {
			wp_schedule_event( time(), 'daily', 'wps_gw_license_daily' );
		}

		$wps_obj = new Woocommerce_Gift_Cards_Common_Function();
		$product_id = get_option( 'gc_expiry_extension_product_id' );
		$product_settings = get_option( 'wps_wgm_product_settings', true );
		$wps_wgm_product_setting_expiry_extension = $wps_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_product_setting_expiry_extension' );
		
		if ( $product_id && 'on' == $wps_wgm_product_setting_expiry_extension ) {
			$productdata = wc_get_product( $product_id );
			$productdata->set_catalog_visibility( 'visible' );
			$productdata->save();
		}
	}


}

