<?php
/**
 * Fired during plugin activation
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/package/rest-api/version1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! class_exists( 'Giftcard_For_Woocommerce_Rest_Api_Process' ) ) {

	/**
	 * The plugin API class.
	 *
	 * This is used to define the functions and data manipulation for custom endpoints.
	 *
	 * @since      1.0.0
	 * @package    Ultimate Woocommerce Gift Cards
	 * @subpackage Ultimate Woocommerce Gift Cards/package/rest-api/version1
	 * @author     WP Swings <webmaster@wpswings.com>
	 */
	class Giftcard_For_Woocommerce_Rest_Api_Process {

		/**
		 * Initialize the class and set its properties.
		 *
		 * @since    1.0.0
		 */
		public function __construct() {

		}

		/**
		 * Fetch the coupon details.
		 *
		 * @return array
		 */
		public function wps_uwgc_giftcard_fetch_details( $coupon_code ) {
            global $woocommerce;
            $coupon_code = strtolower( $coupon_code );

            $coupon_details = new WC_Coupon( $coupon_code );
            $coupon_id = $coupon_details->get_id();
            if ( '' !== $coupon_id && 0 !== $coupon_id ) {

                $woo_ver = WC()->version;
                if ( $woo_ver < '3.6.0' ) {

                    $coupon_expiry = get_post_meta( $coupon_id, 'expiry_date', true );

                } else {
                    $coupon_expiry = get_post_meta( $coupon_id, 'date_expires', true );
                }

                $response['status']  = 200;

                $data = array(
                    'code' => 'success',
                    'message' => 'There is Giftcard Coupon Details',
                    'remaining_amount' => $coupon_details->get_amount(),
                    'discount_type' => $coupon_details->get_discount_type(),
                    'usage_count' => $coupon_details->get_usage_count(),
                    'usage_limit' => $coupon_details->get_usage_limit(),
                    'description' => $coupon_details->get_description(),
                    'coupon_expiry' => ! empty( $coupon_expiry ) ? date( "d/m/Y", $coupon_expiry ) : 'No Expiration',
                );
                $response['data'] = $data;
            } else {
                $response['code']    = 'error';
                $response['message'] = 'Coupon is not a valid Giftcard Coupon';
                $response['status']  = 404;
            }
            return $response;
		}

		/**
		 * Redeem the Coupon code amount
		 *
		 * @param int $coupon_code
		 * @return array
		 */
		public function wps_uwgc_giftcard_redeem( $coupon_code, $redeem_amount ) {
			global $woocommerce;
            $coupon_code = strtolower( $coupon_code );

            $the_coupon = new WC_Coupon( $coupon_code );
            $coupon_id = $the_coupon->get_id();
            if ( '' !== $coupon_id && 0 !== $coupon_id ) {
                $coupon_amount      = get_post_meta( $coupon_id, 'coupon_amount', true );
                $coupon_usage_count = get_post_meta( $coupon_id, 'usage_count', true );
                $coupon_usage_limit = get_post_meta( $coupon_id, 'usage_limit', true );

                if ( 0 == $coupon_usage_limit || $coupon_usage_limit > $coupon_usage_count ) {

                    $woo_ver = WC()->version;

                    $coupon_expiry = '';
                    if ( $woo_ver < '3.6.0' ) {

                        $coupon_expiry = get_post_meta( $coupon_id, 'expiry_date', true );

                    } else {
                        $coupon_expiry = get_post_meta( $coupon_id, 'date_expires', true );
                    }

                    $giftcardcoupon_order_id = get_post_meta( $coupon_id, 'wps_wgm_giftcard_coupon', true );

                    if ( '' == $coupon_expiry || $coupon_expiry > current_time( 'timestamp' ) ) {

                        if ( isset( $redeem_amount ) && ! empty ( $redeem_amount ) && 0 != $redeem_amount && 0 < $redeem_amount ) {

                            if ( $coupon_amount >= $redeem_amount ) {

                                $remaining_amount = $coupon_amount - $redeem_amount;
            
                                update_post_meta( $coupon_id, 'coupon_amount', $remaining_amount );
                                $coupon_usage_count = ++$coupon_usage_count;
                                update_post_meta( $coupon_id, 'usage_count', $coupon_usage_count );
            
                                $response['status'] = 200;
            
                                $data = array(
                                    'code' => 'success',
                                    'message' => 'Coupon is successfully Redeemed',
                                    'remaining_amount' => $remaining_amount,
                                    'discount_type' => $the_coupon->get_discount_type(),
                                    'usage_count' => $coupon_usage_count,
                                    'usage_limit' => $the_coupon->get_usage_limit(),
                                    'description' => $the_coupon->get_description(),
                                    'coupon_expiry' => ! empty( $coupon_expiry ) ? date( "d/m/Y", $coupon_expiry ) : 'No Expiration',
                                );
                                $response['data'] = $data;
        
                            } else {
                                $response['code'] = 'error';
                                $response['message'] = 'Redeem amount is greater than Coupon amount';
                                $response['status'] = 404;
                            }
                        } else {
                            $response['code'] = 'error';
                            $response['message'] = 'Redeem amount should be greater than 0';
                            $response['status'] = 404;
                        }
                    } else {
                        $response['code'] = 'error';
                        $response['message'] = 'Coupon is expired';
                        $response['status'] = 404;
                    }
                } else {
                    $response['code'] = 'error';
                    $response['message'] = 'Coupon Usage Limit Reached';
                    $response['status'] = 404;
                }
            } else {
                $response['code'] = 'error';
                $response['message'] = 'Coupon is not valid Giftcard Coupon';
                $response['status'] = 404;
            }
            return $response;
        }


		/**
		 * Recharge Gift Card Coupon
		 *
		 * @param array $request containing all values for updating the coupon.
		 * @return array
		 */
		public function wps_uwgc_giftcard_recharge( $coupon_code, $recharge_amount, $coupon_expirys = '', $usage_count = '', $usage_limit = '' ) {
			global $woocommerce;
            $coupon_code = strtolower( $coupon_code );
            $the_coupon = new WC_Coupon( $coupon_code );
            $coupon_id = $the_coupon->get_id();

            if ( '' !== $coupon_id && 0 !== $coupon_id ) {
                $coupon_amount = get_post_meta( $coupon_id, 'coupon_amount', true );

                $coupon_expiry = '';
                $woo_ver = WC()->version;

                if ( $woo_ver < '3.6.0' ) {

                    $coupon_expiry = get_post_meta( $coupon_id, 'expiry_date', true );

                } else {
                    $coupon_expiry = get_post_meta( $coupon_id, 'date_expires', true );
                }

                $giftcardcoupon_order_id = get_post_meta( $coupon_id, 'wps_wgm_giftcard_coupon', true );

                if ( '' == $coupon_expiry || $coupon_expiry > current_time( 'timestamp' ) ) {

                    if ( isset( $recharge_amount ) && ! empty ( $recharge_amount ) && '0' != $recharge_amount && '0' < $recharge_amount ) {

                        $updated_amount = $coupon_amount + $recharge_amount;

                        update_post_meta( $coupon_id, 'coupon_amount', $updated_amount );

                        if ( ! empty ( $usage_count ) ) {
                            update_post_meta( $coupon_id, 'usage_count', $usage_count );
                        } else {
                            $usage_count = get_post_meta( $coupon_id, 'usage_count', true );
                        }

                        if ( ! empty ( $usage_limit ) ) {
                            update_post_meta( $coupon_id, 'usage_limit', $usage_limit );
                        } else {
                            $usage_limit = get_post_meta( $coupon_id, 'usage_limit', true );
                        }

                        if ( $woo_ver < '3.6.0' ) {
                            if ( $coupon_expirys > time() ) {
                                update_post_meta( $coupon_id, 'expiry_date', $coupon_expirys );
                                $coupon_expiry = $coupon_expirys;
                            }
                        } else {
                            if ( $coupon_expirys > time() ) {
                                update_post_meta( $coupon_id, 'date_expires', $coupon_expirys );
                                $coupon_expiry = $coupon_expirys;
                            }
                        }

                        $response['status'] = 200;

                        $data = array(
                            'code' => 'success',
                            'message' => 'Coupon is successfully Recharged',
                            'remaining_amount' => $updated_amount,
                            'discount_type' => $the_coupon->get_discount_type(),
                            'usage_count' => $usage_count,
                            'usage_limit' => $usage_limit,
                            'description' => $the_coupon->get_description(),
                            'coupon_expiry' => ! empty( $coupon_expiry ) ? date( "d/m/Y", $coupon_expiry ) : 'No Expiration',
                        );
                        $response['data'] = $data;
                    } else {
                        $response['code'] = 'error';
                        $response['message'] = 'Recharge amount should be greater than 0';
                        $response['status'] = 404;
                    }
                } else {
                    $response['code'] = 'error';
                    $response['message'] = 'Coupon is expired';
                    $response['status'] = 404;
                }
            } else {
                $response['code'] = 'error';
                $response['message'] = 'Coupon is not valid Giftcard Coupon';
                $response['status'] = 404;
            }
            return $response;
        }
	}
}
