<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://wpswings.com
 * @since      1.0.0
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Ultimate Woocommerce Gift Cards
 * @subpackage Ultimate Woocommerce Gift Cards/public
 * @author     WP Swings <webmaster@wpswings.com>
 */
use Automattic\WooCommerce\Utilities\OrderUtil;
class Ultimate_Woocommerce_Gift_Card_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * Instance of Commom Function.
	 *
	 * @var string
	 */
	public $wps_common_fun;

	/**
	 * Instance of Customized Giftcard.
	 *
	 * @var string
	 */
	public $wps_custmizable_obj;


	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of the plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		require_once WPS_UWGC_DIRPATH . 'includes/class-wps-uwgc-giftcard-common-function.php';
		$this->wps_common_fun = new WPS_UWGC_Giftcard_Common_Function();
		require_once WPS_UWGC_DIRPATH . 'Qrcode/class-wps-uwgc-qrcode-barcode.php';
		require_once WPS_UWGC_DIRPATH . 'custmizable-gift-card/class-wps-uwgc-custmizable-gift-card-product.php';
		$this->wps_custmizable_obj = new Wps_Uwgc_Custmizable_Gift_Card_Product();

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ultimate_Woocommerce_Gift_Card_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ultimate_Woocommerce_Gift_Card_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		
		global $post;
		$post_id = isset( $post->ID ) ? $post->ID : '';
		$page_content = '';
		if ( ! empty( $post_id ) ) {
			$page         = get_post( $post->ID );
			$page_content = ! empty( $page->post_content ) ? $page->post_content : '';
		}
		if ( is_shop() || is_product() || is_wc_endpoint_url( 'view-order' ) || ( function_exists( 'is_account_page' ) && is_account_page() ) || is_wc_endpoint_url( 'order-received' ) || apply_filters( 'wps_wgm_load_product_script', false ) || str_contains( $page_content, 'wps_check_your_gift_card_balance' ) ) {
			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/ultimate-woocommerce-gift-card-public.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name . 'wps_uwgc_jquery-ui-datepicker', plugin_dir_url( __FILE__ ) . 'css/jquery-ui.css', array(), $this->version, 'all' );
		}
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 * s
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ultimate_Woocommerce_Gift_Card_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ultimate_Woocommerce_Gift_Card_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();

		$product_settings   = get_option( 'wps_wgm_product_settings', array() );
		$disable_from_field = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_from_field' );
		$disable_message_field = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_message_field' );
		$disable_to_email_field = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_to_email_field' );

		$wps_uwgc_schedule_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_date' );
		$wps_uwgc_date_format = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
		$wps_uwgc_time_format = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_time_format' );

		$remove_validation_to = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_remove_validation_to' );
		$remove_validation_from = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_remove_validation_from' );
		$remove_validation_msg = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_remove_validation_msg' );
		$remove_validation_to_name = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_remove_validation_to_name' );

		$discount_settings = get_option( 'wps_wgm_discount_settings', array() );
		$discount_enable = $wps_public_obj->wps_wgm_get_template_data( $discount_settings, 'wps_wgm_discount_enable' );

		$notification_settings = get_option( 'wps_wgm_notification_settings', array() );
		$enable_sms_notification = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_enable_sms_notification' );

		$wps_uwgc_date_format = $this->wps_common_fun->wps_uwgc_selected_date_format_for_js( $wps_uwgc_date_format );

		$wps_uwgc = array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'send_date' => __( 'Send Date: Field is empty', 'giftware' ),
			'to_name' => __( 'Recipient Name: Field is empty', 'giftware' ),
			'browse_error' => __( 'Please browse image files only', 'giftware' ),
			'discount_price_message' => __( 'Discounted Giftcard Price: ', 'giftware' ),
			'coupon_message' => __( 'Giftcard Value: ', 'giftware' ),
			'invalid_contact' => __( 'Enter Valid Contact Number', 'giftware' ),
			'time_now_string' => __( 'Now', 'giftware' ),
			'contact_number'  => __( 'Invalid number. Only numbers are allowed, no spaces or special characters.', 'giftware' ),
		);

		$wps_uwgc['wps_uwgc_nonce'] = wp_create_nonce( 'wps-uwgc-verify-nonce' );
		$wps_uwgc['schedule_date'] = $wps_uwgc_schedule_date;
		$wps_uwgc['selected_date'] = $wps_uwgc_date_format;
		$wps_uwgc['time_format'] = $wps_uwgc_time_format;
		$wps_uwgc['remove_validation_to'] = $remove_validation_to;
		$wps_uwgc['remove_validation_from'] = $remove_validation_from;
		$wps_uwgc['remove_validation_msg'] = $remove_validation_msg;
		$wps_uwgc['remove_validation_to_name'] = $remove_validation_to_name;
		$wps_uwgc['discount_enable'] = $discount_enable;
		$wps_uwgc['enable_sms_notification'] = $enable_sms_notification;

		global $post;
		$post_id = isset( $post->ID ) ? $post->ID : '';
		$page_content = '';
		if ( ! empty( $post_id ) ) {
			$page         = get_post( $post->ID );
			$page_content = ! empty( $page->post_content ) ? $page->post_content : '';
		}

		if ( is_product() || str_contains( $page_content, 'product_page id' ) ) {

			if ( str_contains( $page_content, 'product_page id' ) ) {
				$content = $post->post_content;
				if ( isset( ( explode( '=', explode( ']', $content )[0] ) )[1] ) ) {
					$array = ( explode( '=', explode( ']', $content )[0] ) )[1];
					$product_id = intval( explode( '"', $array )[1] );
				} else {
					$product_id    = $post->ID;
				}
			} else {
				$product_id    = $post->ID;
			}
			$is_group_product = get_post_meta( $product_id, 'wps_wgm_is_group_gift', true );
			$product_types = wp_get_object_terms( $product_id, 'product_type' );
			if ( isset( $product_types[0] ) ) {
				$product_type = $product_types[0]->slug;
				$sell_as_a_giftcard = get_post_meta( $product_id, '_sell_as_a_giftcard' );
				if ( 'wgm_gift_card' == $product_type || ( isset( $sell_as_a_giftcard[0] ) && 'yes' === $sell_as_a_giftcard[0] ) ) {
					$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_giftware', true );
					$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing', true );
					$wps_wgm_discount = get_post_meta( $product_id, 'wps_wgm_discount', true );

					$wps_uwgc['product_id'] = $product_id;
					$wps_uwgc['is_customizable'] = $is_customizable;
					$wps_uwgc['pricing_type'] = $wps_wgm_pricing;
					$wps_uwgc['wps_wgm_discount'] = $wps_wgm_discount;

					$wps_uwgc['disable_from_field'] = $disable_from_field;
					$wps_uwgc['disable_message_field'] = $disable_message_field;
					$wps_uwgc['disable_to_email_field'] = $disable_to_email_field;
					$wps_uwgc['is_group_gift_prod'] = 0;
					$wps_uwgc['timezone_offset'] = (float) get_option( 'gmt_offset' );
					$wps_uwgc['is_addon_active'] = $this->is_addon_active();

					wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-public.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );
					wp_localize_script( $this->plugin_name, 'wps_uwgc_param', $wps_uwgc );
				}
			}
			if ( 'yes' == $is_group_product ) {
				if ( isset( $is_group_product ) && ! empty( $is_group_product ) ) {

					$wps_uwgc['is_group_gift_prod'] = 1;

				}
				wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-public.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );
				wp_localize_script( $this->plugin_name, 'wps_uwgc_param', $wps_uwgc );
			}
		} else if ( apply_filters( 'wps_wgm_load_product_script', false ) ) {
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-public.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );
			wp_localize_script( $this->plugin_name, 'wps_uwgc_param', $wps_uwgc );
		} else if ( str_contains( $page_content, 'wps_check_your_gift_card_balance' ) || ( function_exists( 'is_account_page' ) && is_account_page() ) ) {
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-public.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );
			wp_localize_script( $this->plugin_name, 'wps_uwgc_param', $wps_uwgc );
		}

		if ( is_wc_endpoint_url( 'order-received' ) || is_wc_endpoint_url( 'view-order' ) ) {
			wp_enqueue_script( 'wps-thankyoupage-script', WPS_UWGC_URL . 'public/js/wps-thankyoupage-whatsapp.js', array( 'jquery' ), time(), false );
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-public.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );
			wp_localize_script( $this->plugin_name, 'wps_uwgc_param', $wps_uwgc );
		}
	}

	/**
	 * Wps_wgm_load_product_script_on_custom_page
	 *
	 * @param boolean $flag flag.
	 */
	public function wps_wgm_load_product_script_on_custom_page( $flag ) {
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_gc_custom_page = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_render_product_custom_page' );
		global $wp_query;
		$page_title = ! empty( $wp_query->post ) ? $wp_query->post->post_title : '';
		if ( 'on' == $wps_wgm_gc_custom_page ) {
			$wps_wgm_custom_page_selection = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_custom_page_selection' );
			if ( 'Select Custom Page' !== $wps_wgm_custom_page_selection ) {
				$page_name = get_the_title( $wps_wgm_custom_page_selection );
				if ( $page_title == $page_name ) {
					global $post;
					$slug = isset( $post->post_name ) ? $post->post_name : '';
					$url = isset( $_SERVER['REQUEST_URI'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '';
					$url_last_index = explode( '/', $url );
					if ( in_array( $slug, $url_last_index ) ) {
						wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ultimate-woocommerce-gift-card-public.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );
						$flag = true;
					}
				}
			}
		}
		return $flag;
	}

	/**
	 * This function is used to show the product price at shop as well as product single page
	 *
	 * @name wps_uwgc_pricing_html
	 * @param string $price_html Contains html to show price.
	 * @param object $product Contains product object.
	 * @param array  $product_pricing Contains product price.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_pricing_html( $price_html, $product, $product_pricing ) {
		$product_id = $product->get_id();
		$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );
		$discount_min = $wps_wgm_discount_data['discount_min'];
		$discount_max = $wps_wgm_discount_data['discount_max'];
		$discount_type = $wps_wgm_discount_data['discount_type'];
		$discount_value = $wps_wgm_discount_data['discount_value'];
		$discount_applicable = false;

		if ( isset( $product_pricing['type'] ) && 'wps_wgm_default_price' == $product_pricing['type'] ) {

			$default_price = $product_pricing['default_price'];
			if ( isset( $wps_wgm_discount_data['wps_wgm_discount'] ) && 'yes' == $wps_wgm_discount_data['wps_wgm_discount'] ) {
				if ( isset( $wps_wgm_discount_data['discount_enable'] ) && 'on' == $wps_wgm_discount_data['discount_enable'] ) {
					if ( isset( $discount_min ) && null !== $discount_min && isset( $discount_max ) && null !== $discount_max && isset( $discount_value ) && null !== $discount_value ) {
						foreach ( $discount_min as $key => $value ) {
							if ( $discount_min[ $key ] <= $default_price && $default_price <= $discount_max[ $key ] ) {
								if ( 'Percentage' == $discount_type ) {
									$new_price = $default_price - ( $default_price * $discount_value[ $key ] ) / 100;
								} else {
									$new_price = $default_price - $discount_value[ $key ];
								}
								$discount_applicable = true;
							}
						}
					}
				}
				if ( $discount_applicable ) {
					// for price based on country.
					if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {

						if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
							$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
							$new_price = wcpbc_the_zone()->get_exchange_rate_price( $new_price );
						}
						$price_html = '<del>' . wc_price( $default_price ) . $product->get_price_suffix() . '</del><ins>' . wc_price( $new_price ) . $product->get_price_suffix() . '</ins>';
					} elseif ( ! is_admin() && function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
						$default_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
						$new_price     = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $new_price );
						$price_html    = '<del>' . wps_mmcsfw_get_custom_currency_symbol( '' ) . ( $default_price ) . $product->get_price_suffix() . '</del><ins>' . wps_mmcsfw_get_custom_currency_symbol( '' ) . ( $new_price ) . $product->get_price_suffix() . '</ins>';
					} else {
						$price_html = '<del>' . wc_price( $default_price ) . $product->get_price_suffix() . '</del><ins>' . wc_price( $new_price ) . $product->get_price_suffix() . '</ins>';
					}
				}
			}
		}
		return $price_html;
	}
	/**
	 * Function to get discount settings data.
	 *
	 * @name wps_uwgc_common_discount_function
	 * @param mixed $product_id contains product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_common_discount_function( $product_id ) {

		$wps_wgm_discount_settings = get_option( 'wps_wgm_discount_settings', array() );
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_discount_array = array(
			'wps_wgm_discount' => get_post_meta( $product_id, 'wps_wgm_discount', true ),
			'discount_enable'   => $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_discount_settings, 'wps_wgm_discount_enable' ),
			'discount_min'     => $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_discount_settings, 'wps_wgm_discount_minimum' ),
			'discount_max'     => $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_discount_settings, 'wps_wgm_discount_maximum' ),
			'discount_value'   => $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_discount_settings, 'wps_wgm_discount_current_type' ),
			'discount_type'    => $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_discount_settings, 'wps_wgm_discount_type' ),
		);
		return $wps_wgm_discount_array;
	}

	/**
	 * Adds Discount fields for Default Pricing Type Gift Card Product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_default_price_discount().
	 * @param array $product Contains product.
	 * @param array $product_pricing Contains product price.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_default_price_discount( $product, $product_pricing ) {

		global $post;
		$product_id = $post->ID;

		$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );
		if ( isset( $wps_wgm_discount_data['discount_enable'] ) && 'on' == $wps_wgm_discount_data['discount_enable'] ) {
			if ( isset( $wps_wgm_discount_data['wps_wgm_discount'] ) && 'yes' == $wps_wgm_discount_data['wps_wgm_discount'] ) {
				$default_price = $product_pricing['default_price'];
				// for price based on country.
				if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
					if ( null !== wcpbc_the_zone() && wcpbc_the_zone() ) {
						$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
					}
					?>
					<span style="color:green;">
					<?php
					esc_html_e( 'Coupon Amount will be: ', 'giftware' );
					echo wp_kses_post( wc_price( $default_price ) );
					?>
					</span>
					<?php
				} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
					$default_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
					?>
					<span style="color:green;">
					<?php
					esc_html_e( 'Coupon Amount will be: ', 'giftware' );
					echo wp_kses_post( wc_price( $default_price ) );
					?>
					</span>
					<?php
				} else {
					?>
					<span style="color:green;">
					<?php
					esc_html_e( 'Coupon Amount will be: ', 'giftware' );
					echo esc_html( $default_price );
					?>
					</span>
					<?php
				}
			}
		}
	}
	/**
	 * This function is used update product price on cart page
	 *
	 * @name wps_uwgc_before_calculate_totals
	 * @param mixed $gift_price price of giftcard.
	 * @param mixed $value gifcard value.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_before_calculate_totals( $gift_price, $value ) {

		$product_id = $value['product_id'];
		$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );

		$discount_min = $wps_wgm_discount_data['discount_min'];
		$discount_max = $wps_wgm_discount_data['discount_max'];
		$discount_type = $wps_wgm_discount_data['discount_type'];
		$discount_value = $wps_wgm_discount_data['discount_value'];
		$discount_applicable = false;
		if ( isset( $wps_wgm_discount_data['discount_enable'] ) && 'on' == $wps_wgm_discount_data['discount_enable'] ) {
			if ( isset( $wps_wgm_discount_data['wps_wgm_discount'] ) && 'yes' == $wps_wgm_discount_data['wps_wgm_discount'] ) {

				if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {

					if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
						$exchange_rate = wcpbc_the_zone()->get_exchange_rate();
						$gift_price = floatval( $gift_price / $exchange_rate );
					}
				}

				if ( isset( $discount_min ) && null !== $discount_min && isset( $discount_max ) && null !== $discount_max && isset( $discount_value ) && null !== $discount_value ) {

					foreach ( $discount_min as $key => $values ) {

						if ( $discount_min[ $key ] <= $gift_price && $gift_price <= $discount_max[ $key ] ) {

							if ( 'Percentage' == $discount_type ) {
								$new_price = $gift_price - ( $gift_price * $discount_value[ $key ] ) / 100;
							} else {
								$new_price = $gift_price - $discount_value[ $key ];
							}
							$discount_applicable = true;

						}
					}
				}
			}
		}
		if ( $discount_applicable ) {
			if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {

				if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
					$new_price = wcpbc_the_zone()->get_exchange_rate_price( $new_price );
				}
			}

			$gift_price = apply_filters( 'wps_uwgc_before_calculate_totals', $new_price, $value );

		}
		return $gift_price;

	}

	/**
	 * Adds Discount fields for Range Pricing Type Gift Card Product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_range_price_discount()
	 * @param array $product Conatins product data.
	 * @param array $product_pricing Contains product price.
	 * @param mixed $text_box_price Contains text box price.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_range_price_discount( $product, $product_pricing, $text_box_price ) {
		$product_id = $product->get_id();
		$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );
		$discount_min = $wps_wgm_discount_data['discount_min'];
		$discount_max = $wps_wgm_discount_data['discount_max'];
		$discount_type = $wps_wgm_discount_data['discount_type'];
		$discount_value = $wps_wgm_discount_data['discount_value'];
		$discount_applicable = false;

		if ( isset( $wps_wgm_discount_data['discount_enable'] ) && 'on' == $wps_wgm_discount_data['discount_enable'] ) {
			if ( isset( $wps_wgm_discount_data['wps_wgm_discount'] ) && 'yes' == $wps_wgm_discount_data['wps_wgm_discount'] ) {
				if ( isset( $discount_min ) && null !== $discount_min && isset( $discount_max ) && null !== $discount_max && isset( $discount_value ) && null !== $discount_value ) {
					foreach ( $discount_min as $key => $value ) {
						if ( $discount_min[ $key ] <= $text_box_price && $text_box_price <= $discount_max[ $key ] ) {
							if ( 'Percentage' == $discount_type ) {
								$new_price_range = $text_box_price - ( $text_box_price * $discount_value[ $key ] ) / 100;
							} else {
								$new_price_range = $text_box_price - $discount_value[ $key ];
							}
							$discount_applicable = true;
						}
					}
				}
			}
		}
		if ( $discount_applicable ) {
			if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
				if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
					$new_price_range = wcpbc_the_zone()->get_exchange_rate_price( $new_price_range );
					$text_box_price = wcpbc_the_zone()->get_exchange_rate_price( $text_box_price );
				}
				?>
				<div class="wps_wgm_price_content">
					<b style="color:green;">
					<?php
					esc_html_e( 'Discounted Gift Card Price: ', 'giftware' );
					echo wp_kses_post( wc_price( $new_price_range ) );
					?>
					</b><br/>
					<b style="color:green;">
					<?php
					esc_html_e( 'Giftcard Value: ', 'giftware' );
					echo wp_kses_post( wc_price( $text_box_price ) );
					?>
					</b>
				</div>
				<?php
			} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
				$new_price_range = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $new_price_range );
				$text_box_price  = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $text_box_price );
				?>
				<div class="wps_wgm_price_content">
					<b style="color:green;">
					<?php
					esc_html_e( 'Discounted Gift Card Price: ', 'giftware' );
					echo wp_kses_post( wc_price( $new_price_range ) );
					?>
					</b><br/>
					<b style="color:green;">
					<?php
					esc_html_e( 'Giftcard Value: ', 'giftware' );
					echo wp_kses_post( wc_price( $text_box_price ) );
					?>
					</b>
				</div>
				<?php
			} else {
				?>
				<div class="wps_wgm_price_content">
					<b style="color:green;">
					<?php
					esc_html_e( 'Discounted Gift Card Price: ', 'giftware' );
					echo wp_kses_post( wc_price( $new_price_range ) );
					?>
					</b><br/>
					<b style="color:green;">
					<?php
					esc_html_e( 'Giftcard Value: ', 'giftware' );
					echo wp_kses_post( wc_price( $text_box_price ) );
					?>
					</b>
				</div>
				<?php
			}
		}
	}

	/**
	 * Adds Discount fields for User Pricing Type Gift Card Product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_user_price_discount()
	 * @param array $product Conatins product data.
	 * @param array $product_pricing Contains product price.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_user_price_discount( $product, $product_pricing ) {
		$product_id = $product->get_id();
		$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );
		$discount_min = $wps_wgm_discount_data['discount_min'];
		$discount_max = $wps_wgm_discount_data['discount_max'];
		$discount_type = $wps_wgm_discount_data['discount_type'];
		$discount_value = $wps_wgm_discount_data['discount_value'];
		$discount_applicable = false;
		$default_price = $product_pricing['default_price'];

		if ( isset( $wps_wgm_discount_data['discount_enable'] ) && 'on' == $wps_wgm_discount_data['discount_enable'] ) {
			if ( isset( $wps_wgm_discount_data['wps_wgm_discount'] ) && 'yes' == $wps_wgm_discount_data['wps_wgm_discount'] ) {
				if ( isset( $discount_min ) && null !== $discount_min && isset( $discount_max ) && null !== $discount_max && isset( $discount_value ) && null !== $discount_value ) {
					foreach ( $discount_min as $key => $value ) {
						if ( $discount_min[ $key ] <= $default_price && $default_price <= $discount_max[ $key ] ) {
							if ( 'Percentage' == $discount_type ) {
								$new_price_user = $default_price - ( $default_price * $discount_value[ $key ] ) / 100;
							} else {
								$new_price_user = $default_price - $discount_value[ $key ];
							}
							$discount_applicable = true;
						}
					}
				}
			}
		}
		if ( $discount_applicable ) {

			if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
				if ( null !== wcpbc_the_zone() && wcpbc_the_zone() ) {
					$new_price_user = wcpbc_the_zone()->get_exchange_rate_price( $new_price_user );
					$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
				}
				?>
				<div class="wps_wgm_price_content">
					<b style="color:green;">
					<?php
					esc_html_e( 'Discounted Gift Card Price: ', 'giftware' );
					echo wp_kses_post( wc_price( $new_price_user ) );
					?>
					</b><br/>
					<b style="color:green;">
					<?php
					esc_html_e( 'Giftcard Value: ', 'giftware' );
					echo wp_kses_post( wc_price( $default_price ) );
					?>
					</b>
				</div>
				<?php
			} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
				$new_price_user = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $new_price_user );
				$default_price  = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
				?>
				<div class="wps_wgm_price_content">
					<b style="color:green;">
					<?php
					esc_html_e( 'Discounted Gift Card Price: ', 'giftware' );
					echo wp_kses_post( wc_price( $new_price_user ) );
					?>
					</b><br/>
					<b style="color:green;">
					<?php
					esc_html_e( 'Giftcard Value: ', 'giftware' );
					echo wp_kses_post( wc_price( $default_price ) );
					?>
					</b>
				</div>
				<?php
			} else {
				?>
				<div class="wps_wgm_price_content">

					<b style="color:green;">
					<?php
					esc_html_e( 'Discounted Gift Card Price: ', 'giftware' );
					echo wp_kses_post( wc_price( $new_price_user ) );
					?>
					</b><br/>
					<b style="color:green;">
					<?php
					esc_html_e( 'Giftcard Value: ', 'giftware' );
					echo wp_kses_post( wc_price( $default_price ) );
					?>
					</b>

				</div>
				<?php
			}
		}

	}
	/**
	 * Add Schedule Date fields for  Gift Card Product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_select_date_feature()
	 * @param mixed  $wps_additional_section contains additional info.
	 * @param string $product_id Contains product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_select_date_feature( $wps_additional_section, $product_id ) {
		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_additional_section = '';
		$is_group_product = get_post_meta( $product_id, 'wps_wgm_is_group_gift', true );
		$wps_uwgc_schedule_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_date' );

		if ( isset( $wps_uwgc_schedule_date ) && 'on' == $wps_uwgc_schedule_date ) {
			$wps_additional_section .= '<p class="wps_wgm_section select_date">
				<label class="wps_wgc_label">' . __( 'Select Date', 'giftware' ) . '</label>	
				<input type="text"  name="wps_uwgc_send_date" id="wps_uwgc_send_date" class="wps_uwgc_send_date" placeholder="">
				<span class="wps_uwgc_info">' . __( '(Recipient will receive the Gift Card on selected date)', 'giftware' ) . '</span>

			</p>
			<p class="wps_wgm_section select_time">
				<label class="wps_wgc_label">' . __( 'Select Time', 'giftware' ) . '</label>
				<select id="wps_wgm_time" name="wps_wgm_time" class="wps_wgm_time">
				</select>
			</p>';
		}
		if ( isset( $is_group_product ) && 'yes' == $is_group_product ) {

			$general_settings['wps_wgm_general_setting_enable_selected_date'] = 'on';
			update_option( 'wps_wgm_general_settings', $general_settings );
			
		}
		return $wps_additional_section;

	}
	/**
	 * Add Delivery method for  Gift Card Product
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_add_delivery_method()
	 * @param mixed  $wps_additional_section contains additional info.
	 * @param string $product_id Contains product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_add_delivery_method( $wps_additional_section, $product_id ) {
		$wps_additional_section = '';
	
		$delivery_settings = get_option( 'wps_wgm_delivery_settings', array() );
		$other_settings = get_option( 'wps_wgm_other_settings', array() );

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$use_new_page_layout = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_new_gift_card_page_layout' );
		$wps_uwgc_delivery_method = $wps_public_obj->wps_wgm_get_template_data( $delivery_settings, 'wps_wgm_send_giftcard' );	

		$is_group_product = get_post_meta($product_id , 'wps_wgm_is_group_gift', true );
		$genaral_settings = get_option( 'wps_wgm_general_settings', array() );
		$enable_sent_multiple_gc = $wps_public_obj->wps_wgm_get_template_data( $genaral_settings, 'wps_wgm_general_setting_enable_sent_multiple_giftcard' );
		$is_imported_product = get_post_meta( $product_id, 'is_imported', true );
		
		if ( '' == $use_new_page_layout ){
			
				if ( isset( $wps_uwgc_delivery_method ) && 'shipping' == $wps_uwgc_delivery_method ) {
					$wps_additional_section .= '
					<div class="wps_wgm_delivery_method">
						<input type="radio" name="wps_wgm_send_giftcard" value="shipping" class="wps_wgm_send_giftcard" checked="checked" id="wps_wgm_send_giftcard_ship">
						<span class="wps_wgm_method">' . __( 'Want To Ship Your Card', 'giftware' ) . '</span>
						<div class="wps_wgm_delivery_via_admin">
							<input type="text"  name="wps_wgm_to_email_ship" id="wps_wgm_to_ship" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
							<span class= "wps_wgm_msg_info">' . __( 'We will ship your card', 'giftware' ) . '</span>
						</div>
					</div>';
				}
				/////////// is_group_product ////////////////
				if ( isset( $is_group_product) && 'yes' == $is_group_product && isset( $wps_uwgc_delivery_method ) && 'Mail to recipient' == $wps_uwgc_delivery_method) {
					$wps_additional_section .= '<label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
								<div class="wps_wgm_delivery_method">	

									<div class="wps_wgm_delivery_via_email">
										<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
										<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
										<span class= "wps_wgm_msg_info_multiple_name"></span>
									</div>
								</div>';
				}
					//////////////  end ///////////////
				if ( isset( $wps_uwgc_delivery_method ) && 'customer_choose' == $wps_uwgc_delivery_method ) {
					$wps_uwgc_is_overwrite = get_post_meta( $product_id, 'wps_wgm_overwrite', true );
					$wps_wgm_email_to_recipient = get_post_meta( $product_id, 'wps_wgm_email_to_recipient', true );
					$wps_wgm_download = get_post_meta( $product_id, 'wps_wgm_download', true );
					$wps_wgm_shipping = get_post_meta( $product_id, 'wps_wgm_shipping', true );

					
						if ( isset( $wps_uwgc_is_overwrite ) && 'yes' == $wps_uwgc_is_overwrite ) {
							if ( isset( $wps_wgm_email_to_recipient ) && 'yes' == $wps_wgm_email_to_recipient ) {
								$html = ( 'on' == $enable_sent_multiple_gc && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) ? '<span class= "wps_wgm_msg_info_multiple_email">' . __( 'Separate multiple addresses with a comma', 'giftware' ) . '</span>' : '';
								$wps_additional_section .= '
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" id="wps_wgm_to_email_send" checked="checked" ><span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>	
									<div class="wps_wgm_delivery_via_email">
										<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
										' . $html . '
										<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
										<span class="wps_wgm_msg_info">' . __( 'We will send it to recipient email address', 'giftware' ) . '</span>
										<span class= "wps_wgm_msg_info_multiple_name"></span>
									</div>
								</div>';
								/////////// is_group_product ////////////////
								if ( isset( $is_group_product) && 'yes' == $is_group_product ) {
									$wps_additional_section .= '<label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
												<div class="wps_wgm_delivery_method">	
			
													<div class="wps_wgm_delivery_via_email">
														<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
														<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
														<span class= "wps_wgm_msg_info_multiple_name"></span>
													</div>
												</div>';
									}
									//////////////  end ///////////////
							}
							if ( isset( $wps_wgm_download ) && 'yes' == $wps_wgm_download ) {
								$wps_additional_section .= '	
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="Downloadable" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_download"><span class="wps_wgm_method">' . __( 'You Print & Give To Recipient', 'giftware' ) . '</span>
									<div class="wps_wgm_delivery_via_buyer">
										<input type="text"  name="wps_wgm_to_email_name" id="wps_wgm_to_download" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'After checking out, you can print your Gift Card', 'giftware' ) . '</span>
									</div>
								</div>';
							}
							if ( isset( $wps_wgm_shipping ) && 'yes' == $wps_wgm_shipping ) {
								$wps_additional_section .= '
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="shipping" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_ship">
									<span class="wps_wgm_method">' . __( 'Want To Ship Your Card', 'giftware' ) . '</span>
									<div class="wps_wgm_delivery_via_admin">
										<input type="text"  name="wps_wgm_to_email_ship" id="wps_wgm_to_ship" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'We will ship your card', 'giftware' ) . '</span>
									</div>
								</div>';
							}
							$wps_additional_section = apply_filters( 'wps_wgm_add_overwrite_method', $wps_additional_section, $product_id );
						} else {
			
							if ( ! isset( $delivery_settings['wps_wgm_email_to_recipient'] ) && ! isset( $delivery_settings['wps_wgm_downloadable'] ) && ! isset( $delivery_settings['wps_wgm_shipping'] ) ) {
								$html = ( 'on' == $enable_sent_multiple_gc && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) ? '<span class= "wps_wgm_msg_info_multiple_email">' . __( 'Separate multiple addresses with a comma', 'giftware' ) . '</span>' : '';
								$wps_additional_section .= '
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" id="wps_wgm_to_email_send" checked="checked" ><span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>	
									<div class="wps_wgm_delivery_via_email">
										<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
										' . $html . '
										<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
										<span class= "wps_wgm_msg_info">' . __( 'We will send it to recipient email address', 'giftware' ) . '</span>
										<span class= "wps_wgm_msg_info_multiple_name"></span>
									</div>
								</div>';
							}
			
							if ( isset( $delivery_settings['wps_wgm_email_to_recipient'] ) && 'on' == $delivery_settings['wps_wgm_email_to_recipient'] ) {
								$html = ( 'on' == $enable_sent_multiple_gc && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) ? '<span class= "wps_wgm_msg_info_multiple_email">' . __( 'Separate multiple addresses with a comma', 'giftware' ) . '</span>' : '';
								$wps_additional_section .= '
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" id="wps_wgm_to_email_send" checked="checked"><span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>	
									<div class="wps_wgm_delivery_via_email">
										<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
										' . $html . '
										<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
										<span class= "wps_wgm_msg_info">' . __( 'We will send it to recipient email address', 'giftware' ) . '</span>
										<span class= "wps_wgm_msg_info_multiple_name"></span>
									</div>
								</div>';
								/////////// is_group_product ////////////////
								if ( isset( $is_group_product) && 'yes' == $is_group_product ) {
									$wps_additional_section .= '<label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
												<div class="wps_wgm_delivery_method">	
			
													<div class="wps_wgm_delivery_via_email">
														<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
														<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
														<span class= "wps_wgm_msg_info_multiple_name"></span>
													</div>
												</div>';
									}
								//////////////  end ///////////////
							}
							if ( isset( $delivery_settings['wps_wgm_downloadable'] ) && 'on' == $delivery_settings['wps_wgm_downloadable'] ) {
								$wps_additional_section .= '
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="Downloadable" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_download"><span class="wps_wgm_method">' . __( 'You Print & Give To Recipient', 'giftware' ) . '</span>
									<div class="wps_wgm_delivery_via_buyer">
										<input type="text"  name="wps_wgm_to_email_name" id="wps_wgm_to_download" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'After checking out, you can print your Gift Card', 'giftware' ) . '</span>
									</div>
								</div>';
							}
							if ( isset( $delivery_settings['wps_wgm_shipping'] ) && 'on' == $delivery_settings['wps_wgm_shipping'] ) {
								$wps_additional_section .= '
								<div class="wps_wgm_delivery_method">
									<input type="radio" name="wps_wgm_send_giftcard" value="shipping" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_ship">
									<span class="wps_wgm_method">' . __( 'Want To Ship Your Card', 'giftware' ) . '</span>
									<div class="wps_wgm_delivery_via_admin">
										<input type="text"  name="wps_wgm_to_email_ship" id="wps_wgm_to_ship" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'We will ship your card', 'giftware' ) . '</span>
									</div>
								</div>';
							}
						}
					}
					$wps_uwgc_browse_image = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_other_setting_browse' );
					if ( isset( $wps_uwgc_browse_image ) && 'on' == $wps_uwgc_browse_image ) {
						$wps_additional_section .= '
						<div class="wps_demo_browse">
			
							<p class="wps_wgm_section">
								<label class="wps_wgc_label">' . __( 'Upload Image : ', 'giftware' ) . '</label>	
								<input type="file"  name="wps_uwgc_browse_img" id="wps_uwgc_browse_img" class="wps_uwgc_browse_img"><span class="wps_wgm_info">' . __( '(Uploaded Image will replace the product image in template)', 'giftware' ) . '</span>
								<img id="wps_wgm_browse_src">
							</p>
						</div>';
				}
		} else {
				////////////////////////////////////////////// changes done for layout //////////////////////////////////////////////////////////////

			
				if ( isset( $wps_uwgc_delivery_method ) && 'customer_choose' ==  $wps_uwgc_delivery_method) {

					
					$wps_uwgc_is_overwrite = get_post_meta( $product_id, 'wps_wgm_overwrite', true );
					$wps_wgm_email_to_recipient = get_post_meta( $product_id, 'wps_wgm_email_to_recipient', true );
					$wps_wgm_download = get_post_meta( $product_id, 'wps_wgm_download', true );
					$wps_wgm_shipping = get_post_meta( $product_id, 'wps_wgm_shipping', true );

				
					
						if ( isset( $wps_uwgc_is_overwrite ) && 'yes' == $wps_uwgc_is_overwrite ) {
						
							$wps_additional_section .='<div class="wps-ts__head" >';
							if ( isset( $wps_wgm_email_to_recipient ) && 'yes' == $wps_wgm_email_to_recipient ) {
								$wps_additional_section .='<div class="wps-ts__h-item wps-ts__h-item_1 wps-ts__active">' . __( 'Mail', 'giftware' ) . '</div>';
							}

							if ( isset( $wps_wgm_download ) && 'yes' == $wps_wgm_download ) {
								$wps_additional_section .=' <div class="wps-ts__h-item wps-ts__h-item_2">' . __( 'Download', 'giftware' ) . '</div>';

							}

							if ( isset( $wps_wgm_shipping ) && 'yes' == $wps_wgm_shipping ) {

								$wps_additional_section .='<div class="wps-ts__h-item wps-ts__h-item_3 ">' . __( 'Shipping', 'giftware' ) . '</div>';
							}
							
								$wps_additional_section .='</div>';
						} else {
							
							$wps_additional_section .='<div class="wps-ts__head" >';
							if ( ! isset( $delivery_settings['wps_wgm_email_to_recipient'] ) && ! isset( $delivery_settings['wps_wgm_downloadable'] ) && ! isset( $delivery_settings['wps_wgm_shipping'] ) ) {
								$wps_additional_section .='<div class="wps-ts__h-item wps-ts__h-item_1 wps-ts__active">' . __( 'Mail', 'giftware' ) . '</div>';
							}
							if ( isset( $delivery_settings['wps_wgm_email_to_recipient'] ) && 'on' == $delivery_settings['wps_wgm_email_to_recipient'] ) {
							$wps_additional_section .='<div class="wps-ts__h-item wps-ts__h-item_1 wps-ts__active">' . __( 'Mail', 'giftware' ) . '</div>';
							}
							if ( (isset( $delivery_settings['wps_wgm_downloadable'] ) && 'on' == $delivery_settings['wps_wgm_downloadable'] ) && ( '' == $is_group_product)) {
							$wps_additional_section .=' <div class="wps-ts__h-item wps-ts__h-item_2">' . __( 'Download', 'giftware' ) . '</div>';
							}
							if ( (isset( $delivery_settings['wps_wgm_shipping'] ) && 'on' == $delivery_settings['wps_wgm_shipping'] )&& ( '' == $is_group_product) ) {
							$wps_additional_section .='<div class="wps-ts__h-item wps-ts__h-item_3 ">' . __( 'Shipping', 'giftware' ) . '</div>';
							}
							
							$wps_additional_section .='</div>';
						}
						
				}
			/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
				if ( isset( $wps_uwgc_delivery_method ) && 'shipping' == $wps_uwgc_delivery_method ) {
					$wps_additional_section .= '
				
					<div class="wps_wgm_delivery_method">
						<input type="radio" name="wps_wgm_send_giftcard" value="shipping" class="wps_wgm_send_giftcard" checked="checked" id="wps_wgm_send_giftcard_ship">
						<span class="wps_wgm_method">' . __( 'Want To Ship Your Card', 'giftware' ) . '</span>
						<div class="wps_wgm_delivery_via_admin">
							<input type="text"  name="wps_wgm_to_email_ship" id="wps_wgm_to_ship" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
							<span class= "wps_wgm_msg_info">' . __( 'We will ship your card', 'giftware' ) . '</span>
						</div>
					</div>';
				}
			/////////// is_group_product ////////////////
			if ( isset( $is_group_product) && 'yes' == $is_group_product && isset( $wps_uwgc_delivery_method ) && 'Mail to recipient' == $wps_uwgc_delivery_method) {
				$wps_additional_section .= '<div class="wps_wgm_contribution_field" > <label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
							<div class="wps_wgm_delivery_method">	

								<div class="wps_wgm_delivery_via_email">
									<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
									<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
									<span class= "wps_wgm_msg_info_multiple_name"></span>
								</div>
							</div></div>';
			}
			$wps_additional_section .= '
			<div class="wps-ts__body">';
				//////////////  end ///////////////
			if ( isset( $wps_uwgc_delivery_method ) && 'customer_choose' == $wps_uwgc_delivery_method ) {
			
				$wps_uwgc_is_overwrite = get_post_meta( $product_id, 'wps_wgm_overwrite', true );
				$wps_wgm_email_to_recipient = get_post_meta( $product_id, 'wps_wgm_email_to_recipient', true );
				$wps_wgm_download = get_post_meta( $product_id, 'wps_wgm_download', true );
				$wps_wgm_shipping = get_post_meta( $product_id, 'wps_wgm_shipping', true );
				
					if ( isset( $wps_uwgc_is_overwrite ) && 'yes' == $wps_uwgc_is_overwrite ) {
						if ( isset( $wps_wgm_email_to_recipient ) && 'yes' == $wps_wgm_email_to_recipient ) {
							$html = ( 'on' == $enable_sent_multiple_gc && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) ? '<span class= "wps_wgm_msg_info_multiple_email">' . __( 'Separate multiple addresses with a comma', 'giftware' ) . '</span>' : '';
							$wps_additional_section .= '
							<div class="wps_wgm_delivery_method wps-ts__b-item wps-ts__active">
								<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" id="wps_wgm_to_email_send" checked="checked" ><span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>	
								<div class="wps_wgm_delivery_via_email">
									<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
									' . $html . '
									<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
									<span class="wps_wgm_msg_info">' . __( 'We will send it to recipient email address', 'giftware' ) . '</span>
									<span class= "wps_wgm_msg_info_multiple_name"></span>
								</div>
							</div>';
							/////////// is_group_product ////////////////
							if ( isset( $is_group_product) && 'yes' == $is_group_product ) {
								$wps_additional_section .= '<div class="wps_wgm_contribution_field" ><label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
											<div class="wps_wgm_delivery_method">	
		
												<div class="wps_wgm_delivery_via_email">
													<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
													<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
													<span class= "wps_wgm_msg_info_multiple_name"></span>
												</div>
											</div></div>';
								}
								//////////////  end ///////////////
						}
						if ( isset( $wps_wgm_download ) && 'yes' == $wps_wgm_download ) {
							$wps_additional_section .= '	
							<div class="wps_wgm_delivery_method wps-ts__b-item">
								<input type="radio" name="wps_wgm_send_giftcard" value="Downloadable" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_download"><span class="wps_wgm_method">' . __( 'You Print & Give To Recipient', 'giftware' ) . '</span>
								<div class="wps_wgm_delivery_via_buyer">
									<input type="text"  name="wps_wgm_to_email_name" id="wps_wgm_to_download" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'After checking out, you can print your Gift Card', 'giftware' ) . '</span>
								</div>
							</div>';
						}
						if ( isset( $wps_wgm_shipping ) && 'yes' == $wps_wgm_shipping ) {
							$wps_additional_section .= '
							<div class="wps_wgm_delivery_method wps-ts__b-item">
								<input type="radio" name="wps_wgm_send_giftcard" value="shipping" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_ship">
								<span class="wps_wgm_method">' . __( 'Want To Ship Your Card', 'giftware' ) . '</span>
								<div class="wps_wgm_delivery_via_admin">
									<input type="text"  name="wps_wgm_to_email_ship" id="wps_wgm_to_ship" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'We will ship your card', 'giftware' ) . '</span>
								</div>
							</div>';
						}
						$wps_additional_section = apply_filters( 'wps_wgm_add_overwrite_method', $wps_additional_section, $product_id );
					} else {
		
						if ( ! isset( $delivery_settings['wps_wgm_email_to_recipient'] ) && ! isset( $delivery_settings['wps_wgm_downloadable'] ) && ! isset( $delivery_settings['wps_wgm_shipping'] ) ) {
							$html = ( 'on' == $enable_sent_multiple_gc && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) ? '<span class= "wps_wgm_msg_info_multiple_email">' . __( 'Separate multiple addresses with a comma', 'giftware' ) . '</span>' : '';
							
							$wps_additional_section .= '
							<div class="wps_wgm_delivery_method wps-ts__b-item wps-ts__active">
								<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" id="wps_wgm_to_email_send" checked="checked" ><span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>	
								<div class="wps_wgm_delivery_via_email">
									<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
									' . $html . '
									<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
									<span class= "wps_wgm_msg_info">' . __( 'We will send it to recipient email address', 'giftware' ) . '</span>
									<span class= "wps_wgm_msg_info_multiple_name"></span>
								</div>
							</div>';
							/////////// is_group_product ////////////////
							if ( isset( $is_group_product) && 'yes' == $is_group_product ) {
								$wps_additional_section .= '<div class="wps_wgm_contribution_field" ><label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
											<div class="wps_wgm_delivery_method">	
		
												<div class="wps_wgm_delivery_via_email">
													<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
													<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
													<span class= "wps_wgm_msg_info_multiple_name"></span>
												</div>
											</div></div>';
								}
							//////////////  end ///////////////
						}
		
						if ( isset( $delivery_settings['wps_wgm_email_to_recipient'] ) && 'on' == $delivery_settings['wps_wgm_email_to_recipient'] ) {
							$html = ( 'on' == $enable_sent_multiple_gc && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) ? '<span class= "wps_wgm_msg_info_multiple_email">' . __( 'Separate multiple addresses with a comma', 'giftware' ) . '</span>' : '';
						
							$wps_additional_section .= '
							<div class="wps_wgm_delivery_method wps-ts__b-item wps-ts__active">
								<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" id="wps_wgm_to_email_send" checked="checked"><span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>	
								<div class="wps_wgm_delivery_via_email">
									<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
									' . $html . '
									<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
									<span class= "wps_wgm_msg_info">' . __( 'We will send it to recipient email address', 'giftware' ) . '</span>
									<span class= "wps_wgm_msg_info_multiple_name"></span>
								</div>
							</div>';
							/////////// is_group_product ////////////////
							if ( isset( $is_group_product) && 'yes' == $is_group_product ) {
								$wps_additional_section .= '<div class="wps_wgm_contribution_field" ><label class="wps_wgc_label">' . __( 'Contributors Email ', 'giftware' ) . '</label>
											<div class="wps_wgm_delivery_method">	
		
												<div class="wps_wgm_delivery_via_email">
													<input type="text"  name="wps_wgm_to_contributor_email" id="wps_wgm_to_contributor_email" class="wps_wgm_to_contributor_email" placeholder="' . __( 'Enter the Contributors Email', 'giftware' ) . '">
													<span class="wps_wgm_msg_info">' . __( 'To send it to contributors email addresses, please enter the contributors emails separated by commas.', 'giftware' ) . '</span>
													<span class= "wps_wgm_msg_info_multiple_name"></span>
												</div>
											</div></div>';
								}
							//////////////  end ///////////////
						}
						if ( (isset( $delivery_settings['wps_wgm_downloadable'] ) && 'on' == $delivery_settings['wps_wgm_downloadable'] ) && ( '' == $is_group_product)) {
							$wps_additional_section .= '
							<div class="wps_wgm_delivery_method wps-ts__b-item">
								<input type="radio" name="wps_wgm_send_giftcard" value="Downloadable" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_download"><span class="wps_wgm_method">' . __( 'You Print & Give To Recipient', 'giftware' ) . '</span>
								<div class="wps_wgm_delivery_via_buyer">
									<input type="text"  name="wps_wgm_to_email_name" id="wps_wgm_to_download" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'After checking out, you can print your Gift Card', 'giftware' ) . '</span>
								</div>
							</div>';
						}
						if ( (isset( $delivery_settings['wps_wgm_shipping'] ) && 'on' == $delivery_settings['wps_wgm_shipping']) && ( '' == $is_group_product) ) {
							$wps_additional_section .= '
							<div class="wps_wgm_delivery_method wps-ts__b-item">
								<input type="radio" name="wps_wgm_send_giftcard" value="shipping" class="wps_wgm_send_giftcard" id="wps_wgm_send_giftcard_ship">
								<span class="wps_wgm_method">' . __( 'Want To Ship Your Card', 'giftware' ) . '</span>
								<div class="wps_wgm_delivery_via_admin">
									<input type="text"  name="wps_wgm_to_email_ship" id="wps_wgm_to_ship" class="wps_wgm_to_email wps_wgm_disable" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '" readonly><span class= "wps_wgm_msg_info">' . __( 'We will ship your card', 'giftware' ) . '</span>
								</div>
							</div>';
						}
					}
				}
				
			$wps_additional_section .= '</div>';


	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		}
	
	////////////////////////////////////////////// changes done for layout //////////////////////////////////////////////////////////////
		$single_page_nonce = wp_create_nonce( 'wps_verify_nonce_single_' );
		
		return apply_filters( 'wps_uwgc_after_browse_section', $wps_additional_section, $product_id );
	}

	/**
	 * Upload Image for Giftcard product.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_upload_featured_image()
	 * @param array $post Contains post.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_upload_featured_image( $post ) {

		if ( isset( $_FILES['file']['type'] ) && ! empty( $_FILES['file']['type'] ) ) {

			$upload_dir_path = wp_upload_dir()['basedir'] . '/wps_browse';

			if ( ! is_dir( $upload_dir_path ) ) {
				wp_mkdir_p( $upload_dir_path );
				chmod( $upload_dir_path, 0775 );
			}

			if ( ( 'image/gif' == $_FILES['file']['type'] )
				|| ( 'image/jpeg' == $_FILES['file']['type'] )
				|| ( 'image/jpg' == $_FILES['file']['type'] )
				|| ( 'image/pjpeg' == $_FILES['file']['type'] )
				|| ( 'image/x-png' == $_FILES['file']['type'] )
				|| ( 'image/png' == $_FILES['file']['type'] ) ) {
				$file_name = isset( $_FILES['file']['name'] ) ? sanitize_text_field( wp_unslash( $_FILES['file']['name'] ) ) : '';
				$file_name = sanitize_file_name( $file_name );
				if ( ! file_exists( wp_upload_dir()['basedir'] . '/wps_browse/' . $file_name ) ) {
						$wps_temp = isset( $_FILES['file']['tmp_name'] ) ? sanitize_text_field( wp_unslash( $_FILES['file']['tmp_name'] ) ) : '';
						move_uploaded_file( $wps_temp, wp_upload_dir()['basedir'] . '/wps_browse/' . $file_name );
				}
				$post['name'] = $file_name;
			}
		}
		return $post;
	}

	/**
	 * Add fields on Preview Template on Giftcard single page.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_preview_template_fields()
	 * @param mixed $args conatins argument.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_preview_template_fields( $args ) {
		if ( isset( $_GET['name'] ) && null !== $_GET['name'] ) {
			$wps_name = isset( $_GET['name'] ) ? sanitize_text_field( wp_unslash( $_GET['name'] ) ) : '';
			$args['browse_image'] = $wps_name;
		}
		if ( isset( $_GET['send_date'] ) && null !== $_GET['send_date'] && 'undefined' !== $_GET['send_date'] ) {
			$send_date = isset( $_GET['send_date'] ) ? sanitize_text_field( wp_unslash( $_GET['send_date'] ) ) : '';
			$args['send_date'] = $send_date;
		}
		return $args;
	}
	/**
	 * Add Default event Images by users for giftcard.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_default_event_html()
	 * @param mixed $giftcard_event_html Contains HTML.
	 * @param array $args Contains argument.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_default_event_html( $giftcard_event_html, $args ) {
		if ( isset( $args['browse_image'] ) && null !== $args['browse_image'] ) {
			$wps_public_obj         = new Woocommerce_Gift_Cards_Common_Function();
			$other_settings         = get_option( 'wps_wgm_other_settings', array() );
			$wps_wgm_select_library = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_select_library' );
			if ( 'mpdf' == $wps_wgm_select_library ) {
				$giftcard_event_html = content_url( 'uploads/wps_browse/' . $args['browse_image'] );
			} else {
				$giftcard_event_html = "<img src='" . content_url( 'uploads/wps_browse/' . $args['browse_image'] ) . "' style='width:100%;' />";
			}
		}
		return $giftcard_event_html;
	}

	/**
	 * Add fields on Email template in common functionality.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_common_functionality_template_args()
	 * @param array $args Contains argument.
	 * @param array $wps_uwgc_common_arr Common arguments.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_common_functionality_template_args( $args, $wps_uwgc_common_arr ) {
		if ( isset( $wps_uwgc_common_arr['gift_img_name'] ) && '' !== $wps_uwgc_common_arr['gift_img_name'] ) {
			$args['browse_image'] = $wps_uwgc_common_arr['gift_img_name'];
		}
		if ( isset( $wps_uwgc_common_arr['to_name'] ) && '' !== $wps_uwgc_common_arr['to_name'] ) {
			$args['to'] = $wps_uwgc_common_arr['to_name'];
		}
		if ( isset( $wps_uwgc_common_arr['choosen_image'] ) && '' !== $wps_uwgc_common_arr['choosen_image'] ) {
			$args['choosen_image'] = $wps_uwgc_common_arr['choosen_image'];
		}
		if ( isset( $wps_uwgc_common_arr['cgc_file_name'] ) && '' !== $wps_uwgc_common_arr['cgc_file_name'] ) {
			$args['cgc_file_name'] = $wps_uwgc_common_arr['cgc_file_name'];
		}
		if ( isset( $wps_uwgc_common_arr['send_date'] ) && '' !== $wps_uwgc_common_arr['send_date'] ) {
			$args['send_date'] = $wps_uwgc_common_arr['send_date'];
		}
		$args = apply_filters( 'wps_uwgc_common_functionality_args', $args, $wps_uwgc_common_arr );
		return $args;
	}

	/**
	 * Add html on preview template for giftcard.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_email_template_html()
	 * @param array $templatehtml Contains HTML.
	 * @param array $args Contains arguments.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_email_template_html( $templatehtml, $args ) {

		// PRODUCTNAME SHORTCODE.
		$product_id = isset( $args['product_id'] ) ? $args['product_id'] : '';
		if ( isset( $product_id ) && ! empty( $product_id ) ) {
			$product = wc_get_product( $product_id );
		}
		$product_title = '';
		$pro_permalink = '';
		$product_format = '';
		$pro_short_desc = '';
		if ( isset( $product ) && ! empty( $product ) ) {
			$product_title  = $product->get_name();
			$pro_permalink  = $product->get_permalink();
			$pro_short_desc = '<br>' . get_the_excerpt( $product_id ) . '</br>';

			$product_format = "<a href='$pro_permalink'>$product_title</a>";
		}
		$order_id = isset( $args['order_id'] ) ? $args['order_id'] : '';

		$couponurl = wc_get_cart_url() . '?wps_giftcard_code=' . $args['coupon'];

		$applytocart = __( 'Apply This Coupon to Cart', 'giftware' );
		$couponlink  = "<a href='$couponurl' target='blank'>$applytocart</a>";

		$schedule_date = isset( $args['send_date'] ) ? $args['send_date'] : '';

		$templatehtml = str_replace( '[PRODUCTNAME]', $product_format, $templatehtml );
		$templatehtml = str_replace( '[PRODUCT]', $product_title, $templatehtml );
		$templatehtml = str_replace( '[ORDERID]', $order_id, $templatehtml );
		$templatehtml = str_replace( '[SHORTDESCRIPTION]', $pro_short_desc, $templatehtml );
		$templatehtml = str_replace( '[COUPONURL]', $couponlink, $templatehtml );
		$templatehtml = str_replace( '[SCHEDULEDATE]', $schedule_date, $templatehtml );
		return $templatehtml;
	}

	/**
	 * Adds the meta data into the Cart Item.
	 *
	 * @since 1.0.0
	 * @name wps_uwgc_add_cart_item_data()
	 * @param array $item_meta Contains item meta.
	 * @param array $the_cart_data Contains cart data.
	 * @param int   $product_id Contains product id.
	 * @param int   $variation_id Contains product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_add_cart_item_data( $item_meta, $the_cart_data, $product_id, $variation_id ) {

		// phpcs:disable WordPress.Security.NonceVerification.Missing

		$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_giftware', true );
		if ( isset( $_POST['wps_wgm_to_email_ship'] ) && ! empty( $_POST['wps_wgm_to_email_ship'] ) ) {
			$temp_meta['wps_wgm_to_email'] = sanitize_text_field( wp_unslash( $_POST['wps_wgm_to_email_ship'] ) );
			$item_meta = array_merge( $temp_meta, $item_meta );
		}
		if ( isset( $_POST['wps_wgm_selected_temp'] ) && empty( $is_customizable ) ) {
			$item_meta['wps_wgm_selected_temp'] = sanitize_text_field( wp_unslash( $_POST['wps_wgm_selected_temp'] ) );
		}
		if ( isset( $_FILES['wps_uwgc_browse_img']['type'] ) && ! empty( $_FILES['wps_uwgc_browse_img']['type'] ) ) {
			$upload_dir_path = wp_upload_dir()['basedir'] . '/wps_browse';
			if ( ! is_dir( $upload_dir_path ) ) {
				wp_mkdir_p( $upload_dir_path );
				chmod( $upload_dir_path, 0775 );
			}
			if ( ( 'image/gif' == $_FILES['wps_uwgc_browse_img']['type'] )
				|| ( 'image/jpeg' == $_FILES['wps_uwgc_browse_img']['type'] )
				|| ( 'image/jpg' == $_FILES['wps_uwgc_browse_img']['type'] )
				|| ( 'image/pjpeg' == $_FILES['wps_uwgc_browse_img']['type'] )
				|| ( 'image/x-png' == $_FILES['wps_uwgc_browse_img']['type'] )
				|| ( 'image/png' == $_FILES['wps_uwgc_browse_img']['type'] ) ) {

				$file_name = isset( $_FILES['wps_uwgc_browse_img']['name'] ) ? sanitize_text_field( wp_unslash( $_FILES['wps_uwgc_browse_img']['name'] ) ) : '';
				if ( ! file_exists( wp_upload_dir()['basedir'] . '/wps_browse/' . $file_name ) ) {
					$wps_temp = isset( $_FILES['wps_uwgc_browse_img']['tmp_name'] ) ? sanitize_text_field( wp_unslash( $_FILES['wps_uwgc_browse_img']['tmp_name'] ) ) : '';
					move_uploaded_file( $wps_temp, wp_upload_dir()['basedir'] . '/wps_browse/' . $file_name );
				}
				$item_meta['wps_uwgc_browse_img'] = $file_name;
			}
		}
		if ( isset( $_POST['wps_uwgc_send_date'] ) && ! empty( $_POST['wps_uwgc_send_date'] ) ) {
			$item_meta['wps_uwgc_send_date'] = isset( $_POST['wps_uwgc_send_date'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_uwgc_send_date'] ) ) : '';
		}
		if ( isset( $_POST['wps_wgm_time'] ) && ! empty( $_POST['wps_wgm_time'] ) ) {
			$item_meta['wps_wgm_time'] = isset( $_POST['wps_wgm_time'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_time'] ) ) : '';
		}
		if ( isset( $_POST['wps_wgm_to_name_optional'] ) && ! empty( $_POST['wps_wgm_to_name_optional'] ) ) {
			$item_meta['wps_wgm_to_name_optional'] = isset( $_POST['wps_wgm_to_name_optional'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_to_name_optional'] ) ) : '';
		}
		// is_group_gift /////////////////////.
		if ( isset( $_POST['wps_wgm_to_contributor_email'] ) && ! empty( $_POST['wps_wgm_to_contributor_email'] ) ) {
			$item_meta['wps_wgm_to_contributor_email'] = isset( $_POST['wps_wgm_to_contributor_email'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_wgm_to_contributor_email'] ) ) : '';
		}
			// end //////////////.
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$notification_settings = get_option( 'wps_wgm_notification_settings', array() );
		$username = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_account_sid' );
		$password = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_auth_token' );
		$wps_wgm_enable_whatsapp_notification = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_enable_whatsapp_notification' );
		if ( ( isset( $username ) && '' !== $username && isset( $password ) && '' !== $password ) || 'yes' == $wps_wgm_enable_whatsapp_notification ) {
			if ( isset( $_POST['wps_whatsapp_contact'] ) && ! empty( $_POST['wps_whatsapp_contact'] ) ) {
				$item_meta['wps_whatsapp_contact'] = sanitize_text_field( wp_unslash( $_POST['wps_whatsapp_contact'] ) );
			}
		}
		if ( isset( $_POST['wps_gift_this_product'] ) ) {
			$item_meta['sell_as_a_gc'] = sanitize_text_field( wp_unslash( $_POST['wps_gift_this_product'] ) );
		}
		$item_meta = apply_filters( 'wps_uwgc_item_meta_data', $item_meta, $product_id );
		return $item_meta;
		// phpcs:enable WordPress.Security.NonceVerification.Missing.
	}

	/**
	 * This function is used to append the prices through ajax request
	 *
	 * @name wps_uwgc_append_prices
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_append_prices() {
		check_ajax_referer( 'wps-uwgc-verify-nonce', 'wps_uwgc_nonce' );
		$response['result'] = false;
		$new_price = '';
		$discount_applicable = false;
		$product_id = isset( $_POST['product_id'] ) ? sanitize_text_field( wp_unslash( $_POST['product_id'] ) ) : '';
		if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
			if ( null !== wcpbc_the_zone() && wcpbc_the_zone() ) {
				$wps_uwgc_range_price = isset( $_POST['wps_uwgc_price'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_uwgc_price'] ) ) : '';
				if ( isset( $wps_uwgc_range_price ) && ! empty( $wps_uwgc_range_price ) ) {
					$exchange_rate = wcpbc_the_zone()->get_exchange_rate();
					$wps_uwgc_range_price = floatval( $wps_uwgc_range_price / $exchange_rate );
				}
			}
		} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_to_base_currency' ) ) {
			$wps_uwgc_range_price = isset( $_POST['wps_uwgc_price'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_uwgc_price'] ) ) : '';
			if ( isset( $wps_uwgc_range_price ) && ! empty( $wps_uwgc_range_price ) ) {
				$wps_uwgc_range_price = wps_mmcsfw_admin_fetch_currency_rates_to_base_currency( '', $wps_uwgc_range_price );
			}
		} else {
			$wps_uwgc_range_price = isset( $_POST['wps_uwgc_price'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_uwgc_price'] ) ) : '';
		}

		$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );

		$discount_min = $wps_wgm_discount_data['discount_min'];
		$discount_max = $wps_wgm_discount_data['discount_max'];
		$discount_type = $wps_wgm_discount_data['discount_type'];
		$discount_value = $wps_wgm_discount_data['discount_value'];

		if ( isset( $wps_uwgc_range_price ) && ! empty( $wps_uwgc_range_price ) ) {
			if ( isset( $discount_min ) && null !== $discount_min && isset( $discount_max ) && null !== $discount_max && isset( $discount_value ) && null !== $discount_value ) {
				foreach ( $discount_min as $key => $value ) {
					if ( $discount_min[ $key ] <= $wps_uwgc_range_price && $wps_uwgc_range_price <= $discount_max[ $key ] ) {
						if ( 'Percentage' == $discount_type ) {
							$new_price = $wps_uwgc_range_price - ( $wps_uwgc_range_price * $discount_value[ $key ] ) / 100;
						} else {
							$new_price = $wps_uwgc_range_price - $discount_value[ $key ];
						}
						$discount_applicable = true;
					}
				}
			}
			if ( $discount_applicable ) {
				if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
					if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
						$new_price = wcpbc_the_zone()->get_exchange_rate_price( $new_price );
						$wps_uwgc_range_price = wcpbc_the_zone()->get_exchange_rate_price( $wps_uwgc_range_price );
					}
					$response['result'] = true;
					$response['new_price'] = wc_price( $new_price );
					$response['wps_uwgc_price'] = wc_price( $wps_uwgc_range_price );
					echo json_encode( $response );
				} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
					$new_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $new_price );
					$wps_uwgc_range_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $wps_uwgc_range_price );
					$response['result'] = true;
					$response['new_price'] = wc_price( $new_price );
					$response['wps_uwgc_price'] = wc_price( $wps_uwgc_range_price );
					echo json_encode( $response );
				} else {
					$response['result'] = true;
					$response['new_price'] = wc_price( $new_price );
					$response['wps_uwgc_price'] = wc_price( $wps_uwgc_range_price );
					echo json_encode( $response );
				}
			} else {
				$response['result'] = false;
				echo json_encode( $response );
			}
			wp_die();
		}
	}

	/**
	 * This function is used to add metadata with item.
	 *
	 * @name wps_uwgc_get_item_meta.
	 * @param array $item_meta Item meta.
	 * @param mixed $key Key.
	 * @param mixed $val value.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_get_item_meta( $item_meta, $key, $val ) {

		// is_group_gift /////////////////////.
		if ( 'wps_wgm_to_contributor_email' == $key ) {
			$item_meta [] = array(
				'name' => __( 'Contributor', 'giftware' ),
				'value' => stripslashes( $val ),
			);
		}
		// end //////////////////////.
		if ( 'wps_uwgc_send_date' == $key ) {
			$item_meta [] = array(
				'name' => __( 'Send Date', 'giftware' ),
				'value' => stripslashes( $val ),
			);
		}
		if ( 'wps_wgm_time' == $key ) {
			$item_meta [] = array(
				'name' => __( 'Send Time', 'giftware' ),
				'value' => stripslashes( $val ),
			);
		}
		if ( 'wps_whatsapp_contact' == $key ) {
			$item_meta [] = array(
				'name' => __( 'Reciever Contact', 'giftware' ),
				'value' => stripslashes( $val ),
			);
		}
		if ( 'wps_expiry_extension_coupon_code' == $key ) {
			$item_meta [] = array(
				'name' => __( 'Coupon Code', 'giftware' ),
				'value' => stripslashes( $val ),
			);
		}
		if ( 'wps_uwgc_expiry_extension_days' == $key ) {
			$item_meta [] = array(
				'name' => __( 'Days Extended', 'giftware' ),
				'value' => stripslashes( $val ),
			);
		}

		$item_meta = apply_filters( 'wps_uwgc_product_item_meta', $item_meta, $key, $val );
		return $item_meta;
	}

	/**
	 * This function is used to add metadata on checkout.
	 *
	 * @name wps_uwgc_checkout_create_order_line_item.
	 * @param array  $item Item.
	 * @param string $key key.
	 * @param array  $order_val Order value.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_checkout_create_order_line_item( $item, $key, $order_val ) {
		if ( 'sell_as_a_gc' == $key ) {
			$item->add_meta_data( 'Purchase as a Gift', stripslashes( $order_val ) );
		}
		// is_group_gift /////////////////////.
		if ( 'wps_wgm_to_contributor_email' == $key ) {
			$item->add_meta_data( 'Contributor', stripslashes( $order_val ) );
		}
		// end ///////.
		if ( 'wps_wgm_to_name_optional' == $key ) {
			$item->add_meta_data( 'To Name', stripslashes( $order_val ) );
		}
		if ( 'wps_uwgc_send_date' == $key ) {
			$item->add_meta_data( 'Send Date', stripslashes( $order_val ) );
		}
		if ( 'wps_wgm_time' == $key ) {
			$item->add_meta_data( 'Send Time', stripslashes( $order_val ) );
		}
		if ( 'wps_uwgc_browse_img' == $key ) {
			$item->add_meta_data( 'Image', stripslashes( $order_val ) );
		}
		if ( 'wps_cgc_image' == $key ) {
			$item->add_meta_data( 'Choosen Image', stripslashes( $order_val ) );
		}
		if ( 'wps_cgc_custom_img' == $key ) {
			$item->add_meta_data( 'File Name', stripslashes( $order_val ) );
		}
		if ( 'wps_whatsapp_contact' == $key ) {
			$item->add_meta_data( 'Reciever Contact', stripslashes( $order_val ) );
		}
		if ( 'wps_expiry_extension_coupon_code' == $key ) {
			$item->add_meta_data( 'Coupon Code', stripslashes( $order_val ) );
		}
		if ( 'wps_uwgc_expiry_extension_days' == $key ) {
			$item->add_meta_data( 'Days Extended', stripslashes( $order_val ) );
		}
		do_action( 'wps_uwgc_create_order_line_item', $item, $key, $order_val );
	}

	/**
	 * Add Extra coupon fields on coupon creation.
	 *
	 * @name wps_uwgc_add_more_coupon_fields
	 * @param mixed $extra_data Contains extra data.
	 * @param mixed $new_coupon_id Contains Coupon id.
	 * @param mixed $product_id contains product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_add_more_coupon_fields( $extra_data, $new_coupon_id, $product_id ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		if ( ( isset( $new_coupon_id ) && isset( $product_id ) ) && ( '' !== $new_coupon_id && '' !== $product_id ) ) {
			$todaydate = date_i18n( 'Y-m-d' );
			$is_imported_product = get_post_meta( $product_id, 'is_imported', true );

			// set the expiry date of imported giftcard.
			if ( isset( $is_imported_product ) && ! empty( $is_imported_product ) && 'yes' == $is_imported_product ) {

				$expiry_date = get_post_meta( $product_id, 'expiry_after_days', true );

				if ( $expiry_date > 0 || 0 === $expiry_date ) {
					$expirydate = date_i18n( 'Y-m-d', strtotime( "$todaydate +$expiry_date day" ) );
					
				} else {
					$expirydate = '';
				}
				$extra_data['expiry_date'] = $expirydate;
			}

			$product_settings = get_option( 'wps_wgm_product_settings', array() );

			$include_categories = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_product_setting_include_category' );

			$wps_wgm_include_per_category = get_post_meta( $product_id, 'wps_wgm_include_per_category', true );

			$include_products = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_product_setting_include_product' );
			$include_products = ( is_array( $include_products ) && ! empty( $include_products ) ) ? implode( ',', $include_products ) : '';

			$include_per_products = get_post_meta( $product_id, 'wps_wgm_include_per_product', true );

			$include_per_products = ( is_array( $include_per_products ) && ! empty( $include_per_products ) ) ? implode( ',', $include_per_products ) : '';

			$exclude_per_product_category = get_post_meta( $product_id, 'wps_wgm_exclude_per_category', true );
			$extra_data['exclude_per_product_category'] = $exclude_per_product_category;

			$exclude_per_products = get_post_meta( $product_id, 'wps_wgm_exclude_per_product', true );

			$exclude_per_products = ( is_array( $exclude_per_products ) && ! empty( $exclude_per_products ) ) ? implode( ',', $exclude_per_products ) : '';

			$extra_data['exclude_per_products'] = $exclude_per_products;

			$wps_wgm_excluded_days_per_product = get_post_meta( $product_id, 'wps_wgm_excluded_days_per_product', true );

			$day_excluded = $wps_public_obj->wps_wgm_get_template_data( $product_settings, 'wps_wgm_excluded_days' );

			// include products.
			if ( isset( $include_per_products ) && '' !== $include_per_products ) {
				update_post_meta( $new_coupon_id, 'product_ids', $include_per_products );
			} else {
				update_post_meta( $new_coupon_id, 'product_ids', $include_products );
			}
			// include category.
			if ( isset( $wps_wgm_include_per_category ) && is_array( $wps_wgm_include_per_category ) && ! empty( $wps_wgm_include_per_category ) ) {
				update_post_meta( $new_coupon_id, 'product_categories', $wps_wgm_include_per_category );
			} else {
				update_post_meta( $new_coupon_id, 'product_categories', $include_categories );
			}

			if ( isset( $wps_wgm_excluded_days_per_product ) && is_array( $wps_wgm_excluded_days_per_product ) && ! empty( $wps_wgm_excluded_days_per_product ) ) {
				update_post_meta( $new_coupon_id, 'wps_wgm_excluded_days', $wps_wgm_excluded_days_per_product );
			} else {
				update_post_meta( $new_coupon_id, 'wps_wgm_excluded_days', $day_excluded );
			}
			
		}
		return $extra_data;
	}

	/**
	 * Add Extra Aditional feature on pdf settings.
	 *
	 * @name wps_uwgc_add_more_coupon_fields.
	 * @param array  $wps_uwgc_common_arr Contains common arguments.
	 * @param string $message contains message.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_add_pdf_settings( $wps_uwgc_common_arr, $message ) {

		if ( isset( $wps_uwgc_common_arr ) && is_array( $wps_uwgc_common_arr ) && ! empty( $wps_uwgc_common_arr ) ) {
			$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();

			$wps_uwgc_other_settings = get_option( 'wps_wgm_other_settings', array() );
			$wps_wgm_delivery_settings = get_option( 'wps_wgm_delivery_settings', array() );
			$general_setting = get_option( 'wps_wgm_general_settings', array() );
			$giftcard_pdf_prefix = $wps_public_obj->wps_wgm_get_template_data( $general_setting, 'wps_wgm_general_setting_pdf_prefix' );

			$wps_uwgc_pdf_enable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_addition_pdf_enable' );

			if ( isset( $wps_uwgc_pdf_enable ) && 'on' == $wps_uwgc_pdf_enable ) {
				$site_name = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
				$time = time();
				$this->wps_common_fun->wps_uwgc_attached_pdf( $message, $site_name, $time, $wps_uwgc_common_arr['order_id'], $wps_uwgc_common_arr['gift_couponnumber'] );
				if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
					$attachments = array( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $wps_uwgc_common_arr['gift_couponnumber'] . '.pdf' );
				} else {
					$attachments = array( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
				}
				$wps_uwgc_common_arr['attachments'] = $attachments;

			} else {

				$wps_uwgc_common_arr['attachments'] = array();
			}

			if ( isset( $wps_uwgc_common_arr['delivery_method'] ) && 'shipping' == $wps_uwgc_common_arr['delivery_method'] ) {
				$admin_email = get_option( 'admin_email' );

				$wps_change_admin_email = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_delivery_settings, 'wps_wgm_change_admin_email_for_shipping' );
				$alternate_email = ! empty( $wps_change_admin_email ) ? $wps_change_admin_email : $admin_email;
				$wps_uwgc_common_arr['to'] = $alternate_email;
			}
			$wps_uwgc_bcc_enable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_addition_bcc_option_enable' );
			$wps_bcc_to_admin_enable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_addition_bcc_option_enable_for_site_admin' );
			if ( isset( $wps_uwgc_bcc_enable ) && 'on' == $wps_uwgc_bcc_enable ) {

				if ( isset( $wps_uwgc_common_arr['order_id'] ) && ! empty( $wps_uwgc_common_arr['order_id'] ) ) {

					$order = wc_get_order( $wps_uwgc_common_arr['order_id'] );
					$woo_ver = WC()->version;
					if ( $woo_ver < '3.0.0' ) {
						$from = $order->billing_email;
					} else {
						$from = $order->get_billing_email();
					}
					$headers[] = 'Bcc:' . $from;
					if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
						$headers[] = 'Bcc:' . get_option( 'admin_email' );
					}
					$wps_uwgc_common_arr['header'] = $headers;

				}
			}
			$disable_buyer_notification = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_disable_buyer_notification' );
			if ( isset( $disable_buyer_notification ) && 'on' == $disable_buyer_notification ) {
				$wps_uwgc_common_arr['disable_buyer_notice'] = 'on';
			}

			$wps_uwgc_mail_template_settings = get_option( 'wps_wgm_mail_settings', array() );
			if ( isset( $wps_uwgc_common_arr['delivery_method'] ) && 'Downloadable' == $wps_uwgc_common_arr['delivery_method'] ) {

				$send_subject = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_mail_template_settings, 'wps_wgm_mail_setting_giftcard_subject_downloadable' );

				$wps_uwgc_common_arr['send_subject'] = $send_subject;
			}
			if ( isset( $wps_uwgc_common_arr['delivery_method'] ) && 'shipping' == $wps_uwgc_common_arr['delivery_method'] ) {

				$send_subject = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_mail_template_settings, 'wps_wgm_mail_setting_giftcard_subject_shipping' );

				$order_id = isset( $wps_uwgc_common_arr['order_id'] ) ? $wps_uwgc_common_arr['order_id'] : '';
				$send_subject = str_replace( '[ORDERID]', $order_id, $send_subject );
				$wps_uwgc_common_arr['send_subject'] = $send_subject;
			}

			$receive_subject = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_mail_template_settings, 'wps_wgm_mail_setting_receive_subject' );
			$receive_message = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_mail_template_settings, 'wps_wgm_mail_setting_receive_message' );

			$wps_uwgc_common_arr['receive_subject'] = $receive_subject;
			$wps_uwgc_common_arr['receive_message'] = $receive_message;
		}
		return $wps_uwgc_common_arr;
	}

	/**
	 * Update remaining amount of offline/Imported coupons.
	 *
	 * @name wps_uwgc_offline_giftcard_coupon.
	 * @param mixed $coupon_id Coupon id.
	 * @param mixed $item Item data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_offline_giftcard_coupon( $coupon_id, $item ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_discount = $item->get_discount();
		$wps_wgm_discount_tax = $item->get_discount_tax();
		$couponpost = get_post( $coupon_id );
		$couponcontent = $couponpost->post_content;
		if ( ( false !== strpos( $couponcontent, 'GIFTCARD ORDER #' ) ) || ( false !== strpos( $couponcontent, 'OFFLINE GIFTCARD ORDER #' ) ) || ( false !== strpos( $couponcontent, 'Imported Offline Coupon' ) || ( false !== strpos( $couponcontent, 'ThankYou ORDER #' ) ) ) ) {
			$amount = get_post_meta( $coupon_id, 'coupon_amount', true );
			$total_discount = $wps_public_obj->wps_wgm_calculate_coupon_discount( $wps_wgm_discount, $wps_wgm_discount_tax );
			if ( $amount < $total_discount ) {
				$remaining_amount = 0;
			} else {
				$remaining_amount = $amount - $total_discount;
				$remaining_amount = round( $remaining_amount, 2 );
			}
			update_post_meta( $coupon_id, 'coupon_amount', $remaining_amount );
			$coupon_id = $this->wps_uwgc_send_mail_to_user( $coupon_id, $remaining_amount );
			$coupon_id = apply_filters( 'wps_uwgc_coupon_after_mail_send', $coupon_id );
		}
	}

	/**
	 * Function to send Remaining amount after giftcard coupon is used.
	 *
	 * @name wps_uwgc_send_mail_to_user.
	 * @param mixed  $coupon_id Coupon id.
	 * @param string $remaining_amount Remaining amount.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_send_mail_to_user( $coupon_id, $remaining_amount ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$to = get_post_meta( $coupon_id, 'wps_wgm_giftcard_coupon_mail_to', true );
		$couponpost = get_post( $coupon_id );
		if ( isset( $couponpost ) ) {
			$couponcode = $couponpost->post_title;
		}
		$couponcode = isset( $couponcode ) ? $couponcode : '';

		$wps_wgm_mail_settings = get_option( 'wps_wgm_mail_settings', array() );

		$subject                    = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_mail_settings, 'wps_wgm_mail_setting_receive_coupon_subject' );
		$message                    = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_mail_settings, 'wps_wgm_mail_setting_receive_coupon_message' );
		$coupon_amount_notification = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_mail_settings, 'wps_wgm_mail_setting_disable_coupon_notification_mail' );
		$giftcard_disclaimer        = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_mail_settings, 'wps_wgm_mail_setting_disclaimer' );

		$bloginfo = get_bloginfo();
		if ( ! isset( $subject ) || empty( $subject ) ) {
			$subject = "$bloginfo:";
			$subject .= __( 'Coupon Amount Notification', 'giftware' );
		}
		if ( empty( $message ) ) {
			ob_start();
			include_once WPS_UWGC_DIRPATH . 'public/partials/wps-uwgc-coupon-template.php';
			$content = ob_get_clean();
			$message = $content;
		}
		if ( isset( $giftcard_disclaimer ) && empty( $giftcard_disclaimer ) ) {
			$giftcard_disclaimer = __( 'Disclaimer Text', 'giftware' );
		}
		$subject = str_replace( '[SITENAME]', $bloginfo, $subject );
		$subject = stripcslashes( $subject );
		$subject = html_entity_decode( $subject, ENT_QUOTES, 'UTF-8' );

		if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
			if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {

				$remaining_amount = wcpbc_the_zone()->get_exchange_rate_price( $remaining_amount );

				$message = str_replace( '[COUPONAMOUNT]', get_woocommerce_currency_symbol() . $remaining_amount, $message );
			} else {
				$message = str_replace( '[COUPONAMOUNT]', get_woocommerce_currency_symbol() . $remaining_amount, $message );
			}
		} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
			$remaining_amount = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $remaining_amount );
			$message = str_replace( '[COUPONAMOUNT]', get_woocommerce_currency_symbol() . $remaining_amount, $message );
		} else {
			$message = str_replace( '[COUPONAMOUNT]', get_woocommerce_currency_symbol() . $remaining_amount, $message );
		}
		$message = str_replace( '[SITENAME]', $bloginfo, $message );
		$message = str_replace( '[DISCLAIMER]', $giftcard_disclaimer, $message );
		$message = str_replace( '[COUPONCODE]', $couponcode, $message );
		$message = stripcslashes( $message );
		$message = html_entity_decode( $message, ENT_QUOTES, 'UTF-8' );

		$other_settings = get_option( 'wps_wgm_other_settings', array() );

		$wps_uwgc_bcc_enable = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable' );
		$from = '';

		if ( isset( $wps_uwgc_bcc_enable ) && 'on' == $wps_uwgc_bcc_enable ) {
			$order_id = get_post_meta( $coupon_id, 'wps_wgm_giftcard_coupon', true );
			if ( isset( $order_id ) && '' !== $order_id ) {
				$order = wc_get_order( $order_id );
				if ( ! empty( $order ) ) {
					$woo_ver = WC()->version;
					if ( $woo_ver < '3.0.0' ) {
						$from = $order->billing_email;
					} else {
						$from = $order->get_billing_email();
					}
				}
			}
			$headers[] = 'Bcc:' . $from;
			if ( empty( $coupon_amount_notification ) ) {
				wc_mail( $to, $subject, $message, $headers );
			}
		} else {
			if ( empty( $coupon_amount_notification ) ) {
				wc_mail( $to, $subject, $message );
			}
		}
		return $coupon_id;
	}

	/**
	 * This function is used to return the remaining coupon amount according to Tax setting you have in your system.
	 *
	 * @name wps_calculate_coupon_discount.
	 * @param mixed $wps_wgm_discount Discount.
	 * @param mixed $wps_wgm_discount_tax Tax.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_calculate_coupon_discount( $wps_wgm_discount, $wps_wgm_discount_tax ) {
		$price_in_ex_option = get_option( 'woocommerce_prices_include_tax' );
		$tax_display_shop = get_option( 'woocommerce_tax_display_shop', 'excl' );
		$tax_display_cart = get_option( 'woocommerce_tax_display_cart', 'excl' );

		if ( isset( $tax_display_shop ) && isset( $tax_display_cart ) ) {
			if ( 'excl' == $tax_display_cart && 'excl' == $tax_display_shop ) {

				if ( 'yes' == $price_in_ex_option || 'no' == $price_in_ex_option ) {

					return $wps_wgm_discount;
				}
			} elseif ( 'incl' == $tax_display_cart && 'incl' == $tax_display_shop ) {

				if ( 'yes' == $price_in_ex_option || 'no' == $price_in_ex_option ) {

					return $wps_wgm_discount + $wps_wgm_discount_tax;
				}
			} else {
				return $wps_wgm_discount;
			}
		}
	}

	/**
	 * This function is used to send remaining amount of coupon for online giftcard coupon.
	 *
	 * @name wps_uwgc_send_mail_remaining_amount.
	 * @param mixed $coupon_id coupon id.
	 * @param mixed $remaining_amount Remaining amount.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_send_mail_remaining_amount( $coupon_id, $remaining_amount ) {
		$coupon_id = $this->wps_uwgc_send_mail_to_user( $coupon_id, $remaining_amount );
	}

	/**
	 * Enable the selected payment gateways for giftcard product.
	 *
	 * @name wps_uwgc_available_payment_gateways.
	 * @param mixed $payment_gateways Payment gateways.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_available_payment_gateways( $payment_gateways ) {
		if ( is_admin() || ! is_checkout() ) {
			return $payment_gateways;
		}

		global $product_type;
		global $woocommerce;
		$wps_uwgc_gift_exist = false;

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();

		$whole_cart = WC()->cart;
		if ( isset( $whole_cart ) && ! empty( $whole_cart ) ) {
			$wps_uwgc_not_giftcard = false;
			$get_cart = $whole_cart->get_cart();
			foreach ( $get_cart as $cart_item_key => $cart_item ) {
				$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

				$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				$product_types = wp_get_object_terms( $product_id, 'product_type' );

				if ( isset( $product_types[0] ) ) {
					$product_type = $product_types[0]->slug;

					if ( 'wgm_gift_card' == $product_type ) {
						$wps_uwgc_gift_exist = true;
					} else {
						$wps_uwgc_not_giftcard = true;
					}
				}
			}

			if ( $wps_uwgc_gift_exist ) {
				if ( is_checkout() ) {
					$general_settings = get_option( 'wps_wgm_general_settings', array() );
					$giftcard_payment_gateways = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_payment' );

					if ( ! $wps_uwgc_not_giftcard ) {

						if ( isset( $giftcard_payment_gateways ) && ! empty( $giftcard_payment_gateways ) ) {
							if ( isset( $payment_gateways ) && ! empty( $payment_gateways ) && is_array( $payment_gateways ) ) {
								foreach ( $payment_gateways as $key => $payment_gateway ) {
									if ( ! in_array( $key, $giftcard_payment_gateways ) ) {
										unset( $payment_gateways[ $key ] );
									}
								}
							}
						} else {
							if ( isset( $payment_gateways ) && ! empty( $payment_gateways ) && is_array( $payment_gateways ) ) {
								foreach ( $payment_gateways as $key => $payment_gateway ) {
									unset( $payment_gateways['cod'] );
								}
							}
						}
					} else {
						if ( isset( $giftcard_payment_gateways ) && ! empty( $giftcard_payment_gateways ) ) {
							if ( isset( $payment_gateways ) && ! empty( $payment_gateways ) && is_array( $payment_gateways ) ) {
								foreach ( $payment_gateways as $key => $payment_gateway ) {
									if ( ! in_array( $key, $giftcard_payment_gateways ) && 'cod' == $key ) {
										unset( $payment_gateways['cod'] );
									}
								}
							}
						} else {
							if ( isset( $payment_gateways ) && ! empty( $payment_gateways ) && is_array( $payment_gateways ) ) {
								foreach ( $payment_gateways as $key => $payment_gateway ) {
									unset( $payment_gateways['cod'] );
								}
							}
						}
					}
				}
			}
		}
		return $payment_gateways;
	}

	/**
	 * This function is used to Add qrcode/barcode for coupon code.
	 *
	 * @name wps_uwgc_qrcode_coupon.
	 * @param mixed $coupon contains coupons.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_qrcode_coupon( $coupon ) {

		$qrcode_object = new Wps_Uwgc_Qrcode_Barcode();
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();

		$site_name = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
		$time_stamp = time();

		$wps_uwgc_qrcode_settings = get_option( 'wps_wgm_qrcode_settings', array() );

		$wps_wgm_qrcode_enable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_qrcode_enable' );
		$qrcode_level = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_qrcode_ecc_level' );
		$qrcode_size = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_qrcode_size' );
		$qrcode_margin = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_qrcode_margin' );

		if ( 'qrcode' == $wps_wgm_qrcode_enable ) {

			
			$qrcode_level = ( '' !== $qrcode_level ) ? $qrcode_level : 'L';
			$qrcode_size = ( '' !== $qrcode_size ) ? $qrcode_size : 3;
			$qrcode_margin = ( '' !== $qrcode_margin ) ? $qrcode_margin : 4;

			$qrcode_display = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_qrcode_display_enable' );
	
			$qrcode_object->getqrcode( $coupon, $qrcode_level, $qrcode_size, $qrcode_margin, $time_stamp, $site_name );
			if ( "on" == $qrcode_display ) {
				return '<img class = "wps_wgm_coupon_img" id = "' . $time_stamp . $site_name . '" src="' . WPS_UWGC_UPLOAD_URL . '/qrcode_barcode/wps__' . $time_stamp . $coupon . '.png"><div>'.$coupon.'</div>';
			} else {
				return '<img class = "wps_wgm_coupon_img" id = "' . $time_stamp . $site_name . '" src="' . WPS_UWGC_UPLOAD_URL . '/qrcode_barcode/wps__' . $time_stamp . $coupon . '.png">';
			}
		} elseif ( 'barcode' == $wps_wgm_qrcode_enable ) {

			$barcode_display = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_barcode_display_enable' );
			$barcode_type = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_barcode_codetype' );
			$barcode_size = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_qrcode_settings, 'wps_wgm_barcode_size' );

			$barcode_type = ( '' !== $barcode_type ) ? $barcode_type : 'code39';
			$barcode_size = ( '' !== $barcode_size ) ? $barcode_size : '20';

			$qrcode_object->getbarcode( $coupon, $barcode_display, $barcode_type, $barcode_size, $time_stamp, $site_name );
			return '<img class = "wps_wgm_coupon_img" id = "' . $time_stamp . $site_name . '" src="' . WPS_UWGC_UPLOAD_URL . '/qrcode_barcode/wps__' . $time_stamp . $coupon . '.png">';
		} else {
			return $coupon;
		}
	}

	/**
	 * This function is used to Add Preview link on shop page for Giftcard product.
	 *
	 * @name wps_uwgc_preview_link_shop_page
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_preview_link_shop_page() {
		$wps_uwgc_enable = wps_wgm_giftcard_enable();
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_uwgc_other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_uwgc_preview_disable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_additional_preview_disable' );

		if ( $wps_uwgc_enable ) {
			global $post;
			$product_id = $post->ID;
			$product_types = wp_get_object_terms( $product_id, 'product_type' );
			if ( isset( $product_types[0] ) ) {
				$product_type = $product_types[0]->slug;
				if ( 'wgm_gift_card' == $product_type ) {
					add_thickbox();

					$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_giftware', true );

					if ( 'on' !== $wps_uwgc_preview_disable && 'yes' !== $is_customizable ) {
						?>
						<span class="wps_uwgc_price" >
							<a href="<?php echo esc_url( home_url( "?wps_uwgc_preview_email_shop_page=wps_uwgc_preview_email_shop_page&product_id=$product_id" ) ); ?>&TB_iframe=true&width=100&height=200" class="thickbox button"><?php esc_html_e( 'Preview', 'giftware' ); ?></a>	
						</span>
						<?php
					}
				}
			}
		}
	}

	/**
	 * This function is used to Show Email Template on shop Page.
	 *
	 * @name wps_uwgc_preview_email_template_shop_page.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_preview_email_template_shop_page() {
		if ( isset( $_GET['wps_uwgc_preview_email_shop_page'] ) && 'wps_uwgc_preview_email_shop_page' == $_GET['wps_uwgc_preview_email_shop_page'] ) {
			if ( isset( $_GET['product_id'] ) ) {
				$product_id = sanitize_text_field( wp_unslash( $_GET['product_id'] ) );
				$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
				$wps_uwgc_general_settings = get_option( 'wps_wgm_general_settings', array() );
				$todaydate = date_i18n( 'Y-m-d' );

								$local_expiry_day = get_post_meta( $product_id, 'wps_wgm_local_setting_giftcard_expiry', true );
				if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
					$expiry_date = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
				} else {
					$expiry_date = $local_expiry_day;
				}
				
				$selected_date_format = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_enable_selected_format' );

				if ( $expiry_date > 0 || 0 === $expiry_date ) {
					$expirydate = date_i18n( 'Y-m-d', strtotime( "$todaydate +$expiry_date day" ) );
					$expirydate_format = date_create( $expirydate );

					if ( isset( $selected_date_format ) && null !== $selected_date_format && '' !== $selected_date_format ) {

						$selected_date_format = $this->wps_common_fun->wps_uwgc_selected_date_format( $selected_date_format );
						$expirydate_format = date_i18n( $selected_date_format, strtotime( "$todaydate +$expiry_date day" ) );
					} else {
						$expirydate_format = date_format( $expirydate_format, 'jS M Y' );
					}
				} else {
					$expirydate_format = __( 'No Expiration', 'giftware' );
				}

				$wps_uwgc_coupon_length = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );

				if ( '' == $wps_uwgc_coupon_length ) {
					$wps_uwgc_coupon_length = 5;
				}
				$password = '';
				for ( $i = 0;$i < $wps_uwgc_coupon_length;$i++ ) {
					$password .= 'x';
				}
				$giftcard_prefix = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_giftcard_prefix' );
				$coupon = $giftcard_prefix . $password;

				$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing', true );

				$templateids = isset( $wps_wgm_pricing['template'] ) && ! empty( $wps_wgm_pricing['template'] ) ? $wps_wgm_pricing['template'] : false;

				$preferedid = isset( $wps_wgm_pricing['by_default_tem'] ) ? $wps_wgm_pricing['by_default_tem'] : '';

				$prefered_template_id = '';
				if ( is_array( $templateids ) && ! empty( $preferedid ) ) {
					$prefered_template_id = $preferedid;
				} elseif ( is_array( $templateids ) && ! empty( $templateids ) ) {
					$prefered_template_id = $templateids[0];
				} elseif ( is_array( $templateids ) && empty( $preferedid ) ) {
					$prefered_template_id = $templateids[0];
				} elseif ( ! is_array( $templateids ) && ! empty( $templateids ) ) {
					$prefered_template_id = $templateids;
				}

				$args['from'] = __( 'from@example.com', 'giftware' );
				$args['to'] = __( 'to@example.com', 'giftware' );
				$args['message'] = __( 'Your gift message will appear here which you send to your receiver. ', 'giftware' );
				$args['coupon'] = apply_filters( 'wps_wgm_qrcode_coupon', $coupon );
				$args['expirydate'] = $expirydate_format;
				$args['amount'] = wc_price( 100 );
				$args['templateid'] = $prefered_template_id;
				$args['product_id'] = $product_id;
				$args['order_id'] = '';
				$message = $wps_public_obj->wps_wgm_create_gift_template( $args );
				$finalhtml = $message;
				$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
				$allowed_tags = $wps_admin_obj->wps_allowed_html_tags();
				echo wp_kses( $finalhtml, $allowed_tags );
				wp_die();
			}
		}
	}

	/**
	 * This function is used set the selected Date Format for Email template.
	 *
	 * @name wps_uwgc_select_date_format_enable.
	 * @param data $date_format date format.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_select_date_format_enable( $date_format ) {

		if ( isset( $date_format ) && ! empty( $date_format ) ) {
			$date_format = $this->wps_common_fun->wps_uwgc_selected_date_format( $date_format );
		}
		return $date_format;
	}

	/**
	 * This function is used to add notification about expiry days after product purchase.
	 *
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 * @name wps_uwgc_gift_card_expiry_notice
	 */
	public function wps_uwgc_gift_card_expiry_notice() {

		global $post;
		$woo_ver = WC()->version;
		$product_id = $post->ID;
		$product_types = wp_get_object_terms( $product_id, 'product_type' );

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_uwgc_other_settings = get_option( 'wps_wgm_other_settings', array() );

		$wps_uwgc_hide_giftcard_exp_notice = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_hide_giftcard_notice' );

		if ( isset( $product_types[0] ) ) {
			$product_type = $product_types[0]->slug;

			if ( 'wgm_gift_card' == $product_type && 'on' !== $wps_uwgc_hide_giftcard_exp_notice ) {
				$args = array(
					'posts_per_page'   => -1,
					'orderby'          => 'title',
					'order'            => 'asc',
					'post_type'        => 'shop_coupon',
					'post_status'      => 'publish',
				);
				$args['meta_query'] = array(
					array(
						'key' => 'wps_wgm_imported_coupon',
						'value' => 'yes',
						'compare' => '==',
					),
				);
				$imported_coupons = get_posts( $args );
				$is_imported = get_post_meta( $product_id, 'is_imported', true );
				if ( isset( $is_imported ) && ! empty( $is_imported ) && 'yes' == $is_imported ) {
					$giftcard_expiry = get_post_meta( $product_id, 'expiry_after_days', true );
				} elseif ( ! empty( $imported_coupons ) ) {
					$imported_code = $imported_coupons[0]->post_title;
					$the_coupon = new WC_Coupon( $imported_code );
					if ( $woo_ver < '3.0.0' ) {
						$import_coupon_id = $the_coupon->id;
					} else {
						$import_coupon_id = $the_coupon->get_id();
					}
					$giftcard_expiry = get_post_meta( $import_coupon_id, 'wps_wgm_expiry_date', true );
				} else {
					$wps_uwgc_general_settings = get_option( 'wps_wgm_general_settings', array() );
										$local_expiry_day = get_post_meta( $product_id, 'wps_wgm_local_setting_giftcard_expiry', true );
					if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
						$giftcard_expiry = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
					} else {
						$giftcard_expiry = $local_expiry_day;
					}
					
				}
				if ( $giftcard_expiry > 0 ) {
					$days = $giftcard_expiry;
					?>
					<div class="wps_uwgc_expiry_notice clear">
						<h4><?php esc_html_e( 'Giftcard Notice', 'giftware' ); ?></h4>
						<?php /* translators: %s: search term */ ?>
						<p><?php echo esc_html( sprintf( __( 'This Gift Card will expire  %s days after purchase.', 'giftware' ), $days ) ); ?></p>
					</div>
					<?php

				} elseif ( 0 === $giftcard_expiry ) {
					$days = 'same';
					?>
					<div class="wps_uwgc_expiry_notice clear">
						<h4><?php esc_html_e( 'Giftcard Notice', 'giftware' ); ?></h4>
						<p>
						<?php
						/* translators: %s: search term */
						echo esc_html( sprintf( __( 'This Gift Card will expire %s days after purchase.', 'giftware' ), $days ) );
						?>
						</p>
					</div>
					<?php
				} else {
					?>
					<div class="wps_uwgc_expiry_notice clear">
						<h4><?php esc_html_e( 'Giftcard Notice', 'giftware' ); ?></h4>
						<p>
						<?php
						/* translators: %s: search term */
						echo esc_html( sprintf( __( 'The Gift Card has no expiration.', 'giftware' ) ) );
						?>
						</p>
					</div>
					<?php
				}
			}

			if ( 'wgm_gift_card' == $product_type ) {
				do_action( 'wps_uwgc_terms_and_condition' );
			}
		}
	}

	/**
	 * Settings for terms and condition.
	 *
	 * @name wps_uwgc_terms_and_condition_content.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_terms_and_condition_content() {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_uwgc_other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_wgm_hide_terms_and_condition = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_hide_terms_and_condition' );
		$wps_wgm_terms_condition_content = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_terms_condition_content' );
		if ( '' === $wps_wgm_terms_condition_content ) {
			$wps_wgm_terms_condition_content = __( 'Products Cannot be exchanged', 'giftware' );
		}
		if ( '' === $wps_wgm_hide_terms_and_condition ) {
			?>
			<div class="wps_gw_expiry_notice clear">
				<h4><?php esc_html_e( 'Terms And Conditions', 'giftware' ); ?></h4>
				<p><?php echo esc_html( $wps_wgm_terms_condition_content ); ?></p>
			</div>
			<?php
		}
	}

	/**
	 * Compatible with flatsome theme (wmini_cart).
	 *
	 * @name wps_uwgc_return_actual_price.
	 * @param mixed $price Contains price.
	 * @param array $cart_item Contains cart item .
	 * @param mixed $cart_item_key Contains cart item key.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_return_actual_price( $price, $cart_item, $cart_item_key ) {
		$product_type = $cart_item['data']->get_type();
		$test = get_option( 'woocommerce_prices_include_tax' );
		if ( 'wgm_gift_card' == $product_type ) {
			$woo_ver = WC()->version;
			if ( $woo_ver >= '4.4.0' ) {
				if ( 'excl' === WC()->cart->get_tax_price_display_mode() ) {
					return wc_price( ( $cart_item['line_subtotal'] ) / $cart_item['quantity'] );
				} else {
					return wc_price( ( $cart_item['line_subtotal'] + $cart_item['line_subtotal_tax'] ) / $cart_item['quantity'] );
				}
			} else {
				if ( 'excl' === WC()->cart->tax_display_cart ) {
					return wc_price( ( $cart_item['line_subtotal'] ) / $cart_item['quantity'] );
				} else {
					return wc_price( ( $cart_item['line_subtotal'] + $cart_item['line_subtotal_tax'] ) / $cart_item['quantity'] );
				}
			}
		} else {
			return $price;
		}
	}

	/**
	 * This function is used to send a Thankyou Gift Coupon to customers when the option is selected "Order Creation".
	 *
	 * @name wps_uwgc_thankyou_coupon_order_creation.
	 * @param mixed $order_id Contains order id.
	 * @param array $data Contains data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_thankyou_coupon_order_creation( $order_id, $data ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$order = wc_get_order( $order_id );
		$order_status  = $order->get_status();
		$wps_uwgc_thankyou_coupon_settings = get_option( 'wps_wgm_thankyou_order_settings', array() );
		$wps_wgm_thankyouorder_enable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_thankyou_coupon_settings, 'wps_wgm_thankyouorder_enable' );
		$wps_wgm_thankyouorder_time = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_thankyou_coupon_settings, 'wps_wgm_thankyouorder_time' );
		$thankyou_status = '';
		switch ( $wps_wgm_thankyouorder_time ) {
			case 'wps_wgm_order_processing':
				$thankyou_status = 'processing';
				break;
			case 'wps_wgm_order_completed':
				$thankyou_status = 'completed';
				break;
			default:
				$thankyou_status = 'other';
				break;
		}
		if ( isset( $wps_wgm_thankyouorder_enable ) && ! empty( $wps_wgm_thankyouorder_enable ) && 'on' == $wps_wgm_thankyouorder_enable ) {
			if ( $thankyou_status === $order_status || 'other' === $thankyou_status ) {
				$thanku_coupon = $this->wps_common_fun->wps_uwgc_thankyou_coupon_handle( $order_id, $data );
			}
		}
	}

	/**
	 * This is function is used for hiding quantity field for gift card type product.
	 *
	 * @name wps_uwgc_hide_quantity_fields.
	 * @param bool  $return Contains return value.
	 * @param mixed $product Contains product.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_hide_quantity_fields( $return, $product ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_uwgc_other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_uwgc_disable_quantity_field = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_other_settings, 'wps_wgm_additional_quantity_disable' );
		$product_id  = $product->get_id();
		$is_imported = get_post_meta( $product_id, 'is_imported', true );
		if ( ( $product->is_type( 'wgm_gift_card' ) && ( 'on' == $wps_uwgc_disable_quantity_field || 'yes' == $is_imported ) ) || get_option( 'gc_expiry_extension_product_id' ) == $product_id ) {
			return true;
		} else {
			return $return;
		}
	}

	/**
	 * This is function is used to Add meta Info on Email Tempalte.
	 *
	 * @name wps_uwgc_common_arr_data.
	 * @param array $wps_wgm_common_arr Instance of common class.
	 * @param array $item Array of items.
	 * @param array $order Order data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_common_arr_data( $wps_wgm_common_arr, $item, $order ) {
		$item_meta_data = $item->get_meta_data();
		if ( isset( $item_meta_data ) && ! empty( $item_meta_data ) && is_array( $item_meta_data ) ) {
			foreach ( $item_meta_data as $key => $value ) {
				if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
					$wps_wgm_common_arr['to_name'] = $value->value;
					$recipients_name = wps_wgm_hpos_get_meta_data( $order->get_id(), 'recipient_name', true );
					if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
						$wps_wgm_common_arr['to_name'] = trim( array_shift( $recipients_name ) );
						wps_wgm_hpos_update_meta_data( $order->get_id(), 'recipient_name', $recipients_name );
					} else {
						$recipients_name = preg_split( '/[,]+/', $wps_wgm_common_arr['to_name'], -1, PREG_SPLIT_NO_EMPTY );
						$wps_wgm_common_arr['to_name'] = trim( array_shift( $recipients_name ) );
						wps_wgm_hpos_update_meta_data( $order->get_id(), 'recipient_name', $recipients_name );
					}
				}
				if ( isset( $value->key ) && 'Image' == $value->key && ! empty( $value->value ) ) {
					$wps_wgm_common_arr['gift_img_name'] = $value->value;
				}
				if ( isset( $value->key ) && 'Reciever Contact' == $value->key && ! empty( $value->value ) ) {
					$wps_wgm_common_arr['contact_no'] = $value->value;
				}
				if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
					$wps_wgm_common_arr['send_date'] = $value->value;
				}
				if ( isset( $value->key ) && 'Send Time' == $value->key && ! empty( $value->value ) ) {
					$wps_wgm_common_arr['send_time'] = $value->value;
				}
			}
		}
		$wps_wgm_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_wgm_common_arr, $item, $order );
		return $wps_wgm_common_arr;
	}

	/**
	 * This is function is used to Locate The Custmizable Giftcard template.
	 *
	 * @name wps_uwgc_locate_custmizable_gift_template.
	 * @param string $template template of giftcard.
	 * @param string $template_name Template name of giftcard.
	 * @param string $template_path Contains template path.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_locate_custmizable_gift_template( $template, $template_name, $template_path ) {
		$template = $this->wps_custmizable_obj->wps_uwgc_create_custmizable_gift_template( $template, $template_name, $template_path );

		return $template;

	}
	/**
	 * This is function is used to Include The Custmizable Giftcard template.
	 *
	 * @name wps_uwgc_include_custmizable_template.
	 * @param string $template Contains template data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_include_custmizable_template( $template ) {
		$template = $this->wps_custmizable_obj->wps_uwgc_include_custmizable_gift_template( $template );
		return $template;
	}

	/**
	 * This is function is used to Add Delivery Method for Custmizable Giftcard.
	 *
	 * @name wps_uwgc_add_custmizable_giftcard_delivery_methods.
	 * @param string $product_id Conatins product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_add_custmizable_giftcard_delivery_methods( $product_id ) {
		$this->wps_custmizable_obj->wps_uwgc_custmizable_giftcard_delivery_methods_html( $product_id );
	}

	/**
	 * This is function is used to Add Custom div for Custmizable Giftcard.
	 *
	 * @name wps_uwgc_custmizable_before_main_content.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_custmizable_before_main_content() {
		$this->wps_custmizable_obj->wps_uwgc_custmizable_before_main_content_html();
	}

	/**
	 * This is function is used to Add Email Template for  Custmizable Giftcard.
	 *
	 * @name wps_uwgc_customizable_email_template.
	 * @param array $return Contains data to return.
	 * @param array $args Contain arguments.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_customizable_email_template( $return, $args ) {
		if ( isset( $args['product_id'] ) && ! empty( $args['product_id'] ) ) {
			$product_id = $args['product_id'];
			$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_giftware', true );
			if ( isset( $is_customizable ) && ! empty( $is_customizable ) && 'yes' == $is_customizable ) {
				$message = $this->wps_custmizable_obj->wps_uwgc_customized_giftcard_email_template( $args );
				return $message;
			}
		}
		return $return;
	}

	/**
	 * This is function is used to Upload custom Image for Custmizable Giftcard On Ajax Call.
	 *
	 * @name wps_cgc_upload_own_img
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_cgc_upload_own_img() {
		$this->wps_custmizable_obj->wps_cgc_custmizable_upload_own_img();
	}

	/**
	 * This is function is used to Upload Image for Custmizable Giftcard On Ajax Call.
	 *
	 * @name wps_cgc_admin_uploads_name
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_cgc_admin_uploads_name() {
		$this->wps_custmizable_obj->wps_cgc_custmizable_admin_uploads_name();
	}

	/**
	 * This is function is used to Add Item Meta for Custmizable Giftcard.
	 *
	 * @name wps_cgc_add_item_meta_data
	 * @param array $item_meta Contains item meta.
	 * @param int   $product_id Contains product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_cgc_add_item_meta_data( $item_meta, $product_id ) {
		$item_meta = $this->wps_custmizable_obj->wps_cgc_custmizable_item_meta_data( $item_meta, $product_id );
		return $item_meta;
	}

	/**
	 * This is function is used to Add meta Info on Email Template for Custmizable Giftcard.
	 *
	 * @name wps_cgc_custmizable_common_arr
	 * @param object $wps_cgc_common_arr Contains instance.
	 * @param array  $item Contains item.
	 * @param array  $order Contains order.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_cgc_custmizable_common_arr( $wps_cgc_common_arr, $item, $order ) {
		$wps_cgc_common_arr = $this->wps_custmizable_obj->wps_cgc_custmizable_gift_common_arr( $wps_cgc_common_arr, $item, $order );
		return $wps_cgc_common_arr;
	}

	/**
	 * This is function is used to Add meta Info Resend Mail for Custmizable Giftcard.
	 *
	 * @name wps_cgc_resend_mail_arr_update
	 * @param string $args Contains argument.
	 * @param array  $item Contains item.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_cgc_resend_mail_arr_update( $args, $item ) {
		$args = $this->wps_custmizable_obj->wps_cgc_custmizable_resend_mail_arr_update( $args, $item );
		return $args;
	}

	/**
	 * This is function is used to Add meta data on order status change hooks.
	 *
	 * @name wps_uwgc_mail_templates_settings
	 * @param array $settings_data Contains setting data.
	 * @param array $items Contains item data.
	 * @param int   $order_id Contains order id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_mail_templates_settings( $settings_data, $items, $order_id ) {

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_uwgc_saved_data = get_option( 'wps_wgm_general_settings', array() );

		$selected_date = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_saved_data, 'wps_wgm_general_setting_enable_selected_format' );
		$giftcard_pdf_prefix = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_saved_data, 'wps_wgm_general_setting_pdf_prefix' );

		wps_wgm_hpos_update_meta_data( $order_id, 'wps_wgm_pdf_name_prefix', $giftcard_pdf_prefix );

		$mailsend = $settings_data['mail_send'];
		$gift_date_check = false;
		$order = wc_get_order( $order_id );

		if ( is_array( $items ) && ! empty( $items ) ) {
			foreach ( $items as $item_id => $item ) {
				// Handle extra coupon generation issue.
				$product = $item->get_product();
				$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );

				if ( ! $product->is_type( 'wgm_gift_card' ) && 'on' != $wps_gift_product ) {
					continue;
				}
				// Handle scheduling coupon issue.
				if ( $item_id != $settings_data['item_id'] ) {
					continue;
				}
				$item_meta_data = $item->get_meta_data();

				if ( is_array( $item_meta_data ) && ! empty( $item_meta_data ) ) {
					foreach ( $item_meta_data as $key => $value ) {
						if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$to_name = $value->value;
							$settings_data['to_name'] = $to_name;
						}
						if ( isset( $value->key ) && 'Image' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$gift_img_name = $value->value;
							$settings_data['gift_img_name'] = $gift_img_name;
						}
						if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
							$gift_date_check = true;
							$gift_date = $value->value;
							$settings_data['gift_date'] = $gift_date;
						}
						if ( isset( $value->key ) && 'Send Time' == $value->key && ! empty( $value->value ) ) {
							$gift_date_check = true;
							$gift_time = $value->value;
							$settings_data['gift_time'] = $gift_time;
						}
						if ( isset( $value->key ) && 'Reciever Contact' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$settings_data['contact_no'] = $value->value;
						}
					}

					if ( ! isset( $settings_data['to'] ) && empty( $settings_data['to'] ) ) {

						if ( isset( $settings_data['delivery_method'] ) && 'Mail to recipient' == $settings_data['delivery_method'] ) {
							$to = $order->get_billing_email();
						} else {
							$to = '';
						}

						$settings_data['to'] = $to;
					}
					if ( $gift_date_check ) {
						$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
						if ( 'send' == $itemgiftsend ) {
							$settings_data['mail_send'] = false;
							continue;
						}
						$mailsend = true;
						if ( is_string( $gift_date ) ) {
							if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
								if ( 'd/m/Y' == $selected_date ) {
									$gift_date = str_replace( '/', '-', $gift_date );
								}
							}
							$senddatetime = strtotime( $gift_date );
						}
						$senddate = date_i18n( 'Y-m-d', $senddatetime );
						
						if ( isset( $gift_time ) && 'now' === $gift_time ) {
							$todaytime = time();
							$todaydate = date_i18n( 'Y-m-d', $todaytime );
							$senddatetime = strtotime( "$senddate" );
							
						} elseif ( is_string( $gift_time ) ) {
							$time_in_sec = substr($gift_time, 0, -3) * 3600;
							$senddatetime = strtotime( "$senddate" ) + $time_in_sec;
							$today_cyp_time = time() + ( (float) get_option( 'gmt_offset' ) * 60 * 60);
							$todaydate = date_i18n( "Y-m-d H:i:s", $today_cyp_time );
							
						} else {
							$todaytime = time();
							$todaydate = date_i18n( 'Y-m-d', $todaytime );
							$senddatetime = strtotime( "$senddate" );
						}
						
						$todaytime = strtotime( "$todaydate" );
						$giftdiff = $senddatetime - $todaytime;

						if ( isset( $settings_data['delivery_method'] ) && 'Mail to recipient' == $settings_data['delivery_method'] ) {
							if ( $giftdiff > 0 ) {
								$datecheck = false;
								$settings_data['datecheck'] = $datecheck;
								wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'notsend' );
								continue;
							} else {
								wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'send' );
								$note = __( 'Gift Card Email has been sent.', 'giftware' );
								$order->add_order_note( $note );
								continue;
							}
						} else {
							wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'send' );
							$note = __( 'Gift Card Email has been sent.', 'giftware' );
							$order->add_order_note( $note );
						}
					} else {
						wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#giftcard_send", 'send' );
						$note = __( 'Gift Card Email has been sent.', 'giftware' );
						$order->add_order_note( $note );
					}

					$settings_data['mail_send'] = $mailsend;
					// Handle extra coupon generation issue.
					if ( isset( $settings_data['product_id'] ) && ! empty( $settings_data['product_id'] ) ) {
						$product = wc_get_product( $settings_data['product_id'] );
						$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
						if ( ! $product->is_type( 'wgm_gift_card' ) && 'on' != $wps_gift_product ) {
							$settings_data['mail_send'] = false;
						}
					}
				}
				$settings_data = apply_filters( 'wps_wgm_add_additional_meta_data', $settings_data, $item_meta_data, $order_id );
			}
		}
		return $settings_data;
	}

	/**
	 * This is function is used to create imported giftcard coupon on order status change.
	 *
	 * @name wps_uwgc_check_coupon_creation.
	 * @param array  $wps_uwgc_temp_arr Contains template array.
	 * @param string $order_id Contain order id.
	 * @param array  $item Contain item data.
	 * @param string $validaity Validaity of coupon.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_check_coupon_creation( $wps_uwgc_temp_arr, $order_id, $item, $validaity ) {

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();

		if ( isset( $order_id ) ) {
			$order = wc_get_order( $order_id );
			if ( isset( $order ) ) {
				$wps_uwgc_general_settings = get_option( 'wps_wgm_general_settings', array() );
				$giftcard_coupon_length = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );
				$giftcard_coupon_length = ( '' !== $giftcard_coupon_length ) ? $giftcard_coupon_length : 5;

				$pro_id = isset( $wps_uwgc_temp_arr['product_id'] ) ? $wps_uwgc_temp_arr['product_id'] : '';
				$args = array(
					'posts_per_page'   => -1,
					'orderby'          => 'title',
					'order'            => 'asc',
					'post_type'        => 'shop_coupon',
					'post_status'      => 'publish',
				);

				// First query: search for coupons associated with product ID.
				$args['meta_query'] = array(
					'relation' => 'AND',
					array(
						'key'     => 'wps_wgm_imported_coupon',
						'value'   => 'yes',
						'compare' => '==',
					),
					array(
						'key'     => 'wps_wgm_coupon_product_id',
						'value'   => $pro_id,
						'compare' => '==',
					),
				);
				$imported_coupons = get_posts( $args );

				// If no imported coupons found for product ID, search for global coupons.
				if ( empty( $imported_coupons ) ) {
					$args['meta_query'] = array(
						'relation' => 'AND',
						array(
							'key'     => 'wps_wgm_imported_coupon',
							'value'   => 'yes',
							'compare' => '==',
						),
						array(
							'key'     => 'wps_wgm_coupon_product_id',
            				'compare' => 'NOT EXISTS',
						),
					);
					$imported_coupons = get_posts( $args );
				}

				$wps_uwgc_common_arr = array();

				if ( isset( $pro_id ) && '' !== $pro_id ) {
					$is_imported_product = get_post_meta( $pro_id, 'is_imported', true );
				} else {
					$is_imported_product = '';
				}
				$inc_tax_status = get_option( 'woocommerce_prices_include_tax', false );
				if ( 'yes' == $inc_tax_status ) {
					$inc_tax_status = true;
				} else {
					$inc_tax_status = false;
				}
				$couponamont = isset( $wps_uwgc_temp_arr['original_price'] ) ? $wps_uwgc_temp_arr['original_price'] : '';

				if ( ! empty( $wps_uwgc_temp_arr['to'] && ( 'Mail to recipient' == $wps_uwgc_temp_arr['delivery_method'] ) ) ) {
					$recipients = preg_split( '/[\s,]+/', $wps_uwgc_temp_arr['to'], -1, PREG_SPLIT_NO_EMPTY );
				}
				if ( ! empty( $wps_uwgc_temp_arr['to_name'] ) ) {
					$recipients_name = preg_split( '/[,]+/', $wps_uwgc_temp_arr['to_name'], -1, PREG_SPLIT_NO_EMPTY );
				}

				if ( isset( $is_imported_product ) && ! empty( $is_imported_product ) && 'yes' == $is_imported_product ) {
					if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
						$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
						if ( isset( $pro_price ) && is_array( $pro_price ) ) {
							$couponamont = $pro_price['default_price'];
						}
					} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
						$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
						if ( isset( $pro_price ) && is_array( $pro_price ) ) {
							$couponamont = $pro_price['default_price'];
						}
					} else {
						$couponamont = $order->get_line_subtotal( $item, $inc_tax_status );
					}
					$gift_couponnumber = get_post_meta( $pro_id, 'coupon_code', true );
					if ( empty( $gift_couponnumber ) && ! isset( $gift_couponnumber ) ) {
						$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );

					}
					if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $wps_uwgc_temp_arr['to'] ) ) {
						$expiry_date = get_post_meta( $pro_id, 'expiry_after_days', true );
						$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
						$wps_uwgc_common_arr['order_id'] = $order_id;
						$wps_uwgc_common_arr['product_id'] = $pro_id;
						$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
						$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
						$wps_uwgc_common_arr['couponamont'] = $couponamont;

						$wps_uwgc_common_arr['to'] = isset( $wps_uwgc_temp_arr['to'] ) ? $wps_uwgc_temp_arr['to'] : '';
						$wps_uwgc_common_arr['from'] = isset( $wps_uwgc_temp_arr['from'] ) ? $wps_uwgc_temp_arr['from'] : '';
						$wps_uwgc_common_arr['to_name'] = isset( $wps_uwgc_temp_arr['to_name'] ) ? $wps_uwgc_temp_arr['to_name'] : '';
						$wps_uwgc_common_arr['gift_msg'] = isset( $wps_uwgc_temp_arr['gift_msg'] ) ? $wps_uwgc_temp_arr['gift_msg'] : '';
						$wps_uwgc_common_arr['selected_template'] = isset( $wps_uwgc_temp_arr['selected_template'] ) ? $wps_uwgc_temp_arr['selected_template'] : '';
						$wps_uwgc_common_arr['delivery_method'] = isset( $wps_uwgc_temp_arr['delivery_method'] ) ? $wps_uwgc_temp_arr['delivery_method'] : '';
						$wps_uwgc_common_arr['gift_img_name'] = isset( $wps_uwgc_temp_arr['gift_img_name'] ) ? $wps_uwgc_temp_arr['gift_img_name'] : '';
						$wps_uwgc_common_arr['item_id'] = isset( $wps_uwgc_temp_arr['item_id'] ) ? $wps_uwgc_temp_arr['item_id'] : '';
						$wps_uwgc_common_arr['send_date'] = isset( $wps_uwgc_temp_arr['gift_date'] ) ? $wps_uwgc_temp_arr['gift_date'] : '';

						$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

						if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
							update_post_meta( $pro_id, '_stock_status', 'outofstock' );
						}
					}
					$validaity = false;
				} elseif ( ! empty( $imported_coupons ) ) {

					$item_quantity = isset( $wps_uwgc_temp_arr['item_quantity'] ) ? $wps_uwgc_temp_arr['item_quantity'] : '';
					$woo_ver = WC()->version;

					if ( isset( $item_quantity ) && '' !== $item_quantity ) {
						for ( $i = 0; $i < $item_quantity; $i++ ) {
							if ( isset( $recipients ) && ! empty( $recipients ) ) {
								$wps_uwgc_temp_arr['to'] = trim( array_shift( $recipients ) );
							}
							if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
								$wps_uwgc_temp_arr['to_name'] = trim( array_shift( $recipients_name ) );
							}
							$imported_code = isset( $imported_coupons[ $i ] ) ? $imported_coupons[ $i ]->post_title : '';
							if ( isset( $imported_code ) && ! empty( $imported_code ) ) {
								$the_coupon = new WC_Coupon( $imported_code );
								if ( $woo_ver < '3.0.0' ) {
									$import_coupon_id = $the_coupon->id;
								} else {
									$import_coupon_id = $the_coupon->get_id();
								}
								$expiry_date = get_post_meta( $import_coupon_id, 'wps_wgm_expiry_date', true );

								$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );

								$wps_uwgc_common_arr['order_id'] = $order_id;
								$wps_uwgc_common_arr['product_id'] = $pro_id;
								$wps_uwgc_common_arr['gift_couponnumber'] = $imported_code;
								$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
								$wps_uwgc_common_arr['couponamont'] = $couponamont;

								$wps_uwgc_common_arr['to'] = isset( $wps_uwgc_temp_arr['to'] ) ? $wps_uwgc_temp_arr['to'] : '';
								$wps_uwgc_common_arr['from'] = isset( $wps_uwgc_temp_arr['from'] ) ? $wps_uwgc_temp_arr['from'] : '';
								$wps_uwgc_common_arr['to_name'] = isset( $wps_uwgc_temp_arr['to_name'] ) ? $wps_uwgc_temp_arr['to_name'] : '';
								$wps_uwgc_common_arr['gift_msg'] = isset( $wps_uwgc_temp_arr['gift_msg'] ) ? $wps_uwgc_temp_arr['gift_msg'] : '';
								$wps_uwgc_common_arr['selected_template'] = isset( $wps_uwgc_temp_arr['selected_template'] ) ? $wps_uwgc_temp_arr['selected_template'] : '';
								$wps_uwgc_common_arr['delivery_method'] = isset( $wps_uwgc_temp_arr['delivery_method'] ) ? $wps_uwgc_temp_arr['delivery_method'] : '';
								$wps_uwgc_common_arr['gift_img_name'] = isset( $wps_uwgc_temp_arr['gift_img_name'] ) ? $wps_uwgc_temp_arr['gift_img_name'] : '';
								$wps_uwgc_common_arr['item_id'] = isset( $wps_uwgc_temp_arr['item_id'] ) ? $wps_uwgc_temp_arr['item_id'] : '';
								$wps_uwgc_common_arr['send_date'] = isset( $wps_uwgc_temp_arr['gift_date'] ) ? $wps_uwgc_temp_arr['gift_date'] : '';

								$products_settings = get_option( 'wps_wgm_product_settings', array() );

								$exclude_sale_items = $wps_public_obj->wps_wgm_get_template_data( $products_settings, 'wps_wgm_product_setting_giftcard_ex_sale' );

								$exclude_sale_items = ( 'on' == $exclude_sale_items ) ? 'yes' : 'no';

								$exclude_products = $wps_public_obj->wps_wgm_get_template_data( $products_settings, 'wps_wgm_product_setting_exclude_product' );
								$exclude_products = ( is_array( $exclude_products ) && ! empty( $exclude_products ) ) ? implode( ',', $exclude_products ) : '';
								$exclude_category = $wps_public_obj->wps_wgm_get_template_data( $products_settings, 'wps_wgm_product_setting_exclude_category' );
								if ( ! isset( $exclude_category ) || empty( $exclude_category ) ) {
									$exclude_category = ' ';
								}
								$include_products = $wps_public_obj->wps_wgm_get_template_data( $products_settings, 'wps_wgm_product_setting_include_product' );
								$include_products = ( is_array( $include_products ) && ! empty( $include_products ) ) ? implode( ',', $include_products ) : '';

								$include_category = $wps_public_obj->wps_wgm_get_template_data( $products_settings, 'wps_wgm_product_setting_include_category' );

								$day_excluded = $wps_public_obj->wps_wgm_get_template_data( $products_settings, 'wps_wgm_excluded_days' );

								$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

								if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
									update_post_meta( $import_coupon_id, 'product_ids', $include_products );
									update_post_meta( $import_coupon_id, 'product_categories', $include_category );
									update_post_meta( $import_coupon_id, 'exclude_product_categories', $exclude_category );
									update_post_meta( $import_coupon_id, 'exclude_product_ids', $exclude_products );
									update_post_meta( $import_coupon_id, 'exclude_sale_items', $exclude_sale_items );
									update_post_meta( $import_coupon_id, 'coupon_amount', $couponamont );
									update_post_meta( $import_coupon_id, 'wps_wgm_coupon_amount', $couponamont );
									update_post_meta( $import_coupon_id, 'wps_wgm_imported_coupon', 'purchased' );
									update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon', $order_id );
									update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_unique', 'online' );
									update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_product_id', $pro_id );
									update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_mail_to', $wps_uwgc_temp_arr['to'] );
									update_post_meta( $import_coupon_id, 'wps_wgm_excluded_days', $day_excluded );
									// for price based on country.
									if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
										update_post_meta( $import_coupon_id, 'zone_pricing_type', 'exchange_rate' );
									}

									$woo_ver = WC()->version;
									
									if ( $woo_ver < '3.6.0' ) {
										update_post_meta( $import_coupon_id, 'expiry_date', $expirydate_format );
									} else {
										$general_settings = get_option( 'wps_wgm_general_settings', array() );
										$selected_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
										if ( isset( $selected_date ) && null != $selected_date && '' != $selected_date ) {
											if ( 'd/m/Y' == $selected_date ) {
												$expirydate_format = str_replace( '/', '-', $expirydate_format );
											}
										}

										$expirydate_format = strtotime( $expirydate_format );

										update_post_meta( $import_coupon_id, 'date_expires', $expirydate_format );
									}
								}
							} elseif ( empty( $imported_code ) ) {
								$wps_uwgc_common_arr = array();
								$random_code = wps_wgm_coupon_generator( $giftcard_coupon_length );

																$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
								if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
									$expiry_date = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
								} else {
									$expiry_date = $local_expiry_day;
								}

								if ( $wps_public_obj->wps_wgm_create_gift_coupon( $random_code, $couponamont, $order_id, $item['product_id'], $wps_uwgc_temp_arr['to'] ) ) {

									$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
									$wps_uwgc_common_arr['order_id'] = $order_id;
									$wps_uwgc_common_arr['product_id'] = $pro_id;
									$wps_uwgc_common_arr['gift_couponnumber'] = $random_code;
									$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
									$wps_uwgc_common_arr['couponamont'] = $couponamont;

									$wps_uwgc_common_arr['to'] = isset( $wps_uwgc_temp_arr['to'] ) ? $wps_uwgc_temp_arr['to'] : '';
									$wps_uwgc_common_arr['from'] = isset( $wps_uwgc_temp_arr['from'] ) ? $wps_uwgc_temp_arr['from'] : '';
									$wps_uwgc_common_arr['to_name'] = isset( $wps_uwgc_temp_arr['to_name'] ) ? $wps_uwgc_temp_arr['to_name'] : '';
									$wps_uwgc_common_arr['gift_msg'] = isset( $wps_uwgc_temp_arr['gift_msg'] ) ? $wps_uwgc_temp_arr['gift_msg'] : '';
									$wps_uwgc_common_arr['selected_template'] = isset( $wps_uwgc_temp_arr['selected_template'] ) ? $wps_uwgc_temp_arr['selected_template'] : '';
									$wps_uwgc_common_arr['delivery_method'] = isset( $wps_uwgc_temp_arr['delivery_method'] ) ? $wps_uwgc_temp_arr['delivery_method'] : '';
									$wps_uwgc_common_arr['gift_img_name'] = isset( $wps_uwgc_temp_arr['gift_img_name'] ) ? $wps_uwgc_temp_arr['gift_img_name'] : '';
									$wps_uwgc_common_arr['item_id'] = isset( $wps_uwgc_temp_arr['item_id'] ) ? $wps_uwgc_temp_arr['item_id'] : '';
									$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );
									if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
									}
								}
							}
						}
					}
					$validaity = false;
				}
			}
		}
		return $validaity;
	}

	/**
	 * Cron for set giftcard on specific date.
	 *
	 * @name wps_uwgc_do_this_hourly.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_do_this_hourly() {

		$woo_ver = WC()->version;
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$giftcard_pdf_prefix = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_pdf_prefix' );
		$giftcard_selected_date  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_date' );

		$selected_date  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );

		$discount_settings = get_option( 'wps_wgm_discount_settings', array() );
		$discount_enable  = $wps_public_obj->wps_wgm_get_template_data( $discount_settings, 'wps_wgm_discount_enable' );
		if ( 'on' == $giftcard_selected_date ) {
			// Fetch all giftcard order which need to be send on specific date.
			$order_statuses = array(
				'wc-processing' => __( 'Processing', 'giftware' ),
				'wc-completed'  => __( 'Completed', 'giftware' ),
			);

			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				// HPOS Enabled.
				$shop_orders = wc_get_orders(
					array(
						'limit'       => -1,
						'type'        => wc_get_order_types(),
						'status'      => array_keys( $order_statuses ),
						'meta_query'  => array(
							'relation' => 'OR',
							array(
								'key'   => 'wps_gw_order_giftcard',
								'value' => 'notsend',
							),
							array(
								'key'   => 'wps_wgm_order_giftcard',
								'value' => 'notsend',
							),
						),
					)
				);
			} else {
				$shop_orders = get_posts(
					array(
						'numberposts' => -1,
						'post_type'   => wc_get_order_types(),
						'post_status' => array_keys( $order_statuses ),
						'meta_query'  => array(
							'relation' => 'OR',
							array(
								'key'   => 'wps_gw_order_giftcard',
								'value' => 'notsend',
							),
							array(
								'key'   => 'wps_wgm_order_giftcard',
								'value' => 'notsend',
							),
						),
					)
				);
			}

			if ( isset( $shop_orders ) && ! empty( $shop_orders ) ) {
				foreach ( $shop_orders as $shop_order ) {
					if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
						$order_id = $shop_order->get_id();
					} else {
						$order_id = $shop_order->ID;
					}
					$gift_msg = '';
					$original_price = 0;
					$to = '';
					$from = '';
					$gift_order = false;
					$order = wc_get_order( $order_id );
					$datecheck = true;
					$contact_no = '';
					$variable_price_description = '';
					foreach ( $order->get_items() as $item_id => $item ) {
						$mailsend = false;
						$gift_img_name = '';
						$item_quantity = wc_get_order_item_meta( $item_id, '_qty', true );
						$product = $item->get_product();
						$pro_id = '';
						if ( ! empty( $product ) ) {
							$pro_id = $product->get_id();
						}
						$item_meta_data = $item->get_meta_data();
						$gift_date_check = false;
						$gift_date = '';
						foreach ( $item_meta_data as $key => $value ) {
							if ( isset( $value->key ) && 'To' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$to = $value->value;
							}
							if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$to_name = $value->value;
							}
							if ( isset( $value->key ) && 'From' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$from = $value->value;
							}
							if ( isset( $value->key ) && 'Message' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$gift_msg = $value->value;
							}
							if ( isset( $value->key ) && 'Image' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$gift_img_name = $value->value;
							}
							if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
								$gift_date_check = true;
								$gift_date = $value->value;
							}
							if ( isset( $value->key ) && 'Send Time' == $value->key && ! empty( $value->value ) ) {
								$gift_date_check = true;
								$gift_time = $value->value;
							}
							if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$delivery_method = $value->value;
							}
							if ( isset( $value->key ) && 'Original Price' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$original_price = $value->value;
							}
							if ( isset( $value->key ) && 'Selected Template' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$selected_template = $value->value;
							}
							if ( isset( $value->key ) && 'Reciever Contact' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$contact_no = $value->value;
							}
							if ( isset( $value->key ) && 'Variable Price Description' == $value->key && ! empty( $value->value ) ) {
								$mailsend = true;
								$variable_price_description = $value->value;
							}
						}
						if ( ! empty( $to ) && ( 'Mail to recipient' == $delivery_method ) ) {
							$recipients = preg_split( '/[\s,]+/', $to, -1, PREG_SPLIT_NO_EMPTY );
						}
						if ( ! empty( $to_name ) ) {
							$recipients_name = preg_split( '/[,]+/', $to_name, -1, PREG_SPLIT_NO_EMPTY );
						}
						if ( ! isset( $to ) && empty( $to ) ) {
							if ( 'Mail to recipient' == $delivery_method ) {
								$to = $order->get_billing_email();
							} else {
								$to = '';
							}
						}
						if ( $gift_date_check ) {
							$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
							if ( 'send' == $itemgiftsend ) {
								continue;
							}

							$mailsend = true;
							if ( is_string( $gift_date ) ) {
								if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
									if ( 'd/m/Y' == $selected_date ) {
										$gift_date = str_replace( '/', '-', $gift_date );
									}
								}
								$senddatetime = strtotime( $gift_date );
							}
							$senddate = date_i18n( 'Y-m-d', $senddatetime );
							
							if ( isset( $gift_time ) && 'now' === $gift_time ) {
								$todaytime = time();
								$todaydate = date_i18n( 'Y-m-d', $todaytime );
								$senddatetime = strtotime( "$senddate" );
								
							} elseif ( is_string( $gift_time ) ) {
								$time_in_sec = substr($gift_time, 0, -3) * 3600;
								$senddatetime = strtotime( "$senddate" ) + $time_in_sec;
								$today_cyp_time = time() + ( (float) get_option( 'gmt_offset' ) * 60 * 60);
								$todaydate = date_i18n( "Y-m-d H:i:s", $today_cyp_time );
								
							} else {
								$todaytime = time();
								$todaydate = date_i18n( 'Y-m-d', $todaytime );
								$senddatetime = strtotime( "$senddate" );
							}
					
							$todaytime = strtotime( "$todaydate" );

							$giftdiff = $senddatetime - $todaytime;

							if ( 'Mail to recipient' == $delivery_method ) {
								if ( $giftdiff > 0 ) {
									$datecheck = false;
									wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'notsend' );
									continue;
								} else {
									wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'send' );
									$note = __( 'Gift Card Email has been sent.', 'giftware' );
									$order->add_order_note( $note );
								}
							} else {
								wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'send' );
								$note = __( 'Gift Card Email has been sent.', 'giftware' );
								$order->add_order_note( $note );
							}
						} else {
							wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#giftcard_send", 'send' );
							$note = __( 'Gift Card Email has been sent.', 'giftware' );
							$order->add_order_note( $note );
						}
						if ( $mailsend ) {

							$gift_order = true;
							// gift total.
							$inc_tax_status = get_option( 'woocommerce_prices_include_tax', false );
							if ( 'yes' == $inc_tax_status ) {
								$inc_tax_status = true;
							} else {
								$inc_tax_status = false;
							}
							$wps_wgm_discount = get_post_meta( $item['product_id'], 'wps_wgm_discount', false );
							$couponamont = $original_price;
							$group_couponamont = wps_wgm_hpos_get_meta_data( $order_id, 'suborder#amttotal', true );
							if ( isset( $group_couponamont ) && ! empty( $group_couponamont ) ) {
								$couponamont = $group_couponamont;
							}
							$args = array(
								'posts_per_page'   => -1,
								'orderby'          => 'title',
								'order'            => 'asc',
								'post_type'        => 'shop_coupon',
								'post_status'      => 'publish',
							);

							// First query: search for coupons associated with product ID.
							$args['meta_query'] = array(
								'relation' => 'AND',
								array(
									'key'     => 'wps_wgm_imported_coupon',
									'value'   => 'yes',
									'compare' => '==',
								),
								array(
									'key'     => 'wps_wgm_coupon_product_id',
									'value'   => $pro_id,
									'compare' => '==',
								),
							);
							$imported_coupons = get_posts( $args );

							// If no imported coupons found for product ID, search for global coupons.
							if ( empty( $imported_coupons ) ) {
								$args['meta_query'] = array(
									'relation' => 'AND',
									array(
										'key'     => 'wps_wgm_imported_coupon',
										'value'   => 'yes',
										'compare' => '==',
									),
									array(
										'key'     => 'wps_wgm_coupon_product_id',
										'compare' => 'NOT EXISTS',
									),
								);
								$imported_coupons = get_posts( $args );
							}
							$wps_uwgc_common_arr = array();
							$is_imported_product = get_post_meta( $pro_id, 'is_imported', true );
							$wps_wgm_pricing = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
							$templateid = isset( $wps_wgm_pricing['template'] ) ? $wps_wgm_pricing['template'] : '';
							if ( is_array( $templateid ) && ! empty( $templateid[0] ) ) {
								$temp = $templateid[0];
							} else {
								$temp = $templateid;
							}
							if ( isset( $is_imported_product ) && ! empty( $is_imported_product ) && 'yes' == $is_imported_product ) {
								if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
									$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
									if ( isset( $pro_price ) && is_array( $pro_price ) ) {
										$couponamont = $pro_price['default_price'];
									}
								} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
									$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
									if ( isset( $pro_price ) && is_array( $pro_price ) ) {
										$couponamont = $pro_price['default_price'];
									}
								} else {
									$couponamont = $order->get_line_subtotal( $item, $inc_tax_status );
								}
								$gift_couponnumber = get_post_meta( $pro_id, 'coupon_code', true );
								if ( empty( $gift_couponnumber ) && ! isset( $gift_couponnumber ) ) {
									$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );

								}
								if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $to ) ) {
									$todaydate = date_i18n( 'Y-m-d' );
									$expiry_date = get_post_meta( $pro_id, 'expiry_after_days', true );
									$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
									$wps_uwgc_common_arr['order_id'] = $order_id;
									$wps_uwgc_common_arr['product_id'] = $pro_id;
									$wps_uwgc_common_arr['to'] = $to;
									$wps_uwgc_common_arr['from'] = $from;
									$wps_uwgc_common_arr['to_name'] = $to_name;
									$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
									$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
									$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
									$wps_uwgc_common_arr['selected_template'] = ! empty( $selected_template ) ? $selected_template : $temp;
									$wps_uwgc_common_arr['couponamont'] = $couponamont;
									$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
									$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
									$wps_uwgc_common_arr['item_id'] = $item_id;
									$wps_uwgc_common_arr['contact_no'] = $contact_no;
									$wps_uwgc_common_arr['send_date'] = $gift_date;
									$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;

									$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

									if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
										update_post_meta( $pro_id, '_stock_status', 'outofstock' );
									}
								}
							} elseif ( ! empty( $imported_coupons ) ) {
								for ( $i = 0; $i < $item_quantity; $i++ ) {
									if ( isset( $recipients ) && ! empty( $recipients ) ) {
										$to = trim( array_shift( $recipients ) );
									}
									if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
										$to_name = trim( array_shift( $recipients_name ) );
									}
									$imported_code = $imported_coupons[ $i ]->post_title;
									if ( isset( $imported_code ) && ! empty( $imported_code ) ) {
										$the_coupon = new WC_Coupon( $imported_code );
										if ( $woo_ver < '3.0.0' ) {
											$import_coupon_id = $the_coupon->id;
										} else {
											$import_coupon_id = $the_coupon->get_id();
										}
										$expiry_date = get_post_meta( $import_coupon_id, 'wps_wgm_expiry_date', true );
										$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
										$wps_uwgc_common_arr['order_id'] = $order_id;
										$wps_uwgc_common_arr['product_id'] = $pro_id;
										$wps_uwgc_common_arr['to'] = $to;
										$wps_uwgc_common_arr['from'] = $from;
										$wps_uwgc_common_arr['to_name'] = $to_name;
										$wps_uwgc_common_arr['gift_couponnumber'] = $imported_code;
										$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
										$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
										$wps_uwgc_common_arr['selected_template'] = $selected_template;
										$wps_uwgc_common_arr['couponamont'] = $couponamont;
										$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
										$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
										$wps_uwgc_common_arr['item_id'] = $item_id;
										$wps_uwgc_common_arr['contact_no'] = $contact_no;
										$wps_uwgc_common_arr['send_date'] = $gift_date;
										$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
										$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

										if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
											update_post_meta( $import_coupon_id, 'coupon_amount', $couponamont );
											update_post_meta( $import_coupon_id, 'wps_wgm_coupon_amount', $couponamont );
											update_post_meta( $import_coupon_id, 'wps_wgm_imported_coupon', 'purchased' );
											update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon', $order_id );
											update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_unique', 'online' );
											update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_product_id', $pro_id );
											update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_mail_to', $to );

											$woo_ver = WC()->version;

											
											if ( $woo_ver < '3.6.0' ) {
												update_post_meta( $import_coupon_id, 'expiry_date', $expirydate_format );
											} else {
												$general_settings = get_option( 'wps_wgm_general_settings', array() );
												$selected_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
												if ( isset( $selected_date ) && null != $selected_date && '' != $selected_date ) {
													if ( 'd/m/Y' == $selected_date ) {
														$expirydate_format = str_replace( '/', '-', $expirydate_format );
													}
												}
												$expirydate_format = strtotime( $expirydate_format );
												update_post_meta( $import_coupon_id, 'date_expires', $expirydate_format );
											}
										}
									} elseif ( empty( $imported_code ) ) {

										$general_settings = get_option( 'wps_wgm_general_settings', array() );
										$giftcard_coupon_length  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );
										$giftcard_coupon_length = ( '' !== $giftcard_coupon_length ) ? $giftcard_coupon_length : 5;
										$random_code = wps_wgm_coupon_generator( $giftcard_coupon_length );
										if ( $wps_public_obj->wps_wgm_create_gift_coupon( $random_code, $couponamont, $order_id, $item['product_id'], $to ) ) {
											$todaydate = date_i18n( 'Y-m-d' );
																						$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
											if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
												$expiry_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
											} else {
												$expiry_date = $local_expiry_day;
											}
										
											$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
											$wps_uwgc_common_arr['order_id'] = $order_id;
											$wps_uwgc_common_arr['product_id'] = $pro_id;
											$wps_uwgc_common_arr['to'] = $to;
											$wps_uwgc_common_arr['from'] = $from;
											$wps_uwgc_common_arr['to_name'] = $to_name;
											$wps_uwgc_common_arr['gift_couponnumber'] = $random_code;
											$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
											$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
											$wps_uwgc_common_arr['selected_template'] = $selected_template;
											$wps_uwgc_common_arr['couponamont'] = $couponamont;
											$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
											$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
											$wps_uwgc_common_arr['item_id'] = $item_id;
											$wps_uwgc_common_arr['contact_no'] = $contact_no;
											$wps_uwgc_common_arr['send_date'] = $gift_date;
											$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;

											$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );
											if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
											}
										}
									}
								}
							} else {
								$general_settings = get_option( 'wps_wgm_general_settings', array() );
								$giftcard_coupon_length  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );
								$giftcard_coupon_length = ( '' !== $giftcard_coupon_length ) ? $giftcard_coupon_length : 5;

								for ( $i = 1; $i <= $item_quantity; $i++ ) {
									if ( isset( $recipients ) && ! empty( $recipients ) ) {
										$to = trim( array_shift( $recipients ) );
									}
									if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
										$to_name = trim( array_shift( $recipients_name ) );
									}
									$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );
									if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $to ) ) {
										$todaydate = date_i18n( 'Y-m-d' );

										$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
										if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
											$expiry_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
										} else {
											$expiry_date = $local_expiry_day;
										}

									
										$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
										$wps_uwgc_common_arr['order_id'] = $order_id;
										$wps_uwgc_common_arr['product_id'] = $pro_id;
										$wps_uwgc_common_arr['to'] = $to;
										$wps_uwgc_common_arr['from'] = $from;
										$wps_uwgc_common_arr['to_name'] = $to_name;
										$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
										$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
										$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
										$wps_uwgc_common_arr['selected_template'] = ! empty( $selected_template ) ? $selected_template : $temp;
										$wps_uwgc_common_arr['couponamont'] = $couponamont;
										$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
										$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
										$wps_uwgc_common_arr['item_id'] = $item_id;
										$wps_uwgc_common_arr['contact_no'] = $contact_no;
										$wps_uwgc_common_arr['send_date'] = $gift_date;
										$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;

										$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );
										if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
										}
									}
								}
							}
						}
					}
					if ( $gift_order && $datecheck ) {
						wps_wgm_hpos_update_meta_data( $order_id, 'wps_gw_order_giftcard', 'send' );
						wps_wgm_hpos_update_meta_data( $order_id, 'wps_wgm_order_giftcard', 'send' );
						$other_settings                               = get_option( 'wps_wgm_other_settings', array() );
						$wps_wgm_enable_auto_complete_gift_card_order = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_enable_auto_complete_gift_card_order' );
						if ( 'on' === $wps_wgm_enable_auto_complete_gift_card_order && $wps_public_obj->is_order_gift_card_only( $order_id ) && empty( $order->get_shipping_method() ) ) {
							$order_detail = new WC_Order( $order_id );
							$order_detail->update_status( 'wc-completed', 'Auto Completed via Gift Card.' );
						}
					}
				}
			}
		}
		global $wpdb;
		$table_name = $wpdb->prefix . 'offline_giftcard';
		$query = "SELECT * FROM $table_name WHERE `mail` != 1";
		$giftresults = $wpdb->get_results( $query, ARRAY_A );
		if ( isset( $giftresults ) && ! empty( $giftresults ) && null !== $giftresults ) {
			foreach ( $giftresults as $key => $value ) {

				if ( isset( $value['schedule'] ) && null !== $value['schedule'] && '' !== $value['schedule'] ) {
					$schedule_date = $value['schedule'];
					if ( is_string( $schedule_date ) ) {
						if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
							if ( 'd/m/Y' == $selected_date ) {
								$gift_date = str_replace( '/', '-', $schedule_date );
							}
						}
						$senddatetime = strtotime( $schedule_date );
					}
				} else {
					$schedule_date = date_i18n( 'Y-m-d' );
					$senddatetime = strtotime( $schedule_date );
				}
				$senddate = date_i18n( 'Y-m-d', $senddatetime );
				$todaytime = time();
				$todaydate = date_i18n( 'Y-m-d', $todaytime );
				$senddatetime = strtotime( "$senddate" );
				$todaytime = strtotime( "$todaydate" );
				$giftdiff = $senddatetime - $todaytime;

				if ( $giftdiff <= 0 ) {

					$couponcreated = $this->wps_common_fun->wps_uwgc_create_offline_gift_coupon( $value['coupon'], $value['amount'], $value['id'], $value['template'], $value['to'] );
					$product_id = $value['template'];
					$wps_wgm_pricing = ! empty( get_post_meta( $product_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $product_id, 'wps_wgm_pricing', true ) : get_post_meta( $product_id, 'wps_wgm_pricing_details', true );
					$templateid = $wps_wgm_pricing['template'];
					if ( is_array( $templateid ) && array_key_exists( 0, $templateid ) ) {
						$temp = $templateid[0];
					} else {
						$temp = $templateid;
					}
					$args['from'] = $value['from'];
					$args['to'] = $value['to'];
					$args['message'] = stripcslashes( $value['message'] );
					$args['coupon'] = apply_filters( 'wps_wgm_qrcode_coupon', $value['coupon'] );
					$to = $args['to'];
					$from = $args['from'];
					$couponcode = $value['coupon'];
					$coupon = new WC_Coupon( $couponcode );
					if ( isset( $coupon->id ) ) {
						$expiry_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
						$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );

						$args['expirydate'] = $expirydate_format;
						$args['amount'] = wc_price( $value['amount'] );
						$args['templateid'] = $temp;
						$args['product_id'] = $product_id;
						$args['order_id'] = '';
						$args['created_date'] = $value['date'];
						$args['send_date'] = $schedule_date;
						$message = $wps_public_obj->wps_wgm_create_gift_template( $args );

						$other_settings = get_option( 'wps_wgm_other_settings', array() );
						$wps_wgm_pdf_enable  = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_pdf_enable' );

						if ( isset( $wps_wgm_pdf_enable ) && 'on' == $wps_wgm_pdf_enable ) {
							$site_name = isset( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : '';
							$time = time();
							$this->wps_common_fun->wps_uwgc_attached_pdf( $message, $site_name, $time, '', $couponcode );
							if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
								$attachments = array( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $couponcode . '.pdf' );
							} else {
								$attachments = array( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
							}
						} else {
							$attachments = array();
						}
						$mail_settings = get_option( 'wps_wgm_mail_settings', array() );
						$subject  = $wps_public_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_giftcard_subject' );

						$bloginfo = get_bloginfo();
						if ( empty( $subject ) || ! isset( $subject ) ) {

							$subject = "$bloginfo:";
							$subject .= __( ' Hurry!!! Gift Card is Received', 'giftware' );
						}
						$subject = str_replace( '[SITENAME]', $bloginfo, $subject );
						$subject = str_replace( '[FROM]', $from, $subject );
						$subject = stripcslashes( $subject );
						$subject = html_entity_decode( $subject, ENT_QUOTES, 'UTF-8' );
						// Send mail to Receiver.

						$wps_wugc_bcc_enable  = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable' );
						$wps_bcc_to_admin_enable = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_addition_bcc_option_enable_for_site_admin' );

						if ( isset( $wps_wugc_bcc_enable ) && 'on' == $wps_wugc_bcc_enable ) {
							$headers[] = 'Bcc:' . $from;
							if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
								$headers[] = 'Bcc:' . get_option( 'admin_email' );
							}
							wc_mail( $to, $subject, $message, $headers, $attachments );
							if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
								unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $couponcode . '.pdf' );
							} elseif ( isset( $time ) && isset( $site_name ) && ! empty( $time ) && ! empty( $site_name ) ) {
								unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
							}
						} else {
							$headers = array( 'Content-Type: text/html; charset=UTF-8' );
							if ( isset( $wps_bcc_to_admin_enable ) && 'on' == $wps_bcc_to_admin_enable ) {
								$headers[] = 'Bcc:' . get_option( 'admin_email' );
							}
							wc_mail( $to, $subject, $message, $headers, $attachments );
							if ( isset( $giftcard_pdf_prefix ) && ! empty( $giftcard_pdf_prefix ) ) {
								unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/' . $giftcard_pdf_prefix . $couponcode . '.pdf' );
							} elseif ( isset( $time ) && isset( $site_name ) && ! empty( $time ) && ! empty( $site_name ) ) {
								unlink( WPS_UWGC_UPLOAD_DIR . '/giftcard_pdf/giftcard' . $time . $site_name . '.pdf' );
							}
						}

						$mail_settings = get_option( 'wps_wgm_mail_settings', array() );
						$subject  = $wps_public_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_receive_subject' );
						$subject = str_replace( '[TO]', $to, $subject );
						$message  = $wps_public_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_receive_message' );
						if ( empty( $subject ) || ! isset( $subject ) ) {

							$subject = "$bloginfo:";
							$subject .= __( ' Gift Card is Sent Successfully', 'giftware' );
						}

						if ( empty( $message ) || ! isset( $message ) ) {

							$message = "$bloginfo:";
							$message .= __( ' Gift Card is Sent Successfully to the Email Id: [TO]', 'giftware' );
						}

						$message = stripcslashes( $message );
						$message = str_replace( '[TO]', $to, $message );
						$subject = stripcslashes( $subject );
						// send acknowledge mail to sender.

						$wps_wgm_disable_buyer_notification  = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_disable_buyer_notification' );
						if ( 'on' !== $wps_wgm_disable_buyer_notification ) {
							wc_mail( $from, $subject, $message );
						}
						$data_to_update = array( 'mail' => 1 );
						$where = array( 'id' => $value['id'] );
						$update_data = $wpdb->update( $table_name, $data_to_update, $where );
					}
				}
			}
		}
	}

		/**
		 * This function is used to delete old images via a scheduler
		 *
		 * @name wps_gw_do_this_delete_img
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
	public function wps_uwgc_do_this_delete_img() {
		$time = time();
		$files = glob( wp_upload_dir()['basedir'] . '/qrcode_barcode/*.*' );
		if ( isset( $files ) && is_array( $files ) && ! empty( $files ) ) {
			foreach ( $files as $filename ) {
				$file1 = explode( 'wps__', $filename );
				$time = time();
				$timestamp = array();
				$timestamp[] = end( $file1 );
				if ( isset( $timestamp ) && is_array( $timestamp ) && ! empty( $timestamp ) ) {
					foreach ( $timestamp as $key => $val ) {
						if ( end( $file1 ) < $time . '.png' ) {
							unlink( wp_upload_dir()['basedir'] . '/qrcode_barcode/wps__' . $val );
						}
					}
				}
			}
		}

	}

	/**
	 * Send mail forcefully html
	 *
	 * @name wps_send_mail_forcefully
	 * @param int   $item_id Holds item id.
	 * @param array $item Holds item.
	 * @param array $order Holds order.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_send_mail_forcefully_html( $item_id, $item, $order ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$woo_ver = WC()->version;
		$order_status = $order->get_status();
		if ( 'completed' == $order_status || 'processing' == $order_status ) {
			if ( $woo_ver < '3.0.0' ) {
				$_product = $order->get_product_from_item( $item );
				$product_id = $_product->id;
			} else {
				$_product = $item->get_product();
				if ( ! empty( $_product ) ) {
					$product_id = $_product->get_id();
				}
			}
			if ( isset( $product_id ) && ! empty( $product_id ) ) {
				$product_types = wp_get_object_terms( $product_id, 'product_type' );
				$order_id = $order->get_id();
				$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
				if ( isset( $product_types[0] ) || 'on' === $wps_gift_product ) {
					$product_type = isset( $product_types[0] ) ? $product_types[0]->slug : '';
					if ( 'wgm_gift_card' == $product_type || 'on' === $wps_gift_product ) {
							$item_data = $item->get_meta_data();
						foreach ( $item_data as $key => $value ) {
								$value = $value->get_data();
							if ( isset( $value['key'] ) && 'Contributor' == $value['key'] && ! empty( $value['value'] ) ) {
								$pro_id = $item->get_id();
								$conti_prod_id = get_option( 'contributor_product_id' );
								$conti_prod_link = $url = get_permalink( $conti_prod_id );

								$subject = 'Product Notification';

								$message = $conti_prod_link . '?order_id=' . $order_id . '&prod_id=' . $pro_id;

								$whatsapp_url = 'https://api.whatsapp.com/send?';
								$whatsapp_url .= 'text=' . urlencode( $message );
								
								echo '<div class="wrapper-wps-thankyou-whatsapp-icon"><div class="wps-thankyou-whatsapp-icon"><a class="wps_pgfw_whatsapp_share_icon" href="' . $whatsapp_url . '"><img src="' . WPS_UWGC_URL . 'assets/images/whatsapp.png" alt="not found" style="width:50px;"/></a><p>Share link</p></div>';
								echo '<div class="wps-thankyou-whatsapp-icon"><a class="wps_copyLinkButton" href="' . $message . '"><span class="dashicons dashicons-admin-links"></span></a><p>Copy link</p></div></div>';
							}
							if ( isset( $value['key'] ) && 'Send Date' == $value['key'] && '' !== $value['value'] ) {
								$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
								$other_settings = get_option( 'wps_wgm_other_settings', array() );
								$wps_uwgc_sendtoday_disable  = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_additional_sendtoday_disable' );
								if ( 'send' !== $itemgiftsend ) {
									if ( 'on' !== $wps_uwgc_sendtoday_disable ) {
										?>
												<div id="wps_wgm_loader" style="display: none;">
													<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
												</div>
												<p id="wps_uwgc_send_mail_force_notification_<?php echo esc_attr( $item_id ); ?>"></p>
												<div id="wps_send_force_div_<?php echo esc_attr( $item_id ); ?>">
													<input type="button" data-id="<?php echo esc_attr( $order_id ); ?>" data-num = "<?php echo esc_attr( $item_id ); ?>" class="wps_uwgc_send_mail_force" class="button button-primary" value="<?php esc_attr_e( 'Send Today', 'giftware' ); ?>">
												</div>
											<?php
									}
								}
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Send mail forcefully for Schedule Giftcard when click on send Today Button.
	 *
	 * @name wps_uwgc_send_mail_force
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_send_mail_forcefully() {
		check_ajax_referer( 'wps-uwgc-verify-nonce', 'wps_uwgc_nonce' );
		$response['result'] = false;
		$response['message'] = __( 'Mail sending failed due to some issue. Please try again.', 'giftware' );

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$discount_settings = get_option( 'wps_wgm_discount_settings', array() );
		$discount_enable  = $wps_public_obj->wps_wgm_get_template_data( $discount_settings, 'wps_wgm_discount_enable' );

		$general_settings = get_option( 'wps_wgm_general_settings', array() );
		$giftcard_coupon_length  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_coupon_length' );
		$giftcard_coupon_length = ( '' !== $giftcard_coupon_length ) ? $giftcard_coupon_length : 5;

		if ( isset( $_POST['order_id'] ) && ! empty( $_POST['order_id'] ) && isset( $_POST['item_id'] ) && ! empty( $_POST['item_id'] ) ) {

			$order_id = sanitize_text_field( wp_unslash( $_POST['order_id'] ) );
			$item_id = sanitize_text_field( wp_unslash( $_POST['item_id'] ) );
			$order = wc_get_order( $order_id );

			foreach ( $order->get_items() as $item_id_arr => $item ) {
				if ( $item_id_arr == $item_id ) {
					$mailsend = false;
					$original_price = 0;
					$woo_ver = WC()->version;
					$gift_img_name = '';
					$from = '';
					$gift_msg = '';
					$to_name = '';
					$contact_no = '';
					$variable_price_description = '';
					$item_quantity = wc_get_order_item_meta( $item_id, '_qty', true );
					$product = $item->get_product();
					$item_meta_data = $item->get_meta_data();
					$pro_id = $product->get_id();
					foreach ( $item_meta_data as $key => $value ) {
						if ( isset( $value->key ) && 'To' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$to = $value->value;
						}
						if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$to_name = $value->value;
						}
						if ( isset( $value->key ) && 'From' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$from = $value->value;
						}
						if ( isset( $value->key ) && 'Message' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$gift_msg = $value->value;
						}
						if ( isset( $value->key ) && 'Image' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$gift_img_name = $value->value;
						}
						if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$delivery_method = $value->value;
						}
						if ( isset( $value->key ) && 'Original Price' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$original_price = $value->value;
						}
						if ( isset( $value->key ) && 'Selected Template' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$selected_template = $value->value;
						}
						if ( isset( $value->key ) && 'Reciever Contact' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$contact_no = $value->value;
						}
						if ( isset( $value->key ) && 'Variable Price Description' == $value->key && ! empty( $value->value ) ) {
							$mailsend = true;
							$variable_price_description = $value->value;
						}
						if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
							$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
							if ( 'send' == $itemgiftsend ) {
								$response['result'] = false;
								$response['message'] = __( 'Mail already send on the scheduled date.', 'giftware' );
								echo json_encode( $response );
								wp_die();
							}

							$mailsend = true;
							wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#send", 'send' );
							$note = __( 'Gift Card Email has been sent.', 'giftware' );
							$order->add_order_note( $note );
						} else {
							wps_wgm_hpos_update_meta_data( $order_id, "$order_id#$item_id#giftcard_send", 'send' );
						}
					}
					if ( ! empty( $to ) && ( 'Mail to recipient' == $delivery_method ) ) {
						$recipients = preg_split( '/[\s,]+/', $to, -1, PREG_SPLIT_NO_EMPTY );
					}
					if ( ! empty( $to_name ) ) {
						$recipients_name = preg_split( '/[,]+/', $to_name, -1, PREG_SPLIT_NO_EMPTY );
					}
					if ( ! isset( $to ) && empty( $to ) ) {
						if ( 'Mail to recipient' == $delivery_method ) {
							$to = $order->get_billing_email();
						} else {
							$to = '';
						}
					}
					if ( $mailsend ) {
						$gift_order = true;
						// gift total.
						$inc_tax_status = get_option( 'woocommerce_prices_include_tax', false );
						if ( 'yes' == $inc_tax_status ) {
							$inc_tax_status = true;
						} else {
							$inc_tax_status = false;
						}
						$couponamont = $original_price;
						$group_couponamont = wps_wgm_hpos_get_meta_data( $order_id, 'suborder#amttotal', true );
						if ( isset( $group_couponamont ) && ! empty( $group_couponamont ) ) {
							$couponamont = $group_couponamont;
						}
						$args = array(
							'posts_per_page'   => -1,
							'orderby'          => 'title',
							'order'            => 'asc',
							'post_type'        => 'shop_coupon',
							'post_status'      => 'publish',
						);

						// First query: search for coupons associated with product ID.
						$args['meta_query'] = array(
							'relation' => 'AND',
							array(
								'key'     => 'wps_wgm_imported_coupon',
								'value'   => 'yes',
								'compare' => '==',
							),
							array(
								'key'     => 'wps_wgm_coupon_product_id',
								'value'   => $pro_id,
								'compare' => '==',
							),
						);
						$imported_coupons = get_posts( $args );

						// If no imported coupons found for product ID, search for global coupons.
						if ( empty( $imported_coupons ) ) {
							$args['meta_query'] = array(
								'relation' => 'AND',
								array(
									'key'     => 'wps_wgm_imported_coupon',
									'value'   => 'yes',
									'compare' => '==',
								),
								array(
									'key'     => 'wps_wgm_coupon_product_id',
									'compare' => 'NOT EXISTS',
								),
							);
							$imported_coupons = get_posts( $args );
						}
						$wps_uwgc_common_arr = array();
						$is_imported_product = get_post_meta( $pro_id, 'is_imported', true );
						$wps_wgm_pricing = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
						$templateid = $wps_wgm_pricing['template'];
						if ( is_array( $templateid ) && array_key_exists( 0, $templateid ) ) {
							$temp = $templateid[0];
						} else {
							$temp = $templateid;
						}
						if ( isset( $is_imported_product ) && ! empty( $is_imported_product ) && 'yes' == $is_imported_product ) {
							if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
								$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
								if ( isset( $pro_price ) && is_array( $pro_price ) ) {
									$couponamont = $pro_price['default_price'];
								}
							} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
								$pro_price = ! empty( get_post_meta( $pro_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $pro_id, 'wps_wgm_pricing', true ) : get_post_meta( $pro_id, 'wps_wgm_pricing_details', true );
								if ( isset( $pro_price ) && is_array( $pro_price ) ) {
									$couponamont = $pro_price['default_price'];
								}
							} else {
								$couponamont = $order->get_line_subtotal( $item, $inc_tax_status );
							}
							$gift_couponnumber = get_post_meta( $pro_id, 'coupon_code', true );
							if ( empty( $gift_couponnumber ) && ! isset( $gift_couponnumber ) ) {
								$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );
							}
							if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $to ) ) {
								$todaydate = date_i18n( 'Y-m-d' );
								$expiry_date = get_post_meta( $pro_id, 'expiry_after_days', true );
								$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
								wc_update_order_item_meta( $item_id, 'Send Date', $todaydate );
								$wps_uwgc_common_arr['order_id'] = $order_id;
								$wps_uwgc_common_arr['product_id'] = $pro_id;
								$wps_uwgc_common_arr['to'] = $to;
								$wps_uwgc_common_arr['from'] = $from;
								$wps_uwgc_common_arr['to_name'] = isset( $to_name ) ? $to_name : '';
								$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
								$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
								$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
								$wps_uwgc_common_arr['selected_template'] = ! empty( $selected_template ) ? $selected_template : $temp;
								$wps_uwgc_common_arr['couponamont'] = $couponamont;
								$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
								$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
								$wps_uwgc_common_arr['item_id'] = $item_id;
								$wps_uwgc_common_arr['contact_no'] = $contact_no;
								$wps_uwgc_common_arr['send_date'] = $todaydate;
								$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
								$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

								if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
									update_post_meta( $pro_id, '_stock_status', 'outofstock' );
									$response['result'] = true;
									$response['message'] = __( 'Gift card  is Sent Successfully', 'giftware' );
									echo json_encode( $response );
									wp_die();
								}
							}
						} elseif ( ! empty( $imported_coupons ) ) {

							for ( $i = 0; $i < $item_quantity; $i++ ) {
								if ( isset( $recipients ) && ! empty( $recipients ) ) {
									$to = trim( array_shift( $recipients ) );
								}
								if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
									$to_name = trim( array_shift( $recipients_name ) );
								}
								$imported_code = $imported_coupons[ $i ]->post_title;
								if ( isset( $imported_code ) && ! empty( $imported_code ) ) {
									$the_coupon = new WC_Coupon( $imported_code );
									if ( $woo_ver < '3.0.0' ) {
										$import_coupon_id = $the_coupon->id;
									} else {
										$import_coupon_id = $the_coupon->get_id();
									}
									$todaydate = date_i18n( 'Y-m-d' );
									$expiry_date = get_post_meta( $import_coupon_id, 'wps_wgm_expiry_date', true );
									$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
									$wps_uwgc_common_arr['order_id'] = $order_id;
									$wps_uwgc_common_arr['product_id'] = $pro_id;
									$wps_uwgc_common_arr['to'] = $to;
									$wps_uwgc_common_arr['from'] = $from;
									$wps_uwgc_common_arr['to_name'] = isset( $to_name ) ? $to_name : '';
									$wps_uwgc_common_arr['gift_couponnumber'] = $imported_code;
									$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
									$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
									$wps_uwgc_common_arr['selected_template'] = $selected_template;
									$wps_uwgc_common_arr['couponamont'] = $couponamont;
									$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
									$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
									$wps_uwgc_common_arr['item_id'] = $item_id;
									$wps_uwgc_common_arr['contact_no'] = $contact_no;
									$wps_uwgc_common_arr['send_date'] = $todaydate;
									$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;

									$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

									if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
										update_post_meta( $import_coupon_id, 'coupon_amount', $couponamont );
										update_post_meta( $import_coupon_id, 'wps_wgm_coupon_amount', $couponamont );
										update_post_meta( $import_coupon_id, 'wps_wgm_imported_coupon', 'purchased' );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon', $order_id );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_unique', 'online' );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_product_id', $pro_id );
										update_post_meta( $import_coupon_id, 'wps_wgm_giftcard_coupon_mail_to', $to );
										$woo_ver = WC()->version;

										
										if ( $woo_ver < '3.6.0' ) {
											update_post_meta( $import_coupon_id, 'expiry_date', $expirydate_format );
										} else {
											$general_settings = get_option( 'wps_wgm_general_settings', array() );
											$selected_date = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_enable_selected_format' );
											if ( isset( $selected_date ) && null != $selected_date && '' != $selected_date ) {
												if ( 'd/m/Y' == $selected_date ) {
													$expirydate_format = str_replace( '/', '-', $expirydate_format );
												}
											}
											$expirydate_format = strtotime( $expirydate_format );
											update_post_meta( $import_coupon_id, 'date_expires', $expirydate_format );
										}

										$response['result'] = true;
										$response['message'] = __( 'Gift card  is Sent Successfully', 'giftware' );
										echo json_encode( $response );
										wp_die();
									}
								} elseif ( empty( $imported_code ) ) {
									$random_code = wps_wgm_coupon_generator( $giftcard_coupon_length );
									if ( $wps_public_obj->wps_wgm_create_gift_coupon( $random_code, $couponamont, $order_id, $item['product_id'], $to ) ) {
										$todaydate = date_i18n( 'Y-m-d' );
																				$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
										if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
											$expiry_date  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
										} else {
											$expiry_date = $local_expiry_day;
										}

									
										$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
										$wps_uwgc_common_arr['order_id'] = $order_id;
										$wps_uwgc_common_arr['product_id'] = $pro_id;
										$wps_uwgc_common_arr['to'] = $to;
										$wps_uwgc_common_arr['from'] = $from;
										$wps_uwgc_common_arr['to_name'] = $to_name;
										$wps_uwgc_common_arr['gift_couponnumber'] = $random_code;
										$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
										$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
										$wps_uwgc_common_arr['selected_template'] = $selected_template;
										$wps_uwgc_common_arr['couponamont'] = $couponamont;
										$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
										$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
										$wps_uwgc_common_arr['item_id'] = $item_id;
										$wps_uwgc_common_arr['contact_no'] = $contact_no;
										$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
										$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );
									}
								}
							}
						} else {

							for ( $i = 1; $i <= $item_quantity; $i++ ) {
								if ( isset( $recipients ) && ! empty( $recipients ) ) {
									$to = trim( array_shift( $recipients ) );
								}
								if ( isset( $recipients_name ) && ! empty( $recipients_name ) ) {
									$to_name = trim( array_shift( $recipients_name ) );
								}
								$gift_couponnumber = wps_wgm_coupon_generator( $giftcard_coupon_length );

								if ( $wps_public_obj->wps_wgm_create_gift_coupon( $gift_couponnumber, $couponamont, $order_id, $item['product_id'], $to ) ) {
									$todaydate = date_i18n( 'Y-m-d' );

									$local_expiry_day = get_post_meta( $pro_id, 'wps_wgm_local_setting_giftcard_expiry', true );
									if ( empty( $local_expiry_day ) || 0 == $local_expiry_day ) {
										$expiry_date  = $wps_public_obj->wps_wgm_get_template_data( $general_settings, 'wps_wgm_general_setting_giftcard_expiry' );
									} else {
										$expiry_date = $local_expiry_day;
									}

								
									$expirydate_format = $wps_public_obj->wps_wgm_check_expiry_date( $expiry_date );
									$wps_uwgc_common_arr['order_id'] = $order_id;
									$wps_uwgc_common_arr['product_id'] = $pro_id;
									$wps_uwgc_common_arr['to'] = $to;
									$wps_uwgc_common_arr['from'] = $from;
									$wps_uwgc_common_arr['to_name'] = $to_name;
									$wps_uwgc_common_arr['gift_couponnumber'] = $gift_couponnumber;
									$wps_uwgc_common_arr['gift_msg'] = $gift_msg;
									$wps_uwgc_common_arr['expirydate_format'] = $expirydate_format;
									$wps_uwgc_common_arr['selected_template'] = ! empty( $selected_template ) ? $selected_template : $temp;
									$wps_uwgc_common_arr['couponamont'] = $couponamont;
									$wps_uwgc_common_arr['delivery_method'] = $delivery_method;
									$wps_uwgc_common_arr['gift_img_name'] = $gift_img_name;
									$wps_uwgc_common_arr['item_id'] = $item_id;
									$wps_uwgc_common_arr['contact_no'] = $contact_no;
									$wps_uwgc_common_arr['send_date'] = $todaydate;
									$wps_uwgc_common_arr['variable_price_description'] = $variable_price_description;
									$wps_uwgc_common_arr = apply_filters( 'wps_uwgc_custmizable_common_arr', $wps_uwgc_common_arr, $item, $order );

									if ( $wps_public_obj->wps_wgm_common_functionality( $wps_uwgc_common_arr, $order ) ) {
										$response['result'] = true;
										$response['message'] = __( 'Gift card  is Sent Successfully', 'giftware' );
										echo json_encode( $response );
										 wp_die();
									}
								}
							}
						}
					}
					break;
				}
			}
		}
		echo json_encode( $response );
		wp_die();
	}

	/**
	 * This function is used to add resend email button at order detail page on front end
	 *
	 * @name wps_uwgc_woocommerce_order_details_after_order_table
	 * @param  array $order Conatins order data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_mail_view_order_frontend( $order ) {
		$resend_view_gift = false;
		$resend_view_ship = false;
		$resend_view_other_pro = false;
		$resend_view = false;
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$woo_ver = WC()->version;
		if ( $woo_ver < '3.0.0' ) {
			$order_id = $order->id;
			$order_status = $order->status;
		} else {
			$order_id = $order->get_id();
			$order_status = $order->get_status();
		}
		if ( 'completed' == $order_status || 'processing' == $order_status ) {
			$giftcard = false;
			foreach ( $order->get_items() as $item_id => $item ) {
				if ( $woo_ver < '3.0.0' ) {
					$_product = apply_filters( 'woocommerce_order_item_product', $order->get_product_from_item( $item ), $item );
				} else {
					$_product = apply_filters( 'woocommerce_order_item_product', $product = $item->get_product(), $item );
				}
				if ( isset( $_product ) && ! empty( $_product ) ) {
					$product_id = $_product->get_id();
				}
				if ( isset( $product_id ) && ! empty( $product_id ) ) {

					$product_types = wp_get_object_terms( $product_id, 'product_type' );

					if ( isset( $product_types[0] ) ) {
						$product_type = $product_types[0]->slug;
						$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
						if ( 'wgm_gift_card' == $product_type || 'on' == $wps_gift_product ) {
							$giftcard = true;
						}
					} else {
						$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
						if ( 'on' == $wps_gift_product ) {
							$giftcard = true;
						}
					}
				}

				if ( $woo_ver < '3.0.0' ) {
					$product = $order->get_product_from_item( $item );
					if ( isset( $item['item_meta']['Delivery Method'] ) && ! empty( $item['item_meta']['Delivery Method'] ) ) {
						$delivery_method = $item['item_meta']['Delivery Method'][0];
					}
				} else {

					$product = $item->get_product();
					$item_meta_data = $item->get_meta_data();
					foreach ( $item_meta_data as $key => $value ) {
						if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
							$delivery_method = $value->value;
						}
					}
				}

				if ( isset( $delivery_method ) ) {
					if ( 'Mail to recipient' == $delivery_method || 'Downloadable' == $delivery_method ) {
						$resend_view_gift = true;
					} else {
						$resend_view_ship = false;
					}
				} else {
					$resend_view_other_pro = false;
				}
				// DOWNLOAD PDF IN THANKYOU ORDER PAGE.
				if ( isset( $delivery_method ) && ! empty( $delivery_method ) && 'Downloadable' == $delivery_method ) {

					$giftcoupon = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
					if ( isset( $giftcoupon ) && ! empty( $giftcoupon ) ) {
						foreach ( $giftcoupon as $key => $value ) {
							$upload_dir_path = esc_attr( WPS_UWGC_UPLOAD_URL ). '/giftcard_pdf/giftcard' . $order_id . $value . '.pdf';
							?>
							<a href="<?php echo esc_attr( $upload_dir_path ); ?>" class="wps_download_pdf" target="_blank"><?php esc_html_e( 'Download PDF', 'giftware' ); ?><i class="fas fa-file-download wps_wgm_download_pdf"></i></a><br/>
							<?php
						}
					}
				}
			}
			if ( $resend_view_gift && ! $resend_view_ship && ! $resend_view_other_pro ) {
				$resend_view = true;
			} else {
				$resend_view = false;
			}
			$other_settings = get_option( 'wps_wgm_other_settings', array() );
			$wps_uwgc_resend_disable  = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_additional_resend_disable' );
			if ( $giftcard && $resend_view ) {
				?>
				<style>
				#wps_wgm_loader {
					background-color: rgba(255, 255, 255, 0.6);
					bottom: 0;
					height: 100%;
					left: 0;
					position: fixed;
					right: 0;
					top: 0;
					width: 100%;
					z-index: 99999;
				}

				#wps_wgm_loader img {
					display: block;
					left: 0;
					margin: 0 auto;
					position: absolute;
					right: 0;
					top: 40%;
				}
			</style>
				<?php
				if ( 'on' !== $wps_uwgc_resend_disable ) {
					?>
					<div class="resend_mail_wrapper">
						<span id="wps_uwgc_resend_mail_frontend_notification"></span>
						<h4>
							<strong><?php esc_html_e( 'Resend Gift Card Email', 'giftware' ); ?></strong>
						</h4>
						<div id="wps_wgm_loader" style="display: none;">
							<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/loading.gif">
						</div>
						<span class="wps_resend_content"><?php esc_html_e( "Press the icon to resend mail if the receiver hasn't received the mail you sent.", 'giftware' ); ?>
						</span>
						<a href="javascript:void(0);" data-id="<?php echo esc_attr( $order_id ); ?>" class="wps_uwgc_resend_mail" id="wps_uwgc_resend_mail_button_frontend">
							<img src="<?php echo esc_url( WPS_UWGC_URL ); ?>assets/images/send_mail.png" class="wps_resend_image">
						</a>
					</div>
					<?php
				}
			}
		}
	}

	/**
	 * This function is used to  resend email  at order detail page on front end
	 *
	 * @name wps_uwgc_resend_mail_order_deatils_frontend
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_mail_order_deatils_frontend() {
		check_ajax_referer( 'wps-uwgc-verify-nonce', 'wps_uwgc_nonce' );
		$this->wps_common_fun->wps_uwgc_resend_mail_common_function();
	}

	/**
	 * This function is used to create thankyou coupon on order status change.
	 *
	 * @name wps_uwgc_thankyou_coupon_order_status_change
	 * @param int    $order_id Conatins order id.
	 * @param string $old_status Conatins order status.
	 * @param string $new_status Conatins order status.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_thankyou_coupon_order_status_change( $order_id, $old_status, $new_status ) {
		if ( ! wps_wgm_giftcard_enable() ) {
			return;
		}
		if ( $old_status != $new_status ) {
			$order = wc_get_order( $order_id );
			$user_id = $order->get_user_id();
			if ( isset( $user_id ) && ! empty( $user_id ) ) {
				if ( 'completed' == $new_status || 'processing' == $new_status ) {
					$thankyou_user_order = get_user_meta( $user_id, 'thankyou_order_number', true );
					if ( isset( $thankyou_user_order ) && ! empty( $thankyou_user_order ) ) {
						++$thankyou_user_order;
						update_user_meta( $user_id, 'thankyou_order_number', $thankyou_user_order );
					} else {
						update_user_meta( $user_id, 'thankyou_order_number', 1 );
					}
				}
			}

			$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
			$wps_uwgc_thankyou_coupon_settings = get_option( 'wps_wgm_thankyou_order_settings', array() );

			$wps_wgm_thankyouorder_enable = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_thankyou_coupon_settings, 'wps_wgm_thankyouorder_enable' );
			$wps_wgm_thankyouorder_time = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_thankyou_coupon_settings, 'wps_wgm_thankyouorder_time' );
			$thankyou_status = '';
			switch ( $wps_wgm_thankyouorder_time ) {
				case 'wps_wgm_order_processing':
					$thankyou_status = 'processing';
					break;
				case 'wps_wgm_order_completed':
					$thankyou_status = 'completed';
					break;
				default:
					$thankyou_status = 'other';
					break;
			}
			if ( isset( $wps_wgm_thankyouorder_enable ) && ! empty( $wps_wgm_thankyouorder_enable ) && 'on' == $wps_wgm_thankyouorder_enable ) {
				if ( $thankyou_status === $new_status || 'other' === $thankyou_status ) {
					$thanku_coupon = $this->wps_common_fun->wps_uwgc_thankyou_coupon_handle( $order_id, $new_status );
				}
			}
		}
	}

	/**
	 * This function is for validating the ajax add to cart request on single product page
	 *
	 * @param bool   $validate Check if valid.
	 * @param int    $product_id Contains product id.
	 * @param string $quantity Contains quantity.
	 * @return boolean
	 * @name wps_uwgc_add_to_cart_validation
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_add_to_cart_validation( $validate, $product_id, $quantity ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_wgm_product_settings = get_option( 'wps_wgm_product_settings', array() );

		$wps_wgm_remove_validation_to = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_product_settings, 'wps_wgm_remove_validation_to' );
		$wps_wgm_remove_validation_from = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_product_settings, 'wps_wgm_remove_validation_from' );
		$wps_wgm_remove_validation_msg = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_product_settings, 'wps_wgm_remove_validation_msg' );
		$wps_wgm_remove_validation_to_name = $wps_public_obj->wps_wgm_get_template_data( $wps_wgm_product_settings, 'wps_wgm_remove_validation_to_name' );

		$wps_uwgc_mail_settings = get_option( 'wps_wgm_mail_settings', array() );
		$giftcard_message_length = $wps_public_obj->wps_wgm_get_template_data( $wps_uwgc_mail_settings, 'wps_wgm_mail_setting_giftcard_message_length' );

		$giftcard_message_length = ( '' !== $giftcard_message_length ) ? $giftcard_message_length : 300;

		$product_types = wp_get_object_terms( $product_id, 'product_type' );
		if ( isset( $product_types[0] ) ) {
			$product_type = $product_types[0]->slug;
			if ( 'wgm_gift_card' == $product_type ) {
				$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_giftware', true );
				if ( ! isset( $_POST['wps_wgm_send_giftcard'] ) || empty( $_POST['wps_wgm_send_giftcard'] ) ) {
					$validate = false;
					wc_add_notice( __( 'Delivery Method: Please Select One Method', 'giftware' ), 'error' );
				} else {
					$wps_wgm_method = sanitize_text_field( wp_unslash( $_POST['wps_wgm_send_giftcard'] ) );

					if ( 'on' !== $wps_wgm_remove_validation_to ) {
						if ( 'Mail to recipient' == $wps_wgm_method ) {
							
						}
					}

					if ( 'yes' !== $is_customizable ) {
						if ( 'Mail to recipient' == $wps_wgm_method ) {
							if ( 'on' !== $wps_wgm_remove_validation_to_name ) {
								if ( ! isset( $_POST['wps_wgm_to_name_optional'] ) || empty( $_POST['wps_wgm_to_name_optional'] ) ) {
									$validate = false;
									wc_add_notice( __( 'Recipient Name: Field is empty.', 'giftware' ), 'error' );
								}
							}
						}
					}
				}
				
				if ( 'on' !== $wps_wgm_remove_validation_msg ) {
					if ( ! isset( $_POST['wps_wgm_message'] ) || empty( $_POST['wps_wgm_message'] ) ) {
						$validate = false;
						wc_add_notice( __( 'Message: Field is empty.', 'giftware' ), 'error' );
					} elseif ( strlen( mb_convert_encoding(trim( sanitize_text_field( wp_unslash( $_POST['wps_wgm_message'] ) ) ), "ISO-8859-1", "UTF-8") ) > $giftcard_message_length ) {
						$validate = false;
						/* translators: %s: search term */
						$error_mesage = sprintf( __( '%1$sMessage: %2$sMessage length cannot exceed %3$s characters.', 'giftware' ), '<b>', '</b>', $giftcard_message_length );
						wc_add_notice( $error_mesage, 'error' );
					}
				}
				if ( 'on' !== $wps_wgm_remove_validation_from ) {
					if ( ! isset( $_POST['wps_wgm_from_name'] ) || empty( $_POST['wps_wgm_from_name'] ) ) {
						$validate = false;
						wc_add_notice( __( 'From: Field is empty.', 'giftware' ), 'error' );
					}
				}

				if ( isset( $_POST['wps_whatsapp_contact'] ) ) {
					$whatsapp_contact = sanitize_text_field( wp_unslash( $_POST['wps_whatsapp_contact'] ) );
					if ( empty( $whatsapp_contact ) ) {
						wc_add_notice( __( 'Please enter a WhatsApp contact number.', 'giftware' ), 'error' );
						$validate = false;
					} else {
						if ( ! preg_match( '/^[0-9]+$/', $whatsapp_contact ) ) {
							wc_add_notice( __( 'Invalid WhatsApp contact number. Only numbers are allowed, no spaces or special characters.', 'giftware' ), 'error' );
							$validate = false;
						}
					}
				}
			}
		}

		if ( get_option( 'gc_expiry_extension_product_id' ) == $product_id ) {
			if ( ! isset( $_POST['wps_expiry_extension_coupon_code'] ) || empty( $_POST['wps_expiry_extension_coupon_code'] ) ) {
				$validate = false;
				wc_add_notice( __( 'Enter the Gift Card Coupon', 'giftware' ), 'error' );
			} else {
				$wps_expiry_extension_coupon_code = sanitize_text_field( wp_unslash( $_POST['wps_expiry_extension_coupon_code'] ) );
				$coupon = new WC_Coupon( $wps_expiry_extension_coupon_code );

				// Check if the coupon exists.
				if ( $coupon->is_valid() ) {
					$expiry_date = $coupon->get_date_expires();
					if ( isset( $expiry_date ) && ! empty( $expiry_date ) ) {

					} else {
						$validate = false;
						wc_add_notice( __( 'This Coupon has No Expiry', 'giftware' ), 'error' );
					}
				} else {
					$validate = false;
					wc_add_notice( __( 'Invalid Gift Card Code', 'giftware' ), 'error' );
				}
			}
			
		}
		return $validate;
	}

	/**
	 * This function is used to test input.
	 *
	 * @name wps_uwgc_test_input
	 * @param array $data Conatins data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_test_input( $data ) {
		$data = trim( $data );
		$data = stripslashes( $data );
		$data = htmlspecialchars( $data );
		return $data;
	}

	/**
	 * This function is used to hide giftcard thumbnail on single product page
	 *
	 * @name wps_uwgc_hide_giftcard_product_thumbnail
	 * @param array $thumbnail_settings thumbnail settings.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_hide_giftcard_product_thumbnail( $thumbnail_settings ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_wgm_hide_giftcard_thumbnail = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_hide_giftcard_thumbnail' );
		return $wps_wgm_hide_giftcard_thumbnail;
	}

	/**
	 * This is function is used for hiding some  item meta from thankyou order page and also from Emails
	 *
	 * @name wps_uwgc_hide_order_metafields_from_email
	 * @param array $item_metas  Conatins item meta.
	 * @param array $formatted_meta contains formatted data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_hide_order_metafields_from_email( $item_metas, $formatted_meta ) {
		$temp_metas = array();
		foreach ( $item_metas as $key => $meta ) {
			if ( isset( $meta->key ) && ! in_array( $meta->key, array( 'Selected Template', 'Image', 'Choosen Image', 'Purchase as a Gift' ) ) ) {
				$temp_metas[ $key ] = $meta;
			}
		}
		return $temp_metas;
	}

	/**
	 * This function is used to make the meta keys translatable
	 *
	 * @name wps_uwgc_woocommerce_order_item_display_meta_key
	 * @param string $display_key show display key.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_woocommerce_order_item_display_meta_key( $display_key ) {
		if ( 'To Name' == $display_key ) {
			$display_key = __( 'To Name', 'giftware' );
		}
		if ( 'To' == $display_key ) {
			$display_key = __( 'To', 'giftware' );
		}
		if ( 'From' == $display_key ) {
			$display_key = __( 'From', 'giftware' );
		}
		if ( 'Message' == $display_key ) {
			$display_key = __( 'Message', 'giftware' );
		}
		if ( 'Delivery Method' == $display_key ) {
			$display_key = __( 'Delivery Method', 'giftware' );
		}
		if ( 'Send Date' == $display_key ) {
			$display_key = __( 'Send Date', 'giftware' );
		}
		if ( 'Send Time' == $display_key ) {
			$display_key = __( 'Send Time', 'giftware' );
		}
		if ( 'Original Price' == $display_key ) {
			$display_key = __( 'Original Price', 'giftware' );
		}
		if ( 'Selected Template' == $display_key ) {
			$display_key = __( 'Selected Template', 'giftware' );
		}
		if ( 'Image' == $display_key ) {
			$display_key = __( 'Image', 'giftware' );
		}
		if ( 'Variable Price Description' == $display_key ) {
			$display_key = __( 'Variable Price Description', 'giftware' );
		}
		return $display_key;
	}

	/**
	 * This function is used to make the meta values translatable
	 *
	 * @name wps_uwgc_woocommerce_order_item_display_meta_value
	 * @param string $display_value show display value.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_woocommerce_order_item_display_meta_value( $display_value ) {

		if ( 'Mail to recipient' == $display_value ) {
			$display_value = __( 'Mail to recipient', 'giftware' );
		}
		if ( 'Downloadable' == $display_value ) {
			$display_value = __( 'Downloadable', 'giftware' );
		}
		if ( 'shipping' == $display_value ) {
			$display_value = __( 'shipping', 'giftware' );
		}
		return $display_value;
	}

	/**
	 * This is function of class where coupon on shipping is applied
	 *
	 * @name add_hooks_and_filters
	 * @param array $cart Conatins cart data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_apply_coupon_on_cart_total( $cart ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$delivery_settings = get_option( 'wps_wgm_delivery_settings', array() );
		$gift_cart_ship = $wps_public_obj->wps_wgm_get_template_data( $delivery_settings, 'wps_wgm_general_cart_shipping_enable' );
		if ( 'on' == $gift_cart_ship ) {
			$wps_cart_discount = $cart->discount_cart;
			$woo_ver = WC()->version;
			if ( $woo_ver >= '4.4.0' ) {
				if ( 'incl' === WC()->cart->get_tax_price_display_mode() ) {
					if ( isset( $cart->discount_cart_tax ) && null !== $cart->discount_cart_tax ) {
						$wps_cart_discount += $cart->discount_cart_tax;
					}
				}
			} else {
				if ( 'incl' === WC()->cart->tax_display_cart ) {
					if ( isset( $cart->discount_cart_tax ) && null !== $cart->discount_cart_tax ) {
						$wps_cart_discount += $cart->discount_cart_tax;
					}
				}
			}
			$applied_coupons = $cart->get_applied_coupons();
			if ( is_array( $applied_coupons ) && ! empty( $applied_coupons ) ) {
				$wps_coupon_arr = array();
				foreach ( $applied_coupons as $key => $code ) {
					$the_coupon = new WC_Coupon( $code );
					$coupon_id = $the_coupon->get_id();
					if ( isset( $coupon_id ) && ! empty( $coupon_id ) ) {
						$coupon_type = get_post_meta( $coupon_id, 'discount_type', true );
						if ( isset( $coupon_type ) && 'fixed_cart' == $coupon_type ) {

							$wps_coupon_total = $this->wps_uwgc_coupons_total( $cart->get_coupons() );
							$wps_uwgc_coupon_amount_left = $wps_coupon_total - $wps_cart_discount;
							$total_shipping_tax = $cart->shipping_total + $cart->shipping_tax_total;
							if ( $wps_uwgc_coupon_amount_left > 0 && ! empty( $cart->shipping_total ) ) {

								if ( $wps_uwgc_coupon_amount_left >= $total_shipping_tax ) {
									$cart->discount_cart += $total_shipping_tax;
									$this->wps_uwgc_adjust_coupon_amount( $total_shipping_tax );

									$cart->total -= $total_shipping_tax;
									return $cart;
								} elseif ( $wps_uwgc_coupon_amount_left < $total_shipping_tax ) {

									$cart->discount_cart += $wps_uwgc_coupon_amount_left;
									$this->wps_uwgc_adjust_coupon_amount( $wps_uwgc_coupon_amount_left );
									$cart->total -= $wps_uwgc_coupon_amount_left;
									return $cart;
								}
							} else {
								return $cart;
							}
						} else {
							return $cart;
						}
					} else {
						return $cart;
					}
				}
			} else {
				return $cart;
			}
		} else {
			return $cart;
		}
	}

	/**
	 * This is used to get all coupon total amount
	 *
	 * @name wps_uwgc_coupons_total
	 * @param array $wps_coupon contains coupon data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_coupons_total( $wps_coupon ) {
		$wps_coupon_total = 0;
		foreach ( $wps_coupon as $coupon ) {
			$woo_ver = WC()->version;
			if ( $woo_ver < '3.0.0' ) {
				$wps_coupon_total = $wps_coupon_total + $coupon->coupon_amount;
			} else {
				$wps_coupon_total = $wps_coupon_total + $coupon->get_amount();
			}
		}
		return $wps_coupon_total;
	}

	/**
	 * This is used to adjust the coupon price
	 *
	 * @name wps_uwgc_adjust_coupon_amount
	 * @param mixed $more_amount Coupon Amount.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_adjust_coupon_amount( $more_amount ) {
		$coupons = WC()->cart->get_coupons();
		$woo_ver = WC()->version;
		if ( $woo_ver < '3.0.0' ) {
			foreach ( $coupons as $coupon ) {
				$wps_already_applied_coupon_amount = isset( WC()->cart->coupon_discount_amounts[ $coupon->code ] ) ? round( WC()->cart->coupon_discount_amounts[ $coupon->code ] ) : 0;
				if ( $wps_already_applied_coupon_amount < $coupon->coupon_amount ) {
					$remaining_coupon_amount = $coupon->coupon_amount - $wps_already_applied_coupon_amount;
					if ( $more_amount <= $remaining_coupon_amount ) {
						WC()->cart->coupon_discount_amounts[ $coupon->code ] = ( isset( WC()->cart->coupon_discount_amounts[ $coupon->code ] ) ? WC()->cart->coupon_discount_amounts[ $coupon->code ] : 0 ) + $more_amount;
						$more_amount = 0;
					} elseif ( $more_amount > $remaining_coupon_amount ) {
						$more_amount = $more_amount - $remaining_coupon_amount;
						WC()->cart->coupon_discount_amounts[ $coupon->code ] += $remaining_coupon_amount;
					}
				}
				if ( 0 == $more_amount ) {
					break;
				}
			}
		} else {
			foreach ( $coupons as $coupon ) {
				$wps_already_applied_coupon_amount = isset( WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] ) ? ( WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] ) : 0;
				if ( $wps_already_applied_coupon_amount < $coupon->get_amount() ) {
					$remaining_coupon_amount = $coupon->get_amount() - $wps_already_applied_coupon_amount;
					if ( $more_amount <= $remaining_coupon_amount ) {
						WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] = ( isset( WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] ) ? WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] : 0 ) + $more_amount;
						$more_amount = 0;
					} elseif ( $more_amount > $remaining_coupon_amount ) {
						$more_amount = $more_amount - $remaining_coupon_amount;
						WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] += $remaining_coupon_amount;
					}
				}
				if ( 0 == $more_amount ) {
					break;
				}
			}
		}
	}

	/**
	 * Create a section to input mobile number from user.
	 *
	 * @name wps_wgm_input_mobileno_section
	 * @param mixed $wps_additional_section Additional data.
	 * @param mixed $product_id Product id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_input_mobileno_section( $wps_additional_section, $product_id ) {
		$wps_additional_section = '';
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$notification_settings = get_option( 'wps_wgm_notification_settings', array() );
		$wps_uwgc_sms_notification = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_enable_sms_notification' );
		$wps_wgm_enable_whatsapp_notification = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_enable_whatsapp_notification' );
		$wps_uwgc_sms_notification = ( ! $wps_uwgc_sms_notification || '' === $wps_uwgc_sms_notification ) ? 'off' : $wps_uwgc_sms_notification;
		$wps_wgm_enable_whatsapp_notification = ( ! $wps_wgm_enable_whatsapp_notification || '' === $wps_wgm_enable_whatsapp_notification ) ? 'off' : $wps_wgm_enable_whatsapp_notification;
		$delivery_settings = get_option( 'wps_wgm_delivery_settings', array() );
		$wps_uwgc_method_enable = $wps_public_obj->wps_wgm_get_template_data( $delivery_settings, 'wps_wgm_send_giftcard' );
		if ( isset( $wps_uwgc_method_enable ) && 'shipping' !== $wps_uwgc_method_enable ) {
			$is_sms_enabled = ( 'off' !== $wps_uwgc_sms_notification );
			$is_whatsapp_enabled = ( 'off' !== $wps_wgm_enable_whatsapp_notification );

			if ( $is_sms_enabled || $is_whatsapp_enabled ) {
				$label = '';

				if ( $is_sms_enabled && $is_whatsapp_enabled ) {
					$label = __( 'Share Giftcard over SMS / WhatsApp', 'giftware' );
				} elseif ( $is_sms_enabled ) {
					$label = __( 'Share Giftcard over SMS', 'giftware' );
				} elseif ( $is_whatsapp_enabled ) {
					$label = __( 'Share Giftcard over WhatsApp', 'giftware' );
				}

				$wps_additional_section .= '<p class="wps_wgm_section wps_notification" id="wps_notification_div">
					<label class="wps_wgc_label">' . $label . '</label>    
					<input type="tel" name="wps_whatsapp_contact" id="wps_whatsapp_contact" class="wps_uwgc_from_name">
					<span class="wps_uwgc_msg_info">' . __( "Enter contact number with country code. Ex : 1XXXXXXX987 ( '+' not allowed)", 'giftware' ) . '</span>
					<span class="wps_uwgc_msg_info">' . __( 'NOTE : No special characters & spaces are allowed.', 'giftware' ) . '</span>
				</p>';
			}
		}
		return apply_filters( 'wps_uwgc_after_notification_section', $wps_additional_section, $product_id );
	}

	/**
	 * This function is used to validate the phone number fot sms notification
	 *
	 * @name wps_gw_validate_twilio_contact_number
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_validate_twilio_contact_number() {
		check_ajax_referer( 'wps-uwgc-verify-nonce', 'wps_uwgc_nonce' );
		$wps_contact = isset( $_POST['wps_contact'] ) ? sanitize_text_field( wp_unslash( $_POST['wps_contact'] ) ) : '';
		if ( isset( $wps_contact ) && '' !== $wps_contact ) {
			$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
			$url = 'https://lookups.twilio.com/v1/PhoneNumbers/' . $wps_contact;
			$notification_settings = get_option( 'wps_wgm_notification_settings', array() );
			$username = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_account_sid' );
			$password = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_auth_token' );
			if ( isset( $username ) && '' !== $username && isset( $password ) && '' !== $password ) {
				$send_sms_from = $wps_public_obj->wps_wgm_get_template_data( $notification_settings, 'wps_wgm_twilio_number' );
				$ch = curl_init();
				curl_setopt( $ch, CURLOPT_URL, $url );
				curl_setopt( $ch, CURLOPT_TIMEOUT, 30 ); // timeout after 30 seconds.
				curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
				curl_setopt( $ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY );
				curl_setopt( $ch, CURLOPT_USERPWD, "$username:$password" );
				$response_obj = curl_exec( $ch );
				$response_obj = json_decode( $response_obj, true );
                if ( isset( $response_obj['status'] ) && ! empty( $response_obj['status'] ) && '404' == $response_obj['status'] ) {
                    $response['result'] = 'Invalid';
                } else {
                    $response['result'] = 'Valid';
                }
				echo json_encode( $response );
				wp_die();
			}
		}
	}

	/**
	 * This function is resend the message over phone.
	 *
	 * @name wps_uwgc_resend_message
	 * @param array $args Contains argument.
	 * @param array $wps_uwgc_common_arr Contains common arguments.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_resend_message( $args, $wps_uwgc_common_arr ) {
		$coupon_code = isset( $wps_uwgc_common_arr['coupon'] ) ? $wps_uwgc_common_arr['coupon'] : '';
		$contact_no  = isset( $wps_uwgc_common_arr['contact_no'] ) ? $wps_uwgc_common_arr['contact_no'] : '';
		$order_id    = isset( $wps_uwgc_common_arr['order_id'] ) ? $wps_uwgc_common_arr['order_id'] : '';
		$item_id     = isset( $wps_uwgc_common_arr['item_id'] ) ? $wps_uwgc_common_arr['item_id'] : '';
		global $woocommerce;
		$coupon          = new WC_Coupon( $coupon_code );
		$coupon_amount   = $coupon->get_amount();
		$wps_common_args = array();
		$wps_common_args['couponamont'] = $coupon_amount;
		$wps_common_args['contact_no'] = $contact_no;
		$wps_common_args['order_id'] = $order_id;
		$wps_common_args['item_id'] = $item_id;
		return $args;
	}

	/**
	 * This function is used to send giftcard over whatsapp
	 *
	 * @name wps_uwgc_enable_whatspp_sharing
	 * @param array $order contains order data.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_uwgc_enable_whatspp_sharing( $order ) {
		$order_id = $order->get_id();
		$order_status = $order->get_status();
		if ( 'completed' == $order_status || 'processing' == $order_status ) {
			$message = '';
			$to_name = '';
			$to_email = '';
			$from = '';
			$coupon_code = '';
			$expiry_date = '';
			$amount = 0;
			$contact_no = '';
			$couponamont = 0;
			$gift_date = '';
			$itemgiftsend = '';
			foreach ( $order->get_items() as $item_id => $item ) {
				$giftcard = false;
				$product = $item->get_product();

				if ( isset( $product ) && ! empty( $product ) ) {
					$product_id = $product->get_id();
				}
				if ( isset( $product_id ) && ! empty( $product_id ) ) {
					$product_types = wp_get_object_terms( $product_id, 'product_type' );

					if ( isset( $product_types[0] ) ) {
						$product_type = $product_types[0]->slug;
						$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
						if ( 'wgm_gift_card' == $product_type || 'on' == $wps_gift_product ) {
							$giftcard = true;
						}
					} else {
						$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
						if ( 'on' == $wps_gift_product ) {
							$giftcard = true;
						}
					}
				}
				$item_meta_data = $item->get_meta_data();
				foreach ( $item_meta_data as $key => $value ) {
					if ( isset( $value->key ) && 'To Name' == $value->key && ! empty( $value->value ) ) {
						$to_name = $value->value;
					}
					if ( isset( $value->key ) && 'To' == $value->key && ! empty( $value->value ) ) {
						$to_email = $value->value;
					}
					if ( isset( $value->key ) && 'From' == $value->key && ! empty( $value->value ) ) {
						$from = $value->value;
					}
					if ( isset( $value->key ) && 'Message' == $value->key && ! empty( $value->value ) ) {
						$message = $value->value;
					}
					if ( isset( $value->key ) && 'Delivery Method' == $value->key && ! empty( $value->value ) ) {
						$delivery_method = $value->value;
					}
					if ( isset( $value->key ) && 'Send Date' == $value->key && ! empty( $value->value ) ) {
						$gift_date = $value->value;
					}
				}
				$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
				if ( '' == $itemgiftsend ) {
					$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#giftcard_send", true );
				}

				if ( $giftcard ) {
					$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
					$wps_notification_settings = get_option( 'wps_wgm_notification_settings', array() );
					$wps_enable_whatsap_sharing = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_share_on_whatsapp' );
					$wps_enable_pdf_link = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_share_pdf_link' );

					if ( 'on' == $wps_enable_whatsap_sharing ) {

						$wps_wgm_whatsapp_message = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_whatsapp_message' );
						if ( '' == $wps_wgm_whatsapp_message ) {
							$wps_wgm_whatsapp_message = __(
								'Hello [TO],
							[MESSAGE] 
							You have received a gift card from  [FROM]
							Coupon code : [COUPONCODE]
							Amount : [AMOUNT]
							Expiry Date : [EXPIRYDATE]',
								'giftware'
							);
						}
						$wps_wgm_whatsapp_message = preg_replace( '/\s*$^\s*/m', "\n", $wps_wgm_whatsapp_message );
						$wps_wgm_whatsapp_message = preg_replace( '/[ \t]+/', ' ', $wps_wgm_whatsapp_message );
						if ( isset( $delivery_method ) && 'Shipping' !== $delivery_method ) {
							if ( 'send' == $itemgiftsend ) {
								if ( '' !== $to_name && ! empty( $to_name ) ) {
									$wps_wgm_whatsapp_message = str_replace( '[TO]', $to_name, $wps_wgm_whatsapp_message );
								} else {
									$wps_wgm_whatsapp_message = str_replace( '[TO]', $to_email, $wps_wgm_whatsapp_message );
								}
								$wps_wgm_whatsapp_message = str_replace( '[MESSAGE]', $message, $wps_wgm_whatsapp_message );
								$wps_wgm_whatsapp_message = str_replace( '[FROM]', $from, $wps_wgm_whatsapp_message );
								$product_id = $product->get_id();
								$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
								if ( empty( $gift_couponnumber ) ) {
									$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$product_id", true );
								}
								foreach ( $gift_couponnumber as $key => $value ) {
									$the_coupon = new WC_Coupon( $value );
								}
								$expiry_date_timestamp = $the_coupon->get_date_expires();
								$couponamont = $the_coupon->get_amount();
								$other_settings = get_option( 'wps_wgm_other_settings', array() );
								if ( empty( $expiry_date_timestamp ) ) {
									$expirydate_format = __( 'No Expiration', 'giftware' );
								} else {
									$expiry_date_timestamp = strtotime( $expiry_date_timestamp );
									$expirydate = date_i18n( 'Y-m-d', $expiry_date_timestamp );
									$expirydate_format = date_create( $expirydate );
									$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
									$wps_general_settings = get_option( 'wps_wgm_general_settings', array() );
									$selected_date = $wps_public_obj->wps_wgm_get_template_data( $wps_general_settings, 'wps_wgm_general_setting_enable_selected_format' );
									if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
										$expirydate_format = gmdate( $selected_date, $expiry_date_timestamp );
									} else {
										$expirydate_format = date_format( $expirydate_format, 'jS M Y' );
									}
								}

								$coupon_amount = $couponamont . ' ' . get_woocommerce_currency();
								$wps_wgm_whatsapp_message = str_replace( '[COUPONCODE]', $value, $wps_wgm_whatsapp_message );
								$wps_wgm_whatsapp_message = str_replace( '[AMOUNT]', $coupon_amount, $wps_wgm_whatsapp_message );
								$wps_wgm_whatsapp_message = str_replace( '[EXPIRYDATE]', $expirydate_format, $wps_wgm_whatsapp_message );

								if ( isset( $other_settings['wps_wgm_addition_pdf_enable'] ) && 'on' == $other_settings['wps_wgm_addition_pdf_enable'] && 'on' == $wps_enable_pdf_link ) {
									$dwnld_pdf = ( esc_attr( WPS_UWGC_UPLOAD_URL ) . '/giftcard_pdf/giftcard' . $order_id . $value . '.pdf' );
								}

								$wps_message = __( 'Share On', 'giftware' );

								$dwnld_pdf_link = isset( $dwnld_pdf ) ? ' PDF Link : ' . $dwnld_pdf : '';

								$whatsapp_url = "https://api.whatsapp.com/send?text=" . rawurlencode( $wps_wgm_whatsapp_message . $dwnld_pdf_link );
								echo '<div class="wrapper-wps-thankyou-whatsapp-icon"><div class="wps-thankyou-whatsapp-icon"><a target="_blank" class="wps_pgfw_whatsapp_share_icon" href="' . $whatsapp_url . '"><img src="' . esc_url( WPS_UWGC_URL ) . 'assets/images/whatsapp.png"></a>'. esc_html( $wps_message ) . '</div></div>';
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Wps_uwgc_display_thumbnail_temmplates
	 *
	 * @param string $wps_additional_section additional_section.
	 * @param int    $product_id id.
	 */
	public function wps_uwgc_display_thumbnail_temmplates( $wps_additional_section, $product_id ) {
		
		$wps_additional_section = '';
		$wps_return_value = array();
		$wps_wgm_pricing = ! empty( get_post_meta( $product_id, 'wps_wgm_pricing', true ) ) ? get_post_meta( $product_id, 'wps_wgm_pricing', true ) : get_post_meta( $product_id, 'wps_wgm_pricing_details', true );
		$templateid = $wps_wgm_pricing['template'];
		$assigned_temp = '';
		$default_selected = isset( $wps_wgm_pricing['by_default_tem'] ) ? $wps_wgm_pricing['by_default_tem'] : false;

		$wps_wgm_hide_giftcard_thumbnail = '';
		$wps_wgm_hide_giftcard_thumbnail = apply_filters( 'wps_wgm_hide_giftcard_product_thumbnail', $wps_wgm_hide_giftcard_thumbnail );
		if ( is_array( $templateid ) && ! empty( $templateid ) ) {
			foreach ( $templateid as $key => $temp_id ) {
				
			
				$featured_img = wp_get_attachment_image_src( get_post_thumbnail_id( $temp_id ), 'single-post-thumbnail' );
				
				if ( empty( $featured_img[0] ) ) {
					$featured_img = array();
					$featured_img[0] = WPS_WGC_URL . 'assets/images/placeholder.png';
				}
				
				$selected_class = '';
				if ( isset( $default_selected ) && null !== $default_selected && $default_selected == $temp_id ) {
					$selected_class = 'wps_wgm_pre_selected_temp';
					$choosed_temp = $temp_id;
				} elseif ( isset( $default_selected ) && is_array( $default_selected ) && null !== $default_selected && $default_selected[0] == $temp_id ) {
					$selected_class = 'wps_wgm_pre_selected_temp';
					$choosed_temp = $temp_id;
				}
				$assigned_temp .= '<img class = "wps_wgm_featured_img ' . $selected_class . '" id="' . $temp_id . '" style="width: 70px; height: 70px; display: inline-block;margin-right:5px;" src="' . $featured_img[0] . '">';
			}
		}
		/////////////////////////////////////////////////////////////////////////////
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$use_new_page_layout = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_new_gift_card_page_layout' );


		if ('' == $use_new_page_layout ){

				if ( isset( $wps_wgm_hide_giftcard_thumbnail ) && 'on' !== $wps_wgm_hide_giftcard_thumbnail ) {
					$wps_additional_section .= '<div class="wps_wgm_selected_template" style="display: inline-block; text-decoration: none; padding-right:20px;">' . $assigned_temp . '</div>';
				}
		}
		////////////////////////////////////////////// changes done for layout //////////////////////////////////////////////////////////////
		
		if ('on' == $use_new_page_layout){
						$wps_additional_section .= "<div class='wps_wgm_selected_template_wrapper'>";
						if ( isset( $wps_wgm_hide_giftcard_thumbnail ) && 'on' !== $wps_wgm_hide_giftcard_thumbnail ) {
							$wps_additional_section .= '<div class="wps_wgm_selected_template" style="display: inline-block; text-decoration: none; padding-right:20px;">' . $assigned_temp .'</div>';
						}
						$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
						$other_settings = get_option( 'wps_wgm_other_settings', array() );
						$wps_uwgc_browse_image = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_other_setting_browse' );
						if ( isset( $wps_uwgc_browse_image ) && 'on' == $wps_uwgc_browse_image ) {
							$wps_additional_section .= '
							<div class="wps_demo_browse">
								<label for="wps_uwgc_browse_img" class="wps-custom-file-upload">
								<span class="wps-gc__upload-icon">'. __('+','giftware') . '<div>'. __('Upload','giftware') . '</div></span>
									<input type="file" name="wps_uwgc_browse_img" id="wps_uwgc_browse_img" class="wps_uwgc_browse_img" />
									<img id="wps_wgm_browse_src">
									<span class="selected-file-name-span"></span>
								</label>
							</div>';
					}
					$wps_additional_section .= "</div>";
		}
		////////////////////////////////////////////// changes done for layout //////////////////////////////////////////////////////////////
		$wps_return_value['choosen_temp_id'] = $choosed_temp;
		$wps_return_value['html'] = $wps_additional_section;
		return $wps_return_value;

	}

	/**
	 * This function is used to send sms notification via twilio.
	 *
	 * @param array  $wps_wgm_common_arr array.
	 * @param object $order order.
	 * @name wps_wgm_send_gc_sms_via_twilio
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_send_gc_sms_via_twilio( $wps_wgm_common_arr, $order ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_notification_settings = get_option( 'wps_wgm_notification_settings', array() );
		$wps_wgm_enable_sms_notification = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_enable_sms_notification' );
		$contact_no = '';
		$item_id = '';
		$to = '';
		$from = '';
		$message = '';
		$coupon = '';
		$order_id = $order->get_id();
		if ( array_key_exists( 'contact_no', $wps_wgm_common_arr ) ) {
			$contact_no = $wps_wgm_common_arr['contact_no'];
		}
		if ( array_key_exists( 'delivery_method', $wps_wgm_common_arr ) ) {
			$delivery_method = $wps_wgm_common_arr['delivery_method'];
		} else {
			$delivery_method = 'Mail to recipient';
		}
		if ( array_key_exists( 'item_id', $wps_wgm_common_arr ) ) {
			$item_id = $wps_wgm_common_arr['item_id'];
		}
		if ( array_key_exists( 'to_name', $wps_wgm_common_arr ) ) {
			$to = $wps_wgm_common_arr['to_name'];
		} elseif ( array_key_exists( 'to', $wps_wgm_common_arr ) ) {
			$to = $wps_wgm_common_arr['to'];
		}
		if ( array_key_exists( 'from', $wps_wgm_common_arr ) ) {
			$from = $wps_wgm_common_arr['from'];
		}
		if ( array_key_exists( 'gift_msg', $wps_wgm_common_arr ) ) {
			$message = $wps_wgm_common_arr['gift_msg'];
		}
		if ( array_key_exists( 'product_id', $wps_wgm_common_arr ) ) {
			$product_id = $wps_wgm_common_arr['product_id'];
		}
		$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
		if ( '' == $itemgiftsend ) {
			$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#giftcard_send", true );
		}
		if ( '' !== $wps_wgm_enable_sms_notification ) {
			if ( '' !== $contact_no ) {
				$wps_wgm_whatsapp_message = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_whatsapp_message' );
				if ( '' == $wps_wgm_whatsapp_message ) {
					$wps_wgm_whatsapp_message = __(
						'Hello [TO],
					[MESSAGE] 
					You have received a gift card from  [FROM]
					Coupon code : [COUPONCODE]
					Amount : [AMOUNT]
					Expiry Date : [EXPIRYDATE]',
						'giftware'
					);
				}
				$wps_wgm_whatsapp_message = preg_replace( '/\s*$^\s*/m', "\n", $wps_wgm_whatsapp_message );
				$wps_wgm_whatsapp_message = preg_replace( '/[ \t]+/', ' ', $wps_wgm_whatsapp_message );
				if ( isset( $delivery_method ) && 'Shipping' !== $delivery_method ) {
					$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
					if ( empty( $gift_couponnumber ) ) {
						$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$product_id", true );
					}
					foreach ( $gift_couponnumber as $key => $value ) {
						$coupon = $value;
						$the_coupon = new WC_Coupon( $value );
					}
					$expiry_date_timestamp = $the_coupon->get_date_expires();
					$couponamont = $the_coupon->get_amount();
					if ( empty( $expiry_date_timestamp ) ) {
						$expirydate_format = __( 'No Expiration', 'giftware' );
					} else {
						$expiry_date_timestamp = strtotime( $expiry_date_timestamp );
						$expirydate = date_i18n( 'Y-m-d', $expiry_date_timestamp );
						$expirydate_format = date_create( $expirydate );
						$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
						$wps_general_settings = get_option( 'wps_wgm_general_settings', array() );
						$selected_date = $wps_public_obj->wps_wgm_get_template_data( $wps_general_settings, 'wps_wgm_general_setting_enable_selected_format' );
						if ( isset( $selected_date ) && null !== $selected_date && '' !== $selected_date ) {
							$expirydate_format = gmdate( $selected_date, $expiry_date_timestamp );
						} else {
							$expirydate_format = date_format( $expirydate_format, 'jS M Y' );
						}
					}
					if ( 'send' == $itemgiftsend ) {
						$coupon_amount = $couponamont . ' ' . get_woocommerce_currency();
						$wps_wgm_whatsapp_message = str_replace( '[TO]', $to, $wps_wgm_whatsapp_message );
						$wps_wgm_whatsapp_message = str_replace( '[MESSAGE]', $message, $wps_wgm_whatsapp_message );
						$wps_wgm_whatsapp_message = str_replace( '[FROM]', $from, $wps_wgm_whatsapp_message );
						$wps_wgm_whatsapp_message = str_replace( '[COUPONCODE]', $coupon, $wps_wgm_whatsapp_message );
						$wps_wgm_whatsapp_message = str_replace( '[AMOUNT]', $coupon_amount, $wps_wgm_whatsapp_message );
						$wps_wgm_whatsapp_message = str_replace( '[EXPIRYDATE]', $expirydate_format, $wps_wgm_whatsapp_message );
						/*sms notify */
						$send_contact = '+' . $contact_no;
						$username = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_account_sid' );
						$password = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_auth_token' );
						$send_sms_from = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_twilio_number' );
						$wps_enable_pdf_link = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_share_pdf_link' );
						$other_settings = get_option( 'wps_wgm_other_settings', array() );

						if ( isset( $username ) && '' !== $username && isset( $password ) && '' !== $password ) {
							$url = 'https://api.twilio.com/2010-04-01/Accounts/' . $username . '/Messages.json';
							$ch = curl_init();

							if ( isset( $other_settings['wps_wgm_addition_pdf_enable'] ) && 'on' == $other_settings['wps_wgm_addition_pdf_enable'] && 'on' == $wps_enable_pdf_link ) {
								$dwnld_pdf = ( esc_attr( WPS_UWGC_UPLOAD_URL ) . '/giftcard_pdf/giftcard' . $order_id . $coupon . '.pdf' );
								$curl_data = array(
									'From' => $send_sms_from,
									'Body' => __( $wps_wgm_whatsapp_message . 'PDF Link : ' . $dwnld_pdf, 'giftware' ),
									'To' => $send_contact,
								);
							} else {
								$curl_data = array(
									'From' => $send_sms_from,
									'Body' => __( $wps_wgm_whatsapp_message, 'giftware' ),
									'To' => $send_contact,
								);
							}

							curl_setopt( $ch, CURLOPT_URL, $url );
							curl_setopt( $ch, CURLOPT_TIMEOUT, 30 ); // timeout after 30 seconds.
							curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
							curl_setopt( $ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY );
							curl_setopt( $ch, CURLOPT_POSTFIELDS, $curl_data );
							curl_setopt( $ch, CURLOPT_USERPWD, "$username:$password" );
							$response = curl_exec( $ch );
							$response = json_decode( $response );
							$status_code = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
							if ( $status_code == 201 ) {
								$note = __( 'Gift Card SMS has been sent.', 'giftware' );
								$order->add_order_note( $note );
							}
						}
					}
				}
			}
		}
	}

	/**
	 * This function is used to initiate gc refund process.
	 *
	 * @param int    $order_id order_id.
	 * @param string $old_status old_status.
	 * @param string $new_status new_status.
	 * @name wps_wgm_initiate_refund_gc
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_wgm_initiate_refund_gc( $order_id, $old_status, $new_status ) {
		$wps_wgc_enable = wps_wgm_giftcard_enable();
		$gc_item_in_order = 0;
		if ( $wps_wgc_enable ) {
			if ( $old_status != $new_status ) {
				if ( ( 'processing' == $old_status || 'completed' == $old_status ) &&
					( 'refunded' == $new_status || 'cancelled' == $new_status ) ) {
					$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
					$woo_ver = WC()->version;
					$order = wc_get_order( $order_id );
					$order_total_quantity = $order->get_item_count();
					// The loop to get the order items which are WC_Order_Item_Product objects since WC 3+.
					$woo_ver = WC()->version;
					foreach ( $order->get_items() as $item_id => $item ) {
						if ( $woo_ver < '3.0.0' ) {
							$_product = $order->get_product_from_item( $item );
							$product_id = $_product->id;
						} else {
							$_product = $item->get_product();
							if ( ! empty( $_product ) ) {
								$product_id = $_product->get_id();
							}
						}
						if ( isset( $product_id ) && ! empty( $product_id ) ) {
							$product_types = wp_get_object_terms( $product_id, 'product_type' );
							if ( isset( $product_types[0] ) ) {
								$product_type = $product_types[0]->slug;
								if ( 'wgm_gift_card' == $product_type ) {
									$gc_item_in_order++;
								}
							}
						}
					}
					if ( $gc_item_in_order === $order_total_quantity ) {
						foreach ( $order->get_items() as $item_id => $item ) {
							$giftcoupon = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
							if ( isset( $giftcoupon ) && ! empty( $giftcoupon ) ) {
								foreach ( $giftcoupon as $key => $value ) {
									global $woocommerce;
									$coupon_data = new WC_Coupon( $value );
									$coupon_usage = $coupon_data->get_usage_count();
									$coupon_amount = $coupon_data->get_amount();
									$expiry_date_timestamp = $coupon_data->get_date_expires();

									if ( empty( $expiry_date_timestamp ) ) {
										$expirydiff = 1;
									} else {
										$expiry_date_timestamp = strtotime( $expiry_date_timestamp );
										$timestamp = strtotime( gmdate( 'Y-m-d' ) );
										$expirydiff = $expiry_date_timestamp - $timestamp;
									}
									$coupon_original_amount = get_post_meta( $coupon_data->get_id(), 'wps_wgm_coupon_amount', true );
									if ( 0 == $coupon_usage && isset( $coupon_original_amount ) && $coupon_amount == $coupon_original_amount && 0 < $expirydiff ) {
										update_post_meta( $coupon_data->get_id(), 'coupon_amount', 0 );
										update_post_meta( $coupon_data->get_id(), 'date_expires', $timestamp );
									}
								}
							}
						}
					}
				}
			}
		}
	}

	/**
	 * This function is used to set discount price on cart.
	 *
	 * @name wps_mini_cart_product_product_discount_price
	 * @param string $html price html.
	 * @param array  $cart_item cart_item.
	 * @param string $cart_item_key cart_item_key.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_mini_cart_product_product_discount_price( $html, $cart_item, $cart_item_key ) {
		$new_price = $html;
		if ( isset( $cart_item['product_meta']['meta_data']['wps_wgm_price'] ) && ! empty( $cart_item['product_meta']['meta_data']['wps_wgm_price'] ) ) {
			$product_id = $cart_item['product_id'];
			$gift_price = $cart_item['product_meta']['meta_data']['wps_wgm_price'];
			$wps_wgm_discount_data = $this->wps_uwgc_common_discount_function( $product_id );

			$discount_min = $wps_wgm_discount_data['discount_min'];
			$discount_max = $wps_wgm_discount_data['discount_max'];
			$discount_type = $wps_wgm_discount_data['discount_type'];
			$discount_value = $wps_wgm_discount_data['discount_value'];
			$discount_applicable = false;
			if ( isset( $wps_wgm_discount_data['discount_enable'] ) && 'on' == $wps_wgm_discount_data['discount_enable'] ) {
				if ( isset( $wps_wgm_discount_data['wps_wgm_discount'] ) && 'yes' == $wps_wgm_discount_data['wps_wgm_discount'] ) {

					if ( isset( $discount_min ) && null !== $discount_min && isset( $discount_max ) && null !== $discount_max && isset( $discount_value ) && null !== $discount_value ) {

						foreach ( $discount_min as $key => $values ) {

							if ( $discount_min[ $key ] <= $gift_price && $gift_price <= $discount_max[ $key ] ) {

								if ( 'Percentage' == $discount_type ) {
									$new_price = $gift_price - ( $gift_price * $discount_value[ $key ] ) / 100;
								} else {
									$new_price = $gift_price - $discount_value[ $key ];
								}
							}
						}
					}
				}
			}
		}
		$gift_price = apply_filters( 'wps_uwgc_minicart_discount_price', $new_price, $product_id );
		if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
			if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
				$gift_price = wcpbc_the_zone()->get_exchange_rate_price( $gift_price );
			}
		} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
			$gift_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $gift_price );
		}
		$gift_price = str_replace( ',', '.', $gift_price );
		$gift_price = wc_price( $gift_price );
		return $gift_price;
	}

	/**
	 * Set coupon meta for product as a gift.
	 *
	 * @name wps_set_coupon_meta_for_product_as_a_gift
	 * @param int $order_id order_id.
	 * @param int $item_id item_id.
	 * @param int $new_coupon_id new_coupon_id.
	 * @param int $product_id product_id.
	 * @author WP Swings <webmaster@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	public function wps_set_coupon_meta_for_product_as_a_gift( $order_id, $item_id, $new_coupon_id, $product_id ) {
		$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
		if ( isset( $wps_gift_product ) && 'on' === $wps_gift_product ) {
			update_post_meta( $new_coupon_id, 'individual_use', 'yes' );
			update_post_meta( $new_coupon_id, 'product_ids', $product_id );
			update_post_meta( $new_coupon_id, 'usage_limit', '1' );
			update_post_meta( $new_coupon_id, 'minimum_amount', '' );
			update_post_meta( $new_coupon_id, 'maximum_amount', '' );
			update_post_meta( $new_coupon_id, 'exclude_sale_items', 'on' );
			update_post_meta( $new_coupon_id, 'exclude_product_ids', '' );
			update_post_meta( $new_coupon_id, 'exclude_product_categories', '' );
		}
	}

	/**
	 * Enable purchase product as a gift.
	 *
	 * @param array $wps_product product details.
	 * @return void
	 * @since 1.0.0
	 * @name wps_wgm_apply_already_created_giftcard_coupons
	 * @authorWP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_enable_sell_as_a_gc( $wps_product ) {
		$other_settings = get_option( 'wps_wgm_other_settings', array() );

		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$use_new_page_layout = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_new_gift_card_page_layout' );
		if ( '' === $wps_product ) {
			global $product;
			$product_id = $product->get_id();
		} else {
			$product_id = $wps_product;
		}
		$sell_as_a_giftcard = get_post_meta( $product_id, '_sell_as_a_giftcard' );
		if ( isset( $sell_as_a_giftcard[0] ) && 'yes' === $sell_as_a_giftcard[0] ) {

			if ('on' == $use_new_page_layout ){
				echo '<input type="checkbox" class="wps_gift_this_product" id="wps_gift_this_product" name="wps_gift_this_product" data-product="' . esc_html( $product->get_id() ) . '" value="on">
				<label for="wps_gift_this_product">' . __( 'Gift This Product', 'giftware' ) . '</label><br><br>';
			}else {
				echo '<input type="checkbox" id="wps_gift_this_product" name="wps_gift_this_product" data-product="' . esc_html( $product->get_id() ) . '" value="on">
				<label for="wps_gift_this_product">' . __( 'Gift This Product', 'giftware' ) . '</label><br><br>';
			}

			
		}

		?>
		<div id="wps_purchase_as_a_gc"></div>
		<?php
		return '';
	}

	/**
	 * This function take the product array and return product id.
	 *
	 * @param object $product product.
	 * @return int $product_id
	 * @since 1.0.0
	 * @name wps_ajax_product_as_a_gift
	 * @authorWP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_ajax_product_as_a_gift( $product ) {

		$product_id = $product->get_id();
		$price      = get_post_meta( $product_id, '_price', true );

		$params   = array(
			'post_type'   => 'giftcard',
			'post_status' => 'publish',
			'posts_per_page' => -1,
		);
		$wc_query = new WP_Query( $params );

		while ( $wc_query->have_posts() ) {
			$wc_query->the_post();
			if ( get_the_title() === 'Purchase as a Gift' ) {
				$temp_id = get_the_ID();
			}
		}

		$details = array(
			'default_price'  => $price,
			'type'           => 'wps_wgm_default_price',
			'template'       => array( $temp_id ),
			'by_default_tem' => $temp_id,
		);

		update_post_meta( $product_id, 'wps_wgm_pricing_details', $details );

		return $product_id;
	}

	/**
	 * This function tells whether a order item is purchase as a gift or not
	 *
	 * @param object $item item.
	 * @param int    $item_id item_id.
	 * @param int    $order_id order.
	 * @return string
	 * @since 1.0.0
	 * @name wps_update_item_meta_as_a_gift
	 * @authorWP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_update_item_meta_as_a_gift( $item, $item_id, $order_id ) {
		$data = $item->get_meta_data();
		foreach ( $data as $k => $val ) {
			foreach ( $val->get_data() as $key => $value ) {
				if ( 'Purchase as a Gift' === $value ) {
					wps_wgm_hpos_update_meta_data( $order_id, 'sell_as_a_gc' . $item_id, 'on' );
				}
			}
		}
		$wps_gift_product = wps_wgm_hpos_get_meta_data( $order_id, 'sell_as_a_gc' . $item_id, true );
		return $wps_gift_product;
	}

	/**
	 * This function is used to stop reduction of stock quantity of sell as a gift
	 *
	 * @param object $order order.
	 * @return void
	 * @since 1.0.0
	 * @name wps_stop_reduce_order_stock_for_sell_as_a_gift
	 * @authorWP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_stop_reduce_order_stock_for_sell_as_a_gift( $order ) {
		$order_id = $order->get_id();
		foreach ( $order->get_items() as $item_id => $item ) {
			$product = $item->get_product();

			$item_quantity = wc_get_order_item_meta( $item_id, '_qty', true );

			$wps_gift_product = apply_filters( 'wps_wgm_update_item_meta_as_a_gift', $item, $item_id, $order_id );

			if ( isset( $wps_gift_product ) && 'on' === $wps_gift_product ) {
				$pro_id = $product->get_id();
				if ( 'yes' === get_post_meta( $pro_id, '_manage_stock', true ) ) {
					$stock = ( get_post_meta( $pro_id, '_stock', true ) );
					update_post_meta( $pro_id, '_stock', $stock + $item_quantity );
				}
			}
		}
	}

	/**
	 * Adding dynamically GC form for Purchase as a gift.
	 *
	 * @return void
	 * @since 1.0.0
	 * @name wps_cart_form_for_product_as_a_gift
	 * @authorWP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_cart_form_for_product_as_a_gift() {

		if ( isset( $_REQUEST['wps_gc_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_REQUEST['wps_gc_nonce'] ) ), 'wps-gc-verify-nonce' ) ) {
			if ( isset( $_POST['wps_product'] ) ) {

				$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();

				$product_id = sanitize_text_field( wp_unslash( $_POST['wps_product'] ) );
				$product    = wc_get_product( $product_id );

				$product_id = apply_filters( 'wps_wgm_ajax_product_as_a_gift', $product );

				$sell_as_a_giftcard = get_post_meta( $product_id, '_sell_as_a_giftcard' );

				if ( isset( $product ) && ! empty( $product ) ) {
					$wps_wgc_enable = wps_wgm_giftcard_enable();
					if ( $wps_wgc_enable && isset( $sell_as_a_giftcard[0] ) && 'yes' === $sell_as_a_giftcard[0] ) {
						if ( isset( $product_id ) && ! empty( $product_id ) ) {
							$cart_html = '';
							$wps_additional_section = '';
							$product_pricing = get_post_meta( $product_id, 'wps_wgm_pricing_details', true );
							if ( isset( $product_pricing ) && ! empty( $product_pricing ) ) {
								$cart_html .= '<div class="wps_wgm_added_wrapper" id="wps_product_as_a_gift_form">';
								wp_nonce_field( 'wps_wgm_single_nonce', 'wps_wgm_single_nonce_field' );
								if ( isset( $product_pricing['type'] ) ) {
									$product_pricing_type = $product_pricing['type'];
									if ( 'wps_wgm_range_price' == $product_pricing_type ) {
										$default_price = $product_pricing['default_price'];
										$from_price = $product_pricing['from'];
										$to_price = $product_pricing['to'];
										$text_box_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
											// hooks for discount features.
										do_action( 'wps_wgm_range_price_discount', $product, $product_pricing, $text_box_price );

										if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
											if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
												$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
												$to_price = wcpbc_the_zone()->get_exchange_rate_price( $to_price );
												$from_price = wcpbc_the_zone()->get_exchange_rate_price( $from_price );
											}
											$wps_new_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
											$cart_html .= '<p class="wps_wgm_section selected_price_type">
												<label>' . __( 'Enter Price Within Above Range', 'giftware' ) . '</label>	
												<input type="text" class="input-text wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $wps_new_price . '" max="' . $to_price . '" min="' . $from_price . '">
												</p>';
										} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
											$default_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
											$to_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $to_price );
											$from_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $from_price );
											$wps_new_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
											$cart_html .= '<p class="wps_wgm_section selected_price_type">
												<label>' . __( 'Enter Price Within Above Range', 'giftware' ) . '</label>	
												<input type="text" class="input-text wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $wps_new_price . '" max="' . $to_price . '" min="' . $from_price . '">
												</p>';
										} else {
											$wps_new_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
											$cart_html .= '<p class="wps_wgm_section selected_price_type">
												<label>' . __( 'Enter Price Within Above Range', 'giftware' ) . '</label>	
												<input type="text" class="input-text wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $wps_new_price . '" max="' . $to_price . '" min="' . $from_price . '">
												</p>';
										}
									}
									if ( 'wps_wgm_default_price' == $product_pricing_type ) {
										$default_price = $product_pricing['default_price'];
										$cart_html .= '<input type="hidden" class="wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $default_price . '">';
											// hooks for discount features.
										do_action( 'wps_wgm_default_price_discount', $product, $product_pricing );
									}
									if ( 'wps_wgm_selected_price' == $product_pricing_type ) {
										$default_price = $product_pricing['default_price'];
										$selected_price = $product_pricing['price'];
										if ( ! empty( $selected_price ) ) {
											$label = __( 'Choose Gift Card Selected Price: ', 'giftware' );
											$cart_html .= '<p class="wps_wgm_section selected_price_type">
														<label class="wps_wgc_label">' . $label . '</label><br/>';
												$selected_prices = explode( '|', $selected_price );
											if ( isset( $selected_prices ) && ! empty( $selected_prices ) ) {
												$cart_html .= '<select name="wps_wgm_price" class="wps_wgm_price" id="wps_wgm_price" >';
												foreach ( $selected_prices as $price ) {
													if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {

														if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
															$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
															$prices = wcpbc_the_zone()->get_exchange_rate_price( $price );
															if ( $prices == $default_price ) {
																$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $prices ) . '</option>';
															} else {
																$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $prices ) . '</option>';
															}
														} else {
															if ( $price == $default_price ) {
																$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $price ) . '</option>';
															} else {
																$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $price ) . '</option>';
															}
														}
													} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
														$default_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
														$prices = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $price );
														if ( $prices == $default_price ) {
															$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $prices ) . '</option>';
														} else {
															$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $prices ) . '</option>';
														}
													} else {
														if ( $price == $default_price ) {
															$cart_html .= '<option  value="' . $price . '" selected>' . wc_price( $price ) . '</option>';
														} else {
															$cart_html .= '<option  value="' . $price . '">' . wc_price( $price ) . '</option>';
														}
													}
												}
												$cart_html .= '</select>';
											}
												$cart_html .= '</p>';
										}
									}
									if ( 'wps_wgm_user_price' == $product_pricing_type ) {
										$default_price = $product_pricing['default_price'];
											// hooks for discount features.
										do_action( 'wps_wgm_user_price_discount', $product, $product_pricing );
											// price based on country.
										if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
											$default_price = $product_pricing['default_price'];
											if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
												$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
											}
											$cart_html .= '<p class="wps_wgm_section selected_price_type"">
												<label class="wps_wgc_label">' . __( 'Enter Gift Card Price : ', 'giftware' ) . '</label>	
												<input type="text" class="wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" min="1" value = ' . $default_price . '>
												</p>';
										} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
											$default_price = $product_pricing['default_price'];
											$default_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
											$cart_html .= '<p class="wps_wgm_section selected_price_type"">
												<label class="wps_wgc_label">' . __( 'Enter Gift Card Price : ', 'giftware' ) . '</label>	
												<input type="text" class="wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" min="1" value = ' . $default_price . '>
												</p>';
										} else {
											$cart_html .= '<p class="wps_wgm_section selected_price_type"">
												<label class="wps_wgc_label">' . __( 'Enter Gift Card Price : ', 'giftware' ) . '</label>	
												<input type="text" class="wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" min="1" value = ' . $default_price . '>
												</p>';
										}
									}
									$cart_html .= apply_filters( 'wps_wgm_add_price_types', $wps_additional_section, $product, $product_pricing );
								}
								$cart_html .= '<p class="wps_wgm_section wps_from">
								<label class="wps_wgc_label">' . __( 'From', 'giftware' ) . '</label>	
								<input type="text"  name="wps_wgm_from_name" id="wps_wgm_from_name" class="wps_wgm_from_name" placeholder="' . __( 'Enter the sender name', 'giftware' ) . '" required="required">
								</p>';
								$mail_settings = get_option( 'wps_wgm_mail_settings', array() );
								$default_giftcard_message = $wps_public_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_default_message' );
								$cart_html .= '<p class="wps_wgm_section wps_message">
								<label class="wps_wgc_label">' . __( 'Gift Message ', 'giftware' ) . '</label>	
								<textarea name="wps_wgm_message" id="wps_wgm_message" class="wps_wgm_message">' . $default_giftcard_message . '</textarea>';
								$giftcard_message_length = $wps_public_obj->wps_wgm_get_template_data( $mail_settings, 'wps_wgm_mail_setting_giftcard_message_length' );
								if ( '' == $giftcard_message_length ) {
									$giftcard_message_length = 300;
								}
								$cart_html .= '<span class = "wps_wgm_message_length" >';
								$cart_html .= __( 'Characters: ( ', 'giftware' ) . '<span class="wps_box_char">0</span>/' . $giftcard_message_length . ')</span>							
								</p>';
								$cart_html .= apply_filters( 'wps_wgm_add_notiication_section', $wps_additional_section, $product_id );
								$delivery_settings = get_option( 'wps_wgm_delivery_settings', true );
								$wps_wgm_delivery_setting_method = $wps_public_obj->wps_wgm_get_template_data( $delivery_settings, 'wps_wgm_send_giftcard' );
								if ( ! wps_uwgc_pro_active() ) {
									if ( 'customer_choose' == $wps_wgm_delivery_setting_method || 'shipping' == $wps_wgm_delivery_setting_method ) {
										$wps_wgm_delivery_setting_method = 'Mail to recipient';
									}
								}
									$cart_html .= '<div class="wps_wgm_section wps_delivery_method">';
										$cart_html .= '<label class = "wps_wgc_label">' . __( 'Delivery Method', 'giftware' ) . '</label>';
								if ( ( isset( $wps_wgm_delivery_setting_method ) && 'Mail to recipient' == $wps_wgm_delivery_setting_method ) || ( '' == $wps_wgm_delivery_setting_method ) ) {
									$cart_html .= '<div class="wps_wgm_delivery_method">
												<input type="radio" name="wps_wgm_send_giftcard" value="Mail to recipient" class="wps_wgm_send_giftcard" checked="checked" id="wps_wgm_to_email_send" >
												<span class="wps_wgm_method">' . __( 'Mail To Recipient', 'giftware' ) . '</span>
												<div class="wps_wgm_delivery_via_email">
													<input type="text"  name="wps_wgm_to_email" id="wps_wgm_to_email" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Email', 'giftware' ) . '">
													<input type="text"  name="wps_wgm_to_name_optional" id="wps_wgm_to_name_optional" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
													<span class= "wps_wgm_msg_info">' . __( 'We will send it to the recipient\'s email address', 'giftware' ) . '</span>
												</div>
											</div>';
								}
								if ( isset( $wps_wgm_delivery_setting_method ) && 'Downloadable' == $wps_wgm_delivery_setting_method ) {
									$cart_html .= '<div class="wps_wgm_delivery_method">
												<input type="radio" name="wps_wgm_send_giftcard" value="Downloadable" class="wps_wgm_send_giftcard" checked="checked" id="wps_wgm_send_giftcard_download">
												<span class="wps_wgm_method">' . __( 'You Print & Give To Recipient', 'giftware' ) . '</span>
												<div class="wps_wgm_delivery_via_buyer">
													<input type="text"  name="wps_wgm_to_email_name" id="wps_wgm_to_download" class="wps_wgm_to_email" placeholder="' . __( 'Enter the Recipient Name', 'giftware' ) . '">
													<span class= "wps_wgm_msg_info">' . __( 'After Checkout, you can print your gift card', 'giftware' ) . '</span>
												</div>
											</div>';
								}
								$cart_html .= apply_filters( 'wps_wgm_add_delivery_method', $wps_additional_section, $product_id );
								$cart_html .= '</div>';
								$cart_html .= apply_filters( 'wps_wgm_add_section_after_delivery', $wps_additional_section, $product_id );
								$wps_wgm_pricing = get_post_meta( $product_id, 'wps_wgm_pricing_details', true );
								if ( array_key_exists( 'template', $wps_wgm_pricing ) ) {
									$templateid = $wps_wgm_pricing['template'];
								} else {
									$templateid = $wps_public_obj->wps_get_org_selected_template();
								}
								$choosed_temp = '';
								if ( ! wps_uwgc_pro_active() ) {
									if ( '1' < count( $templateid ) ) {
										$wps_get_pro_templates = get_option( 'wps_uwgc_templateid', array() );
										if ( ! empty( $wps_get_pro_templates ) ) {
											$wps_get_lite_temp = array_diff( $templateid, $wps_get_pro_templates );
											if ( ! empty( $wps_get_lite_temp ) ) {
												$wps_index = array_keys( $wps_get_lite_temp )[0];
												if ( 0 !== count( $wps_get_lite_temp ) ) {
													$choosed_temp = $wps_get_lite_temp[ $wps_index ];
												}
											} else {
												$args = array(
													'post_type' => 'giftcard',
													'posts_per_page' => -1,
												);
												$loop = new WP_Query( $args );
												$template = array();
												foreach ( $loop->posts as $key => $value ) {
													$template_id = $value->ID;
													$template_title = $value->post_title;
													$template[ $template_id ] = $template_title;
												}
												if ( ! empty( $template ) ) {
													$wps_get_lite_temp = array_diff( array_keys( $template ), $wps_get_pro_templates );
													$wps_index = array_keys( $wps_get_lite_temp )[0];
													if ( 0 !== count( $wps_get_lite_temp ) ) {
														$choosed_temp = $wps_get_lite_temp[ $wps_index ];
													}
												}
											}
										} else {
											$choosed_temp = $templateid[0];
										}
									} else {
										$choosed_temp = $templateid[0];
									}
								}

								$cart_html .= '<input name="add-to-cart" value="' . $product_id . '" type="hidden" class="wps_wgm_hidden_pro_id">';
								if ( is_array( $templateid ) && ! empty( $templateid ) ) {
									$cart_html .= '<input name="wps_wgm_selected_temp" id="wps_wgm_selected_temp" value="' . $choosed_temp . '" type="hidden">';
								}
								$other_settings = get_option( 'wps_wgm_other_settings', array() );
								$wps_wgm_preview_disable = $wps_public_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_additional_preview_disable' );

								if ( empty( $wps_wgm_preview_disable ) ) {
									$cart_html .= '<span class="mwg_wgm_preview_email"><a id="mwg_wgm_preview_email" href="javascript:void(0);">' . __( 'PREVIEW', 'giftware' ) . '</a></span>';
								}
								$cart_html .= apply_filters( 'wps_wgm_after_preview_section', $wps_additional_section, $product_id );
								$cart_html .= '</div>';
							}
							// @codingStandardsIgnoreStart.
							$wps_admin_obj = new Woocommerce_Gift_Cards_Common_Function();
							$allowed_tags = $wps_admin_obj->wps_allowed_html_tags();
							echo wp_kses( $cart_html, $allowed_tags );
							// @codingStandardsIgnoreEnd.
							wp_die();
						}
					}
				}
			}
		}
	}

	/**
	 * Apply Coupon through Coupon url.
	 *
	 * @return void
	 * @since 3.3.0
	 * @name wps_uwgc_apply_coupon_through_url
	 * @authorWP Swings <webmaster@wpswings.com>
	 * @link https://www.wpswings.com/
	 */
	public function wps_uwgc_apply_coupon_through_url() {
		if ( isset( $_GET['wps_giftcard_code'] ) && ! empty( $_GET['wps_giftcard_code'] ) ) {
			$wps_giftcard_code = sanitize_text_field( wp_unslash( $_GET['wps_giftcard_code'] ) );
			if ( isset( $wps_giftcard_code ) && ! empty( $wps_giftcard_code ) ) {
				WC()->cart->add_discount( $wps_giftcard_code );
			}
		}
	}

	/**
	 * Is_addon_active.
	 *
	 * @return boolean
	 */
	public function is_addon_active() {
		return apply_filters( 'wps_wgm_is_addon_active', false );
	}

	/**
	 * Add new price type Selected with price range.
	 */
	public function wps_uwgc_add_price_types( $wps_additional_section, $product, $product_pricing ) {
		$wps_additional_section = '';
		$product_pricing_type = $product_pricing['type'];
		if ( 'wps_wgm_selected_with_price_range' === $product_pricing_type ) {
			$default_price  = $product_pricing['default_price'];
			$from_price     = $product_pricing['from'];
			$to_price       = $product_pricing['to'];
			$selected_price = $product_pricing['price'];
			$text_box_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
				// hooks for discount features.
			do_action( 'wps_wgm_selected_with_price_range_discount', $product, $product_pricing, $text_box_price );

			if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
				if ( wcpbc_the_zone() !== null && wcpbc_the_zone() ) {
					$default_price = wcpbc_the_zone()->get_exchange_rate_price( $default_price );
					$to_price      = wcpbc_the_zone()->get_exchange_rate_price( $to_price );
					$from_price    = wcpbc_the_zone()->get_exchange_rate_price( $from_price );
				}
				$wps_new_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
				$wps_additional_section    .= '<p class="wps_wgm_section selected_price_type">
					<label>' . __( 'Set your own Amount within above range', 'giftware' ) . '</label>	
					<input type="text" class="input-text wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $wps_new_price . '" max="' . $to_price . '" min="' . $from_price . '">
					</p>';
			} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
				$default_price = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $default_price );
				$to_price      = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $to_price );
				$from_price    = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $from_price );
				$wps_new_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
				$wps_additional_section    .= '<p class="wps_wgm_section selected_price_type">
					<label>' . __( 'Set your own Amount within above range', 'giftware' ) . '</label>	
					<input type="text" class="input-text wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $wps_new_price . '" max="' . $to_price . '" min="' . $from_price . '">
					</p>';
			} else {
				$wps_new_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;
				$wps_additional_section    .= '<p class="wps_wgm_section selected_price_type">
					<label>' . __( 'Set your own Amount within above range', 'giftware' ) . '</label>	
					<input type="text" class="input-text wps_wgm_price" id="wps_wgm_price" name="wps_wgm_price" value="' . $wps_new_price . '" max="' . $to_price . '" min="' . $from_price . '">
					</p>';
			}
			if ( ! empty( $selected_price ) ) {
				$selected_prices = explode( '|', $selected_price );
				$wps_additional_section .= '<p class="wps-uwgc-choose-amount" style="padding-bottom: 5px;">
												<label class="wps_uwgc_label">' . __( 'or Select from popular amounts', 'giftware' ) . '</label><br>';
					
				foreach ( $selected_prices as $price ) {
					if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {  // for price based on country.
						if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
							$prices      = wcpbc_the_zone()->get_exchange_rate_price( $price );
							$wps_additional_section .= '<input type="button" class="wps_uwgc_price_button" value="' . $price . '">';
						}
					} elseif ( function_exists( 'wps_mmcsfw_admin_fetch_currency_rates_from_base_currency' ) ) {
						$prices      = wps_mmcsfw_admin_fetch_currency_rates_from_base_currency( '', $price );
						$wps_additional_section .= '<input type="button" class="wps_uwgc_price_button" value="' . $prices . '">';
					} else {
						$wps_additional_section .= '<input type="button" class="wps_uwgc_price_button" value="'.get_woocommerce_currency_symbol() . $price . '">';
					}
				}
				$wps_additional_section .= '</p>';
			}
		}
		return $wps_additional_section;
	}

	/**
	 * wps_uwgc_after_preview_section
	 */
	public function wps_uwgc_after_preview_section( $wps_additional_section, $product_id ) {
		$wps_additional_section = '';
		$wps_additional_section = '<div class="wps_wgm_quantity_one_per_recipient">
										<div class="wps_wgc_label">' . __( 'Quantity', 'giftware' ) . ': <span class="wps_wgm_recipient_count">1</span></div>
										<div class="wps_wgm_subtitle">' . __( '1 to each recipient', 'giftware' ) . '</div>
									</div>';
		return $wps_additional_section;
	}

	/**
	 * Change the Quantity according to receiver email.
	 */
	public function wps_wgm_woocommerce_add_cart_item( $cart_item ) {
		$product_id = isset( $cart_item['product_id'] ) ? $cart_item['product_id'] : '';
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$is_group_product = get_post_meta( $product_id, 'wps_wgm_is_group_gift', true );
		$genaral_settings = get_option( 'wps_wgm_general_settings', array() );
		$enable_sent_multiple_gc = $wps_public_obj->wps_wgm_get_template_data( $genaral_settings, 'wps_wgm_general_setting_enable_sent_multiple_giftcard' );
		$is_imported_product = get_post_meta( $product_id, 'is_imported', true );

		if ( isset( $cart_item['product_meta']['meta_data']['delivery_method'] ) && ! empty( $cart_item['product_meta']['meta_data']['delivery_method'] ) && 'Mail to recipient' === $cart_item['product_meta']['meta_data']['delivery_method'] && $enable_sent_multiple_gc == 'on' && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) {
			if ( isset( $cart_item['product_meta']['meta_data']['wps_wgm_to_email'] ) && ! empty( $cart_item['product_meta']['meta_data']['wps_wgm_to_email'] ) ) {
				$recipients = preg_split( '/[\s,]+/', $cart_item['product_meta']['meta_data']['wps_wgm_to_email'], -1, PREG_SPLIT_NO_EMPTY );
				if ( count( $recipients ) > 1 ) {
					$cart_item['quantity'] = count( $recipients );
				}
			}
		}
		return $cart_item;
	}

	/**
	 * set the Quantity according to receiver email to cart item.
	 */
	public function wps_wgm_woocommerce_cart_item_quantity( $product_quantity, $cart_item_key, $cart_item ) {
		$product_id = isset( $cart_item['product_id'] ) ? $cart_item['product_id'] : '';
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$is_group_product = get_post_meta( $product_id, 'wps_wgm_is_group_gift', true );
		$genaral_settings = get_option( 'wps_wgm_general_settings', array() );
		$enable_sent_multiple_gc = $wps_public_obj->wps_wgm_get_template_data( $genaral_settings, 'wps_wgm_general_setting_enable_sent_multiple_giftcard' );
		$is_imported_product = get_post_meta( $product_id, 'is_imported', true );

		if ( isset( $cart_item['product_meta']['meta_data']['delivery_method'] ) && ! empty( $cart_item['product_meta']['meta_data']['delivery_method'] ) && 'Mail to recipient' === $cart_item['product_meta']['meta_data']['delivery_method'] && $enable_sent_multiple_gc == 'on' && 'yes' !== $is_group_product && 'yes' !== $is_imported_product ) {
			if ( isset( $cart_item['product_meta']['meta_data']['wps_wgm_to_email'] ) && strpos( $cart_item['product_meta']['meta_data']['wps_wgm_to_email'], ',' ) !== false ) {
				return $cart_item['quantity'];
			}
		}
		return $product_quantity;
	}

	public function wps_get_variation_price() {
		check_ajax_referer( 'wps-uwgc-verify-nonce', 'wps_uwgc_nonce' );
		$product_id = isset( $_POST['product_id'] ) ? sanitize_text_field( wp_unslash( $_POST['product_id'] ) ) : '';
		$variation_id = isset( $_POST['variationId'] ) ? sanitize_text_field( wp_unslash( $_POST['variationId'] ) ) : '';

		if ( isset( $variation_id ) && ! empty( $variation_id ) ) {
			$variation = wc_get_product( $variation_id );

			$variation_price = $variation->get_price();

			$response['result'] = true;
			$response['variation_price'] = ( $variation_price );
			echo json_encode( $response );
		}
		wp_die();

	}


			/**
			 * Insert the new endpoint into the My Account menu.
			 *
			 * @param array $items    All the items of the my account page.
			 */
	public function wps_giftware_coupon_recharge_item( $items ) {
		$wps_wgc_enable = wps_wgm_giftcard_enable();
		if ( $wps_wgc_enable ) {
			$logout = $items['customer-logout'];
			unset( $items['customer-logout'] );
			$items['wps-giftcard']      = __( 'Gift cards', 'giftware' );
			$items['customer-logout'] = $logout;
			return $items;
		}

		return $items;
	}
	/**
	 *  Register new endpoint to use for My Account page.
	 */
	public function wps_gift_card_register_endpoint() {

		 add_rewrite_endpoint( 'wps-giftcard', EP_ROOT | EP_PAGES );
		 add_rewrite_endpoint( 'view-details', EP_ROOT | EP_PAGES );
		 add_rewrite_endpoint( 'wps-giftcard/coupon-recharge', EP_ROOT | EP_PAGES );
		 add_rewrite_endpoint( 'wps-giftcard/check-balance', EP_ROOT | EP_PAGES );
		 add_rewrite_endpoint( 'wps-giftcard/group-orders', EP_ROOT | EP_PAGES );
		 add_rewrite_endpoint( 'wps-giftcard/view-giftcards', EP_ROOT | EP_PAGES );

		do_action( 'wps_gift_card_register_endpoint' );
	}
		/**
		 *  Add new query var.
		 *
		 * @param array $vars    Query variable.
		 */
	public function wps_wsfw_giftcard_query_var( $vars ) {
		$vars[] = 'wps-giftcard';
		return $vars;
	}

	/**
	 * Add content to the new endpoint.
	 */
	public function wps_wsfw_display_view_details_endpoint_content() {
		$current_url = $_SERVER['REQUEST_URI'];
		$segments = explode( '/', trim( $current_url, '/' ) );

		$order_id = end( $segments );

		$html = '';
		$order = wc_get_order( $order_id );
		$order_id = $order->get_id();
		$gifting_id = wps_wgm_hpos_get_meta_data( $order_id, 'gifting#order', true );

		$order_date = $order->get_date_created();
		$order_total = $order->get_total();
		$order_status = $order->get_status();
		
		$html .= '<div class="gc-card-table-wrapper">';

		$order_id = $order->get_id();
		$gifting_id = wps_wgm_hpos_get_meta_data( $order_id, 'gifting#order', true );

		$order_date = $order->get_date_created();
		$order_total = $order->get_total();
		$order_status = $order->get_status();
		if ( $order_id == $gifting_id ) {

		
			$meta_key = 'suborder#' . $order_id;
			
			if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
				// HPOS Enabled.
				$suborders = wc_get_orders(
					array(
						'limit'       => -1,
						'status'      => array_keys( wc_get_order_statuses() ),
						'meta_key'    => $meta_key, // Replace with your custom field key.
						'type'        => wc_get_order_types(),
					)
				);
			} else {
				$args = array(
					'post_type'      => 'shop_order',
					'post_status'    => 'any',
					'posts_per_page' => -1,
					'meta_key'       => $meta_key, // Replace with your custom field key.
				);
				$suborders = get_posts( $args );
			}
			if ( ! empty( $suborders ) ) {

				$html .= '<h4>Contributor details</h4><div class="gc-card-table-scroll"><table  ><thead><th>ID</th><th>Email</th><th>Date</th><th>Amount</th></thead><tbody>
				
				';
				foreach ( $suborders as $order ) {
					if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
						$order_sub_id = $order->get_id();
					} else {
						$order_sub_id = $order->ID;
					}
					$order = wc_get_order( $order_sub_id );

					$billing_first_name = $order->get_billing_first_name();
					$billing_last_name  = $order->get_billing_last_name();
					$billing_email      = $order->get_billing_email();
					$product_amount     = $order->get_subtotal();
					$html .= '<tr>
							
								<td>' . $order_sub_id . '</td>
							
					
								<td>' . $billing_email . '</td>
							
							
								<td>' . $order_date->date( get_option( 'date_format' ) ) . '</td>
							
							
								<td>' . wc_price( $product_amount ) . '</td>
							
								
								
								</tr>
							
							';
				}
				$html .= '</tbody></table></div>';

			} else {
				$html .= "<div ><h4>Contributor details</h4><div class='gc-card-table-scroll'><table  ><thead><th>ID</th><th>Email</th><th>Date</th><th>Amount</th></thead><tbody><tr><td colspan='5'>No contribution has been done yet !!</td></tr></tbody></table></div></div>";
			}
		}

		
		$html .= '</div>';
		$previous_page_url = wp_get_referer();

		// Output the "Back" button if there is a previous page URL.
		if ( $previous_page_url ) {
			$html .= '<div class="wps-back-btn"><a style="margin-bottom:10px; padding-bottom:10px; left: 25px;" class="button" href="' . esc_url( $previous_page_url ) . '">Back</a></div>';
		}
		echo $html;
		// }
	}
		/**
		 * Add content to the new endpoint.
		 */
	public function wps_wsfw_display_giftcard_endpoint_content() {
		$current_url = $_SERVER['REQUEST_URI'];
		$segments = explode( '/', trim( $current_url, '/' ) );

		$coupon_rechage = end( $segments );

		$user_id = get_current_user_id();
		$wps_obj = new Woocommerce_Gift_Cards_Common_Function();
		$other_settings = get_option( 'wps_wgm_other_settings', array() );
		$wps_enable_recharge_field = $wps_obj->wps_wgm_get_template_data( $other_settings, 'wps_wgm_hide_recharge_coupon' );
		
		$orders = wc_get_orders(
			array(
				'customer' => $user_id,
			)
		);

		echo '	<div>	<h4><b>' . __( 'Gift Cards', 'giftware' ) . '</b></h4></div>
				<div class="wps-gc-card-section">
					<div class="gc-card-wrapper">';
					if (!$wps_enable_recharge_field){
						echo '	<div class="gc-car-widget wps-coupon-card" id="wps_giftcard_recharge_tab">
						<a href="' . wc_get_endpoint_url( 'wps-giftcard/coupon-recharge' ) . '"  >
							<span class="wps-coupon-card-icon">
								<svg width="74" height="40" viewBox="0 0 74 40" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M27.9799 22.5752C27.9799 21.4922 28.8578 20.6143 29.9408 20.6143H58.8535C59.9364 20.6143 60.8144 21.4922 60.8144 22.5752V26.0854C60.8144 26.302 60.6388 26.4776 60.4222 26.4776C60.2056 26.4776 60.03 26.302 60.03 26.0854V22.5752C60.03 21.9254 59.5033 21.3986 58.8535 21.3986H29.9408C29.291 21.3986 28.7642 21.9254 28.7642 22.5752V26.0854C28.7642 26.302 28.5886 26.4776 28.3721 26.4776C28.1555 26.4776 27.9799 26.302 27.9799 26.0854V22.5752ZM28.3721 33.7496C28.5886 33.7496 28.7642 33.9251 28.7642 34.1417V37.652C28.7642 38.3018 29.291 38.8285 29.9408 38.8285H58.8535C59.5033 38.8285 60.03 38.3018 60.03 37.652V34.1417C60.03 33.9251 60.2056 33.7496 60.4222 33.7496C60.6388 33.7496 60.8144 33.9251 60.8144 34.1417V37.652C60.8144 38.735 59.9364 39.6129 58.8535 39.6129H29.9408C28.8578 39.6129 27.9799 38.735 27.9799 37.652V34.1417C27.9799 33.9251 28.1555 33.7496 28.3721 33.7496Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M52.2634 25.256C52.4313 25.3928 52.4565 25.6398 52.3197 25.8077L44.6136 35.2652C44.4768 35.4331 44.2298 35.4583 44.0619 35.3215C43.894 35.1846 43.8687 34.9376 44.0056 34.7697L51.7116 25.3123C51.8484 25.1444 52.0955 25.1192 52.2634 25.256Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M31.6578 30.1136C31.6578 28.1055 30.0299 26.4776 28.0218 26.4776V25.6933C30.4631 25.6933 32.4422 27.6723 32.4422 30.1136C32.4422 32.5549 30.4631 34.5339 28.0218 34.5339V33.7496C30.0299 33.7496 31.6578 32.1217 31.6578 30.1136Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M57.1365 30.1136C57.1365 28.1055 58.7644 26.4776 60.7725 26.4776V25.6933C58.3312 25.6933 56.3521 27.6723 56.3521 30.1136C56.3521 32.5549 58.3312 34.5339 60.7725 34.5339V33.7496C58.7644 33.7496 57.1365 32.1217 57.1365 30.1136Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M46.0609 27.753C46.7884 27.753 47.3782 27.1632 47.3782 26.4357C47.3782 25.7082 46.7884 25.1184 46.0609 25.1184C45.3334 25.1184 44.7436 25.7082 44.7436 26.4357C44.7436 27.1632 45.3334 27.753 46.0609 27.753ZM46.0609 28.5373C47.2216 28.5373 48.1626 27.5964 48.1626 26.4357C48.1626 25.275 47.2216 24.334 46.0609 24.334C44.9002 24.334 43.9593 25.275 43.9593 26.4357C43.9593 27.5964 44.9002 28.5373 46.0609 28.5373Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M50.9648 34.7585C51.6923 34.7585 52.2821 34.1687 52.2821 33.4412C52.2821 32.7137 51.6923 32.1239 50.9648 32.1239C50.2373 32.1239 49.6475 32.7137 49.6475 33.4412C49.6475 34.1687 50.2373 34.7585 50.9648 34.7585ZM50.9648 35.5428C52.1255 35.5428 53.0665 34.6019 53.0665 33.4412C53.0665 32.2805 52.1255 31.3395 50.9648 31.3395C49.8041 31.3395 48.8632 32.2805 48.8632 33.4412C48.8632 34.6019 49.8041 35.5428 50.9648 35.5428Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M38.0046 22.3657C38.2212 22.3657 38.3968 22.5412 38.3968 22.7578V23.4934C38.3968 23.71 38.2212 23.8856 38.0046 23.8856C37.788 23.8856 37.6124 23.71 37.6124 23.4934V22.7578C37.6124 22.5412 37.788 22.3657 38.0046 22.3657ZM38.0046 24.5724C38.2212 24.5724 38.3968 24.748 38.3968 24.9646V26.4357C38.3968 26.6523 38.2212 26.8279 38.0046 26.8279C37.788 26.8279 37.6124 26.6523 37.6124 26.4357V24.9646C37.6124 24.748 37.788 24.5724 38.0046 24.5724ZM38.0046 27.5147C38.2212 27.5147 38.3968 27.6903 38.3968 27.9069V29.378C38.3968 29.5946 38.2212 29.7702 38.0046 29.7702C37.788 29.7702 37.6124 29.5946 37.6124 29.378V27.9069C37.6124 27.6903 37.788 27.5147 38.0046 27.5147ZM38.0046 30.457C38.2212 30.457 38.3968 30.6326 38.3968 30.8492V32.3203C38.3968 32.5369 38.2212 32.7125 38.0046 32.7125C37.788 32.7125 37.6124 32.5369 37.6124 32.3203V30.8492C37.6124 30.6326 37.788 30.457 38.0046 30.457ZM38.0046 33.3993C38.2212 33.3993 38.3968 33.5749 38.3968 33.7915V35.2626C38.3968 35.4792 38.2212 35.6548 38.0046 35.6548C37.788 35.6548 37.6124 35.4792 37.6124 35.2626V33.7915C37.6124 33.5749 37.788 33.3993 38.0046 33.3993ZM38.0046 36.3416C38.2212 36.3416 38.3968 36.5172 38.3968 36.7338V37.4694C38.3968 37.686 38.2212 37.8616 38.0046 37.8616C37.788 37.8616 37.6124 37.686 37.6124 37.4694V36.7338C37.6124 36.5172 37.788 36.3416 38.0046 36.3416Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M37.5746 16.7144C37.3416 15.6569 38.01 14.6106 39.0676 14.3775L67.3027 8.15499C68.3603 7.92191 69.4066 8.59032 69.6397 9.64792L70.3952 13.0759C70.4418 13.2874 70.3081 13.4967 70.0966 13.5433C69.8851 13.5899 69.6758 13.4562 69.6292 13.2447L68.8737 9.81672C68.7339 9.18216 68.1061 8.78112 67.4715 8.92096L39.2364 15.1435C38.6018 15.2833 38.2008 15.9111 38.3406 16.5456L39.0961 19.9736C39.1427 20.1852 39.009 20.3944 38.7975 20.441C38.586 20.4877 38.3767 20.354 38.3301 20.1425L37.5746 16.7144ZM71.6616 20.6449C71.8731 20.5982 72.0824 20.7319 72.129 20.9434L72.8845 24.3715C73.1176 25.4291 72.4492 26.4753 71.3916 26.7084L57.274 29.8197C57.0625 29.8663 56.8532 29.7326 56.8066 29.5211C56.76 29.3096 56.8936 29.1003 57.1052 29.0537L71.2227 25.9424C71.8573 25.8026 72.2584 25.1748 72.1185 24.5403L71.363 21.1123C71.3164 20.9007 71.4501 20.6915 71.6616 20.6449Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M62.2259 13.7611C62.4165 13.864 62.4876 14.1019 62.3848 14.2925L58.7652 20.9985C58.6623 21.1891 58.4244 21.2603 58.2338 21.1574C58.0432 21.0545 57.9721 20.8166 58.0749 20.626L61.6945 13.9199C61.7974 13.7293 62.0353 13.6582 62.2259 13.7611Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M67.6703 17.8012C67.2382 15.8402 68.4775 13.9001 70.4386 13.4679L70.2698 12.702C67.8857 13.2274 66.3789 15.586 66.9044 17.9701C67.4298 20.3541 69.7884 21.8609 72.1724 21.3355L72.0036 20.5695C70.0426 21.0017 68.1025 19.7623 67.6703 17.8012Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M56.3462 17.8796C57.0567 17.723 57.5057 17.0202 57.3492 16.3097C57.1926 15.5992 56.4897 15.1502 55.7792 15.3068C55.0688 15.4633 54.6197 16.1662 54.7763 16.8767C54.9329 17.5872 55.6358 18.0362 56.3462 17.8796ZM56.515 18.6456C57.6486 18.3958 58.3649 17.2744 58.1151 16.1409C57.8653 15.0074 56.7439 14.291 55.6104 14.5408C54.4769 14.7906 53.7605 15.912 54.0103 17.0455C54.2601 18.179 55.3815 18.8954 56.515 18.6456Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M62.6429 23.6655C63.3534 23.5089 63.8024 22.806 63.6458 22.0956C63.4893 21.3851 62.7864 20.9361 62.0759 21.0927C61.3654 21.2492 60.9164 21.9521 61.073 22.6626C61.2296 23.3731 61.9324 23.8221 62.6429 23.6655ZM62.8117 24.4315C63.9452 24.1817 64.6616 23.0603 64.4118 21.9268C64.162 20.7933 63.0406 20.0769 61.9071 20.3267C60.7736 20.5765 60.0572 21.6979 60.307 22.8314C60.5568 23.9649 61.6782 24.6813 62.8117 24.4315Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M47.3193 14.3523C47.5308 14.3057 47.7401 14.4394 47.7867 14.6509L47.9688 15.477C48.0154 15.6885 47.8817 15.8978 47.6702 15.9444C47.4587 15.991 47.2494 15.8573 47.2028 15.6458L47.0207 14.8197C46.9741 14.6082 47.1078 14.3989 47.3193 14.3523ZM47.8655 16.8305C48.077 16.7839 48.2863 16.9176 48.3329 17.1291L48.5149 17.9552C48.5615 18.1667 48.4278 18.3759 48.2163 18.4225C48.0048 18.4692 47.7955 18.3355 47.7489 18.124L47.5669 17.2979C47.5203 17.0864 47.654 16.8771 47.8655 16.8305Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M11.5648 26.9269L10.5083 25.0525L9.45183 26.9269C9.22797 27.3241 8.84241 27.6042 8.39551 27.6944L6.28637 28.1199L7.74256 29.704C8.05111 30.0396 8.19838 30.4928 8.14604 30.9457L7.89901 33.0832L9.85548 32.1877C10.27 31.998 10.7466 31.998 11.1612 32.1877L13.1176 33.0832L12.8706 30.9457C12.8183 30.4928 12.9655 30.0396 13.2741 29.704L14.7303 28.1199L12.6211 27.6944C12.1742 27.6042 11.7887 27.3241 11.5648 26.9269ZM11.1916 24.6674C10.8916 24.1351 10.1251 24.1351 9.82503 24.6674L8.76853 26.5418C8.65661 26.7404 8.46382 26.8804 8.24037 26.9255L6.13123 27.3511C5.53227 27.4719 5.2954 28.201 5.70893 28.6508L7.16512 30.2348C7.3194 30.4026 7.39303 30.6292 7.36686 30.8557L7.11984 32.9931C7.04968 33.6001 7.66983 34.0507 8.22543 33.7964L10.1819 32.9009C10.3892 32.8061 10.6275 32.8061 10.8347 32.9009L12.7912 33.7964C13.3468 34.0507 13.967 33.6001 13.8968 32.9931L13.6498 30.8557C13.6236 30.6292 13.6972 30.4026 13.8515 30.2348L15.3077 28.6508C15.7212 28.201 15.4844 27.4719 14.8854 27.3511L12.7763 26.9255C12.5528 26.8804 12.36 26.7404 12.2481 26.5418L11.1916 24.6674Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M10.5083 36.5327C14.3968 36.5327 17.5492 33.3803 17.5492 29.4917C17.5492 25.6031 14.3968 22.4508 10.5083 22.4508C6.61966 22.4508 3.46733 25.6031 3.46733 29.4917C3.46733 33.3803 6.61966 36.5327 10.5083 36.5327ZM10.5083 37.317C14.83 37.317 18.3335 33.8135 18.3335 29.4917C18.3335 25.1699 14.83 21.6664 10.5083 21.6664C6.18647 21.6664 2.68297 25.1699 2.68297 29.4917C2.68297 33.8135 6.18647 37.317 10.5083 37.317Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M10.5082 39.2156C15.8786 39.2156 20.2321 34.8621 20.2321 29.4918C20.2321 24.1214 15.8786 19.7679 10.5082 19.7679C5.13789 19.7679 0.78436 24.1214 0.78436 29.4918C0.78436 34.8621 5.13789 39.2156 10.5082 39.2156ZM10.5082 40C16.3118 40 21.0165 35.2953 21.0165 29.4918C21.0165 23.6882 16.3118 18.9835 10.5082 18.9835C4.7047 18.9835 0 23.6882 0 29.4918C0 35.2953 4.7047 40 10.5082 40Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M27.5301 2.81219C20.6178 3.79037 15.2103 8.64967 13.2008 14.8764C13.1342 15.0825 12.9132 15.1957 12.7071 15.1291C12.501 15.0626 12.3878 14.8416 12.4543 14.6355C14.5525 8.13403 20.1995 3.05739 27.4202 2.03556C32.8278 1.2703 38.0191 2.93515 41.889 6.19833L41.426 2.92597C41.3956 2.71151 41.5449 2.51305 41.7593 2.48271C41.9738 2.45236 42.1722 2.60161 42.2026 2.81606L42.871 7.53961L38.8917 8.10276C38.6772 8.1331 38.4787 7.98385 38.4484 7.7694C38.4181 7.55494 38.5673 7.35648 38.7818 7.32613L41.5442 6.9352C37.8214 3.71938 32.7825 2.06889 27.5301 2.81219Z" fill="#545454"/>
								</svg>
							</span>
							<span class="h4">' . __( 'Coupon Recharge', 'giftware' ) . '<span>
						</a>
					</div>';
					}

					echo	'<div class="gc-car-widget wps-coupon-card" id="wps_giftcard_order_tab">
							<a href="' . wc_get_endpoint_url( 'wps-giftcard/group-orders' ) . '">
								<span class="wps-coupon-card-icon">
								<svg width="70" height="40" viewBox="0 0 70 40" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M35.8843 32.8976C39.3665 32.8976 42.1893 30.0748 42.1893 26.5927C42.1893 23.1105 39.3665 20.2877 35.8843 20.2877C32.4022 20.2877 29.5794 23.1105 29.5794 26.5927C29.5794 30.0748 32.4022 32.8976 35.8843 32.8976ZM35.8843 33.6897C39.8039 33.6897 42.9814 30.5123 42.9814 26.5927C42.9814 22.6731 39.8039 19.4956 35.8843 19.4956C31.9648 19.4956 28.7873 22.6731 28.7873 26.5927C28.7873 30.5123 31.9648 33.6897 35.8843 33.6897Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M35.8844 34.0857C31.3925 34.0857 27.4322 36.3619 25.0939 39.8255C24.9715 40.0068 24.7254 40.0545 24.5441 39.9322C24.3628 39.8098 24.3151 39.5636 24.4374 39.3823C26.9167 35.7099 31.1183 33.2937 35.8844 33.2937C40.6504 33.2937 44.852 35.7099 47.3313 39.3823C47.4537 39.5636 47.4059 39.8098 47.2246 39.9322C47.0433 40.0545 46.7972 40.0068 46.6748 39.8255C44.3365 36.3619 40.3762 34.0857 35.8844 34.0857Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M57.6296 13.402C61.1117 13.402 63.9346 10.5792 63.9346 7.09705C63.9346 3.61491 61.1117 0.792079 57.6296 0.792079C54.1474 0.792079 51.3246 3.61491 51.3246 7.09705C51.3246 10.5792 54.1474 13.402 57.6296 13.402ZM57.6296 14.1941C61.5492 14.1941 64.7266 11.0166 64.7266 7.09705C64.7266 3.17746 61.5492 0 57.6296 0C53.71 0 50.5325 3.17746 50.5325 7.09705C50.5325 11.0166 53.71 14.1941 57.6296 14.1941Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M57.6295 14.5901C53.1377 14.5901 49.1773 16.8662 46.8391 20.3299C46.7167 20.5112 46.4705 20.5589 46.2893 20.4365C46.108 20.3141 46.0602 20.068 46.1826 19.8867C48.6618 16.2142 52.8635 13.798 57.6295 13.798C62.3956 13.798 66.5972 16.2142 69.0765 19.8867C69.1988 20.068 69.1511 20.3141 68.9698 20.4365C68.7885 20.5589 68.5423 20.5112 68.42 20.3299C66.0817 16.8662 62.1214 14.5901 57.6295 14.5901Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M11.5148 13.402C14.9969 13.402 17.8198 10.5792 17.8198 7.09705C17.8198 3.61491 14.9969 0.792079 11.5148 0.792079C8.03264 0.792079 5.2098 3.61491 5.2098 7.09705C5.2098 10.5792 8.03264 13.402 11.5148 13.402ZM11.5148 14.1941C15.4344 14.1941 18.6118 11.0166 18.6118 7.09705C18.6118 3.17746 15.4344 0 11.5148 0C7.59518 0 4.41772 3.17746 4.41772 7.09705C4.41772 11.0166 7.59518 14.1941 11.5148 14.1941Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M11.5148 14.5901C7.02292 14.5901 3.06257 16.8662 0.724323 20.3299C0.601941 20.5112 0.355771 20.5589 0.174487 20.4365C-0.00679714 20.3141 -0.0545465 20.068 0.0678356 19.8867C2.54707 16.2142 6.74868 13.798 11.5148 13.798C16.2808 13.798 20.4824 16.2142 22.9617 19.8867C23.0841 20.068 23.0363 20.3141 22.855 20.4365C22.6737 20.5589 22.4276 20.5112 22.3052 20.3299C19.9669 16.8662 16.0066 14.5901 11.5148 14.5901Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M21.6735 31.3981L14.1752 23.8997L14.7353 23.3397L22.2336 30.838L21.6735 31.3981Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M43.1161 7.80084H27.1673V7.00876H43.1161V7.80084Z" fill="#545454"/>
									<path fill-rule="evenodd" clip-rule="evenodd" d="M49.6048 31.0254L56.7282 23.902L57.2883 24.4621L50.1649 31.5855L49.6048 31.0254Z" fill="#545454"/>
								</svg>

								</span>
								<span class="h4">' . __( 'Group Orders', 'giftware' ) . '<span>
							</a>
						</div>
						<div class="gc-car-widget wps-coupon-card" id="wps_giftcard_balance_tab">
							<a href="' . wc_get_endpoint_url( 'wps-giftcard/check-balance' ) . '">
								<span class="wps-coupon-card-icon">
									<svg width="48" height="40" viewBox="0 0 48 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" clip-rule="evenodd" d="M28.4327 1.1877C28.2106 0.805872 27.7194 0.679086 27.3402 0.905742L21.9614 4.12122L9.82046 11.2371H34.2784L28.4327 1.1877ZM35.196 11.2371H36.5135V4.96875C36.5135 4.53073 36.1584 4.17564 35.7204 4.17564H31.0884L35.196 11.2371ZM30.627 3.38252L29.1183 0.78891C28.6741 0.0252494 27.6916 -0.228321 26.9333 0.224991L21.6514 3.38252H1.58623C0.710181 3.38252 0 4.0927 0 4.96876V38.4138C0 39.2898 0.710182 40 1.58623 40H41.3528C42.2289 40 42.939 39.2898 42.939 38.4138V32.337H45.8199C46.6959 32.337 47.4061 31.6269 47.4061 30.7508V20.4863C47.4061 19.6102 46.6959 18.9 45.8199 18.9H42.939V12.8233C42.939 11.9472 42.2289 11.2371 41.3528 11.2371H37.3066V4.96875C37.3066 4.0927 36.5965 3.38252 35.7204 3.38252H30.627ZM42.1459 18.9V12.8233C42.1459 12.3853 41.7908 12.0302 41.3528 12.0302H0.793117V38.4138C0.793117 38.8518 1.14821 39.2069 1.58623 39.2069H41.3528C41.7908 39.2069 42.1459 38.8518 42.1459 38.4138V32.337H34.9679V31.9405C34.9679 32.337 34.9676 32.337 34.9673 32.337L34.9649 32.337L34.9602 32.337L34.9459 32.3367C34.9342 32.3365 34.9183 32.336 34.8983 32.3351C34.8584 32.3332 34.8023 32.3297 34.7325 32.3228C34.5931 32.309 34.3977 32.2818 34.1649 32.2281C33.7001 32.1209 33.0795 31.9065 32.4578 31.4764C31.1924 30.6009 30.0023 28.8889 30.0023 25.6185C30.0023 22.3482 31.1924 20.6361 32.4578 19.7607C33.0795 19.3305 33.7001 19.1161 34.1649 19.0089C34.3977 18.9553 34.5931 18.9281 34.7325 18.9143C34.8023 18.9074 34.8584 18.9038 34.8983 18.902C34.9183 18.9011 34.9342 18.9006 34.9459 18.9003L34.9602 18.9001L34.9649 18.9L34.9666 18.9L34.9673 18.9C34.9676 18.9 34.9679 18.9 34.9679 19.2966V18.9H42.1459ZM34.9679 19.6931L34.9636 19.6932C34.958 19.6934 34.9483 19.6936 34.9348 19.6943C34.9078 19.6955 34.8657 19.6981 34.8106 19.7036C34.7002 19.7145 34.5386 19.7367 34.3431 19.7818C33.9512 19.8722 33.4295 20.0529 32.909 20.4129C31.8899 21.118 30.7955 22.5669 30.7955 25.6185C30.7955 28.6702 31.8899 30.119 32.909 30.8241C33.4295 31.1842 33.9512 31.3649 34.3431 31.4553C34.5386 31.5004 34.7002 31.5226 34.8106 31.5335C34.8657 31.5389 34.9078 31.5415 34.9348 31.5428C34.9483 31.5434 34.958 31.5437 34.9636 31.5438L34.9679 31.5439H34.9689H45.8199C46.2579 31.5439 46.613 31.1888 46.613 30.7508V20.4863C46.613 20.0482 46.2579 19.6931 45.8199 19.6931H34.9679ZM2.33877 11.2371C1.85549 11.2371 1.50457 11.0188 1.24866 10.7261C0.999726 10.4413 0.853088 10.0972 0.793117 9.86257V4.96876C0.793117 4.53073 1.14821 4.17564 1.58623 4.17564H20.3L8.25196 11.2371H2.33877ZM34.5713 24.8925C34.5713 24.0164 35.2815 23.3062 36.1575 23.3062H38.8279C39.704 23.3062 40.4142 24.0164 40.4142 24.8925V26.153C40.4142 27.0291 39.704 27.7393 38.8279 27.7393H36.1575C35.2815 27.7393 34.5713 27.0291 34.5713 26.153V24.8925ZM36.1575 24.0993C35.7195 24.0993 35.3644 24.4544 35.3644 24.8925V26.153C35.3644 26.5911 35.7195 26.9461 36.1575 26.9461H38.8279C39.266 26.9461 39.6211 26.5911 39.6211 26.153V24.8925C39.6211 24.4544 39.266 24.0993 38.8279 24.0993H36.1575Z" fill="#545454"/>
									</svg>
								</span>
								<span class="h4">' . __( 'Check Balance', 'giftware' ) . '<span>
							</a>
						</div>
						<div class="gc-car-widget wps-coupon-card" id="wps_giftcard_view_tab">
							<a href="' . wc_get_endpoint_url( 'wps-giftcard/view-giftcards' ) . '">
								<span class="wps-coupon-card-icon">
									<svg width="48" height="40" viewBox="0 0 48 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" clip-rule="evenodd" d="M28.4327 1.1877C28.2106 0.805872 27.7194 0.679086 27.3402 0.905742L21.9614 4.12122L9.82046 11.2371H34.2784L28.4327 1.1877ZM35.196 11.2371H36.5135V4.96875C36.5135 4.53073 36.1584 4.17564 35.7204 4.17564H31.0884L35.196 11.2371ZM30.627 3.38252L29.1183 0.78891C28.6741 0.0252494 27.6916 -0.228321 26.9333 0.224991L21.6514 3.38252H1.58623C0.710181 3.38252 0 4.0927 0 4.96876V38.4138C0 39.2898 0.710182 40 1.58623 40H41.3528C42.2289 40 42.939 39.2898 42.939 38.4138V32.337H45.8199C46.6959 32.337 47.4061 31.6269 47.4061 30.7508V20.4863C47.4061 19.6102 46.6959 18.9 45.8199 18.9H42.939V12.8233C42.939 11.9472 42.2289 11.2371 41.3528 11.2371H37.3066V4.96875C37.3066 4.0927 36.5965 3.38252 35.7204 3.38252H30.627ZM42.1459 18.9V12.8233C42.1459 12.3853 41.7908 12.0302 41.3528 12.0302H0.793117V38.4138C0.793117 38.8518 1.14821 39.2069 1.58623 39.2069H41.3528C41.7908 39.2069 42.1459 38.8518 42.1459 38.4138V32.337H34.9679V31.9405C34.9679 32.337 34.9676 32.337 34.9673 32.337L34.9649 32.337L34.9602 32.337L34.9459 32.3367C34.9342 32.3365 34.9183 32.336 34.8983 32.3351C34.8584 32.3332 34.8023 32.3297 34.7325 32.3228C34.5931 32.309 34.3977 32.2818 34.1649 32.2281C33.7001 32.1209 33.0795 31.9065 32.4578 31.4764C31.1924 30.6009 30.0023 28.8889 30.0023 25.6185C30.0023 22.3482 31.1924 20.6361 32.4578 19.7607C33.0795 19.3305 33.7001 19.1161 34.1649 19.0089C34.3977 18.9553 34.5931 18.9281 34.7325 18.9143C34.8023 18.9074 34.8584 18.9038 34.8983 18.902C34.9183 18.9011 34.9342 18.9006 34.9459 18.9003L34.9602 18.9001L34.9649 18.9L34.9666 18.9L34.9673 18.9C34.9676 18.9 34.9679 18.9 34.9679 19.2966V18.9H42.1459ZM34.9679 19.6931L34.9636 19.6932C34.958 19.6934 34.9483 19.6936 34.9348 19.6943C34.9078 19.6955 34.8657 19.6981 34.8106 19.7036C34.7002 19.7145 34.5386 19.7367 34.3431 19.7818C33.9512 19.8722 33.4295 20.0529 32.909 20.4129C31.8899 21.118 30.7955 22.5669 30.7955 25.6185C30.7955 28.6702 31.8899 30.119 32.909 30.8241C33.4295 31.1842 33.9512 31.3649 34.3431 31.4553C34.5386 31.5004 34.7002 31.5226 34.8106 31.5335C34.8657 31.5389 34.9078 31.5415 34.9348 31.5428C34.9483 31.5434 34.958 31.5437 34.9636 31.5438L34.9679 31.5439H34.9689H45.8199C46.2579 31.5439 46.613 31.1888 46.613 30.7508V20.4863C46.613 20.0482 46.2579 19.6931 45.8199 19.6931H34.9679ZM2.33877 11.2371C1.85549 11.2371 1.50457 11.0188 1.24866 10.7261C0.999726 10.4413 0.853088 10.0972 0.793117 9.86257V4.96876C0.793117 4.53073 1.14821 4.17564 1.58623 4.17564H20.3L8.25196 11.2371H2.33877ZM34.5713 24.8925C34.5713 24.0164 35.2815 23.3062 36.1575 23.3062H38.8279C39.704 23.3062 40.4142 24.0164 40.4142 24.8925V26.153C40.4142 27.0291 39.704 27.7393 38.8279 27.7393H36.1575C35.2815 27.7393 34.5713 27.0291 34.5713 26.153V24.8925ZM36.1575 24.0993C35.7195 24.0993 35.3644 24.4544 35.3644 24.8925V26.153C35.3644 26.5911 35.7195 26.9461 36.1575 26.9461H38.8279C39.266 26.9461 39.6211 26.5911 39.6211 26.153V24.8925C39.6211 24.4544 39.266 24.0993 38.8279 24.0993H36.1575Z" fill="#545454"/>
									</svg>
								</span>
								<span class="h4">' . __( 'View Gift Cards', 'giftware' ) . '<span>
							</a>
						</div>
					</div>
				</div>';
		if ( $coupon_rechage == 'coupon-recharge' || $coupon_rechage == 'wps-giftcard' ) {
			if ( isset( $_POST['wps_recharge_coupon'] ) && ! empty( $_POST['wps_recharge_coupon'] ) ) {

				$nonce = ( isset( $_POST['verifynonce'] ) ) ? sanitize_text_field( wp_unslash( $_POST['verifynonce'] ) ) : '';

				if ( wp_verify_nonce( $nonce ) ) {

					unset( $_POST['wps_recharge_coupon'] );

					if ( empty( $_POST['wps_gc_recharge_amount'] ) ) {
						$this->show_message_on_form_submit( esc_html__( 'Please enter amount greater than 0', 'giftware' ), 'woocommerce-error' );
					} else {
						$recharge_amount = sanitize_text_field( wp_unslash( $_POST['wps_gc_recharge_amount'] ) );

						$recharge_code   = sanitize_text_field( wp_unslash( $_POST['wps_recharge_coupon_code'] ) );
							// Get the coupon object.
							$coupon = new WC_Coupon( $recharge_code );

							// Check if the coupon exists.
						if ( $coupon->is_valid() ) {
							if ( ! empty( $_POST['user_id'] ) ) {
								$user_id = sanitize_text_field( wp_unslash( $_POST['user_id'] ) );

							}

								$product_id = ( isset( $_POST['product_id'] ) ) ? sanitize_text_field( wp_unslash( $_POST['product_id'] ) ) : '';

								WC()->session->set(
									'gc_coupon_recharge',
									array(
										'userid'         => $user_id,
										'rechargeamount' => $recharge_amount,
										'rechargecode'   => $recharge_code,
										'productid'      => $product_id,
									)
								);

								WC()->session->set( 'gc_recharge_amount', $recharge_amount );
								WC()->session->set( 'gc_recharge_code', $recharge_code );
								echo '<script>window.location.href = "' . esc_url( wc_get_cart_url() ) . '";</script>';

						} else {
									echo "<div class='woocommerce-error' role='alert'>Coupon '{$recharge_code}' is not valid.</div>";
						}
					}
				} else {
					$this->show_message_on_form_submit( esc_html__( 'Failed security check', 'giftware' ), 'woocommerce-error' );
				}
			}
			$product_id             = get_option( 'wps_gccoupon_rechargeable_product_id', '' );
			$user_id                = get_current_user_id();
			if (!$wps_enable_recharge_field){
			echo '<form method="POST"><div id="wps_gift_card_balance_wrapper_recharge" class="wps-wallet-field-container form-row wps_gift_card_balance_wrapper">
					<h4 class="wps_gift_card_balance_heading">' . __( 'Recharge Coupon Code', 'giftware' ) . '</h4>
					<div class="form-group">
						<label>' . __( 'Enter Price', 'giftware' ) . '</label>
						<input type="number" id="wps_gc_recharge_amount" min="1" name="wps_gc_recharge_amount" class="wps_gc_recharge_amount" placeholder="' . __( 'Enter Price', 'giftware' ) . '" required="required">
					</div>
					<div class="form-group">
						<label>' . __( 'Coupon Code', 'giftware' ) . '</label>
						<input type="text" id="wps_recharge_coupon_code" name="wps_recharge_coupon_code" class="wps_recharge_coupon_code" placeholder="' . __( 'Coupon Code', 'giftware' ) . '" required="required">
					</div>
					<input type="hidden" name="user_id" value="' . $user_id . '">
					<input type="hidden" name="product_id" value="' . $product_id . '">
					<input type="hidden" id="verifynonce" name="verifynonce" value="' . wp_create_nonce() . '" />
					<div class="wps-wps_recharge_coupon-btn">
						<input type="submit" class="button" id="wps_recharge_coupon" name="wps_recharge_coupon" value="' . __( 'Recharge +', 'giftware' ) . '">
					</div>
					<span id="wps_recharge_completed"></span>
						</div></form>';
			}
		}
		if ( $coupon_rechage == 'check-balance' ) {
			  $html = '<div id="wps_gift_card_balance_wrapper_check" class="wps_gift_card_balance_wrapper">';
				$html .= '<div id="wps-check-balamce-error"></div><h4 class="wps_gift_card_balance_heading"><span>' . __( 'Check Balance', 'giftware' ) . '</span><div id="wps_balance"></div></h4>';
				$html .= '<div class="gift_card_balance_email"><label>' . __( 'Enter Recipient/Buyer Email', 'giftware' ) . '</label><input type="email" id="gift_card_balance_email" class="wps_gift_balance" placeholder="' . __( 'example@wpswings.com', 'giftware' ) . '" required="required"></div>';
				$html .= '<div class="gift_card_code"><label>' . __( 'Enter Gift Card Code', 'giftware' ) . '</label><input type="text" id="gift_card_code" class="wps_gift_balance" placeholder="' . __( 'Coupon Code', 'giftware' ) . '" required="required"></div>';
				$html .= '<p class="wps_check_balance"><input type="button" class="button wps_check_balance" id="wps_check_balance" value="' . __( 'Check Balance', 'giftware' ) . '"></p>';
				$html .= '<div style="display: none;" class="loading-style-bg" id="wps_wgm_loader"><img src="' . WPS_UWGC_URL . 'assets/images/loading.gif"></div></div>';
				echo $html;
		}
		if ( ( $coupon_rechage == 'group-orders' ) || ( 'on' == $wps_enable_recharge_field && $coupon_rechage == 'wps-giftcard' ) ) {
					$user_id = get_current_user_id();

				$orders = wc_get_orders(
					array(
						'customer' => $user_id,
						'status' => array( 'processing', 'completed' ), // Retrieve orders of any status (you can customize this).
						'limit' => -1,     // Retrieve all orders.
					)
				);
				$html = '';
				$html .= '
							<div id="wps_gift_card_balance_wrapper_order"class="gc-card-table-wrapper">
							<h4 class="wps_gift_card_balance_heading" >' . __( 'Group Gift Orders', 'giftware' ) . '</h4>
							<div class="gc-card-table-scroll">
							<table class="scrollable-table">
								<thead>
									<th>' . __( 'Order ID', 'giftware' ) . '</th>
									<th>' . __( 'Order Date', 'giftware' ) . '</th>
									<th>' . __( 'Total', 'giftware' ) . '</th>
									<th>' . __( 'Order Detail', 'giftware' ) . '</th>
									<th>' . __( 'Share', 'giftware' ) . '</th>
								</thead>
								<tbody id="table-body">
							';
			if ( $orders ) {
				$has_orders = false;
				foreach ( $orders as $order ) {
					$order_id = $order->get_id();
					$gifting_id = wps_wgm_hpos_get_meta_data( $order_id, 'gifting#order', true );

					$order_date = $order->get_date_created();
					$order_total = $order->get_total();
					$order_status = $order->get_status();
					$share_link = wps_wgm_hpos_get_meta_data( $order_id, 'share#link', true );
					$copy_link  = wps_wgm_hpos_get_meta_data( $order_id, 'copy#link', true );

					if ( ! empty( $share_link ) ) {
						$share_icon = '<a class="wps_pgfw_whatsapp_share_icon" href="' . $share_link . '"><img src="' . WPS_UWGC_URL . 'assets/images/whatsapp.png" alt="not found" style="width:20px;"/></a>';

					} else {
						$share_icon = '';
					}
					if ( $order_id == $gifting_id ) {
						$has_orders = true;
						$html .= '<tr>';
						foreach ( $order->get_items() as $item_id => $item ) {
							$product = $item->get_product();
							$html .= '<td><a href="' . wc_get_endpoint_url( 'view-order', $order_id, wc_get_page_permalink( 'myaccount' ) ) . '">#' . $order_id . '</a></td>';
						}
						$html .=    '<td>' . $order_date->date( get_option( 'date_format' ) ) . '</td>
									<td>' . wc_price( wps_wgm_hpos_get_meta_data( $order_id, 'suborder#amttotal', true ) ) . '</td>
									<td><a href="' . wc_get_endpoint_url( 'view-details', $order_id, wc_get_page_permalink( 'myaccount' ) ) . '">View </a></td>
									<td>' . $share_icon . '<a class="wps_copyLinkButton wps-group-tool-tip" href="' . $copy_link . '"><span class="dashicons dashicons-admin-links"></span></a></td>
						</tr>';
					}
				}
				if ( ! $has_orders ) {
					$html .= '<tr>
								 <td colspan="5" style="text-align: center;">' . __( 'No Group Orders Found.', 'giftware' ) . '</td>
							  </tr>';
				}
					$html .= '</tbody>	</table></div></div>';

			} else {
					$html = '
							<div id="wps_gift_card_balance_wrapper_order" class="gc-card-table-wrapper">
   
							<div class="gc-card-table-scroll">
							   <table class="scrollable-table" style="border-spacing: 0;">
								<thead>
									<th>' . __( 'Order ID', 'giftware' ) . '</th>
									<th>' . __( 'Order Date', 'giftware' ) . '</th>
									<th>' . __( 'Total', 'giftware' ) . '</th>
									<th>' . __( 'Order Detail', 'giftware' ) . '</th>
									<th>' . __( 'Share', 'giftware' ) . '</th>
								</thead>
							   <tbody id="table-body">
								   <tr>
									   <td colspan="7" style="text-align: center;">' . __( 'No Group Orders Found.', 'giftware' ) . '</td>
								   </tr>
							   </tbody>
						   </table>
						   </div>
						   </div>
						   ';
			}
				echo $html;
		}
		if ( $coupon_rechage == 'view-giftcards' ) {
			$user_id = get_current_user_id();

				$orders = wc_get_orders(
					array(
						'customer' => $user_id,
						'status' => array( 'processing', 'completed' ), // Retrieve orders of any status (you can customize this).
						'limit' => -1,     // Retrieve all orders.
					)
				);
				$html = '';
				$html .= '
							<div id="wps_gift_card_view_wrapper_order"class="gc-card-table-wrapper">
							<h4 class="wps_gift_card_view_heading" >' . __( 'View Gift Cards', 'giftware' ) . '</h4>
							<div class="gc-card-table-scroll">
							<table class="scrollable-table">
								<thead>
									<th>' . __( 'ID', 'giftware' ) . '</th>
									<th>' . __( 'Coupon Code', 'giftware' ) . '</th>
									<th>' . __( 'Order ID( Where Used )', 'giftware' ) . '</th>
									<th>' . __( 'Coupon Amount', 'giftware' ) . '</th>
									<th>' . __( 'Expiry Date', 'giftware' ) . '</th>
									<th>' . __( 'Status', 'giftware' ) . '</th>
								</thead>
								<tbody id="table-body">
							';
			if ( $orders ) {
				$wps_view_giftcard_array = array();
				foreach ( $orders as $order ) {
					$order_id = $order->get_id();
					foreach ( $order->get_items() as $item_id => $item ) {
						$coupon_code = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
						if ( isset( $coupon_code ) && ! empty( $coupon_code ) && is_array( $coupon_code ) ) {
							$coupon_code = isset( $coupon_code[0] ) ? $coupon_code[0] : '';
							$wps_view_giftcard_array_1['coupon_code'] = $coupon_code;
							$coupon = new WC_Coupon( $coupon_code );
							$wps_gw_used_coupon_details = get_post_meta( $coupon->get_id(), 'wps_uwgc_used_order_id', true );
							if ( isset( $wps_gw_used_coupon_details ) && is_array( $wps_gw_used_coupon_details ) && ! empty( $wps_gw_used_coupon_details ) ) {
								$order_ids = array();
								foreach ( $wps_gw_used_coupon_details as $key => $value ) {
									$order_id = $value['order_id'];
									$order_url = wc_get_endpoint_url( 'view-order', $order_id, get_permalink( wc_get_page_id( 'myaccount' ) ) );
									$order_ids[] = '<a href="' . esc_url( $order_url ) . '">' . esc_html( $order_id ) . '</a>';
								}
								$wps_view_giftcard_array_1['order_details'] = implode( ', ', $order_ids );
							} else {
								$wps_view_giftcard_array_1['order_details'] = __( 'Not Used', 'giftware' );
							}
							$currency_code = $order->get_currency();
							$currency_symbol = get_woocommerce_currency_symbol( $currency_code );
							$currency_position = get_option( 'woocommerce_currency_pos', 'left' );
							if ( 'left' === $currency_position || 'left_space' === $currency_position ) {
								$wps_view_giftcard_array_1['coupon_amount'] = ( 'left_space' === $currency_position ? $currency_symbol . ' ' . $coupon->get_amount() : $currency_symbol . $coupon->get_amount() );
							} else {
								$wps_view_giftcard_array_1['coupon_amount'] = ( 'right_space' === $currency_position ? $coupon->get_amount() . ' ' . $currency_symbol : $coupon->get_amount() . $currency_symbol );
							}
							$expiry_date = $coupon->get_date_expires();
							$current_date = current_time( 'timestamp' );
							$expiry_timestamp = isset( $expiry_date ) ? strtotime( $expiry_date ) : false;
							if ( ! empty ( $expiry_timestamp ) && $expiry_timestamp < $current_date ) {
								$wps_view_giftcard_array_1['status'] = __( 'Expired', 'giftware' );
							} else {
								$wps_view_giftcard_array_1['status'] = __( 'Active', 'giftware' );
							}
							$expiry_date = isset( $expiry_date ) ? gmdate('F j, Y', strtotime('-1 day', strtotime($expiry_date))): esc_html__( 'No Expiry', 'giftware' );
							$wps_view_giftcard_array_1['expiry_date'] = $expiry_date;
							array_push( $wps_view_giftcard_array, $wps_view_giftcard_array_1 );
						}
					}
					
				}
				
				$i = 1;
				foreach( $wps_view_giftcard_array as $wps_view_giftcard ) {
					$html .= '<tr>';
					$html .= '<td>#' . $i++ . '</td>';
					$html .= '<td>' . $wps_view_giftcard['coupon_code'] . '</td>';
					$html .= '<td>' . $wps_view_giftcard['order_details'] . '</td>';
					$html .= '<td>' . $wps_view_giftcard['coupon_amount'] . '</td>';
					$html .= '<td>' . $wps_view_giftcard['expiry_date'] . '</td>';
					$html .= '<td>' . $wps_view_giftcard['status'] . '</td>';
					$html .= '</tr>';
				}
				$html .= '</tbody>	</table></div></div>';

			} else {
					$html = '
							<div id="wps_gift_card_view_wrapper_order" class="gc-card-table-wrapper">

							<div class="gc-card-table-scroll">
							<table class="scrollable-table" style="border-spacing: 0;">
							<thead>
							<th>' . __( 'ID', 'giftware' ) . '</th>
							<th>' . __( 'Coupon Code', 'giftware' ) . '</th>
							<th>' . __( 'Order ID( Where Used )', 'giftware' ) . '</th>
							<th>' . __( 'Coupon Amount', 'giftware' ) . '</th>
							<th>' . __( 'Expiry Date', 'giftware' ) . '</th>
							</thead>
							<tbody id="table-body">
								<tr>
									<td colspan="7" style="text-align: center;">' . __( 'No Gift Cards Found', 'giftware' ) . '</td>
								</tr>
							</tbody>
						</table>
						</div>
						</div>
						';
			}
				echo $html;
		}
	}

	/**
	 * Show message on form submit
	 *
	 * @param string $wpg_message message to be shown on form submission.
	 * @param string $type error type.
	 * @return void
	 */
	public function show_message_on_form_submit( $wpg_message, $type = 'error' ) {
		$wpg_notice = '<div class="woocommerce"><p class="' . esc_attr( $type ) . '">' . $wpg_message . '</p>	</div>';
		echo wp_kses_post( $wpg_notice );
	}

	/**
	 * Add gc topup to cart
	 *
	 * @return void
	 */
	public function add_gc_recharge_to_cart() {
		
		if ( ! function_exists( 'WC' ) || ! WC()->session ) {
			return; // Prevent error if WooCommerce session is not available.
		}

		if ( WC()->session->__isset( 'gc_coupon_recharge' ) ) {
			
			$gc_coupon_recharge = WC()->session->get( 'gc_coupon_recharge' );

			// check if product already in cart.
			if ( count( WC()->cart->get_cart() ) > 0 ) {

				$found = false;
				foreach ( WC()->cart->get_cart() as $cart_item ) {
					$product_in_cart = $cart_item['product_id'];

					if ( $product_in_cart == $gc_coupon_recharge['productid'] ) {

						$found = true;
					}
				}
				// if product not found, add it.
				if ( ! $found ) {
					add_action( 'woocommerce_before_cart', array( $this, 'add_cart_custom_notice' ) );
					WC()->session->__unset( 'gc_recharge_amount' );

				}
				if ( $found ) {
					WC()->cart->empty_cart();
					WC()->cart->add_to_cart( $gc_coupon_recharge['productid'] );

				}
			} else {

				WC()->cart->empty_cart();
				// if no products in cart, add it.
				WC()->cart->add_to_cart( $gc_coupon_recharge['productid'] );

				wp_safe_redirect( wc_get_checkout_url() );

			}
			WC()->session->__unset( 'gc_coupon_recharge' );
		}

	}
	/**
	 * Add a filter to check if a product is already in the cart.
	 *
	 * @param string $passed $passed.
	 * @param int    $prodcut_id $product_id.
	 * @param  int    $quantity $quantity.
	 */

	public function wps_gift_prevent_duplicate_product_in_cart( $passed, $product_id, $quantity ) {
		if ( ! $passed ) {
			return $passed;
		}

		// Check if the cart is not empty
		if ( ! WC()->cart->is_empty() ) {
			// Check if the product to be added is the specific product you want to restrict.
			$specific_product_id = get_option( 'contributor_product_id' ); // Replace with the actual product ID.
			if ( $product_id == $specific_product_id ) {
				// Cart is not empty and the specific product is being added, display a notice.
				wc_add_notice( __( 'You can not purchase contribution product with other products in cart . ', 'giftware' ), 'error' );
				return false;
			}
			if ( 'yes' == get_post_meta( $product_id, 'wps_wgm_is_group_gift', true ) ) {
				wc_add_notice( __( 'You can not purchase Group gift products with other products in cart . ', 'giftware' ), 'error' );
				return false;
			}
		}

		return $passed;
	}
	/**
	 * Add notice on cart page if cart is already added with products.
	 *
	 * @return void
	 */
	public function add_cart_custom_notice() {
		wc_print_notice(
			sprintf(
				'<span class="subscription-reminder">' .
				__( 'Sorry, we cannot recharge giftcard coupon with other products, either empty cart or recharge later when cart is empty', 'giftware' ) . '</span>',
				__( 'empty', 'giftware' )
			),
			'error'
		);
	}
	/**
	 * update price on cart .
	 *
	 * @param $cart_object $cart_object.
	 */
	public function wps_gc_update_price_cart( $cart_object ) {

		$recharge_prod_id = get_option( 'wps_gccoupon_rechargeable_product_id', '' );

		$cart_items = $cart_object->cart_contents;

		if ( WC()->session->__isset( 'gc_recharge_amount' ) ) {
			$gc_coupon_recharge = WC()->session->get( 'gc_recharge_amount' );
			$price           = $gc_coupon_recharge;
			if ( ! empty( $cart_items ) ) {
				foreach ( $cart_items as $key => $value ) {

					if ( $value['product_id'] == $recharge_prod_id ) {

						$value['data']->set_price( $price );

					}
				}
			}
		}

	}

	/**
	 * Add notice on cart page if cart is already added with wallet topup.
	 *
	 * @param boolean $passed  check product can be add to cart.
	 * @param int     $product_id  product id.
	 * @return boolean
	 */
	public function wps_gc_show_message_addto_cart( $passed, $product_id ) {

		$recharge_prod_id = get_option( 'wps_gccoupon_rechargeable_product_id', '' );
		$contri_prod_id = get_option( 'contributor_product_id', '' );
		$gc_expiry_extension_product_id = get_option( 'gc_expiry_extension_product_id', '' );

		if ( ! empty( $recharge_prod_id ) ) {
			if ( ! WC()->cart->is_empty() ) {
				foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->get_id() == $recharge_prod_id ) {
						$passed = false;

						wc_add_notice(
							sprintf(
								'<span class="subscription-reminder">' .
								__( 'Sorry, you cannot buy this product since the Gift Card rechargeable product is added to the cart. If you want to buy this product, please remove Gift Card rechargeable product from the cart.', 'giftware' ) . '</span>',
								__( 'empty', 'giftware' )
							),
							'error'
						);

					}
				}
			}
		}

		if ( ! empty( $contri_prod_id ) ) {
			if ( ! WC()->cart->is_empty() ) {
				foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->get_id() == $contri_prod_id ) {
						$passed = false;

						wc_add_notice(
							sprintf(
								'<span class="subscription-reminder">' .
								__( 'You can only purchase one product at a time with your current cart item. ', 'giftware' ) . '</span>',
								__( 'empty', 'giftware' )
							),
							'error'
						);

					}
				}
			}
		}

		
		if ( ! WC()->cart->is_empty() ) {
			foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
				$_product = $values['data'];

				if ( 'yes' == get_post_meta( $_product->get_id(), 'wps_wgm_is_group_gift', true ) ) {
					$passed = false;

					wc_add_notice(
						sprintf(
							'<span class="subscription-reminder">' .
							__( 'You cannot purchase Group Gift product with other products in the cart.', 'giftware' ) . '</span>',
							__( 'empty', 'giftware' )
						),
						'error'
					);

				}
			}
		}

		if ( ! empty( $gc_expiry_extension_product_id ) ) {
			if ( ! WC()->cart->is_empty() ) {
				foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
					$_product = $values['data'];
					if ( $_product->get_id() == $gc_expiry_extension_product_id ) {
						$passed = false;

						wc_add_notice(
							sprintf(
								'<span class="subscription-reminder">' .
								__( 'Sorry, you cannot buy this product since the Gift Card Expiry Extension product is added to the cart. If you want to buy this product, please remove Gift Card Expiry Extension product from the cart.', 'giftware' ) . '</span>',
								__( 'empty', 'giftware' )
							),
							'error'
						);

					}
				}
			}
		}
	
		return $passed;
	}
	 /**
	  * Unset session after wallet topup is removed from cart.
	  *
	  * @param string $removed_cart_item_key removed cart item key.
	  * @param object $cart cart object.
	  * @return void
	  */
	public function after_remove_gc_recharge_from_cart( $removed_cart_item_key, $cart ) {
		$line_item  = $cart->removed_cart_contents[ $removed_cart_item_key ];
		$product_id = $line_item['product_id'];
		$recharge_prod_id  = get_option( 'wps_gccoupon_rechargeable_product_id', '' );
		if ( $recharge_prod_id ) {
			if ( $product_id == $recharge_prod_id ) {
				WC()->session->__unset( 'gc_recharge_amount' );

			}
		}
		if ( WC()->session->__isset( 'gc_recharge_code' ) ) {
			WC()->session->__unset( 'gc_recharge_code' );
		}
		do_action( 'wps_gccoupon_remove_value_from_session', $removed_cart_item_key );

	}
	// Group gifting product functions ///////////////////////////////.

	/**
	 *
	 */
	public function wps_contri_product_price_field() {
		global $product;
		$product_id = $product->get_id();
		if ( get_option( 'contributor_product_id' ) == $product_id ) {

			echo '<div class="wps-custom-price"><div ><lable for="contri_product_price">Enter price <abbr class="required" title="required">*</abbr></lable></div><div><input type="number" id="contri_product_price" class="contri_product_price" name="contri_product_price"  min="1" required> </div>';

			if ( isset( $_GET['order_id'] ) && isset( $_GET['prod_id'] ) ) {
				echo '<input type="hidden" name="wps_main_order_id" value="' . $_GET['order_id'] . '" id="wps_main_order_id" class="wps_main_order_id" />';
				echo '<input type="hidden" name="wps_main_prod_id" value="' . $_GET['prod_id'] . '" id="wps_main_prod_id" class="wps_main_prod_id" />';
				echo '</div>';
			}
		}

		if ( get_option( 'gc_expiry_extension_product_id' ) == $product_id ) {

			$wps_uwgc_expiry_extension_giftcard_text = ! empty( get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_text', true ) ) ? get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_text', true ) : array();
			$wps_uwgc_expiry_extension_giftcard_price = ! empty( get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_price', true ) ) ? get_post_meta( $product_id, 'wps_uwgc_expiry_extension_giftcard_price', true ) : array();

			$wps_price = 0;
			if ( isset( $wps_uwgc_expiry_extension_giftcard_price ) && is_array( $wps_uwgc_expiry_extension_giftcard_price ) && ! empty( $wps_uwgc_expiry_extension_giftcard_price ) ) {
				$wps_price = ( '' != $wps_uwgc_expiry_extension_giftcard_price[0] ) ? $wps_uwgc_expiry_extension_giftcard_price[0] : 0;
			}
			echo '<p class="wps_wgm_section">
					<span id="wps_expiry_extension_currency" class="wps_expiry_extension_currency">' . wc_price( $wps_price ) . '</span>
				</p>';
			echo '<div class="wps-custom-price">
					<p>
						<label for="wps_uwgc_expiry_extension_price">' . __( 'Select Extension Options', 'giftware' ) . ' :</label>
						<select id="wps_uwgc_expiry_extension_price" class="wps_uwgc_expiry_extension_price" name="wps_uwgc_expiry_extension_price" required>';
							foreach( $wps_uwgc_expiry_extension_giftcard_price as $key => $value ) {
								echo '<option data-expiry-days="' . $wps_uwgc_expiry_extension_giftcard_text[$key] . '" value="'. $value . '">' . $wps_uwgc_expiry_extension_giftcard_text[$key] . __( ' Days ', 'giftware' ) . '</option>';
							}
					echo '</select>
					</p>
					 <p>
						<label>' . __( 'Coupon Code', 'giftware' ) . '</label>
						<input type="text" id="wps_expiry_extension_coupon_code" name="wps_expiry_extension_coupon_code" class="wps_expiry_extension_coupon_code" placeholder="' . __( 'Enter Coupon Code', 'giftware' ) . '" required="required">
						<input type="hidden" id="wps_uwgc_expiry_extension_days" name="wps_uwgc_expiry_extension_days" value="' . ( ! empty($wps_uwgc_expiry_extension_giftcard_text[0]) ? esc_html( $wps_uwgc_expiry_extension_giftcard_text[0] ) : "") . '">
					</p>
				</div>';
		}
	}
	/**
	 * Save.
	 */
	public function wps_save_contri_product_price( $cart_item_data, $product_id ) {
		if ( isset( $_POST['contri_product_price'] ) ) {
			$contri_product_price = floatval( sanitize_text_field( $_POST['contri_product_price'] ) );
			if ( $contri_product_price > 0 ) {
				$cart_item_data['contri_product_price'] = $contri_product_price;
				$cart_item_data['price'] = $contri_product_price;
			}
		}
		if ( isset( $_POST['wps_uwgc_expiry_extension_price'] ) ) {
			if ( isset( $_POST['wps_expiry_extension_coupon_code'] ) ) {
				$item_meta['wps_expiry_extension_coupon_code'] = sanitize_text_field( wp_unslash( $_POST['wps_expiry_extension_coupon_code'] ) );
			}
			if ( isset( $_POST['wps_uwgc_expiry_extension_days'] ) ) {
				$item_meta['wps_uwgc_expiry_extension_days'] = sanitize_text_field( wp_unslash( $_POST['wps_uwgc_expiry_extension_days'] ) );
			}

			$cart_item_data['product_meta'] = array( 'meta_data' => $item_meta );
			
			$wps_uwgc_expiry_extension_price = isset( $_POST['wps_uwgc_expiry_extension_price'] ) ? floatval( sanitize_text_field( $_POST['wps_uwgc_expiry_extension_price'] ) ) : '';
			$cart_item_data['wps_uwgc_expiry_extension_price'] = $wps_uwgc_expiry_extension_price;
		}
		return $cart_item_data;
	}
	/**
	 * Hide product.
	 */
	public function wps_gift_contri_hide_product_from_category( $q ) {
		// Define the product ID to hide.
		$product_id_to_hide = get_option( 'contributor_product_id' );

		// Check if the query is for the shop or category pages.
		if ( ( is_shop() || is_product_category() ) && $q->is_main_query() ) {
			// Get the current queried product IDs.
			$queried_product_ids = $q->get( 'post__not_in' );

			// Add the product ID to the array of excluded product IDs.
			$queried_product_ids[] = get_option( 'contributor_product_id' );

			// Set the updated list of excluded product IDs.
			$q->set( 'post__not_in', $queried_product_ids );
		}
	}
	/**
	 *
	 */
	public function wps_contri_prod_display_custom_price_in_cart( $product_price, $cart_item, $cart_item_key ) {
		if ( isset( $cart_item['contri_product_price'] ) ) {
			$contri_product_price = wc_price( $cart_item['contri_product_price'] );
			return $contri_product_price;
		}
		if ( isset( $cart_item['wps_uwgc_expiry_extension_price'] ) ) {
			$wps_uwgc_expiry_extension_price = wc_price( $cart_item['wps_uwgc_expiry_extension_price'] );
			return $wps_uwgc_expiry_extension_price;
		}
		return $product_price;
	}
	/**
	 * Custom price.
	 *
	 * @param object $cart cart.
	 */
	public function wps_contri_prod_update_cart_total_with_custom_price( $cart ) {
		if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
			return;
		}

		foreach ( $cart->cart_contents as $cart_item_key => $cart_item ) {
			if ( isset( $cart_item['contri_product_price'] ) ) {
				$cart_item['data']->set_price( $cart_item['contri_product_price'] );
			}
			if ( isset( $cart_item['wps_uwgc_expiry_extension_price'] ) ) {
				$cart_item['data']->set_price( $cart_item['wps_uwgc_expiry_extension_price'] );
			}
		}
	}
	/**
	 * Notice for contribution product.
	 *
	 * @param object $cart cart.
	 */
	public function wps_gift_contri_add_product_notice( $cart ) {

		global $product;
		$id = $product->get_id();
		$html = '';
		$contri_prod_id = get_option( 'contributor_product_id' );
		$item_id = isset( $_GET['order_id'] ) ? wps_wgm_hpos_get_meta_data( $_GET['order_id'], 'temp_item_id', true ) : '';

		if ( $contri_prod_id == $id ) {

			if ( empty( $_GET['order_id'] ) || empty( $_GET['prod_id'] ) ) {

				$html .= '<style>
				.single_add_to_cart_button{
					pointer-events: none; /* Disable clicking */
					opacity: 0.6; /* Reduce opacity for visual indication */
					cursor: not-allowed; /* Show "not allowed" cursor */
				}
				</style>';

			} else if ( isset( $_GET['order_id'], $_GET['prod_id'] ) ) {

				$order_id = sanitize_text_field( $_GET['order_id'] );
				$prod_id = sanitize_text_field( $_GET['prod_id'] );
			
				$send_meta = wps_wgm_hpos_get_meta_data( $order_id, "{$order_id}#{$item_id}#send", true );
				$giftcard_send_meta = wps_wgm_hpos_get_meta_data( $order_id, "{$order_id}#{$item_id}#giftcard_send", true );
			
				if ( ( ! empty( $send_meta ) && $send_meta === 'send' ) || ( ! empty( $giftcard_send_meta ) && $giftcard_send_meta === 'send' ) ) {
					$html .= '<style>.product-notice { display: none; }</style>';
					$html .= '<style>
					.single_add_to_cart_button{
						pointer-events: none; /* Disable clicking */
						opacity: 0.6; /* Reduce opacity for visual indication */
						cursor: not-allowed; /* Show "not allowed" cursor */
					}
					</style>
					<div class="woocommerce-error" role="error">' . __( 'Sorry, Link is Expire now you can not contribute for this product', 'giftware' ) . '</div>';
				}
			}
		}
		echo $html;
	}
	/**
	 * back button on myaccount section .
	 */
	public function wps_gift_add_myaccount_back_button() {
		// Get the previous page URL if available.
	}

	public function wps_uwgc_expiry_extend_to_existing_coupon( $order_id, $old_status, $new_status ) {
		if ( $old_status != $new_status ) {

			if ( 'completed' == $new_status || 'processing' == $new_status ) {
				$order = wc_get_order( $order_id );

				foreach ( $order->get_items() as $item_id => $item ) {
					$coupon_code   = '';
					$days_extended = '';
					foreach ( $item->get_meta_data() as $key => $value ) {
						if ( isset( $value->key ) && 'Coupon Code' == $value->key && ! empty( $value->value ) ) {
							$coupon_code = $value->value;
						}
						if ( isset( $value->key ) && 'Days Extended' == $value->key && ! empty( $value->value ) ) {
							$days_extended = $value->value;
						}
					}

					$coupon = new WC_Coupon( $coupon_code );

					if ( $coupon->is_valid() ) {

						$coupon_id = $coupon->get_id();

						$woo_ver = WC()->version;

						if ( $woo_ver < '3.6.0' ) {

							$current_expiry = get_post_meta( $coupon_id, 'expiry_date', true );

						} else {
							$current_expiry = get_post_meta( $coupon_id, 'date_expires', true );
						}

						if ( isset( $current_expiry ) && ! empty( $current_expiry ) ) {
							$new_expiry = strtotime( '+' . intval( $days_extended ) . ' days', $current_expiry );
							update_post_meta( $coupon_id, 'date_expires', $new_expiry );
						}

						// Translators: %1$s is the number of days extended, %2$s is the coupon code.
						$order->add_order_note( sprintf( __( 'Expiry extended by %1$s days for coupon %2$s.', 'giftware' ), $days_extended, $coupon_code ) );

						wps_wgm_hpos_update_meta_data( $order_id, 'wps_wgm_expiry_extension_already', 'send' );
					} else {
						// Translators: %s is the coupon code.
						echo esc_html( sprintf( __( 'Coupon %s is not available.', 'giftware' ), $coupon_code ) );
					}
				}
			}
		}
	}

	public function wps_wgm_validate_coupon_usage_restriction( $valid, $coupon ) {
		$excluded_days = get_post_meta( $coupon->get_id(), 'wps_wgm_excluded_days', true );
		$current_day = strtolower( date( 'l' ) );
		if ( ! empty( $excluded_days ) && in_array( $current_day, $excluded_days ) ) {
			// Translators: %s is the current day of the week.
			throw new Exception( sprintf( __( 'This coupon cannot be used on %s.', 'giftware' ), ucfirst( $current_day ) ) );
		}
		return $valid;
	}

	public function wps_wgm_send_gc_via_whatsapp( $wps_wgm_common_arr, $order ) {
		$wps_public_obj = new Woocommerce_Gift_Cards_Common_Function();
		$wps_notification_settings = get_option( 'wps_wgm_notification_settings', array() );
		$wps_wgm_enable_whatsapp_notification = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_enable_whatsapp_notification' );
		$wps_wgm_whatsapp_phone_number_id = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_whatsapp_phone_number_id' );
		$wps_wgm_whatsapp_access_token = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_whatsapp_access_token' );
		$wps_wgm_whatsapp_template_name = $wps_public_obj->wps_wgm_get_template_data( $wps_notification_settings, 'wps_wgm_whatsapp_template_name' );
		$contact_no = '';
		$item_id = '';
		$to = '';
		$from = '';
		$message = '';
		$coupon = '';
		$order_id = $order->get_id();
		if ( array_key_exists( 'contact_no', $wps_wgm_common_arr ) ) {
			$contact_no = $wps_wgm_common_arr['contact_no'];
		}
		if ( array_key_exists( 'delivery_method', $wps_wgm_common_arr ) ) {
			$delivery_method = $wps_wgm_common_arr['delivery_method'];
		} else {
			$delivery_method = 'Mail to recipient';
		}
		if ( array_key_exists( 'item_id', $wps_wgm_common_arr ) ) {
			$item_id = $wps_wgm_common_arr['item_id'];
		}
		if ( array_key_exists( 'to_name', $wps_wgm_common_arr ) ) {
			$to = $wps_wgm_common_arr['to_name'];
		} elseif ( array_key_exists( 'to', $wps_wgm_common_arr ) ) {
			$to = $wps_wgm_common_arr['to'];
		}
		if ( array_key_exists( 'from', $wps_wgm_common_arr ) ) {
			$from = $wps_wgm_common_arr['from'];
		}
		if ( array_key_exists( 'gift_msg', $wps_wgm_common_arr ) ) {
			$message = $wps_wgm_common_arr['gift_msg'];
		}
		if ( array_key_exists( 'product_id', $wps_wgm_common_arr ) ) {
			$product_id = $wps_wgm_common_arr['product_id'];
		}
		if ( array_key_exists( 'expirydate', $wps_wgm_common_arr ) ) {
			$expirydate_format = $wps_wgm_common_arr['expirydate'];
		}
		$message = sanitize_text_field( wp_unslash( $message ) );
		$bloginfo = get_bloginfo();
		$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#send", true );
		if ( '' == $itemgiftsend ) {
			$itemgiftsend = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id#giftcard_send", true );
		}

		if ( '' !== $wps_wgm_enable_whatsapp_notification ) {
			if ( '' !== $contact_no ) {
				if ( isset( $delivery_method ) && 'Shipping' !== $delivery_method ) {
					$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$item_id", true );
					if ( empty( $gift_couponnumber ) ) {
						$gift_couponnumber = wps_wgm_hpos_get_meta_data( $order_id, "$order_id#$product_id", true );
					}
					foreach ( $gift_couponnumber as $key => $value ) {
						$coupon = $value;
						$the_coupon = new WC_Coupon( $value );
					}
					$couponamont = $the_coupon->get_amount();
					$couponamont = $couponamont . get_woocommerce_currency();
					if ( 'send' == $itemgiftsend ) {
						$api_header = array(
							'Content-Type: application/json',
							'Authorization: Bearer ' . $wps_wgm_whatsapp_access_token,
						);
						
						$curl_data = array(
							"messaging_product" => "whatsapp",
							"to" => $contact_no,
							"type" => "template",
							"template" => array(
								"name" => $wps_wgm_whatsapp_template_name,
								"language" => array(
									"code" => "en"
								),
								"components" => array(
									array(
										"type" => "header",
										"parameters" => array(
											array(
												"type" => "text",
												"text" => $bloginfo
											)
										)
									),
									array(
										"type" => "body",
										"parameters" => array(
											array(
												"type" => "text",
												"text" => $to
											),
											array(
												"type" => "text",
												"text" => $message
											),
											array(
												"type" => "text",
												"text" => $from
											),
											array(
												"type" => "text",
												"text" => $coupon
											),
											array(
												"type" => "text",
												"text" => $couponamont
											),
											array(
												"type" => "text",
												"text" => $expirydate_format
											),
										)
									)
								)
							)
						);
				
						$data = json_encode( $curl_data );
				
						// LOAD THE WC LOGGER
						$logger = wc_get_logger();
				
						$curl = curl_init();
				
						curl_setopt_array( $curl, array(
						CURLOPT_URL => 'https://graph.facebook.com/v21.0/' . $wps_wgm_whatsapp_phone_number_id . '/messages',
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_ENCODING => '',
						CURLOPT_MAXREDIRS => 10,
						CURLOPT_TIMEOUT => 0,
						CURLOPT_FOLLOWLOCATION => true,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						CURLOPT_CUSTOMREQUEST => 'POST',
						CURLOPT_POSTFIELDS =>$data,
						CURLOPT_HTTPHEADER => $api_header,
						));
					
						$response = curl_exec($curl);
				
						// LOG THE Result
						$logger->info( wc_print_r( 'Order ID : ' . $order_id . ' Response from Whatsapp API :' . $response, true ), array( 'source' => 'giftcard-whatsapp-api' ) );
					
						curl_close($curl);
				
						$response = json_decode( $response, true );

						if ( isset( $response['messages'][0]['message_status'] ) && ! empty( $response['messages'][0]['message_status'] ) && 'accepted' == $response['messages'][0]['message_status'] ) {
							$note = __( 'Gift Card Whatsapp Message has been sent.', 'giftware' );
							$order->add_order_note( $note );
						}
					}
				}
			}
		}
	}
	
}

