/**
 * All of the public javascript code should reside in this file.
 *
 * @package           Ultimate Woocommerce Gift Cards
 */

(function ($) {
	'use strict';

	$(document).ready(function (e) {

		$('#wps_whatsapp_contact').on('input', function() {
            var contactNumber = $(this).val();
            var isValid = /^[0-9]+$/.test(contactNumber);

            if (!isValid) {
                $(this).css('border', '2px solid red');
                if (!$('#wps_whatsapp_error').length) {
                    $(this).after('<span id="wps_whatsapp_error">'+ wps_uwgc_param.contact_number +'</span>');
                }
            } else {
                $(this).css('border', '');
                $('#wps_whatsapp_error').remove();
            }
        });

		jQuery('.wps_gift_this_product').click(function(){
			
			if(jQuery('.wps_gift_this_product').is(":checked")) {
				setTimeout(function (e) {
					jQuery('.wps_wgm_added_wrapper').addClass('wps-gc_lay-2');
					jQuery('.wps_demo_browse.wps_for_variable_product').show();
				 }, 250)
			} 
		});

		jQuery('div .wps-ts__head').attr('id', 'wps-ts__head_field');
		jQuery('div .wps-ts__h-item_1').attr('id', 'wps-ts__item_1');
		jQuery('div .wps-ts__h-item_2').attr('id', 'wps-ts__item_2');
		jQuery('div .wps-ts__h-item_3').attr('id', 'wps-ts__item_3');
		jQuery('div .wps-ts__h-item_4').attr('id', 'wps-ts__item_4');
		
		// Add wps-ts__active class to the first .wps-ts__h-item
		if (!jQuery('.wps-ts__head .wps-ts__h-item').hasClass('wps-ts__active')) {
			jQuery('.wps-ts__head .wps-ts__h-item:first-child').addClass('wps-ts__active');
		}

		// Add wps-ts__active class to the first .wps-ts__b-item
		if (!jQuery('.wps-ts__body .wps-ts__b-item').hasClass('wps-ts__active')) {
			jQuery('.wps-ts__body .wps-ts__b-item:first-child').addClass('wps-ts__active');
		}

		jQuery('.wps-ts__body .wps-ts__b-item:first-child input[type=radio]').prop('checked', true);

		jQuery(document).on('click', '.wps-ts__head .wps-ts__h-item', function () {
			jQuery('.wps-ts__head .wps-ts__h-item').removeClass('wps-ts__active');
			jQuery(this).addClass('wps-ts__active');
			jQuery('.wps-ts__body .wps-ts__b-item').removeClass('wps-ts__active');
			var index = $(this).index();
			var activeDescriptionItem = $('.wps-ts__body .wps-ts__b-item:eq(' + index + ')');

			activeDescriptionItem.addClass('wps-ts__active');
			jQuery('.wps-ts__body .wps-ts__b-item').find('input[type=radio]').prop('checked', false);
			jQuery('.wps-ts__body .wps-ts__b-item.wps-ts__active').find('input[type=radio]').prop('checked', true);

			// jQuery('.wps-ts__body .wps-ts__b-item.wps-ts__active *').show();
			//$('#wps_wgm_contribution_field').hide();
		});

		$(document).on('change','#wps_uwgc_browse_img',function(){
			var fileName = $(this).val().split("\\").pop(); // Get the file name without the path
			$('.wps_wgm_featured_img').removeClass('wps_wgm_pre_selected_temp');
			$(this).prevAll('.wps-gc__upload-icon').addClass('wps_wgm_pre_selected_temp');
			$(".selected-file-name-span").text(fileName || "No file selected");
			$('.wps_wgm_featured_img').on('click', function () {
				$('.wps-gc__upload-icon').removeClass('wps_wgm_pre_selected_temp');
				$(this).addClass('wps_wgm_pre_selected_temp');
			})
		})
		

		$(document).on('click', '#wps-ts__item_4', function () {
			//$('#wps_wgm_contribution_field').show();
		})

	})
	jQuery(document).ready(
		function () {

			var timeoutId;
			$('.variations select').on('change', function () {
				clearTimeout(timeoutId);
				timeoutId = setTimeout(function () {
					wps_wgm_variation_product_price();
				}, 300);

			});

			function wps_wgm_variation_product_price() {
				var variationId = $('input[name="variation_id"]').prop('value');
				console.log(variationId);
				var data = {
					action: 'wps_get_variation_price',
					variationId: variationId,
					product_id: wps_uwgc_param.product_id,
					wps_uwgc_nonce: wps_uwgc_param.wps_uwgc_nonce
				}
				$.ajax(
					{
						url: wps_uwgc_param.ajaxurl,
						type: "POST",
						data: data,
						dataType: 'json',
						success: function (response) {
							if (response.result == true) {
								console.log(response);
								$('#wps_wgm_price').val(response.variation_price);
							}
						}
					}
				);
			}

			// date picker for schedule date for giftcard.
			$('#wps_uwgc_send_date').datepicker(
				{

					dateFormat: wps_uwgc_param.selected_date,
					minDate: wps_uwgc_param.is_group_gift_prod
				}
			).datepicker("setDate", wps_uwgc_param.is_group_gift_prod);

			var a = new Date();
			var timeZoneOffset = wps_uwgc_param.timezone_offset*60 //Set specific timezone according to our need. i.e. GMT+1
			a.setMinutes(a.getMinutes() + a.getTimezoneOffset() + timeZoneOffset);

			var date = new Date(a),
			mnth = ("0" + (date.getMonth() + 1)).slice(-2),
			day = ("0" + date.getDate()).slice(-2);
			var formatdate = [day, mnth, date.getFullYear()].join("/");

			function convertToDDMMYYYY( inputdate ) {

				if (!inputdate) {
					return "";
				}

				if ( wps_uwgc_param.selected_date == 'dd/mm/yy' || wps_uwgc_param.selected_date == 'dd.mm.yy' ) {
					var inputdate1 = inputdate.replace( /\./g, '/' );
					return inputdate1;
				}
			
				var parsedDate = new Date(inputdate);

				if (isNaN(parsedDate.getTime())) {
					return "";
				}
			
				var day = ("0" + parsedDate.getDate()).slice(-2);
				var month = ("0" + (parsedDate.getMonth() + 1)).slice(-2);
				var year = parsedDate.getFullYear();
			
				return day + "/" + month + "/" + year;
			}

			wps_wgm_time( date );

			function wps_wgm_time( date ) {
				if ( convertToDDMMYYYY($( "#wps_uwgc_send_date" ).val()) == formatdate ) {
					var time = date.getHours();
					var timerange = '';
					timerange  += '<option value="now">' + wps_uwgc_param.time_now_string + '</option>';
					for( var i = time+1; i < 24; i++ ) {
						if ( wps_uwgc_param.time_format == '24-hour' ) {
							timerange  += '<option value="' + i + ':00">' + i + ':00 </option>';
						} else {
							var j          = ( i > 11 ) ? ( i - 12 ) : i;
							var start_time = ( 0 === j ) ? 12 : j;
							timerange  += ( i < 12 ) ? '<option value="' + i + ':00">' + start_time + ':00 AM </option>' : '<option value="' + i + ':00">' + start_time + ':00 PM </option>';
						}
					}
					$( '#wps_wgm_time').html(timerange);
				} else {
					var timerange = '';
					for( var i = 0; i < 24; i++ ) {
						if ( wps_uwgc_param.time_format == '24-hour' ) {
							timerange  += '<option value="' + i + ':00">' + i + ':00 </option>';
						} else {
							var j          = ( i > 11 ) ? ( i - 12 ) : i;
							var start_time = ( 0 === j ) ? 12 : j;
							timerange  += ( i < 12 ) ? '<option value="' + i + ':00">' + start_time + ':00 AM </option>' : '<option value="' + i + ':00">' + start_time + ':00 PM </option>';
						}
					}
					$( '#wps_wgm_time').html(timerange);
				}
			}

			//on change we change the input field date
			$( '#wps_uwgc_send_date' ).on('change', function(val){
				$('#wps_uwgc_send_date').val($( this ).val());
				if ( convertToDDMMYYYY($( "#wps_uwgc_send_date" ).val()) == formatdate ) {
					wps_wgm_time( date );
				} else {
					var timerange = '';
					for( var i = 0; i < 24; i++ ) {
						if ( wps_uwgc_param.time_format == '24-hour' ) {
							timerange  += '<option value="' + i + ':00">' + i + ':00 </option>';
						} else {
							var j          = ( i > 11 ) ? ( i - 12 ) : i;
							var start_time = ( 0 === j ) ? 12 : j;
							timerange  += ( i < 12 ) ? '<option value="' + i + ':00">' + start_time + ':00 AM </option>' : '<option value="' + i + ':00">' + start_time + ':00 PM </option>';
						}
					}
					$( '#wps_wgm_time').html(timerange);
				}
			});

			// for delivery method.
			var radio_on_load = $("input[name='wps_wgm_send_giftcard']:checked").val();
			wps_wgm_check_which_radio_has_been_selected(radio_on_load);
			function wps_wgm_check_which_radio_has_been_selected(radioVal) {
				$('.wps_wgm_quantity_one_per_recipient').hide();
				$('.wps_wgm_msg_info_multiple_name').hide();
				$('.wps_wgm_msg_info').show();
				$('.quantity').show();
				if (radioVal == "Mail to recipient") {
					$("#wps_wgm_to_download").val("");
					$("#wps_wgm_to_ship").val("");
					$(".wps_wgm_delivery_via_admin").hide();
					$(".wps_wgm_delivery_via_email").show();
					$(".wps_wgm_delivery_via_buyer").hide();
					$("#wps_wgm_to_email").attr("readonly", false);
					$("#wps_wgm_to_name_optional").attr("readonly", false);
				} else if (radioVal == "Downloadable") {
					$("#wps_wgm_to_email").val("");
					$("#wps_wgm_to_ship").val("");
					$("#wps_wgm_to_name_optional").val("");
					$(".wps_wgm_delivery_via_admin").hide();
					$(".wps_wgm_delivery_via_email").hide();
					$(".wps_wgm_delivery_via_buyer").show();
					$("#wps_wgm_to_download").attr("readonly", false);
				} else if (radioVal == "shipping") {

					$("#wps_wgm_to_email").val("");
					$("#wps_wgm_to_download").val("");
					$("#wps_wgm_to_name_optional").val("");
					$("#wps_wgm_to_ship").attr("readonly", false);
					$(".wps_wgm_delivery_via_admin").show();
					$(".wps_wgm_delivery_via_email").hide();
					$(".wps_wgm_delivery_via_buyer").hide();
				}
			}

			$('body').on('click', '#wps_gift_this_product', function () {
				$(document).ajaxComplete(function () {

					jQuery('div .wps-ts__h-item_1').attr('id', 'wps-ts__item_1');
					jQuery('div .wps-ts__h-item_2').attr('id', 'wps-ts__item_2');
					jQuery('div .wps-ts__h-item_3').attr('id', 'wps-ts__item_3');

					var radio_on_load = $("input[name='wps_wgm_send_giftcard']:checked").val();
					wps_wgm_check_which_radio_has_been_selected(radio_on_load);
					function wps_wgm_check_which_radio_has_been_selected(radioVal) {
						if (radioVal == "Mail to recipient") {
							$("#wps_wgm_to_download").val("");
							$("#wps_wgm_to_ship").val("");
							$(".wps_wgm_delivery_via_admin").hide();
							$(".wps_wgm_delivery_via_email").show();
							$(".wps_wgm_delivery_via_buyer").hide();
							$("#wps_wgm_to_email").attr("readonly", false);
							$("#wps_wgm_to_name_optional").attr("readonly", false);
						} else if (radioVal == "Downloadable") {
							$("#wps_wgm_to_email").val("");
							$("#wps_wgm_to_ship").val("");
							$("#wps_wgm_to_name_optional").val("");
							$(".wps_wgm_delivery_via_admin").hide();
							$(".wps_wgm_delivery_via_email").hide();
							$(".wps_wgm_delivery_via_buyer").show();
							$("#wps_wgm_to_download").attr("readonly", false);
						} else if (radioVal == "shipping") {

							$("#wps_wgm_to_email").val("");
							$("#wps_wgm_to_download").val("");
							$("#wps_wgm_to_name_optional").val("");
							$("#wps_wgm_to_ship").attr("readonly", false);
							$(".wps_wgm_delivery_via_admin").show();
							$(".wps_wgm_delivery_via_email").hide();
							$(".wps_wgm_delivery_via_buyer").hide();
						}
					}

					$('#wps_uwgc_send_date').datepicker(
						{
							dateFormat: wps_uwgc_param.selected_date,
							minDate: 0
						}
					).datepicker("setDate", "0");

					if (wps_uwgc_param.disable_from_field) {
						$('.wps_from').hide();
					}
					if (wps_uwgc_param.disable_message_field) {
						$('.wps_message').hide();
					}
					if (wps_uwgc_param.disable_to_email_field) {
						$('.wps_wgm_to_email').hide();
					} else {
						$('.wps_wgm_to_email').show();
					}
				});
			});

			$('body').on('change', '.wps_wgm_send_giftcard',
				function () {
					var radioVal = $(this).val();
					wps_wgm_check_which_radio_has_been_selected(radioVal);
				}
			);
			// to check the image type for giftcard on single product page.
			jQuery('body').on('change', '#wps_uwgc_browse_img',
				function () {
					var error = false;
					var html = "<ul>";
					var image_br = jQuery(this).val();
					var extension = image_br.substring(image_br.lastIndexOf('.') + 1).toLowerCase();
					var all_ext = ["gif", "png", "jpeg", "jpg", "pjpeg", "x-png"];
					var exists = all_ext.indexOf(extension);
					if (exists == -1) {
						$("#wps_wgm_error_notice").hide();
						error = true;
						$("#wps_wgm_to_email").addClass("wps_wgm_error");
						html += "<li><b>";
						html += wps_uwgc_param.browse_error;
						html += "</li>";
						$(this).val("");
					}
					if (error) {
						$("#wps_wgm_error_notice").html(html);
						$("#wps_wgm_error_notice").show();
						jQuery('html, body').animate(
							{
								scrollTop: jQuery(".woocommerce-page").offset().top
							},
							800
						);
					}
				}
			);
			// appends discount price for giftcard.
			$(document).on(
				'change',
				'#wps_wgm_price',
				function () {
					var wps_uwgc_price = $(this).val();
					var product_id = wps_uwgc_param.product_id;
					var wps_wgm_discount = wps_uwgc_param.wps_wgm_discount;
					var discount_enable = wps_uwgc_param.discount_enable;
					var html = '';
					var new_price = '';
					$(document).find('.wps_wgm_price_content').remove();
					if (wps_wgm_discount == 'yes' && discount_enable == 'on') {

						block($('.summary.entry-summary'));
						var data = {
							action: 'wps_uwgc_append_prices',
							wps_uwgc_price: wps_uwgc_price,
							product_id: product_id,
							wps_uwgc_nonce: wps_uwgc_param.wps_uwgc_nonce
						};
						$.ajax(
							{
								url: wps_uwgc_param.ajaxurl,
								type: "POST",
								data: data,
								dataType: 'json',
								success: function (response) {
									if (response.result == true) {
										var new_price = response.new_price;
										var wps_uwgc_price = response.wps_uwgc_price;
										var html = '';
										html += '<div class="wps_wgm_price_content"><b style="color:green;">' + wps_uwgc_param.discount_price_message + '</b>';
										html += '<b style="color:green;">' + new_price + '</b><br/>';
										html += '<b style="color:green;">' + wps_uwgc_param.coupon_message + '</b>';
										html += '<b style="color:green;">' + wps_uwgc_price + '</b></div>';
									}

									$(html).insertAfter($('p.price'));

								},
								complete: function () {
									unblock($('.summary.entry-summary'));
								}
							}
						);
					}
				}
			);


			// send mail forcefully when click on Send Toaday Button.
			$('.wps_uwgc_send_mail_force').click(
				function () {
					var order_id = $(this).data('id');
					var item_id = $(this).data('num');
					$("#wps_uwgc_send_mail_force_notification_" + item_id).html("");
					$("#wps_wgm_loader").show();
					var data = {
						action: 'wps_uwgc_send_mail_forcefully',
						order_id: order_id,
						item_id: item_id,
						wps_uwgc_nonce: wps_uwgc_param.wps_uwgc_nonce
					};
					$.ajax(
						{
							url: wps_uwgc_param.ajaxurl,
							type: "POST",
							data: data,
							dataType: 'json',
							success: function (response) {
								console.log(response);
								$("#wps_wgm_loader").hide();
								if (response.result == true) {
									var message = response.message;
									var html = '<b style="color:green;">' + message + '</b>';
									$('#wps_send_force_div_' + item_id).hide();
								} else {
									var message = response.message;
									var html = '<b style="color:red;">' + message + '</b>';

								}
								$("#wps_uwgc_send_mail_force_notification_" + item_id).html(html);
							}
						}
					);
				}
			);

			// resend mail from order details page at front-end.
			$('#wps_uwgc_resend_mail_button_frontend').click(
				function (e) {
					e.preventDefault();
					$("#wps_uwgc_resend_mail_frontend_notification").html("");
					var order_id = $(this).data('id');
					$("#wps_wgm_loader").show();
					var data = {
						action: 'wps_uwgc_resend_mail_order_deatils_frontend',
						order_id: order_id,
						wps_uwgc_nonce: wps_uwgc_param.wps_uwgc_nonce
					};
					$.ajax(
						{
							url: wps_uwgc_param.ajaxurl,
							type: "POST",
							data: data,
							dataType: 'json',
							success: function (response) {
								$("#wps_wgm_loader").hide();
								if (response.result == true) {
									var message = response.message;
									var html = '<b style="color:green;">' + message + '</b>';
								} else {
									var message = response.message;
									var html = '<b style="color:red;">' + message + '</b>';
								}
								$("#wps_uwgc_resend_mail_frontend_notification").html(html);
							}
						}
					);
				}
			);

			$('#wps_gift_this_product').on('click', function () {
				if ($(this).prop("checked") == true) {
					var wps_product = $(this).data('product');
					$.ajax({
						type: "POST",
						url: wps_wgm.ajaxurl,
						data: { action: "wps_get_data", wps_product: wps_product, wps_gc_nonce: wps_wgm.wps_gc_nonce },
						success: function (data) {
							$('#wps_purchase_as_a_gc').html(data);
							wps_wgm_variation_product_price();
						},
					});
				} else {
					$('#wps_purchase_as_a_gc').html('');
				}
			});

			if (wps_uwgc_param.disable_from_field) {
				$('.wps_from').hide();
			}
			if (wps_uwgc_param.disable_message_field) {
				$('.wps_message').hide();
			}
			if (wps_uwgc_param.disable_to_email_field) {
				$('.wps_wgm_to_email').hide();
			} else {
				$('.wps_wgm_to_email').show();
			}

			$('.wps_uwgc_price_button').on('click', function () {
				var txt = $(this).val();
				var numb = txt.replace(/[^0-9.,]/g, '');
				// $('#wps_wgm_price').val($(this).val());
				$('#wps_wgm_price').val(numb);
				$(this).css('background-color', 'red');
				$(this).css('color', 'white');
				$(this).siblings().css('background-color', '');
				$(this).siblings().css('color', '');
			});

			$(document).on('click', '#wps-ts__item_1', function () {
				$('#wps_wgm_to_email_send').attr( 'checked', 'checked');
				var radioVal = $('#wps_wgm_to_email_send').val();
				wps_wgm_check_which_radio_has_been_selected(radioVal);
			})
			$(document).on('click', '#wps-ts__item_2', function () {
				$('#wps_wgm_send_giftcard_download').attr( 'checked', 'checked');
				var radioVal = $('#wps_wgm_send_giftcard_download').val();
				wps_wgm_check_which_radio_has_been_selected(radioVal);
			})
			$(document).on('click', '#wps-ts__item_3', function () {
				$('#wps_wgm_send_giftcard_ship').attr( 'checked', 'checked');
				var radioVal = $('#wps_wgm_send_giftcard_ship').val();
				wps_wgm_check_which_radio_has_been_selected(radioVal);
			})
		}
	);
})(jQuery);

// preview button validation.
var wps_wgm_preview_validation = function (html, error, form_Data) {

	var html = '';
	var to_mail = '';
	var schedule_date = jQuery(document).find('#wps_uwgc_send_date').val();

	if (schedule_date != undefined) {
		if (schedule_date == null || schedule_date == '') {
			error = true;
			jQuery(document).find("#wps_uwgc_send_date").addClass("wps_wgm_error");
			html += "<li><b>";
			html += wps_uwgc_param.send_date;
			html += "<b></li>";
		}
	}

	var delivery_method = jQuery(document).find('input[name="wps_wgm_send_giftcard"]:checked').val();

	// remove validation from to name field.
	if (wps_wgm_remove_validation_to_name() == 'on') {
		if (delivery_method == 'Mail to recipient') {
			to_mail = jQuery(document).find('#wps_wgm_to_name_optional').val();
			if (to_mail == null || to_mail == '') {
				to_mail = jQuery("#wps_wgm_to_email").val();
			}
		}
	} else {
		if (delivery_method == 'Mail to recipient') {
			to_mail = jQuery(document).find('#wps_wgm_to_name_optional').val();
			if (to_mail == null || to_mail == '') {
				error = true;
				jQuery(document).find("#wps_wgm_to_name_optional").addClass("wps_wgm_error");
				html += "<li><b>";
				html += wps_uwgc_param.to_name;
				html += "<b></li>";
			}
		}
		if (delivery_method == 'shipping') {
			to_mail = jQuery(document).find('#wps_wgm_to_ship').val();
			if (to_mail == null || to_mail == '') {
				error = true;
				jQuery(document).find("#wps_wgm_to_ship").addClass("wps_wgm_error");
				html += "<li><b>";
				html += wps_wgm.to_empty_name;
				html += "<b></li>";
			}
		}
	}
	if (delivery_method == 'Downloadable') {
		to_mail = jQuery(document).find('#wps_wgm_to_download').val();
	}
	// remove validation  from to field.
	if (wps_wgm_remove_validation_to() == 'on') {

		if (delivery_method == 'shipping') {
			to_mail = jQuery(document).find('#wps_wgm_to_ship').val();
		}
	}
	if (jQuery(document).find('#wps_uwgc_browse_img').val() != undefined) {
		form_Data.append('file', jQuery('input[type=file]')[0].files[0]);
	}

	var wps_wgm_preview_data = { 'html': html, 'error': error, 'to_mail': to_mail, 'form_Data': form_Data, 'send_date': schedule_date };
	return wps_wgm_preview_data;
};

var wps_wgm_remove_validation_msg = function () {
	return wps_uwgc_param.remove_validation_msg;
};
var wps_wgm_remove_validation_from = function () {
	return wps_uwgc_param.remove_validation_from;
};
var wps_wgm_remove_validation_to = function () {
	return wps_uwgc_param.remove_validation_to;
};
var wps_wgm_remove_validation_to_name = function () {
	return wps_uwgc_param.remove_validation_to_name;
};
// add_to_card button validation.
var wps_wgm_add_to_card_validation = function (html, error) {
	var html = '';
	var to_mail = '';
	var delivery_method = jQuery(document).find('input[name="wps_wgm_send_giftcard"]:checked').val();
	var enable_sms_notification = wps_uwgc_param.enable_sms_notification;
	// remove validation from to name field.
	if (wps_wgm_remove_validation_to_name() == 'on') {
		if (delivery_method == 'Mail to recipient') {
			to_mail = jQuery(document).find('#wps_wgm_to_name_optional').val();
			if (to_mail == null || to_mail == '') {
				to_mail = jQuery("#wps_wgm_to_email").val();
			}
		}
	} else {
		if (delivery_method == 'Mail to recipient') {
			if (wps_uwgc_param.is_customizable != 'yes') {
				to_mail = jQuery(document).find('#wps_wgm_to_name_optional').val();
				if (to_mail == null || to_mail == '') {
					error = true;
					jQuery(document).find("#wps_wgm_to_name_optional").addClass("wps_wgm_error");
					html += "<li><b>";
					html += wps_uwgc_param.to_name;
					html += "<b></li>";
				}
			}
		}
	}
	if (delivery_method == 'Downloadable') {
		to_mail = jQuery(document).find('#wps_wgm_to_download').val();
	}
	// remove validation  from to field.
	if (wps_wgm_remove_validation_to() == 'on') {

		if (delivery_method == 'shipping') {
			to_mail = jQuery(document).find('#wps_wgm_to_ship').val();
		}
	}
	if (enable_sms_notification == 'on') {
		var contact = jQuery(document).find('#wps_whatsapp_contact').val();
		if (contact != null || contact != "") {
			var data = {
				action: 'wps_wgm_validate_twilio_contact_number',
				wps_contact: contact,
				wps_uwgc_nonce: wps_uwgc_param.wps_uwgc_nonce
			};

			jQuery.ajax(
				{
					url: wps_uwgc_param.ajaxurl,
					type: 'POST',
					async: false,
					cache: false,
					dataType: 'json',
					data: data,
					success: function (response) {
						if (response.result == 'Invalid') {
							error = true;
							jQuery(document).find("#wps_whatsapp_contact").addClass("wps_wgm_error");
							html += "<li><b>";
							html += wps_uwgc_param.invalid_contact;
							html += "</li>";
						}
					}
				}
			);
		}
	}
	if (wps_uwgc_param.is_addon_active != null && wps_uwgc_param.is_addon_active != '') {
		var response = wps_wgm_addon_validation(error);
		html += response.html;
		error = response.error;
	}
	var wps_wgm_add_to_cart_data = { 'html': html, 'error': error, 'to_mail': to_mail };
	return wps_wgm_add_to_cart_data;
};
	var block = function ($node) {
		if (!is_blocked($node)) {
			$node.addClass('processing').block(
				{
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.6
					}
				}
			);
		}
	};
	var is_blocked = function ($node) {
		return $node.is('.processing') || $node.parents('.processing').length;
	};
	var unblock = function ($node) {
		$node.removeClass('processing').unblock();
	};

	jQuery(document).ready(function () {

		if (jQuery('#wps_gift_card_balance_wrapper_recharge').is(':visible')) {

			jQuery('#wps_giftcard_recharge_tab a').addClass('active');
		} else if (jQuery('#wps_gift_card_balance_wrapper_check').is(':visible')) {

			jQuery('#wps_giftcard_balance_tab a').addClass('active');
		} else if (jQuery('#wps_gift_card_balance_wrapper_order').is(':visible')) {
			jQuery('#wps_giftcard_order_tab a').addClass('active');
		} else if (jQuery('#wps_gift_card_view_wrapper_order').is(':visible')) {
			jQuery('#wps_giftcard_view_tab a').addClass('active');
		}
		jQuery('.wps-order-status').each(function () {
			var status = jQuery(this).html(); // Use 'this' to refer to the current element

			console.log(status);

			if (status === "on-hold") {
				jQuery(this).addClass('wps-on-hold');
			}
			if (status === "completed") {
				jQuery(this).addClass('wps-completed');
			}
			if (status === "processing") {
				jQuery(this).addClass('wps-processing');
			}
		});
	});
	jQuery(document).ready(function () {

		const $copyLinkButton = jQuery('.wps_copyLinkButton');

		// Add a click event handler to the anchor element
		$copyLinkButton.on('click', function (e) {
			e.preventDefault(); // Prevent the anchor from navigating

			// Get the href attribute of the anchor
			const linkToCopy = $copyLinkButton.attr('href');

			// Create a temporary input element to copy the link to the clipboard
			const $tempInput = jQuery('<input>');
			jQuery('body').append($tempInput);
			$tempInput.val(linkToCopy).select();

			try {
				// Use the Clipboard API to copy the text to the clipboard
				document.execCommand('copy');
				jQuery(this).append('<span class="wps-copied-text-msg">Copied!</span>');
				setTimeout(function () {
					jQuery('.wps-copied-text-msg').remove();
				}, 200);
			} catch (err) {
				jQuery(this).parent().append('<span class="wps-copied-text-msg">Oops!</span>');
			}

			// Remove the temporary input element
			$tempInput.remove();
		});
	});
	/////////////////////////////////////////////////////////////
