<div class="ohio-widget clb-gallery <?php echo $this->getWrapperClasses(); ?>" data-gallery="<?php echo esc_attr( $gallery_uniqid ); ?>">

	<?php
		$_image_start = 0;
		$_image_end = count( $settings['images'] );
		$_gallery_item = 0;

		if ( !empty( $settings['use_pagination'] ) ) {
			$_image_start = $_gallery_item = $pagination_page * $items_per_page - $items_per_page;

			if ( in_array( $settings['pagination_type'], [ 'simple', 'standard' ] ) ) {
				$_gallery_item = 0;
			}

			if ( $_image_end > $_image_start + $items_per_page ) {
				$_image_end = $_image_start + $items_per_page;
			}
		}
	?>

	<div
		class="vc_row <?php if ( !empty( $settings['masonry_grid'] ) ) { echo 'ohio-masonry'; } ?>"
		data-lazy-container="gallery"
		data-masonry-alignment="<?php echo $settings['masonry_grid_alignment'] ?>"
	>
	
		<?php for ( $_image_i = $_image_start; $_image_i < $_image_end; $_image_i++, $_gallery_item++ ) : ?>

		<?php $image = $settings['images'][ $_image_i ]; ?>

		<div class="masonry-block gallery-item card cursor-as-pointer <?php echo esc_attr( $grid_classes ); ?> <?php echo implode( ' ', $column_class ); ?> " data-gallery-item="<?php echo $_gallery_item; ?>" data-lazy-item="" data-lazy-scope="gallery">
			<div class="image-holder cursor-plus" data-cursor-class="cursor-link" <?php if ( $settings['tilt_effect'] ) { echo esc_attr( $tilt_attrs ); } ?>>
			    <img class="gimg gallery-archive-image hidden-image" src="<?php echo ( $image['url'] ) ? $image['url'] : '#'; ?>" alt="<?php echo esc_html( get_the_title( $image['id'] ) ); ?>">

			    <?php if ( $settings['gallery_layout'] == 'minimal' && $settings['preview_title'] ) : ?>
				    <div class="overlay-details -fade-up">
				        <div class="heading">
				            <h5 class="title"><?php echo esc_html( get_the_title( $image['id'] ) ); ?></h5>
				        </div>
				    </div>
			    <?php endif; ?>

			</div>

			<?php if ( $settings['preview_title'] ) : ?>
				<div class="card-details">
				    <div class="heading">
				        <h5 class="title"><?php echo esc_html( get_the_title( $image['id'] ) ); ?></h5>
				        <p class="caption -unspace -small-t"><?php echo esc_html( wp_get_attachment_caption( $image['id'] ) ); ?></p>
				    </div>
				</div>
			<?php endif; ?>

		</div>
			
		<?php endfor; ?>

	</div>

	<?php 
	    if ( !empty( $settings['use_pagination'] ) ) {
	        $large_number = 10000000;
	        $paginator_pattern = str_replace( $large_number, '{{page}}', get_pagenum_link( $large_number ) );

	        if ( $settings['pagination_type'] == 'standard' ) {

	            OhioLayout::the_paginator_layout( $pagination_page, $pages_count, $settings['pagination_position'], $settings['pagination_style'], $settings['pagination_size'] );

	        } elseif ( $settings['pagination_type'] == 'lazy_scroll' ) {

	            echo '<div class="lazy-load loading ' . implode( ' ', $additional_classes ) . '" data-lazy-load="scroll" ';
		            echo 'data-lazy-pages-count="' . esc_attr( $pages_count ) . '" ';
		            echo 'data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" ';
					echo 'data-lazy-load-id="' . wp_unique_prefixed_id('ohio-paginator-') . '" ';
		            echo 'data-lazy-load-scope="gallery">';
		            echo '<button class="button -pagination ' . implode( ' ', $style_class ) . '">';
		            	echo '<span class="loading-text">' . esc_html__( 'Loading', 'ohio-extra' ) . '</span>';
		            echo '</button>';
	            echo '</div>';

	        } elseif ( $settings['pagination_type'] == 'lazy_button' ) {

	            echo '<div class="lazy-load load-more ' . implode( ' ', $additional_classes ) . '" data-lazy-load="click" ';
		            echo 'data-lazy-pages-count="' . esc_attr( $pages_count ) . '" ';
		            echo 'data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" ';
					echo 'data-lazy-load-id="' . wp_unique_prefixed_id('ohio-paginator-') . '" ';
		            echo 'data-lazy-load-scope="gallery">';
		            echo '<button class="button -pagination ' . implode( ' ', $style_class ) . '">';
			            echo '<span class="loadmore-text">' . esc_html__( 'Load More', 'ohio-extra' ) . '</span>';
			            echo '<span class="loading-text">' . esc_html__( 'Loading', 'ohio-extra' ) . '</span>';
		            echo '</button>';
	            echo '</div>';
	        }
	    }
	?>
</div>

<?php
	ob_start();
?>

<div class="clb-popup ohio-gallery-opened-sc clb-gallery-lightbox" id="<?php echo $gallery_uniqid; ?>" data-options='<?php echo $gallery_json; ?>'>
	<div class="close-bar">
	    <button class="icon-button -light" data-js="close-popup" aria-label="<?php esc_html_e( 'Close', 'ohio' ); ?>">
		    <i class="icon">
		    	<svg class="default" width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><path d="M14 1.41L12.59 0L7 5.59L1.41 0L0 1.41L5.59 7L0 12.59L1.41 14L7 8.41L12.59 14L14 12.59L8.41 7L14 1.41Z"></path></svg>
		    </i>
		</button>
	</div>
    <div class="clb-popup-holder"></div>
</div>

<?php
	OhioLayout::append_to_footer_buffer_content( ob_get_clean() );
