<?php
defined( 'ABSPATH' ) || exit;


if ( ! class_exists( 'YITH_YWRAQ_Email' ) ) {
	class YITH_YWRAQ_Email extends WC_Email {
		/**
		 * The quote request data
		 *
		 * @var array
		 */
		public $raq = null;

		protected static $dummy_quote = null;

		protected static $dummy_product = null;

		public function __construct() {
			parent::__construct();
		}

		/**
		 * Get the current RAQ information
		 *
		 * @return array
		 */
		public function get_raq() {
			if ( apply_filters( 'woocommerce_is_email_preview', false ) ) {
				$this->raq = $this->get_dummy_raq();
			}
			return $this->raq;
		}

		/**
		 * Get the dummy RAQ information
		 *
		 * @return array
		 */
		public function get_dummy_raq() {
			$dummy_quote = self::get_dummy_quote();
			$dummy_raq   = array(
				'order_id'     => $dummy_quote->get_id(),
				'content_type' => 'order_items',
				'raq_content'  => $dummy_quote->get_items(),
			);
			return $dummy_raq;
		}

		/**
		 * Get the dummy quote for preview
		 *
		 * @return WC_Order
		 */
		public static function get_dummy_quote() {
			if ( null === self::$dummy_quote ) {
				self::$dummy_quote = new WC_Order();
				// Add dummy product.
				self::$dummy_quote->add_product( self::get_dummy_product() );
				// Add quote metadata.
				self::$dummy_quote->set_meta_data(
					array(
						'ywraq_customer_message' => _x( 'Quote product', '[ADMIN] Email preview', 'yith-woocommerce-request-a-quote' ),
						'_ywcm_request_response' => '',
						'ywraq_customer_email'   => 'john.doe@yith.test',
						'ywraq_customer_name'    => 'John Doe',
					)
				);
				// Set remaining order data.
				self::$dummy_quote->set_id( '128' );
				self::$dummy_quote->set_date_created( time() );
				self::$dummy_quote->set_currency( 'USD' );
				self::$dummy_quote->set_total( 10 );
			}
			return self::$dummy_quote;
		}

		public static function get_dummy_product() {
			if ( null === self::$dummy_product ) {
				self::$dummy_product = new WC_Product();
				self::$dummy_product->set_name( _x( 'Quote product', '[ADMIN] Email preview', 'yith-woocommerce-request-a-quote' ) );
				self::$dummy_product->set_id( 0 );
				self::$dummy_product->set_price( 10 );
			}
			return self::$dummy_product;
		}
	}
}
