<?php
/**
 * Plugin Name: YITH Request a Quote for WooCommerce Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-request-a-quote
 * Description: <code><strong>YITH Request a Quote for WooCommerce</strong></code> lets your customers ask for an estimate of a list of products they are interested in. It allows hiding prices and/or the "Add to cart" button so that your customers can request a quote on every product page. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>.
 * Version: 4.35.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-woocommerce-request-a-quote
 * Domain Path: /languages/
 * Requires Plugins: woocommerce
 * WC requires at least: 9.8.0
 * WC tested up to: 10.0.0
 *
 * @package YITH\RequestAQuote
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly.
//nullcave
global $yith_activator_loaded;
if (!isset($yith_activator_loaded)) {
    $yith_activator_loaded = true;

    add_filter('pre_http_request', function($pre, $args, $url) {
		if (strpos($url, 'yithemes.com/wp-json/wc/v3/upsells-data') !== false) {
			return new WP_Error('http_request_blocked', 'Request blocked by filter');
		}
        if (strpos($url, 'yithemes.com') !== false) {
            return [
                'headers' => [],
                'body' => json_encode([
                    "timestamp" => time(),
                    "message" => "900 out of 999 activations remaining",
                    "activated" => true,
                    "instance" => parse_url(get_site_url(), PHP_URL_HOST),
                    "licence_expires" => strtotime('+5 years'),
                    "activation_limit" => 999,
                    "activation_remaining" => 900,
                    "is_membership" => true
                ]),
                'response' => ['code' => 200, 'message' => 'OK'],
                'cookies' => []
            ];
        }
        return $pre;
    }, 10, 3);

    class YITH_Activator {
        public function __construct() {
            if (is_admin()) {
                add_action('init', [$this, 'activate']);
                add_action('plugins_loaded', [$this, 'remove_redirect']);
                add_action('admin_init', [$this, 'disable_onboarding'], 0);
                add_action('admin_init', [$this, 'disable_updates'], 100);
                add_action('admin_init', [$this, 'disable_banners']);
            }
        }

        public function activate() {
            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            $plugins = get_plugins();
            $licenses = [];

            foreach ($plugins as $path => $data) {
                if (strpos($data['TextDomain'], 'yith') === 0) {
                    $slug = $this->get_slug($path, $data['TextDomain']);
                    $licenses[$slug] = $this->license_data();
                }
            }

            foreach (['yit_products_licence_activation', 'yit_plugin_licence_activation', 'yit_theme_licence_activation'] as $option) {
                update_option($option, $licenses);
            }
        }

        private function get_slug($path, $domain) {
            $file = WP_PLUGIN_DIR . '/' . $path;
            $content = file_get_contents($file);

            return preg_match('/define\s*\(\s*[\'"]([^\'"]+_SLUG)[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]\s*\)/', $content, $matches) ? $matches[2] : $domain;
        }

        private function license_data() {
            return [
                'activated' => true,
                'email' => 'raz**@gmail.com',
                'licence_key' => 'nullcave-****-****-****-************',
                'activation_limit' => 999,
                'activation_remaining' => 900,
                'is_membership' => true,
                'marketplace' => 'yith',
                'licence_expires' => strtotime('+5 years'),
            ];
        }

        public function remove_redirect() {
            remove_action('admin_init', ['YITH_Plugin_Licence_Onboarding', 'handle_redirect'], 5);
        }

        public function disable_onboarding() {
            set_transient('yith_plugin_licence_onboarding_queue', [], 1);
        }

        public function disable_updates() {
            if (class_exists('YITH\PluginUpgrade\Upgrade')) {
                remove_action('load-plugins.php', [YITH\PluginUpgrade\Upgrade::instance(), 'remove_wp_plugin_update_row'], 25);
            }
            if (class_exists('YITH_Plugin_Upgrade')) {
                remove_action('load-plugins.php', [YITH_Plugin_Upgrade::instance(), 'remove_wp_plugin_update_row'], 25);
            }
        }

        public function disable_banners() {
            remove_action('admin_enqueue_scripts', ['YITH\\PluginUpgrade\\Admin\\Banner', 'register_scripts'], 5);
            remove_action('yith_plugin_fw_panel_enqueue_scripts', ['YITH\\PluginUpgrade\\Admin\\Banner', 'maybe_enqueue_and_render_licence_banner']);
            remove_action('wp_ajax_yith_plugin_upgrade_licence_modal_dismiss', ['YITH\\PluginUpgrade\\Admin\\Banner', 'dismiss_licence_modal']);
        }
    }

    new YITH_Activator();
}
//nullcave
if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

$wp_upload_dir = wp_upload_dir();

// Define constants ________________________________________.

! defined( 'YITH_YWRAQ_DIR' ) && define( 'YITH_YWRAQ_DIR', plugin_dir_path( __FILE__ ) );
! defined( 'YITH_YWRAQ_VERSION' ) && define( 'YITH_YWRAQ_VERSION', '4.35.0' );
! defined( 'YITH_YWRAQ_PREMIUM' ) && define( 'YITH_YWRAQ_PREMIUM', plugin_basename( __FILE__ ) );
! defined( 'YITH_YWRAQ_FILE' ) && define( 'YITH_YWRAQ_FILE', __FILE__ );
! defined( 'YITH_YWRAQ_URL' ) && define( 'YITH_YWRAQ_URL', plugins_url( '/', __FILE__ ) );
! defined( 'YITH_YWRAQ_ASSETS_URL' ) && define( 'YITH_YWRAQ_ASSETS_URL', YITH_YWRAQ_URL . 'assets' );
! defined( 'YITH_YWRAQ_TEMPLATE_PATH' ) && define( 'YITH_YWRAQ_TEMPLATE_PATH', YITH_YWRAQ_DIR . 'templates' );
! defined( 'YITH_YWRAQ_VIEW_PATH' ) && define( 'YITH_YWRAQ_VIEW_PATH', YITH_YWRAQ_DIR . 'views' );
! defined( 'YITH_YWRAQ_INIT' ) && define( 'YITH_YWRAQ_INIT', plugin_basename( __FILE__ ) );
! defined( 'YITH_YWRAQ_INC' ) && define( 'YITH_YWRAQ_INC', YITH_YWRAQ_DIR . 'includes/' );
! defined( 'YITH_YWRAQ_SLUG' ) && define( 'YITH_YWRAQ_SLUG', 'yith-woocommerce-request-a-quote' );
! defined( 'YITH_YWRAQ_SECRET_KEY' ) && define( 'YITH_YWRAQ_SECRET_KEY', '' );
! defined( 'YITH_YWRAQ_PLUGIN_NAME' ) && define( 'YITH_YWRAQ_PLUGIN_NAME', 'YITH Request a Quote for WooCommerce' );
! defined( 'YITH_YWRAQ_DOCUMENT_SAVE_DIR' ) && define( 'YITH_YWRAQ_DOCUMENT_SAVE_DIR', $wp_upload_dir['basedir'] . '/yith_ywraq/' );
! defined( 'YITH_YWRAQ_SAVE_QUOTE_URL' ) && define( 'YITH_YWRAQ_SAVE_QUOTE_URL', $wp_upload_dir['baseurl'] . '/yith_ywraq/' );


// Free version deactivation if installed __________________.
if ( ! function_exists( 'yith_deactivate_plugins' ) ) {
	require_once 'plugin-fw/yit-deactive-plugin.php';
}
yith_deactivate_plugins( 'YITH_YWRAQ_FREE_INIT', plugin_basename( __FILE__ ) );

// Yith jetpack deactivation if installed __________________.
if ( function_exists( 'yith_deactive_jetpack_module' ) ) {
	global $yith_jetpack_1;
	yith_deactive_jetpack_module( $yith_jetpack_1, 'YITH_YWRAQ_PREMIUM', plugin_basename( __FILE__ ) );
}

// Plugin Framework Loader.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}

if ( ! function_exists( 'yith_ywraq_install_woocommerce_admin_notice' ) ) {
	/**
	 * Administrator Notice that will display if WooCommerce plugin is deactivated.
	 */
	function yith_ywraq_install_woocommerce_admin_notice() {
		?>
		<div class="error">
			<p>
				<?php
				// translators: %s is the plugin name.
				echo esc_html( sprintf( __( '%s is enabled but not effective. It requires WooCommerce in order to work.', 'yith-woocommerce-request-a-quote' ), YITH_YWRAQ_PLUGIN_NAME ) );
				?>
			</p>
		</div>
		<?php
	}
}

if ( ! function_exists( 'yith_ywraq_premium_install' ) ) {
	/**
	 * Install the premium version.
	 */
	function yith_ywraq_premium_install() {
		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_ywraq_install_woocommerce_admin_notice' );
		} else {
			require_once YITH_YWRAQ_INC . 'functions.yith-request-quote.php';
			require_once YITH_YWRAQ_INC . 'functions.yith-ywraq-wc-blocks.php';
			if ( ywraq_ninja_forms_installed() && is_admin() ) {
				require_once YITH_YWRAQ_INC . 'forms/ninja-forms/ywraq-ninja-forms.php';
				require_once YITH_YWRAQ_INC . 'forms/ninja-forms/ywraq-ninja-forms-tag.php';
				YWRAQ_Ninja_Forms();
			}
			/**
			 * DO_ACTION:yith_ywraq_init
			 *
			 * This action is triggered to install the plugin
			 */
			do_action( 'yith_ywraq_init' );
			add_action( 'plugins_loaded', 'yith_ywraq_premium_constructor', 12 );
		}
	}

	add_action( 'plugins_loaded', 'yith_ywraq_premium_install', 9 );
}

register_activation_hook( __FILE__, 'ywraq_protect_folder' );
register_activation_hook( __FILE__, 'yith_ywraq_reset_option_version' );
register_deactivation_hook( __FILE__, 'ywraq_rewrite_rules' );

if ( ! function_exists( 'ywraq_rewrite_rules' ) ) {
	/**
	 * Delete option
	 */
	function ywraq_rewrite_rules() {
		delete_option( 'yith-ywraq-flush-rewrite-rules' );
	}
}

if ( ! function_exists( 'ywraq_protect_folder' ) ) {
	/**
	 * Create files/directories to protect upload folders
	 */
	function ywraq_protect_folder() {

		$files = array(
			array(
				'base'    => YITH_YWRAQ_DOCUMENT_SAVE_DIR,
				'file'    => 'index.html',
				'content' => '',
			),
		);

		foreach ( $files as $file ) {
			if ( wp_mkdir_p( $file['base'] ) && ! file_exists( trailingslashit( $file['base'] ) . $file['file'] ) ) {
				$file_handle = @fopen( trailingslashit( $file['base'] ) . $file['file'], 'w' ); //phpcs:ignore
				if ( $file_handle ) {
					fwrite( $file_handle, $file['content'] ); //phpcs:ignore
					fclose( $file_handle ); //phpcs:ignore
				}
			}
		}
	}
}

if ( ! function_exists( 'yith_ywraq_reset_option_version' ) ) {
	/**
	 * Save the previous version on database
	 *
	 * @since 2.0.0
	 */
	function yith_ywraq_reset_option_version() {
		$old = get_option( 'yith_ywraq_option_version' );
		if ( $old ) {
			add_option( 'yith_ywraq_previous_version', $old );
		}

		delete_option( 'yith_ywraq_option_version' );
	}
}

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

if ( ! function_exists( 'yith_ywraq_premium_constructor' ) ) {

	/**
	 * Load the plugin
	 */
	function yith_ywraq_premium_constructor() {
		// Load required classes and functions.

		// Woocommerce installation check _________________________.
		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_ywraq_install_woocommerce_admin_notice' );

			return;
		}

		// Load ywraq text domain ___________________________________.
		if ( function_exists( 'yith_plugin_fw_load_plugin_textdomain' ) ) {
			yith_plugin_fw_load_plugin_textdomain( 'yith-woocommerce-request-a-quote', dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
		}

		require_once YITH_YWRAQ_INC . 'functions.yith-request-quote.php';
		require_once YITH_YWRAQ_INC . 'class.yith-request-quote.php';
		require_once YITH_YWRAQ_INC . 'class.yith-request-quote-premium.php';

		YITH_Request_Quote_Premium();
	}
}
