<?php

if ( (!has_post_thumbnail($post->ID) && (!$replace)) || $replace) {

    self::aicc_log_register($post->ID, 'error', 'Generando imagen destacada (IA) para "'.$post->post_title.'"', 'aicc_bulk_curation_image');

    update_option('aicc_last_item_time', current_time('timestamp'));

    $is_canceled = $wpdb->get_var("SELECT option_value FROM $wpdb->options WHERE option_name = 'aicc_cancel_bulk_process' LIMIT 1");
    $is_canceled = $is_canceled === '1';
    if ($is_canceled) {
        self::aicc_log_register(0, 'warning', 'Proceso cancelado manualmente.', 'aicc_bulk_curation_image');
        if (isset($this->bulk) && method_exists($this->bulk, 'cancel')) {
            $this->bulk->cancel();
        }
        return false;
    }

    if ($totalCost >= $budget && $budget > 0) {
        self::aicc_log_register(0, 'warning', 'Cancelación del proceso por superar límite de presupuesto.', 'aicc_bulk_curation_image');
        if (isset($this->bulk) && method_exists($this->bulk, 'cancel')) {
            $this->bulk->cancel();
        }
        return false;
    }

    if ($set_prompt && !empty($user_prompt)) {
        $prompt_image = $user_prompt;
        $prompt_image = str_replace('{post_title}', $post_title, $prompt_image);
        $prompt_image = str_replace('{post_content}', $post_content, $prompt_image);
    } else {
        curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');

        $prompt = 'Basado en la keyword "' . $post_title . '", crea una descripción detallada para una imagen que capture visualmente el concepto de esta keyword. La descripción debe ser lo suficientemente detallada para ser utilizada como prompt en una generación de imagen, incluyendo elementos visuales específicos, emociones que se quieren transmitir y cualquier otro detalle relevante que enriquezca la representación visual del concepto. Devuelve solo el prompt, sin agregar ningún dato adicional, ni hacer referencia a estas instrucciones.';

        $messages = [
            ["role" => "system", "content" => "Eres un Prompt Engineer"],
            ["role" => "user","content" => $prompt]
        ];

        $primerosPostFields = [
            "model" => $model_prompt,
            "messages" => $messages,
            "temperature" => 0.7
        ];

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($primerosPostFields));

        // Configuración de reintentos
        $retryCount = 0;
        $result = false;

        while ($retryCount < $maxRetries && !$result) {
            $result = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            if ($result === false || $httpcode >= 400) {
                $curlError = curl_errno($ch);
                $curlErrorMsg = curl_error($ch);
                $consecutiveFailures++;

                if ($consecutiveFailures >= $maxConsecutiveFailures) {
                    throw new Exception("Número máximo de fallos consecutivos alcanzado, cancelando el proceso.");
                }

                if ($curlError) {
                    self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al error de cURL: $curlErrorMsg", 'aicc_bulk_curation_content');
                } else {
                    self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al código de estado HTTP: $httpcode", 'aicc_bulk_curation_content');
                }

                if ($httpcode == 401 || $httpcode == 429) {
                    // No tiene sentido reintentar en caso de error de autenticación o límite de tarifas
                    throw new Exception("Error con código $httpcode, verifique las credenciales de la API o la política de límites de tarifas.");
                }

                // Incrementa el contador de reintentos y espera antes de reintentar
                $retryCount++;
                sleep(5);
                $result = false;
            } else {
                $consecutiveFailures = 0; // Restablece el contador de fallos si hay éxito
            }
        }

        if (!$result) {
            $discarded++;
            update_option('aicc_bulk_discarded_count', $discarded);
            $error_message = 'Error por respuesta de OpenAI vacía.';
            self::aicc_log_register('', 'error', $error_message, 'aicc_bulk_curation_image_prompt');
            return false;
        }

        $response = json_decode($result);
        if (json_last_error() !== JSON_ERROR_NONE) {
            $discarded++;
            update_option('aicc_bulk_discarded_count', $discarded);
            $json_error_message = json_last_error_msg();
            $error_message = 'La respuesta de OpenAI no se pudo decodificar. Error JSON: ' . $json_error_message . '. Respuesta recibida: ' . $result;
            self::aicc_log_register('', 'error', $error_message, 'aicc_bulk_curation_image_prompt');
            return false;
        }

        if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) {
            $discarded++;
            update_option('aicc_bulk_discarded_count', $discarded);
            $error_message = 'Respuesta inesperada de OpenAI. Respuesta completa: ' . $result;
            self::aicc_log_register('', 'error', $error_message, 'aicc_bulk_curation_image_prompt');
            return false;
        }

        $prompt_image = $response->choices[0]->message->content;
        $usage = $response->usage;
        $tokens = $usage->total_tokens;

        $totalTokens += $tokens;
        update_option('aicc_bulk_total_tokens', $totalTokens);
        $costPromptImage += self::aicc_calculate_process_cost($prompt, $model_prompt, $tokens);

        sleep(1);
    }

    if ($prompt_image) {

        if ($motor == 'openai') {

            $message = 'Motor de generación de imágenes seleccionado: OpenAI';
            self::aicc_log_register(0, 'warning', $message, 'aicc_maker');

            curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/images/generations');

            $model = 'dall-e-3';
            $segundosPostFields = array(
                "model" => $model,
                "prompt" => $prompt_image,
                'quality' => $quality,
                "size" => $size,
                "n" => 1
            );

            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($segundosPostFields));

            // Configuración de reintentos
            $retryCount = 0;
            $result = false;

            while ($retryCount < $maxRetries && !$result) {
                $result = curl_exec($ch);
                $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                if ($result === false || $httpcode >= 400) {
                    $curlError = curl_errno($ch);
                    $curlErrorMsg = curl_error($ch);
                    $consecutiveFailures++;

                    if ($consecutiveFailures >= $maxConsecutiveFailures) {
                        throw new Exception("Número máximo de fallos consecutivos alcanzado, cancelando el proceso.");
                    }

                    if ($curlError) {
                        self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al error de cURL: $curlErrorMsg", 'aicc_bulk_curation_content');
                    } else {
                        self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al código de estado HTTP: $httpcode", 'aicc_bulk_curation_content');
                    }

                    if ($httpcode == 401 || $httpcode == 429) {
                        // No tiene sentido reintentar en caso de error de autenticación o límite de tarifas
                        throw new Exception("Error con código $httpcode, verifique las credenciales de la API o la política de límites de tarifas.");
                    }

                    // Incrementa el contador de reintentos y espera antes de reintentar
                    $retryCount++;
                    sleep(5);
                    $result = false;
                } else {
                    $consecutiveFailures = 0; // Restablece el contador de fallos si hay éxito
                }
            }

            if (!$result) {
                $discarded++;
                update_option('aicc_bulk_discarded_count', $discarded);
                $error_message = 'Error por respuesta de OpenAI vacía.';
                self::aicc_log_register($post_id, 'error', $error_message, 'aicc_bulk_curation_image');
                return false;
            }

            $response = json_decode($result);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $discarded++;
                update_option('aicc_bulk_discarded_count', $discarded);
                $error_message = 'La respuesta de OpenAI no se pudo decodificar. Por favor, intenta de nuevo.';
                self::aicc_log_register($post_id, 'error', $error_message, 'aicc_bulk_curation_image');
                return false;
            }

            if (!isset($response->data[0]->url)) {
                $discarded++;
                update_option('aicc_bulk_discarded_count', $discarded);
                $error_message = 'No se pudo generar la imagen. Respuesta de OpenAI: ' . $result;
                self::aicc_log_register($post_id, 'error', $error_message, 'aicc_bulk_curation_image');
                return false;
            }

            $image_url = $response->data[0]->url;

        } else {

            $replicate_style = 'flux_schnell';
            $image_url = self::aicc_generate_image_replicate($prompt_image, $replicate_style, $aspect_ratio, $api_key_replicate);

        }
    }

    if ($image_url) {
        $processed_count++;
        update_option('aicc_bulk_processed_count', $processed_count);
        try {
            $temp_image_path = self::aicc_download_image_to_temp($image_url);
            $processed_image_path = self::aicc_process_image($temp_image_path, $size, $motor, $aspect_ratio);
            if ($processed_image_path) {
                $attachment_id = self::aicc_move_image_to_media($processed_image_path, $post_id, $post_title);
                if ($attachment_id) {
                    set_post_thumbnail($post_id, $attachment_id);
                    $ids_processed[$post_id] = '';
                    update_option('aicc_bulk_ids_processed',$ids_processed);
                }
                unlink($temp_image_path);
                sleep(1);
            } else {
                $discarded++;
                update_option('aicc_bulk_discarded_count', $discarded);
                $error_message = 'Error caraiccdo la imagen en la biblioteca de medios.';
                self::aicc_log_register($post_id, 'error', $error_message, 'aicc_GenerateContent');
                return false;
            }
        } catch (Exception $e) {
            $discarded++;
            update_option('aicc_bulk_discarded_count', $discarded);
            $error_message = 'Error al crear la imagen: ' . $e->getMessage();
            self::aicc_log_register($post->ID, 'error', $error_message, 'aicc_bulk_curation_image');
            return false;
        }
    } else {
        $discarded++;
        update_option('aicc_bulk_discarded_count', $discarded);
        $error_message = 'Error en la respuesta al crear la imagen.';
        self::aicc_log_register($post->ID, 'error', $error_message, 'aicc_bulk_curation_image');
        return false;        
    }

    if ($motor == 'openai') {
        $totalCost = ($processed_count * 0.08) + $costPromptImage;
    } else {
        $totalCost = ($processed_count * 0.003) + $costPromptImage;
    }

    update_option('aicc_bulk_total_cost', $totalCost);
    
}


?>
