<?php
	// Configuración de reintentos
	$retryCount = 0;
	$result = false;

	while ($retryCount < $maxRetries && !$result) {
	    $result = curl_exec($ch);
	    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	    update_option('aicc_last_item_time', current_time('timestamp'));    

	    if ($result === false || $httpcode >= 400) {
	        $curlError = curl_errno($ch);
	        $curlErrorMsg = curl_error($ch);
	        $consecutiveFailures++;

	        if ($consecutiveFailures >= $maxConsecutiveFailures) {
	            throw new Exception("Número máximo de fallos consecutivos alcanzado, cancelando el proceso.");
	        }

	        if ($curlError) {
	            self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al error de cURL: $curlErrorMsg", 'aicc_bulk_curation_content');
	        } else {
	            self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al código de estado HTTP: $httpcode", 'aicc_bulk_curation_content');
	        }

	        if ($httpcode == 401 || $httpcode == 429) {
	            // No tiene sentido reintentar en caso de error de autenticación o límite de tarifas
	            throw new Exception("Error con código $httpcode, verifique las credenciales de la API o la política de límites de tarifas.");
	        }

	        // Incrementa el contador de reintentos y espera antes de reintentar
	        $retryCount++;
	        sleep(5);
	        $result = false;
	    } else {
	        update_option('aicc_last_item_time', current_time('timestamp'));
	        $consecutiveFailures = 0; // Restablece el contador de fallos si hay éxito
	    }
	}

	if (!$result) {
	    $discarded++;
	    update_option('aicc_bulk_discarded_count', $discarded);
	    $error_message = 'Error por respuesta de OpenAI vacía.';
	    self::aicc_log_register($post_id, 'error', $error_message, 'aicc_bulk_curation_content');
	    return false;
	}

	/*
	 * Chequeamos errores al decodificar la respuesta
	 */
	$response = json_decode($result);

	if (json_last_error() !== JSON_ERROR_NONE) {
	    $discarded++;
	    update_option('aicc_bulk_discarded_count', $discarded);
	    $error_message = 'La respuesta de OpenAI no se pudo decodificar.';
	    self::aicc_log_register($post_id, 'error', $error_message, 'aicc_bulk_curation_content');
	    return false;
	}

	/*
	 * Chequeamos que la respuesta tenga formato adecuado
	 */
	if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) {
	    $discarded++;
	    update_option('aicc_bulk_discarded_count', $discarded);
	    $error_message = 'Respuesta inesperada de OpenAI. Respuesta completa: ' . $result;
	    self::aicc_log_register($post_id, 'error', $error_message, 'aicc_bulk_curation_content');
	    return false;
	}