<?php

$valueserp_encrypted_key = get_option('aicc_options_valueserp');
$valueserp_api = $valueserp_encrypted_key ? self::aicc_decrypt_api_key($valueserp_encrypted_key) : '';

// Verificar si falta la clave de API
if (empty($valueserp_api)) {
    self::aicc_log_register('', 'error', "API de ValueSerp no válida o no configurada", 'aicc_makeCurlRequests');
    return ['error' => true, 'message' => 'API de ValueSerp no válida o no configurada', 'status' => 400];
}


// Definir los parámetros de la API
$api_params = [
    'api_key' => $valueserp_api,
    'q' => $query,
    'hl' => $lang,
];

// Añadir el parámetro para obtener videos si la bandera está activada
if ($fetch_videos) {
    $api_params['search_type'] = 'videos';
}

// Construir la URL de la API con los parámetros
$api_url = 'https://api.valueserp.com/search?' . http_build_query($api_params);

// Mensaje de análisis (opcional)
$tipo_contenido = $fetch_videos ? 'videos' : 'contenido';
$message_vs = 'Analizando los resultados de búsqueda de ' . $tipo_contenido . ' para "' . $query . '"';
$message_vs .= ' con lenguaje "' . $lang . '".';

self::aicc_log_register('', 'aviso', $message_vs, 'stage1');

// Inicializar la petición cURL
$chvs = curl_init();

// Configurar las opciones de cURL
curl_setopt($chvs, CURLOPT_RETURNTRANSFER, true);
curl_setopt($chvs, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($chvs, CURLOPT_TIMEOUT, 180);
curl_setopt($chvs, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($chvs, CURLOPT_SSL_VERIFYPEER, false);

// Establecer la URL de la petición
curl_setopt($chvs, CURLOPT_URL, $api_url);

// Ejecutar la petición cURL
$response = curl_exec($chvs);

// Verificar el código de respuesta HTTP
$httpCode = curl_getinfo($chvs, CURLINFO_HTTP_CODE);

// Manejo de errores
if ($response === false) {
    $error = curl_error($chvs);
    self::aicc_log_register('', 'error', "Error en cURL: $error", 'aicc_makeCurlRequests');
    $response_data = ['error' => true, 'message' => $error, 'status' => $httpCode];
} elseif ($httpCode != 200) {
    $error = "Error con código HTTP: $httpCode";
    self::aicc_log_register('', 'error', "Error con HTTP: $error", 'aicc_makeCurlRequests');
    $response_data = ['error' => true, 'message' => $error, 'status' => $httpCode];
} else {
    // Si la respuesta es exitosa, decodificar el JSON
    $response_data = json_decode($response, true);
    // Log para verificar si la respuesta está vacía
    if (empty($response_data)) {
        self::aicc_log_register('', 'error', "Respuesta JSON vacía", 'aicc_makeCurlRequests');
    }    
}

// Cerrar la sesión cURL
curl_close($chvs);

?>
