<?php

    update_option('aicc_last_item_time', current_time('timestamp'));

    $is_canceled = $wpdb->get_var("SELECT option_value FROM $wpdb->options WHERE option_name = 'aicc_cancel_bulk_process' LIMIT 1");
    $is_canceled = $is_canceled === '1';
    if ($is_canceled) {
        self::aicc_log_register(0, 'warning', 'Proceso cancelado manualmente.', 'aicc_bulk_curation_image');
        if (isset($this->bulk) && method_exists($this->bulk, 'cancel')) {
            $this->bulk->cancel();
        }
        return false;       
    }

    if ($totalCost >= $budget && $budget > 0) {
        self::aicc_log_register(0, 'warning', 'Cancelación del proceso por superar límite de presupuesto.', 'aicc_bulk_curation_image');
        if (isset($this->bulk) && method_exists($this->bulk, 'cancel')) {
            $this->bulk->cancel();
        }
        return false;        
    }

    curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');

    $prompt = 'Basado en el título "' . $post_title . '", identifica una entidad principal que pueda ser utilizada para buscar imágenes relacionadas. Esta entidad debe ser un sustantivo en inglés que capture el concepto central del título de manera clara y representativa. 
    Ejemplos:

    - Si el título es "significado de soñar con mariposas", la entidad es "butterflies".
    - Si el título es "requisitos para trabajar en USA", la entidad es "work".
    - Si el título es "cómo cuidar plantas de interior", la entidad es "indoor plants".
    - Si el título es "por qué mi ex me dejó", la entidad es "sad man or woman".
    - Si el título es "Por qué un hombre besa a una mujer sin ser novios", la entidad es "kissing"
    - Si el título es "Sangrado al limpiarme después de orinar en el embarazo", la entidad es "urinate"
    - Si el título es "Que comen los caballos", la entidad es "horse eating"
    - Si el título es "Requisitos para abrir una cuenta bancaria en Argentina", la entidad es "bank"

    Cuando es algo complejo que probablemente no haya imágenes de stock, debes generar una entidad más generalista, por ejemplo:

    - Si el título es "Escarlatina en niños: síntomas, contagio y tratamiento", la entidad podría ser "cold child"
    - Si el título es "Papiroflexia para niños paso a paso", la entidad podría ser "sick kid"
    - Si el título es "Cómo saber si estoy ovulando", la entidad podría ser "pregnancy"

    Título: "' . $post_title . '"

    Devuelve solo la entidad en idioma inglés, sin agregar comillas ni comentarios ni explicaciones adicionales. Solo la entidad.';

    $messages = [
        ["role" => "system", "content" => "Eres un experto en SEO"],
        ["role" => "user","content" => $prompt]
    ];

    $primerosPostFields = [
        "model" => 'gpt-4-turbo',
        "messages" => $messages,
        "temperature" => 0.7
    ];

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($primerosPostFields));

    // Configuración de reintentos
    $retryCount = 0;
    $result = false;

    while ($retryCount < $maxRetries && !$result) {
        $result = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($result === false || $httpcode >= 400) {
            $curlError = curl_errno($ch);
            $curlErrorMsg = curl_error($ch);
            $consecutiveFailures++;

            if ($consecutiveFailures >= $maxConsecutiveFailures) {
                throw new Exception("Número máximo de fallos consecutivos alcanzado, cancelando el proceso.");
            }

            if ($curlError) {
                self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al error de cURL: $curlErrorMsg", 'aicc_bulk_curation_content');
            } else {
                self::aicc_log_register($post_id, 'warning', "Reintento $retryCount debido al código de estado HTTP: $httpcode", 'aicc_bulk_curation_content');
            }

            if ($httpcode == 401 || $httpcode == 429) {
                // No tiene sentido reintentar en caso de error de autenticación o límite de tarifas
                throw new Exception("Error con código $httpcode, verifique las credenciales de la API o la política de límites de tarifas.");
            }

            // Incrementa el contador de reintentos y espera antes de reintentar
            $retryCount++;
            sleep(5);
            $result = false;
        } else {
            $consecutiveFailures = 0; // Restablece el contador de fallos si hay éxito
        }
    }

    if (!$result) {
        $discarded++;
        update_option('aicc_bulk_discarded_count', $discarded);
        $error_message = 'Error por respuesta de OpenAI vacía.';
        self::aicc_log_register('', 'error', $error_message, 'aicc_bulk_curation_image_prompt');
        return false;
    }

    $response = json_decode($result);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $discarded++;
        update_option('aicc_bulk_discarded_count', $discarded);
        $json_error_message = json_last_error_msg();
        $error_message = 'La respuesta de OpenAI no se pudo decodificar. Error JSON: ' . $json_error_message . '. Respuesta recibida: ' . $result;
        self::aicc_log_register('', 'error', $error_message, 'aicc_bulk_curation_image_prompt');
        return false;
    }

    if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) {
        $discarded++;
        update_option('aicc_bulk_discarded_count', $discarded);
        $error_message = 'Respuesta inesperada de OpenAI. Respuesta completa: ' . $result;
        self::aicc_log_register('', 'error', $error_message, 'aicc_bulk_curation_image_prompt');
        return false;
    }

    $entity = $response->choices[0]->message->content;
    $usage = $response->usage;
    $tokens = $usage->total_tokens;

    $totalTokens += $tokens;
    update_option('aicc_bulk_total_tokens', $totalTokens);
    $costPromptImage += self::aicc_calculate_process_cost($prompt, 'gpt-4o-mini', $tokens);

    update_option('aicc_last_item_time', current_time('timestamp'));

?>
