<?php

// Verificar si el post ya contiene una imagen
if (!preg_match('/<img[^>]+>/', $post_content)) {

    self::aicc_log_register($post->ID, 'error', 'Agregando imágenes (stock) para "' . $post->post_title . '"', 'aicc_bulk_curation_image');

    $is_gutenberg = function_exists('use_block_editor_for_post') && use_block_editor_for_post($post->ID);

    // Obtener entidad y verificar su existencia
    include(AICC_PLUGIN_DIR . 'functions/obtainEntity.php');
    if (!$entity) {
        $discarded++;
        update_option('aicc_bulk_discarded_count', $discarded);
        self::aicc_log_register($post->ID, 'error', 'Error al obtener la entidad.', 'aicc_bulk_curation_image');
        return false;
    }

    // Obtener imágenes y verificar su existencia
    $stock_images = self::aicc_get_images($entity, $post->post_title, $source);
    $post_images = $stock_images['post_images'];
    if (!$post_images) {
        $discarded++;
        update_option('aicc_bulk_discarded_count', $discarded);
        self::aicc_log_register($post->ID, 'error', 'Error al obtener imágenes.', 'aicc_bulk_curation_image');
        return false;
    }

    if ($is_gutenberg) {
        // Parsear los bloques existentes
        $blocks = parse_blocks($post_content);

        $num_blocks = count($blocks);
        $num_images = count($post_images);
        $interval = ceil($num_blocks / ($num_images + 1));

        $imagen_index = 0;
        $nuevo_blocks = array();

        foreach ($blocks as $index => $block) {

            // Añadir el bloque actual al nuevo arreglo de bloques
            $nuevo_blocks[] = $block;

            // Evitar insertar imágenes dentro de bloques de lista
            $current_block_name = isset($block['blockName']) ? $block['blockName'] : '';

            // Verificar si es momento de insertar una imagen y que el bloque actual no sea una lista
            if ($imagen_index < $num_images && (($index + 1) % $interval) == 0 && $current_block_name !== 'core/list') {
                $image_url = esc_url($post_images[$imagen_index]);

                // Obtener el ID de la imagen si ya está en la biblioteca de medios
                $image_id = attachment_url_to_postid($image_url);

                // Verificar que el ID de la imagen sea válido
                if ($image_id === 0) {
                    self::aicc_log_register($post->ID, 'error', 'Imagen no encontrada en la biblioteca de medios: ' . $image_url, 'aicc_bulk_curation_image');
                    $imagen_index++;
                    continue;
                }

                // Construir el bloque de imagen correctamente con atributos de estilo
                $image_block = array(
                    'blockName'   => 'core/image',
                    'attrs'       => array(
                        'url'             => $image_url,
                        'id'              => (int) $image_id,
                        'alt'             => '',
                        'caption'         => '',
                        'sizeSlug'        => 'large', // Opcional: especifica el tamaño
                        'linkDestination' => 'none',  // Opcional
                        'style'           => array(
                            'elements' => array(
                                'image' => array(
                                    'maxWidth' => '100%',
                                    'height'   => 'auto',
                                ),
                            ),
                        ),
                    ),
                    'innerBlocks' => array(),
                    'innerHTML'   => '<figure class="wp-block-image size-large"><img src="' . $image_url . '" alt="" class="wp-image-' . $image_id . '" style="max-width:100%; height:auto;" /></figure>',
                    'innerContent'=> array('<figure class="wp-block-image size-large"><img src="' . $image_url . '" alt="" class="wp-image-' . $image_id . '" style="max-width:100%; height:auto;" /></figure>'),
                );

                // Añadir el bloque de imagen al nuevo arreglo de bloques
                $nuevo_blocks[] = $image_block;

                self::aicc_log_register($post->ID, 'info', 'Imagen insertada en Gutenberg: ' . $image_url, 'aicc_bulk_curation_image');
                $imagen_index++;
            }
        }

        // Serializar los bloques de nuevo a contenido
        $nuevo_contenido = serialize_blocks($nuevo_blocks);

         // Eliminar <p><!-- wp:paragraph --></p> o cualquier párrafo vacío en Gutenberg
        $nuevo_contenido = preg_replace('/<p><!-- wp:paragraph --><\/p>/', '', $nuevo_contenido);
        $nuevo_contenido = preg_replace('/<p>(\s|&nbsp;)*<\/p>/', '', $nuevo_contenido);
    } else {
        // Para el editor clásico, mantener tu lógica original
        $lines = preg_split('/(<\/p>|<\/ul>|<\/ol>|<\/table>|<\/blockquote>)/i', $post_content, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);

        $num_lines = count($lines);
        $num_images = count($post_images);
        $interval = ceil($num_lines / ($num_images + 1));

        $nuevo_contenido = '';
        $imagen_index = 0;

        foreach ($lines as $index => $line) {
            $nuevo_contenido .= $line;

            // Verificar si es momento de insertar una imagen
            if ($imagen_index < $num_images && ($index + 1) % $interval == 0) {
                $nuevo_contenido .= '<p style="text-align:center;"><img src="' . esc_url($post_images[$imagen_index]) . '" style="max-width:100%; height:auto;"></p>';
                $imagen_index++;
            }
        }

        // Eliminar párrafos vacíos generados accidentalmente
        $nuevo_contenido = preg_replace('/<p>(\s|&nbsp;)*<\/p>/', '', $nuevo_contenido);
    }

    // Actualizar el contenido del post
    $post_updated = array(
        'ID'           => $post->ID,
        'post_content' => wp_slash($nuevo_contenido), 
    );
    $result = wp_update_post($post_updated);

    if (is_wp_error($result)) {
        self::aicc_log_register($post->ID, 'error', 'Error al actualizar el post: ' . $result->get_error_message(), 'aicc_bulk_curation_image');
    } else {
        self::aicc_log_register($post->ID, 'info', 'Post actualizado correctamente.', 'aicc_bulk_curation_image');
    }

    // Actualizar el costo total y registrar el proceso
    $totalCost = $costPromptImage;
    update_option('aicc_bulk_total_cost', $totalCost);
} else {
    self::aicc_log_register($post->ID, 'error', 'Contenido descartado: ya tiene imágenes.', 'aicc_bulk_curation_image');
}

?>
