<?php

update_option('aicc_last_item_time', current_time('timestamp'));

$message = 'El artículo "' . $post_title . '" está siendo mejorado.';
self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

if ($type == 'improve') {

    $headers_addition = '';

    if ($include_headers) {
        $headers_addition = "Además de la tarea de integración de keywords, si se considera apropiado, introduce uno o dos encabezados nuevos (H2) basados en las keywords suministradas, sin cambiar o alterar los encabezados existentes. Es imperativo que todos los encabezados ya presentes en el contenido (H2,H3,H4) se mantengan sin modificaciones, y que cualquier encabezado nuevo se añada de forma que complementen y no reemplacen los ya existentes. Estos encabezados nuevos deberían surgir naturalmente del contenido y aportar valor adicional al texto, evitando la repetición de temas y manteniendo la cohesión del artículo. Selecciona las keywords para los encabezados que ofrezcan nuevas perspectivas o detalles relevantes, enriqueciendo así el contenido general. Cada nuevo encabezado H2, debe ser seguido por contenido que desarrolle el tema de manera adecuada, ya sean párrafos o listas HTML, asegurando que la adición sea coherente y enriquezca el contenido de forma integral. Esta evaluación debe tener en cuenta la jerarquía actual de encabezados para elegir el nivel más apropiado, mejorando así la experiencia de lectura y la estructura del artículo.";
    }

    $prompt = "Tu tarea es enriquecer el siguiente contenido con nuevas keywords específicas, las cuales son: '" . $formattedKeywords . "'. Cada una de estas keywords debe ser incorporada al menos una vez en el texto, asegurando que el resultado final sea un texto más relevante y coherente. Es importante integrar estas keywords de forma natural, ajustando, modificando o reemplazando frases existentes para incluir cada una de las nuevas keywords proporcionadas, sin sacrificar la calidad ni legibilidad del contenido. Deberás modificar el texto existente o añadir nuevos párrafos y/o listas HTML (usando <ul> con <li> o <ol> con <li>) de manera que todo nuevo contenido se sienta como una parte integral del artículo, manteniendo el tono y el estilo original. Es importante que las nuevas keywords no deben ser agregadas entre comillas, sino de forma natural. \n\n Además, debes asegurarte de que las keywords ya presentes, '" . $includedKeywords . "', permanezcan intactas en el texto, ya que son fundamentales para la coherencia y relevancia del tema. \n\n Es crucial mantener todas las etiquetas `<img>` existentes sin cambios. Todas las imágenes deben permanecer en su lugar original y no deben ser eliminadas ni alteradas. Asegura que cualquier adición o modificación de contenido se realice sin afectar la presencia y posición de las imágenes.\n\n " . $headers_addition . " \n\n Instrucciones detalladas:\n\n 1. Conserva la estructura y esencia del contenido original, pero siéntete libre de modificar frases o secciones para incorporar todas las nuevas keywords de manera orgánica. Cada cambio debe preservar o mejorar la relevancia y coherencia del texto.\n 2. El artículo final debe ser una versión enriquecida del original, que incluya todas las modificaciones realizadas para integrar las nuevas keywords. Es esencial que devuelvas el texto completo, no solo las secciones modificadas. Esto asegura una visión integral del contenido mejorado.\n 3. Mantén todas las etiquetas HTML intactas y sigue utilizando el formato HTML para las operaciones de estilo, incluyendo la preservación de las etiquetas <strong> y la estructura de encabezados (H2, H3, H4) ya presentes en el contenido actual. La integración de las nuevas keywords no debe comprometer la estructura del contenido ni su presentación visual.\n 4. Utilizar exclusivamente formato HTML para cualquier operación de estilo y evitar completamente el uso de marcadores de formato de texto como ** para negritas o ## para encabezados. Todas las modificaciones y adiciones deben seguir el formato HTML sin desviarse a Markdown u otros formatos.\n 5. Asegúrate de que las nuevas keywords se utilicen al menos una vez y que cualquier adición o modificación fluya de manera coherente con el resto del contenido. La clave es mejorar el texto existente sin desviar su tema o diluir su mensaje principal.\n 6. No acortar el contenido original. Se espera que el texto resultante sea más largo debido a las adiciones necesarias. Esto es esencial para cumplir con las validaciones de longitud del contenido. No importa si hay contenido repetido o duplicado o tú piensas que sería mejor eliminar ciertas partes. Es vital no acortar el contenido original, así que trabaja sobre él agregando contenido y no quitando.\n 7. Por ningún motivo debes agregar etiquetas HTML <strong> en los nuevos párrafos o contenidos que agregues. Esta medida es para prevenir la sobreoptimización del contenido con las keywords recién incorporadas. Solo debes mantener las etiquetas <strong> que ya estén dentro del contenido, pero no agregar nuevas. Además, asegúrate de mantener todas las etiquetas HTML <strong> que ya están presentes dentro del contenido.\n\n Por favor, realiza las modificaciones necesarias con el fin de entregar un artículo completo que no solo mantenga el valor informativo y temático del original, sino que también lo amplíe y enriquezca con las nuevas keywords. Este enfoque garantiza que el contenido final sea tanto integral como mejorado, cumpliendo con los objetivos de esta tarea. Es crucial que todas las mejoras y modificaciones se realicen respetando el idioma original del contenido. Por último, evita completamente hacer mención a estas instrucciones, al formato HTML, o cualquier comentario adicional fuera del contenido del artículo.\n\n A continuación, se muestra el contenido sobre el cual debes trabajar:\n\n" . $post_content;

    $role = 'Eres un experto en redacción SEO y estás mejorando un artículo. El título del artículo es: ' . $post_title;

} else {

    $prompt = '';
    $prompt = $user_prompt;
    $prompt = str_replace('{keywords}', $formattedKeywords, $prompt);
    $prompt = str_replace('{keywords_incluidas}', $includedKeywords, $prompt);
    $prompt = str_replace('{post_title}', $post_title, $prompt);
    $prompt = str_replace('{post_content}', $post_content, $prompt);
    $prompt .= ' Evita completamente hacer mención a estas instrucciones, al formato HTML, o cualquier comentario adicional fuera del contenido del artículo.';

    $role = 'Eres un experto en redacción SEO.';

}

$messages = array(
    array(
        "role" => "system",
        "content" => $role
    ),
    array(
        "role" => "user",
        "content" => $prompt
    )
);

$post_fields = array(
    "model" => $model,
    "messages" => $messages,
    "temperature" => 0.7
);

curl_setopt($ch, CURLOPT_TIMEOUT, 480);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

$new_content = $response->choices[0]->message->content;
$new_content = str_replace('<p>```html</p>', '', $new_content);
$new_content = str_replace('```html', '', $new_content);
$usage = $response->usage;
$tokens = $usage->total_tokens;

$totalTokens += $tokens;
update_option('aicc_bulk_total_tokens', $totalTokens);
$totalCost += self::aicc_calculate_process_cost($prompt, $model, $tokens);
update_option('aicc_bulk_total_cost', $totalCost);

if (!$remove_validations) {

    // Limpiamos las cadenas y calculamos la cantidad de palabras en el contenido original y en el contenido nuevo
    $original_length = str_word_count(strip_tags($post_content));
    $new_length = str_word_count(strip_tags($new_content));

    // Calcular el 90% del largo del contenido original
    $minimum_length = $original_length * 0.90;

    // Extraer encabezados del contenido original
    $original_headers = $this->aicc_extractHeaders($post_content);

    // Extraer encabezados del nuevo contenido
    $new_headers = $this->aicc_extractHeaders($new_content);

    // Unir todos los encabezados originales y nuevos en dos grandes cadenas
    $original_headers_joined = implode(" ", $original_headers);
    $new_headers_joined = implode(" ", $new_headers);

    // Calcular la similitud entre las dos grandes cadenas de encabezados
    similar_text($original_headers_joined, $new_headers_joined, $percent);

    // Verificar que todos los encabezados originales estén presentes en el nuevo contenido
    $all_headers_included = !array_diff($original_headers, $new_headers);
}

update_option('aicc_last_item_time', current_time('timestamp'));

$message = 'El artículo "' . $post_title . '" se procesó con éxito.';
self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

?>
