<?php

	$combinedData = '';

	$keyword = $post_title;

	update_option('aicc_last_item_time', current_time('timestamp'));

	$message = 'El artículo "' . $keyword . '" está siendo regenerado.';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

	$remove_validations =  true;

	/*
	 * Detectamos idioma
	 */
	$lang_prompt = 'Necesito identificar el idioma en el que está escrita la siguiente frase: "' . $keyword . '". Por favor, devuelve solo el idioma en el que está escrito, por ejemplo: "español" o "inglés" o "francés". Solo devuelve el idioma sin agregar ningún otro comentario ni dato adicional. No hagas meción a estas instrucciones, solo límitate a devolverme el idioma.';

	$messages = array(
		array(
			"role" => "user",
			"content" => $lang_prompt
		)
	);

	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"temperature" => 0.7  
	);

	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

	include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

	$language = $response->choices[0]->message->content;
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($lang_prompt, $model, $tokens);

	$message = 'Se detectó correctamente el idioma para "' . $keyword . '"';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
	
	update_option('aicc_last_item_time', current_time('timestamp'));

	/*
	 * Generamos ideas para los encabezados de los artículos
	 */

	$initial_prompt = 'Estoy trabajando en un artículo sobre "'.$keyword.'". Dime 5 o 6 subtítulos redactados en idioma '.$language.' y optimizados para SEO que podría usar para armar este artículo y enriquecerlo semánticamente. Puedes basarte en las siguientes keywords para crear subtítulos que las incluyan. Las keywords son: "{allKeywords}". Cuántas más keywords incluyas, mejor, ya que son palabras clave que se están posicionando para mis artículos. Más allá de que debas basarte en esas keywords para crear los subtítulos, los subtítulos deben aportar valor al usuario y no duplicarse la intención de búsqueda de esos subtítulos. Es decir, si una keyword es "Significado del color rojo" y otra "Color rojo significado", solo deberías agregar una, ya que la intención de búsqueda de ambas keywords es la misma. Si muchas keywords tienen la misma intención de búsqueda o consideras que no son aptas para usar como subtítulos, puedes no basarte en ellas y decirme tú mismo 4 o 5 subtítulos que consideres apropiados para la keyword "{$keyword}". Dime solo la lista, separando cada subtítulo con un salto de línea, sin numeración ni viñetas, sin añadir ninguna frase o palabra adicional además del listado, ni hacer mención a estas instrucciones.';

	$messages = array(
	    array(
	        "role" => "system",
	        "content" => "El usuario busca subtítulos optimizados para SEO en el idioma especificado para un artículo sobre un tema específico."
	    ),
	    array(
	        "role" => "user",
	        "content" => $initial_prompt
	    )
	);


	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"temperature" => 0.8
	);

	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
			
	include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

	$responseContent = $response->choices[0]->message->content;
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($initial_prompt, $model, $tokens);

	$responseContent = str_replace('<p>```html</p>', '', $responseContent);
	$responseContent = str_replace('```html', '', $responseContent);			
	$responseContent = preg_replace('/^\d+\.\s*/m', '', $responseContent);
	$responseContent = preg_replace('/^-\s*/m', '', $responseContent);
	$responseContent = preg_replace('/^•\s*/m', '', $responseContent);
	$responseContent = preg_replace('/\.$/', '', $responseContent);
	$responseContent = preg_replace('/^["\']|["\']$/m', '', $responseContent);
	$responseContent = str_replace('```', '', $responseContent);

	$subtitles = array_filter(array_map('trim', explode("\n", $responseContent)));


	$message = 'Se generaron correctamente los nuevos encabezados para "' . $keyword . '".';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

	update_option('aicc_last_item_time', current_time('timestamp'));

	/*
	 * Generamos la introducción para el artículo
	 */
	$intro_prompt = 'Estoy escribiendo un artículo sobre "' . $keyword . '". Por favor, escribe dos párrafos cortos (máximo 4 líneas cada uno) introductorios sobre "' . $keyword . '" redactados en idioma '.$language.' para incorporarlos como introducción al artículo. Debes incluir explícitamente la frase "' . $keyword . '" dentro del primer o del segundo párrafo (solo en uno de ellos) en negrita <strong>, ya que esto mejora a nivel SEO el posicionamiento de esa keyword. Cada párrafo debe estar envuelto en etiquetas de párrafo HTML (<p></p>). El texto debe estar listo para su incorporación, así que no se necesitan subtítulos ni menciones del formato HTML. No hagas meción a estas instrucciones, solo límitate a escribir la introducción.';

	$messages = array(
		array(
			"role" => "user",
			"content" => $intro_prompt
		)
	);

	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"temperature" => 0.8  
	);

	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

	include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

	$responseContent = $response->choices[0]->message->content;
	$responseContent = str_replace('<p>```html</p>', '', $responseContent);
	$responseContent = str_replace('```html', '', $responseContent);		
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($intro_prompt, $model, $tokens);


	$message = 'Se generó correctamente la introducción para "' . $keyword . '"';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
	
	update_option('aicc_last_item_time', current_time('timestamp'));

	$combinedData .= $responseContent;  

	$article_content = array();

	$countPrompts = 5;

	$multiplePrompts = [
		'Estoy trabajando en un artículo sobre "{post_title}" y quiero enriquecerlo semánticamente. Necesito que redactes en idioma {language} tres o cuatro párrafos cortos (máximo 4 o 5 líneas) sobre "{keyword}". Cada párrafo debe estar envuelto en etiquetas de párrafo de HTML (<p></p>). Siempre que puedas utiliza listas HTML (<ul>) para aportar valor adicional y usa la etiqueta HTML <strong></strong> para destacar algunas partes del texto que consideres importantes. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma, como por ejemplo en comparativas o donde los datos se muestren mejor en tablas.',
		'Estoy creando un artículo centrado en "{post_title}". Por favor, redacta en {language} tres o cuatro párrafos cortos (máximo 4 o 5 líneas) sobre "{keyword}". Encierra cada párrafo con las etiquetas HTML correspondientes (<p></p>). Si es pertinente, utiliza listas (<ul> o <ol>) para aclarar puntos, ya que esto enriquece mucho más el contenido. Cuando puedas, la etiqueta HTML <strong></strong> para destacar algunas partes del texto que sean importantes. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma: cuánto mejor se responda la intención de búsqueda, más satisfecho estará el usuario.',
		'Me encuentro en el proceso de elaboración de un artículo sobre "{post_title}". Sería de gran ayuda si pudieras proporcionar tres o cuatro párrafos cortos (máximo 4 o 5 líneas) en {language} que aborden la temática "{keyword}". Cada fragmento debe estar contenido dentro de etiquetas de párrafo (<p></p>). Apreciaría si puedes incluir listas HTML (<ul> o <ol>) para detalles adicionales, ya que esto mejora mucho el formateo del texto y la experiencia de usuario. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma, como por ejemplo en comparativas o donde los datos se muestren mejor en tablas.',
		'Estoy en la fase de redacción de un post sobre "{post_title}". Me gustaría profundizar en el tema. Para ello, escribe en idioma {language} tres o cuatro párrafos cortos (máximo 4 o 5 líneas) sobre "{keyword}". Es importante que cada párrafo esté envuelto con etiquetas <p></p>. Si crees que es relevante, añade listas en formato HTML (<ul> o <ol>) para complementar y también usa la etiqueta HTML <strong></strong> para destacar algunas partes del texto que consideres importantes.',
		'Actualmente, estoy desarrollando un artículo sobre "{post_title}". ¿Podrías ayudarme a expandir el contenido? Necesito tres o cuatro párrafos cortos (máximo 4 o 5 líneas) en idioma {language} que responda la pregunta "{keyword}". Recuerda envolver cada párrafo con etiquetas de párrafo HTML (<p></p>) y, en caso de ser necesario, emplear listas HTML (<ul> o <ol>) para ofrecer información adicional y la etiqueta HTML <strong></strong> para destacar algunas partes del texto que consideres importantes. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma, como por ejemplo en comparativas o donde los datos se muestren mejor en tablas. '
	];

	/*
	 * Generamos el contenido para cada encabezado
	 */

	$currentIndex = 0;

	foreach ($subtitles as $subtitle) {

		update_option('aicc_last_item_time', current_time('timestamp'));

		$prompt = self::aicc_replacePrompt($multiplePrompts[$currentIndex], $subtitle, $language, $keyword, '');

		$prompt .= ' Además, si es posible y adecuado según la keyword que estás trabajando, procura agregar alguna de las siguientes palabras clave dentro de los textos. Las palabras clave son "' . $allKeywords . '". Esto mejorará semánticamente el contenido para ese subtítulo, aportará valor SEO y hará que el contenido general se posicione mejor. Agrega algunas de ellas (no todas para no sobreoptimizar el contenido) de forma natural dentro de los textos y siempre que sea posible según el contexto. 

**Es muy importante que NO repitas el mismo contenido que ya forma parte del artículo. Agrega NUEVA información sin repetir lo existente.** El contenido actual del artículo es: "' . $combinedData . '". 

Asegúrate de que el contenido esté listo para ser publicado tal como está. Es importante también que para el formateo del contenido no uses Markdown. Por ejemplo, usa <strong></strong> para negritas en lugar de asteriscos (**). 

Por último, bajo ningún motivo debes hacer mención a estas instrucciones, al formato HTML, o cualquier comentario adicional fuera del contenido del artículo. El contenido debe ser puramente informativo y directamente relacionado con el tema, sin referencias a su propia creación y sin referencias al formato HTML. Evita también completamente agregar una frase que comente sobre la optimización SEO, la preparación del contenido para WordPress, o cualquier tipo de metadatos o instrucciones sobre la creación del artículo. No hagas mención a estas instrucciones.';
					
		$currentIndex = ($currentIndex + 1) % $countPrompts;
	
		$messages = array(
			array(
				"role" => "user",
				"content" => $prompt
			)
		);
			
		$post_fields = array(
			"model" => $model,
			"messages" => $messages,
			"temperature" => 0.8
		);
	
		curl_setopt($ch, CURLOPT_TIMEOUT, 120);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
			
		include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');
			
		$usage = $response->usage;
		$tokens = $usage->total_tokens;
		
		$totalTokens = $totalTokens + $tokens;		
		$totalCost += self::aicc_calculate_process_cost($prompt, $model, $tokens);
		
	    $responseContent = $response->choices[0]->message->content;
		$responseContent = str_replace('<p>```html</p>', '', $responseContent);
		$responseContent = str_replace('```html', '', $responseContent);		
		
		// Verificar si el subtítulo está al principio del contenido y lo eliminamos
		$responseContent = preg_replace("/^" . preg_quote($subtitle, '/') . ":\s*/i", '', $responseContent);
		$responseContent = preg_replace("/^" . preg_quote($subtitle, '/') . "(?:\s*|\s*:\s*)/i", '', $responseContent);

		update_option('aicc_last_item_time', current_time('timestamp'));

		$subtitle = '<h2>' . ucfirst( $subtitle ) . '</h2>';	
		
		if (strpos($responseContent, 'como modelo de lenguaje de IA') === false &&
			strpos($responseContent, 'como modelo de lenguaje de inteligencia artificial') === false &&
			strpos($responseContent, '¿Hay algo más en lo que pueda ayudarte?') === false ) 
		{
			$responseContent = preg_replace('/<h[^>]*>.*?<\/h[^>]*>/', '', $responseContent);
						
			$lines = explode("\n", $responseContent);
			
			foreach ($lines as &$line) {
				$line = trim($line);
				if (!empty($line) && !preg_match('/^<.*>$/', $line)) {
					$line = '<p>' . $line . '</p>';
				}
			}

			$responseContent = implode("\n", $lines);

			$article_content[$subtitle] = trim($responseContent);
		
			$combinedData .= $subtitle;
			
			$combinedData .= trim($responseContent);

			$message = 'Se generó correctamente el contenido del subtítulo  "' . $subtitle . '" artículo "' . $keyword . '" ';
			$message = str_replace(array('<h2>', '</h2>'), '', $message);
			self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

		} 
		else 
		{
			$error_message = 'Eliminamos algunos resultados porque OpenAI devolvió esto: ' . $responseContent;
			self::aicc_log_register($post_id, 'mensaje', $error_message, 'aicc_call_openai');		
		}		
		
	}

	$new_content = $combinedData;


	update_option('aicc_last_item_time', current_time('timestamp'));

	$message = 'El artículo "' . $keyword . '" se regeneró con éxito.';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');