<?php

	$keyword = $post_title;

	$faqGenerated = get_post_meta($post->ID, '_aicc_faq_schema', true);
	$isFaqIncluded = get_post_meta($post->ID, 'aicc_bulkc_is_faq_included', true);

	if ($faqGenerated || $isFaqIncluded) {
		$discarded++;
		update_option('aicc_bulk_discarded_count', $discarded);		
		$message = 'Artículo descartado poque ya fueron incorporadas las preguntas relacionadas: "' . $keyword . '".';
		self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');		
		return false;
	}

	/*
	 * Scrapeamos las SERPS para obtener información de los tres primeros resultados de Google
	 */

	$query = trim(preg_replace('/\s+/', ' ', $keyword));



	/*
	 * Detectamos idioma
	 */
	$lang_prompt = 'Necesito identificar el idioma en el que está escrita la siguiente frase: "' . $keyword . '". Por favor, devuelve solo el idioma en el que está escrito, por ejemplo: "español" o "inglés" o "francés". Solo devuelve el idioma sin agregar ningún otro comentario ni dato adicional. No hagas meción a estas instrucciones, solo límitate a devolverme el idioma.';

	$messages = array(
		array(
			"role" => "user",
			"content" => $lang_prompt
		)
	);

	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"temperature" => 0.7  
	);

	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

    include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

	$language = $response->choices[0]->message->content;
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($lang_prompt, $model, $tokens);

	$message = 'Detectado idioma "'.$language.'" para la palabra clave "' . $keyword . '".';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
	
	update_option('aicc_last_item_time', current_time('timestamp'));




	/*
	 * Detectamos código ISO de idioma
	 */
	$iso_prompt = 'Necesito identificar el código del idioma en el que está escrita la siguiente frase: "' . $keyword . '". Por favor, devuelve solo el código ISO 639-1 de dos letras para el idioma (por ejemplo: "es" para español, "en" para inglés o "fr" para francés). Solo devuelve el código del idioma sin agregar ningún otro comentario o dato adicional.';

	$messages = array(
		array(
			"role" => "user",
			"content" => $iso_prompt
		)
	);

	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"temperature" => 0.7  
	);

	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

    include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

	$lang = $response->choices[0]->message->content;
	$usage = $response->usage;
	$tokens = $usage->total_tokens;

	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($iso_prompt, $model, $tokens);

	$message = 'Detectado código de idioma "'.$lang.'" para la palabra clave "' . $keyword . '".';
	self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

	update_option('aicc_last_item_time', current_time('timestamp'));



	/*
	 * Generamos el H2 para las PAA
	 */
	$h2_prompt = 'Toma el siguiente título de un post y reformúlalo para crear un encabezado H2 utilizando alguna de las siguientes estructuras: "Preguntas relacionadas sobre...", "Más información sobre...", "Preguntas frecuentes sobre..." entre otros. Elige una estructura aleatoria de las que te he mencionado. Asegúrate de que el encabezado esté relacionado con el tema del título. Devuelve únicamente el encabezado H2 sin agregar comillas ni ningún otro comentario o dato adicional, ni hacer referencia a estas instrucciones.

	Algunos ejemplos para que entiendas como debería ser tu respuesta:

	- Título: "Significado de soñar con mariposas" 
	  Resultado: "Preguntas relacionadas sobre el significado de soñar con mariposas"
	  
	- Título: "Cómo plantar tomates en casa" 
	  Resultado: "Más información sobre cómo plantar tomates en casa"
	  
	- Título: "Beneficios del té verde" 
	  Resultado: "Preguntas frecuentes sobre los beneficios del té verde"

	El título del post es: "' . $keyword . '"';


	$messages = array(
		array(
			"role" => "user",
			"content" => $h2_prompt
		)
	);

	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"temperature" => 0.7  
	);

	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

    include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

	$h2_text = $response->choices[0]->message->content;
	$usage = $response->usage;
	$tokens = $usage->total_tokens;

	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($h2_prompt, $model, $tokens);

	update_option('aicc_last_item_time', current_time('timestamp'));




	/*
	 * Llamado a la función de conexión con la API que corresponda
	 */
	include(AICC_PLUGIN_DIR . 'functions/includes/retryCurlValueSerp.php');

	if (isset($response_data['error']) && $response_data['error']) {
	   $errorMessage = "Error en ValueSERP en la solicitud '$key': " . $response_data['message'] . " (HTTP Status: " . $response_data['status'] . ")";
	    throw new Exception($errorMessage);
	}
	
	$google_data = self::aicc_process_paa_results($response_data);

	$paa = $google_data['paa'] ?? [];
	$related_searches = $google_data['related_searches'] ?? [];

	update_option($post_id . '_paa', $paa);
	update_option($post_id . '_related_searches', $related_searches);


	if (!empty($paa)) {

		$is_gutenberg = use_block_editor_for_post($post_id);

		// Lo primero que hacemos es copiar el contenido del post original para agregarle los datos.
		$combinedData = get_post_field('post_content', $post_id);

		update_option('aicc_last_item_time', current_time('timestamp'));

		$message = 'El artículo "' . $keyword . '" está siendo mejorado con la incorporación de preguntas relacionadas.';
		self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

		$remove_validations =  true;

		$countPrompts = 5;

		$paaPrompts = [
			'Estoy trabajando en un artículo sobre "{post_title}" y quiero enriquecerlo semánticamente. Necesito que redactes en idioma {language} uno o dos párrafos cortos (máximo 4 o 5 líneas) respondiendo la pregunta "{keyword}". Cada párrafo debe estar envuelto en etiquetas de párrafo de HTML (<p></p>). Siempre que puedas utiliza listas HTML (<ul>) para aportar valor adicional y usa la etiqueta HTML <strong></strong> para destacar algunas partes del texto que consideres importantes. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma, como por ejemplo en comparativas o donde los datos se muestren mejor en tablas. Asegúrate de que el contenido esté listo para ser publicado tal como está. Es imporante también que para el formateo del contenido no uses Markdown. Por ejemplo, usa <strong></strong> para negritas en lugar de asteriscos (**).',
			'Estoy creando un artículo centrado en "{post_title}". Por favor, redacta en {language} dos o tres párrafos cortos (máximo 4 o 5 líneas) respondiendo la pregunta "{keyword}". Encierra cada párrafo con las etiquetas HTML correspondientes (<p></p>). Si es pertinente, utiliza listas (<ul> o <ol>) para aclarar puntos, ya que esto enriquece mucho más el contenido. Solo hazlo si corresponde. Cuando puedas, la etiqueta HTML <strong></strong> para destacar algunas partes del texto que sean importantes. Asegúrate de que el contenido esté listo para ser publicado tal como está. Es imporante también que para el formateo del contenido no uses Markdown. Por ejemplo, usa <strong></strong> para negritas en lugar de asteriscos (**).',
			'Me encuentro en el proceso de elaboración de un artículo sobre "{post_title}". Sería de gran ayuda si pudieras proporcionar dos párrafos cortos (máximo 4 o 5 líneas) en {language} que respondan la pregunta "{keyword}". Cada fragmento debe estar contenido dentro de etiquetas de párrafo (<p></p>). Apreciaría si puedes incluir listas HTML (<ul> o <ol>) para detalles adicionales, ya que esto mejora mucho el formateo del texto y la experiencia de usuario. Asegúrate de que el contenido esté listo para ser publicado tal como está. Es imporante también que para el formateo del contenido no uses Markdown. Por ejemplo, usa <strong></strong> para negritas en lugar de asteriscos (**).',
			'Actualmente, estoy desarrollando un artículo sobre "{post_title}". ¿Podrías ayudarme a expandir el contenido? Necesito tres párrafos cortos (máximo 4 o 5 líneas) en idioma {language} que responda la pregunta "{keyword}". Recuerda envolver cada párrafo con etiquetas de párrafo HTML (<p></p>) y, en caso de ser necesario, emplear listas HTML (<ul> o <ol>) para ofrecer información adicional y la etiqueta HTML <strong></strong> para destacar algunas partes del texto que consideres importantes. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma, como por ejemplo en comparativas o donde los datos se muestren mejor en tablas. Asegúrate de que el contenido esté listo para ser publicado tal como está. Es imporante también que para el formateo del contenido no uses Markdown. Por ejemplo, usa <strong></strong> para negritas en lugar de asteriscos (**).',
			'Actualmente, estoy desarrollando un artículo sobre "{post_title}". ¿Podrías ayudarme a expandir el contenido? Necesito tres párrafos cortos (máximo 4 o 5 líneas) en idioma {language} que responda la pregunta "{keyword}". Recuerda envolver cada párrafo con etiquetas de párrafo HTML (<p></p>) y, en caso de ser necesario, emplear listas HTML (<ul> o <ol>) para ofrecer información adicional y la etiqueta HTML <strong></strong> para destacar algunas partes del texto que consideres importantes. También puedes usar tablas HTML si consideras que la intención de búsqueda de "{keyword}" se responde mejor de esta forma, como por ejemplo en comparativas o donde los datos se muestren mejor en tablas. Asegúrate de que el contenido esté listo para ser publicado tal como está. Es imporante también que para el formateo del contenido no uses Markdown. Por ejemplo, usa <strong></strong> para negritas en lugar de asteriscos (**).'
		];

		/*
		 * Generamos el contenido para cada encabezado
		 */

		$currentIndex = 0;

		// Añadir el H2 para las PAA, verificando si Gutenberg está activo
		if ($is_gutenberg) {
		    $combinedData .= '<!-- wp:heading {"level":2} --><h2>' . esc_html($h2_text) . '</h2><!-- /wp:heading -->';
		} else {
		    $combinedData .= '<h2>' . esc_html($h2_text) . '</h2>';
		}

		foreach ($paa as $subtitle) {

			update_option('aicc_last_item_time', current_time('timestamp'));
			$prompt = self::aicc_replacePrompt($paaPrompts[$currentIndex], $subtitle, $language, $keyword, '');
			$prompt .= 'Por último, por ningún motivo debes hacer mención a estas instrucciones, al formato HTML, o cualquier comentario adicional fuera del contenido solicitado.';
			$currentIndex = ($currentIndex + 1) % $countPrompts;
		
			$messages = array(
				array(
					"role" => "user",
					"content" => $prompt
				)
			);
				
			$post_fields = array(
				"model" => $model,
				"messages" => $messages,
				"temperature" => 0.7
			);
		
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
				
			include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');
				
			$usage = $response->usage;
			$tokens = $usage->total_tokens;
			
			$totalTokens = $totalTokens + $tokens;		
			$totalCost += self::aicc_calculate_process_cost($prompt, $model, $tokens);
			
		    $responseContent = $response->choices[0]->message->content;
			$responseContent = str_replace('<p>```html</p>', '', $responseContent);
			$responseContent = str_replace('```html', '', $responseContent);		
			
			// Verificar si el subtítulo está al principio del contenido y lo eliminamos
			$responseContent = preg_replace("/^" . preg_quote($subtitle, '/') . ":\s*/i", '', $responseContent);
			$responseContent = preg_replace("/^" . preg_quote($subtitle, '/') . "(?:\s*|\s*:\s*)/i", '', $responseContent);

			update_option('aicc_last_item_time', current_time('timestamp'));

			$subtitle_html = $is_gutenberg 
			    ? '<!-- wp:heading {"level":3} --><h3>' . esc_html($subtitle) . '</h3><!-- /wp:heading -->' 
			    : '<h3>' . esc_html($subtitle) . '</h3>';

		
			if (strpos($responseContent, 'como modelo de lenguaje de IA') === false &&
				strpos($responseContent, 'como modelo de lenguaje de inteligencia artificial') === false &&
				strpos($responseContent, '¿Hay algo más en lo que pueda ayudarte?') === false )  
			{
				
				$responseContent = preg_replace('/<h[^>]*>.*?<\/h[^>]*>/', '', $responseContent);

				$lines = explode("\n", $responseContent);

				$is_list_open = false;
				$is_table_open = false;

				foreach ($lines as &$line) {
				    $line = trim($line);

				    if (!empty($line)) {
				        if (preg_match('/^<p>.*<\/p>$/', $line)) {
				            // Párrafo
				            $line = $is_gutenberg 
				                ? '<!-- wp:paragraph -->' . $line . '<!-- /wp:paragraph -->'
				                : $line;
				        } elseif (preg_match('/^<h([1-6])>.*<\/h\1>$/', $line, $matches)) {
				            // Encabezado (H1 a H6)
				            $level = $matches[1];
				            $line = $is_gutenberg 
				                ? "<!-- wp:heading {\"level\":$level} -->$line<!-- /wp:heading -->"
				                : $line;
				        } elseif (preg_match('/^<(ul|ol)>$/', $line)) {
				            // Apertura de lista (UL o OL)
				            $is_list_open = true;
				            $line = $is_gutenberg 
				                ? '<!-- wp:list -->' . $line
				                : $line;
				        } elseif (preg_match('/^<\/(ul|ol)>$/', $line)) {
				            // Cierre de lista (UL o OL)
				            $is_list_open = false;
				            $line = $is_gutenberg 
				                ? $line . '<!-- /wp:list -->'
				                : $line;
				        } elseif ($is_list_open && preg_match('/^<li>.*<\/li>$/', $line)) {
				            // Elemento de lista (LI completo en una línea)
				            $line = $is_gutenberg 
				                ? '<!-- wp:list-item -->' . $line . '<!-- /wp:list-item -->'
				                : $line;
				        } elseif ($is_list_open && preg_match('/^<li>.*$/', $line)) {
				            // Apertura de <li> sin cierre inmediato
				            $line = $is_gutenberg 
				                ? '<!-- wp:list-item -->' . $line . '<!-- /wp:list-item -->'
				                : $line;
				        } elseif (preg_match('/^<blockquote>.*<\/blockquote>$/', $line)) {
				            // Cita
				            $line = $is_gutenberg 
				                ? '<!-- wp:quote -->' . $line . '<!-- /wp:quote -->'
				                : $line;
				        } elseif (preg_match('/^<table>$/', $line)) {
				            // Apertura de tabla
				            $is_table_open = true;
				            $line = $is_gutenberg 
				                ? '<!-- wp:table -->' . $line
				                : $line;
				        } elseif (preg_match('/^<\/table>$/', $line)) {
				            // Cierre de tabla
				            $is_table_open = false;
				            $line = $is_gutenberg 
				                ? $line . '<!-- /wp:table -->'
				                : $line;
				        } elseif ($is_table_open && preg_match('/^<tr>.*<\/tr>$/', $line)) {
				            // Fila de tabla completa
				            $line = $is_gutenberg 
				                ? '<!-- wp:table-row -->' . $line . '<!-- /wp:table-row -->'
				                : $line;
				        } elseif ($is_table_open && preg_match('/^<tr>$/', $line)) {
				            // Apertura de fila de tabla
				            $line = $is_gutenberg 
				                ? '<!-- wp:table-row -->' . $line
				                : $line;
				        } elseif ($is_table_open && preg_match('/^<\/tr>$/', $line)) {
				            // Cierre de fila de tabla
				            $line = $is_gutenberg 
				                ? $line . '<!-- /wp:table-row -->'
				                : $line;
				        } elseif ($is_table_open && (preg_match('/^<th>.*<\/th>$/', $line) || preg_match('/^<td>.*<\/td>$/', $line))) {
				            // Celda de tabla (TH o TD completa)
				            $line = $is_gutenberg 
				                ? '<!-- wp:table-cell -->' . $line . '<!-- /wp:table-cell -->'
				                : $line;
				        } elseif (preg_match('/^<img .*\/>$/', $line)) {
				            // Imagen
				            $line = $is_gutenberg 
				                ? '<!-- wp:image -->' . $line . '<!-- /wp:image -->'
				                : $line;
				        } elseif (preg_match('/^<pre>.*<\/pre>$/', $line) || preg_match('/^<code>.*<\/code>$/', $line)) {
				            // Código
				            $line = $is_gutenberg 
				                ? '<!-- wp:code -->' . $line . '<!-- /wp:code -->'
				                : $line;
				        } else {
				            // Si no hay coincidencia y no es un bloque específico, envolver en párrafo
				            $line = $is_gutenberg 
				                ? '<!-- wp:paragraph --><p>' . esc_html($line) . '</p><!-- /wp:paragraph -->'
				                : '<p>' . esc_html($line) . '</p>';
				        }
				    }
				}

				$responseContent = implode("\n", $lines);


                // Limpia el título para el esquema
        		$cleanTitle = wp_strip_all_tags($subtitle, true);
				$cleanTitle = preg_replace('/[\x00-\x1F\x7F]/u', '', $cleanTitle);
				$cleanTitle = str_replace(array('"', "'"), '', $cleanTitle);

                // Limpia la respuesta para el esquema
        		$cleanAnswer = wp_strip_all_tags($responseContent, true);
        		$cleanAnswer = preg_replace('/[\x00-\x1F\x7F]/u', '', $cleanAnswer);
        		$cleanAnswer = str_replace(array('"', "'"), '', $cleanAnswer);

		        $faqItems[] = array(
		            'question' => $cleanTitle,
		            'answer' => $cleanAnswer
		        );

				$article_content[$subtitle] = trim($responseContent);
				$combinedData .= $subtitle_html;
				$combinedData .= trim($responseContent);

				$message = 'Se respondió correctamente la pregunta  "' . $subtitle . '".';
				$message = str_replace(array('<h3>', '</h3>'), '', $message);
				self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
			} else {
				$error_message = 'Eliminamos algunos resultados porque OpenAI devolvió esto: ' . $responseContent;
				self::aicc_log_register($post_id, 'mensaje', $error_message, 'aicc_call_openai');		
			}		
		}

		$new_content = $combinedData;

		update_option('aicc_last_item_time', current_time('timestamp'));

		// Genera el array de datos para el esquema
		$faqSchema = array(
		    '@context' => 'https://schema.org',
		    '@type' => 'FAQPage',
		    'mainEntity' => array()
		);

		foreach ($faqItems as $item) {
		    $faqSchema['mainEntity'][] = array(
		        '@type' => 'Question',
		        'name' => $item['question'],
		        'acceptedAnswer' => array(
		            '@type' => 'Answer',
		            'text' => $item['answer']
		        )
		    );
		}

		// Genera el JSON puro sin las etiquetas de script
		$faqJson = json_encode($faqSchema, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

		// Intenta decodificar el JSON puro
		$jsonData = json_decode($faqJson);

		if ($jsonData === null && json_last_error() !== JSON_ERROR_NONE) {
		    $message = 'Error al generar el JSON del esquema FAQ: ' . json_last_error_msg();
		    self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
		} else {
		    $message = 'Schema FAQ generado para "' . $keyword . '".';
		    self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
		    // Envuelve el JSON con las etiquetas de script
		    $faqJsonLd = '<script type="application/ld+json">' . $faqJson . '</script>';
		    // Guarda el esquema en un campo personalizado del post
		    update_post_meta($post_id, '_aicc_faq_schema', $faqJsonLd);
		}

		$message = 'El artículo "' . $keyword . '" se actualizó con éxito.';
		self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

	}