<?php

$keyword = $post_title;

$isVideoIncluded = get_post_meta($post->ID, 'aicc_bulkv_is_video_included', true);

if ($isVideoIncluded) {
    $discarded++;
    update_option('aicc_bulk_discarded_count', $discarded);
    $message = 'Artículo descartado porque ya fue incorporado un video desde la curación masiva: "' . $keyword . '".';
    self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
    return false;
}

// Detecta si el editor de bloques (Gutenberg) está activo
$is_gutenberg = function_exists('use_block_editor_for_post') && use_block_editor_for_post($post_id);

/*
 * Scrapeamos las SERPS para obtener información de los tres primeros resultados de Google
 */

$query = trim(preg_replace('/\s+/', ' ', $keyword));

/*
 * Detectamos idioma
 */
$lang_prompt = 'Necesito identificar el idioma en el que está escrita la siguiente frase: "' . $keyword . '". Por favor, devuelve solo el idioma en el que está escrito, por ejemplo: "español" o "inglés" o "francés". Solo devuelve el idioma sin agregar ningún otro comentario ni dato adicional. No hagas mención a estas instrucciones, solo límitate a devolverme el idioma.';

$messages = array(
    array(
        "role" => "user",
        "content" => $lang_prompt
    )
);

$post_fields = array(
    "model" => $model,
    "messages" => $messages,
    "temperature" => 0.7
);

curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

$language = $response->choices[0]->message->content;
$usage = $response->usage;
$tokens = $usage->total_tokens;

$totalTokens += $tokens;
$totalCost += self::aicc_calculate_process_cost($lang_prompt, $model, $tokens);

$message = 'Detectado idioma "' . $language . '" para la palabra clave "' . $keyword . '".';
self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

update_option('aicc_last_item_time', current_time('timestamp'));

/*
 * Detectamos código ISO de idioma
 */
$iso_prompt = 'Necesito identificar el código del idioma en el que está escrita la siguiente frase: "' . $keyword . '". Por favor, devuelve solo el código ISO 639-1 de dos letras para el idioma (por ejemplo: "es" para español, "en" para inglés o "fr" para francés). Solo devuelve el código del idioma sin agregar ningún otro comentario o dato adicional.';

$messages = array(
    array(
        "role" => "user",
        "content" => $iso_prompt
    )
);

$post_fields = array(
    "model" => $model,
    "messages" => $messages,
    "temperature" => 0.7
);

curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

$lang = $response->choices[0]->message->content;
$usage = $response->usage;
$tokens = $usage->total_tokens;

$totalTokens += $tokens;
$totalCost += self::aicc_calculate_process_cost($iso_prompt, $model, $tokens);

$message = 'Detectado código de idioma "' . $lang . '" para la palabra clave "' . $keyword . '".';
self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

update_option('aicc_last_item_time', current_time('timestamp'));

/*
 * Agregamos frase introductoria
 */
// Prompt para generar introducción antes del video
$intro_video_prompt = 'Toma el siguiente título de un post y crea una frase introductoria para presentar un video relacionado con el tema. La introducción debe sonar natural y contextual, como continuación de un párrafo previo, e indicar que el video profundizará en el tema del título. Devuelve únicamente la frase sin comillas ni ningún comentario adicional.

Algunos ejemplos para que entiendas cómo debería ser tu respuesta:

- Título: "Importancia del NIF para entidades en España"
  Resultado: "A continuación, un video que profundiza en la importancia y uso del NIF para las entidades en España."

- Título: "Cómo organizar tu día para ser más productivo"
  Resultado: "Para complementar, te mostramos un video con estrategias prácticas para organizar mejor tu día y alcanzar una mayor productividad."

- Título: "Beneficios de la meditación diaria"
  Resultado: "Además, en el siguiente video podrás descubrir los beneficios de incorporar la meditación a tu rutina diaria."

El título del post es: "' . $keyword . '". Ten en cuenta el título del video también para armar una frase introductoria acorde.';

$messages = array(
    array(
        "role" => "user",
        "content" => $intro_video_prompt
    )
);

$post_fields = array(
    "model" => $model,
    "messages" => $messages,
    "temperature" => 0.7
);

curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

include(AICC_PLUGIN_DIR . 'functions/includes/retryCurl.php');

$generated_intro = $response->choices[0]->message->content;
$usage = $response->usage;
$tokens = $usage->total_tokens;

$totalTokens += $tokens;
$totalCost += self::aicc_calculate_process_cost($intro_video_prompt, $model, $tokens);

$message = 'Generada introducción de video para la palabra clave "' . $keyword . '".';
self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

update_option('aicc_last_item_time', current_time('timestamp'));

/*
 * Llamado a la función de conexión con la API que corresponda
 */

$fetch_videos = true;
include(AICC_PLUGIN_DIR . 'functions/includes/retryCurlValueSerp.php');

if (isset($response_data['error']) && $response_data['error']) {
    $errorMessage = "Error en ValueSERP en la solicitud '$key': " . $response_data['message'] . " (HTTP Status: " . $response_data['status'] . ")";
    throw new Exception($errorMessage);
}

$processed_video_results = self::aicc_process_video_results($response_data);
$first_video = $processed_video_results['videos'][0] ?? null;

update_option($post_id . '_videos', $videos);

if (!empty($first_video)) {

    // Sumamos el costo de la petición a ValueSERP
    $totalCost += 0.0025;
    update_option('aicc_bulk_total_cost', $totalCost);

    $video_title = $first_video['title'];
    $video_description = $first_video['description'];
    $video_upload_date = $first_video['upload_date']; // Asegúrate de que esté en formato ISO 8601
    $video_duration_iso8601 = self::aicc_convertDurationToISO8601($first_video['duration']);
    $video_embed = self::aicc_generate_video_embed($first_video['link']); // Generar el código embebido
    $video_embed_url = self::aicc_get_youtube_embed_url($first_video['link']); // Generar la URL embebible
    $video_thumbnail_url = self::aicc_get_youtube_thumbnail_url($first_video['link']);

    // Lo primero que hacemos es copiar el contenido del post original para agregarle los datos.
    $new_content = get_post_field('post_content', $post->ID);

    update_option('aicc_last_item_time', current_time('timestamp'));

    $message = 'El artículo "' . $keyword . '" está siendo mejorado con la incorporación de videos.';
    self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');

    if ($is_gutenberg) {

        $blocks = parse_blocks($new_content);

        // Crear el bloque de párrafo con la introducción
        $intro_block = array(
            'blockName'   => 'core/paragraph',
            'attrs'       => array(),
            'innerBlocks' => array(),
            'innerHTML'   => '<p>' . esc_html($generated_intro) . '</p>',
            'innerContent' => array('<p>' . esc_html($generated_intro) . '</p>'),
        );

        // Usar la URL estándar del video de YouTube
        $original_video_url = esc_url($first_video['link']);

        // Asegurarse de que la función wp_oembed_get esté disponible
        if ( ! function_exists( 'wp_oembed_get' ) ) {
            require_once ABSPATH . WPINC . '/embed.php';
        }

        // Obtener el código embebido del video de YouTube
        $embed_code = wp_oembed_get( $original_video_url );
        // Crear el bloque de embed específico para YouTube con el atributo 'html'
        $video_block = array(
            'blockName'   => 'core-embed/youtube',
            'attrs'       => array(
                'url' => $original_video_url,
                'type' => 'video',
                'providerNameSlug' => 'youtube',
                'responsive' => true,
            ),
            'innerBlocks' => array(),
            'innerHTML'   => $embed_code,
            'innerContent' => array( $embed_code ),
        );

        // Crear un bloque de párrafo vacío para simular un <br>
        $spacer_block = array(
            'blockName'   => 'core/paragraph',
            'attrs'       => array(),
            'innerBlocks' => array(),
            'innerHTML'   => '<p>&nbsp;</p>', // Esto genera un espacio en blanco
            'innerContent' => array('<p>&nbsp;</p>'),
        );        

        // Encontrar índices de los bloques <h2>
        $heading_indices = array();
        foreach ($blocks as $index => $block) {
            if ($block['blockName'] === 'core/heading' && isset($block['attrs']['level']) && $block['attrs']['level'] == 2) {
                $heading_indices[] = $index;
            }
        }

        if (count($heading_indices) > 0) {
            // Calcular un índice aleatorio desde la mitad hasta el final
            $start_index = intdiv(count($heading_indices), 2);
            $end_index = count($heading_indices) - 1;
            if ($start_index > $end_index) {
                $start_index = 0;
            }
            $random_heading_index = rand($start_index, $end_index);
            $insert_position = $heading_indices[$random_heading_index];

            // Insertar los bloques antes del heading seleccionado
            array_splice($blocks, $insert_position, 0, array($intro_block, $video_block, $spacer_block));
        } else {
            // Si no hay headings, buscar párrafos
            $paragraph_indices = array();
            foreach ($blocks as $index => $block) {
                if ($block['blockName'] === 'core/paragraph') {
                    $paragraph_indices[] = $index;
                }
            }

            if (count($paragraph_indices) > 0) {
                $start_index = intdiv(count($paragraph_indices), 2);
                $end_index = count($paragraph_indices) - 1;
                if ($start_index > $end_index) {
                    $start_index = 0;
                }
                $random_paragraph_index = rand($start_index, $end_index);
                $insert_position = $paragraph_indices[$random_paragraph_index];

                array_splice($blocks, $insert_position, 0, array($intro_block, $video_block, $spacer_block));
            } else {
                // Si no hay párrafos, insertar al final
                array_push($blocks, $intro_block, $video_block, $spacer_block);
            }
        }

        // Serializar los bloques de vuelta a contenido
        $new_content = serialize_blocks($blocks);

    } else {
        // Para el editor clásico, usamos solo HTML
        $intro_text = '<p>' . esc_html($generated_intro) . '</p>';
        $intro_with_video = $intro_text . $video_embed;

        // Buscar todos los <h2> en el contenido
        preg_match_all('/<h2\b[^>]*>(.*?)<\/h2>/i', $new_content, $h2_matches, PREG_OFFSET_CAPTURE);

        $h2_count = count($h2_matches[0]);

        if ($h2_count > 0) {
            $start_index = intdiv($h2_count, 2);
            $end_index = $h2_count - 1;
            if ($start_index > $end_index) {
                $start_index = 0;
            }
            $random_h2_index = rand($start_index, $end_index);
            $random_h2_position = $h2_matches[0][$random_h2_index][1];

            // Insertar la introducción y el video antes del <h2> seleccionado
            $new_content = substr_replace($new_content, $intro_with_video, $random_h2_position, 0);
        } else {
            // Buscar todos los <p> en el contenido
            preg_match_all('/<p\b[^>]*>(.*?)<\/p>/i', $new_content, $p_matches, PREG_OFFSET_CAPTURE);

            $p_count = count($p_matches[0]);

            if ($p_count > 0) {
                $start_index = intdiv($p_count, 2);
                $end_index = $p_count - 1;
                if ($start_index > $end_index) {
                    $start_index = 0;
                }
                $random_p_index = rand($start_index, $end_index);
                $random_p_position = $p_matches[0][$random_p_index][1];

                // Insertar la introducción y el video antes del <p> seleccionado
                $new_content = substr_replace($new_content, $intro_with_video, $random_p_position, 0);
            } else {
                // Si no hay <p>, insertar al final del contenido
                $new_content .= $intro_with_video;
            }
        }
    }

    $video_included = true;

    update_option('aicc_last_item_time', current_time('timestamp'));

    // Obtener el nombre del sitio dinámicamente y sanitizarlo
    $site_name = sanitize_text_field(get_bloginfo('name'));

    // Obtener la URL del logo del sitio y validarla
    $custom_logo_id = get_theme_mod('custom_logo');

    if ($custom_logo_id) {
        // Si hay un logo personalizado, obtener su URL y validarla
        $logo_url = esc_url(wp_get_attachment_image_url($custom_logo_id, 'full'));
    } else {
        // Si no hay logo personalizado, puedes usar una imagen por defecto o dejarlo vacío
        $logo_url = '';
    }

    // Sanitizar y validar los datos del video
    $video_title = sanitize_text_field($video_title);
    $video_description = sanitize_textarea_field($video_description);
    $video_thumbnail_url = esc_url($video_thumbnail_url);
    $video_upload_date = sanitize_text_field($video_upload_date);
    $video_duration_iso8601 = sanitize_text_field($video_duration_iso8601);
    $content_url = esc_url($first_video['link']);
    $video_embed_url = esc_url($video_embed_url);

    // Verificar que las variables esenciales no estén vacías
    if (empty($video_title) || empty($video_embed_url)) {
        $message = 'Error: Datos esenciales del video faltantes.';
        self::aicc_log_register($post_id, 'error', $message, 'aicc_bulk_curation_content');
        return; // O maneja el error según corresponda
    }

    // Genera el array de datos para el esquema de video
    $videoSchema = array(
        '@context'    => 'https://schema.org',
        '@type'       => 'VideoObject',
        'name'        => $video_title,
        'description' => $video_description,
        'thumbnailUrl' => $video_thumbnail_url,
        'uploadDate'  => $video_upload_date,
        'contentUrl'  => $content_url,
        'embedUrl'    => $video_embed_url,
        'publisher'   => array(
            '@type' => 'Organization',
            'name'  => $site_name,
            'logo'  => array(
                '@type' => 'ImageObject',
                'url'   => $logo_url,
            ),
        ),
    );

    // Genera el JSON-LD con opciones adicionales
    $videoJson = json_encode($videoSchema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);

    // Comprueba si hubo errores al codificar el JSON
    if (json_last_error() !== JSON_ERROR_NONE) {
        $message = 'Error al generar el JSON del esquema VideoObject: ' . json_last_error_msg();
        self::aicc_log_register($post_id, 'error', $message, 'aicc_bulk_curation_content');
    } else {
        $message = 'Schema VideoObject generado para "' . $keyword . '".';
        self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
        // Envuelve el JSON con las etiquetas de script
        $videoJsonLd = '<script type="application/ld+json">' . $videoJson . '</script>';
        // Guarda el esquema en un campo personalizado del post
        update_post_meta($post_id, '_aicc_video_schema', $videoJsonLd);
    }

    $message = 'El artículo "' . $keyword . '" se actualizó con éxito.';
    self::aicc_log_register($post_id, 'aviso', $message, 'aicc_bulk_curation_content');
}

?>
