<?php

	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
	curl_setopt($ch, CURLOPT_TIMEOUT, 480);
	if ( $force_ssl )
	{
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	}


	/*
	 * Generamos ideas para los encabezados de los artículos
	 */
	$keyword = $keywords[0];

	$initial_prompt = 'Estoy trabajando en un artículo sobre "'.$keyword.'". Dime 4 o 5 subtítulos redactados en idioma '.$language.' y optimizados para SEO que podría usar para armar este artículo y enriquecerlo semánticamente. Dime solo la lista sin numeración ni viñetas, sin añadir ninguna frase o palabra adicional además del listado, ni hacer mención a estas instrucciones.';

	$messages = array(
	    array(
	        "role" => "system",
	        "content" => "El usuario busca subtítulos optimizados para SEO en el idioma especificado para un artículo sobre un tema específico."
	    ),
	    array(
	        "role" => "user",
	        "content" => $initial_prompt
	    )
	);


	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"max_tokens" => 500,
		"temperature" => 0.7
	);

	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
			
	$result = curl_exec($ch);
		
	$curlError = curl_errno($ch);
		
	if ($curlError) {
		$curlErrorMsg = curl_error($ch);

		if ($curlError == CURLE_COULDNT_CONNECT) {
			throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
		} else {
			throw new Exception('Error cURL: ' . $curlErrorMsg);
		}
	}
		
	if (!$result) 
	{                        
		throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
	}						
	
	$response = json_decode($result);
		
	if (json_last_error() !== JSON_ERROR_NONE) 
	{
		throw new Exception('La respuesta de OpenAI no se pudo decodificar. Por favor, intenta de nuevo.');
	}
				
	$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);		

	self::aicc_handleOpenAIHttpErrors($httpcode, $response);

	if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) 
	{
		throw new Exception('Respuesta inesperada de OpenAI. Por favor, intenta de nuevo. Respuesta de OpenAI: ' . $response);
	}

	$responseContent = $response->choices[0]->message->content;
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($initial_prompt, $model, $tokens);

	$responseContent = str_replace('<p>```html</p>', '', $responseContent);
	$responseContent = str_replace('```html', '', $responseContent);			
	$responseContent = preg_replace('/^\d+\.\s*/m', '', $responseContent);
	$responseContent = preg_replace('/^-\s*/m', '', $responseContent);
	$responseContent = preg_replace('/^•\s*/m', '', $responseContent);
	$responseContent = preg_replace('/\.$/', '', $responseContent);
	$responseContent = preg_replace('/^["\']|["\']$/m', '', $responseContent);
	$responseContent = str_replace('```', '', $responseContent);

	$subtitles = explode("\n", trim($responseContent));



	/*
	 * Generamo la introducción para el artículo
	 */
	$intro_prompt = 'Estoy escribiendo un artículo sobre "' . $keyword . '". Por favor, escribe dos párrafos cortos introductorios sobre "' . $keyword . '" redactados en idioma '.$language.' para incorporarlos como introducción al artículo. Cada párrafo debe estar envuelto en etiquetas de párrafo HTML (<p></p>). El texto debe estar listo para su incorporación, así que no se necesitan subtítulos ni menciones del formato HTML. No hagas meción a estas instrucciones, solo límitate a escribir la introducción.';

	$messages = array(
		array(
			"role" => "user",
			"content" => $intro_prompt
		)
	);

	$post_fields = array(
		"model" => 'gpt-4o-mini',
		"messages" => $messages,
		"max_tokens" => 500,  
		"temperature" => 0.7  
	);

	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));

	$result = curl_exec($ch);

	$curlError = curl_errno($ch);
		
	if ($curlError) {
		$curlErrorMsg = curl_error($ch);

		if ($curlError == CURLE_COULDNT_CONNECT) {
			throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
		} else {
			throw new Exception('Error cURL: ' . $curlErrorMsg);
		}
	}
		
	if (!$result) 
	{                        
		throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
	}						
	
	$response = json_decode($result);
		
	if (json_last_error() !== JSON_ERROR_NONE) 
	{
		throw new Exception('La respuesta de OpenAI no se pudo decodificar. Por favor, intenta de nuevo.');
	}
				
	$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);		

	self::aicc_handleOpenAIHttpErrors($httpcode, $response);

	if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) 
	{
		throw new Exception('Respuesta inesperada de OpenAI. Por favor, intenta de nuevo. Respuesta de OpenAI: ' . $response);
	}

	$responseContent = $response->choices[0]->message->content;
	$responseContent = str_replace('<p>```html</p>', '', $responseContent);
	$responseContent = str_replace('```html', '', $responseContent);		
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;		
	$totalCost += self::aicc_calculate_process_cost($intro_prompt, $model, $tokens);

	$combinedData .= "<h1>" . ucfirst( $keyword ) . "</h1>";

	$combinedData .= $responseContent;  

	$article_content = array();




	/*
	 * Generamos el contenido para cada encabezado
	 */
	foreach ($subtitles as $subtitle) {

		if ($format == 'p' || $format == 'response') 
		{
			$prompt = self::aicc_replacePrompt($paragraphPrompts[$currentIndex], $subtitle, $language, $keyword, '');
		} 
		elseif ($format == 'li') 
		{
			$prompt = self::aicc_replacePrompt($listPrompts[$currentIndex], $subtitle, $language, $keyword, '');
		} 
		elseif ($format == 'table') 
		{
			$prompt = self::aicc_replacePrompt($tablePrompts[$currentIndex], $subtitle, $language, $keyword, '');
		} 
		elseif ($format == 'multiple') 
		{
			$prompt = self::aicc_replacePrompt($multiplePrompts[$currentIndex], $keyword, $language, $post_title, '');
		}
					
		$currentIndex = ($currentIndex + 1) % $countPrompts;
	
		$messages = array(
			array(
				"role" => "user",
				"content" => $prompt
			)
		);
			
		$post_fields = array(
			"model" => $model,
			"messages" => $messages,
			"max_tokens" => 2000,
			"temperature" => 0.7
		);
	
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
			
		$result = curl_exec($ch);
		
		$curlError = curl_errno($ch);
		
		if ($curlError) {
			$curlErrorMsg = curl_error($ch);

			if ($curlError == CURLE_COULDNT_CONNECT) {
				throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
			} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
				throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
			} else {
				throw new Exception('Error cURL: ' . $curlErrorMsg);
			}
		}

		if (!$result) 
		{                        
			throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
		}						

		$response = json_decode($result);

		if (json_last_error() !== JSON_ERROR_NONE) 
		{
			throw new Exception('La respuesta de OpenAI no se pudo decodificar. Por favor, intenta de nuevo.');
		}

		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);		

		self::aicc_handleOpenAIHttpErrors($httpcode, $response);

		if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) 
		{
			throw new Exception('Respuesta inesperada de OpenAI. Por favor, intenta de nuevo. Respuesta de OpenAI: ' . $response);
		}
		
		$usage = $response->usage;
		$tokens = $usage->total_tokens;
		
		$totalTokens = $totalTokens + $tokens;		
		$totalCost += self::aicc_calculate_process_cost($prompt, $model, $tokens);
		
	    $responseContent = $response->choices[0]->message->content;
		$responseContent = str_replace('<p>```html</p>', '', $responseContent);
		$responseContent = str_replace('```html', '', $responseContent);		
		
		// Verificar si el subtítulo está al principio del contenido y lo eliminamos
		$responseContent = preg_replace("/^" . preg_quote($subtitle, '/') . ":\s*/i", '', $responseContent);
		$responseContent = preg_replace("/^" . preg_quote($subtitle, '/') . "(?:\s*|\s*:\s*)/i", '', $responseContent);

		$subtitle = '<h2>' . ucfirst( $subtitle ) . '</h2>';	
		
		if (strpos($responseContent, 'como modelo de lenguaje de IA') === false &&
			strpos($responseContent, 'como modelo de lenguaje de inteligencia artificial') === false &&
			strpos($responseContent, '¿Hay algo más en lo que pueda ayudarte?') === false ) 
		{
			$responseContent = preg_replace('/<h[^>]*>.*?<\/h[^>]*>/', '', $responseContent);
						
			$lines = explode("\n", $responseContent);
			
			foreach ($lines as &$line) {
				$line = trim($line);
				if (!empty($line) && !preg_match('/^<.*>$/', $line)) {
					$line = '<p>' . $line . '</p>';
				}
			}

			$responseContent = implode("\n", $lines);

			$article_content[$subtitle] = trim($responseContent);
		
			$combinedData .= $subtitle;
			
			$combinedData .= trim($responseContent);
		} 
		else 
		{
			$error_message = 'Eliminamos algunos resultados porque OpenAI devolvió esto: ' . $responseContent;

			self::aicc_log_register($post_id, 'mensaje', $error_message, 'aicc_call_openai');		
		}		
		
	}