 <?php

	$keyword = $keywords[0];

	$prompt = self::aicc_replacePrompt($customPrompt, $keyword, $language, $post_title, '');
				
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
	curl_setopt($ch, CURLOPT_TIMEOUT, 300);
	if ( $force_ssl )
	{
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	}
			
	global $wpdb;
				
	wp_cache_flush();
								
	$messages = array(
		array(
	        "role" => "system",
	        "content" => "Estás en el proceso de crear un nuevo artículo centrado en la palabra clave: '" . $keyword . "'."
	    ),
		array(
			"role" => "user",
			"content" => $prompt
		)
	);
						
	$post_fields = array(
		"model" => $model,
		"messages" => $messages,
		"max_tokens" => 2000,
		"temperature" => 0.7
	);

	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_fields));
				
	$result = curl_exec($ch);
		
		
	/*
	 * Validamos errores cURL y chequeamos que la respuesta no este vacía
	 */
	$curlError = curl_errno($ch);
		
	if ($curlError) {
		$curlErrorMsg = curl_error($ch);
		if ($curlError == CURLE_COULDNT_CONNECT) {
			throw new Exception('No se pudo establecer una conexión con OpenAI. Verifica tu conexión a internet.');
		} elseif ($curlError == CURLE_OPERATION_TIMEDOUT) {
			throw new Exception('La solicitud a OpenAI tomó demasiado tiempo. Puede que OpenAI esté saturado o que haya un problema de conexión a Internet. Intenta de nuevo en unso minutos.');
		} else {
			throw new Exception('Error cURL: ' . $curlErrorMsg);
		}
	}
			
	if (!$result) 
	{                        
		throw new Exception('La respuesta de OpenAI está vacía. Por favor, intenta de nuevo.');
	}						

		
		
	/*
	 * Chequeamos errores al decodificar la respuesta
	 */
	$response = json_decode($result);
		
	if (json_last_error() !== JSON_ERROR_NONE) 
	{
		throw new Exception('La respuesta de OpenAI no se pudo decodificar. Por favor, intenta de nuevo.');
	}
		

				
	/*
	 * Chequeamos errores de HTTP
	 */
	$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);		

	self::aicc_handleOpenAIHttpErrors($httpcode, $response);


	/*
	 * Chequeamos que la respusesta tenga formato adecuado
	 */
	if (!isset($response->choices[0]->message->content) || !isset($response->usage->total_tokens)) 
	{
		throw new Exception('Respuesta inesperada de OpenAI. Por favor, intenta de nuevo. Respuesta de OpenAI: ' . $response);
	}

		
	$responseContent = $response->choices[0]->message->content;
	$responseContent = str_replace('<p>```html</p>', '', $responseContent);
	$responseContent = str_replace('```html', '', $responseContent);
	$responseContent = str_replace('```', '', $responseContent);	
	$usage = $response->usage;
	$tokens = $usage->total_tokens;
		
	$totalTokens = $totalTokens + $tokens;
	$totalCost += self::aicc_calculate_process_cost($prompt, $model, $tokens);

	$lines = explode("\n", $responseContent);
		
	foreach ($lines as &$line) {
		$line = trim($line);
		if (!empty($line) && !preg_match('/^<.*>$/', $line)) {
			$line = '<p>' . $line . '</p>';
		}
	}
		
	$responseContent = implode("\n", $lines);
							
	$combinedData = trim($responseContent);		

	sleep(1);