<?php if ( current_user_can('manage_options') ) : ?>

<style>
.aicc-tooltip-a { cursor:pointer; }
</style>

<form method="post">

	<?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

	<table class="form-table" id="aicc-fieldset-one">

		<h2><?php _e('Claves API', 'aicc'); ?></h2>

		<?php

		if ( ( isset( $_POST['devlog_nonce_field'] ) && wp_verify_nonce($_POST['devlog_nonce_field'], 'devlog_nonce_action') ) && ( current_user_can('manage_options') ) )
		{

			$error = false;

			if (isset($_POST['aicc_options_property_type'])) {
				update_option('aicc_options_property_type', $_POST['aicc_options_property_type'], '', 'yes');
			}
			else {
				delete_option('aicc_options_property_type');
			}	
			if (isset($_POST['aicc_options_sc']) && (!empty($_POST['aicc_options_sc']))) {
				$sanitized_content = wp_kses_post(stripslashes($_POST['aicc_options_sc']));
				update_option('aicc_options_sc', $sanitized_content, 'yes');
				/*
				 * Cuando colocamos la API de Search Console, hacemos la carga inicial de datos.
				 */
				$response = $this->aicc_search_console_first();

				if ($response['success'])
				{
					echo '<div class="notice notice-success is-dismissible"><p><strong>Clave API de Search Console:</strong> Se obtuvieron los datos de Search Console correctamente.</p></div>';
				} 
				else
				{
					$error = true;
					$error_sc = get_transient('aicc_error_sc');				
					echo '<div class="notice notice-error is-dismissible"><p>'.$error_sc.'</p></div>';
					delete_transient('aicc_error_sc');
				}
			}
			else {
				delete_transient('aicc_data_cache');
				delete_option('aicc_options_sc');
			}	
			if (isset($_POST['aicc_options_openai']) && (!empty($_POST['aicc_options_openai']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_openai']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_openai', $encrypted_api_key, 'yes');

				$result = $this->aicc_ValidateKey($sanitized_api_key);

				if ($result['status']) 
				{
					echo '<div class="notice notice-success is-dismissible"><p><strong>Clave API de OpenAI: </strong>' . __($result['message'], "aicc") . '</p></div>';
				} 
				else
				{
					$error = true;
					echo '<div class="notice notice-error is-dismissible"><p><strong>Clave API de OpenAI: </strong>' . __($result['message'], "aicc") . '</p></div>';
				}

			}
			else {
				delete_option('aicc_options_openai');
			}	

			if (isset($_POST['aicc_options_replicate']) && (!empty($_POST['aicc_options_replicate']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_replicate']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_replicate', $encrypted_api_key, 'yes');

				$result = $this->aicc_ValidateKey_replicate($sanitized_api_key);

				if ($result['status']) 
				{
					echo '<div class="notice notice-success is-dismissible"><p><strong>Clave API de Replicate: </strong>' . __($result['message'], "aicc") . '</p></div>';
				} 
				else
				{
					$error = true;
					echo '<div class="notice notice-error is-dismissible"><p><strong>Clave API de Replicate: </strong>' . __($result['message'], "aicc") . '</p></div>';
				}

			}
			else {
				delete_option('aicc_options_replicate');
			}	

			if (isset($_POST['aicc_options_analysis_api'])) {
				update_option('aicc_options_analysis_api', $_POST['aicc_options_analysis_api'], 'yes');
			}
			else {
				delete_option('aicc_options_analysis_api');
			}


			if (isset($_POST['aicc_options_valueserp']) && (!empty($_POST['aicc_options_valueserp']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_valueserp']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_valueserp', $encrypted_api_key, 'yes');

				$result = $this->aicc_checkValueSERP($sanitized_api_key);

				if ($result['status']) 
				{
					echo '<div class="notice notice-success is-dismissible"><p><strong>Clave API de ValueSERP: </strong>' . __($result['message'], "aicc") . '</p></div>';
				} 
				else
				{
					$error = true;
					echo '<div class="notice notice-error is-dismissible"><p><strong>Clave API de ValueSERP: </strong>' . __($result['message'], "aicc") . '</p></div>';
				}

			}
			else {
				delete_option('aicc_options_valueserp');
			}

			if (isset($_POST['aicc_options_spaceserp']) && (!empty($_POST['aicc_options_spaceserp']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_spaceserp']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_spaceserp', $encrypted_api_key, 'yes');
			}
			else {
				delete_option('aicc_options_spaceserp');
			}			

			if (isset($_POST['aicc_options_serpapi']) && (!empty($_POST['aicc_options_serpapi']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_serpapi']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_serpapi', $encrypted_api_key, 'yes');
			}
			else {
				delete_option('aicc_options_serpapi');
			}			

			if (isset($_POST['aicc_options_pexels']) && (!empty($_POST['aicc_options_pexels']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_pexels']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_pexels', $encrypted_api_key, 'yes');
			}
			else {
				delete_option('aicc_options_pexels');
			}

			if (isset($_POST['aicc_options_pixabay']) && (!empty($_POST['aicc_options_pixabay']))) {
				$sanitized_api_key = sanitize_text_field($_POST['aicc_options_pixabay']);
		    	$encrypted_api_key = $this->aicc_encrypt_api_key($sanitized_api_key);
				update_option('aicc_options_pixabay', $encrypted_api_key, 'yes');
			}
			else {
				delete_option('aicc_options_pixabay');
			}

		}


		$property_type  = get_option('aicc_options_property_type');

		$options_sc = get_option('aicc_options_sc') ;
		$analysis_api = get_option('aicc_options_analysis_api', 'valueserp');

		$openai_encrypted_key = get_option('aicc_options_openai');
		$pexels_encrypted_key = get_option('aicc_options_pexels');
		$pixabay_encrypted_key = get_option('aicc_options_pixabay');
		$valueserp_encrypted_key = get_option('aicc_options_valueserp');
		$spaceserp_encrypted_key = get_option('aicc_options_spaceserp');
		$serpapi_encrypted_key = get_option('aicc_options_serpapi');
		$replicate_encrypted_key = get_option('aicc_options_replicate');

		$options_openai = $openai_encrypted_key ? self::aicc_decrypt_api_key($openai_encrypted_key) : '';
		$options_pexels = $pexels_encrypted_key ? self::aicc_decrypt_api_key($pexels_encrypted_key) : '';
		$options_pixabay = $pixabay_encrypted_key ? self::aicc_decrypt_api_key($pixabay_encrypted_key) : '';
		$options_valueserp = $valueserp_encrypted_key ? self::aicc_decrypt_api_key($valueserp_encrypted_key) : '';
		$options_spaceserp = $spaceserp_encrypted_key ? self::aicc_decrypt_api_key($spaceserp_encrypted_key) : '';
		$options_serpapi = $serpapi_encrypted_key ? self::aicc_decrypt_api_key($serpapi_encrypted_key) : '';
		$options_replicate = $replicate_encrypted_key ? self::aicc_decrypt_api_key($replicate_encrypted_key) : '';

		?>

		<style>
			tr th i {
				display: inline-block;
			    vertical-align: top;
			    box-sizing: border-box;
			    margin: 1px 0 0 6px;
			    padding: 0 5px;
			    min-width: 18px;
			    height: 18px;
			    border-radius: 3px;
			    background-color: #f1556c;
			    color: #fff;
			    font-size: 11px;
			    line-height: 1.715;
			    text-align: center;
			    font-style: normal;
			}
		</style>
		<tbody>

			<tr>
				<th>
					<label for="aicc_options_property_type"><?php _e('Type of property', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the type of property with which you have registered the website in Search Console.', 'aicc'); ?></span></span>
				</th>
				<td>
					<select name="aicc_options_property_type" id="aicc_options_property_type">
		                <option value="url_prefix" <?php selected($property_type, 'url_prefix'); ?>><?php _e('Prefijo de URL', 'aicc'); ?></option>
		                <option value="domain" <?php selected($property_type, 'domain'); ?>><?php _e('Propiedad de dominio', 'aicc'); ?></option>				
		        </select>
				</td>
			</tr>	

			<tr>
				<th>
					<label for="aicc_options_sc"><?php _e('Search Console API', 'aicc'); ?></label><a href="https://contentcurator.ai/wp-content/uploads/2023/09/api_key_search_console.pdf" target="_blank" class="aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php _e('Click here to learn how to obtain this API key. It is necessary to perform healing.', 'aicc'); ?></span></a>
				</th>
				<td>
					<textarea name="aicc_options_sc" id="aicc_options_sc" rows="10" cols="50"><?php echo $options_sc; ?></textarea>
				</td>
			</tr>
			
			<tr>
				<th>
					<label for="aicc_options_openai"><?php _e('OpenAI API', 'aicc'); ?></label><a href="https://www.youtube.com/watch?v=IM3Vn6K8jn4" target="_blank" class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php _e('Click here to learn how to obtain this API key. It is necessary to perform healing.', 'aicc'); ?></span></a>
				</th>
				<td>
					<input name="aicc_options_openai" id="aicc_options_openai" type="password" value="<?php echo $options_openai; ?>"/>
				</td>
			</tr>


			<tr>
				<th>
					<label for="aicc_options_replicate"><?php _e('Clave API de Replicate', 'aicc'); ?><i>Nuevo</i></label><a href="https://www.youtube.com/watch?v=cQQtYqimn_k" target="_blank" class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php _e('Haz clic aquí para conocer cómo obtener esta clave API. Es necesaria para generar imágenes con Replicate por 0.003$.', 'aicc'); ?></span></a>
				</th>
				<td>
					<input name="aicc_options_replicate" id="aicc_options_replicate" type="password" value="<?php echo $options_replicate; ?>"/>
				</td>
			</tr>


			<tr>
				<th>
					<label for="aicc_options_pexels"><?php _e('Clave API de Pexels', 'aicc'); ?></label><a href="https://www.pexels.com/api/" target="_blank" rel="nofollow noopener"><span class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php _e('Haz clic aquí para obtener esta clave API. Es necesaria si quieres agregar en tus artículos imágenes de stock con Pexels.', 'aicc'); ?></span></span></a>
				</th>
				<td>
					<input name="aicc_options_pexels" id="aicc_options_pexels" type="password" value="<?php echo $options_pexels; ?>"/>
				</td>
			</tr>

			<tr>
				<th>
					<label for="aicc_options_pixabay"><?php _e('Clave API de Pixabay', 'aicc'); ?></label><a href="https://pixabay.com/es/service/about/api/" target="_blank" rel="nofollow noopener"><span class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php _e('Haz clic aquí para obtener esta clave API. Es necesaria si quieres agregar en tus artículos imágenes de stock con Pixabay.', 'aicc'); ?></span></span></a>
				</th>
				<td>
					<input name="aicc_options_pixabay" id="aicc_options_pixabay" type="password" value="<?php echo $options_pixabay; ?>"/>
				</td>
			</tr>

			<!--<tr>
				<th>
					<label for="aicc_options_analysis_api"><?php _e('Motor de búsqueda', 'aicc'); ?><i>Nuevo</i></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the type of property with which you have registered the website in Search Console.', 'aicc'); ?></span></span>
				</th>
				<td>
					<select name="aicc_options_analysis_api" id="aicc_options_analysis_api">
		                <option value="valueserp" <?php selected($analysis_api, 'valueserp'); ?>><?php _e('ValueSERP', 'aicc'); ?></option>
		                <option value="spaceserp" <?php selected($analysis_api, 'spaceserp'); ?>><?php _e('SpaceSERP', 'aicc'); ?></option>						                
		                <option value="serpapi" <?php selected($analysis_api, 'serpapi'); ?>><?php _e('SERPApi', 'aicc'); ?></option>				
		        </select>
				</td>
			</tr>	-->
			
			<tr>
				<th>
					<label for="aicc_options_valueserp"><?php _e('Clave API de ValueSERP', 'aicc'); ?></label><a href="https://www.valueserp.com/" target="_blank" class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php _e('La API de ValueSERP es necesaria para incorporar de forma masiva las PAA o People Also Ask.', 'aicc'); ?></span></a>
				</th>
				<td>
					<input name="aicc_options_valueserp" id="aicc_options_valueserp" type="password" value="<?php echo $options_valueserp; ?>"/>
				</td>
			</tr>

			<!--<tr <?php //if ($analysis_api != 'spaceserp'):?>style="display: none;"<?php //endif;?>>
				<th>
					<label for="aicc_options_spaceserp"><?php //_e('Clave API de SpaceSERP', 'aicc'); ?><i>Nuevo</i></label><a href="https://www.youtube.com/watch?v=IXXXXXX" target="_blank" class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php //_e('', 'aicc'); ?></span></a>
				</th>
				<td>
					<input name="aicc_options_spaceserp" id="aicc_options_spaceserp" type="password" value="<?php //echo $options_spaceserp; ?>"/>
				</td>
			</tr>

			<tr <?php //if ($analysis_api != 'serpapi'):?>style="display: none;"<?php //endif;?>>
				<th>
					<label for="aicc_options_serpapi"><?php //_e('Clave API de SERPApi', 'aicc'); ?><i>Nuevo</i></label><a href="https://www.youtube.com/watch?v=IXXXXXX" target="_blank" class="aicc-tooltip aicc-tooltip aicc-tooltip-a">?<span class="tooltiptext"><?php //_e('', 'aicc'); ?></span></a>
				</th>
				<td>
					<input name="aicc_options_serpapi" id="aicc_options_serpapi" type="password" value="<?php //echo $options_serpapi; ?>"/>
				</td>
			</tr>	-->					

			<tr>
				<th>
					<input type="hidden" name="aicc_from" id="aicc_from" value="general-settings" />
					<?php submit_button(); ?>
				</th>
			</tr>
			
		</tbody>

	</table>

</form>

<script type="text/javascript">
	
	jQuery(document).ready(function($) {
    function toggleApiFields() {
        var selectedApi = $('#aicc_options_analysis_api').val();

        // Mostramos o escondemos los campos basados en la opción seleccionada
        if (selectedApi === 'valueserp') {
            $('#aicc_options_valueserp').closest('tr').show();
        } else {
            $('#aicc_options_valueserp').closest('tr').hide();
        }

        if (selectedApi === 'spaceserp') {
            $('#aicc_options_spaceserp').closest('tr').show();
        } else {
            $('#aicc_options_spaceserp').closest('tr').hide();
        }

        if (selectedApi === 'serpapi') {
            $('#aicc_options_serpapi').closest('tr').show();
        } else {
            $('#aicc_options_serpapi').closest('tr').hide();
        }
    }

    // Ejecutamos la función al cambiar el valor del select
    //$('#aicc_options_analysis_api').on('change', toggleApiFields);

    // Ejecutamos la función al cargar la página para que el campo correcto esté visible
    //toggleApiFields();
});


</script>

<?php else: ?>

<div class="notice notice-warning inline active-plugin-edit-warning" style="margin:10px !important;"><p>Parece que no tienes los permisos suficientes para ver esta página.</p></div>

<?php endif; ?>