	<?php

	if ( ! $this->aicc_table_exists( AICC_BULK_TABLE ) )
	{
		global $wpdb;
		$sql = $wpdb->prepare( "
			CREATE TABLE " . AICC_BULK_TABLE . " (
				id mediumint(9) NOT NULL AUTO_INCREMENT,
				type varchar(55) NOT NULL,
				amount mediumint(9) NOT NULL,
				tokens mediumint(9) NOT NULL,
				cost DECIMAL(12,9) NOT NULL,
				budget mediumint(9) NOT NULL,
				model varchar(55) NOT NULL,
				ids_processed TEXT NOT NULL,
				date DATETIME DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY  (id),
	        	INDEX (type)
			) " . $charset_collate . ";
		" );
		require_once( AICC_UPGRADE_PATH );
		dbDelta( $sql );
	}

	?>

	<?php if ( current_user_can('manage_options') ) : ?>

	<style>
		#calcular-costo-btn,
		#aicc-recovery-autosave {
			color: #f1556c;
			border-color: #f1556c;
		    background: #fdeef0;
			vertical-align: top;	
			display: inline-block;
		    text-decoration: none;
		    font-size: 13px;
		    line-height: 2.15384615;
		    min-height: 30px;
		    margin: 0;
		    padding: 0 10px;
		    cursor: pointer;
		    border-width: 1px;
		    border-style: solid;
		    -webkit-appearance: none;
		    border-radius: 3px;
		    white-space: nowrap;
		    box-sizing: border-box;
		}
		#calcular-costo-btn:hover {
			background:#f7e7ff;
			border-color:#f1556c;
		}
		#calcular-costo-btn:active {
			border-color:#d174ff
		}
		span.aicc-status.green {
			color:#00a320 !important;
			font-weight:bold;
		}
		span.aicc-status.red {
			color:#e65054 !important;
			font-weight:bold;
		}
		#cancel-bulk-process {
			cursor: pointer;
			text-decoration: underline;
		}
		#cancel-bulk-process:hover {
			text-decoration: none;
		}
		#bulkPromptRow p,
		#bulkPromptRow li {
			font-size: 13px;
			color: #767676;
		}
		#bulkPromptRow ul {
			margin-top: 12px;
			margin-left: 16px;
			list-style: disc;
		}
		#bulkPromptRow code {
			cursor: pointer;
		}
		#bulkPromptRow code:hover {
			background: rgba(0,0,0,.1) !important;
		}
		.aicc-tooltip-a { 
			cursor:pointer; 
		}
		.aicc-options h2 {
		    display: flex;
		    align-items: center;
		}
		.aicc-options h2 span {
		    background: #202225;
		    color: #fff;
		    margin-left: 6px;
		}
		.aicc-link {
			cursor: pointer;
			text-decoration: underline;
		}

		div:where(.swal2-container) button:where(.swal2-styled).swal2-deny {
			background: #dc3741 !important;
		    border-color: #dc3741 !important;
		    color: #fff !important;
		    text-decoration: none !important;
		    text-shadow: none !important;
		    text-decoration: none !important;
		    font-size: 13px !important;
		    line-height: 2.15384615 !important;
		    min-height: 30px !important;
		    margin: 0 !important;
		    padding: 0 10px !important;
		    cursor: pointer !important border-width: 1px !important;
		    border-style: solid !important;
		    margin-left: 10px !important;
		    -webkit-appearance: none !important;
		    border-radius: 3px !important;
		    white-space: nowrap !important;
		    box-sizing: border-box !important;
		    box-shadow: none !important;
		}


		tr th i {
			display: inline-block;
		    vertical-align: top;
		    box-sizing: border-box;
		    margin: 1px 0 0 6px;
		    padding: 0 5px;
		    min-width: 18px;
		    height: 18px;
		    border-radius: 3px;
		    background-color: #f1556c;
		    color: #fff;
		    font-size: 11px;
		    line-height: 1.715;
		    text-align: center;
		    font-style: normal;
		}
		
	</style>
	<?php

	global $wpdb;

	$ajust_model = get_option('aicc_ajust_model', 1);

	$model = get_option('aicc_model', 'gpt-4o-mini');

	// Actualiza modelos antiguos del plugin a los nuevos modelos
	$models = [
	    'gpt-3.5-turbo' => 'gpt-3.5-turbo-0125',
	    'gpt-4' => 'gpt-4-1106-preview',
	    'gpt-4-0125-preview' => 'gpt-4-1106-preview'
	];

	$model = $models[$model] ?? $model;

	// Mapea los modelos a sus nombres legibles
	$model_names = [
	    'gpt-3.5-turbo' => 'GPT 3.5 Turbo',
	    'gpt-3.5-turbo-0125' => 'GPT 3.5 Turbo',
	    'gpt-4' => 'GPT 4 Turbo',
	    'gpt-4-1106-preview' => 'GPT 4 Turbo',
	    'gpt-4-0125-preview' => 'GPT 4 Turbo',
	    'gpt-4o' => 'GPT 4o',
	    'gpt-4o-mini' => 'GPT 4o mini'
	];

	$modelM = $model_names[$model] ?? 'Modelo desconocido';
	
	$status = '';

	$is_error = get_transient('aicc_error_bulk');

	if ( $is_error ) {
		$admin_link = admin_url('admin.php?page=aicc-log');
		echo '<div class="notice notice-error is-dismissible"><p><strong>Se produjo un error</strong>. Revisa el registro de depuración del plugin para identificar la causa del problema o contacta con nuestro equipo de soporte. <a target="_blank" href="' . esc_url($admin_link) . '">Ir al registro de depuración</a></p></div>';
		delete_transient('aicc_error_bulk');
		$success_message = 'La curación en bulk terminó.';	
	}
	else
	{
		$success_message = 'La curación en bulk se completó con éxito.';
	}

	$is_run = get_transient('aicc_is_bulk_running');

	$is_end = get_transient('aicc_end_bulk');

	$is_cancel = $wpdb->get_var("SELECT option_value FROM $wpdb->options WHERE option_name = 'aicc_cancel_bulk_process' LIMIT 1");

	$is_cancel = $is_cancel === '1';

	$is_recovery = get_transient('aicc_is_recovery_running');

	$discarded = get_option('aicc_bulk_discarded_count');
	if ($discarded === false || !$discarded ) {
		$discarded = 0;
	}

	if ($is_cancel) {
	    $status = 'cancel';
	} elseif ($is_run) {
	    $status = 'run';
	} elseif ($is_end) {
	    $status = 'end';
	} elseif ($is_recovery) {
	    $status = 'recovery';
	} else {
	    $status = '';
	}

	if ($status == 'cancel') {
	echo '<div class="notice notice-warning is-dismissible"><p>' . __('El proceso de cancelación está en curso. Por favor, ten paciencia, este proceso puede tardar unos minutos.', "aicc") . '</p></div>';
		delete_option('aicc_bulk_total_posts');
		delete_option('aicc_bulk_processed_count');
	} elseif ($status == 'run') {
	    $total_posts = get_option('aicc_bulk_total_posts');
		$processed_count = get_option('aicc_bulk_processed_count');	
		if ($processed_count === false || !$processed_count ) {
		    $processed_count = 0;
		}	
		$currentBulkProcessId = get_transient('aicc_current_bulk_process_id');
		if (false === $currentBulkProcessId) {
		    $currentBulkProcessId = '';
		}
		$resultado = null;
		$type = '';
		$type_ed = '';		
		if (false !== $currentBulkProcessId && $currentBulkProcessId > 0) {
		    $sql = $wpdb->prepare("SELECT type FROM " . AICC_BULK_TABLE . " WHERE id = %d", $currentBulkProcessId);
		    $resultado = $wpdb->get_row($sql);
		    if ($resultado){
		    	$type = $resultado->type;
		    }
		}
	    if ($type == 'Contenido') {
	    	$type_ed = 'contenidos';
	    }elseif ($type == 'Imagen'){
	    	$type_ed = 'imágenes';
	    }elseif ($type == 'Metaetiqueta'){
	    	$type_ed = 'metaetiquetas';
	    }
		$message = '<strong>Curación de '.$type_ed.' en proceso</strong>';
		if ($type == 'Contenido') {
			$message .= ' · Procesados <strong>' . $processed_count . '</strong> de <strong>' . $total_posts  . '</strong>';
			if($discarded){
				$message .= ' · ' . $discarded . ' descartados';
			}
			$message .=  ' · <span id="cancel-bulk-process">Cancelar proceso</span>';
		}
		echo '<div class="notice notice-success is-dismissible"><p>'.$message.'</p></div>';

	} elseif ($status == 'recovery') {
		$total_posts = get_transient('aicc_total_recover_posts');
		$processed_count = get_transient('aicc_processed_recovery_posts');
		if ($processed_count === false || !$processed_count ) {
	        $processed_count = 0;
	    }
		$message = 'Recuperados <strong>' . $processed_count . '</strong> de <strong>' . $total_posts  . '</strong>';
		echo '<div class="notice notice-success is-dismissible"><p><strong>' . __($message, "aicc") . ' · <span id="cancel-bulk-process">Cancelar proceso</span></strong></p></div>';
	} elseif ($status == 'end') {
		delete_transient('aicc_end_bulk');
		echo '<div class="notice notice-success is-dismissible"><p><strong>'.__($success_message, "aicc").'</strong></p></div>';
	}

	$data_prompt = 'Tu tarea es enriquecer el siguiente contenido con nuevas keywords específicas, las cuales son: {keywords}. Cada una de estas keywords debe ser incorporada al menos una vez en el texto, asegurando que el resultado final sea un texto más relevante y coherente. Es importante integrar estas keywords de forma natural, ajustando, modificando o reemplazando frases existentes para incluir cada una de las nuevas keywords proporcionadas, sin sacrificar la calidad ni legibilidad del contenido. Deberás modificar el texto existente o añadir nuevos párrafos y/o listas HTML (usando <ul> con <li> o <ol> con <li>) de manera que todo nuevo contenido se sienta como una parte integral del artículo, manteniendo el tono y el estilo original. Además, debes asegurarte de que las keywords ya presentes, {keywords_incluidas}, permanezcan intactas en el texto, ya que son fundamentales para la coherencia y relevancia del tema. Es crucial mantener todas las etiquetas `<img>` existentes sin cambios. Todas las imágenes deben permanecer en su lugar original y no deben ser eliminadas ni alteradas. Asegura que cualquier adición o modificación de contenido se realice sin afectar la presencia y posición de las imágenes. Instrucciones detalladas: 1. Conserva la estructura y esencia del contenido original, pero siéntete libre de modificar frases o secciones para incorporar todas las nuevas keywords de manera orgánica. Cada cambio debe preservar o mejorar la relevancia y coherencia del texto. 2. El artículo final debe ser una versión enriquecida del original, que incluya todas las modificaciones realizadas para integrar las nuevas keywords. Es esencial que devuelvas el texto completo, no solo las secciones modificadas. Esto asegura una visión integral del contenido mejorado. 3. Mantén todas las etiquetas HTML intactas y sigue utilizando el formato HTML para las operaciones de estilo, incluyendo la preservación de las etiquetas <strong> y la estructura de encabezados (H2, H3, H4) ya presentes en el contenido acutal. La integración de las nuevas keywords no debe comprometer la estructura del contenido ni su presentación visual. 4. Utilizar exclusivamente formato HTML para cualquier operación de estilo y evitar completamente el uso de marcadores de formato de texto como ** para negritas o ## para encabezados. Todas las modificaciones y adiciones deben seguir el formato HTML sin desviarse a Markdown u otros formatos. 5. Asegúrate de que las nuevas keywords se utilicen al menos una vez y que cualquier adición o modificación fluya de manera coherente con el resto del contenido. La clave es mejorar el texto existente sin desviar su tema o diluir su mensaje principal. 6. No acortar el contenido original. Se espera que el texto resultante sea más largo debido a las adiciones necesarias. Esto es esencial para cumplir con las validaciones de longitud del contenido. No importa si hay contenido repetido o duplicado o tú piensas que sería mejor eliminar ciertas partes. Es vital no acortar el contenido original, así que trabaja sobre él agregando contenido y no quitando. 7. Por ningún motivo debes agregar etiquetas HTML <strong> en los nuevos párrafos o contenidos que agregues. Esta medida es para prevenir la sobreoptimización del contenido con las keywords recién incorporadas. Solo debes mantener las etiquetas <strong> que ya estén dentro del contenido, pero no agregar nuevas. Además, asegúrate de mantener todas las etiquetas HTML <strong> que ya están presentes dentro del contenido. Por favor, realiza las modificaciones necesarias con el fin de entregar un artículo completo que no solo mantenga el valor informativo y temático del original, sino que también lo amplíe y enriquezca con las nuevas keywords. Este enfoque garantiza que el contenido final sea tanto integral como mejorado, cumpliendo con los objetivos de esta tarea. Es crucial que todas las mejoras y modificaciones se realicen respetando el idioma original del contenido. Por último, evita completamente hacer mención a estas instrucciones, al formato HTML, o cualquier comentario adicional fuera del contenido del artículo. A continuación, se muestra el contenido sobre el cual debes trabajar: {post_content}';

	$option_bulkc_prompt = get_option('aicc_bulkc_prompt', '');
	$option_bulkc_budget = get_option('aicc_bulkc_budget', '');

	?>
	<form method="post" id="form-bulk-content">

	<?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

	<table class="form-table" id="aicc-fieldset-one">

			<h2><?php _e('Content Bulk Curation', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('In this section you can perform massive content curations on all your articles automatically, without needing to modify them individually. You can include the most relevant Search Console keywords in each of your articles or customize them to your specific needs with tailored instructions.', 'aicc'); ?></span></span></h2>

			<tbody>
				<?php
				    $post_types = get_post_types(array('public' => true), 'names');
				    $excluded_post_types = array('attachment', 'product');
				    $post_types = array_diff($post_types, $excluded_post_types);

				    // Obtener las opciones guardadas
				    $saved_post_type = get_option('aicc_bulkc_post_type', 'post');
				    $saved_type = get_option('aicc_bulkc_type', 'improve');
				    $saved_prompt = get_option('aicc_bulkc_prompt', '');
				    $saved_num_keywords = get_option('aicc_bulkc_num_keywords', 5);
				    $saved_sort_by = get_option('aicc_bulkc_sort_by', 'clicks');
				    $saved_include = get_option('aicc_bulkc_include', '');
				    $saved_exclude = get_option('aicc_bulkc_exclude', '');
				    $saved_exclude_already = get_option('aicc_bulkc_exclude_already', true);
				    $saved_remove_validations = get_option('aicc_bulkc_remove_validations', false);
				    $saved_budget = get_option('aicc_bulkc_budget', 0);
				    $saved_include_headers = get_option('aicc_bulkc_include_headers', false);
				?>
				<tr>
				    <th>
				        <label for="aicc_bulkc_post_type"><?php _e('Run on', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the type of content where bulk curation will run.', 'aicc'); ?></span></span>
				    </th>
				    <td>
				       <select name="aicc_bulkc_post_type" id="aicc_bulkc_post_type">
					    <?php foreach ($post_types as $post_type): ?>
					        <?php 
					            $post_type_object = get_post_type_object($post_type);
					            $post_type_label = $post_type_object->labels->singular_name;
					        ?>
					        <option value="<?php echo $post_type; ?>" <?php selected($saved_post_type, $post_type); ?>><?php echo $post_type_label; ?></option>
					    <?php endforeach; ?>
						</select>
				    </td>
				</tr>

				<tr>
				    <th>
				        <label for="aicc_bulkc_type"><?php _e('Tipo de curación', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Con esta opción puedes elegir si deseas mejorar tus artículos incorporando palabras clave de Search Console, regenerar los artículos por completo o usar una instrucción personalizada para hacer, de forma masiva, literalmente lo que tú quieras.', 'aicc'); ?></span></span>
				    </th>
				    <td>
				       <select name="aicc_bulkc_type" id="aicc_bulkc_type">
					        <option value="improve" <?php selected($saved_type, 'improve'); ?>><?php _e('Agregar keywords de oportunidad', 'aicc'); ?></option>
					        <option value="paa" <?php selected($saved_type, 'paa'); ?>><?php _e('Agregar preguntas relacionadas', 'aicc'); ?></option>
					        <option value="regenerate" <?php selected($saved_type, 'regenerate'); ?>><?php _e('Regenerar artículos', 'aicc'); ?></option>
					        <option value="custom" <?php selected($saved_type, 'custom'); ?>><?php _e('Usar instrucción personalizada', 'aicc'); ?></option>
					</select>
					<div id="aicc_message" style="display: block; margin-top: 6px; font-style: italic; margin-bottom:2px;">
						<?php 
						if (get_option('aicc_bulkc_type', 'improve') == 'improve' && $modelM != 'GPT 4 Turbo' && !$ajust_model) {
							echo 'El modelo recomendado para agregar keywords de oportunidad es GPT 4 Turbo. Este modelo garantiza la calidad de los contenidos generados. Actualmente estás usando ' . $modelM . '. <a href="'.esc_url(get_admin_url(null, 'admin.php?page=aicc')).'" target="_blank">Haz clic aquí para cambiar de modelo</a>.';
						}
						if (get_option('aicc_bulkc_type', 'improve') == 'regenerate' && $modelM != 'GPT 4o mini' && !$ajust_model) {
							echo 'El modelo recomendado para regenerar los artículos es GPT 4o mini. Este modelo genera contenidos de mucha calidad al menor costo posible. Actualmente estás usando ' . $modelM . '. <a href="'.esc_url(get_admin_url(null, 'admin.php?page=aicc')).'" target="_blank">Haz clic aquí para cambiar de modelo</a>.';
						}
						if (get_option('aicc_bulkc_type', 'improve') == 'paa' && $modelM != 'GPT 4o mini' && !$ajust_model) {
							echo 'El modelo recomendado para agregar preguntas relacionadas es GPT 4o mini. Este modelo genera contenidos de mucha calidad al menor costo posible. Actualmente estás usando ' . $modelM . '. <a href="'.esc_url(get_admin_url(null, 'admin.php?page=aicc')).'" target="_blank">Haz clic aquí para cambiar de modelo</a>.';
						}					
						?>
					</div>
				    </td>
				</tr>	

				<tr id="bulkPromptRow" <?php if ($saved_type != 'custom' || !$saved_prompt): ?>style="display: none;"<?php endif;?>>
				    <th>
				        <label for="aicc_bulkc_prompt"><?php _e('Bulk Prompt', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Design a specific prompt for mass healing. Use the variable {keyword} to indicate the keywords that should be incorporated.', 'aicc'); ?></span></span>
				    </th>
				    <td>
				        <textarea name="aicc_bulkc_prompt" id="aicc_bulkc_prompt" rows="8" cols="50" placeholder="El objetivo es enriquecer el siguiente contenido con nuevas keywords, {keywords}, de manera que el resultado final sea un texto más relevante y coherente, sin sacrificar su calidad ni legibilidad. Se permite ajustar, modificar o reemplazar frases existentes para integrar todas estas nuevas keywords de forma natural, manteniendo o mejorando la fluidez y coherencia del contenido...."><?php echo $saved_prompt ? esc_textarea($saved_prompt) : ''; ?></textarea>

				        <p>Te recomendamos usar esta opción avanzada únicamente si tienes experiencia creando prompts personalizados. Puedes <span class="copy-to-clipboard aicc-link" data-variable="<?php echo $data_prompt; ?>" title="Copiar">copiar nuestra instrucción base</span> para trabajar sobre ella o crear una completamente nueva. Las variables disponibles son:</p>
				        <ul>
						    <li><span class="copy-to-clipboard" data-variable="{keywords}" title="Copiar"><code>{keywords}</code></span> son las keywords de Search Console que faltan incluir</li>
						    <li><span class="copy-to-clipboard" data-variable="{keywords_incluidas}" title="Copiar"><code>{keywords_incluidas}</code></span> son las keywords de Search Console que ya están incluidas</li>
						    <li><span class="copy-to-clipboard" data-variable="{post_title}" title="Copiar"><code>{post_title}</code></span> es el título del artículo</li>
						    <li><span class="copy-to-clipboard" data-variable="{post_content}" title="Copiar"><code>{post_content}</code></span> es el contenido actual del artículo</li>
						</ul>
				    </td>
				</tr>

				<tr id="campo_sort_by" <?php if ($saved_type == 'paa'):?>style="display: none;"<?php endif;?>> 
				    <th>
				        <label for="aicc_bulkc_sort_by"><?php _e('Sort by', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e("The criteria you choose will determine how keywords are sorted for curation. If you choose 'Impressions', those keywords with the most impressions and that do not appear in the current content will be prioritized. If you choose 'Clicks', keywords with a higher number of clicks and that are not in the content will be selected.", "aicc"); ?></span></span>
				    </th>
				    <td>
				       <select name="aicc_bulkc_sort_by" id="aicc_bulkc_sort_by">
					        <option value="impressions" <?php selected($saved_sort_by, 'impressions'); ?>><?php _e('Impressions', 'aicc'); ?></option>
					        <option value="clicks" <?php selected($saved_sort_by, 'clicks'); ?>><?php _e('Clicks', 'aicc'); ?></option>
						</select>
				    </td>
				</tr>			

				<tr id="campo_number" <?php if ($saved_type == 'paa'):?>style="display: none;"<?php endif;?>>
					<th>
						<label for="aicc_bulkc_number"><?php _e('Number of keywords', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Choose how many Search Console keywords, which are not currently part of your content, you want to include in the curation process.', 'aicc'); ?></span></span>
					</th>
					<td>
						<input style="width:60px"  name="aicc_bulkc_number" id="aicc_bulkc_number" type="number" value="<?php echo esc_attr($saved_num_keywords); ?>" min="1" max="10"/> 
					</td>
				</tr>	

				<tr id="campo_include_headers" <?php if ($saved_type != 'improve'): ?>style="display: none;"<?php endif;?>>
					<th>
						<label for="aicc_bulkc_include_headers"><?php _e('Generar encabezados', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Activando esta opción, el prompt base se enriquecerá con instrucciones específicas para crear uno o dos encabezados, ya sean H2 o H3, utilizando las palabras clave seleccionadas de Search Console. Este proceso está diseñado para integrar orgánicamente términos relevantes en la estructura del contenido, mejorando así su visibilidad y relevancia en los resultados de búsqueda.', 'aicc'); ?></span></span>
					</th>
					<td>
						<input name="aicc_bulkc_include_headers" id="aicc_bulkc_include_headers" type="checkbox" value="1" <?php checked($saved_include_headers, '1'); ?>>
					</td>
				</tr>

				<tr id="exclude_already">
					<th>
						<label for="aicc_bulkc_exclude_already"><?php _e('Descartar contenido ya procesado', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('By activating this feature, items that have already been previously curated will be excluded from processing.', 'aicc'); ?></span></span>
					</th>
					<td>
						<input name="aicc_bulkc_exclude_already" id="aicc_bulkc_exclude_already" type="checkbox" value="1" <?php checked($saved_exclude_already, '1'); ?>>
					</td>
				</tr>

				<tr id="remove_validations" <?php if ($saved_type == 'regenerate' || $saved_type == 'paa'): ?>style="display: none;"<?php endif;?>>
					<th>
						<label for="aicc_bulkc_remove_validations"><?php _e('Desactivar validaciones', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Activar esta opción provocará que se agreguen los contenidos generados por OpenAI, sin tener en cuenta las validaciones internas del plugin. Estas validaciones de contenido que son esenciales para aseguar la calidad del texto. Te recomendamos activar esta opción solamente si tu objetivo es reescribir los contenidos por completo.', 'aicc'); ?></span></span>
					</th>
					<td>
						<input name="aicc_bulkc_remove_validations" id="aicc_bulkc_remove_validations" type="checkbox" value="1" <?php checked($saved_remove_validations, '1'); ?>>
					</td>
				</tr>


				<tr>
					<th>
						<label for="aicc_bulkc_budget"><?php _e('Presupuesto máximo', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Esta función te permite establecer un presupuesto máximo estimado para la curación masiva. La curación finalizará automáticamente una vez que se consuma el presupuesto especificado. Si estableces el presupuesto en 0, este será considerado ilimitado, permitiendo que la curación continúe hasta que decidas finalizarla manualmente.', 'aicc'); ?></span></span>
						</th>
					<td>
						<input style="width:60px"  name="aicc_bulkc_budget" id="aicc_bulkc_budget" type="number" value="<?php echo esc_attr($saved_budget); ?>" min="0" max="100"  step="1"/> <span> dólares</span>
					</td>
				</tr>

				<tr>
					<th>
						<label for="aicc_bulkc_include"><?php _e('Seleccionar contenidos', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Utiliza esta opción para seleccionar específicamente las publicaciones o páginas que desea curar en masa. Al activar esta funcionalidad, solo se seleccionarán los elementos seleccionados manualmente, excluyendo automáticamente cualquier otro contenido no marcado. Si no seleccionas ninguno, el proceso procesará todos los contenidos.', 'aicc'); ?></span></span>
					</th>
					<td>
						<input style="width:250px" name="aicc_bulkc_include" id="aicc_bulkc_include" type="text" value="<?php echo esc_attr($saved_include); ?>"/> 
					</td>
				</tr>

				<tr>
					<th>
						<label for="aicc_bulkc_exclude"><?php _e('Exclude content', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the posts or pages you want to exclude from mass content curation.', 'aicc'); ?></span></span>
					</th>
					<td>
						<input style="width:250px" name="aicc_bulkc_exclude" id="aicc_bulkc_exclude" type="text" value="<?php echo esc_attr($saved_exclude); ?>"/> 
					</td>
				</tr>

				<tr>
				    <th>
				        <label for="calcular-costo-btn"><?php _e('Calculate cost', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Find out the approximate cost of the cure. Please note that this value is an estimate and may vary based on OpenAI responses.', 'aicc'); ?></span></span>
				    </th>
				    <td style="display: flex;align-items: center; margin-top:6px">
				        <button id="calcular-costo-btn" class="button"><?php _e('Calculate', 'aicc'); ?></button>
				        <span class="spinner is-active" style="display:none;"></span>
				        <span id="resultado-costo" style="margin-left:10px"></span>
				    </td>
				</tr>

				<tr>
					<th>
						<input type="hidden" name="aicc_from" id="aicc_from" value="general-settings" />
						<div style="display:flex; align-items: center"><?php submit_button('Empezar'); ?><span class="spinner is-active" style="display:none;"></span></div>
					</th>
				</tr>
			</tbody>


		</table>

	</form>

	<script>

	jQuery(document).ready(function($) {

		var aiccAjustModel = "<?php echo $ajust_model; ?>";
		var aiccModel = "<?php echo $model; ?>";
		var aiccLink = '<?php echo esc_url( get_admin_url(null, 'admin.php?page=aicc') ); ?>';

		if (aiccModel == 'gpt-3.5-turbo-0125') {
			aiccModel = 'GPT 3.5 Turbo';
		} else if (aiccModel == 'gpt-4-1106-preview') {
			aiccModel = 'GPT 4 Turbo';
		} else if (aiccModel == 'gpt-4o') {
			aiccModel = 'GPT 4o';
		} else if (aiccModel == 'gpt-4o-mini') {
			aiccModel = 'GPT 4o mini';
		}

	    $('#aicc_bulkc_type').change(function() {
	        var selectedValue = $(this).val();
	        var message = '';
			var modelMessage = 'Actualmente estás usando ' + aiccModel + '.';
			var changeMessage = '<a href="' + aiccLink + '" target="_blank">Haz clic aquí para cambiar de modelo</a>.';

			$('#aicc_message').html('');

	        switch (selectedValue) {
	            case 'improve':
	           		if (aiccModel != 'GPT 4 Turbo' && aiccAjustModel !== '1') {
	                	message = 'El modelo recomendado para agregar keywords de oportunidad es GPT 4 Turbo. Este modelo garantiza la calidad de los contenidos generados.';
	                	$('#aicc_message').html(aiccAjustModel + message + ' ' + modelMessage + ' ' + changeMessage);
	            	}
	                break;
	            case 'regenerate':
	           		if (aiccModel != 'GPT 4o mini' && aiccAjustModel !== '1') {
	                	message = 'El modelo recomendado para regenerar los artículos es GPT 4o mini. Este modelo genera contenidos de mucha calidad al menor costo posible.';
	            		$('#aicc_message').html(message + ' ' + modelMessage + ' ' + changeMessage);	                
	            	}	            
	                break;
	            case 'paa':
	           		if (aiccModel != 'GPT 4o mini' && aiccAjustModel !== '1') {
	                	message = 'El modelo recomendado para agregar las preguntas relacionadas es GPT 4o mini. Este modelo genera contenidos de mucha calidad al menor costo posible.';
	            		$('#aicc_message').html(message + ' ' + modelMessage + ' ' + changeMessage);	                
	            	}	            
	                break;	                
	            default:
	                message = '';
	        }

	    });
	});

	jQuery(document).ready(function($) {

		$('.copy-to-clipboard').click(function() {
		    var $temp = $("<input>");
		    $("body").append($temp);
		    $temp.val($(this).attr('data-variable')).select();
		    document.execCommand("copy");
		    $temp.remove();

		    var dataVariable = $(this).attr('data-variable');
		    var textToShow;

		    if (dataVariable !== '{post_content}' && dataVariable !== '{post_title}' && dataVariable !== '{keywords}' && dataVariable !== '{keywords_incluidas}') {
		        textToShow = "Instrucción copiada";
		    } else {
		        textToShow = 'Variable copiada: ' + dataVariable;
		    }

		    Swal.fire({
		        text: textToShow,
		        icon: 'success',
		        confirmButtonText: 'Aceptar'
		    });
		});

		$('#aicc_bulkc_type').change(function() {
		    if ($(this).val() === 'custom') {
		        $('#bulkPromptRow').fadeIn(); 
		        $('#campo_include_headers').fadeOut(); 
		        $('#remove_validations').fadeIn(); 
		        $('#campo_number').fadeIn(); 
		        $('#campo_sort_by').fadeIn();        
		        $('#campo_encabezados').fadeOut();  
		        $('#include_already').fadeIn();
		    } else if ($(this).val() === 'improve')  {
		        $('#bulkPromptRow').fadeOut(); 
		        $('#campo_include_headers').fadeIn(); 
		        $('#remove_validations').fadeIn(); 
		        $('#campo_number').fadeIn(); 
		        $('#campo_sort_by').fadeIn();         
		        $('#campo_encabezados').fadeOut();
		        $('#include_already').fadeIn();
		    } else if ($(this).val() === 'regenerate') {
		        $('#bulkPromptRow').fadeOut(); 
		        $('#campo_include_headers').fadeOut(); 
		        $('#remove_validations').fadeOut(); 
		        $('#campo_number').fadeIn(); 
		        $('#campo_sort_by').fadeIn();     
		        $('#campo_encabezados').fadeOut();                         
		    } else if ($(this).val() === 'paa') {
		        $('#bulkPromptRow').fadeOut(); 
		        $('#campo_include_headers').fadeOut(); 
		        $('#remove_validations').fadeOut(); 
		        $('#campo_number').fadeOut(); 
		        $('#campo_sort_by').fadeOut(); 
		        $('#campo_encabezados').fadeIn(); 
		        $('#include_already').fadeOut();                       
		    }
		});


		var allSuggestions = {
		    <?php
		    $post_types = get_post_types(array('public' => true), 'names');
		    $excluded_post_types = array('attachment', 'product');
		    $post_types = array_diff($post_types, $excluded_post_types);

		    foreach ($post_types as $post_type) {
		        echo "'$post_type': [";

		        $args = array('post_type' => $post_type, 'posts_per_page' => -1);
		        $posts = get_posts($args);
		        foreach ($posts as $post) {

		            $title = addslashes($post->post_title);
	    			$special_chars = array(".", "-", "'", "'", "\"", "\n", "\r", "\t", "&", "<", ">");
				    $title = str_replace($special_chars, " ", $title);	            
		            echo "{tag: '$title', value: '{$post->ID}'},";
		        }

		        echo "],";
		    }
		    ?>
		};

		jQuery(document).ready(function($) {
		    // Función para inicializar/reinicializar Amsify Suggestags
		    function initializeSuggestags(postType, inputName) {
		        var suggestionsElement = $('input[name="' + inputName + '"]');
		        
		        // Asegurarse de destruir la instancia anterior si existe
		        if (suggestionsElement.data('amsifySuggestags')) {
		            suggestionsElement.suggestags('destroy');
		        }
		        
		        // Filtrar sugerencias basadas en el tipo de publicación seleccionado
		        var filteredSuggestions = allSuggestions[postType] || [];
		        
		        // Inicializar Amsify Suggestags con las nuevas sugerencias
		        suggestionsElement.amsifySuggestags({
		            showAllSuggestions: true,
		            keepLastOnHoverTag: false,
		            suggestions: filteredSuggestions,
		            whiteList: true
		        });
		    }

		    // Escuchar cambios en el selector de tipo de publicación
		    $('#aicc_bulkc_post_type').change(function() {
		        var selectedPostType = $(this).val();
		        // Inicializar para ambos campos de entrada
		        initializeSuggestags(selectedPostType, "aicc_bulkc_include");
		        initializeSuggestags(selectedPostType, "aicc_bulkc_exclude");
		    });

		    // Inicializar Amsify Suggestags con el tipo de publicación inicial para ambos campos
		    var initialPostType = $('#aicc_bulkc_post_type').val();
		    initializeSuggestags(initialPostType, "aicc_bulkc_include");
		    initializeSuggestags(initialPostType, "aicc_bulkc_exclude");
		});


		$('#calcular-costo-btn').click(function(e) {
			e.preventDefault();
			var postType = $('#aicc_bulkc_post_type').val();
		    var include = jQuery('#aicc_bulkc_include').val();
		    var excludeAlready = jQuery('#aicc_bulkc_exclude_already').prop('checked') ? '1' : '0';
		    var intraType = jQuery('#aicc_bulkc_type').val();


			$('#resultado-costo').html('');

			var spinner = $(this).next('.spinner'); 
							
			spinner.css({
			'float': 'none',          
			'margin-top': '5px',     
			'margin-left': '10px'    
			});
							
			spinner.show();

			$.ajax({
			url: ajaxurl,
			type: 'POST',
			data: {
				action: 'aicc_return_total_cost',
				postType: postType,
				getDataGsc: '',
				include: include,
				excludeAlready: excludeAlready,
				type: 'content',
				intraType: intraType
			},
			success: function(response) {
				spinner.hide();
				$('#resultado-costo').html('Costo estimado: $' + response);
			},
			error: function() {
				$('#resultado-costo').html('Error al calcular el costo.');
			}
			});

		});


		$('#cancel-bulk-process').click(function(e) {
		    e.preventDefault();
		    var spinner = $(this).next('.spinner');

		    // SweetAlert para confirmar la cancelación
		    Swal.fire({
		        text: "¿Estás seguro de que quieres cancelar el proceso en curso?",
		        icon: 'warning',
		        showCancelButton: true,
		        confirmButtonText: 'Sí, cancelar',
		        cancelButtonText: 'No, continuar'
		    }).then((result) => {
		        if (result.value) {
		            $.ajax({
		                url: ajaxurl,
		                type: 'POST',
		                data: {
		                    action: 'aicc_cancel_bulk_process'
		                },
		                success: function(response) {
		                    Swal.fire({
		                        icon: 'success',
		                        text: 'El proceso se está cancelando',
		                        confirmButtonText: 'Aceptar'
		                    }).then((result) => {
		                        if (result.isConfirmed) {
		                            location.reload();
		                        }
		                    });
		                },
		                error: function() {
		                    // Manejar el error adecuadamente
		                    Swal.fire({
		                        icon: 'error',
		                        text: 'Hubo un error al cancelar el proceso',
		                        confirmButtonText: 'Aceptar'
		                    });
		                }
		            });
		        } else {
		            // Usuario canceló la cancelación
		            Swal.fire({
		                icon: 'success',
		                text: 'El proceso sigue su curso',
		                confirmButtonText: 'Aceptar'
		            });
		        }
		    });
		});

	    function checkBulkRunning(callback) {
	      jQuery.ajax({
	        url: ajaxurl,
	        type: "POST",
	        data: {
	          action: "aicc_check_bulk_running"
	        },
	        dataType: "json",
	        success: function (response) {
	          if (response.check_status === 'processing' || response.check_status === 'missing') {
	            Swal.fire({
	              icon: 'error',
	              text: response.message,
	              confirmButtonText: 'Aceptar'
	            });
	            callback(false);
	            spinner.hide();
	          } else {
	            callback(true);
	          }
	        },
	        error: function (xhr, status, error) {
	          alert("Error: " + error);
	          callback(false);
	        }
	      });
	    }

	    $("#form-bulk-content").off("click", "#submit").on("click", "#submit", function(e) {
		   
		    e.preventDefault();

			// Verificar si la opción de OpenAI está configurada
		    var openaiKey = '<?php echo esc_js(get_option('aicc_options_openai')); ?>';
		    if (!openaiKey) {
		        Swal.fire({
		            icon: 'warning',
		            text: 'Para continuar, es necesario ingresar tu clave API de OpenAI en las opciones del plugin.',
		            confirmButtonText: 'Aceptar'
		        });
		        return; 
		    }

		    // Verifica si 'Incluir datos de Search Console' está activada y la configuración relevante está completa
		    if ($('#aicc_bulkc_type').val() === 'improve' || $('#aicc_bulkc_type').val() === 'regenerate') {
		        var aiccOptionsSC = '<?php echo esc_js(get_option('aicc_options_sc')); ?>';
		        if (!aiccOptionsSC) {
		            Swal.fire({
		                icon: 'error',
		                text: 'Para incluir datos de Search Console, es necesario ingresar tu clave API de Search Console en las opciones del plugin.',
		                confirmButtonText: 'Aceptar'
		            });
		            return; 
		        }
		    }

		    // Verifica si 'Get data from Search Console' está desactivado
		    if ($('#aicc_bulkc_type').val() === 'custom' && $('#aicc_bulkc_prompt').val().trim() === '') {
		        // Verifica si el checkbox 'Customize prompt' está marcado y el área de texto no está vacía
		            Swal.fire({
		                icon: 'error',
		                text: 'Para iniciar una curación de contenidos con una instrucción personalizada es necesario indicar un prompt.',
		                confirmButtonText: 'Aceptar'
		            });
		            return;
		    }

	   		// Verifica si está creado el transient con datos de Search Console
		    if ($('#aicc_bulkc_type').val() === 'improve' || $('#aicc_bulkc_type').val() === 'regenerate' || $('#aicc_bulkc_type').val() === 'custom') {
	            <?php $aiccTransientSCExists = !empty(get_transient("aicc_data_sc_cache")); ?>
	            var aiccTransientSCExists = <?php echo json_encode($aiccTransientSCExists); ?>;
	            var adminLink = '<?php echo esc_url(admin_url('admin.php?page=aicc')); ?>';
	            if (!aiccTransientSCExists) {
	                Swal.fire({
	                    icon: 'error',
	                    html: 'Parece que los datos de Search Console expiraron...<br><br>Antes de ejecutar una curación masiva, es necesario que borres la caché del plugin para cargar los nuevos datos actualizados y luego recargues esta página.<br><br><a target="_blank" href="' + adminLink + '">Ir a la configuración del plugin</a>',
	                    confirmButtonText: 'Aceptar'
	                });
	                return;
	            }
		    }    

			// Verifica si 'Incluir datos de Search Console' está activada y la configuración relevante está completa
			if ($('#aicc_bulkc_type').val() === 'paa') {
			    var aiccApiValueSerp = '<?php echo esc_js(get_option('aicc_options_valueserp')); ?>';			    
			    if (!aiccApiValueSerp) {
			        Swal.fire({
			            icon: 'error',
			            text: 'Debes ingresar tu clave API de ValueSerp en las opciones del plugin.',
			            confirmButtonText: 'Aceptar'
			        });
			        return;
			    }

			} 

			var spinner = $(this).parent().next('.spinner');
								
			spinner.css({
				'float': 'none',          
				'margin-top': '10px',     
				'margin-left': '10px'    
			});
								
			spinner.show();

	    	checkBulkRunning(function (canContinue) {
		        if (canContinue) {
		        	var bulkType = $('#aicc_bulkc_type').val();
			        var promptContent = jQuery('#aicc_bulkc_prompt').val();
			        var confirmationText = "¿Deseas empezar la curación masiva de contenidos?";
			        var removeValidations = jQuery('#aicc_bulkc_remove_validations').prop('checked');

			        if (bulkType == 'custom' && promptContent) {
			            if (!promptContent.includes('{post_content}')) {
			                confirmationText = "No has incluido la variable {post_content} en tu prompt personalizado.<br><br>Esta variable es crucial ya que representa el contenido actual del artículo que se va a curar.<br><br>¿Estás seguro de iniciar la curación sin incluir el contenido del artículo en la curación?";
			            }
			            if (!promptContent.includes('{keywords}')) {
			                confirmationText = "No has incluido la variable {keywords} en tu prompt personalizado.<br><br>¿Estás seguro de iniciar la curación sin incorporar las keywords específicas de cada artículo?";
			            }
			        }else if(bulkType == 'custom' && !promptContent) {
			           	confirmationText = "Has activado la opción para personalizar el prompt, pero no hemos detectado un prompt personalizado.<br><br>¿Deseas iniciar la curación utilizando nuestro prompt por defecto?";
			        }else if (removeValidations) {
			           	confirmationText = "Has seleccionado la opción de desactivar validaciones.<br><br>Esta opción provocará que se agreguen los contenidos generados por OpenAI, sin tener en cuenta las validaciones internas del plugin, que son esenciales para aseguar la calidad del texto.<br><br>Te recomendamos activar esta opción solamente si tu objetivo es reescribir los contenidos por completo.<br><br>¿Estas seguro de continuar sin las validaciones?";
			     	}

		          Swal.fire({
	            	html: confirmationText,
		            icon: 'warning',
		            showCancelButton: true,
		            confirmButtonText: 'Empezar',
		            cancelButtonText: 'Cancelar'
		          }).then((result) => {
		            if (result.value) {
		              var nonce = '<?php echo esc_js(wp_create_nonce("aicc_process_bulkc_content")); ?>';
		              var postType = jQuery('#aicc_bulkc_post_type').val();
		              var numKeywords = jQuery('#aicc_bulkc_number').val();
		              var sortBy = jQuery('#aicc_bulkc_sort_by').val();
		              var includeHeaders = jQuery('#aicc_bulkc_include_headers').prop('checked') ? '1' : '0';
		              var prompt = jQuery('#aicc_bulkc_prompt').val();
		              var budget = jQuery('#aicc_bulkc_budget').val();
		              var include = jQuery('#aicc_bulkc_include').val();
		              var exclude = jQuery('#aicc_bulkc_exclude').val();
		              var excludeAlready = jQuery('#aicc_bulkc_exclude_already').prop('checked') ? '1' : '0';
		              var removeValidations = jQuery('#aicc_bulkc_remove_validations').prop('checked') ? '1' : '0';
			          var type = jQuery('#aicc_bulkc_type').val();

		              jQuery.ajax({
		                url: ajaxurl,
		                type: "POST",
		                data: {
		                  action: "aicc_process_bulkc_content",
		                  aicc_bulkc_post_type: postType,
		                  aicc_bulkc_number: numKeywords,
		                  aicc_bulkc_sort_by: sortBy,
		                  aicc_bulkc_include_headers: includeHeaders,
		                  aicc_bulkc_prompt: prompt,
		                  aicc_bulkc_budget: budget,
		                  aicc_bulkc_include: include,
		                  aicc_bulkc_exclude: exclude,
		                  aicc_bulkc_exclude_already: excludeAlready,
		                  aicc_bulkc_remove_validations: removeValidations,
		                  aicc_bulkc_type: type,
		                  nonce: nonce
		                },
		                success: function (response) {
		                  console.log(response);
		                  Swal.fire({
		                    icon: 'success',
		                    text: '¡La curación masiva ha iniciado!',
		                    confirmButtonText: 'Aceptar'
		                  }).then((result) => {
		                  	spinner.hide();
		                    if (result.value) {
		                      location.reload();
		                    }
		                  });
		                },
		                error: function (xhr, status, error) {
		                  alert("Error: " + error);
		                }
		              });
		            } else {
						spinner.hide();
		            }
		          });
		        }
		        else
		        {
		        	spinner.hide();
		        }
		   	});
	    });
	 });

	</script>


	<?php else: ?>

	<div class="notice notice-warning inline active-plugin-edit-warning" style="margin:10px !important;"><p>Parece que no tienes los permisos suficientes para ver esta página.</p></div>

	<?php endif; ?>