<?php if ( current_user_can('manage_options') ) : ?>

<style>
	#calcular-costo-btn {
		color: #f1556c;
		border-color: #f1556c;
	    background: #fdeef0;
		vertical-align: top;	
		display: inline-block;
	    text-decoration: none;
	    font-size: 13px;
	    line-height: 2.15384615;
	    min-height: 30px;
	    margin: 0;
	    padding: 0 10px;
	    cursor: pointer;
	    border-width: 1px;
	    border-style: solid;
	    -webkit-appearance: none;
	    border-radius: 3px;
	    white-space: nowrap;
	    box-sizing: border-box;
	}
	
	#calcular-costo-btn:hover {
		background:#f7e7ff;
		border-color:#f1556c;
	}
	
	#calcular-costo-btn:active {
		border-color:#d174ff
	}
	
	span.aicc-status.green {
		color:#00a320 !important;
		font-weight:bold;
	}
	
	span.aicc-status.red {
		color:#e65054 !important;
		font-weight:bold;
	}
	
	#cancel-bulk-process {
		cursor: pointer;
		text-decoration: underline;
	}

	#cancel-bulk-process:hover {
		text-decoration: none;
	}

	#bulkPromptRow p,
	#bulkPromptRow li {
		font-size: 13px;
		color: #767676;
	}

	#bulkPromptRow ul {
		margin-top: 12px;
		margin-left: 16px;
		list-style: disc;
	}

	#bulkPromptRow code {
		cursor: pointer;
	}
	#bulkPromptRow code:hover {
		background: rgba(0,0,0,.1) !important;
	}
	.aicc-tooltip-a { cursor:pointer; }

	.aicc-options h2 {
	    display: flex;
	    align-items: center;
	}

	.aicc-options h2 span {
	    background: #202225;
	    color: #fff;
	    margin-left: 6px;
	}

	tr th i {
		display: inline-block;
	    vertical-align: top;
	    box-sizing: border-box;
	    margin: 1px 0 0 6px;
	    padding: 0 5px;
	    min-width: 18px;
	    height: 18px;
	    border-radius: 3px;
	    background-color: #f1556c;
	    color: #fff;
	    font-size: 11px;
	    line-height: 1.715;
	    text-align: center;
	    font-style: normal;
	}

</style>
<?php

global $wpdb;

$status = '';

$is_error = get_transient('aicc_error_bulk');

if ( $is_error ) {
	$admin_link = admin_url('admin.php?page=aicc-log');
	echo '<div class="notice notice-error is-dismissible"><p><strong>Se produjo un error</strong>. Revisa el registro de depuración del plugin para identificar la causa del problema o contacta con nuestro equipo de soporte. <a target="_blank" href="' . esc_url($admin_link) . '">Ir al registro de depuración</a></p></div>';
	delete_transient('aicc_error_bulk');
	$success_message = 'La curación en bulk terminó.';	
}
else
{
	$success_message = 'La curación en bulk se completó con éxito.';
}

$is_run = get_transient('aicc_is_bulk_running');

$is_end = get_transient('aicc_end_bulk');

$is_cancel = $wpdb->get_var("SELECT option_value FROM $wpdb->options WHERE option_name = 'aicc_cancel_bulk_process' LIMIT 1");

$is_cancel = $is_cancel === '1';

$discarded = get_option('aicc_bulk_discarded_count');
if ($discarded === false || !$discarded ) {
	$discarded = 0;
}

if ($is_cancel) {
    $status = 'cancel';
} elseif ($is_run) {
    $status = 'run';
} elseif ($is_end) {
    $status = 'end';
} else {
    $status = '';
}

if ($status == 'cancel') {
echo '<div class="notice notice-warning is-dismissible"><p>' . __('El proceso de cancelación está en curso. Por favor, ten paciencia, este proceso puede tardar unos minutos.', "aicc") . '</p></div>';
	delete_option('aicc_bulk_total_posts');
	delete_option('aicc_bulk_processed_count');
} elseif ($status == 'run') {
    $total_posts = get_option('aicc_bulk_total_posts');
	$processed_count = get_option('aicc_bulk_processed_count');	
	if ($processed_count === false || !$processed_count ) {
	    $processed_count = 0;
	}		
	$currentBulkProcessId = get_transient('aicc_current_bulk_process_id');
	if (false === $currentBulkProcessId) {
	    $currentBulkProcessId = '';
	}
	$resultado = null;
	$type = '';
	$type_ed = '';	
	if (false !== $currentBulkProcessId && $currentBulkProcessId > 0) {	
	    $sql = $wpdb->prepare("SELECT type FROM " . AICC_BULK_TABLE . " WHERE id = %d", $currentBulkProcessId);
	    $resultado = $wpdb->get_row($sql);
	    if ($resultado){
	    	$type = $resultado->type;
	    }
	}
    if ($type == 'Contenido') {
    	$type_ed = 'contenidos';
    }elseif ($type == 'Imagen'){
    	$type_ed = 'imágenes';
    }elseif ($type == 'Metaetiqueta'){
    	$type_ed = 'metaetiquetas';
    }
	$message = '<strong>Curación de '.$type_ed.' en proceso</strong>';
	if ($type == 'Imagen') {
		$message .= ' · Procesados <strong>' . $processed_count . '</strong> de <strong>' . $total_posts  . '</strong>';
		if($discarded){
			$message .= ' · ' . $discarded . ' descartados';
		}
		$message .=  ' · <span id="cancel-bulk-process">Cancelar proceso</span>';
	}

	echo '<div class="notice notice-success is-dismissible"><p>'.$message.'</p></div>';
} elseif ($status == 'end') {
	delete_transient('aicc_end_bulk');		
	echo '<div class="notice notice-success is-dismissible"><p><strong>'.__($success_message, "aicc").'</strong></p></div>';
}

$option_bulki_set_prompt = get_option('aicc_bulki_set_prompt', false);
$option_bulki_prompt = get_option('aicc_bulki_prompt', '');
$option_bulki_budget = get_option('aicc_bulki_budget', '');

?>
<form method="post" id="form-bulk-content">

<?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

<table class="form-table" id="aicc-fieldset-one">

		<h2><?php _e('Image Bulk Curation', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('En esta sección puedes añadir imágenes destacadas o imágenes dentro del contenido a todos tus artículos de forma masiva.', 'aicc'); ?></span></span></h2>

		<tbody>
		    <?php
		        $post_types = get_post_types(array('public' => true), 'names');
		        $excluded_post_types = array('attachment', 'product'); // Se añadió 'product' aquí
		        $post_types = array_diff($post_types, $excluded_post_types);

				// Recuperar las opciones guardadas o establecer valores predeterminados
				$saved_post_type = get_option('aicc_bulki_post_type', 'post');
				$saved_type = get_option('aicc_bulki_type', 'featured');
				$saved_excludeNoPublish = get_option('aicc_bulki_excludeNoPublish', '0');
				$saved_set_prompt = get_option('aicc_bulki_set_prompt', '0');
				$saved_prompt = get_option('aicc_bulki_prompt', '');
				$saved_budget = get_option('aicc_bulki_budget', 0);
				$saved_include = get_option('aicc_bulki_include', '');
				$saved_exclude = get_option('aicc_bulki_exclude', '');
				$saved_quality = get_option('aicc_bulki_quality', 'standard');
				$saved_resolution = get_option('aicc_bulki_resolution', '1792x1024');
				$saved_source = get_option('aicc_bulki_source', 'ia');		        
				$saved_motor = get_option('aicc_bulki_motor', 'openai');		        
				$saved_aspect_ratio = get_option('aicc_bulki_aspect_ratio', '16:9');
				$saved_replace = get_option('aicc_bulki_replace', '');
		    ?>
		    <tr>
		        <th>
		            <label for="aicc_bulki_post_type"><?php _e('Run on', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the type of content where bulk curation will run.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		           <select name="aicc_bulki_post_type" id="aicc_bulki_post_type">
		            <?php foreach ($post_types as $post_type): ?>
		                <?php 
		                    $post_type_object = get_post_type_object($post_type);
		                    $post_type_label = $post_type_object->labels->singular_name;
		                ?>
		                <option value="<?php echo $post_type; ?>" <?php selected($saved_post_type, $post_type); ?>><?php echo $post_type_label; ?></option>
		            <?php endforeach; ?>
		            </select>
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulki_type"><?php _e('Tipo de curación', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Elige si quieres generar imágenes destacadas para los artículos que no tengan, o agregar imágenes dentro de los artículos que no tengan.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		           <select name="aicc_bulki_type" id="aicc_bulki_type">
		                <option value="featured" <?php selected($saved_type, 'featured'); ?>><?php _e('Generar imágenes destacadas', 'aicc'); ?></option>
		                <option value="into" <?php selected($saved_type, 'into'); ?>><?php _e('Agregar imágenes dentro', 'aicc'); ?></option>
		            </select>
		        </td>
		    </tr>  

		    <tr>
		        <th>
		            <label for="aicc_bulki_source"><?php _e('Fuente imágenes', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Selecciona si quieres generar la imagen con IA usando Dall-e u obtenerlas de bancos de imágenes gratuitos.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		           <select name="aicc_bulki_source" id="aicc_bulki_source">
		                <option value="ia" <?php selected($saved_source, 'ia'); ?> <?php if ($saved_type != 'featured'): ?>style="display: none;"<?php endif;?>><?php _e('Generar con IA', 'aicc'); ?></option>
		                <option value="pexels" <?php selected($saved_source, 'pexels'); ?>><?php _e('Obtener de Pexels', 'aicc'); ?></option>
		                <option value="pixabay" <?php selected($saved_source, 'pixabay'); ?>><?php _e('Obtener de Pixabay', 'aicc'); ?></option>
		            </select>
		        </td>
		    </tr>  

		    <tr <?php if ($saved_type != 'featured'): ?>style="display: none;"<?php endif;?> >
		        <th>
					<label for="aicc_bulki_motor"><?php _e('Motor de generación', 'aicc'); ?><i>Nuevo</i></label>
					<span class="aicc-tooltip">?
					  <span class="tooltiptext">
					    <?php _e('Selecciona qué servicio se utilizará para generar las imágenes con inteligencia artificial: OpenAI (DALL·E) o Replicate.', 'aicc'); ?>
					  </span>
					</span>
		        </th>
		        <td>
		           <select name="aicc_bulki_motor" id="aicc_bulki_motor">
		                <option value="openai" <?php selected($saved_motor, 'openai'); ?>><?php _e('OpenAI (DALL·E)', 'aicc'); ?></option>
		                <option value="replicate" <?php selected($saved_motor, 'replicate'); ?>><?php _e('Replicate', 'aicc'); ?></option>
		            </select>
		           <div id="cost-message">
			          <?php if ($saved_motor == 'openai') { ?>
			          <span style="display:block;margin-top: 8px; font-style: italic;">La generación con OpenAI tiene un costo de <strong>0.08$</strong> por imagen.</span>
			          <?php } else { ?>
			          <span style="display:block;margin-top: 8px; font-style: italic;">La generación con Replicate tiene un costo de <strong>0.003$</strong> por imagen.</span>
			          <?php } ?>
			        </div>
		        </td>
		    </tr>  		    

		    <tr id="row-image-quality" <?php if ($saved_type != 'featured' || $saved_motor != 'openai'): ?>style="display: none;"<?php endif;?>>
		        <th>
		            <label for="aicc_bulki_image_quality"><?php _e('Image Quality', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Choose the quality in which you want the images to be created.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		           <select name="aicc_bulki_image_quality" id="aicc_bulki_image_quality">
		                <option value="standard" <?php selected($saved_quality, 'standard'); ?>>Standard</option>
		                <option value="hd" <?php selected($saved_quality, 'hd'); ?>>HD</option>
		            </select>
		        </td>
		    </tr>    

		    <tr id="row-image-resolution" <?php if ($saved_type != 'featured' || $saved_motor != 'openai'): ?>style="display: none;"<?php endif;?>>
		        <th>
		            <label for="aicc_bulki_image_resolution"><?php _e('Image Resolution', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Choose the resolution in which you want the images to be created.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		           <select name="aicc_bulki_image_resolution" id="aicc_bulki_image_resolution">
		                <option value="1792x1024" <?php selected($saved_resolution, '1792x1024'); ?>>1792x1024 (Apaisado)</option>
		                <option value="1024x1792" <?php selected($saved_resolution, '1024x1792'); ?>>1024x1792 (Vertical)</option>
		                <option value="1024x1024" <?php selected($saved_resolution, '1024x1024'); ?>>1024x1024 (Cuadrado)</option>
		            </select>
		        </td>
		    </tr> 


		    <tr id="row-aspect-ratio" <?php if ($saved_type != 'featured' || $saved_motor == 'openai'): ?>style="display: none;"<?php endif;?>>
			    <th>
			        <label for="aicc_bulki_aspect_ratio"><?php _e('Aspect ratio', 'aicc'); ?><i>Nuevo</i></label>
			        <span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Selecciona el aspect ratio de la imagen para Replicate.', 'aicc'); ?></span></span>
			    </th>
			    <td>
			       <select name="aicc_bulki_aspect_ratio" id="aicc_bulki_aspect_ratio">
						<option value="16:9" <?php selected($saved_aspect_ratio, '16:9'); ?>>16:9 (Apaisado)</option>
						<option value="9:16" <?php selected($saved_aspect_ratio, '9:16'); ?>>9:16 (Vertical)</option>
						<option value="1:1" <?php selected($saved_aspect_ratio, '1:1'); ?>>1:1 (Cuadrado)</option>
			        </select>
			    </td>
			</tr>		    


		    <tr <?php if ($saved_type != 'featured'): ?>style="display: none;"<?php endif;?>>
		        <th>
		            <label for="aicc_bulki_replace"><?php _e('Reemplazar existentes', 'aicc'); ?><i>Nuevo</i></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Si activas esta opción, también se reemplazarán las imágenes destacadas ya existentes por nuevas generadas. Si no la activás, solo se agregarán imágenes a los contenidos que no tengan ninguna.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input name="aicc_bulki_replace" id="aicc_bulki_replace" type="checkbox" value="1" <?php checked($saved_replace, '1'); ?>>
		        </td>
		    </tr>  

		    <tr>
		        <th>
		            <label for="aicc_bulki_exclude_no_publish"><?php _e('Exclude unpublished', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('By activating this option, only content that is in published status will be selected. Otherwise, those contents that are in draft status, pending review and scheduled will also be included.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input name="aicc_bulki_exclude_no_publish" id="aicc_bulki_exclude_no_publish" type="checkbox" value="1" <?php checked($saved_excludeNoPublish, '1'); ?>>
		        </td>
		    </tr>  

		    <tr>
		        <th>
		            <label for="aicc_bulki_set_prompt"><?php _e('Customize prompt', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Enable this option to add a specific prompt for mass healing.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input name="aicc_bulki_set_prompt" id="aicc_bulki_set_prompt" type="checkbox" value="1" <?php checked($saved_set_prompt, '1'); ?>>
		        </td>
		    </tr>  

		    <tr id="bulkPromptRow" <?php if (!$saved_prompt): ?>style="display: none;"<?php endif;?>>
		        <th>
		            <label for="aicc_bulki_prompt"><?php _e('Bulk Prompt', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Design a specific prompt for mass healing. Use the variable {keyword} to indicate the keywords that should be incorporated.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <textarea name="aicc_bulki_prompt" id="aicc_bulki_prompt" rows="8" cols="50" placeholder="Quiero que generes una imagen que sea realista y llamativa sobre: {post_title}"><?php echo $saved_prompt ? esc_textarea($saved_prompt) : ''; ?></textarea>
		            <p>Te recomendamos usar esta opción avanzada únicamente si tienes experiencia creando prompts personalizados. Las variables disponibles son:</p>
		            <ul>
		                <li><span class="copy-to-clipboard" data-variable="{post_title}" title="Copiar"><code>{post_title}</code></span> es el título del artículo</li>
		                <li><span class="copy-to-clipboard" data-variable="{post_content}" title="Copiar"><code>{post_content}</code></span> es el contenido actual del artículo</li>
		            </ul>
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulki_budget"><?php _e('Presupuesto máximo', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Esta función te permite establecer un presupuesto máximo estimado para la curación masiva. La curación finalizará automáticamente una vez que se consuma el presupuesto especificado. Si estableces el presupuesto en 0, este será considerado ilimitado, permitiendo que la curación continúe hasta que decidas finalizarla manualmente.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input style="width:60px" step="1" name="aicc_bulki_budget" id="aicc_bulki_budget" type="number" value="<?php echo $saved_budget; ?>" min="0" max="100"/> <span> dólares</span>
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulki_include"><?php _e('Seleccionar contenidos', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Utiliza esta opción para seleccionar específicamente las publicaciones o páginas que desea curar en masa. Al activar esta funcionalidad, solo se seleccionarán los elementos seleccionados manualmente, excluyendo automáticamente cualquier otro contenido no marcado. Si no seleccionas ninguno, el proceso procesará todos los contenidos.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input style="width:250px" name="aicc_bulki_include" id="aicc_bulki_include" type="text" value="<?php echo esc_attr($saved_include); ?>"/> 
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulki_exclude"><?php _e('Exclude content', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the posts or pages you want to exclude from mass content curation.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input style="width:250px" name="aicc_bulki_exclude" id="aicc_bulki_exclude" type="text" value="<?php echo esc_attr($saved_exclude); ?>"/> 
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="calcular-costo-btn"><?php _e('Calculate cost', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Find out the approximate cost of the cure. Please note that this value is an estimate and may vary based on OpenAI responses.', 'aicc'); ?></span></span>
		        </th>
		        <td style="display: flex;align-items: center; margin-top:6px">
		            <button id="calcular-costo-btn" class="button"><?php _e('Calculate', 'aicc'); ?></button>
		            <span class="spinner is-active" style="display:none;"></span>
		            <span id="resultado-costo" style="margin-left:10px"></span>
		        </td>
		    </tr>   

		    <tr>
		        <th>
		            <input type="hidden" name="aicc_from" id="aicc_from" value="general-settings" />
		            <div style="display:flex; align-items: center"><?php submit_button('Empezar'); ?><span class="spinner is-active" style="display:none;"></span></div>
		        </th>
		    </tr>
		</tbody>


	</table>

</form>

<script>

	jQuery(document).ready(function($) {

		$('#aicc_bulki_type').change(function() {
	        if ($(this).val() === 'into') {
	            $('#aicc_bulki_source option[value="ia"]').fadeOut();
	            $('#aicc_bulki_source').val('pexels');
	            $('#aicc_bulki_image_quality').closest('tr').fadeOut();
	            $('#aicc_bulki_image_resolution').closest('tr').fadeOut();
	            $('#aicc_bulki_set_prompt').closest('tr').fadeOut();
	            $('#aicc_bulki_motor').closest('tr').fadeOut();	            
	        } else {
	            $('#aicc_bulki_source option[value="ia"]').fadeIn();
	            $('#aicc_bulki_source').val('ia');
	            $('#aicc_bulki_image_quality').closest('tr').fadeIn();
	            $('#aicc_bulki_image_resolution').closest('tr').fadeIn();
	            $('#aicc_bulki_set_prompt').closest('tr').fadeIn();	     
	            $('#aicc_bulki_motor').closest('tr').fadeIn();	            
	        }
	    });


		$('#aicc_bulki_source').change(function() {
	        if ($(this).val() !== 'ia') {
	            $('#aicc_bulki_image_quality').closest('tr').fadeOut();
	            $('#aicc_bulki_image_resolution').closest('tr').fadeOut();
	            $('#aicc_bulki_motor').closest('tr').fadeOut();	       
	            $('#row-aspect-ratio').fadeOut();     
	            $('#aicc_bulki_replace').closest('tr').fadeOut();	       
	        } else {
	            $('#aicc_bulki_image_quality').closest('tr').fadeIn();
	            $('#aicc_bulki_image_resolution').closest('tr').fadeIn();
	            $('#aicc_bulki_motor').closest('tr').fadeIn();	 
	            $('#row-aspect-ratio').fadeIn();    
	            $('#aicc_bulki_replace').closest('tr').fadeIn();	       	                   
	        }
	    });

	  	$('#aicc_bulki_motor').change(function() {
	        var motor = $(this).val();
	        if (motor === 'openai') {
	            // Mostrar los campos para OpenAI
	            $('#row-image-quality').fadeIn();
	            $('#row-image-resolution').fadeIn();
	            // Ocultar el campo de Aspect Ratio para Replicate
	            $('#row-aspect-ratio').fadeOut();
	        } else if (motor === 'replicate') {
	            // Ocultar los campos para OpenAI
	            $('#row-image-quality').fadeOut();
	            $('#row-image-resolution').fadeOut();
	            // Mostrar el campo de Aspect Ratio
	            $('#row-aspect-ratio').fadeIn();
	        }
	    });

		 $('.copy-to-clipboard').click(function() {
	        var $temp = $("<input>");
	        $("body").append($temp);
	        $temp.val($(this).attr('data-variable')).select();
	        document.execCommand("copy");
	        $temp.remove();

	        // Usando SweetAlert para la notificación
	        Swal.fire({
	            text: 'Variable copiada: ' + $(this).attr('data-variable'),
	            icon: 'success',
	            confirmButtonText: 'Aceptar'
	        });
	    });

		var allSuggestions = {
		    <?php
		    $post_types = get_post_types(array('public' => true), 'names');
		    $excluded_post_types = array('attachment', 'product');
		    $post_types = array_diff($post_types, $excluded_post_types);

		    foreach ($post_types as $post_type) {
		        echo "'$post_type': [";

		        $args = array('post_type' => $post_type, 'posts_per_page' => -1);
		        $posts = get_posts($args);
		        foreach ($posts as $post) {

		            $title = addslashes($post->post_title);
	    			$special_chars = array(".", "-", "'", "'", "\"", "\n", "\r", "\t", "&", "<", ">");
				    $title = str_replace($special_chars, " ", $title);	            
		            echo "{tag: '$title', value: '{$post->ID}'},";
		        }

		        echo "],";
		    }
		    ?>
		};

		jQuery(document).ready(function($) {
		  $('#aicc_bulki_motor').on('change', function() {
		    var selectedValue = $(this).val();
		    var newHTML = '';

		    if (selectedValue === 'openai') {
		      newHTML = '<span style="display:block;margin-top: 8px; font-style: italic;">La generación con OpenAI tiene un costo de <strong>0.08$</strong> por imagen.</span>';
		    } else if (selectedValue === 'replicate') {
		      newHTML = '<span style="display:block;margin-top: 8px; font-style: italic;">La generación con Replicate tiene un costo de <strong>0.003$</strong> por imagen.</span>';
		    }
		    
		    $('#cost-message').html(newHTML);
		  });
		});


		jQuery(document).ready(function($) {
		    // Función para inicializar/reinicializar Amsify Suggestags
		    function initializeSuggestags(postType, inputName) {
		        var suggestionsElement = $('input[name="' + inputName + '"]');
		        
		        // Asegurarse de destruir la instancia anterior si existe
		        if (suggestionsElement.data('amsifySuggestags')) {
		            suggestionsElement.suggestags('destroy');
		        }
		        
		        // Filtrar sugerencias basadas en el tipo de publicación seleccionado
		        var filteredSuggestions = allSuggestions[postType] || [];
		        
		        // Inicializar Amsify Suggestags con las nuevas sugerencias
		        suggestionsElement.amsifySuggestags({
		            showAllSuggestions: true,
		            keepLastOnHoverTag: false,
		            suggestions: filteredSuggestions,
		            whiteList: true
		        });
		    }

		    // Escuchar cambios en el selector de tipo de publicación
		    $('#aicc_bulki_post_type').change(function() {
		        var selectedPostType = $(this).val();
		        // Inicializar para ambos campos de entrada
		        initializeSuggestags(selectedPostType, "aicc_bulki_include");
		        initializeSuggestags(selectedPostType, "aicc_bulki_exclude");
		    });

		    // Inicializar Amsify Suggestags con el tipo de publicación inicial para ambos campos
		    var initialPostType = $('#aicc_bulki_post_type').val();
		    initializeSuggestags(initialPostType, "aicc_bulki_include");
		    initializeSuggestags(initialPostType, "aicc_bulki_exclude");
		});

	    $('#calcular-costo-btn').click(function(e) {
	    	e.preventDefault();
	        var postType = $('#aicc_bulki_post_type').val();
	        var quality = $('#aicc_bulki_image_quality').val();
	        var resolution = $('#aicc_bulki_image_resolution').val();
         	var excludeNoPublish = jQuery('#aicc_bulki_exclude_no_publish').prop('checked') ? '1' : '0';
 	    	var include = jQuery('#aicc_bulki_include').val();
 	    	var curationType = jQuery('#aicc_bulki_type').val();
 	    	var source = jQuery('#aicc_bulki_source').val();
 	    	var motor = jQuery('#aicc_bulki_motor').val();
         	var replace = jQuery('#aicc_bulki_replace').prop('checked') ? '1' : '0';
         
	        $('#resultado-costo').html('');

	        var spinner = $(this).next('.spinner'); 
						
			spinner.css({
				'float': 'none',          
				'margin-top': '5px',     
				'margin-left': '10px'    
			});
						
			spinner.show();

	        $.ajax({
	            url: ajaxurl,
	            type: 'POST',
	            data: {
	                action: 'aicc_return_total_cost',
	                postType: postType,
	               	type: 'image',
	               	quality: quality,
	               	resolution: resolution,
	               	excludeNoPublish: excludeNoPublish,
	               	include: include,
	               	curationType: curationType,
	               	source: source,
	               	motor: motor,
	               	replace: replace
	            },
	            success: function(response) {
	            	spinner.hide();
	                $('#resultado-costo').html('Costo estimado: $' + response);
	            },
	            error: function() {
	                $('#resultado-costo').html('Error al calcular el costo.');
	            }
	        });
	    });

	    $('#cancel-bulk-process').click(function(e) {
		    e.preventDefault();
		    
		    var spinner = $(this).next('.spinner'); 

		    // SweetAlert para confirmar la cancelación
		    Swal.fire({
		        text: "¿Estás seguro de que quieres cancelar la curación en curso?",
		        icon: 'warning',
		        showCancelButton: true,
	        	confirmButtonText: 'Sí, cancelar',
	        	cancelButtonText: 'No, continuar'
		    }).then((result) => {
		        if (result.value) {
		            $.ajax({
		                url: ajaxurl,
		                type: 'POST',
		                data: {
		                    action: 'aicc_cancel_bulk_process'
		                },
		                success: function(response) {
		                       Swal.fire({
							        icon: 'success',
							        text: 'El proceso se está cancelando',
							        confirmButtonText: 'Aceptar'
								}).then((result) => {
							    if (result.isConfirmed) {
							            location.reload();
								    }
							    });
		                },
		                error: function() {
		                    // Manejar el error adecuadamente
		                    Swal.fire({
		                        icon: 'error',
		                        text: 'Hubo un error al cancelar el proceso',
		                        confirmButtonText: 'Aceptar'
		                    });
		                }
		            });
		        } else {
		            // Usuario canceló la cancelación
		            Swal.fire({
		                icon: 'success',
		                text: 'La curación sigue su curso',
		                confirmButtonText: 'Aceptar'
		            });
		        }
		    });
		});


    var checkbox = $('#aicc_bulki_set_prompt');
    var bulkPromptRow = $('#bulkPromptRow');

    checkbox.change(function() {
        if (checkbox.is(':checked')) {
            bulkPromptRow.show();
        } else {
            bulkPromptRow.hide();
        }
    });

    function checkBulkRunning(callback) {
      jQuery.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "aicc_check_bulk_running"
        },
        dataType: "json",
        success: function (response) {
          if (response.check_status === 'processing' || response.check_status === 'missing') {
            Swal.fire({
              icon: 'error',
              text: response.message,
              confirmButtonText: 'Aceptar'
            });
            callback(false);
            spinner.hide();
          } else {
            callback(true);
          }
        },
        error: function (xhr, status, error) {
          alert("Error: " + error);
          callback(false);
        }
      });
    }

    $("#form-bulk-content").off("click", "#submit").on("click", "#submit", function(e) {
      	e.preventDefault();

		// Verificar si la opción de OpenAI está configurada
		var openaiKey = '<?php echo esc_js(get_option('aicc_options_openai')); ?>';
		if (!openaiKey) {
		    Swal.fire({
		        icon: 'warning',
		        text: 'Para continuar, es necesario ingresar tu clave API de OpenAI en las opciones del plugin.',
		        confirmButtonText: 'Aceptar'
		    });
		    return; 
		}

		// Verificar si la opción de OpenAI está configurada
		var replicateKey = '<?php echo esc_js(get_option('aicc_options_replicate')); ?>';
		var motor = jQuery('#aicc_bulki_motor').val();		

		if (!replicateKey && motor == 'replicate') {
		    Swal.fire({
		        icon: 'warning',
		        text: 'Para continuar, es necesario ingresar tu clave API de Replicate en las opciones del plugin.',
		        confirmButtonText: 'Aceptar'
		    });
		    return; 
		}

		var sourceFrom = jQuery('#aicc_bulki_source').val();

		// Verificar si la opción de OpenAI está configurada
		var pexelsKey = '<?php echo esc_js(get_option('aicc_options_pexels')); ?>';
		if (!pexelsKey && sourceFrom == 'pexels') {
		    Swal.fire({
		        icon: 'warning',
		        text: 'Para continuar, es necesario ingresar tu clave API de Pexels en las opciones del plugin.',
		        confirmButtonText: 'Aceptar'
		    });
		    return; 
		}

		// Verificar si la opción de OpenAI está configurada
		var pixabayKey = '<?php echo esc_js(get_option('aicc_options_pixabay')); ?>';
		if (!pixabayKey && sourceFrom == 'pixabay') {
		    Swal.fire({
		        icon: 'warning',
		        text: 'Para continuar, es necesario ingresar tu clave API de Pixabay en las opciones del plugin.',
		        confirmButtonText: 'Aceptar'
		    });
		    return; 
		}

	    var spinner = $(this).parent().next('.spinner');
						
		spinner.css({
			'float': 'none',          
			'margin-top': '10px',     
			'margin-left': '10px'    
		});
						
	   spinner.show();

      checkBulkRunning(function (canContinue) {
        if (canContinue) {
        	var setPromptActive = jQuery('#aicc_bulki_set_prompt').prop('checked');
		    var promptContent = jQuery('#aicc_bulki_prompt').val();
		    var confirmationText = "¿Deseas empezar la curación masiva de imágenes?";

		    if (setPromptActive && promptContent) {
		         if (!promptContent.includes('{post_title}')) {
		             confirmationText = "No has incluido la variable {post_title} en tu prompt personalizado. Esta variable podría resultar crucial para generar una imagen de calidad y relacionada al contenido. ¿Estás seguro de iniciar la curación sin incluir el título del artículo en la curación?";
		         }
		     }else if(setPromptActive && !promptContent) {
		           	confirmationText = "Has seleccionado la opción de personalizar la instrucción pero no has introducido ningún prompt personalizado. ¿Deseas continuar utilizando nuestro prompt por defecto?";
		    }

          Swal.fire({
            text: confirmationText,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Empezar',
            cancelButtonText: 'Cancelar'
          }).then((result) => {
            if (result.value) {
              var nonce = '<?php echo esc_js(wp_create_nonce("aicc_process_bulki_content")); ?>';
              var postType = jQuery('#aicc_bulki_post_type').val();
              var setPrompt = jQuery('#aicc_bulki_set_prompt').prop('checked') ? '1' : '0';
              var prompt = jQuery('#aicc_bulki_prompt').val();
 	          var budget = jQuery('#aicc_bulki_budget').val();	                          
              var include = jQuery('#aicc_bulki_include').val();
              var exclude = jQuery('#aicc_bulki_exclude').val();
              var quality = jQuery('#aicc_bulki_image_quality').val();
              var resolution = jQuery('#aicc_bulki_image_resolution').val();
              var excludeNoPublish = jQuery('#aicc_bulki_exclude_no_publish').prop('checked') ? '1' : '0';
 	          var type = jQuery('#aicc_bulki_type').val();	                          
 	          var source = jQuery('#aicc_bulki_source').val();	                          
 	          var motor = jQuery('#aicc_bulki_motor').val();	                          
 	          var aspect_ratio = jQuery('#aicc_bulki_aspect_ratio').val();	                          
              var replace = jQuery('#aicc_bulki_replace').prop('checked') ? '1' : '0';

              jQuery.ajax({
                url: ajaxurl,
                type: "POST",
                data: {
                  action: "aicc_process_bulki_content",
                  aicc_bulki_post_type: postType,
                  aicc_bulki_set_prompt: setPrompt,
                  aicc_bulki_prompt: prompt,
	              aicc_bulki_budget: budget,
                  aicc_bulki_include: include,
                  aicc_bulki_exclude: exclude,
                  aicc_bulki_quality: quality,
                  aicc_bulki_resolution: resolution,
                  aicc_bulki_exclude_no_publish: excludeNoPublish,
                  aicc_bulki_type: type,
                  aicc_bulki_source: source,
                  aicc_bulki_motor: motor,                  
                  aicc_bulki_aspect_ratio: aspect_ratio,                  
                  aicc_bulki_replace: replace,                  
                  nonce: nonce
                },
                success: function (response) {
                  console.log(response);
                  Swal.fire({
                    icon: 'success',
                    text: '¡La curación masiva de imágenes ha iniciado!',
                    confirmButtonText: 'Aceptar'
                  }).then((result) => {
                  	spinner.hide();
                    if (result.value) {
                      location.reload();
                    }
                  });
                },
                error: function (xhr, status, error) {
                  alert("Error: " + error);
                }
              });
            } else {
              spinner.hide();
            }
          });
        }
        else
        {
        	spinner.hide();
        }
      });
    });
  });
</script>


<?php else: ?>

<div class="notice notice-warning inline active-plugin-edit-warning" style="margin:10px !important;"><p>Parece que no tienes los permisos suficientes para ver esta página.</p></div>

<?php endif; ?>