<?php if ( current_user_can('manage_options') ) : ?>

<style>

	#view-posts-btn {
		color: #f1556c;
		border-color: #f1556c;
	    background: #fdeef0;
		vertical-align: top;	
		display: inline-block;
	    text-decoration: none;
	    font-size: 13px;
	    line-height: 2.15384615;
	    min-height: 30px;
	    margin: 0;
	    padding: 1px 10px;
	    cursor: pointer;
	    border-width: 1px;
	    border-style: solid;
	    -webkit-appearance: none;
	    border-radius: 3px;
	    white-space: nowrap;
	    box-sizing: border-box;
	}

	#aicc-recovery-autosave {
		color: #fff;
		border-color: #f1556c;
	    background: #f1556c;
		vertical-align: top;	
		display: inline-block;
	    text-decoration: none;
	    font-size: 13px;
	    line-height: 2.15384615;
	    min-height: 30px;
	    margin: 0 4px 0 4px;
	    padding: 1px 10px;
	    cursor: pointer;
	    border-width: 1px;
	    border-style: solid;
	    -webkit-appearance: none;
	    border-radius: 3px;
	    white-space: nowrap;
	    box-sizing: border-box;
	}
	
	#calcular-costo-btn:hover {
		background:#f7e7ff;
		border-color:#f1556c;
	}
	
	#calcular-costo-btn:active {
		border-color:#d174ff
	}
	
	span.aicc-status.green {
		color:#00a320 !important;
		font-weight:bold;
	}
	
	span.aicc-status.red {
		color:#e65054 !important;
		font-weight:bold;
	}
	
	#cancel-bulk-process {
		cursor: pointer;
		text-decoration: underline;
	}

	#cancel-bulk-process:hover {
		text-decoration: none;
	}

	#bulkPromptRow p,
	#bulkPromptRow li {
		font-size: 13px;
		color: #767676;
	}

	#bulkPromptRow ul {
		margin-top: 12px;
		margin-left: 16px;
		list-style: disc;
	}

	#bulkPromptRow code {
		cursor: pointer;
	}
	#bulkPromptRow code:hover {
		background: rgba(0,0,0,.1) !important;
	}
	.aicc-tooltip-a { cursor:pointer; }

	.aicc-options h2 {
	    display: flex;
	    align-items: center;
	}

	.aicc-options h2 span {
	    background: #202225;
	    color: #fff;
	    margin-left: 6px;
	}

	tr th i {
		display: inline-block;
	    vertical-align: top;
	    box-sizing: border-box;
	    margin: 1px 0 0 6px;
	    padding: 0 5px;
	    min-width: 18px;
	    height: 18px;
	    border-radius: 3px;
	    background-color: #f1556c;
	    color: #fff;
	    font-size: 11px;
	    line-height: 1.715;
	    text-align: center;
	    font-style: normal;
	}

</style>
<?php

global $wpdb;

$status = '';

$is_error = get_transient('aicc_error_bulk');

if ( $is_error ) {
	$admin_link = admin_url('admin.php?page=aicc-log');
	echo '<div class="notice notice-error is-dismissible"><p><strong>Se produjo un error</strong>. Revisa el registro de depuración del plugin para identificar la causa del problema o contacta con nuestro equipo de soporte. <a target="_blank" href="' . esc_url($admin_link) . '">Ir al registro de depuración</a></p></div>';
	delete_transient('aicc_error_bulk');
	$success_message = 'La curación en bulk terminó.';	
}
else
{
	$success_message = 'La curación en bulk se completó con éxito.';
}

$is_run = get_transient('aicc_is_bulk_running');

$is_end = get_transient('aicc_end_bulk');

$is_cancel = $wpdb->get_var("SELECT option_value FROM $wpdb->options WHERE option_name = 'aicc_cancel_bulk_process' LIMIT 1");

$is_cancel = $is_cancel === '1';

$discarded = get_option('aicc_bulk_discarded_count');
if ($discarded === false || !$discarded ) {
	$discarded = 0;
}

if ($is_cancel) {
    $status = 'cancel';
} elseif ($is_run) {
    $status = 'run';
} elseif ($is_end) {
    $status = 'end';
} else {
    $status = '';
}

if ($status == 'cancel') {
echo '<div class="notice notice-warning is-dismissible"><p>' . __('El proceso de cancelación está en curso. Por favor, ten paciencia, este proceso puede tardar unos minutos.', "aicc") . '</p></div>';
	delete_option('aicc_bulk_total_posts');
	delete_option('aicc_bulk_processed_count');
} elseif ($status == 'run') {
    $total_posts = get_option('aicc_bulk_total_posts');
	$processed_count = get_option('aicc_bulk_processed_count');	
	if ($processed_count === false || !$processed_count ) {
	    $processed_count = 0;
	}		
	$currentBulkProcessId = get_transient('aicc_current_bulk_process_id');
	if (false === $currentBulkProcessId) {
	    $currentBulkProcessId = '';
	}
	$resultado = null;
	$type = '';
	$type_ed = '';	
	if (false !== $currentBulkProcessId && $currentBulkProcessId > 0) {	
	    $sql = $wpdb->prepare("SELECT type FROM " . AICC_BULK_TABLE . " WHERE id = %d", $currentBulkProcessId);
	    $resultado = $wpdb->get_row($sql);
	    if ($resultado){
	    	$type = $resultado->type;
	    }
	}
    if ($type == 'Contenido') {
    	$type_ed = 'contenidos';
    }elseif ($type == 'Imagen'){
    	$type_ed = 'imágenes';
    }elseif ($type == 'Metaetiqueta'){
    	$type_ed = 'metaetiquetas';
    }elseif ($type == 'Video'){
    	$type_ed = 'videos';
    }
	$message = '<strong>Curación de '.$type_ed.' en proceso</strong>';
	if ($type == 'Video') {
		$message .= ' · Procesados <strong>' . $processed_count . '</strong> de <strong>' . $total_posts  . '</strong>';
		if($discarded){
			$message .= ' · ' . $discarded . ' descartados';
		}
		$message .=  ' · <span id="cancel-bulk-process">Cancelar proceso</span>';
	}

	echo '<div class="notice notice-success is-dismissible"><p>'.$message.'</p></div>';
} elseif ($status == 'end') {
	delete_transient('aicc_end_bulk');		
	echo '<div class="notice notice-success is-dismissible"><p><strong>'.__($success_message, "aicc").'</strong></p></div>';
}


?>
<form method="post" id="form-bulk-content">

<?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

<table class="form-table" id="aicc-fieldset-one">

		<h2><?php _e('Recuperación de revisiones', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Utiliza esta opción para restaurar tus publicaciones a una versión anterior empleando los autoguardados generados durante las curaciones masivas. Selecciona la ejecución específica que deseas recuperar y el contenido de tus publicaciones volverá al estado en que estaba antes de esa curación.', 'aicc'); ?></span></span></h2>

		<tbody>

			<tr>
			    <th>
			        <label><?php _e('Opciones de recuperación', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Every time you perform mass content curation, Content Curator will create a backup copy of each edited article. In case of any issues or errors during the process, this option allows you to easily restore all posts to their latest version auto-saved by Content Curator. This guarantees the integrity of your work and recover your contents safely and without complications.', 'aicc'); ?></span></span>
			    </th>
			 	<td style="display: flex;align-items: center; margin-top:6px">
				  <?php $processedPostsHistory = get_option('aicc_bulk_processed_posts_history', []); 
					// Crea una copia del array para preservar los índices
					$processedPostsHistorySorted = $processedPostsHistory;
					uasort($processedPostsHistorySorted, function ($a, $b) {
					    return strtotime($b['timestamp']) - strtotime($a['timestamp']);
					});
				  ?>
					<select id="aicc_recovery_select" name="aicc_recovery_select" style="min-width:240px">
					    <option value="recover_all">Todas las últimas revisiones</option>
					    <option value="recover_last">Sólo última ejecución</option>
					    <?php foreach ($processedPostsHistorySorted  as $index => $execution): ?>
					        <option value="<?php echo esc_attr($index); ?>">
					            <?php
					            // Mostrar tipo de curación y fecha de ejecución
					            $type = isset($execution['type']) ? ucfirst($execution['type']) : 'General';
					            $date = date('d-m-Y H:i:s', strtotime($execution['timestamp']));
					            echo sprintf('%s – %s', $type, $date);
					            ?>
					        </option>
					    <?php endforeach; ?>
					</select>
				    <button id="aicc-recovery-autosave" class="button"><?php _e('Recovery', 'aicc'); ?></button>
    				<button id="view-posts-btn" class="button">Ver artículos que se recuperarán</button>				    
				    <span class="spinner is-active" style="display:none;"></span>
				</td>
			</tr>

		</tbody>

	</table>

</form>

<!-- Modal structure -->
<div id="aicc-modal" class="aicc-modal" style="display: none;">
    <div class="aicc-modal-content">
        <div class="loader" style="display: none;"></div>
        <div class="aicc-modal-content-scroll"></div>
        <div id="modal-actions">
            <button class="aicc-cancel-btn">
                <span>Cerrar ventana</span>
            </button>
        </div>
    </div>
</div>

<script>

jQuery(document).ready(function($) {
    
    $('#aicc-recovery-autosave').off('click').on('click', function(e) {
        e.preventDefault();
        var spinner = $(this).next('.spinner');
        
        spinner.css({
            'float': 'none',
            'margin-top': '5px',
            'margin-left': '10px'
        });

        spinner.show();

        // Captura el valor seleccionado del select
        var recoveryOption = $('#aicc_recovery_select').val();

        // Primera SweetAlert para confirmar la acción de recuperación
        Swal.fire({
            text: "¿Estás seguro de querer realizar esta recuperación?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, recuperar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                performRecovery(recoveryOption);
            } else {
                spinner.hide();
            }
        });

        // Función para realizar la recuperación
        function performRecovery(action) {
            var nonce = '<?php echo esc_js(wp_create_nonce("aicc_process_bulkr_content")); ?>';
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'aicc_process_bulkr_content',
                    aicc_recovery_action: action,
                    nonce: nonce
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        text: 'El proceso de recuperación comenzó con éxito.',
                        confirmButtonText: 'Aceptar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            location.reload();
                        }
                    });
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        text: 'Hubo un error al recuperar los autoguardados.',
                        confirmButtonText: 'Aceptar'
                    });
                    spinner.hide();
                }
            });
        }
    });

	
	// Función para abrir el modal
    function openModal() {
        setTimeout(function() {
            $('#aicc-modal .aicc-modal-content-scroll').scrollTop(0);
        }, 1); 
        $('#aicc-modal').css('display', 'flex');
    }

    // Abre el modal al hacer clic en "Ver posts a actualizar"
    $('#view-posts-btn').on('click', function(e) {
        e.preventDefault();

        // Muestra el loader en el botón y en el modal mientras se carga el contenido
        var spinner = $(this).next('.spinner');
        spinner.css({
            'float': 'none',
            'margin-top': '5px',
            'margin-left': '10px'
        });
        spinner.show();
        $('#aicc-modal .loader').show();

        // Obtén el valor seleccionado en el select y llama al backend para obtener los títulos
        var selectedIndex = $('#aicc_recovery_select').val();

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'aicc_get_posts_to_recover',
                selected_index: selectedIndex
            },
            success: function(response) {
                $('#aicc-modal .loader').hide(); // Oculta el loader del modal
                spinner.hide(); // Oculta el loader del botón
                $('#aicc-modal .aicc-modal-content-scroll').html(response);
                openModal();  // Abre el modal
            },
            error: function() {
                $('#aicc-modal .loader').hide(); // Oculta el loader del modal
                spinner.hide(); // Oculta el loader del botón
                $('#aicc-modal .aicc-modal-content-scroll').html('<p>Error al cargar los títulos de los posts.</p>');
                openModal();  // Abre el modal
            }
        });
    });

    // Cierra el modal al hacer clic en "Cerrar ventana"
    $('.aicc-cancel-btn').on('click', function() {
        $('#aicc-modal').hide();
    });

});


</script>


<?php else: ?>

<div class="notice notice-warning inline active-plugin-edit-warning" style="margin:10px !important;"><p>Parece que no tienes los permisos suficientes para ver esta página.</p></div>

<?php endif; ?>