<?php if ( current_user_can('manage_options') ) : ?>

<style>
	#calcular-costo-btn {
		color: #f1556c;
		border-color: #f1556c;
	    background: #fdeef0;
		vertical-align: top;	
		display: inline-block;
	    text-decoration: none;
	    font-size: 13px;
	    line-height: 2.15384615;
	    min-height: 30px;
	    margin: 0;
	    padding: 0 10px;
	    cursor: pointer;
	    border-width: 1px;
	    border-style: solid;
	    -webkit-appearance: none;
	    border-radius: 3px;
	    white-space: nowrap;
	    box-sizing: border-box;
	}
	
	#calcular-costo-btn:hover {
		background:#f7e7ff;
		border-color:#f1556c;
	}
	
	#calcular-costo-btn:active {
		border-color:#d174ff
	}
	
	span.aicc-status.green {
		color:#00a320 !important;
		font-weight:bold;
	}
	
	span.aicc-status.red {
		color:#e65054 !important;
		font-weight:bold;
	}
	
	#cancel-bulk-process {
		cursor: pointer;
		text-decoration: underline;
	}

	#cancel-bulk-process:hover {
		text-decoration: none;
	}

	#bulkPromptRow p,
	#bulkPromptRow li {
		font-size: 13px;
		color: #767676;
	}

	#bulkPromptRow ul {
		margin-top: 12px;
		margin-left: 16px;
		list-style: disc;
	}

	#bulkPromptRow code {
		cursor: pointer;
	}
	#bulkPromptRow code:hover {
		background: rgba(0,0,0,.1) !important;
	}
	.aicc-tooltip-a { cursor:pointer; }

	.aicc-options h2 {
	    display: flex;
	    align-items: center;
	}

	.aicc-options h2 span {
	    background: #202225;
	    color: #fff;
	    margin-left: 6px;
	}

	tr th i {
		display: inline-block;
	    vertical-align: top;
	    box-sizing: border-box;
	    margin: 1px 0 0 6px;
	    padding: 0 5px;
	    min-width: 18px;
	    height: 18px;
	    border-radius: 3px;
	    background-color: #f1556c;
	    color: #fff;
	    font-size: 11px;
	    line-height: 1.715;
	    text-align: center;
	    font-style: normal;
	}

</style>
<?php

global $wpdb;

$status = '';

$is_error = get_transient('aicc_error_bulk');

if ( $is_error ) {
	$admin_link = admin_url('admin.php?page=aicc-log');
	echo '<div class="notice notice-error is-dismissible"><p><strong>Se produjo un error</strong>. Revisa el registro de depuración del plugin para identificar la causa del problema o contacta con nuestro equipo de soporte. <a target="_blank" href="' . esc_url($admin_link) . '">Ir al registro de depuración</a></p></div>';
	delete_transient('aicc_error_bulk');
	$success_message = 'La curación en bulk terminó.';	
}
else
{
	$success_message = 'La curación en bulk se completó con éxito.';
}

$is_run = get_transient('aicc_is_bulk_running');

$is_end = get_transient('aicc_end_bulk');

$is_cancel = $wpdb->get_var("SELECT option_value FROM $wpdb->options WHERE option_name = 'aicc_cancel_bulk_process' LIMIT 1");

$is_cancel = $is_cancel === '1';

$discarded = get_option('aicc_bulk_discarded_count');
if ($discarded === false || !$discarded ) {
	$discarded = 0;
}

if ($is_cancel) {
    $status = 'cancel';
} elseif ($is_run) {
    $status = 'run';
} elseif ($is_end) {
    $status = 'end';
} else {
    $status = '';
}

if ($status == 'cancel') {
echo '<div class="notice notice-warning is-dismissible"><p>' . __('El proceso de cancelación está en curso. Por favor, ten paciencia, este proceso puede tardar unos minutos.', "aicc") . '</p></div>';
	delete_option('aicc_bulk_total_posts');
	delete_option('aicc_bulk_processed_count');
} elseif ($status == 'run') {
    $total_posts = get_option('aicc_bulk_total_posts');
	$processed_count = get_option('aicc_bulk_processed_count');	
	if ($processed_count === false || !$processed_count ) {
	    $processed_count = 0;
	}		
	$currentBulkProcessId = get_transient('aicc_current_bulk_process_id');
	if (false === $currentBulkProcessId) {
	    $currentBulkProcessId = '';
	}
	$resultado = null;
	$type = '';
	$type_ed = '';	
	if (false !== $currentBulkProcessId && $currentBulkProcessId > 0) {	
	    $sql = $wpdb->prepare("SELECT type FROM " . AICC_BULK_TABLE . " WHERE id = %d", $currentBulkProcessId);
	    $resultado = $wpdb->get_row($sql);
	    if ($resultado){
	    	$type = $resultado->type;
	    }
	}
    if ($type == 'Contenido') {
    	$type_ed = 'contenidos';
    }elseif ($type == 'Imagen'){
    	$type_ed = 'imágenes';
    }elseif ($type == 'Metaetiqueta'){
    	$type_ed = 'metaetiquetas';
    }elseif ($type == 'Video'){
    	$type_ed = 'videos';
    }
	$message = '<strong>Curación de '.$type_ed.' en proceso</strong>';
	if ($type == 'Video') {
		$message .= ' · Procesados <strong>' . $processed_count . '</strong> de <strong>' . $total_posts  . '</strong>';
		if($discarded){
			$message .= ' · ' . $discarded . ' descartados';
		}
		$message .=  ' · <span id="cancel-bulk-process">Cancelar proceso</span>';
	}

	echo '<div class="notice notice-success is-dismissible"><p>'.$message.'</p></div>';
} elseif ($status == 'end') {
	delete_transient('aicc_end_bulk');		
	echo '<div class="notice notice-success is-dismissible"><p><strong>'.__($success_message, "aicc").'</strong></p></div>';
}

?>
<form method="post" id="form-bulk-content">

<?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

<table class="form-table" id="aicc-fieldset-one">

		<h2><?php _e('Curación masiva de videos', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('En esta sección puedes agregar vídeos de YouTube a todos tus artículos de forma masiva.', 'aicc'); ?></span></span></h2>

		<tbody>
		    <?php
		        $post_types = get_post_types(array('public' => true), 'names');
		        $excluded_post_types = array('attachment', 'product');
		        $post_types = array_diff($post_types, $excluded_post_types);
		        
				// Recuperar las opciones guardadas o establecer valores predeterminados
				$saved_post_type = get_option('aicc_bulkv_post_type', 'post');
				$saved_budget = get_option('aicc_bulkv_budget', 0);
				$saved_include = get_option('aicc_bulkv_include', '');
				$saved_exclude = get_option('aicc_bulkv_exclude', '');
				$saved_discard_already_video = get_option('aicc_bulkv_discard_already_video', false);
		    ?>
		    <tr>
		        <th>
		            <label for="aicc_bulkv_post_type"><?php _e('Run on', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the type of content where bulk curation will run.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		           <select name="aicc_bulkv_post_type" id="aicc_bulkv_post_type">
		            <?php foreach ($post_types as $post_type): ?>
		                <?php 
		                    $post_type_object = get_post_type_object($post_type);
		                    $post_type_label = $post_type_object->labels->singular_name;
		                ?>
		                <option value="<?php echo $post_type; ?>" <?php selected($saved_post_type, $post_type); ?>><?php echo $post_type_label; ?></option>
		            <?php endforeach; ?>
		            </select>
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulkv_discard_already_video"><?php _e('Descartar artículos con videos ', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Al habilitar esta opción, no se agregarán videos a los artículos que ya tengan otros videos de Youtube incrustados.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input name="aicc_bulkv_discard_already_video" id="aicc_bulkv_discard_already_video" type="checkbox" value="1" <?php checked($saved_discard_already_video, '1'); ?>>
		        </td>
		    </tr>  

		    <tr>
		        <th>
		            <label for="aicc_bulkv_budget"><?php _e('Presupuesto máximo', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Esta función te permite establecer un presupuesto máximo estimado para la curación masiva. La curación finalizará automáticamente una vez que se consuma el presupuesto especificado. Si estableces el presupuesto en 0, este será considerado ilimitado, permitiendo que la curación continúe hasta que decidas finalizarla manualmente.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input style="width:60px" step="1" name="aicc_bulkv_budget" id="aicc_bulkv_budget" type="number" value="<?php echo $saved_budget; ?>" min="0" max="100"/> <span> dólares</span>
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulkv_include"><?php _e('Seleccionar contenidos', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Utiliza esta opción para seleccionar específicamente las publicaciones o páginas que desea curar en masa. Al activar esta funcionalidad, solo se seleccionarán los elementos seleccionados manualmente, excluyendo automáticamente cualquier otro contenido no marcado. Si no seleccionas ninguno, el proceso procesará todos los contenidos.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input style="width:250px" name="aicc_bulkv_include" id="aicc_bulkv_include" type="text" value="<?php echo esc_attr($saved_include); ?>"/> 
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="aicc_bulkv_exclude"><?php _e('Exclude content', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Select the posts or pages you want to exclude from mass content curation.', 'aicc'); ?></span></span>
		        </th>
		        <td>
		            <input style="width:250px" name="aicc_bulkv_exclude" id="aicc_bulkv_exclude" type="text" value="<?php echo esc_attr($saved_exclude); ?>"/> 
		        </td>
		    </tr>

		    <tr>
		        <th>
		            <label for="calcular-costo-btn"><?php _e('Calculate cost', 'aicc'); ?></label><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Calcula el costo estimado del agregado de video en los artículos. Esta función considera tanto el saldo de OpenAI como el de ValueSERP. Agregar un video a cada artículo consume una solicitud en ValueSERP (costo de $0,0025 por solicitud) y también utiliza el saldo de OpenAI para generar descripciones o presentar contexto al video.', 'aicc'); ?></span></span>
		        </th>
		        <td style="display: flex;align-items: center; margin-top:6px">
		            <button id="calcular-costo-btn" class="button"><?php _e('Calculate', 'aicc'); ?></button>
		            <span class="spinner is-active" style="display:none;"></span>
		            <span id="resultado-costo" style="margin-left:10px"></span>
		        </td>
		    </tr>      

		    <tr>
		        <th>
		            <input type="hidden" name="aicc_from" id="aicc_from" value="general-settings" />
		            <div style="display:flex; align-items: center"><?php submit_button('Empezar'); ?><span class="spinner is-active" style="display:none;"></span></div>
		        </th>
		    </tr>
		</tbody>


	</table>

</form>

<script>

	jQuery(document).ready(function($) {

		var allSuggestions = {
		    <?php
		    $post_types = get_post_types(array('public' => true), 'names');
		    $excluded_post_types = array('attachment', 'product');
		    $post_types = array_diff($post_types, $excluded_post_types);

		    foreach ($post_types as $post_type) {
		        echo "'$post_type': [";

		        $args = array('post_type' => $post_type, 'posts_per_page' => -1);
		        $posts = get_posts($args);
		        foreach ($posts as $post) {

		            $title = addslashes($post->post_title);
	    			$special_chars = array(".", "-", "'", "'", "\"", "\n", "\r", "\t", "&", "<", ">");
				    $title = str_replace($special_chars, " ", $title);	            
		            echo "{tag: '$title', value: '{$post->ID}'},";
		        }

		        echo "],";
		    }
		    ?>
		};

		jQuery(document).ready(function($) {
		    // Función para inicializar/reinicializar Amsify Suggestags
		    function initializeSuggestags(postType, inputName) {
		        var suggestionsElement = $('input[name="' + inputName + '"]');
		        
		        // Asegurarse de destruir la instancia anterior si existe
		        if (suggestionsElement.data('amsifySuggestags')) {
		            suggestionsElement.suggestags('destroy');
		        }
		        
		        // Filtrar sugerencias basadas en el tipo de publicación seleccionado
		        var filteredSuggestions = allSuggestions[postType] || [];
		        
		        // Inicializar Amsify Suggestags con las nuevas sugerencias
		        suggestionsElement.amsifySuggestags({
		            showAllSuggestions: true,
		            keepLastOnHoverTag: false,
		            suggestions: filteredSuggestions,
		            whiteList: true
		        });
		    }

		    // Escuchar cambios en el selector de tipo de publicación
		    $('#aicc_bulkv_post_type').change(function() {
		        var selectedPostType = $(this).val();
		        // Inicializar para ambos campos de entrada
		        initializeSuggestags(selectedPostType, "aicc_bulkv_include");
		        initializeSuggestags(selectedPostType, "aicc_bulkv_exclude");
		    });

		    // Inicializar Amsify Suggestags con el tipo de publicación inicial para ambos campos
		    var initialPostType = $('#aicc_bulkv_post_type').val();
		    initializeSuggestags(initialPostType, "aicc_bulkv_include");
		    initializeSuggestags(initialPostType, "aicc_bulkv_exclude");
		});

	    $('#calcular-costo-btn').click(function(e) {
	    	e.preventDefault();
	        var postType = $('#aicc_bulkv_post_type').val();
					var include = jQuery('#aicc_bulkv_include').val();		        

	        $('#resultado-costo').html('');

	        var spinner = $(this).next('.spinner'); 
						
			spinner.css({
				'float': 'none',          
				'margin-top': '5px',     
				'margin-left': '10px'    
			});
						
			spinner.show();

	        $.ajax({
	            url: ajaxurl,
	            type: 'POST',
	            data: {
	                action: 'aicc_return_total_cost',
	                postType: postType,
	                include: include,
	               	type: 'video',
	            },
	            success: function(response) {
	            	spinner.hide();
	                $('#resultado-costo').html('Costo estimado: $' + response);
	            },
	            error: function() {
	                $('#resultado-costo').html('Error al calcular el costo.');
	            }
	        });
	    });

		
	    $('#cancel-bulk-process').click(function(e) {
		    e.preventDefault();
		    
		    var spinner = $(this).next('.spinner'); 

		    // SweetAlert para confirmar la cancelación
		    Swal.fire({
		        text: "¿Estás seguro de que quieres cancelar la curación en curso?",
		        icon: 'warning',
		        showCancelButton: true,
	        	confirmButtonText: 'Sí, cancelar',
	        	cancelButtonText: 'No, continuar'
		    }).then((result) => {
		        if (result.value) {
		            $.ajax({
		                url: ajaxurl,
		                type: 'POST',
		                data: {
		                    action: 'aicc_cancel_bulk_process'
		                },
		                success: function(response) {
		                       Swal.fire({
							        icon: 'success',
							        text: 'El proceso se está cancelando',
							        confirmButtonText: 'Aceptar'
								}).then((result) => {
							    if (result.isConfirmed) {
							            location.reload();
								    }
							    });
		                },
		                error: function() {
		                    // Manejar el error adecuadamente
		                    Swal.fire({
		                        icon: 'error',
		                        text: 'Hubo un error al cancelar el proceso',
		                        confirmButtonText: 'Aceptar'
		                    });
		                }
		            });
		        } else {
		            // Usuario canceló la cancelación
		            Swal.fire({
		                icon: 'success',
		                text: 'La curación sigue su curso',
		                confirmButtonText: 'Aceptar'
		            });
		        }
		    });
		});


    function checkBulkRunning(callback) {
      jQuery.ajax({
        url: ajaxurl,
        type: "POST",
        data: {
          action: "aicc_check_bulk_running"
        },
        dataType: "json",
        success: function (response) {
          if (response.check_status === 'processing' || response.check_status === 'missing') {
            Swal.fire({
              icon: 'error',
              text: response.message,
              confirmButtonText: 'Aceptar'
            });
            callback(false);
            spinner.hide();
          } else {
            callback(true);
          }
        },
        error: function (xhr, status, error) {
          alert("Error: " + error);
          callback(false);
        }
      });
    }

    $("#form-bulk-content").off("click", "#submit").on("click", "#submit", function(e) {
      	e.preventDefault();

		// Verificar si la opción de OpenAI está configurada
		var openaiKey = '<?php echo esc_js(get_option('aicc_options_openai')); ?>';
		if (!openaiKey) {
		    Swal.fire({
		        icon: 'warning',
		        text: 'Para continuar, es necesario ingresar tu clave API de OpenAI en las opciones del plugin.',
		        confirmButtonText: 'Aceptar'
		    });
		    return; 
		}

		// Verificar si la opción de OpenAI está configurada
		var valueserpKey = '<?php echo esc_js(get_option('aicc_options_valueserp')); ?>';
		if (!valueserpKey) {
		    Swal.fire({
		        icon: 'warning',
		        text: 'Para continuar, es necesario ingresar tu clave API de ValueSERP en las opciones del plugin.',
		        confirmButtonText: 'Aceptar'
		    });
		    return; 
		}

	    var spinner = $(this).parent().next('.spinner');
						
		spinner.css({
			'float': 'none',          
			'margin-top': '10px',     
			'margin-left': '10px'    
		});
						
	   spinner.show();

      checkBulkRunning(function (canContinue) {
        if (canContinue) {
		    var confirmationText = "¿Deseas empezar la curación masiva de videos?";

          Swal.fire({
            text: confirmationText,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Empezar',
            cancelButtonText: 'Cancelar'
          }).then((result) => {
            if (result.value) {
              var nonce = '<?php echo esc_js(wp_create_nonce("aicc_process_bulkv_content")); ?>';
              var postType = jQuery('#aicc_bulkv_post_type').val();
 	          var budget = jQuery('#aicc_bulkv_budget').val();	                          
              var include = jQuery('#aicc_bulkv_include').val();
              var exclude = jQuery('#aicc_bulkv_exclude').val();
              var discardAlready = jQuery('#aicc_bulkv_discard_already_video').prop('checked') ? '1' : '0';

              jQuery.ajax({
                url: ajaxurl,
                type: "POST",
                data: {
                  action: "aicc_process_bulkv_content",
                  aicc_bulkv_post_type: postType,
	              aicc_bulkv_budget: budget,
                  aicc_bulkv_include: include,
                  aicc_bulkv_exclude: exclude,
                  aicc_bulkv_discard_already_video: discardAlready,                  
                  nonce: nonce
                },
                success: function (response) {
                  console.log(response);
                  Swal.fire({
                    icon: 'success',
                    text: '¡La curación masiva de videos ha iniciado!',
                    confirmButtonText: 'Aceptar'
                  }).then((result) => {
                  	spinner.hide();
                    if (result.value) {
                      location.reload();
                    }
                  });
                },
                error: function (xhr, status, error) {
                  alert("Error: " + error);
                }
              });
            } else {
              spinner.hide();
            }
          });
        }
        else
        {
        	spinner.hide();
        }
      });
    });
  });
</script>


<?php else: ?>

<div class="notice notice-warning inline active-plugin-edit-warning" style="margin:10px !important;"><p>Parece que no tienes los permisos suficientes para ver esta página.</p></div>

<?php endif; ?>