	<style>

	.aicc-options table.widefat {
		margin-top:1.5rem;
		font-size:14px;
		border:1px solid #e2e4e7;
	}
				
	.aicc-options .widefat td
	{
		font-size:14px;			
	}
				
	.aicc-options table.widefat th,
	.aicc-options table.widefat td {
		padding:1rem 1.1rem;	
	}
				
	.widefat thead th {
		background:#fff;
		border-bottom:1px solid #e2e4e7;
		background:#fff;
	}
				
	.widefat tbody tr:nth-child(even) {
		background-color: #fff;
	}

	.widefat tbody tr:nth-child(odd) {
	  	background-color: #f6f7f7;
	}
				
	.aicc-options .widefat .icon-tabler-alert-circle {
		position:absolute;
	}
				
	.aicc-options .widefat .icon-tabler-alert-circle  + span {
		margin-left:24px;
		display:block;
	}
		
	.aicc-options h2 {
	    display: flex;
	    align-items: center;
	}

	.aicc-options h2 span {
	    background: #202225;
		color: #fff;
	    margin-left: 6px;
	}
		
	.aicc-modal h2 {
		border-bottom:none !important;
	}
		
	.aicc-cancel-btn {
		font-size:13px !important;	
	}

	.view-content-btn {
		cursor: pointer
	}		

	</style>

	<?php

   	global $wpdb;

    $items_per_page = 10;

    $current_page = isset($_GET['paged']) ? absint($_GET['paged']) : 1;

    $offset = ($current_page - 1) * $items_per_page;
 
 	$sql = $wpdb->prepare("SELECT ID, post_id, tokens, cost, content, model, date  FROM " . AICC_HISTORICAL_TABLE . " ORDER BY id DESC LIMIT %d OFFSET %d", $items_per_page, $offset);
     
    $resultados = $wpdb->get_results($sql);

    $total_query = "SELECT COUNT(*) FROM " . AICC_HISTORICAL_TABLE;

    $total_items = $wpdb->get_var($total_query);

    $total_cost_sql = "SELECT SUM(cost) as total_cost FROM " . AICC_HISTORICAL_TABLE;

    $total_cost = $wpdb->get_var($total_cost_sql);
							
	?>

  	<h2><?php _e('List of curations', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext">En esta sección aparecen todas las ejecuciones realizadas y sus gastos asociados, ya sea que las hayas aceptado la curación o no. De momento, llevas gastado un total de $<?php echo rtrim(rtrim($total_cost, '0'), '.'); ?>.</span></span></h2>
			
	<?php if (!$resultados): ?>
				
	<div class="notice notice-warning"><p><?php _e('There are no content curations yet.', 'aicc'); ?></p></div>

	<?php else: ?>

	<table class="widefat">
		<thead>
			 <tr>
				<th><?php _e('Title', 'aicc'); ?></th>
				<th style="text-align:center;"><?php _e('Tokens', 'aicc'); ?></th>
				<th style="text-align:center;"><?php _e('Cost', 'aicc'); ?></th>		
				<th style="text-align:center;"><?php _e('Fecha', 'aicc'); ?></th>			
				<th style="text-align:center;"><?php _e('Modelo', 'aicc'); ?></th>			
			</tr>
		</thead>
		<tbody>
			<?php foreach ($resultados as $resultado) : ?>
			<?php 
				$post_id = $resultado->post_id; 
				$dateObject = new DateTime($resultado->date);
				$date = $dateObject->format('d/m/Y');
				$edit_link = get_edit_post_link($post_id);
				$cost = rtrim(rtrim(sprintf('%f', $resultado->cost), '0'), '.');
				$title = get_the_title($post_id);
				$edit_url = admin_url("post.php?post={$post_id}&action=edit");
				$url = get_permalink($post_id);
				$contenido = htmlspecialchars($resultado->content);
			?>
			
			<tr>
				<td width="45%">
				<?php
				echo "<a href='{$edit_url}' target='_blank' rel='noopener'><strong>{$title}</strong></a>";
				echo '<div class="row-actions">';
				echo "<span class='edit'><a href='{$edit_url}' target='_blank' rel='noopener'>Editar</a> | </span>";
				echo "<span class='view'><a href='{$url}' target='_blank' rel='noopener'>Vista previa</a> | </span>";
				echo "<span class='view'><a class='view-content-btn' data-content='{$contenido}' target='_blank' rel='noopener'>Ver contenido generado</a></span>";
				echo "</div>";
				?>
				</td>
				<td width="10%" style="text-align:center;"><?php echo $resultado->tokens; ?></td>
				<td width="10%" style="text-align:center;">$<?php echo $cost;  ?></td>
				<td width="10%" style="text-align:center;" title="<?php echo $resultado->date; ?>"><?php echo $date; ?></td>
				<td width="20%" style="text-align:center;"><?php echo $resultado->model; ?></td>
			</tr>
			<?php endforeach; ?>
			
		</tbody>
	
	</table>
			
	<?php
				
 		$pagination_args = array(
            'base' => add_query_arg('paged', '%#%'),
             'format' => '?paged=%#%',
             'total' => ceil($total_items / $items_per_page),
             'current' => $current_page,
             'prev_text' => __('«'),
             'next_text' => __('»'),
		);

		echo '<div class="tablenav"><div class="tablenav-pages">' . paginate_links($pagination_args) . '</div></div>';
				
	?>

	<div id="aicc-modal" class="aicc-modal" style="display: none;">
		<div class="aicc-modal-content">
			<div class="loader" style="display: none;"></div>
			<div class="aicc-modal-content-scroll"></div>
			<div id="modal-actions">
				<button class="aicc-cancel-btn">
					<span>Cerrar ventana</span>
				</button>	
			</div>
		</div>
	</div>

	<script>
	jQuery(document).ready(function($) {
		var modal = document.querySelector('.aicc-modal');

		// Función para abrir el modal
		function openModal() {
			// Introduce un breve retraso antes de restablecer la posición de desplazamiento
			setTimeout(function() {
				$('#aicc-modal .aicc-modal-content-scroll').scrollTop(0);
			}, 1); 
			modal.style.display = 'flex';
			
		}

		// Al hacer clic en el botón "Ver Contenido"
		$('.view-content-btn').on('click', function() {
			// Obtener el contenido desde el atributo data-content del botón
			var content = $(this).data('content');

			// Actualizar el modal con el contenido
			$('#aicc-modal .aicc-modal-content-scroll').html(content);

			// Mostrar el modal
			openModal();
		});

		// Cerrar el modal al hacer clic en el botón "Cancelar"
		$('.aicc-cancel-btn').on('click', function() {
			$('#aicc-modal').hide();
		});
	});
	</script>

	<?php endif; ?>