<?php if ( current_user_can('manage_options') ) : ?>

    <style>
        #exportBtn {
            color: #fff;
            border-color: #f1556c;
            background: #f1556c;
            vertical-align: top;    
            display: inline-block;
            text-decoration: none;
            font-size: 13px;
            line-height: 2.15384615;
            min-height: 30px;
            margin: 0;
            padding: 0 10px;
            cursor: pointer;
            border-width: 1px;
            border-style: solid;
            -webkit-appearance: none;
            border-radius: 3px;
            white-space: nowrap;
            box-sizing: border-box;
        }
        
        #exportBtn:hover {
            background:#d84c61;
            border-color:#d84c61;
        }
        
        #exportBtn:active {
            border-color:#c04456
        }
        
        #copyBtn,
        #clearLogBtn {
            color: #f1556c;
            border-color: #f1556c;
            background: #fdeef0;
            vertical-align: top;    
            display: inline-block;
            text-decoration: none;
            font-size: 13px;
            line-height: 2.15384615;
            min-height: 30px;
            margin: 0;
            padding: 0 10px;
            cursor: pointer;
            border-width: 1px;
            border-style: solid;
            -webkit-appearance: none;
            border-radius: 3px;
            white-space: nowrap;
            box-sizing: border-box;
            margin-left:10px;
        }
        
        #copyBtn:hover,
        #clearLogBtn:hover {
            background:#f7e7ff;
            border-color:#f1556c;
        }
        
        #copyBtn:active,
        #clearLogBtn:active {
            border-color:#d174ff
        }   
    
        span.aicc-status.green {
            color:#00a320 !important;
            font-weight:bold;
        }
        
        span.aicc-status.red {
            color:#e65054 !important;
            font-weight:bold;
        }
        
        #token_cost {
            margin-left: 6px;
            font-style:italic;
        }   
        
        .tools-textarea {
            margin-top:1rem  !important;
            width:100% !important;
            background: #32373c !important;
            color: rgba(240, 245, 250, .7)  !important;;
            font-size: 12px  !important;
            font-family: Menlo, Monaco, monospace  !important;;
            display: block  !important;;
            overflow: auto  !important;;
            white-space: pre  !important;;
            width: 100%  !important;;
            height: 450px  !important;;
            padding: 10px  !important;;
            outline: none  !important;;
        }

        .aicc-tooltip-a { 
            cursor:pointer; 
        }
        .aicc-options h2 {
            display: flex;
            align-items: center;
        }
        .aicc-options h2 span {
            background: #202225;
            color: #fff;
            margin-left: 6px;
        }   

    </style>

    <?php
    global $wpdb;
    $query = $wpdb->prepare('SELECT date, message FROM ' . AICC_LOG_TABLE . ' ORDER BY id DESC LIMIT 1000');
    $rows = $wpdb->get_results($query, ARRAY_A);
    $log_contents = array_map(function ($row) {
        return $row['date'] . ' - ' . $row['message'];
    }, $rows);
    $log_contents = array_slice($log_contents, 0, 100); // Limita a las últimas 100 entradas
    $log_text = implode("\n", $log_contents);
    ?>

    <?php
    $nonce = wp_create_nonce('export_data_nonce'); 
    ?>

    <?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

    <table class="form-table" id="aicc-fieldset-one">

        <h2><?php _e('Registro de depuración', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('En este registro de depuración se documentan detalladamente todas las actividades realizadas por el plugin, incluyendo errores, advertencias y otras situaciones importantes que ocurren durante su ejecución. Al revisar este registro, los administradores pueden identificar rápidamente por qué ciertas acciones, como el descarte de posts, se llevaron a cabo, facilitando la identificación y corrección de problemas. En resumen, el registro de depuración actúa como un historial completo de las operaciones del plugin, proporcionando una visión clara de su funcionamiento interno y ayudando a mejorar y estabilizar su rendimiento a lo largo del tiempo', 'aicc'); ?></span></span></h2>

        <tbody>
            
        <textarea readonly="readonly" class="tools-textarea" rows="15" id="log-contents"><?php echo esc_textarea($log_text); ?></textarea>
            
        </tbody>
        <br>
        <button id="exportBtn" data-nonce="<?php echo $nonce; ?>">Descargar archivo completo</button>
        <button type="button" id="copyBtn" onclick="copyToClipboard(event)">Copiar al portapapeles</button>
        <button id="clearLogBtn" data-nonce="<?php echo wp_create_nonce('clear_log_nonce'); ?>">Vaciar registro</button>

    </table>

    
<?php else: ?>

    <div class="notice notice-warning inline active-plugin-edit-warning" style="margin:10px !important;"><p>Parece que no tienes los permisos suficientes para ver esta página.</p></div>

<?php endif; ?>

<script>

    jQuery(document).ready(function($) {
        $('#exportBtn').on('click', function(e) {
            e.preventDefault();
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'export_data',
                    security: $('#exportBtn').data('nonce')
                },
                success: function(data) {
                    const blob = new Blob([data], { type: 'text/plain' });
                    const url = URL.createObjectURL(blob);
    
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'data.txt';
                    a.click();
    
                    URL.revokeObjectURL(url);
                },
                error: function() {
                    alert('Hubo un error al obtener los datos.');
                }
            });
        });


        $('#clearLogBtn').on('click', function(e) {
            e.preventDefault();
            Swal.fire({
                html: "<strong>Atención</strong>: esta acción borrará todo el registro de depuración y no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Vaciar registro',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'aicc_clear_log',
                            security: $('#clearLogBtn').data('nonce')
                        },
                        success: function(response) {
                            Swal.fire({
                                text: 'El registro de depuración ha sido vaciado.',
                                icon: 'success',
                                confirmButtonText: 'Aceptar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            });
                        },
                        error: function() {
                            Swal.fire(
                                'Error',
                                'Hubo un error al vaciar el registro.',
                                'error'
                            );
                        }
                    });
                }
            });
        });
    });


    function copyToClipboard(e) {
        e.preventDefault();  
    
        const logContent = document.getElementById('log-contents');
        logContent.select();
        document.execCommand('copy');
    
        Swal.fire({
            text: "Registro de depuración copiado al portapapeles",
            icon: "success",
            confirmButtonText: 'Aceptar'
        });
    }
</script>