	<style>

	.aicc-options table.widefat {
		margin-top:1.5rem;
		font-size:14px;
		border:1px solid #e2e4e7;
	}
				
	.aicc-options .widefat td
	{
		font-size:14px;			
	}
				
	.aicc-options table.widefat th,
	.aicc-options table.widefat td {
		padding:1rem 1.1rem;	
	}
				
	.widefat thead th {
		background:#fff;
		border-bottom:1px solid #e2e4e7;
		background:#fff;
	}
				
	.widefat tbody tr:nth-child(even) {
		background-color: #fff;
	}

	.widefat tbody tr:nth-child(odd) {
	  	background-color: #f5f5f5;
	}
				
	.aicc-options .widefat .icon-tabler-alert-circle {
		position:absolute;
	}
				
	.aicc-options .widefat .icon-tabler-alert-circle  + span {
		margin-left:24px;
		display:block;
	}

	.aicc-options h2 {
	    display: flex;
	    align-items: center;
	}

	.aicc-options h2 span {
	    background: #202225;
		color: #fff;
	    margin-left: 6px;
	}	

	</style>

	<?php

   	global $wpdb;

    $items_per_page = 10;

    $current_page = isset($_GET['paged']) ? absint($_GET['paged']) : 1;

    $offset = ($current_page - 1) * $items_per_page;
 
 	$sql = $wpdb->prepare("SELECT ID, post_id, content, date FROM " . AICC_PENDING_TABLE . " ORDER BY id DESC LIMIT %d OFFSET %d", $items_per_page, $offset);
     
    $resultados = $wpdb->get_results($sql);

    $total_query = "SELECT COUNT(*) FROM " . AICC_PENDING_TABLE;

    $total_items = $wpdb->get_var($total_query);
							
	?>

  	<h2><?php _e('Pending Curations', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext">Las curaciones pendiente son aquellas que se realizaron pero quedaron pendientes porque no se guardaron los cambios. En esta sección podrás detectarlas rápidamente para editar la entrada o página y actualizarla para impactar la curación.</span></span></h2>
			
	<?php if (!$resultados): ?>
				
	<div class="notice notice-warning"><p><?php _e('No hay curaciones de contenidos pendientes de terminar.', 'aicc'); ?></p></div>

	<?php else: ?>

	<table class="widefat">
		<thead>
			 <tr>
				<th><?php _e('Title', 'aicc'); ?></th>
				<th style="text-align:center;"><?php _e('Date', 'aicc'); ?></th>			
			</tr>
		</thead>
		<tbody>
			<?php foreach ($resultados as $resultado) : ?>
			<?php 
				$post_id = $resultado->post_id; 
				$dateObject = new DateTime($resultado->date);
				$date = $dateObject->format('d/m/Y');
				$title = get_the_title($post_id); 
        		$edit_url = get_edit_post_link($post_id);
        		$url = get_permalink($post_id);
			?>

			<tr>
				<?php
				echo "<td width=\"88%\" style=\"text-align:left;\">";
				echo "<a href='{$edit_url}' target='_blank' rel='noopener'><strong>{$title}</strong></a>";
				echo '<div class="row-actions">';
				echo "<span class='edit'><a href='{$edit_url}' target='_blank' rel='noopener'>Editar</a> | </span>";
				echo "<span class='view'><a href='{$url}' target='_blank' rel='noopener'>Vista previa</a>";
				echo "</div>";
				echo "</td>";
				?>
				<td width="12%" style="text-align:center;" title="<?php echo $resultado->date; ?>"><?php echo $date; ?></td>
			</tr>
			<?php endforeach; ?>
			
		</tbody>
	
	</table>
			
	<?php
				
 		$pagination_args = array(
            'base' => add_query_arg('paged', '%#%'),
             'format' => '?paged=%#%',
             'total' => ceil($total_items / $items_per_page),
             'current' => $current_page,
             'prev_text' => __('«'),
             'next_text' => __('»'),
		);

		echo '<div class="tablenav"><div class="tablenav-pages">' . paginate_links($pagination_args) . '</div></div>';
				
	?>
			

	<?php endif; ?>