<style>
    #add_new_prompt { margin-top: 20px; }
	textarea {
		width: 300px;
		padding: 8px !important;
		border-radius: 4px !important;
		border: 1px solid #8c8f94 !important;
	}
	.aicc-tooltip-a { cursor:pointer; }

	.aicc-options h2 {
	    display: flex;
	    align-items: center;
	}

	.aicc-options h2 span {
	    background: #202225;
	    color: #fff;
	    margin-left: 6px;
	}

	.promptRow p,
	.promptRow li {
		font-size: 13px;
		color: #767676;
	}

	.promptRow ul {
		margin-top: 12px;
		margin-left: 16px;
		list-style: square;
	}

	.promptRow code {
		cursor: pointer;
	}
	.promptRow code:hover {
		background: rgba(0,0,0,.1) !important;
	}

</style>

<form method="post">

    <?php wp_nonce_field('devlog_nonce_action', 'devlog_nonce_field'); ?>

    <table class="form-table" id="aicc-fieldset-one">
		<h2><?php _e('Prompts', 'aicc'); ?> <span class="aicc-tooltip">?<span class="tooltiptext">En esta sección podrás crear uno o varios prompts personalizados para tus curaciones. Utiliza las variables: {keyword} para la palabra clave, {post_title} para el título del post y {language} para el idioma elegido.</span></span></h2>
        <?php

        if ((isset($_POST['devlog_nonce_field']) && wp_verify_nonce($_POST['devlog_nonce_field'], 'devlog_nonce_action')) ) {
			
			$entries_skipped = 0;
		    
		    $prompts_data = [];
    
		    $i = 1; 

    		while (isset($_POST['prompt_name_' . $i]) || isset($_POST['prompt_text_' . $i])) {
		        
		        $name = sanitize_text_field($_POST['prompt_name_' . $i]);
		       
		        $allowed_html = array(
				    'p' => array(),
				    'strong' => array(),
				    'ul' => array(),
				    'li' => array(),
				    'h2' => array(),
				    'h3' => array(),
				    'h4' => array(),
				    'blockquote' => array(),
				    'pre' => array(),
				    'a' => array(
				        'href' => array(),
				        'title' => array(),
				        'target' => array()
				    ),
				    'br' => array(),
				    'em' => array(),
				    'i' => array(),
				    'u' => array(),
				    'code' => array(),
				    'ol' => array(),
				    'span' => array(
				        'class' => array(),
				        'style' => array()
				    ),
				    'div' => array(
				        'class' => array(),
				        'style' => array()
				    )
				);

				$text = wp_kses(stripslashes($_POST['prompt_text_' . $i]), $allowed_html);

		        if (empty($name) || empty($text)) {
					$entries_skipped++;
				} else {
					$prompts_data[] = [
						'name' => $name,
						'text' => $text
					];
				}

		        $i++; 
		    }

			if (empty($prompts_data)) {
			    delete_option('aicc_prompts_data');
			} else {
			    update_option('aicc_prompts_data', $prompts_data);
			}
			
			if ($entries_skipped > 0) {
				echo '<div class="notice notice-warning is-dismissible"><p><strong>'.sprintf(_n("%d instrucción fue descartada porque estaba incompleta", "%d instrucciones fueron descartadas porque estaban incompletas", $entries_skipped, "aicc"), $entries_skipped).'.</strong></p></div>';
			}

			echo '<div class="notice notice-success is-dismissible"><p><strong>'.__("Saved Settings", "aicc").'.</strong></p></div>';
			
		
        }

        $saved_prompts = get_option('aicc_prompts_data', []);

        ?>
        <tbody id="promptsContainer">

          <?php foreach ($saved_prompts as $index => $prompt): ?>
		    <tr class="promptRow">
		        <th>
		            <label for="prompt_name_<?php echo $index + 1; ?>"><?php _e('Prompt Name', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Prompt identification name. Use this name when you are curating content and need to select the appropriate prompt.', 'aicc'); ?></span></span></label>
		        </th>
		        <td>
		            <input type="text" name="prompt_name_<?php echo $index + 1; ?>" id="prompt_name_<?php echo $index + 1; ?>" value="<?php echo esc_attr($prompt['name']); ?>" placeholder="<?php _e('Enter Prompt Name', 'aicc'); ?>">
		        </td>
		    </tr>
		    <tr class="promptRow">
		        <th>
		            <label for="prompt_text_<?php echo $index + 1; ?>"><?php _e('Prompt Text', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Create a custom prompt for your healings. Use the variables: {keyword} for the selected keyword, {post_title} for the post title and {language} for the chosen language.', 'aicc'); ?></span></label>
		        </th>
		        <td>
		            <textarea rows="6" name="prompt_text_<?php echo $index + 1; ?>" id="prompt_text_<?php echo $index + 1; ?>" placeholder="<?php _e('Necesito tres párrafos sobre {keyword} redactados en idioma {language}. Cada párrafo debe estar envuelto en etiquetas de párrafo de HTML (<p></p>)."', 'aicc'); ?>"><?php echo htmlspecialchars($prompt['text']); ?></textarea>
		            <p>Las variables disponibles son:</p>
				   	<ul>
						 <li><span class="copy-to-clipboard" data-variable="{keyword}"><code>{keyword}</code></span> incluye las keywords de Search Console para cada contenido</li>
						 <li><span class="copy-to-clipboard" data-variable="{post_title}"><code>{post_title}</code></span> es el título del artículo</li>
						 <li><span class="copy-to-clipboard" data-variable="{post_content}"><code>{post_content}</code></span> es el contenido actual del artículo</li>
					</ul>
		        </td>
		    </tr>
		<?php endforeach; ?>

		<?php if(empty($saved_prompts)): ?>
	    <tr class="promptRow">
	        <th>
	            <label for="prompt_name_1"><?php _e('Prompt Name', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Prompt identification name. Use this name when you are curating content and need to select the appropriate prompt.', 'aicc'); ?></span></span></label>
	        </th>
	        <td>
	            <input type="text" name="prompt_name_1" id="prompt_name_1" placeholder="<?php _e('Enter Prompt Name', 'aicc'); ?>">
	        </td>
	    </tr>
	    <tr class="promptRow">
	        <th>
	            <label for="prompt_text_1"><?php _e('Prompt Text', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Create a custom prompt for your healings. Use the variables: {keyword} for the selected keyword, {post_title} for the post title and {language} for the chosen language.', 'aicc'); ?></span></span></label>
	        </th>
	        <td>
	            <textarea rows="6" name="prompt_text_1" id="prompt_text_1" placeholder="<?php _e('Necesito tres párrafos sobre {keyword} redactados en idioma {language}. Cada párrafo debe estar envuelto en etiquetas de párrafo de HTML (<p></p>).', 'aicc'); ?>"></textarea>
	        	<p>Las variables disponibles son:</p>
			   	<ul>
					 <li><span class="copy-to-clipboard" data-variable="{keyword}"><code>{keyword}</code></span> incluye las keywords de Search Console para cada contenido.</li>
					 <li><span class="copy-to-clipboard" data-variable="{post_title}"><code>{post_title}</code></span> es el título del artículo.</li>
					 <li><span class="copy-to-clipboard" data-variable="{post_content}"><code>{post_content}</code></span> es el contenido actual del artículo.</li>
				</ul>
	        </td>
	    </tr>
	<?php endif; ?>

        <tfoot>
            <tr>
                <th style="display:flex;">
                    <input type="hidden" name="aicc_from" id="aicc_from" value="general-settings" />
                    <button type="button" id="add_new_prompt" class="button-secondary" style="margin-right:10px;"><?php _e('Add New', 'aicc'); ?></button>      
	                    <?php submit_button(); ?>				
                </th>
            </tr>
        </tfoot>

    </table>

</form>

<script>
   jQuery(function($) {

   	 $('.copy-to-clipboard').click(function() {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(this).attr('data-variable')).select();
        document.execCommand("copy");
        $temp.remove();

        // Usando SweetAlert para la notificación
        Swal.fire({
            text: 'Variable copiada: ' + $(this).attr('data-variable'),
            icon: 'success',
            confirmButtonText: 'Cerrar'
        });
    });

    let rowCount = $('#promptsContainer .promptRow').length / 2; // Cada prompt tiene 2 filas
    const MAX_PROMPTS = 20;

    $('#add_new_prompt').on('click', function() {

    	if(rowCount < MAX_PROMPTS) {

        rowCount++;
        let newRowName = `
            <tr class="promptRow">
                <th>
                    <label for="prompt_name_${rowCount}"><?php _e('Prompt Name', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Prompt identification name. Use this name when you are curating content and need to select the appropriate prompt.', 'aicc'); ?></span></span></label>
                </th>
                <td>
                    <input type="text" name="prompt_name_${rowCount}" id="prompt_name_${rowCount}" placeholder="<?php _e('Enter Prompt Name', 'aicc'); ?>">
                </td>
            </tr>`;
        let newRowText = `
            <tr class="promptRow">
                <th>
                    <label for="prompt_text_${rowCount}"><?php _e('Prompt Text', 'aicc'); ?><span class="aicc-tooltip">?<span class="tooltiptext"><?php _e('Create a custom prompt for your healings. Use the variables: {keyword} for the selected keyword, {post_title} for the post title and {language} for the chosen language.', 'aicc'); ?></span></label>                
                </th>
                <td>
                    <textarea rows="6" name="prompt_text_${rowCount}" id="prompt_text_${rowCount}" placeholder="<?php _e('Necesito tres párrafos sobre {keyword} redactados en idioma {language}. Cada párrafo debe estar envuelto en etiquetas de párrafo de HTML (<p></p>).', 'aicc'); ?>"></textarea>
                </td>
            </tr>`;
        $('#promptsContainer').append(newRowName).append(newRowText);

        } else {
        	alert("Se ha alcanzado el número máximo de prompts permitidos."); 
        }

    });
});

</script>
