<?php

namespace Keywordrush\AffiliateEgg;

/*
  Plugin Name: Affiliate Egg Pro
  Plugin URI: http://www.keywordrush.com/en/affiliateegg
  Description: Parse, add, update products from affiliate shops. Let you to earn money from affiliate networks.
  Version: 10.11.0
  Author: keywordrush.com
  Author URI: http://www.keywordrush.com
  Text Domain: affegg
 */

/*
 * Copyright (c)  www.keywordrush.com  (email: support@keywordrush.com)
 */

defined('\ABSPATH') || die('No direct script access allowed!');

define(__NAMESPACE__ . '\NS', __NAMESPACE__ . '\\');
define(NS . 'PLUGIN_PATH', plugin_dir_path(__FILE__));
define(NS . 'PLUGIN_FILE', __FILE__);
define(NS . 'PLUGIN_RES', plugins_url('res', __FILE__));

require_once PLUGIN_PATH . 'application/MapAutoLoader.php';
require_once PLUGIN_PATH . 'application/AffiliateEgg.php';
require_once PLUGIN_PATH . 'application/Widget.php';
new MapAutoLoader;

\add_action('plugins_loaded', array('\Keywordrush\AffiliateEgg\Plugin', 'registerComponents'));
\add_action('init', array('\Keywordrush\AffiliateEgg\Plugin', 'getInstance'));

if (\is_admin())
{
  require_once PLUGIN_PATH . 'application/admin/AffiliateEggAdmin.php';

  \register_activation_hook(__FILE__, array(\Keywordrush\AffiliateEgg\Installer::getInstance(), 'activate'));
  \register_deactivation_hook(__FILE__, array(\Keywordrush\AffiliateEgg\Installer::getInstance(), 'deactivate'));
  \register_uninstall_hook(__FILE__, array('\Keywordrush\AffiliateEgg\Installer', 'uninstall'));
  \add_action('init', array(NS . 'AffiliateEggAdmin', 'getInstance'));
}
