<?php

namespace Keywordrush\AffiliateEgg;

defined('\ABSPATH') || exit;

/**
 * AffiliateEggAdmin class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class AffiliateEggAdmin
{

    protected static $instance = null;

    public static function getInstance()
    {

        if (self::$instance == null)
            self::$instance = new self;

        return self::$instance;
    }

    private function __construct()
    {
        if (!\is_admin())
            die('You are not authorized to perform the requested action.');

        \add_action('admin_notices', array($this, 'activate_notice'));
        \add_action('admin_menu', array($this, 'add_admin_menu'));
        \add_action('admin_enqueue_scripts', array($this, 'admin_load_scripts'));
        \add_filter('parent_file', array($this, 'highlight_admin_menu'));

        if (isset($GLOBALS['pagenow']) && $GLOBALS['pagenow'] == 'plugins.php')
        {
            \add_filter('plugin_row_meta', array($this, 'add_plugin_row_meta'), 10, 2);
        }

        AdminNotice::getInstance()->adminInit();

        if (AffiliateEgg::isFree() || (AffiliateEgg::isPro() && AffiliateEgg::isActivated()) || AffiliateEgg::isEnvato())
        {
            new EggController;
            new AutoblogController;
            DeeplinkConfig::getInstance()->adminInit();
            ProxyConfig::getInstance()->adminInit();
            ExtractorConfig::getInstance()->adminInit();
            CookiesConfig::getInstance()->adminInit();
            GeneralConfig::getInstance()->adminInit();
            new EggThickboxEditorButton;
            LManager::getInstance()->adminInit();
        }
        if (AffiliateEgg::isEnvato() && !AffiliateEgg::isActivated() && !\get_option(AffiliateEgg::slug . '_env_install'))
            EnvatoConfig::getInstance()->adminInit();
        elseif (AffiliateEgg::isPro())
            LicConfig::getInstance()->adminInit();

        if (AffiliateEgg::isPro() && AffiliateEgg::isActivated())
        {
            new Autoupdate(AffiliateEgg::version(), \plugin_basename(PLUGIN_FILE), AffiliateEgg::getApiBase(), AffiliateEgg::slug);
        }
    }

    public function admin_load_scripts()
    {
        if ($GLOBALS['pagenow'] != 'admin.php')
            return;

        if (!empty($_GET['page']))
        {
            $page_pats = explode('-', $_GET['page']);

            if ($page_pats[0] != 'affiliate' && $page_pats[0] != 'affegg')
                return;
        }

        \wp_enqueue_script('affegg_common', PLUGIN_RES . '/js/common.js', array('jquery'));
        \wp_localize_script('affegg_common', 'affeggL10n', array(
            'are_you_shure' => __('Are you sure?', 'affegg'),
            'use_shortcode' => __('Use shortcode:', 'affegg'),
        ));

        \wp_enqueue_style('affegg-admin', PLUGIN_RES . '/css/admin.css', null, '' . Plugin::version());
    }

    public function add_plugin_row_meta(array $links, $file)
    {
        if ($file == plugin_basename(PLUGIN_FILE) && LicConfig::getInstance()->option('license_key'))
        {
            return array_merge(
                $links,
                array(
                    '<a href="' . get_bloginfo('wpurl') . '/wp-admin/admin.php?page=affiliate-egg-settings">' . __('Settings', 'affegg') . '</a>',
                    '<a href="' . get_bloginfo('wpurl') . '/wp-admin/admin.php?page=affiliate-egg-deeplink-settings">' . __('Deeplink settings', 'affegg') . '</a>',
                )
            );
        }
        return $links;
    }

    public function add_admin_menu()
    {
        $icon_svg = 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTE1IiBoZWlnaHQ9IjEzNCIgdmVyc2lvbj0iMS4xIiB2aWV3Qm94PSIwIDAgMTE1IDEzNCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczpjYz0iaHR0cDovL2NyZWF0aXZlY29tbW9ucy5vcmcvbnMjIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+CiA8bWV0YWRhdGE+CiAgPHJkZjpSREY+CiAgIDxjYzpXb3JrIHJkZjphYm91dD0iIj4KICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgPGRjOnR5cGUgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIvPgogICAgPGRjOnRpdGxlLz4KICAgPC9jYzpXb3JrPgogIDwvcmRmOlJERj4KIDwvbWV0YWRhdGE+CiA8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtMTcuODgyIC0zMS42NDIpIj4KICA8cGF0aCBkPSJtMTE4LjgzIDE1OC4wM2gtODUuMzU5Yy03Ljc0MjItMC40NjQzOS00LjI3MTItNS44MTAxLTMuMDQ0NS05LjUxOTJsNDAuNDU4LTk1LjEzMWMwLjIxMjMtMC41ODU1MyAwLjU1OTg1LTEuNTI0MSAwLjk3NjQ5LTIuNTc4OGwtMC4wMDg2LTAuMDAxM2MwLjcwMS0xLjk1MDkgMi4yMzUzLTUuMTE0MyAyLjIzNTMtNS4xMTQzbDAuMDA3NS02LjQ0ZS00YzAuMTU2ODMtMC4yOTU3MiAwLjM1MzkxLTAuNjA5ODUgMC41ODYyMS0wLjg4NDQ0IDAuMTI4NjUtMC4xNDAyNCAwLjI3NzU0LTAuMjg0MzUgMC4zNzg5MS0wLjM3OTYgMC4wMDMyLTAuMDAxOSAwLjAwNTgtMC4wMDM5IDAuMDA5MS0wLjAwNTggMC4zNzM0Ni0wLjI5ODIyIDAuODE0NjYtMC40NTM5MyAxLjMxNjUtMC4zMDUyNyAwLjAxNTQ2IDAuMDAzOSAwLjA2ODQyIDAuMDA5OCAwLjA4NDMzIDAuMDE0NzUgMC4wMDEzIDYuNDRlLTQgMC4wMDU4IDAuMDAxMyAwLjAwODQgMC4wMDE5IDAuMDczMTkgMC4wMjIyOSAwLjEyOTU3IDAuMDQyNzIgMC4xNjQzNCAwLjA1NjM4IDEuODE1OSAwLjkwNDY3IDQuNDEyOSA3Ljg2OTIgNC44MjA5IDkuMDM2IDAuODMyODMgMS44ODUyIDEuNTE0NSAzLjYxMzQgMS45MjYyIDQuNjUzNmwxNC43NiAzNC42OTRoLTMzLjg1NXY4LjYzNzVoNDYuNDgybC0zLjY3NzUtOC42Mzc1LTIyLjQ2LTUyLjc1Yy0wLjUyMDMtMS4wODktMS4yMTk3LTIuNDgxOS0xLjg2LTMuNTI1LTYuMDE3OC04Ljc4NzMtMTEuMzM2LTIuOTg3Mi0xMy40MzcgMC4wOTI5NjMtMC41MTgyNSAwLjkwMDU4LTEuMDE4MSAxLjg4NzMtMS40MTA5IDIuNjk5OWwtNDkuMTU4IDExNS40NWMtMS40NTEzIDQuMzg3NC0yLjI2MSAxMS4zMTYgNi44OTYyIDExLjY3NWgxMDcuNXYtOC4xODI5eiIgZmlsbD0iI2ZmM2U3ZCIvPgogPC9nPgo8L3N2Zz4K';
        \add_menu_page(__('Storefronts', 'affegg') . ' &lsaquo; Affiliate Egg', 'Affiliate Egg Pro', 'publish_posts', AffiliateEgg::slug, null, $icon_svg);
    }

    public static function render($view_name, $_data = null)
    {
        if (is_array($_data))
            extract($_data, EXTR_PREFIX_SAME, 'data');
        else
            $data = $_data;

        include PLUGIN_PATH . 'application/admin/views/' . TextHelper::clear($view_name) . '.php';
    }

    /**
     * Highlight menu for hidden submenu item
     */
    public function highlight_admin_menu($file)
    {
        global $plugin_page;

        // options.php - hidden submenu items
        if ($file != 'options.php' || substr($plugin_page, 0, strlen(AffiliateEgg::slug())) !== AffiliateEgg::slug())
            return $file;

        if (preg_match('/affiliate-egg-(\w+?)-settings/', $plugin_page))
            $plugin_page = 'affiliate-egg-settings';

        return $file;
    }

    public function activate_notice()
    {
        if (!AffiliateEgg::isEnvato())
            return;
        if (AffiliateEgg::isActivated() || !AffiliateEggAdmin::isPluginPage())
            return;

        $link = 'admin.php?page=';
        if (AffiliateEgg::isEnvato())
            $link .= 'affiliate-egg-lic';
        else
            $link .= 'affiliate-egg';
        $uri = \get_admin_url(\get_current_blog_id(), $link);

        echo '<div class="notice notice-error"><p>';
        echo sprintf(__('<a href="%s">Please activate</a> your copy of the Affiliate Egg to receive automatic updates and get direct support.', 'affegg'), $uri);
        echo '</p></div>';
    }

    public static function isPluginPage()
    {
        if ($GLOBALS['pagenow'] != 'admin.php' || empty($_GET['page']))
            return false;

        $page_pats = explode('-', $_GET['page']);
        if (count($page_pats) < 2 || $page_pats[0] . '-' . $page_pats[1] != AffiliateEgg::slug())
            return false;

        return true;
    }
}
